/*	$NetBSD$	*/

/*-
 * Copyright (c) 2019 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Kamil Rytarowski.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * THIS FILE HAS BEEN GENERATED
 * ! ! DO NOT EDIT MANUALLY ! !
 *
 * Created from: NetBSD: syscall.h,v 1.308 2019/09/22 23:03:21 christos Exp 
 */

#include <stddef.h>

static const size_t max_syscall_number = 486;

static const struct {
	ssize_t nargs;
	const char *name;
	const char *rettype;
} syscall_info[] = {
	/* 0 */  { 8, "syscall", "int" },
	/* 1 */  { 1, "exit", "void" },
	/* 2 */  { 0, "fork", "int" },
	/* 3 */  { 3, "read", "ssize_t" },
	/* 4 */  { 3, "write", "ssize_t" },
	/* 5 */  { 3, "open", "int" },
	/* 6 */  { 1, "close", "int" },
	/* 7 */  { 4, "compat_50_wait4", "int" },
	/* 8 */  { 2, "compat_43_ocreat", "int" },
	/* 9 */  { 2, "link", "int" },
	/* 10 */  { 1, "unlink", "int" },
	/* 11 */  { -1, NULL, NULL },
	/* 12 */  { 1, "chdir", "int" },
	/* 13 */  { 1, "fchdir", "int" },
	/* 14 */  { 3, "compat_50_mknod", "int" },
	/* 15 */  { 2, "chmod", "int" },
	/* 16 */  { 3, "chown", "int" },
	/* 17 */  { 1, "break", "int" },
	/* 18 */  { 3, "compat_20_getfsstat", "int" },
	/* 19 */  { 3, "compat_43_olseek", "long" },
	/* 20 */  { 0, "getpid", "pid_t" },
	/* 21 */  { 4, "compat_40_mount", "int" },
	/* 22 */  { 2, "unmount", "int" },
	/* 23 */  { 1, "setuid", "int" },
	/* 24 */  { 0, "getuid", "uid_t" },
	/* 25 */  { 0, "geteuid", "uid_t" },
	/* 26 */  { 4, "ptrace", "int" },
	/* 27 */  { 3, "recvmsg", "ssize_t" },
	/* 28 */  { 3, "sendmsg", "ssize_t" },
	/* 29 */  { 6, "recvfrom", "ssize_t" },
	/* 30 */  { 3, "accept", "int" },
	/* 31 */  { 3, "getpeername", "int" },
	/* 32 */  { 3, "getsockname", "int" },
	/* 33 */  { 2, "access", "int" },
	/* 34 */  { 2, "chflags", "int" },
	/* 35 */  { 2, "fchflags", "int" },
	/* 36 */  { 0, "sync", "void" },
	/* 37 */  { 2, "kill", "int" },
	/* 38 */  { 2, "compat_43_stat43", "int" },
	/* 39 */  { 0, "getppid", "pid_t" },
	/* 40 */  { 2, "compat_43_lstat43", "int" },
	/* 41 */  { 1, "dup", "int" },
	/* 42 */  { 0, "pipe", "int" },
	/* 43 */  { 0, "getegid", "gid_t" },
	/* 44 */  { 4, "profil", "int" },
	/* 45 */  { 4, "ktrace", "int" },
	/* 46 */  { 3, "compat_13_sigaction13", "int" },
	/* 47 */  { 0, "getgid", "gid_t" },
	/* 48 */  { 2, "compat_13_sigprocmask13", "int" },
	/* 49 */  { 2, "__getlogin", "int" },
	/* 50 */  { 1, "__setlogin", "int" },
	/* 51 */  { 1, "acct", "int" },
	/* 52 */  { 0, "compat_13_sigpending13", "int" },
	/* 53 */  { 2, "compat_13_sigaltstack13", "int" },
	/* 54 */  { 3, "ioctl", "int" },
	/* 55 */  { 1, "compat_12_oreboot", "int" },
	/* 56 */  { 1, "revoke", "int" },
	/* 57 */  { 2, "symlink", "int" },
	/* 58 */  { 3, "readlink", "ssize_t" },
	/* 59 */  { 3, "execve", "int" },
	/* 60 */  { 1, "umask", "mode_t" },
	/* 61 */  { 1, "chroot", "int" },
	/* 62 */  { 2, "compat_43_fstat43", "int" },
	/* 63 */  { 4, "compat_43_ogetkerninfo", "int" },
	/* 64 */  { 0, "compat_43_ogetpagesize", "int" },
	/* 65 */  { 2, "compat_12_msync", "int" },
	/* 66 */  { 0, "vfork", "int" },
	/* 67 */  { -1, NULL, NULL },
	/* 68 */  { -1, NULL, NULL },
	/* 69 */  { -1, NULL, NULL },
	/* 70 */  { -1, NULL, NULL },
	/* 71 */  { 6, "compat_43_ommap", "int" },
	/* 72 */  { 1, "vadvise", "int" },
	/* 73 */  { 2, "munmap", "int" },
	/* 74 */  { 3, "mprotect", "int" },
	/* 75 */  { 3, "madvise", "int" },
	/* 76 */  { -1, NULL, NULL },
	/* 77 */  { -1, NULL, NULL },
	/* 78 */  { 3, "mincore", "int" },
	/* 79 */  { 2, "getgroups", "int" },
	/* 80 */  { 2, "setgroups", "int" },
	/* 81 */  { 0, "getpgrp", "int" },
	/* 82 */  { 2, "setpgid", "int" },
	/* 83 */  { 3, "compat_50_setitimer", "int" },
	/* 84 */  { 0, "compat_43_owait", "int" },
	/* 85 */  { 1, "compat_12_oswapon", "int" },
	/* 86 */  { 2, "compat_50_getitimer", "int" },
	/* 87 */  { 2, "compat_43_ogethostname", "int" },
	/* 88 */  { 2, "compat_43_osethostname", "int" },
	/* 89 */  { 0, "compat_43_ogetdtablesize", "int" },
	/* 90 */  { 2, "dup2", "int" },
	/* 91 */  { -1, NULL, NULL },
	/* 92 */  { 3, "fcntl", "int" },
	/* 93 */  { 5, "compat_50_select", "int" },
	/* 94 */  { -1, NULL, NULL },
	/* 95 */  { 1, "fsync", "int" },
	/* 96 */  { 3, "setpriority", "int" },
	/* 97 */  { 3, "compat_30_socket", "int" },
	/* 98 */  { 3, "connect", "int" },
	/* 99 */  { 3, "compat_43_oaccept", "int" },
	/* 100 */  { 2, "getpriority", "int" },
	/* 101 */  { 4, "compat_43_osend", "int" },
	/* 102 */  { 4, "compat_43_orecv", "int" },
	/* 103 */  { 1, "compat_13_sigreturn13", "int" },
	/* 104 */  { 3, "bind", "int" },
	/* 105 */  { 5, "setsockopt", "int" },
	/* 106 */  { 2, "listen", "int" },
	/* 107 */  { -1, NULL, NULL },
	/* 108 */  { 3, "compat_43_osigvec", "int" },
	/* 109 */  { 1, "compat_43_osigblock", "int" },
	/* 110 */  { 1, "compat_43_osigsetmask", "int" },
	/* 111 */  { 1, "compat_13_sigsuspend13", "int" },
	/* 112 */  { 2, "compat_43_osigstack", "int" },
	/* 113 */  { 3, "compat_43_orecvmsg", "int" },
	/* 114 */  { 3, "compat_43_osendmsg", "int" },
	/* 115 */  { -1, NULL, NULL },
	/* 116 */  { 2, "compat_50_gettimeofday", "int" },
	/* 117 */  { 2, "compat_50_getrusage", "int" },
	/* 118 */  { 5, "getsockopt", "int" },
	/* 119 */  { -1, NULL, NULL },
	/* 120 */  { 3, "readv", "ssize_t" },
	/* 121 */  { 3, "writev", "ssize_t" },
	/* 122 */  { 2, "compat_50_settimeofday", "int" },
	/* 123 */  { 3, "fchown", "int" },
	/* 124 */  { 2, "fchmod", "int" },
	/* 125 */  { 6, "compat_43_orecvfrom", "int" },
	/* 126 */  { 2, "setreuid", "int" },
	/* 127 */  { 2, "setregid", "int" },
	/* 128 */  { 2, "rename", "int" },
	/* 129 */  { 2, "compat_43_otruncate", "int" },
	/* 130 */  { 2, "compat_43_oftruncate", "int" },
	/* 131 */  { 2, "flock", "int" },
	/* 132 */  { 2, "mkfifo", "int" },
	/* 133 */  { 6, "sendto", "ssize_t" },
	/* 134 */  { 2, "shutdown", "int" },
	/* 135 */  { 4, "socketpair", "int" },
	/* 136 */  { 2, "mkdir", "int" },
	/* 137 */  { 1, "rmdir", "int" },
	/* 138 */  { 2, "compat_50_utimes", "int" },
	/* 139 */  { -1, NULL, NULL },
	/* 140 */  { 2, "compat_50_adjtime", "int" },
	/* 141 */  { 3, "compat_43_ogetpeername", "int" },
	/* 142 */  { 0, "compat_43_ogethostid", "int32_t" },
	/* 143 */  { 1, "compat_43_osethostid", "int" },
	/* 144 */  { 2, "compat_43_ogetrlimit", "int" },
	/* 145 */  { 2, "compat_43_osetrlimit", "int" },
	/* 146 */  { 2, "compat_43_okillpg", "int" },
	/* 147 */  { 0, "setsid", "int" },
	/* 148 */  { 4, "compat_50_quotactl", "int" },
	/* 149 */  { 0, "compat_43_oquota", "int" },
	/* 150 */  { 3, "compat_43_ogetsockname", "int" },
	/* 151 */  { -1, NULL, NULL },
	/* 152 */  { -1, NULL, NULL },
	/* 153 */  { -1, NULL, NULL },
	/* 154 */  { -1, NULL, NULL },
	/* 155 */  { 2, "nfssvc", "int" },
	/* 156 */  { 4, "compat_43_ogetdirentries", "int" },
	/* 157 */  { 2, "compat_20_statfs", "int" },
	/* 158 */  { 2, "compat_20_fstatfs", "int" },
	/* 159 */  { -1, NULL, NULL },
	/* 160 */  { -1, NULL, NULL },
	/* 161 */  { 2, "compat_30_getfh", "int" },
	/* 162 */  { 2, "compat_09_ogetdomainname", "int" },
	/* 163 */  { 2, "compat_09_osetdomainname", "int" },
	/* 164 */  { 1, "compat_09_ouname", "int" },
	/* 165 */  { 2, "sysarch", "int" },
	/* 166 */  { -1, NULL, NULL },
	/* 167 */  { -1, NULL, NULL },
	/* 168 */  { -1, NULL, NULL },
	/* 169 */  { 5, "compat_10_osemsys", "int" },
	/* 170 */  { 6, "compat_10_omsgsys", "int" },
	/* 171 */  { 4, "compat_10_oshmsys", "int" },
	/* 172 */  { -1, NULL, NULL },
	/* 173 */  { 5, "pread", "ssize_t" },
	/* 174 */  { 5, "pwrite", "ssize_t" },
	/* 175 */  { 1, "compat_30_ntp_gettime", "int" },
	/* 176 */  { 1, "ntp_adjtime", "int" },
	/* 177 */  { -1, NULL, NULL },
	/* 178 */  { -1, NULL, NULL },
	/* 179 */  { -1, NULL, NULL },
	/* 180 */  { -1, NULL, NULL },
	/* 181 */  { 1, "setgid", "int" },
	/* 182 */  { 1, "setegid", "int" },
	/* 183 */  { 1, "seteuid", "int" },
	/* 184 */  { 3, "lfs_bmapv", "int" },
	/* 185 */  { 3, "lfs_markv", "int" },
	/* 186 */  { 2, "lfs_segclean", "int" },
	/* 187 */  { 2, "compat_50_lfs_segwait", "int" },
	/* 188 */  { 2, "compat_12_stat12", "int" },
	/* 189 */  { 2, "compat_12_fstat12", "int" },
	/* 190 */  { 2, "compat_12_lstat12", "int" },
	/* 191 */  { 2, "pathconf", "long" },
	/* 192 */  { 2, "fpathconf", "long" },
	/* 193 */  { 5, "getsockopt2", "int" },
	/* 194 */  { 2, "getrlimit", "int" },
	/* 195 */  { 2, "setrlimit", "int" },
	/* 196 */  { 4, "compat_12_getdirentries", "int" },
	/* 197 */  { 7, "mmap", "void *" },
	/* 198 */  { 8, "__syscall", "quad_t" },
	/* 199 */  { 4, "lseek", "off_t" },
	/* 200 */  { 3, "truncate", "int" },
	/* 201 */  { 3, "ftruncate", "int" },
	/* 202 */  { 6, "__sysctl", "int" },
	/* 203 */  { 2, "mlock", "int" },
	/* 204 */  { 2, "munlock", "int" },
	/* 205 */  { 1, "undelete", "int" },
	/* 206 */  { 2, "compat_50_futimes", "int" },
	/* 207 */  { 1, "getpgid", "pid_t" },
	/* 208 */  { 2, "reboot", "int" },
	/* 209 */  { 3, "poll", "int" },
	/* 210 */  { 7, "afssys", "int" },
	/* 211 */  { -1, NULL, NULL },
	/* 212 */  { -1, NULL, NULL },
	/* 213 */  { -1, NULL, NULL },
	/* 214 */  { -1, NULL, NULL },
	/* 215 */  { -1, NULL, NULL },
	/* 216 */  { -1, NULL, NULL },
	/* 217 */  { -1, NULL, NULL },
	/* 218 */  { -1, NULL, NULL },
	/* 219 */  { -1, NULL, NULL },
	/* 220 */  { 4, "compat_14___semctl", "int" },
	/* 221 */  { 3, "semget", "int" },
	/* 222 */  { 3, "semop", "int" },
	/* 223 */  { 1, "semconfig", "int" },
	/* 224 */  { 3, "compat_14_msgctl", "int" },
	/* 225 */  { 2, "msgget", "int" },
	/* 226 */  { 4, "msgsnd", "int" },
	/* 227 */  { 5, "msgrcv", "ssize_t" },
	/* 228 */  { 3, "shmat", "void *" },
	/* 229 */  { 3, "compat_14_shmctl", "int" },
	/* 230 */  { 1, "shmdt", "int" },
	/* 231 */  { 3, "shmget", "int" },
	/* 232 */  { 2, "compat_50_clock_gettime", "int" },
	/* 233 */  { 2, "compat_50_clock_settime", "int" },
	/* 234 */  { 2, "compat_50_clock_getres", "int" },
	/* 235 */  { 3, "timer_create", "int" },
	/* 236 */  { 1, "timer_delete", "int" },
	/* 237 */  { 4, "compat_50_timer_settime", "int" },
	/* 238 */  { 2, "compat_50_timer_gettime", "int" },
	/* 239 */  { 1, "timer_getoverrun", "int" },
	/* 240 */  { 2, "compat_50_nanosleep", "int" },
	/* 241 */  { 1, "fdatasync", "int" },
	/* 242 */  { 1, "mlockall", "int" },
	/* 243 */  { 0, "munlockall", "int" },
	/* 244 */  { 3, "compat_50___sigtimedwait", "int" },
	/* 245 */  { 2, "sigqueueinfo", "int" },
	/* 246 */  { 2, "modctl", "int" },
	/* 247 */  { 2, "_ksem_init", "int" },
	/* 248 */  { 5, "_ksem_open", "int" },
	/* 249 */  { 1, "_ksem_unlink", "int" },
	/* 250 */  { 1, "_ksem_close", "int" },
	/* 251 */  { 1, "_ksem_post", "int" },
	/* 252 */  { 1, "_ksem_wait", "int" },
	/* 253 */  { 1, "_ksem_trywait", "int" },
	/* 254 */  { 2, "_ksem_getvalue", "int" },
	/* 255 */  { 1, "_ksem_destroy", "int" },
	/* 256 */  { 2, "_ksem_timedwait", "int" },
	/* 257 */  { 4, "mq_open", "mqd_t" },
	/* 258 */  { 1, "mq_close", "int" },
	/* 259 */  { 1, "mq_unlink", "int" },
	/* 260 */  { 2, "mq_getattr", "int" },
	/* 261 */  { 3, "mq_setattr", "int" },
	/* 262 */  { 2, "mq_notify", "int" },
	/* 263 */  { 4, "mq_send", "int" },
	/* 264 */  { 4, "mq_receive", "ssize_t" },
	/* 265 */  { 5, "compat_50_mq_timedsend", "int" },
	/* 266 */  { 5, "compat_50_mq_timedreceive", "ssize_t" },
	/* 267 */  { -1, NULL, NULL },
	/* 268 */  { -1, NULL, NULL },
	/* 269 */  { -1, NULL, NULL },
	/* 270 */  { 2, "__posix_rename", "int" },
	/* 271 */  { 3, "swapctl", "int" },
	/* 272 */  { 3, "compat_30_getdents", "int" },
	/* 273 */  { 3, "minherit", "int" },
	/* 274 */  { 2, "lchmod", "int" },
	/* 275 */  { 3, "lchown", "int" },
	/* 276 */  { 2, "compat_50_lutimes", "int" },
	/* 277 */  { 3, "__msync13", "int" },
	/* 278 */  { 2, "compat_30___stat13", "int" },
	/* 279 */  { 2, "compat_30___fstat13", "int" },
	/* 280 */  { 2, "compat_30___lstat13", "int" },
	/* 281 */  { 2, "__sigaltstack14", "int" },
	/* 282 */  { 0, "__vfork14", "int" },
	/* 283 */  { 3, "__posix_chown", "int" },
	/* 284 */  { 3, "__posix_fchown", "int" },
	/* 285 */  { 3, "__posix_lchown", "int" },
	/* 286 */  { 1, "getsid", "pid_t" },
	/* 287 */  { 2, "__clone", "pid_t" },
	/* 288 */  { 4, "fktrace", "int" },
	/* 289 */  { 5, "preadv", "ssize_t" },
	/* 290 */  { 5, "pwritev", "ssize_t" },
	/* 291 */  { 3, "compat_16___sigaction14", "int" },
	/* 292 */  { 1, "__sigpending14", "int" },
	/* 293 */  { 3, "__sigprocmask14", "int" },
	/* 294 */  { 1, "__sigsuspend14", "int" },
	/* 295 */  { 1, "compat_16___sigreturn14", "int" },
	/* 296 */  { 2, "__getcwd", "int" },
	/* 297 */  { 1, "fchroot", "int" },
	/* 298 */  { 2, "compat_30_fhopen", "int" },
	/* 299 */  { 2, "compat_30_fhstat", "int" },
	/* 300 */  { 2, "compat_20_fhstatfs", "int" },
	/* 301 */  { 4, "compat_50_____semctl13", "int" },
	/* 302 */  { 3, "compat_50___msgctl13", "int" },
	/* 303 */  { 3, "compat_50___shmctl13", "int" },
	/* 304 */  { 2, "lchflags", "int" },
	/* 305 */  { 0, "issetugid", "int" },
	/* 306 */  { 3, "utrace", "int" },
	/* 307 */  { 1, "getcontext", "int" },
	/* 308 */  { 1, "setcontext", "int" },
	/* 309 */  { 3, "_lwp_create", "int" },
	/* 310 */  { 0, "_lwp_exit", "int" },
	/* 311 */  { 0, "_lwp_self", "lwpid_t" },
	/* 312 */  { 2, "_lwp_wait", "int" },
	/* 313 */  { 1, "_lwp_suspend", "int" },
	/* 314 */  { 1, "_lwp_continue", "int" },
	/* 315 */  { 1, "_lwp_wakeup", "int" },
	/* 316 */  { 0, "_lwp_getprivate", "void *" },
	/* 317 */  { 1, "_lwp_setprivate", "void" },
	/* 318 */  { 2, "_lwp_kill", "int" },
	/* 319 */  { 1, "_lwp_detach", "int" },
	/* 320 */  { 4, "compat_50__lwp_park", "int" },
	/* 321 */  { 2, "_lwp_unpark", "int" },
	/* 322 */  { 3, "_lwp_unpark_all", "ssize_t" },
	/* 323 */  { 2, "_lwp_setname", "int" },
	/* 324 */  { 3, "_lwp_getname", "int" },
	/* 325 */  { 2, "_lwp_ctl", "int" },
	/* 326 */  { -1, NULL, NULL },
	/* 327 */  { -1, NULL, NULL },
	/* 328 */  { -1, NULL, NULL },
	/* 329 */  { -1, NULL, NULL },
	/* 330 */  { 4, "compat_60_sa_register", "int" },
	/* 331 */  { 2, "compat_60_sa_stacks", "int" },
	/* 332 */  { 0, "compat_60_sa_enable", "int" },
	/* 333 */  { 1, "compat_60_sa_setconcurrency", "int" },
	/* 334 */  { 0, "compat_60_sa_yield", "int" },
	/* 335 */  { 1, "compat_60_sa_preempt", "int" },
	/* 336 */  { -1, NULL, NULL },
	/* 337 */  { -1, NULL, NULL },
	/* 338 */  { -1, NULL, NULL },
	/* 339 */  { -1, NULL, NULL },
	/* 340 */  { 5, "__sigaction_sigtramp", "int" },
	/* 341 */  { -1, NULL, NULL },
	/* 342 */  { -1, NULL, NULL },
	/* 343 */  { 3, "rasctl", "int" },
	/* 344 */  { 0, "kqueue", "int" },
	/* 345 */  { 6, "compat_50_kevent", "int" },
	/* 346 */  { 4, "_sched_setparam", "int" },
	/* 347 */  { 4, "_sched_getparam", "int" },
	/* 348 */  { 4, "_sched_setaffinity", "int" },
	/* 349 */  { 4, "_sched_getaffinity", "int" },
	/* 350 */  { 0, "sched_yield", "int" },
	/* 351 */  { 1, "_sched_protect", "int" },
	/* 352 */  { -1, NULL, NULL },
	/* 353 */  { -1, NULL, NULL },
	/* 354 */  { 4, "fsync_range", "int" },
	/* 355 */  { 2, "uuidgen", "int" },
	/* 356 */  { 3, "compat_90_getvfsstat", "int" },
	/* 357 */  { 3, "compat_90_statvfs1", "int" },
	/* 358 */  { 3, "compat_90_fstatvfs1", "int" },
	/* 359 */  { 3, "compat_30_fhstatvfs1", "int" },
	/* 360 */  { 5, "extattrctl", "int" },
	/* 361 */  { 5, "extattr_set_file", "int" },
	/* 362 */  { 5, "extattr_get_file", "ssize_t" },
	/* 363 */  { 3, "extattr_delete_file", "int" },
	/* 364 */  { 5, "extattr_set_fd", "int" },
	/* 365 */  { 5, "extattr_get_fd", "ssize_t" },
	/* 366 */  { 3, "extattr_delete_fd", "int" },
	/* 367 */  { 5, "extattr_set_link", "int" },
	/* 368 */  { 5, "extattr_get_link", "ssize_t" },
	/* 369 */  { 3, "extattr_delete_link", "int" },
	/* 370 */  { 4, "extattr_list_fd", "ssize_t" },
	/* 371 */  { 4, "extattr_list_file", "ssize_t" },
	/* 372 */  { 4, "extattr_list_link", "ssize_t" },
	/* 373 */  { 6, "compat_50_pselect", "int" },
	/* 374 */  { 4, "compat_50_pollts", "int" },
	/* 375 */  { 5, "setxattr", "int" },
	/* 376 */  { 5, "lsetxattr", "int" },
	/* 377 */  { 5, "fsetxattr", "int" },
	/* 378 */  { 4, "getxattr", "int" },
	/* 379 */  { 4, "lgetxattr", "int" },
	/* 380 */  { 4, "fgetxattr", "int" },
	/* 381 */  { 3, "listxattr", "int" },
	/* 382 */  { 3, "llistxattr", "int" },
	/* 383 */  { 3, "flistxattr", "int" },
	/* 384 */  { 2, "removexattr", "int" },
	/* 385 */  { 2, "lremovexattr", "int" },
	/* 386 */  { 2, "fremovexattr", "int" },
	/* 387 */  { 2, "compat_50___stat30", "int" },
	/* 388 */  { 2, "compat_50___fstat30", "int" },
	/* 389 */  { 2, "compat_50___lstat30", "int" },
	/* 390 */  { 3, "__getdents30", "int" },
	/* 391 */  { -1, NULL, NULL },
	/* 392 */  { 2, "compat_30___fhstat30", "int" },
	/* 393 */  { 1, "compat_50___ntp_gettime30", "int" },
	/* 394 */  { 3, "__socket30", "int" },
	/* 395 */  { 3, "__getfh30", "int" },
	/* 396 */  { 3, "__fhopen40", "int" },
	/* 397 */  { 4, "compat_90_fhstatvfs1", "int" },
	/* 398 */  { 3, "compat_50___fhstat40", "int" },
	/* 399 */  { 2, "aio_cancel", "int" },
	/* 400 */  { 1, "aio_error", "int" },
	/* 401 */  { 2, "aio_fsync", "int" },
	/* 402 */  { 1, "aio_read", "int" },
	/* 403 */  { 1, "aio_return", "int" },
	/* 404 */  { 3, "compat_50_aio_suspend", "int" },
	/* 405 */  { 1, "aio_write", "int" },
	/* 406 */  { 4, "lio_listio", "int" },
	/* 407 */  { -1, NULL, NULL },
	/* 408 */  { -1, NULL, NULL },
	/* 409 */  { -1, NULL, NULL },
	/* 410 */  { 5, "__mount50", "int" },
	/* 411 */  { 5, "mremap", "void *" },
	/* 412 */  { 1, "pset_create", "int" },
	/* 413 */  { 1, "pset_destroy", "int" },
	/* 414 */  { 3, "pset_assign", "int" },
	/* 415 */  { 5, "_pset_bind", "int" },
	/* 416 */  { 5, "__posix_fadvise50", "int" },
	/* 417 */  { 5, "__select50", "int" },
	/* 418 */  { 2, "__gettimeofday50", "int" },
	/* 419 */  { 2, "__settimeofday50", "int" },
	/* 420 */  { 2, "__utimes50", "int" },
	/* 421 */  { 2, "__adjtime50", "int" },
	/* 422 */  { 2, "__lfs_segwait50", "int" },
	/* 423 */  { 2, "__futimes50", "int" },
	/* 424 */  { 2, "__lutimes50", "int" },
	/* 425 */  { 3, "__setitimer50", "int" },
	/* 426 */  { 2, "__getitimer50", "int" },
	/* 427 */  { 2, "__clock_gettime50", "int" },
	/* 428 */  { 2, "__clock_settime50", "int" },
	/* 429 */  { 2, "__clock_getres50", "int" },
	/* 430 */  { 2, "__nanosleep50", "int" },
	/* 431 */  { 3, "____sigtimedwait50", "int" },
	/* 432 */  { 5, "__mq_timedsend50", "int" },
	/* 433 */  { 5, "__mq_timedreceive50", "ssize_t" },
	/* 434 */  { 4, "compat_60__lwp_park", "int" },
	/* 435 */  { 6, "__kevent50", "int" },
	/* 436 */  { 6, "__pselect50", "int" },
	/* 437 */  { 4, "__pollts50", "int" },
	/* 438 */  { 3, "__aio_suspend50", "int" },
	/* 439 */  { 2, "__stat50", "int" },
	/* 440 */  { 2, "__fstat50", "int" },
	/* 441 */  { 2, "__lstat50", "int" },
	/* 442 */  { 4, "____semctl50", "int" },
	/* 443 */  { 3, "__shmctl50", "int" },
	/* 444 */  { 3, "__msgctl50", "int" },
	/* 445 */  { 2, "__getrusage50", "int" },
	/* 446 */  { 4, "__timer_settime50", "int" },
	/* 447 */  { 2, "__timer_gettime50", "int" },
	/* 448 */  { 1, "__ntp_gettime50", "int" },
	/* 449 */  { 4, "__wait450", "int" },
	/* 450 */  { 3, "__mknod50", "int" },
	/* 451 */  { 3, "__fhstat50", "int" },
	/* 452 */  { -1, NULL, NULL },
	/* 453 */  { 2, "pipe2", "int" },
	/* 454 */  { 3, "dup3", "int" },
	/* 455 */  { 1, "kqueue1", "int" },
	/* 456 */  { 5, "paccept", "int" },
	/* 457 */  { 5, "linkat", "int" },
	/* 458 */  { 4, "renameat", "int" },
	/* 459 */  { 3, "mkfifoat", "int" },
	/* 460 */  { 5, "mknodat", "int" },
	/* 461 */  { 3, "mkdirat", "int" },
	/* 462 */  { 4, "faccessat", "int" },
	/* 463 */  { 4, "fchmodat", "int" },
	/* 464 */  { 5, "fchownat", "int" },
	/* 465 */  { 3, "fexecve", "int" },
	/* 466 */  { 4, "fstatat", "int" },
	/* 467 */  { 4, "utimensat", "int" },
	/* 468 */  { 4, "openat", "int" },
	/* 469 */  { 4, "readlinkat", "ssize_t" },
	/* 470 */  { 3, "symlinkat", "int" },
	/* 471 */  { 3, "unlinkat", "int" },
	/* 472 */  { 2, "futimens", "int" },
	/* 473 */  { 2, "__quotactl", "int" },
	/* 474 */  { 6, "posix_spawn", "int" },
	/* 475 */  { 5, "recvmmsg", "int" },
	/* 476 */  { 4, "sendmmsg", "int" },
	/* 477 */  { 4, "clock_nanosleep", "int" },
	/* 478 */  { 6, "___lwp_park60", "int" },
	/* 479 */  { 4, "posix_fallocate", "int" },
	/* 480 */  { 4, "fdiscard", "int" },
	/* 481 */  { 6, "wait6", "int" },
	/* 482 */  { 3, "clock_getcpuclockid2", "int" },
	/* 483 */  { 3, "__getvfsstat90", "int" },
	/* 484 */  { 3, "__statvfs190", "int" },
	/* 485 */  { 3, "__fstatvfs190", "int" },
	/* 486 */  { 4, "__fhstatvfs190", "int" },
};
