/*
 *  Routines for managing the list of pending calls, including
 *  creating and looking for invitations.
 */

/*
 * Log:    list.c,v 
 * Revision 1.1	 85/10/28  17:38:22  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: list.c,v 1.1 85/10/28 17:38:22 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: list.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif




static int  requests = 0;	       /* number of pending invitations */

/*
 *  Insert a request into the pending list.
 */

void
insert(INV *inv)
{
    /* insert into top of list */
    if (invitations == NULL) {
	inv->next	  = NULL;
	invitations	  = inv;
    } else {
	inv->next	  = invitations;
	invitations->prev = inv;
	invitations	  = inv;
    }

    if (requests++ == 0)    /* need to set alarm interrupt */
	alarm(1);	   /* so start up alarm */
}


/*
 *  Called on SIGALRM to process pending calls ---
 *  go through the list of pending invitations, removing any old
 *  ones, trying to ring the rest.
 */
void
ring(int s __unused)
{
    INV	  *inv;
    INV	  *next;

    if (!requests)   /* no pending requests **/
	return;

    for (inv = invitations; inv; inv = next) {
	next = inv->next;		    /* save the next one	  */
	if (inv->rings++ == 0)		    /* time to page this one ???  */
	    dopage(inv);		   /* I guess so ...		 */
	else if (inv->rings > 30)	    /* more than five minutes old */
	    delete(inv);
    }
    if (requests > 0)			     /* any requests left ???	  */
	alarm(5);			    /* set the next alarm	 */
#ifdef INET	  /* if running under inetd, exit when no more work to do */
    else
	exit(0);
#endif /* INETD */
}


/*
 *  Page the given invitation and return a status message.
 *  Notice the incredible amount of indirection going on here -
 *  up to three(or is it four) levels !! Have to clean this up 
 *  when we get forwarding working properly.
 */

void
dopage(INV *inv)
{
    char  buf[1024];
    int	  ret;
    char  *name;
    char  *tty;

    name = inv->callee;
    ret = doxpage(inv);


    if (ret == 0)	/* all looks to be good */
	return;

    if (ret == MESG_OFF)
	snprintf(buf, sizeof(buf), "%s@%s is refusing messages", name, host);
    else if (ret == NOT_ON)
	snprintf(buf, sizeof(buf), "%s@%s is not logged in", name, host);

    if ((tty = inv->tty) && *tty) {
	strlcat(buf, " on ", sizeof(buf));
	strlcat(buf, tty, sizeof(buf));
    }

    delete(inv);
    sendit(misc, &inv->ctladdr, "%c%c%c%s%s", ESC, CALLING, NAK, inv->id, buf);
}


/*
 *  Check to see if the named user is being invited by the right person.
 *  Returns a pointer to the invitation in question.
 *
 *  A wildcard "*" is acceptable as the caller name - this is 
 *  useful for answering machine programs.
 */

INV *
lookup(const char *callee, const char *caller)
{
    INV	 *inv;
    int	 all = eq(caller, "*");

    for (inv = invitations; inv; inv = inv->next) {
	if (all || eq(inv->caller, caller))	/* caller match */
	    if (eq(callee, inv->callee))	/* callee match */
		return inv;
    }
    return NULL;
}


/*
 *  The usual linked-list deletion routine, with a minor
 *  difference - instead of deallocating the space, we simply
 *  place the element on a free list for future use(LIFO form)
 */

void
delete(INV *ptr)
{
    requests--;				/* decrement number pending  */
    if (ptr->prev)
	ptr->prev->next = ptr->next;	/* set previous's next pointer */ 
    else 
	invitations = ptr->next;

    if (ptr->next)
	ptr->next->prev = ptr->prev;	/* set next's previous pointer */
    
    ptr->next = freelist;		/* add on tail of free list */
    freelist = ptr;			/* and make this the top */
}
