/*
 * Log:    inquire.c,v 
 * Revision 1.1	 85/10/28  17:38:21  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"

#ifndef lint
#if 0
static char __unused RCSid[] = "Header: inquire.c,v 1.1 85/10/28 17:38:21 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: inquire.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif


/*
 *  Check to see if there are any pending calls for this user,
 *  send back the first address and delete the invite if any are found.
 */

void
inquire(char *argv[], struct sockaddr_in *sin)
{
    INV	 *inv;

    if ((inv = lookup(argv[0], argv[1])) != NULL) {	 /* had one pending */
	sendit(misc, sin, "%c%c%c%s", ESC, INQUIRE, ACK, inv->convaddr);
	delete(inv);
    } else
	sendit(misc, sin, "%c%c%cNo messages pending.", ESC, INQUIRE, NAK);
}


/*
 *  They say they answered the call, so delete it from the list.
 *  This routine is for future use - not used now ...
 */

void
answer(char *argv[])
{
    INV *inv;
    
    for (inv = invitations; inv; inv = inv->next)
	if (eq(argv[0], inv->callee) && eq(argv[1], inv->convaddr)) {
	    sendit(misc, &inv->ctladdr, "%c%c%c%s", ESC, ANSWER, ACK, inv->id);
	    delete(inv);
	    return;
	}
}
