/*
 * Log:    forward_program.c,v 
 * Revision 1.1	 85/10/28  17:38:17  broome
 * Initial revision
 */

#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: forward_program.c,v 1.1 85/10/28 17:38:17 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: forward_program.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif


/*
 *  Take the pathname of a forwarding program
 *  and start it up.
 *
 *  Features: the ability to give a printf-like
 *  format string to fill in with the caller and such.
 *
 *	"%R" - name of recipient 
 *	"%C" - name of caller
 *	"%H" - caller's host
 */

void
forward_program(char *buf, INV *inv)
{
    pid_t    pid;	    /* child process		   */
    int	     fd;	    /* fds to close		   */
    int	     argc;	    /* count of words in command   */
    char     *argv[32];	    /* command in forward file	   */

    inv->flags |= PROG;		    /* mark as being piped */
    if ((pid = fork()) != 0) {	    /* parent returns immediately */
	if (pid == -1)		    /* fork failed */
	    inv->rings = 0;	    /* try again next time */
	else
	    inv->pid = pid;	    /* save process id */
	return;
    }

    /*
     *	We're the child process, so clean up 
     *	and exec the program.
     */

    sigblock(0);		   /* ignore all signals */

    if ((argc = expand(buf, argv, sizeof(argv) / sizeof(argv[0]), inv)) != 0) {
	/* it contains something */

	setgid(inv->gid);	       /* set up permissions */
	initgroups(inv->callee, inv->gid);
	setuid(inv->uid);	       /* ... fix security   */
	for (fd = 0; fd < getdtablesize(); fd++)    /* clean up */
	   (void) close(fd);
	execv(argv[0], argv);	       /* and do it */
	_exit(-99);		       /* bad format?? */
    }
}



/*
 *  Given a line from the .phonerc file, expand ~user and also '%'
 *  substitutions(like printf) and parse into an argument vector.
 *
 *  We use a static buffer to stick the string sinto, so as to 
 *  avoid the malloc/free-in-interrupt routine problem.
 *
 *  The allowed '%' substitutions are:
 *
 *	"%R" - name of the recipient.
 *	"%C" - name of the calling party.
 *	"%H" - calling party's host.
 */

int
expand(char *inbuf, char **argp, size_t nargp, INV *inv)
{
    struct	passwd *pwd;
    static	char outbuf[10240];
    char *i;
    char *o;
    char *n;
    static char PC[] = "%";
    char	*start;
    char	name[32];
    int		first;
    char	**ap;

    i = inbuf;
    o = outbuf;
    ap = argp;

    while (*i) {
	start = o;	/* save front of this word */

	while (*i && (*i == ' ' || *i == '\t'))
	    i++;
	
	for (first = 1; *i && *i != ' ' && *i != '\t'; i++) {
	    if (*i == '~' && first) {	    /* ~user */
		for (i++, n = name; *i && *i != '/' && *i != ' ' && *i != '\t';)
		    *n++ = *i++;
		i--;
		*n = '\0';
		if (*name == '\0') {	/* use $HOME */
		    n = inv->home;
		} else {		/* lookup user in passwd file */
		    if ((pwd = getpwnam(name)) != NULL)
			n = pwd->pw_dir;
		    else
			n = NULL;
		}
		while (n && *n)	    /* copy dir over */
		    *o++ = *n++;
	    } else if (*i == '%') {	/* do printf-like stuff */
		switch(*++i) {
		case 'R':   n = inv->callee;	/* recipient */
			    break;
		case 'C':   n = inv->caller;	/* caller */
			    break;
		case 'H':   n = inv->host;	/* calling host */
			    break;
		case '%':   n = PC;	       /* normal percent */
			    break;
		}
		while (n && *n)
		   (*o++ = *n++);
	    } else
		*o++ = *i;
	}
	*o++ = '\0';
	if ((size_t)(ap - argp) >= nargp)
	    return ap - argp;
	if (*start != '\0')
	    *ap++ = start;
    }
    *ap = NULL;
    return ap - argp;
}
