/*
 * Log:    dopage.c,v 
 * Revision 1.1	 85/10/28  17:38:16  broome
 * Initial revision
 */


#include "../common.h"
#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: dopage.c,v 1.1 85/10/28 17:38:16 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: dopage.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif


/*
 *   Handle paging one user - one invitation.
 *   Checks for ~/.busy, tries to do 
 *   the right thing.
 */

int
doxpage(INV *inv)
{
    FILE     *fp;	    /* forward file   */
    char     *tty;	    /* tty they're on */
    int	     pid;	    /* child process  */
    int	     mode;	    /* tty status     */
    struct   stat statb;
    char     buf[MAXPATHLEN];

    /*
     *	We won't check for forwarding if it has failed already.
     *	We also make sure that home isn't null - otherwise unknown
     *	users might be able to take advantage of root somehow ...
     */

    if ((inv->flags & DONTFORWARD) == 0 && inv->home) {
	strlcpy(buf, inv->home, sizeof(buf));
	strlcat(buf, BUSYFILE, sizeof(buf));
	if (stat(buf, &statb) == 0 &&(statb.st_mode &(04<<3)) &&
	  statb.st_uid == inv->uid &&(fp = fopen(buf, "r"))) {
	    /* file exists */
	    while (fgets(buf, sizeof(buf), fp))	       /* read a line */
		if (*buf != '\n' && *buf != '#')
		    break;
	    fclose(fp);
	    if (*buf == '/' || *buf == '~') {	  /* path to program */
		forward_program(buf, inv);    /* so invoke it */
		return 0;
	    }
	}
    }

    inv->flags &= ~PROG;

    /* 
     *	If we're here, we didn't forward it, so look for them
     *	on a tty and send a message to their terminal.
     */
    
    tty = findtty(inv->callee, inv->tty, &mode);
    if (mode == NOT_ON)
	return NOT_ON;
    
    if (inv->ptty)
	free(inv->ptty);
    inv->ptty = strsave(tty+5);	   /* save name of tty being paged */

    if (mode == MESG_OFF)
	return MESG_OFF;
    
    if ((pid = fork()) != 0) {	      /* parent */
	if (pid == -1) {	    /* fork failed */
	    perror("fork");
	    inv->rings = 0;	/* so try again next time */
	} else
	    inv->pid = pid;	/* save child's id */
	return 0;
    }
    pagetty(inv, tty);	       /* child - do it */
    return 0;
}
