#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: who.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Print out who is on the machine.
 *  If an argument is specified, only show occurrences of that user.
 */

void
who(int argc, char *argv[])
{
    int	    found = 0;	  /* found who we're looking for */
    struct  utmpx *ut;	  /* one entry in /etc/utmp    */
    char    buf[256];	  /* and one entry buffer      */
    char    *msg;
    char    *host;
    struct  hostent *hp;
    struct  sockaddr_in sin;

    if (argc == 1 && **argv == '@') {
	host = &argv[0][1];
	if (isdigit((unsigned char)*host))
	    sin.sin_addr.s_addr = inet_addr(host);
	else if ((hp = gethostbyname(host)) != NULL)
	    memcpy(&sin.sin_addr, hp->h_addr, sizeof(sin.sin_addr));
	else {
	    message("who: unknown host: %s", host);
	}
	sin.sin_port = port;
	sin.sin_family = AF_INET;
	buf[0] = ESC;
	buf[1] = WHO;
	while (sendto(ctl, buf, 2, 0, (void *)&sin, sizeof(sin)) == -1) {
	    if (errno == EINTR)
		continue;
	    error (0, "who: sendto");
	}
	return;
    }

    setutxent();
    msg = NULL;
    while ((ut = getutxent()) != NULL) {
	if (ut->ut_name[0] == '\0' || ut->ut_type != USER_PROCESS)
	    continue;
	if (argc && strcmp(argv[0], ut->ut_name))
	    continue;
	found++;
	if (msg) {
		char *nm;
		asprintf(&nm, "%s %.8s(%.5s)", msg, ut->ut_name, ut->ut_line);
		free(msg);
		msg = nm;
	} else
		asprintf(&msg, "%.8s(%.5s)", ut->ut_name, ut->ut_line);
    }
    endutxent();
    if (msg) {
	message("%s", msg);
	free(msg);
    }

    if (argc && !found)
	message("<not logged on>");
}
