#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: sendit.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

#define WAIT	2	/* wait this long before re-sending */

/*
 *  Send the given buffer to the given address, with
 *  multiple retries.  Stores the received string
 *  in the global `buf', and returns the number of chars
 *  read, or -1 on error or no response.
 */

ssize_t
sendit(char *buf, size_t buflen, struct sockaddr_in *sin, const char *fmt, ...)
{
    int n, nfd;
    ssize_t rval;	/* number of bytes read */
    size_t tries;	/* number of tries made */
    struct pollfd pfd;	/* fd for poll */
    va_list ap;

    va_start(ap, fmt);
    n = vsnprintf(buf, buflen, fmt, ap);
    va_end(ap);
    if ((size_t)n >= buflen) {
	error(0, "sendit: overflow");
	return -1;
    }
    pfd.fd = ctl;
    pfd.events = POLLIN|POLLERR;

    for (tries = 0; tries < 5; tries++) {
	while (sendto(ctl, buf, n, 0, (void *)sin, sizeof(*sin)) < 0) {
	    if (errno == EINTR)
		continue;
	    error(0, "sendit: sendto");
	    return -1;
	}
	if (Debug)
	    printf("\r\nsendit: trying #%zu.\r\n", tries);
#ifdef DEBUG
	putmessage("sendit: trying #%zu ...", tries);
#endif /* DEBUG */

	while ((nfd = poll(&pfd, 1, WAIT * 1000)) <= 0) {   /* nothing to read on */
	    if (errno == EINTR)
		continue;
	    if (Debug)
		printf("\r\nsendit: no response on try #%zu.\r\n", tries);
	    break;
	}
	if (nfd <= 0)
	    continue;
	while ((rval = read(ctl, buf, buflen)) < 0) {	  /* read the response */
	    if (errno == EINTR)
		continue;
	    error(errno, "sendit: read response");
	    break;
	}
	if (rval < 0)
	    continue;
	if (Debug)
	    printf("sendit: read %zd chars.\r\n", rval);
	return rval;
    }
    if (Debug)
	printf("\r\nsendit: response timed out.\r\n");
#ifdef DEBUG
    putmessage("sendit: response timed out.");
#endif /* DEBUG */
    return -1;	      /* timed out */
}
