#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: runprog.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Routines to handle subprocesses inside windows.
 *
 *  Future plans include putting children on ptys,
 *  allowing multiple processes, some kind of simple
 *  process control, setting window size(ioctl) and 
 *  termcap to properly reflect the window size, and 
 *  being able to run screen-oriented programs within
 *  the phone window.  Maybe sometime ...
 */


int childpid = 0;	/* current child process's pid */
int tochild;		/* fd to write to child */
int fromchild;		/* fd to read from child */
int killedchild;	/* flag set on intr - flush output */ 


/*
 *   Run a program. We use the user's shell to allow piping and wildcards.
 */

void
run(int argc, char *argv[])
{
    char  args[512];
    int	  in[2], out[2];
    int	  i;

    if (childpid) {
	putmessage("You are already running a program!!!");
	return;
    }

    /* concatenate all the arguments to pass to a shell */
    for (*args = '\0', i = 0; i < argc; ) {
	strcat(args, argv[i]);
	if (++i < argc)
	    strcat(args, " ");
    }

    if (pipe(in) < 0 || pipe(out) < 0) {
	error(0, "Cannot pipe to child process");
	return;
    }
    killedchild = 0;

    switch(childpid = fork()) {
    case -1:	error(0, "fork");  break;

    case  0:	(void) dup2(in[0], 0); /* child's stdin */
		(void) dup2(out[1], 1);	   /* stdout */
		(void) dup2(out[1], 2);	   /* stderr */
		(void) close(in[0]);(void) close(out[1]);
		execl(shell, xbasename(shell), "-c", args, NULL);
		err(1, "execl %s", argv[0]);

    default:	(void) close(in[0]);
		(void) close(out[1]);
		(void) fcntl(in[1],  F_SETFL, FNDELAY | FASYNC);
		(void) fcntl(out[0], F_SETFL, FNDELAY | FASYNC);
		tochild = in[1];    /* write to child here */
		fromchild = out[0]; /* read from child here */
		return;
    }
}


/*
 *   Read some output from the process.	 We make sure that there
 *   aren't any magic characters there to hang anyone, and do
 *   local echoing if need be.
 */

void
readchild(void)
{
    int	 r, i;
    char buf[1024];
    char *c;

    if ((r = read(fromchild, buf, 1024)) == -1) {
	if (errno != EWOULDBLOCK)
	    perror("read from child");
	return;
    } else if (r == 0) {	/* child is finished */
	if (Debug)
	    putmessage("Saw EOF on child process.");
	childpid = 0;
       (void) close(tochild);
       (void) close(fromchild);
    } else {			/* send to everyone */
	if (!killedchild) {
#ifdef LOCAL_ECHO
	    int oldwin = selwin(-1);
#endif /* LOCAL_ECHO */
	    for (c = buf, i = 0; i < r; c++, i++) {
		if (*c & META)
		    *c &= 0177;
#ifdef LOCAL_ECHO
		showch(*c);
#endif /* LOCAL_ECHO */
	    }
	   (void) write(stream, buf, r);
#ifdef LOCAL_ECHO
	    refresh();
	   (void) selwin(oldwin);
#endif /* LOCAL_ECHO */
	}
    }
}


/*
 *  SIGCHLD handler.
 *  We don't reset the pid and fd states because we'll get those when
 *  we see the eof on the kid's descriptors.
 */

void
sigchld(int n)
{
    int status;

    if (childpid == 0)
	return;

    while (wait3(&status, WNOHANG, NULL) > 0)
	continue;

    if (Debug)
	putmessage("Caught sigchld.");
}
