#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: misc.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

/*
 *  See if char `c' is contained in string `s'. Returns 1 if true, 0 if not.
 */

int
any(int c, const char *s)
{
    while (*s)
	if (c == *s++)
	    return 1;
    return 0;
}


/*
 *  Send an error message to the user.	Much like perror().
 *  If fatal is non-zero, we will terminate with that status.
 */

void
error(int fatal, const char *fmt, ...)
{
    char   buf[1024];
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);

    if (connected)  /* and have set up curses */
	if (errno)
	    putmessage("%s: %s", buf, strerror(errno));
	else
	    putmessage("%s", buf);
    else {
	if (errno)
	    fprintf(stderr, "%s: %s\r\n", buf, strerror(errno));
	else
	    fprintf(stderr, "%s\r\n", buf);
    }

    if (fatal) {
	cleanup();
	fprintf(stderr, "\n\n");
	exit(fatal);
    }
}

/*
 *  User interface to the screen dump routine.
 */

void
dump(int argc, char *argv[])
{
    dodump(argc ? *argv : ".dump");
}


/*
 *  Do a screen dump to the named file.
 */

void
dodump(const char *name)
{
    FILE *fp;
    int	 y, x;

    if (!connected)	    /* take it as a normal interrupt */
	quit(0, NULL);

    if ((fp = fopen(name, "w")) ==NULL) {
	error(0, "Cannot create \"%s\" file", name);
	return;
    }
    for (y = 0; y <= maxy; y++) {
	for (x = 0; x < maxx; x++)  {
	    char c;
	    mvinsnstr(y, x, &c, 1);
	    (void) putc(c & 0177, fp);
	}
	(void) putc('\n', fp);
    }
    (void) fclose(fp);
    (void) putmessage("Screen dump to \"%s\" complete.", name);
}



/*
 *  Move to the bottom line and exit.
 */

void
quit(int argc __unused, char *argv[] __unused)
{
    if (did_screen)
	cleanup();
    if (connected) 
	printf("\nConnection closed. Exiting ...");
    printf("\n");

    if (childpid)   /* clean up rather forcefully */
	kill(childpid, 9);

    exit(0);
}


/*
 *  Catch SIGWINCH and come here - just set a flag and return.
 */

void
sigwinch(int s __unused)
{
    changed_size = 1;
}



/*
 *   Chdir to the named directory, to $HOME if no args.
 */
void
cd(int argc, char *argv[])
{
    char    *dir;

    if (argc == 0) {	    /* try to go home */
	if ((dir = getenv("HOME")) ==NULL) {
	    putmessage("No HOME set!");
	    return;
	}
    } else
	dir = argv[0];
    
    if (chdir(dir)) {
	error(0, "Cannot chdir to \"%s\"", dir);
    }
}


/*
 *  Given a full pathname, return a pointer to the last part of the path.
 */

const char *
xbasename(const char *path)
{
    char    *p;

    if ((p = strrchr(path, '/')) != NULL)
	return p + 1;
    return path;
}

