/*	$Phone: defs.h,v 1.2 2013/01/02 23:00:42 christos Exp $	*/
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <pwd.h>
#include <err.h>
#include <time.h>
#include <fcntl.h>
#include <termios.h>
#include <utmpx.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <stdarg.h>
#include <errno.h>
#include <poll.h>
#include <curses.h>
#include <netdb.h>

int	msgpending;
int	killedchild;
int	changed_size;
int	did_screen;
int	current;
pid_t	childpid;
int	fromchild, tochild;
const char *version_string;
char	*mylogin;		    /* user's login name       */
char	*mytty;			    /* tty he's on	       */
char	*home;			    /* home directory	       */
const char *shell;		    /* preferred shell	       */
char	myhost[MAXHOSTNAMELEN];	    /* local host name	       */
char	realname[MAXLOGNAME];	    /* from password file      */
int	maxx;			    /* max legal x coordinate  */
int	maxy;			    /* max legal y coordinate  */
int	stream;			    /* stream socket filedes   */
int	ctl;			    /* control socket fd       */
int	reading;		    /* currently reading kb?   */
extern	int	pending;	    /* number of pending calls */
int	connected;		    /* number of connected people */
int	touched25;		    /* message changed line 25	  */
struct	sockaddr_in locaddr;	    /* localhost address   */
char	convaddr[MAXHOSTNAMELEN];   /* conversation address    */
int	port;			    /* phoned socket port      */

#ifndef ESC
#define ESC	'\033'
#endif

#define PROMPT	"Command> "

#define ctrl(C)	   ('C'-'@')
#define equal(a,b) (strcmp(a, b) == 0)


/*
 *  Various oft-used flags.
 */

int	Interval;		    /* seconds between messages */
int	Inverse;		    /* allow use of inverse video */
int	Stop;			    /* print "Stopped" to socket on ^Z */
int	Debug;			    /* verbose tracing stuff */
int	Bells;			    /* let ^G come through as bell */
int	Hold;			    /* send input to child process */
int	Echo;			    /* send input to socket when running prog */

/* alias.c */
void alias(int, char *[]);
char *expalias(const char *);

/* calls.c */
void placecall(const char *, const char *, const char *);
void reinvite(void);
void delete(const char *);
void page(int, char *[]);
void cancel(int, char *[]);

/* check_invite.c */
char *check_invite(const char *, char *);

/* cmd.c */
void execute(const char *);
void help(int, char *[]);
void zip(int, char *[]);

/* connect_daemon.c */
int connect_daemon(const char *);

/* getdaemon.c */
char *getdaemon(void);

/* kb.c */
void keyboard(void);
void geteditchars(void);

/* message.c */
void message(const char *, ...)
    __attribute__((__format__(__printf__, 1, 2)));
void showmessage(void);
void flush(void);

/* misc.c */
int any(int, const char *);
void error(int, const char *, ...)
    __attribute__((__format__(__printf__, 2, 3)));
void dump(int, char *[]);
void dodump(const char *);
void quit(int, char *[]);
void sigwinch(int);
void cd(int, char *[]);
const char *xbasename(const char *);

/* names.c */
int names(void);

/* parse.c */
int parse(const char *, char **);

/* readctl.c */
void readctl(void);

/* readrc.c */
void readrc(void);

/* readstream.c */
void readstream(void);

/* runprog.c */
void run(int, char *[]);
void readchild(void);
void sigchld(int);

/* sendit.c */
ssize_t sendit(char *, size_t, struct sockaddr_in *, const char *, ...)
    __attribute__((__format__(__printf__, 4, 5)));

/* set.c */
void set(int, char *[]);
void show(int, char *[]);

/* sig.c */
void sigint(int);
void sigquit(int);
void badsig(int);

/* stop.c */
void sigstop(int);

/* strsave.c */
char *strsave(const char *);

/* tilde.c */
char *exptilde(const char *);

/* timer.c */
void timer(int);

/* version.c */

/* who.c */
void who(int, char *[]);

/* windows.c */
void setup(void);
void cleanup(void);
int selwin(int);
void adduser(int, const char *);
void deluser(int);
void showch(int);
void putmessage(const char *, ...)
    __attribute__((__format__(__printf__, 1, 2)));
void header(int);
void stretch(int);
