#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: alias.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif


/*
 *  Routines to handle phone aliases, much like mail aliases.
 */

struct alias {
    char    *name;	/* name of alias */
    char    *real;	/* and what it expands to */
    struct  alias *next;
};

static	struct	alias	*aliases = NULL;


/*
 *  Set up an alias.
 */

void
alias(int argc, char *argv[])
{
    struct  alias *ap;

    if (argc == 0) {	    /* just show aliases */
	message("Showing all aliases:");
	for (ap = aliases; ap; ap = ap->next) {
	    message("%s --> %s", ap->name, ap->real);
	}
	message("That's all!");
	return;
    }
    if (argc == 1) {
	putmessage("alias: arg count must be 0 or 2!");
	return;
    }
    ap = malloc(sizeof(*ap));
    if (ap == NULL) {
	error(0, "alias: cannot allocate memory for alias");
	return;
    }
    ap->name = strsave(argv[0]);
    ap->real = strsave(argv[1]);

    ap->next = aliases;
    aliases = ap;
}



/*
 *  Expand an alias.  It copies the expansion into a buffer so 
 *  that the calling routines can munge it to their heart's content.
 */

char *
expalias(const char *name)
{
    struct alias *ap;
    static   char   buf[128];

    for (ap = aliases; ap; ap = ap->next)
	if (strcmp(name, ap->name) == 0) {
	    strlcpy(buf, ap->real, sizeof(buf));
	    return buf;
	}
    return NULL;
}
