use ExtUtils::MakeMaker;

use 5.005;

use strict;
use English;
use Term::ReadLine;  # this allows us to test for Term::ReadLine::Gnu
                     # for some reason I don't know yet.

my $modules_dir = 'modules';

my $prereq_modules = { 'AppConfig'           => 1.52,
		       'Term::ReadKey'       => 2.14,
		       'Term::ReadLine::Gnu' => 1.01,
		       'GnuPG::Interface'    => 0.30,
		       'Class::MethodMaker'  => 0.96,
		       'String::Approx'      => 3.13,
		      };

print
  "If you get a warning below about needing prerequisite modules,\n",
  "please install them from the directory '$modules_dir'.\n";


WriteMakefile
  ( AUTHOR        => 'Frank J. Tobin',
    ABSTRACT_FROM => "pgpenvelope",
    NAME          => 'pgpenvelope',
    VERSION_FROM  => 'lib/PGPEnvelope/Common.pm',
    
    EXE_FILES     => [ 'pgpenvelope_encrypt',
		       'pgpenvelope_decrypt',
		       'pgpenvelope',
		     ],
    
    dist => { COMPRESS   => 'gzip', 
	      SUFFIX     => 'gz',
	    },

    PREREQ_PM => $prereq_modules,
    
  );

