/*
   Copyright (c) 2000 MicroSource

   This source file and all accompanying files are the exclusive property
   of the author Paul Carapetis and MicroSource, and no modifications are
   to be performed on said source without expressed permission from the
   author or an authorised representative of MicroSource, unless the
   purpose of such modifications is to effect a successful compile on your
   platform.

   This source is only to be distributed in its complete form and only with
   all of the following files included:

        INSTALL
        README
        ibmchars.uu
        license.doc
        newargs.txt
        pcps.man
        register.doc

        makefile
        define.h
        pcps.c
        pcps.h
        struct.h
        unix.c
        unix.h
        valargs.h

   The utility "PCPS" is a SHAREWARE product and you, as the user, agree
   that the source will be removed from your filesystem once the utility
   has been successfully compiled and is found to be functional.  Any
   changes to the source that were required for a successful compile must
   be returned to the author for inclusion in the main source control.

   The utility may be trialed for the period of time mentioned in the file
   license.doc, but must either be registered or destroyed within said
   trial time.  The cost and method of registration is detailed in the file
   license.doc.

Author:  Paul Carapetis  Internet: Paul_Carapetis@iname.com
Company: MicroSource     Snail:    10 Denise Court
                                   Narre Warren
                                   Australia  3805

*/
#ifndef PCPS_VALA
# define PCPS_VALA
/*****************************************************************************/
/* valargs.h - List of valid arguments used in pcps.c                        */
/*****************************************************************************/

/* The enum below and the ArgTable below that must both have all valid
   arguments listed and in the same order to be used in ProcessArgs().
   The ArgTable is scanned for a match with the first two characters of
   every argument, and the index into that table is used in a switch
   using the values in the following enum
*/

enum {
  eHELP,
  eLIST,
  eALTPAGE,
  eBOXPAGE,
  eCTLD,
  eCOPIES,
  eCTLZ,
  eDEFACT,
  eDENMARK,
  eDELFILE,
  eDUPLEX,
  eDATEFORM,
  eERRHAND,
  eENCODING,
  eENHSTYLE,
  eFILENAME,
  eFONT,
  eGAUDY,
  eGAUDY1,
  eIDENT,
  eINVERSE,
  eLINESPC,
  eLINELEN,
  eLINENUM,
  eLINEPG,
  eMARGIN,
  eMANFEED,
  eMODE,
  eNOBANN,
  eNOFLUSH,
  eNOZEROS,
  eOUTFILE,
  ePRNPREP,
  ePGRANGE,
  ePSTIME,
  eQUIET,
  eROTATE,
  e2COL,
  eSHADE,
  eSWAPMAR,
  ePSIZE,
  eTABSTOP,
  eTRUNC,
  eTRAY,
  ePGUP,
  eWATERMK,
};

char ArgTable [][3] = {
  "he",                    /* eHELP */
  "ls",                    /* eLIST */
  "ap",                    /* eALTPAGE */
  "bx",                    /* eBOXPAGE */
  "cd",                    /* eCTLD */
  "cp",                    /* eCOPIES */
  "cz",                    /* eCTLZ */
  "df",                    /* eDEFACT */
  "dk",                    /* eDENMARK */
  "dl",                    /* eDELFILE */
  "dp",                    /* eDUPLEX */
  "dt",                    /* eDATEFORM */
  "eh",                    /* eERRHAND */
  "en",                    /* eENCODING */
  "es",                    /* eENHSTYLE */
  "fn",                    /* eFILENAME */
  "fo",                    /* eFONT */
  "ga",                    /* eGAUDY */
  "g1",                    /* eGAUDY1 */
  "id",                    /* eIDENT */
  "in",                    /* eINVERSE */
  "lf",                    /* eLINESPC */
  "ll",                    /* eLINELEN */
  "ln",                    /* eLINENUM */
  "lp",                    /* eLINEPG */
  "ma",                    /* eMARGIN */
  "mf",                    /* eMANFEED */
  "mo",                    /* eMODE */
  "nb",                    /* eNOBANN */
  "nf",                    /* eNOFLUSH */
  "nz",                    /* eNOZEROS */
  "of",                    /* eOUTFILE */
  "pp",                    /* ePRNPREP */
  "pr",                    /* ePGRANGE */
  "pt",                    /* ePSTIME */
  "qu",                    /* eQUIET */
  "ro",                    /* eROTATE */
  "2c",                    /* e2COL */
  "sh",                    /* eSHADE */
  "sm",                    /* eSWAPMAR */
  "sz",                    /* ePSIZE */
  "tb",                    /* eTABSTOP */
  "tr",                    /* eTRUNC */
  "ty",                    /* eTRAY */
  "up",                    /* ePGUP */
  "wm",                    /* eWATERMK */
  '\0',  /* this zero must be here to terminate the for loop in PorcessArgs */
};
#endif /* PCPS_VALA */
