/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1994 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

/*
 * The functions in this file customize the behavior of m68kdis
 * to take certain word values as acceptable A-line and F-line
 * instructions and whether any of these unconditionally change PC.
 */

/************************************************************************/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 1998 David Griffiths				*/
/*									*/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 1999 Nick Spence					*/
/*									*/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 2000 Ali Akcaagac					*/
/************************************************************************/

/************************************************************************/
/*	normal includes							*/
/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "dis.h"

/************************************************************************/
/*	normal defines							*/
/************************************************************************/
#define F			0
#define A			1
#define T			2

/************************************************************************/
/*	structure							*/
/************************************************************************/
struct fatinst {
	m68kword inst;
	char *name;
};

/************************************************************************/
/*	global variables						*/
/************************************************************************/
static size_t njinsts = 0;
static m68kword *jinsts = NULL;

/************************************************************************/
/*	traptable. this was a heavy work.				*/
/************************************************************************/
static char *trap_table[] = {
//	"a000 sysTrapBase",			// sysTrapMemInit
	"a000 sysTrapMemInit",
	"a001 sysTrapMemInitHeapTable",
	"a002 sysTrapMemStoreInit",
	"a003 sysTrapMemCardFormat",
	"a004 sysTrapMemCardInfo",
	"a005 sysTrapMemStoreInfo",
	"a006 sysTrapMemStoreSetInfo",
	"a007 sysTrapMemNumHeaps",
	"a008 sysTrapMemNumRAMHeaps",
	"a009 sysTrapMemHeapID",
	"a00a sysTrapMemHeapPtr",
	"a00b sysTrapMemHeapFreeBytes",
	"a00c sysTrapMemHeapSize",
	"a00d sysTrapMemHeapFlags",
	"a00e sysTrapMemHeapCompact",
	"a00f sysTrapMemHeapInit",
	"a010 sysTrapMemHeapFreeByOwnerID",
	"a011 sysTrapMemChunkNew",
	"a012 sysTrapMemChunkFree",
	"a013 sysTrapMemPtrNew",
	"a014 sysTrapMemPtrRecoverHandle",
	"a015 sysTrapMemPtrFlags",
	"a016 sysTrapMemPtrSize",
	"a017 sysTrapMemPtrOwner",
	"a018 sysTrapMemPtrHeapID",
	"a019 sysTrapMemPtrCardNo",
	"a01a sysTrapMemPtrToLocalID",
	"a01b sysTrapMemPtrSetOwner",
	"a01c sysTrapMemPtrResize",
	"a01d sysTrapMemPtrResetLock",
	"a01e sysTrapMemHandleNew",
	"a01f sysTrapMemHandleLockCount",
	"a020 sysTrapMemHandleToLocalID",
	"a021 sysTrapMemHandleLock",
	"a022 sysTrapMemHandleUnlock",
	"a023 sysTrapMemLocalIDToGlobal",
	"a024 sysTrapMemLocalIDKind",
	"a025 sysTrapMemLocalIDToPtr",
	"a026 sysTrapMemMove",
	"a027 sysTrapMemSet",
	"a028 sysTrapMemStoreSearch",
	"a029 sysTrapReserved6",
	"a02a sysTrapMemKernelInit",
	"a02b sysTrapMemHandleFree",
	"a02c sysTrapMemHandleFlags",
	"a02d sysTrapMemHandleSize",
	"a02e sysTrapMemHandleOwner",
	"a02f sysTrapMemHandleHeapID",
	"a030 sysTrapMemHandleDataStorage",
	"a031 sysTrapMemHandleCardNo",
	"a032 sysTrapMemHandleSetOwner",
	"a033 sysTrapMemHandleResize",
	"a034 sysTrapMemHandleResetLock",
	"a035 sysTrapMemPtrUnlock",
	"a036 sysTrapMemLocalIDToLockedPtr",
	"a037 sysTrapMemSetDebugMode",
	"a038 sysTrapMemHeapScramble",
	"a039 sysTrapMemHeapCheck",
	"a03a sysTrapMemNumCards",
	"a03b sysTrapMemDebugMode",
	"a03c sysTrapMemSemaphoreReserve",
	"a03d sysTrapMemSemaphoreRelease",
	"a03e sysTrapMemHeapDynamic",
	"a03f sysTrapMemNVParams",
	"a040 sysTrapDmInit",
	"a041 sysTrapDmCreateDatabase",
	"a042 sysTrapDmDeleteDatabase",
	"a043 sysTrapDmNumDatabases",
	"a044 sysTrapDmGetDatabase",
	"a045 sysTrapDmFindDatabase",
	"a046 sysTrapDmDatabaseInfo",
	"a047 sysTrapDmSetDatabaseInfo",
	"a048 sysTrapDmDatabaseSize",
	"a049 sysTrapDmOpenDatabase",
	"a04a sysTrapDmCloseDatabase",
	"a04b sysTrapDmNextOpenDatabase",
	"a04c sysTrapDmOpenDatabaseInfo",
	"a04d sysTrapDmResetRecordStates",
	"a04e sysTrapDmGetLastErr",
	"a04f sysTrapDmNumRecords",
	"a050 sysTrapDmRecordInfo",
	"a051 sysTrapDmSetRecordInfo",
	"a052 sysTrapDmAttachRecord",
	"a053 sysTrapDmDetachRecord",
	"a054 sysTrapDmMoveRecord",
	"a055 sysTrapDmNewRecord",
	"a056 sysTrapDmRemoveRecord",
	"a057 sysTrapDmDeleteRecord",
	"a058 sysTrapDmArchiveRecord",
	"a059 sysTrapDmNewHandle",
	"a05a sysTrapDmRemoveSecretRecords",
	"a05b sysTrapDmQueryRecord",
	"a05c sysTrapDmGetRecord",
	"a05d sysTrapDmResizeRecord",
	"a05e sysTrapDmReleaseRecord",
	"a05f sysTrapDmGetResource",
	"a060 sysTrapDmGet1Resource",
	"a061 sysTrapDmReleaseResource",
	"a062 sysTrapDmResizeResource",
	"a063 sysTrapDmNextOpenResDatabase",
	"a064 sysTrapDmFindResourceType",
	"a065 sysTrapDmFindResource",
	"a066 sysTrapDmSearchResource",
	"a067 sysTrapDmNumResources",
	"a068 sysTrapDmResourceInfo",
	"a069 sysTrapDmSetResourceInfo",
	"a06a sysTrapDmAttachResource",
	"a06b sysTrapDmDetachResource",
	"a06c sysTrapDmNewResource",
	"a06d sysTrapDmRemoveResource",
	"a06e sysTrapDmGetResourceIndex",
	"a06f sysTrapDmQuickSort",
	"a070 sysTrapDmQueryNextInCategory",
	"a071 sysTrapDmNumRecordsInCategory",
	"a072 sysTrapDmPositionInCategory",
	"a073 sysTrapDmSeekRecordInCategory",
	"a074 sysTrapDmMoveCategory",
	"a075 sysTrapDmOpenDatabaseByTypeCreator",
	"a076 sysTrapDmWrite",
	"a077 sysTrapDmStrCopy",
	"a078 sysTrapDmGetNextDatabaseByTypeCreator",
	"a079 sysTrapDmWriteCheck",
	"a07a sysTrapDmMoveOpenDBContext",
	"a07b sysTrapDmFindRecordByID",
	"a07c sysTrapDmGetAppInfoID",
	"a07d sysTrapDmFindSortPositionV10",
	"a07e sysTrapDmSet",
	"a07f sysTrapDmCreateDatabaseFromImage",
	"a080 sysTrapDbgSrcMessage",
	"a081 sysTrapDbgMessage",
	"a082 sysTrapDbgGetMessage",
	"a083 sysTrapDbgCommSettings",
	"a084 sysTrapErrDisplayFileLineMsg",
	"a085 sysTrapErrSetJump",
	"a086 sysTrapErrLongJump",
	"a087 sysTrapErrThrow",
	"a088 sysTrapErrExceptionList",
	"a089 sysTrapSysBroadcastActionCode",
	"a08a sysTrapSysUnimplemented",
	"a08b sysTrapSysColdBoot",
	"a08c sysTrapSysReset",
	"a08d sysTrapSysDoze",
	"a08e sysTrapSysAppLaunch",
	"a08f sysTrapSysAppStartup",
	"a090 sysTrapSysAppExit",
	"a091 sysTrapSysSetA5",
	"a092 sysTrapSysSetTrapAddress",
	"a093 sysTrapSysGetTrapAddress",
	"a094 sysTrapSysTranslateKernelErr",
	"a095 sysTrapSysSemaphoreCreate",
	"a096 sysTrapSysSemaphoreDelete",
	"a097 sysTrapSysSemaphoreWait",
	"a098 sysTrapSysSemaphoreSignal",
	"a099 sysTrapSysTimerCreate",
	"a09a sysTrapSysTimerWrite",
	"a09b sysTrapSysTaskCreate",
	"a09c sysTrapSysTaskDelete",
	"a09d sysTrapSysTaskTrigger",
	"a09e sysTrapSysTaskID",
	"a09f sysTrapSysTaskUserInfoPtr",
	"a0a0 sysTrapSysTaskDelay",
	"a0a1 sysTrapSysTaskSetTermProc",
	"a0a2 sysTrapSysUILaunch",
	"a0a3 sysTrapSysNewOwnerID",
	"a0a4 sysTrapSysSemaphoreSet",
	"a0a5 sysTrapSysDisableInts",
	"a0a6 sysTrapSysRestoreStatus",
	"a0a7 sysTrapSysUIAppSwitch",
	"a0a8 sysTrapSysCurAppInfoPV20",
	"a0a9 sysTrapSysHandleEvent",
	"a0aa sysTrapSysInit",
	"a0ab sysTrapSysQSort",
	"a0ac sysTrapSysCurAppDatabase",
	"a0ad sysTrapSysFatalAlert",
	"a0ae sysTrapSysResSemaphoreCreate",
	"a0af sysTrapSysResSemaphoreDelete",
	"a0b0 sysTrapSysResSemaphoreReserve",
	"a0b1 sysTrapSysResSemaphoreRelease",
	"a0b2 sysTrapSysSleep",
	"a0b3 sysTrapSysKeyboardDialogV10",
	"a0b4 sysTrapSysAppLauncherDialog",
	"a0b5 sysTrapSysSetPerformance",
	"a0b6 sysTrapSysBatteryInfoV20",
	"a0b7 sysTrapSysLibInstall",
	"a0b8 sysTrapSysLibRemove",
	"a0b9 sysTrapSysLibTblEntry",
	"a0ba sysTrapSysLibFind",
	"a0bb sysTrapSysBatteryDialog",
	"a0bc sysTrapSysCopyStringResource",
	"a0bd sysTrapSysKernelInfo",
	"a0be sysTrapSysLaunchConsole",
	"a0bf sysTrapSysTimerDelete",
	"a0c0 sysTrapSysSetAutoOffTime",
	"a0c1 sysTrapSysFormPointerArrayToStrings",
	"a0c2 sysTrapSysRandom",
	"a0c3 sysTrapSysTaskSwitching",
	"a0c4 sysTrapSysTimerRead",
	"a0c5 sysTrapStrCopy",
	"a0c6 sysTrapStrCat",
	"a0c7 sysTrapStrLen",
	"a0c8 sysTrapStrCompare",
	"a0c9 sysTrapStrIToA",
	"a0ca sysTrapStrCaselessCompare",
	"a0cb sysTrapStrIToH",
	"a0cc sysTrapStrChr",
	"a0cd sysTrapStrStr",
	"a0ce sysTrapStrAToI",
	"a0cf sysTrapStrToLower",
	"a0d0 sysTrapSerReceiveISP",
	"a0d1 sysTrapSlkOpen",
	"a0d2 sysTrapSlkClose",
	"a0d3 sysTrapSlkOpenSocket",
	"a0d4 sysTrapSlkCloseSocket",
	"a0d5 sysTrapSlkSocketRefNum",
	"a0d6 sysTrapSlkSocketSetTimeout",
	"a0d7 sysTrapSlkFlushSocket",
	"a0d8 sysTrapSlkSetSocketListener",
	"a0d9 sysTrapSlkSendPacket",
	"a0da sysTrapSlkReceivePacket",
	"a0db sysTrapSlkSysPktDefaultResponse",
	"a0dc sysTrapSlkProcessRPC",
	"a0dd sysTrapConPutS",
	"a0de sysTrapConGetS",
	"a0df sysTrapFplInit",
	"a0e0 sysTrapFplFree",
	"a0e1 sysTrapFplFToA",
	"a0e2 sysTrapFplAToF",
	"a0e3 sysTrapFplBase10Info",
	"a0e4 sysTrapFplLongToFloat",
	"a0e5 sysTrapFplFloatToLong",
	"a0e6 sysTrapFplFloatToULong",
	"a0e7 sysTrapFplMul",
	"a0e8 sysTrapFplAdd",
	"a0e9 sysTrapFplSub",
	"a0ea sysTrapFplDiv",
	"a0eb sysTrapWinScreenInit",
	"a0ec sysTrapScrCopyRectangle",
	"a0ed sysTrapScrDrawChars",
	"a0ee sysTrapScrLineRoutine",
	"a0ef sysTrapScrRectangleRoutine",
	"a0f0 sysTrapScrScreenInfo",
	"a0f1 sysTrapScrDrawNotify",
	"a0f2 sysTrapScrSendUpdateArea",
	"a0f3 sysTrapScrCompressScanLine",
	"a0f4 sysTrapScrDeCompressScanLine",
	"a0f5 sysTrapTimGetSeconds",
	"a0f6 sysTrapTimSetSeconds",
	"a0f7 sysTrapTimGetTicks",
	"a0f8 sysTrapTimInit",
	"a0f9 sysTrapTimSetAlarm",
	"a0fa sysTrapTimGetAlarm",
	"a0fb sysTrapTimHandleInterrupt",
	"a0fc sysTrapTimSecondsToDateTime",
	"a0fd sysTrapTimDateTimeToSeconds",
	"a0fe sysTrapTimAdjust",
	"a0ff sysTrapTimSleep",
	"a100 sysTrapTimWake",
	"a101 sysTrapCategoryCreateListV10",
	"a102 sysTrapCategoryFreeListV10",
	"a103 sysTrapCategoryFind",
	"a104 sysTrapCategoryGetName",
	"a105 sysTrapCategoryEditV10",
	"a106 sysTrapCategorySelectV10",
	"a107 sysTrapCategoryGetNext",
	"a108 sysTrapCategorySetTriggerLabel",
	"a109 sysTrapCategoryTruncateName",
	"a10a sysTrapClipboardAddItem",
	"a10b sysTrapClipboardCheckIfItemExist",
	"a10c sysTrapClipboardGetItem",
	"a10d sysTrapCtlDrawControl",
	"a10e sysTrapCtlEraseControl",
	"a10f sysTrapCtlHideControl",
	"a110 sysTrapCtlShowControl",
	"a111 sysTrapCtlGetValue",
	"a112 sysTrapCtlSetValue",
	"a113 sysTrapCtlGetLabel",
	"a114 sysTrapCtlSetLabel",
	"a115 sysTrapCtlHandleEvent",
	"a116 sysTrapCtlHitControl",
	"a117 sysTrapCtlSetEnabled",
	"a118 sysTrapCtlSetUsable",
	"a119 sysTrapCtlEnabled",
	"a11a sysTrapEvtInitialize",
	"a11b sysTrapEvtAddEventToQueue",
	"a11c sysTrapEvtCopyEvent",
	"a11d sysTrapEvtGetEvent",
	"a11e sysTrapEvtGetPen",
	"a11f sysTrapEvtSysInit",
	"a120 sysTrapEvtGetSysEvent",
	"a121 sysTrapEvtProcessSoftKeyStroke",
	"a122 sysTrapEvtGetPenBtnList",
	"a123 sysTrapEvtSetPenQueuePtr",
	"a124 sysTrapEvtPenQueueSize",
	"a125 sysTrapEvtFlushPenQueue",
	"a126 sysTrapEvtEnqueuePenPoint",
	"a127 sysTrapEvtDequeuePenStrokeInfo",
	"a128 sysTrapEvtDequeuePenPoint",
	"a129 sysTrapEvtFlushNextPenStroke",
	"a12a sysTrapEvtSetKeyQueuePtr",
	"a12b sysTrapEvtKeyQueueSize",
	"a12c sysTrapEvtFlushKeyQueue",
	"a12d sysTrapEvtEnqueueKey",
	"a12e sysTrapEvtDequeueKeyEvent",
	"a12f sysTrapEvtWakeup",
	"a130 sysTrapEvtResetAutoOffTimer",
	"a131 sysTrapEvtKeyQueueEmpty",
	"a132 sysTrapEvtEnableGraffiti",
	"a133 sysTrapFldCopy",
	"a134 sysTrapFldCut",
	"a135 sysTrapFldDrawField",
	"a136 sysTrapFldEraseField",
	"a137 sysTrapFldFreeMemory",
	"a138 sysTrapFldGetBounds",
	"a139 sysTrapFldGetTextPtr",
	"a13a sysTrapFldGetSelection",
	"a13b sysTrapFldHandleEvent",
	"a13c sysTrapFldPaste",
	"a13d sysTrapFldRecalculateField",
	"a13e sysTrapFldSetBounds",
	"a13f sysTrapFldSetText",
	"a140 sysTrapFldGetFont",
	"a141 sysTrapFldSetFont",
	"a142 sysTrapFldSetSelection",
	"a143 sysTrapFldGrabFocus",
	"a144 sysTrapFldReleaseFocus",
	"a145 sysTrapFldGetInsPtPosition",
	"a146 sysTrapFldSetInsPtPosition",
	"a147 sysTrapFldSetScrollPosition",
	"a148 sysTrapFldGetScrollPosition",
	"a149 sysTrapFldGetTextHeight",
	"a14a sysTrapFldGetTextAllocatedSize",
	"a14b sysTrapFldGetTextLength",
	"a14c sysTrapFldScrollField",
	"a14d sysTrapFldScrollable",
	"a14e sysTrapFldGetVisibleLines",
	"a14f sysTrapFldGetAttributes",
	"a150 sysTrapFldSetAttributes",
	"a151 sysTrapFldSendChangeNotification",
	"a152 sysTrapFldCalcFieldHeight",
	"a153 sysTrapFldGetTextHandle",
	"a154 sysTrapFldCompactText",
	"a155 sysTrapFldDirty",
	"a156 sysTrapFldWordWrap",
	"a157 sysTrapFldSetTextAllocatedSize",
	"a158 sysTrapFldSetTextHandle",
	"a159 sysTrapFldSetTextPtr",
	"a15a sysTrapFldGetMaxChars",
	"a15b sysTrapFldSetMaxChars",
	"a15c sysTrapFldSetUsable",
	"a15d sysTrapFldInsert",
	"a15e sysTrapFldDelete",
	"a15f sysTrapFldUndo",
	"a160 sysTrapFldSetDirty",
	"a161 sysTrapFldSendHeightChangeNotification",
	"a162 sysTrapFldMakeFullyVisible",
	"a163 sysTrapFntGetFont",
	"a164 sysTrapFntSetFont",
	"a165 sysTrapFntGetFontPtr",
	"a166 sysTrapFntBaseLine",
	"a167 sysTrapFntCharHeight",
	"a168 sysTrapFntLineHeight",
	"a169 sysTrapFntAverageCharWidth",
	"a16a sysTrapFntCharWidth",
	"a16b sysTrapFntCharsWidth",
	"a16c sysTrapFntDescenderHeight",
	"a16d sysTrapFntCharsInWidth",
	"a16e sysTrapFntLineWidth",
	"a16f sysTrapFrmInitForm",
	"a170 sysTrapFrmDeleteForm",
	"a171 sysTrapFrmDrawForm",
	"a172 sysTrapFrmEraseForm",
	"a173 sysTrapFrmGetActiveForm",
	"a174 sysTrapFrmSetActiveForm",
	"a175 sysTrapFrmGetActiveFormID",
	"a176 sysTrapFrmGetUserModifiedState",
	"a177 sysTrapFrmSetNotUserModified",
	"a178 sysTrapFrmGetFocus",
	"a179 sysTrapFrmSetFocus",
	"a17a sysTrapFrmHandleEvent",
	"a17b sysTrapFrmGetFormBounds",
	"a17c sysTrapFrmGetWindowHandle",
	"a17d sysTrapFrmGetFormId",
	"a17e sysTrapFrmGetFormPtr",
	"a17f sysTrapFrmGetNumberOfObjects",
	"a180 sysTrapFrmGetObjectIndex",
	"a181 sysTrapFrmGetObjectId",
	"a182 sysTrapFrmGetObjectType",
	"a183 sysTrapFrmGetObjectPtr",
	"a184 sysTrapFrmHideObject",
	"a185 sysTrapFrmShowObject",
	"a186 sysTrapFrmGetObjectPosition",
	"a187 sysTrapFrmSetObjectPosition",
	"a188 sysTrapFrmGetControlValue",
	"a189 sysTrapFrmSetControlValue",
	"a18a sysTrapFrmGetControlGroupSelection",
	"a18b sysTrapFrmSetControlGroupSelection",
	"a18c sysTrapFrmCopyLabel",
	"a18d sysTrapFrmSetLabel",
	"a18e sysTrapFrmGetLabel",
	"a18f sysTrapFrmSetCategoryLabel",
	"a190 sysTrapFrmGetTitle",
	"a191 sysTrapFrmSetTitle",
	"a192 sysTrapFrmAlert",
	"a193 sysTrapFrmDoDialog",
	"a194 sysTrapFrmCustomAlert",
	"a195 sysTrapFrmHelp",
	"a196 sysTrapFrmUpdateScrollers",
	"a197 sysTrapFrmGetFirstForm",
	"a198 sysTrapFrmVisible",
	"a199 sysTrapFrmGetObjectBounds",
	"a19a sysTrapFrmCopyTitle",
	"a19b sysTrapFrmGotoForm",
	"a19c sysTrapFrmPopupForm",
	"a19d sysTrapFrmUpdateForm",
	"a19e sysTrapFrmReturnToForm",
	"a19f sysTrapFrmSetEventHandler",
	"a1a0 sysTrapFrmDispatchEvent",
	"a1a1 sysTrapFrmCloseAllForms",
	"a1a2 sysTrapFrmSaveAllForms",
	"a1a3 sysTrapFrmGetGadgetData",
	"a1a4 sysTrapFrmSetGadgetData",
	"a1a5 sysTrapFrmSetCategoryTrigger",
	"a1a6 sysTrapUIInitialize",
	"a1a7 sysTrapUIReset",
	"a1a8 sysTrapInsPtInitialize",
	"a1a9 sysTrapInsPtSetLocation",
	"a1aa sysTrapInsPtGetLocation",
	"a1ab sysTrapInsPtEnable",
	"a1ac sysTrapInsPtEnabled",
	"a1ad sysTrapInsPtSetHeight",
	"a1ae sysTrapInsPtGetHeight",
	"a1af sysTrapInsPtCheckBlink",
	"a1b0 sysTrapLstSetDrawFunction",
	"a1b1 sysTrapLstDrawList",
	"a1b2 sysTrapLstEraseList",
	"a1b3 sysTrapLstGetSelection",
	"a1b4 sysTrapLstGetSelectionText",
	"a1b5 sysTrapLstHandleEvent",
	"a1b6 sysTrapLstSetHeight",
	"a1b7 sysTrapLstSetSelection",
	"a1b8 sysTrapLstSetListChoices",
	"a1b9 sysTrapLstMakeItemVisible",
	"a1ba sysTrapLstGetNumberOfItems",
	"a1bb sysTrapLstPopupList",
	"a1bc sysTrapLstSetPosition",
	"a1bd sysTrapMenuInit",
	"a1be sysTrapMenuDispose",
	"a1bf sysTrapMenuHandleEvent",
	"a1c0 sysTrapMenuDrawMenu",
	"a1c1 sysTrapMenuEraseStatus",
	"a1c2 sysTrapMenuGetActiveMenu",
	"a1c3 sysTrapMenuSetActiveMenu",
	"a1c4 sysTrapRctSetRectangle",
	"a1c5 sysTrapRctCopyRectangle",
	"a1c6 sysTrapRctInsetRectangle",
	"a1c7 sysTrapRctOffsetRectangle",
	"a1c8 sysTrapRctPtInRectangle",
	"a1c9 sysTrapRctGetIntersection",
	"a1ca sysTrapTblDrawTable",
	"a1cb sysTrapTblEraseTable",
	"a1cc sysTrapTblHandleEvent",
	"a1cd sysTrapTblGetItemBounds",
	"a1ce sysTrapTblSelectItem",
	"a1cf sysTrapTblGetItemInt",
	"a1d0 sysTrapTblSetItemInt",
	"a1d1 sysTrapTblSetItemStyle",
	"a1d2 sysTrapTblUnhighlightSelection",
	"a1d3 sysTrapTblSetRowUsable",
	"a1d4 sysTrapTblGetNumberOfRows",
	"a1d5 sysTrapTblSetCustomDrawProcedure",
	"a1d6 sysTrapTblSetRowSelectable",
	"a1d7 sysTrapTblRowSelectable",
	"a1d8 sysTrapTblSetLoadDataProcedure",
	"a1d9 sysTrapTblSetSaveDataProcedure",
	"a1da sysTrapTblGetBounds",
	"a1db sysTrapTblSetRowHeight",
	"a1dc sysTrapTblGetColumnWidth",
	"a1dd sysTrapTblGetRowID",
	"a1de sysTrapTblSetRowID",
	"a1df sysTrapTblMarkRowInvalid",
	"a1e0 sysTrapTblMarkTableInvalid",
	"a1e1 sysTrapTblGetSelection",
	"a1e2 sysTrapTblInsertRow",
	"a1e3 sysTrapTblRemoveRow",
	"a1e4 sysTrapTblRowInvalid",
	"a1e5 sysTrapTblRedrawTable",
	"a1e6 sysTrapTblRowUsable",
	"a1e7 sysTrapTblReleaseFocus",
	"a1e8 sysTrapTblEditing",
	"a1e9 sysTrapTblGetCurrentField",
	"a1ea sysTrapTblSetColumnUsable",
	"a1eb sysTrapTblGetRowHeight",
	"a1ec sysTrapTblSetColumnWidth",
	"a1ed sysTrapTblGrabFocus",
	"a1ee sysTrapTblSetItemPtr",
	"a1ef sysTrapTblFindRowID",
	"a1f0 sysTrapTblGetLastUsableRow",
	"a1f1 sysTrapTblGetColumnSpacing",
	"a1f2 sysTrapTblFindRowData",
	"a1f3 sysTrapTblGetRowData",
	"a1f4 sysTrapTblSetRowData",
	"a1f5 sysTrapTblSetColumnSpacing",
	"a1f6 sysTrapWinCreateWindow",
	"a1f7 sysTrapWinCreateOffscreenWindow",
	"a1f8 sysTrapWinDeleteWindow",
	"a1f9 sysTrapWinInitializeWindow",
	"a1fa sysTrapWinAddWindow",
	"a1fb sysTrapWinRemoveWindow",
	"a1fc sysTrapWinSetActiveWindow",
	"a1fd sysTrapWinSetDrawWindow",
	"a1fe sysTrapWinGetDrawWindow",
	"a1ff sysTrapWinGetActiveWindow",
	"a200 sysTrapWinGetDisplayWindow",
	"a201 sysTrapWinGetFirstWindow",
	"a202 sysTrapWinEnableWindow",
	"a203 sysTrapWinDisableWindow",
	"a204 sysTrapWinGetWindowFrameRect",
	"a205 sysTrapWinDrawWindowFrame",
	"a206 sysTrapWinEraseWindow",
	"a207 sysTrapWinSaveBits",
	"a208 sysTrapWinRestoreBits",
	"a209 sysTrapWinCopyRectangle",
	"a20a sysTrapWinScrollRectangle",
	"a20b sysTrapWinGetDisplayExtent",
	"a20c sysTrapWinGetWindowExtent",
	"a20d sysTrapWinDisplayToWindowPt",
	"a20e sysTrapWinWindowToDisplayPt",
	"a20f sysTrapWinGetClip",
	"a210 sysTrapWinSetClip",
	"a211 sysTrapWinResetClip",
	"a212 sysTrapWinClipRectangle",
	"a213 sysTrapWinDrawLine",
	"a214 sysTrapWinDrawGrayLine",
	"a215 sysTrapWinEraseLine",
	"a216 sysTrapWinInvertLine",
	"a217 sysTrapWinFillLine",
	"a218 sysTrapWinDrawRectangle",
	"a219 sysTrapWinEraseRectangle",
	"a21a sysTrapWinInvertRectangle",
	"a21b sysTrapWinDrawRectangleFrame",
	"a21c sysTrapWinDrawGrayRectangleFrame",
	"a21d sysTrapWinEraseRectangleFrame",
	"a21e sysTrapWinInvertRectangleFrame",
	"a21f sysTrapWinGetFramesRectangle",
	"a220 sysTrapWinDrawChars",
	"a221 sysTrapWinEraseChars",
	"a222 sysTrapWinInvertChars",
	"a223 sysTrapWinGetPattern",
	"a224 sysTrapWinSetPattern",
	"a225 sysTrapWinSetUnderlineMode",
	"a226 sysTrapWinDrawBitmap",
	"a227 sysTrapWinModal",
	"a228 sysTrapWinGetWindowBounds",
	"a229 sysTrapWinFillRectangle",
	"a22a sysTrapWinDrawInvertedChars",
	"a22b sysTrapPrefOpenPreferenceDBV10",
	"a22c sysTrapPrefGetPreferences",
	"a22d sysTrapPrefSetPreferences",
	"a22e sysTrapPrefGetAppPreferencesV10",
	"a22f sysTrapPrefSetAppPreferencesV10",
	"a230 sysTrapSndInit",
	"a231 sysTrapSndSetDefaultVolume",
	"a232 sysTrapSndGetDefaultVolume",
	"a233 sysTrapSndDoCmd",
	"a234 sysTrapSndPlaySystemSound",
	"a235 sysTrapAlmInit",
	"a236 sysTrapAlmCancelAll",
	"a237 sysTrapAlmAlarmCallback",
	"a238 sysTrapAlmSetAlarm",
	"a239 sysTrapAlmGetAlarm",
	"a23a sysTrapAlmDisplayAlarm",
	"a23b sysTrapAlmEnableNotification",
	"a23c sysTrapHwrGetRAMMapping",
	"a23d sysTrapHwrMemWritable",
	"a23e sysTrapHwrMemReadable",
	"a23f sysTrapHwrDoze",
	"a240 sysTrapHwrSleep",
	"a241 sysTrapHwrWake",
	"a242 sysTrapHwrSetSystemClock",
	"a243 sysTrapHwrSetCPUDutyCycle",
	"a244 sysTrapHwrDisplayInit",
	"a245 sysTrapHwrDisplaySleep",
	"a246 sysTrapHwrTimerInit",
	"a247 sysTrapHwrCursorV33",
	"a248 sysTrapHwrBatteryLevel",
	"a249 sysTrapHwrDelay",
	"a24a sysTrapHwrEnableDataWrites",
	"a24b sysTrapHwrDisableDataWrites",
	"a24c sysTrapHwrLCDBaseAddrV33",
	"a24d sysTrapHwrDisplayDrawBootScreen",
	"a24e sysTrapHwrTimerSleep",
	"a24f sysTrapHwrTimerWake",
	"a250 sysTrapHwrDisplayWake",
	"a251 sysTrapHwrIRQ1Handler",
	"a252 sysTrapHwrIRQ2Handler",
	"a253 sysTrapHwrIRQ3Handler",
	"a254 sysTrapHwrIRQ4Handler",
	"a255 sysTrapHwrIRQ5Handler",
	"a256 sysTrapHwrIRQ6Handler",
	"a257 sysTrapHwrDockSignals",
	"a258 sysTrapHwrPluggedIn",
	"a259 sysTrapCrc16CalcBlock",
	"a25a sysTrapSelectDayV10",
	"a25b sysTrapSelectTimeV33",
	"a25c sysTrapDayDrawDaySelector",
	"a25d sysTrapDayHandleEvent",
	"a25e sysTrapDayDrawDays",
	"a25f sysTrapDayOfWeek",
	"a260 sysTrapDaysInMonth",
	"a261 sysTrapDayOfMonth",
	"a262 sysTrapDateDaysToDate",
	"a263 sysTrapDateToDays",
	"a264 sysTrapDateAdjust",
	"a265 sysTrapDateSecondsToDate",
	"a266 sysTrapDateToAscii",
	"a267 sysTrapDateToDOWDMFormat",
	"a268 sysTrapTimeToAscii",
	"a269 sysTrapFind",
	"a26a sysTrapFindStrInStr",
	"a26b sysTrapFindSaveMatch",
	"a26c sysTrapFindGetLineBounds",
	"a26d sysTrapFindDrawHeader",
	"a26e sysTrapPenOpen",
	"a26f sysTrapPenClose",
	"a270 sysTrapPenGetRawPen",
	"a271 sysTrapPenCalibrate",
	"a272 sysTrapPenRawToScreen",
	"a273 sysTrapPenScreenToRaw",
	"a274 sysTrapPenResetCalibration",
	"a275 sysTrapPenSleep",
	"a276 sysTrapPenWake",
	"a277 sysTrapResLoadForm",
	"a278 sysTrapResLoadMenu",
	"a279 sysTrapFtrInit",
	"a27a sysTrapFtrUnregister",
	"a27b sysTrapFtrGet",
	"a27c sysTrapFtrSet",
	"a27d sysTrapFtrGetByIndex",
	"a27e sysTrapGrfInit",
	"a27f sysTrapGrfFree",
	"a280 sysTrapGrfGetState",
	"a281 sysTrapGrfSetState",
	"a282 sysTrapGrfFlushPoints",
	"a283 sysTrapGrfAddPoint",
	"a284 sysTrapGrfInitState",
	"a285 sysTrapGrfCleanState",
	"a286 sysTrapGrfMatch",
	"a287 sysTrapGrfGetMacro",
	"a288 sysTrapGrfFilterPoints",
	"a289 sysTrapGrfGetNumPoints",
	"a28a sysTrapGrfGetPoint",
	"a28b sysTrapGrfFindBranch",
	"a28c sysTrapGrfMatchGlyph",
	"a28d sysTrapGrfGetGlyphMapping",
	"a28e sysTrapGrfGetMacroName",
	"a28f sysTrapGrfDeleteMacro",
	"a290 sysTrapGrfAddMacro",
	"a291 sysTrapGrfGetAndExpandMacro",
	"a292 sysTrapGrfProcessStroke",
	"a293 sysTrapGrfFieldChange",
	"a294 sysTrapGetCharSortValue",
	"a295 sysTrapGetCharAttr",
	"a296 sysTrapGetCharCaselessValue",
	"a297 sysTrapPwdExists",
	"a298 sysTrapPwdVerify",
	"a299 sysTrapPwdSet",
	"a29a sysTrapPwdRemove",
	"a29b sysTrapGsiInitialize",
	"a29c sysTrapGsiSetLocation",
	"a29d sysTrapGsiEnable",
	"a29e sysTrapGsiEnabled",
	"a29f sysTrapGsiSetShiftState",
	"a2a0 sysTrapKeyInit",
	"a2a1 sysTrapKeyHandleInterrupt",
	"a2a2 sysTrapKeyCurrentState",
	"a2a3 sysTrapKeyResetDoubleTap",
	"a2a4 sysTrapKeyRates",
	"a2a5 sysTrapKeySleep",
	"a2a6 sysTrapKeyWake",
	"a2a7 sysTrapDlkControl",
	"a2a8 sysTrapDlkStartServer",
	"a2a9 sysTrapDlkGetSyncInfo",
	"a2aa sysTrapDlkSetLogEntry",
	"a2ab sysTrapIntlDispatch",
	"a2ac sysTrapSysLibLoad",
	"a2ad sysTrapSndPlaySmf",
	"a2ae sysTrapSndCreateMidiList",
	"a2af sysTrapAbtShowAbout",
	"a2b0 sysTrapMdmDial",
	"a2b1 sysTrapMdmHangUp",
	"a2b2 sysTrapDmSearchRecord",
	"a2b3 sysTrapSysInsertionSort",
	"a2b4 sysTrapDmInsertionSort",
	"a2b5 sysTrapLstSetTopItem",
	"a2b6 sysTrapSclSetScrollBar",
	"a2b7 sysTrapSclDrawScrollBar",
	"a2b8 sysTrapSclHandleEvent",
	"a2b9 sysTrapSysMailboxCreate",
	"a2ba sysTrapSysMailboxDelete",
	"a2bb sysTrapSysMailboxFlush",
	"a2bc sysTrapSysMailboxSend",
	"a2bd sysTrapSysMailboxWait",
	"a2be sysTrapSysTaskWait",
	"a2bf sysTrapSysTaskWake",
	"a2c0 sysTrapSysTaskWaitClr",
	"a2c1 sysTrapSysTaskSuspend",
	"a2c2 sysTrapSysTaskResume",
	"a2c3 sysTrapCategoryCreateList",
	"a2c4 sysTrapCategoryFreeList",
	"a2c5 sysTrapCategoryEditV20",
	"a2c6 sysTrapCategorySelect",
	"a2c7 sysTrapDmDeleteCategory",
	"a2c8 sysTrapSysEvGroupCreate",
	"a2c9 sysTrapSysEvGroupSignal",
	"a2ca sysTrapSysEvGroupRead",
	"a2cb sysTrapSysEvGroupWait",
	"a2cc sysTrapEvtEventAvail",
	"a2cd sysTrapEvtSysEventAvail",
	"a2ce sysTrapStrNCopy",
	"a2cf sysTrapKeySetMask",
	"a2d0 sysTrapSelectDay",
	"a2d1 sysTrapPrefGetPreference",
	"a2d2 sysTrapPrefSetPreference",
	"a2d3 sysTrapPrefGetAppPreferences",
	"a2d4 sysTrapPrefSetAppPreferences",
	"a2d5 sysTrapFrmPointInTitle",
	"a2d6 sysTrapStrNCat",
	"a2d7 sysTrapMemCmp",
	"a2d8 sysTrapTblSetColumnEditIndicator",
	"a2d9 sysTrapFntWordWrap",
	"a2da sysTrapFldGetScrollValues",
	"a2db sysTrapSysCreateDataBaseList",
	"a2dc sysTrapSysCreatePanelList",
	"a2dd sysTrapDlkDispatchRequest",
	"a2de sysTrapStrPrintF",
	"a2df sysTrapStrVPrintF",
	"a2e0 sysTrapPrefOpenPreferenceDB",
	"a2e1 sysTrapSysGraffitiReferenceDialog",
	"a2e2 sysTrapSysKeyboardDialog",
	"a2e3 sysTrapFntWordWrapReverseNLines",
	"a2e4 sysTrapFntGetScrollValues",
	"a2e5 sysTrapTblSetRowStaticHeight",
	"a2e6 sysTrapTblHasScrollBar",
	"a2e7 sysTrapSclGetScrollBar",
	"a2e8 sysTrapFldGetNumberOfBlankLines",
	"a2e9 sysTrapSysTicksPerSecond",
	"a2ea sysTrapHwrBacklightV33",
	"a2eb sysTrapDmDatabaseProtect",
	"a2ec sysTrapTblSetBounds",
	"a2ed sysTrapStrNCompare",
	"a2ee sysTrapStrNCaselessCompare",
	"a2ef sysTrapPhoneNumberLookup",
	"a2f0 sysTrapFrmSetMenu",
	"a2f1 sysTrapEncDigestMD5",
	"a2f2 sysTrapDmFindSortPosition",
	"a2f3 sysTrapSysBinarySearch",
	"a2f4 sysTrapSysErrString",
	"a2f5 sysTrapSysStringByIndex",
	"a2f6 sysTrapEvtAddUniqueEventToQueue",
	"a2f7 sysTrapStrLocalizeNumber",
	"a2f8 sysTrapStrDelocalizeNumber",
	"a2f9 sysTrapLocGetNumberSeparators",
	"a2fa sysTrapMenuSetActiveMenuRscID",
	"a2fb sysTrapLstScrollList",
	"a2fc sysTrapCategoryInitialize",
	"a2fd sysTrapEncDigestMD4",
	"a2fe sysTrapEncDES",
	"a2ff sysTrapLstGetVisibleItems",
	"a300 sysTrapWinSetWindowBounds",
	"a301 sysTrapCategorySetName",
	"a302 sysTrapFldSetInsertionPoint",
	"a303 sysTrapFrmSetObjectBounds",
	"a304 sysTrapWinSetColors",
	"a305 sysTrapFlpDispatch",
	"a306 sysTrapFlpEmDispatch",
	"a307 sysTrapExgInit",
	"a308 sysTrapExgConnect",
	"a309 sysTrapExgPut",
	"a30a sysTrapExgGet",
	"a30b sysTrapExgAccept",
	"a30c sysTrapExgDisconnect",
	"a30d sysTrapExgSend",
	"a30e sysTrapExgReceive",
	"a30f sysTrapExgRegisterData",
	"a310 sysTrapExgNotifyReceive",
	"a311 sysTrapExgControl",
	"a312 sysTrapPrgStartDialogV31",
	"a313 sysTrapPrgStopDialog",
	"a314 sysTrapPrgUpdateDialog",
	"a315 sysTrapPrgHandleEvent",
	"a316 sysTrapImcReadFieldNoSemicolon",
	"a317 sysTrapImcReadFieldQuotablePrintable",
	"a318 sysTrapImcReadPropertyParameter",
	"a319 sysTrapImcSkipAllPropertyParameters",
	"a31a sysTrapImcReadWhiteSpace",
	"a31b sysTrapImcWriteQuotedPrintable",
	"a31c sysTrapImcWriteNoSemicolon",
	"a31d sysTrapImcStringIsAscii",
	"a31e sysTrapTblGetItemFont",
	"a31f sysTrapTblSetItemFont",
	"a320 sysTrapFontSelect",
	"a321 sysTrapFntDefineFont",
	"a322 sysTrapCategoryEdit",
	"a323 sysTrapSysGetOSVersionString",
	"a324 sysTrapSysBatteryInfo",
	"a325 sysTrapSysUIBusy",
	"a326 sysTrapWinValidateHandle",
	"a327 sysTrapFrmValidatePtr",
	"a328 sysTrapCtlValidatePointer",
	"a329 sysTrapWinMoveWindowAddr",
	"a32a sysTrapFrmAddSpaceForObject",
	"a32b sysTrapFrmNewForm",
	"a32c sysTrapCtlNewControl",
	"a32d sysTrapFldNewField",
	"a32e sysTrapLstNewList",
	"a32f sysTrapFrmNewLabel",
	"a330 sysTrapFrmNewBitmap",
	"a331 sysTrapFrmNewGadget",
	"a332 sysTrapFileOpen",
	"a333 sysTrapFileClose",
	"a334 sysTrapFileDelete",
	"a335 sysTrapFileReadLow",
	"a336 sysTrapFileWrite",
	"a337 sysTrapFileSeek",
	"a338 sysTrapFileTell",
	"a339 sysTrapFileTruncate",
	"a33a sysTrapFileControl",
	"a33b sysTrapFrmActiveState",
	"a33c sysTrapSysGetAppInfo",
	"a33d sysTrapSysGetStackInfo",
	"a33e sysTrapWinScreenMode",
	"a33f sysTrapHwrLCDGetDepthV33",
	"a340 sysTrapHwrGetROMToken",
	"a341 sysTrapDbgControl",
	"a342 sysTrapExgDBRead",
	"a343 sysTrapExgDBWrite",
	"a344 sysTrapHostControl",
	"a345 sysTrapFrmRemoveObject",
	"a346 sysTrapSysReserved1",
	"a347 sysTrapSysReserved2",
	"a348 sysTrapSysReserved3",
	"a349 sysTrapOEMDispatch",
	"a34a sysTrapHwrLCDContrastV33",
	"a34b sysTrapSysLCDContrast",
	"a34c sysTrapUIContrastAdjust",
	"a34d sysTrapHwrDockStatus",
	"a34e sysTrapFntWidthToOffset",
	"a34f sysTrapSelectOneTime",
	"a350 sysTrapWinDrawChar",
	"a351 sysTrapWinDrawTruncChars",
	"a352 sysTrapSysNotifyInit",
	"a353 sysTrapSysNotifyRegister",
	"a354 sysTrapSysNotifyUnregister",
	"a355 sysTrapSysNotifyBroadcast",
	"a356 sysTrapSysNotifyBroadcastDeferred",
	"a357 sysTrapSysNotifyDatabaseAdded",
	"a358 sysTrapSysNotifyDatabaseRemoved",
	"a359 sysTrapSysWantEvent",
	"a35a sysTrapFtrPtrNew",
	"a35b sysTrapFtrPtrFree",
	"a35c sysTrapFtrPtrResize",
	"a35d sysTrapSysReserved5",
	"a35e sysTrapHwrNVPrefSet",
	"a35f sysTrapHwrNVPrefGet",
	"a360 sysTrapFlashInit",
	"a361 sysTrapFlashCompress",
	"a362 sysTrapFlashErase",
	"a363 sysTrapFlashProgram",
	"a364 sysTrapAlmTimeChange",
	"a365 sysTrapErrAlertCustom",
	"a366 sysTrapPrgStartDialog",
	"a367 sysTrapSerialDispatch",
	"a368 sysTrapHwrBattery",
	"a369 sysTrapDmGetDatabaseLockState",
	"a36a sysTrapCncGetProfileList",
	"a36b sysTrapCncGetProfileInfo",
	"a36c sysTrapCncAddProfile",
	"a36d sysTrapCncDeleteProfile",
	"a36e sysTrapSndPlaySmfResource",
	"a36f sysTrapMemPtrDataStorage",
	"a370 sysTrapClipboardAppendItem",
	"a371 sysTrapWiCmdV32",
	"a372 sysTrapHwrDisplayAttributes",
	"a373 sysTrapHwrDisplayDoze",
	"a374 sysTrapHwrDisplayPalette",
	"a375 sysTrapBltFindIndexes",
	"a376 sysTrapBmpGetBits",
	"a377 sysTrapBltCopyRectangle",
	"a378 sysTrapBltDrawChars",
	"a379 sysTrapBltLineRoutine",
	"a37a sysTrapBltRectangleRoutine",
	"a37b sysTrapScrCompress",
	"a37c sysTrapScrDecompress",
	"a37d sysTrapSysLCDBrightness",
	"a37e sysTrapWinPaintChar",
	"a37f sysTrapWinPaintChars",
	"a380 sysTrapWinPaintBitmap",
	"a381 sysTrapWinGetPixel",
	"a382 sysTrapWinPaintPixel",
	"a383 sysTrapWinDrawPixel",
	"a384 sysTrapWinErasePixel",
	"a385 sysTrapWinInvertPixel",
	"a386 sysTrapWinPaintPixels",
	"a387 sysTrapWinPaintLines",
	"a388 sysTrapWinPaintLine",
	"a389 sysTrapWinPaintRectangle",
	"a38a sysTrapWinPaintRectangleFrame",
	"a38b sysTrapWinPaintPolygon",
	"a38c sysTrapWinDrawPolygon",
	"a38d sysTrapWinErasePolygon",
	"a38e sysTrapWinInvertPolygon",
	"a38f sysTrapWinFillPolygon",
	"a390 sysTrapWinPaintArc",
	"a391 sysTrapWinDrawArc",
	"a392 sysTrapWinEraseArc",
	"a393 sysTrapWinInvertArc",
	"a394 sysTrapWinFillArc",
	"a395 sysTrapWinPushDrawState",
	"a396 sysTrapWinPopDrawState",
	"a397 sysTrapWinSetDrawMode",
	"a398 sysTrapWinSetForeColor",
	"a399 sysTrapWinSetBackColor",
	"a39a sysTrapWinSetTextColor",
	"a39b sysTrapWinGetPatternType",
	"a39c sysTrapWinSetPatternType",
	"a39d sysTrapWinPalette",
	"a39e sysTrapWinRGBToIndex",
	"a39f sysTrapWinIndexToRGB",
	"a3a0 sysTrapWinScreenLock",
	"a3a1 sysTrapWinScreenUnlock",
	"a3a2 sysTrapWinGetBitmap",
	"a3a3 sysTrapUIColorInit",
	"a3a4 sysTrapUIColorGetTableEntryIndex",
	"a3a5 sysTrapUIColorGetTableEntryRGB",
	"a3a6 sysTrapUIColorSetTableEntry",
	"a3a7 sysTrapUIColorPushTable",
	"a3a8 sysTrapUIColorPopTable",
	"a3a9 sysTrapCtlNewGraphicControl",
	"a3aa sysTrapTblGetItemPtr",
	"a3ab sysTrapUIBrightnessAdjust",
	"a3ac sysTrapUIPickColor",
	"a3ad sysTrapEvtSetAutoOffTimer",
	"a3ae sysTrapTsmDispatch",
	"a3af sysTrapOmDispatch",
	"a3b0 sysTrapDmOpenDBNoOverlay",
	"a3b1 sysTrapDmOpenDBWithLocale",
	"a3b2 sysTrapResLoadConstant",
	"a3b3 sysTrapHwrPreDebugInit",
	"a3b4 sysTrapHwrResetNMI",
	"a3b5 sysTrapHwrResetPWM",
	"a3b6 sysTrapKeyBootKeys",
	"a3b7 sysTrapDbgSerDrvOpen",
	"a3b8 sysTrapDbgSerDrvClose",
	"a3b9 sysTrapDbgSerDrvControl",
	"a3ba sysTrapDbgSerDrvStatus",
	"a3bb sysTrapDbgSerDrvWriteChar",
	"a3bc sysTrapDbgSerDrvReadChar",
	"a3bd sysTrapHwrPostDebugInit",
	"a3be sysTrapHwrIdentifyFeatures",
	"a3bf sysTrapHwrModelSpecificInit",
	"a3c0 sysTrapHwrModelInitStage2",
	"a3c1 sysTrapHwrInterruptsInit",
	"a3c2 sysTrapHwrSoundOn",
	"a3c3 sysTrapHwrSoundOff",
	"a3c4 sysTrapSysKernelClockTick",
	"a3c5 sysTrapMenuEraseMenu",
	"a3c6 sysTrapSelectTime",
	"a3c7 sysTrapMenuCmdBarAddButton",
	"a3c8 sysTrapMenuCmdBarGetButtonData",
	"a3c9 sysTrapMenuCmdBarDisplay",
	"a3ca sysTrapHwrGetSilkscreenID",
	"a3cb sysTrapEvtGetSilkscreenAreaList",
	"a3cc sysTrapSysFatalAlertInit",
	"a3cd sysTrapDateTemplateToAscii",
	"a3ce sysTrapSecVerifyPW",
	"a3cf sysTrapSecSelectViewStatus",
	"a3d0 sysTrapTblSetColumnMasked",
	"a3d1 sysTrapTblSetRowMasked",
	"a3d2 sysTrapTblRowMasked",
	"a3d3 sysTrapFrmCustomResponseAlert",
	"a3d4 sysTrapFrmNewGsi",
	"a3d5 sysTrapMenuShowItem",
	"a3d6 sysTrapMenuHideItem",
	"a3d7 sysTrapMenuAddItem",
	"a3d8 sysTrapFrmSetGadgetHandler",
	"a3d9 sysTrapCtlSetGraphics",
	"a3da sysTrapCtlGetSliderValues",
	"a3db sysTrapCtlSetSliderValues",
	"a3dc sysTrapCtlNewSliderControl",
	"a3dd sysTrapBmpCreate",
	"a3de sysTrapBmpDelete",	
	"a3df sysTrapBmpCompress",
	"a3e0 sysTrapBmpGetColortable",
	"a3e1 sysTrapBmpSize",
	"a3e2 sysTrapBmpBitsSize",
	"a3e3 sysTrapBmpColortableSize",
	"a3e4 sysTrapWinCreateBitmapWindow",
	"a3e5 sysTrapEvtSetNullEventTick",
	"a3e6 sysTrapExgDoDialog",
	"a3e7 sysTrapSysUICleanup",
	"a3e8 sysTrapLastTrapNumber",

//	"a800 sysLibTrapBase",			// sysLibTrapName
	"a800 sysLibTrapName",
	"a801 sysLibTrapOpen",
	"a802 sysLibTrapClose",
	"a803 sysLibTrapSleep",
	"a804 sysLibTrapWake",
	"a805 sysLibTrapCustom",
	""};

/************************************************************************/
/*	read through "jfile" and collect instruction values in		*/
/*	"jinsts".							*/
/************************************************************************/
static void readjfile(void)
{
	FILE *jfp;
	char buf[80];
	char *cp;
	m68kword ul;
	m68kword *jtmp;

	jfp = fopen(jfile, "r");

	if(jfp) {
		while(fgets(buf, sizeof(buf), jfp)) {
			buf[strlen(buf) - 1] = '\0';
			ul = strtoul(buf, &cp, 16);

			if(cp == buf || !((ul >= 0xa000 && ul <= 0xafff) || (ul >= 0xf000))) {
				fprintf(stderr, "%s: File %s: bad inst: %s\n", sfile, jfile, buf);
				continue;
			}

			if((jtmp = realloc(jinsts, ++njinsts *sizeof(*jinsts))) == NULL) {
				if(jtmp) {
					jinsts = jtmp;
				}

				perror("realloc");
				(void)fclose(jfp);
				return;
			}
			else {
				jinsts = jtmp;
				jinsts[njinsts - 1] = ul;
			}
		}

		(void)fclose(jfp);
	}
	else {
		perror(jfile);
	}
}

/************************************************************************/
/*	test whether "word" matches an instruction value in "jfile".	*/
/************************************************************************/
static int itsajinst(m68kword word)
{
	size_t i;

	for(i = 0; i < njinsts; i++) {
		if(word == jinsts[i]) {
			return 1;
		}
	}

	return 0;
}

/************************************************************************/
/*	test whether "word" is a valid a- or f-line instruction,	*/
/*	or a valid trap call, reading "[fat]file" as necessary.		*/
/************************************************************************/
static char *validfatinst(int f0a1t2, m68kword word)
{
	static int fileread[3] = {0, 0, 0};
	static size_t ninsts[3] = {0, 0, 0};
	static struct fatinst *fatinsts[3] = {NULL, NULL, NULL};
	struct fatinst *fattmp;
	size_t i;
	static int jfileread = 0;

	if((f0a1t2 == 0 && !ffile) || (f0a1t2 == 1 && !afile)) {
		return NULL;
	}

/************************************************************************/
/*	read "jfile" if necessary.					*/
/************************************************************************/
	if(jfile && !jfileread) {
		readjfile();
		jfileread = 1;
	}

/************************************************************************/
/*	read "[fat]file" if necessary, collecting the values		*/
/*	in "[fat]insts" and then sorting them.				*/
/************************************************************************/
	if(!fileread[f0a1t2]) {
		char afbuf[80];
		m68kword ul;
		char *cp;

		fileread[f0a1t2] = 1;

/************************************************************************/
/*	if no trap file was specified then use internal list of traps	*/
/************************************************************************/
		if(f0a1t2 == 2 && !tfile) {

/************************************************************************/
/*	load traptable							*/
/************************************************************************/
			int trap_num = 0;

			while(strlen(trap_table[trap_num])) {
				strcpy(afbuf, trap_table[trap_num++]);
				ul = strtoul(afbuf, &cp, 16);

				if(cp == afbuf) {
					fprintf(stderr, "%s: Trap Table : bad trap line %d: %s\n", sfile, trap_num, afbuf);
					continue;
				}

/************************************************************************/
/*	find instruction-string. use "unknown" if not given.		*/
/************************************************************************/
				cp--;

				while(*++cp && isspace(*cp))
					;

				if(!cp) {
					cp = "UNKNOWN";
				}

				if((fattmp = realloc(fatinsts[f0a1t2], ++ninsts[f0a1t2] *sizeof(*fatinsts[f0a1t2]))) == NULL || (fattmp[ninsts[f0a1t2] - 1].name = malloc(strlen(cp) + 1)) == NULL) {
					if(fattmp) {
						fatinsts[f0a1t2] = fattmp;
					}

					perror("realloc");
					return NULL;
				}
				else {
					fatinsts[f0a1t2] = fattmp;
					fatinsts[f0a1t2][ninsts[f0a1t2] - 1].inst = ul;
					strcpy(fatinsts[f0a1t2][ninsts[f0a1t2] - 1].name, cp);
				}
			}
		}
		else {

/************************************************************************/
/*	load fat file							*/
/************************************************************************/
			FILE *afp;

			afp = fopen(f0a1t2 == 2 ? tfile : (f0a1t2 ? afile : ffile), "r");

			if(afp) {
				while(fgets(afbuf, sizeof(afbuf), afp)) {
					afbuf[strlen(afbuf) - 1] = '\0';
					ul = strtoul(afbuf, &cp, 16);

					if(cp == afbuf || (f0a1t2 == 0 && (ul < 0xf000)) || (f0a1t2 == 1 && (ul < 0xa000 || ul > 0xafff))) {
						fprintf(stderr, "%s: File %s: bad inst: %s\n", sfile, f0a1t2 == 2 ? tfile : (f0a1t2 ? afile : ffile), afbuf);
						continue;
					}

/************************************************************************/
/*	find instruction-string. use "unknown" if not given.		*/
/************************************************************************/
					cp--;

					while(*++cp && isspace(*cp))
						;

					if(!cp) {
						cp = "UNKNOWN";
					}

					if((fattmp = realloc(fatinsts[f0a1t2], ++ninsts[f0a1t2] *sizeof(*fatinsts[f0a1t2]))) == NULL || (fattmp[ninsts[f0a1t2] - 1].name = malloc(strlen(cp) + 1)) == NULL) {
						if(fattmp) {
							fatinsts[f0a1t2] = fattmp;
						}

						perror("realloc");
						return NULL;
					}
					else {
						fatinsts[f0a1t2] = fattmp;
						fatinsts[f0a1t2][ninsts[f0a1t2] - 1].inst = ul;
						strcpy(fatinsts[f0a1t2][ninsts[f0a1t2] - 1].name, cp);
					}
				}

				(void)fclose(afp);
			}
			else {
				perror(f0a1t2 == 2 ? tfile : (f0a1t2 ? afile : ffile));
			}
		}
	}

	for(i = 0; i < ninsts[f0a1t2]; i++) {
		if(word == fatinsts[f0a1t2][i].inst) {
			return fatinsts[f0a1t2][i].name;
		}
	}

	return NULL;
}

/************************************************************************/
/*	verify whether "word" is an acceptable a-line instruction.	*/
/*	print as necessary.						*/
/************************************************************************/
void aline(m68kword word)
{
	char *cp;

	cp = validfatinst(A, word);

	if(cp) {
		instprint(ops2f(0), cp);
		valid = 1;

		if(itsajinst(word)) {
			flags |= ISJMP;
		}
	}
}

/************************************************************************/
/*	verify whether "word" is an acceptable f-line instruction.	*/
/*	print as necessary.						*/
/************************************************************************/
void fline(m68kword word)
{
	char *cp;

	cp = validfatinst(F, word);

	if(cp) {
		instprint(ops2f(0), cp);
		valid = 1;

		if(itsajinst(word)) {
			flags |= ISJMP;
		}
	}
}

/************************************************************************/
/*	check if a known trap name exists for the supplied trap		*/
/************************************************************************/
extern char *trapname(long trap_arg)
{
	char *cp;
	static char buf[80];

	cp = validfatinst(T, trap_arg);

	if(cp) {
		return cp;
	}
	else {
		sprintf(buf, "sysTrap $%4x = sysTrap unknown.", trap_arg);
		return buf;
	}
}
