/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: util.h 476 2001-07-09 08:09:10Z hbb $ */

# ifndef util_h_
# define util_h_

# include <sys/types.h>
# include <sys/wait.h>
# include <termios.h>

# define ArraySize(A)	(sizeof(A)/sizeof(A[0]))
# define BAD_SWITCH(S)	panic("bad switch in '%s', %d: %ld\n", __FILE__, __LINE__, (long)(S));

void	set_argv0(char *);
void	catch_signal(int, void (*)(int));

caddr_t mmap_shared_parent(size_t, int *);
caddr_t mmap_shared_child(size_t, int);

# ifndef HAVE_CFMAKERAW
void cfmakeraw(struct termios *);
# endif

/*
 * Cygwin has no WCOREDUMP
 */
# ifndef WCOREDUMP
#  ifdef w_coredump
#   define WCOREDUMP(S)	(((union wait *)&(S))->w_coredump)
#  else
#   define WCOREDUMP(S)	((S) & 0x80)
#  endif
# endif


# endif
