/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include "epp.h"

RCSID("$Id: epp_fifo.c 461 2000-12-04 17:03:43Z hbb $")

char	*fifo_name;	/* fifo name for unlink */
u_char	rbuf[2048];

void	open_fifo(void);
void	rm_fifo(void);


int
main(int argc, char *argv[])
{
	int	opt;

	set_argv0(progname = argv[0]);
	while((opt = getopt(argc, argv, "v")) != EOF)
		switch(opt) {

		case 'v':
			verb_option("all");
			break;
		}

	argc -= optind;
	argv += optind;

	if(argc != 1)
		panic("need fifo name");
	fifo_name = argv[0];

	atexit(rm_fifo);

	init_sigs();
	open_fifo();
	open_shmem();

	loop();
}


/*
 * reset all
 * no-op
 */
void
reset()
{
}

/*
 * receiver enabled state changed
 * no-op
 */
void
rcv_enable_change()
{
}


/*
 * transmit packet so that it can be easily used with tcpdump -F
 */
void
transmit()
{
	static struct timeval ts;
	static struct iovec iov[4] = {
		{ (caddr_t)&ts, sizeof(ts) },
		{ (caddr_t)&xlen, sizeof(xlen) },
		{ (caddr_t)&xlen, sizeof(xlen) },
		{ (caddr_t)xbuf, 0 }};

	gettimeofday(&ts, NULL);
	iov[3].iov_len = xlen;
	
	if((size_t)writev(fd, iov, 4) != sizeof(ts) + 2 * sizeof(xlen) + xlen)
		panic("transmission error: %s", strerror(errno));
}


/*
 * input from fifo
 */
u_int
read_input(u_char **pbuf, int *more)
{
	int	got;
	int	rlen;

	*more = 0;
	got = read(fd, &rlen, sizeof(rlen));
	if(got <= 0)
		return 0;
	if(got != sizeof(rlen))
		panic("fifo short read on frame length");
	if((got = read(fd, rbuf, rlen)) != rlen)
		panic("fifo read error on frame: ret = %d, wanted = %d, %s", got, rlen, strerror(errno));

	*pbuf = rbuf;
	return got;
}

/*
 * do address filtering on input
 */
int
input_filter(u_char *buf)
{
	return apply_filter(buf);
}


/*
 * new filter expression
 * no-op in fifo
 */
void
set_filter()
{
}


/*
 * create fifo, open it
 */
void
open_fifo()
{
	if(mkfifo(fifo_name, 0666))
		panic("can't create %s: %s", fifo_name, strerror(errno));
	if((fd = open(fifo_name, O_RDWR)) < 0)
		panic("can't open %s: %s", fifo_name, strerror(errno));
}
void
rm_fifo()
{
	unlink(fifo_name);
}

/*
 * SIGINFO
 */
# define P	buf+strlen(buf)
void
do_info(char *buf)
{
	sprintf(P, "%s\n", progname);
	sprintf(P, "  fifo=%s", fifo_name);
}

