/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: epp.h 477 2002-01-29 15:29:29Z hbb $ */

/*
 * definitions for EPP support
 */
# include <stdio.h>
# include <stdlib.h>
# include <signal.h>
# include <stdarg.h>
# include <string.h>
# include <errno.h>
# include <unistd.h>
# include <fcntl.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/mman.h>
# include <sys/uio.h>
# include <sys/time.h>

# ifdef HAVE_GETOPT_H
#  include <getopt.h>
# endif

# include <begemot.h>
# include "cdefs.h"
# include "eppdefs.h"
# include "qna_regs.h"
# include "util.h"


typedef struct filter_t	filter_t;
struct filter_t {
	int	promisc;	/* promiscuous mode */
	int	allmulti;	/* receive all multicast frames */
	u_int	naddr;		/* number of regular addresses */
	u_char	addr[14][6];	/* addresses */
};


extern char	*progname;	/* program name */
extern u_int	rcv_enable;	/* receiver is enabled */
extern eppcomm_t *comm;		/* shared memory area */
extern int	fd;		/* input file descriptor */
extern sigset_t	allmask;	/* all used signals */

extern u_char	xbuf[];		/* transmit buffer */
extern u_int	xlen;		/* transmit frame size */

extern filter_t	f;		/* the filter */

/*
 * support functions
 */
void	loop(void) DEAD_FUNC;
void	init_sigs(void);
void	open_shmem(void);
void	p11_write(u_int, void *p, u_int len);
int	apply_filter(u_char *);


/*
 * functions called from support functions
 */
int	input_filter(u_char *);		/* return TRUE if input packet ok */
void	set_filter(void);		/* setup new filter */
void	transmit(void);			/* transmit frame */
u_int	read_input(u_char **, int *);	/* read input frame */
void	do_info(char *buf);		/* monitor 'info' command */
void	reset(void);			/* reset all */
void	rcv_enable_change(void);	/* state changed */
void	parse_ether(u_char *, char *);
