#
# p11 rpm spec file.
#
# $Id: p11.spec 506 2002-09-04 14:30:14Z hbb $
#
# Authors:
#	Eric Moret
#	Harti Brandt
#
%ifos Linux
%define _prefix	/usr
%else
%define _prefix	/usr/local
%endif

Summary: A DEC pdp-11 emulator.
Name: p11
Version: 2.10
%define patchlevel g
Release: 4
Copyright: Computer Begemot Associates
Group: Applications/Emulators
Source: ftp://ftp.fokus.gmd.de/pub/cats/usr/harti/p11/p11-%{version}%{patchlevel}.tar.gz
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}

%ifos Linux
#
# Handle --with-init option on Linux
#
%{!?_with_init: %{!?_without_init: %define _without_init --without-init-dir}}
%{?_with_init: %{?_without_init: %{error: both --with-init and --without-init}}}
%else
%define _with_init
%define _without_init
%endif

BuildPrereq: libbegemot-devel
Requires: libbegemot

%description
p11 is a DEC pdp-11 emulator.

%prep
%setup -q -n %{name}-%{version}%{patchlevel}

%build
%configure \
       --with-begemot=`rpm -q --qf "%{INSTALLPREFIX}" libbegemot-devel` \
       %{?_with_init:--with-init-dir} %{?_without_init:--without-init-dir}
gmake

%clean
rm -fr $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
gmake install DESTDIR=$RPM_BUILD_ROOT

#
# In the postinstall script make symbolic links from the installed
# init scripts and config files to /etc
#
%post
%ifos Linux
%define confdir /etc
%else
%define confdir %{_prefix}/etc
%endif

echo '******************************************************'
if ! test -e %{confdir}/p11conf ; then
	if test "${RPM_INSTALL_PREFIX0}" = "%{_prefix}" ; then
		cp ${RPM_INSTALL_PREFIX0}/share/p11/p11conf %{confdir}/p11conf
	else
		sed '/^##/a\
set iodir '${RPM_INSTALL_PREFIX0}'/libexec/p11\
set libpath %{confdir}:'${RPM_INSTALL_PREFIX0}'/share/p11\
' ${RPM_INSTALL_PREFIX0}/share/p11/p11conf >%{confdir}/p11conf
	fi
	echo "Initial configuration file copied in %{confdir}/p11conf. You probably"
	echo "need to adapt it to your environment."
else
	echo "%{confdir}/p11conf already exists. You may need to merge changes"
	echo "from ${RPM_INSTALL_PREFIX0}/share/p11/p11conf"
fi
echo '******************************************************'

%if %{?_with_init:1}%{!?_with_init:0}
if test -e /etc/init.d/p11 ; then
	rm -f /etc/init.d/p11
fi
ln -s ${RPM_INSTALL_PREFIX0}/share/p11/p11.sh /etc/init.d/p11
chkconfig --add p11
chkconfig p11 on
%endif

%ifos Linux
if test ! -c /dev/net/tun ; then
	if test ! -d /dev/net; then
		mkdir /dev/net
		chown root:root /dev/net
		chmod 755 /dev/net
	fi
	mknod /dev/net/tun c 10 200
	chown root:root /dev/net/tun
	chmod 644 /dev/net/tun
fi
if ! grep -q char-major-10-200 /etc/modules.conf ; then
	echo "alias char-major-10-200 tun" >>/etc/modules.conf
fi
%endif

#
# Don't remove the configuration file. The user most likely changed it.
#
%preun
if test -e /etc/init.d/p11 ; then
	chkconfig p11 off
	chkconfig --del p11
	rm -f /etc/init.d/p11
fi

%files
%defattr(-,root,root)
%doc COPYRIGHT README VERSION
%attr(755,root,root) %dir %{_bindir}
%attr(755,root,root) %dir %{_datadir}/p11
%attr(755,root,root) %dir %{_libexecdir}/p11
%{_bindir}/p11
%{_datadir}/p11/boot.rom
%{_datadir}/p11/COPYRIGHT
%{_datadir}/p11/mon.help
%{_datadir}/p11/p11conf
%if %{?_with_init:1}%{!?_with_init:0}
%{_datadir}/p11/p11.sh
%endif
%ifos FreeBSD
%{_libexecdir}/p11/epp_bpf
%endif
%{_libexecdir}/p11/epp_fifo
%{_libexecdir}/p11/epp_tap
%{_libexecdir}/p11/epp_tun
%{_libexecdir}/p11/fmt
%{_libexecdir}/p11/lp_file
%{_libexecdir}/p11/tty_fifo
%{_libexecdir}/p11/tty_file
%{_libexecdir}/p11/tty_net
%{_libexecdir}/p11/tty_pty
%{_libexecdir}/p11/tty_tty
%{_libexecdir}/p11/tty_xterm

%changelog
* Wed Sep 04 2002 Harti Brandt <brandt@fokus.gmd.de> 2.10-4
- on first install copy configuration file to /etc
  on next installs warn, that it may need modification
- copy init script to /etc/init.d and remove it on de-install
  there is obviously a problem with installing more than one p11
  in parallel in this case
* Tue Sep 03 2002 Harti Brandt <brandt@fokus.gmd.de> 2.10-3
- OS dependend prefix
- patchlevel support
* Wed Aug 14 2002 Eric Moret <eric.moret@epita.fr> 2.10c
- add a daemon mode
- include rc startup scripts
- include the spec file
* Wed Jun 12 2002 Eric Moret <eric.moret@epita.fr> 2.10a
- initial spec file
