//
// Object.h
//

#pragma once

#include "ogl_support.h"

#define INVALID_NODE_FLAG	0xdeadbeef			// put into CType when node is deleted

enum
{
	TERRAIN_SLOT		=     1,
	FENCE_SLOT			=     4,
	PLAYER_SLOT			=   200,
	ENEMY_SLOT			=   210,
	HUMAN_SLOT			=  2950,
	SLOT_OF_DUMB		=  3000,
	WATER_SLOT			=  3097,
	PARTICLE_SLOT		=  3098,
	SPARKLE_SLOT		=  3099,
	SPRITE_SLOT			=  3100,
	DRAWEXTRA_SLOT		=  5000,
	MENU_SLOT			=  5100,
	FADEPANE_SLOT		=  5200,
	DEBUGOVERLAY_SLOT	= 32767,
};

enum
{
	SKELETON_GENRE,
	DISPLAY_GROUP_GENRE,
	SPRITE_GENRE,
	CUSTOM_GENRE,
	EVENT_GENRE,
	TEXTMESH_GENRE
};


enum
{
	SHADOW_TYPE_CIRCULAR
};


//========================================================

void InitObjectManager(void);
ObjNode* MakeNewObject(NewObjectDefinitionType* newObjDef);
void MoveObjects(void);
void DrawObjects(void);

extern	void DeleteAllObjects(void);
extern	void DeleteObject(ObjNode	*theNode);
void DetachObject(ObjNode *theNode, Boolean subrecurse);
extern	void GetObjectInfo(ObjNode *theNode);
extern	void UpdateObject(ObjNode *theNode);
extern	ObjNode *MakeNewDisplayGroupObject(NewObjectDefinitionType *newObjDef);
extern	void AttachGeometryToDisplayGroupObject(ObjNode *theNode, MetaObjectPtr geometry);
extern	void CreateBaseGroup(ObjNode *theNode);
extern	void UpdateObjectTransforms(ObjNode *theNode);
extern	void SetObjectTransformMatrix(ObjNode *theNode);
extern	void DisposeObjectBaseGroup(ObjNode *theNode);
extern	void ResetDisplayGroupObject(ObjNode *theNode);
void AttachObject(ObjNode *theNode, Boolean recurse);

void MoveStaticObject(ObjNode *theNode);
void MoveStaticObject2(ObjNode *theNode);
void MoveStaticObject3(ObjNode *theNode);

void CalcNewTargetOffsets(ObjNode *theNode, float scale);

//===================


extern	void CalcObjectBoxFromNode(ObjNode *theNode);
extern	void CalcObjectBoxFromGlobal(ObjNode *theNode);
extern	void SetObjectCollisionBounds(ObjNode *theNode, short top, short bottom, short left,
							 short right, short front, short back);
extern	void UpdateShadow(ObjNode *theNode);
extern	void CullTestAllObjects(void);
ObjNode	*AttachShadowToObject(ObjNode *theNode, int shadowType, float scaleX, float scaleZ, Boolean checkBlockers);
void CreateCollisionBoxFromBoundingBox(ObjNode *theNode, float tweakXZ, float tweakY);
void CreateCollisionBoxFromBoundingBox_Maximized(ObjNode *theNode);
void CreateCollisionBoxFromBoundingBox_Rotated(ObjNode *theNode, float tweakXZ, float tweakY);
void CreateCollisionBoxFromBoundingBox_Update(ObjNode *theNode, float tweakXZ, float tweakY);
ObjNode* FindClosestCType(const OGLPoint3D* pt, uint32_t ctype);
ObjNode* FindClosestCType3D(const OGLPoint3D* pt, uint32_t ctype);
extern	void StopObjectStreamEffect(ObjNode *theNode);
extern	void KeepOldCollisionBoxes(ObjNode *theNode);
void AddCollisionBoxToObject(ObjNode *theNode, float top, float bottom, float left,
							 float right, float front, float back);
