/* Copyright (C) 2004 Manuel Bouyer

dual_led is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

dual_led is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with dual_led; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <gpsim/modules.h>
#include <gpsim/packages.h>
#include <gpsim/stimuli.h>
#include <gpsim/symbol.h>
#include <gpsim/trace.h>
#include <gpsim/ioports.h>
#include <gpsim/gpsim_interface.h>
#include <gpsim/gpsim_time.h> // for cycles

class oscilloscope_graph;
class oscilloscope_window;

class oscilloscope;

/* A class derived from Interface, which defines our GUI */
class oscilloscope_Interface : public Interface
{
private:
        oscilloscope *osc;
public:
	virtual void SimulationHasStopped (gpointer object);
	oscilloscope_Interface (oscilloscope *_osc) :
	    Interface((gpointer *) _osc)
	{
		osc = _osc;
	}
};

class oscilloscope: public Module
{
public:
	void build_window(int, const char *new_name = NULL);
	oscilloscope(void);
	~oscilloscope(void);
	// Inheritances from the Package class
	virtual void create_iopin_map(void);
	// Inheritance from Module class
	const virtual char *type(void) { return ("oscilloscope"); };
	static Module *construct(const char *new_name);
private:
	oscilloscope_window *window;
	oscilloscope_Interface *interface;
};
