// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.15.6
// source: planfile.proto

package planproto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Mode describes the planning mode that created the plan.
type Mode int32

const (
	Mode_NORMAL       Mode = 0
	Mode_DESTROY      Mode = 1
	Mode_REFRESH_ONLY Mode = 2
)

// Enum value maps for Mode.
var (
	Mode_name = map[int32]string{
		0: "NORMAL",
		1: "DESTROY",
		2: "REFRESH_ONLY",
	}
	Mode_value = map[string]int32{
		"NORMAL":       0,
		"DESTROY":      1,
		"REFRESH_ONLY": 2,
	}
)

func (x Mode) Enum() *Mode {
	p := new(Mode)
	*p = x
	return p
}

func (x Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_planfile_proto_enumTypes[0].Descriptor()
}

func (Mode) Type() protoreflect.EnumType {
	return &file_planfile_proto_enumTypes[0]
}

func (x Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Mode.Descriptor instead.
func (Mode) EnumDescriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{0}
}

// Action describes the type of action planned for an object.
// Not all action values are valid for all object types.
type Action int32

const (
	Action_NOOP               Action = 0
	Action_CREATE             Action = 1
	Action_READ               Action = 2
	Action_UPDATE             Action = 3
	Action_DELETE             Action = 5
	Action_DELETE_THEN_CREATE Action = 6
	Action_CREATE_THEN_DELETE Action = 7
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0: "NOOP",
		1: "CREATE",
		2: "READ",
		3: "UPDATE",
		5: "DELETE",
		6: "DELETE_THEN_CREATE",
		7: "CREATE_THEN_DELETE",
	}
	Action_value = map[string]int32{
		"NOOP":               0,
		"CREATE":             1,
		"READ":               2,
		"UPDATE":             3,
		"DELETE":             5,
		"DELETE_THEN_CREATE": 6,
		"CREATE_THEN_DELETE": 7,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_planfile_proto_enumTypes[1].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_planfile_proto_enumTypes[1]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{1}
}

// ResourceInstanceActionReason sometimes provides some additional user-facing
// context for why a particular action was chosen for a resource instance.
// This is for user feedback only and never used to drive behavior during the
// subsequent apply step.
type ResourceInstanceActionReason int32

const (
	ResourceInstanceActionReason_NONE                              ResourceInstanceActionReason = 0
	ResourceInstanceActionReason_REPLACE_BECAUSE_TAINTED           ResourceInstanceActionReason = 1
	ResourceInstanceActionReason_REPLACE_BY_REQUEST                ResourceInstanceActionReason = 2
	ResourceInstanceActionReason_REPLACE_BECAUSE_CANNOT_UPDATE     ResourceInstanceActionReason = 3
	ResourceInstanceActionReason_DELETE_BECAUSE_NO_RESOURCE_CONFIG ResourceInstanceActionReason = 4
	ResourceInstanceActionReason_DELETE_BECAUSE_WRONG_REPETITION   ResourceInstanceActionReason = 5
	ResourceInstanceActionReason_DELETE_BECAUSE_COUNT_INDEX        ResourceInstanceActionReason = 6
	ResourceInstanceActionReason_DELETE_BECAUSE_EACH_KEY           ResourceInstanceActionReason = 7
	ResourceInstanceActionReason_DELETE_BECAUSE_NO_MODULE          ResourceInstanceActionReason = 8
	ResourceInstanceActionReason_REPLACE_BY_TRIGGERS               ResourceInstanceActionReason = 9
	ResourceInstanceActionReason_READ_BECAUSE_CONFIG_UNKNOWN       ResourceInstanceActionReason = 10
	ResourceInstanceActionReason_READ_BECAUSE_DEPENDENCY_PENDING   ResourceInstanceActionReason = 11
	ResourceInstanceActionReason_READ_BECAUSE_CHECK_NESTED         ResourceInstanceActionReason = 13
	ResourceInstanceActionReason_DELETE_BECAUSE_NO_MOVE_TARGET     ResourceInstanceActionReason = 12
)

// Enum value maps for ResourceInstanceActionReason.
var (
	ResourceInstanceActionReason_name = map[int32]string{
		0:  "NONE",
		1:  "REPLACE_BECAUSE_TAINTED",
		2:  "REPLACE_BY_REQUEST",
		3:  "REPLACE_BECAUSE_CANNOT_UPDATE",
		4:  "DELETE_BECAUSE_NO_RESOURCE_CONFIG",
		5:  "DELETE_BECAUSE_WRONG_REPETITION",
		6:  "DELETE_BECAUSE_COUNT_INDEX",
		7:  "DELETE_BECAUSE_EACH_KEY",
		8:  "DELETE_BECAUSE_NO_MODULE",
		9:  "REPLACE_BY_TRIGGERS",
		10: "READ_BECAUSE_CONFIG_UNKNOWN",
		11: "READ_BECAUSE_DEPENDENCY_PENDING",
		13: "READ_BECAUSE_CHECK_NESTED",
		12: "DELETE_BECAUSE_NO_MOVE_TARGET",
	}
	ResourceInstanceActionReason_value = map[string]int32{
		"NONE":                              0,
		"REPLACE_BECAUSE_TAINTED":           1,
		"REPLACE_BY_REQUEST":                2,
		"REPLACE_BECAUSE_CANNOT_UPDATE":     3,
		"DELETE_BECAUSE_NO_RESOURCE_CONFIG": 4,
		"DELETE_BECAUSE_WRONG_REPETITION":   5,
		"DELETE_BECAUSE_COUNT_INDEX":        6,
		"DELETE_BECAUSE_EACH_KEY":           7,
		"DELETE_BECAUSE_NO_MODULE":          8,
		"REPLACE_BY_TRIGGERS":               9,
		"READ_BECAUSE_CONFIG_UNKNOWN":       10,
		"READ_BECAUSE_DEPENDENCY_PENDING":   11,
		"READ_BECAUSE_CHECK_NESTED":         13,
		"DELETE_BECAUSE_NO_MOVE_TARGET":     12,
	}
)

func (x ResourceInstanceActionReason) Enum() *ResourceInstanceActionReason {
	p := new(ResourceInstanceActionReason)
	*p = x
	return p
}

func (x ResourceInstanceActionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceInstanceActionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_planfile_proto_enumTypes[2].Descriptor()
}

func (ResourceInstanceActionReason) Type() protoreflect.EnumType {
	return &file_planfile_proto_enumTypes[2]
}

func (x ResourceInstanceActionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceInstanceActionReason.Descriptor instead.
func (ResourceInstanceActionReason) EnumDescriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{2}
}

// Status describes the status of a particular checkable object at the
// completion of the plan.
type CheckResults_Status int32

const (
	CheckResults_UNKNOWN CheckResults_Status = 0
	CheckResults_PASS    CheckResults_Status = 1
	CheckResults_FAIL    CheckResults_Status = 2
	CheckResults_ERROR   CheckResults_Status = 3
)

// Enum value maps for CheckResults_Status.
var (
	CheckResults_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "PASS",
		2: "FAIL",
		3: "ERROR",
	}
	CheckResults_Status_value = map[string]int32{
		"UNKNOWN": 0,
		"PASS":    1,
		"FAIL":    2,
		"ERROR":   3,
	}
)

func (x CheckResults_Status) Enum() *CheckResults_Status {
	p := new(CheckResults_Status)
	*p = x
	return p
}

func (x CheckResults_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CheckResults_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_planfile_proto_enumTypes[3].Descriptor()
}

func (CheckResults_Status) Type() protoreflect.EnumType {
	return &file_planfile_proto_enumTypes[3]
}

func (x CheckResults_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CheckResults_Status.Descriptor instead.
func (CheckResults_Status) EnumDescriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{5, 0}
}

type CheckResults_ObjectKind int32

const (
	CheckResults_UNSPECIFIED    CheckResults_ObjectKind = 0
	CheckResults_RESOURCE       CheckResults_ObjectKind = 1
	CheckResults_OUTPUT_VALUE   CheckResults_ObjectKind = 2
	CheckResults_CHECK          CheckResults_ObjectKind = 3
	CheckResults_INPUT_VARIABLE CheckResults_ObjectKind = 4
)

// Enum value maps for CheckResults_ObjectKind.
var (
	CheckResults_ObjectKind_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "RESOURCE",
		2: "OUTPUT_VALUE",
		3: "CHECK",
		4: "INPUT_VARIABLE",
	}
	CheckResults_ObjectKind_value = map[string]int32{
		"UNSPECIFIED":    0,
		"RESOURCE":       1,
		"OUTPUT_VALUE":   2,
		"CHECK":          3,
		"INPUT_VARIABLE": 4,
	}
)

func (x CheckResults_ObjectKind) Enum() *CheckResults_ObjectKind {
	p := new(CheckResults_ObjectKind)
	*p = x
	return p
}

func (x CheckResults_ObjectKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CheckResults_ObjectKind) Descriptor() protoreflect.EnumDescriptor {
	return file_planfile_proto_enumTypes[4].Descriptor()
}

func (CheckResults_ObjectKind) Type() protoreflect.EnumType {
	return &file_planfile_proto_enumTypes[4]
}

func (x CheckResults_ObjectKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CheckResults_ObjectKind.Descriptor instead.
func (CheckResults_ObjectKind) EnumDescriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{5, 1}
}

// Plan is the root message type for the tfplan file
type Plan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version is incremented whenever there is a breaking change to
	// the serialization format. Programs reading serialized plans should
	// verify that version is set to the expected value and abort processing
	// if not. A breaking change is any change that may cause an older
	// consumer to interpret the structure incorrectly. This number will
	// not be incremented if an existing consumer can either safely ignore
	// changes to the format or if an existing consumer would fail to process
	// the file for another message- or field-specific reason.
	Version uint64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The mode that was active when this plan was created.
	//
	// This is saved only for UI purposes, so that OpenTofu can tailor its
	// rendering of the plan depending on the mode. This must never be used to
	// make decisions in OpenTofu Core during the applying of a plan.
	UiMode Mode `protobuf:"varint,17,opt,name=ui_mode,json=uiMode,proto3,enum=tfplan.Mode" json:"ui_mode,omitempty"`
	// Errored is true for any plan whose creation was interrupted by an
	// error. A plan with this flag set cannot be applied, and the changes
	// it proposes are likely to be incomplete.
	Errored bool `protobuf:"varint,20,opt,name=errored,proto3" json:"errored,omitempty"`
	// The variables that were set when creating the plan. Each value is
	// a msgpack serialization of an HCL value.
	Variables map[string]*DynamicValue `protobuf:"bytes,2,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An unordered set of proposed changes to resources throughout the
	// configuration, including any nested modules. Use the address of
	// each resource to determine which module it belongs to.
	ResourceChanges []*ResourceInstanceChange `protobuf:"bytes,3,rep,name=resource_changes,json=resourceChanges,proto3" json:"resource_changes,omitempty"`
	// An unordered set of detected drift: changes made to resources outside of
	// OpenTofu, computed by comparing the previous run's state to the state
	// after refresh.
	ResourceDrift []*ResourceInstanceChange `protobuf:"bytes,18,rep,name=resource_drift,json=resourceDrift,proto3" json:"resource_drift,omitempty"`
	// An unordered set of proposed changes to outputs in the root module
	// of the configuration. This set also includes "no action" changes for
	// outputs that are not changing, as context for detecting inconsistencies
	// at apply time.
	OutputChanges []*OutputChange `protobuf:"bytes,4,rep,name=output_changes,json=outputChanges,proto3" json:"output_changes,omitempty"`
	// An unordered set of check results for the entire configuration.
	//
	// Each element represents a single static configuration object that has
	// checks, and each of those may have zero or more dynamic objects that
	// the checks were applied to nested within.
	CheckResults []*CheckResults `protobuf:"bytes,19,rep,name=check_results,json=checkResults,proto3" json:"check_results,omitempty"`
	// An unordered set of target addresses to include when applying. If no
	// target addresses are present, the plan applies to the whole
	// configuration.
	TargetAddrs []string `protobuf:"bytes,5,rep,name=target_addrs,json=targetAddrs,proto3" json:"target_addrs,omitempty"`
	// An unordered set of force-replace addresses to include when applying.
	// This must match the set of addresses that was used when creating the
	// plan, or else applying the plan will fail when it reaches a different
	// conclusion about what action a particular resource instance needs.
	ForceReplaceAddrs []string `protobuf:"bytes,16,rep,name=force_replace_addrs,json=forceReplaceAddrs,proto3" json:"force_replace_addrs,omitempty"`
	// The version string for the OpenTofu binary that created this plan.
	TerraformVersion string `protobuf:"bytes,14,opt,name=terraform_version,json=terraformVersion,proto3" json:"terraform_version,omitempty"`
	// Backend is a description of the backend configuration and other related
	// settings at the time the plan was created.
	Backend *Backend `protobuf:"bytes,13,opt,name=backend,proto3" json:"backend,omitempty"`
	// RelevantAttributes lists individual resource attributes from
	// ResourceDrift which may have contributed to the plan changes.
	RelevantAttributes []*PlanResourceAttr `protobuf:"bytes,15,rep,name=relevant_attributes,json=relevantAttributes,proto3" json:"relevant_attributes,omitempty"`
	// timestamp is the record of truth for when the plan happened.
	Timestamp string `protobuf:"bytes,21,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *Plan) Reset() {
	*x = Plan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Plan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Plan) ProtoMessage() {}

func (x *Plan) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Plan.ProtoReflect.Descriptor instead.
func (*Plan) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{0}
}

func (x *Plan) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Plan) GetUiMode() Mode {
	if x != nil {
		return x.UiMode
	}
	return Mode_NORMAL
}

func (x *Plan) GetErrored() bool {
	if x != nil {
		return x.Errored
	}
	return false
}

func (x *Plan) GetVariables() map[string]*DynamicValue {
	if x != nil {
		return x.Variables
	}
	return nil
}

func (x *Plan) GetResourceChanges() []*ResourceInstanceChange {
	if x != nil {
		return x.ResourceChanges
	}
	return nil
}

func (x *Plan) GetResourceDrift() []*ResourceInstanceChange {
	if x != nil {
		return x.ResourceDrift
	}
	return nil
}

func (x *Plan) GetOutputChanges() []*OutputChange {
	if x != nil {
		return x.OutputChanges
	}
	return nil
}

func (x *Plan) GetCheckResults() []*CheckResults {
	if x != nil {
		return x.CheckResults
	}
	return nil
}

func (x *Plan) GetTargetAddrs() []string {
	if x != nil {
		return x.TargetAddrs
	}
	return nil
}

func (x *Plan) GetForceReplaceAddrs() []string {
	if x != nil {
		return x.ForceReplaceAddrs
	}
	return nil
}

func (x *Plan) GetTerraformVersion() string {
	if x != nil {
		return x.TerraformVersion
	}
	return ""
}

func (x *Plan) GetBackend() *Backend {
	if x != nil {
		return x.Backend
	}
	return nil
}

func (x *Plan) GetRelevantAttributes() []*PlanResourceAttr {
	if x != nil {
		return x.RelevantAttributes
	}
	return nil
}

func (x *Plan) GetTimestamp() string {
	if x != nil {
		return x.Timestamp
	}
	return ""
}

// Backend is a description of backend configuration and other related settings.
type Backend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type      string        `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Config    *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	Workspace string        `protobuf:"bytes,3,opt,name=workspace,proto3" json:"workspace,omitempty"`
}

func (x *Backend) Reset() {
	*x = Backend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backend) ProtoMessage() {}

func (x *Backend) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backend.ProtoReflect.Descriptor instead.
func (*Backend) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{1}
}

func (x *Backend) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Backend) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Backend) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

// Change represents a change made to some object, transforming it from an old
// state to a new state.
type Change struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Not all action values are valid for all object types. Consult
	// the documentation for any message that embeds Change.
	Action Action `protobuf:"varint,1,opt,name=action,proto3,enum=tfplan.Action" json:"action,omitempty"`
	// msgpack-encoded HCL values involved in the change.
	//   - For update and replace, two values are provided that give the old and new values,
	//     respectively.
	//   - For create, one value is provided that gives the new value to be created
	//   - For delete, one value is provided that describes the value being deleted
	//   - For read, two values are provided that give the prior value for this object
	//     (or null, if no prior value exists) and the value that was or will be read,
	//     respectively.
	//   - For no-op, one value is provided that is left unmodified by this non-change.
	Values []*DynamicValue `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// An unordered set of paths into the old value which are marked as
	// sensitive. Values at these paths should be obscured in human-readable
	// output. This set is always empty for create.
	BeforeSensitivePaths []*Path `protobuf:"bytes,3,rep,name=before_sensitive_paths,json=beforeSensitivePaths,proto3" json:"before_sensitive_paths,omitempty"`
	// An unordered set of paths into the new value which are marked as
	// sensitive. Values at these paths should be obscured in human-readable
	// output. This set is always empty for delete.
	AfterSensitivePaths []*Path `protobuf:"bytes,4,rep,name=after_sensitive_paths,json=afterSensitivePaths,proto3" json:"after_sensitive_paths,omitempty"`
	// Importing, if true, specifies that the resource is being imported as part
	// of the change.
	Importing *Importing `protobuf:"bytes,5,opt,name=importing,proto3" json:"importing,omitempty"`
	// GeneratedConfig contains any configuration that was generated as part of
	// the change, as an HCL string.
	GeneratedConfig string `protobuf:"bytes,6,opt,name=generated_config,json=generatedConfig,proto3" json:"generated_config,omitempty"`
}

func (x *Change) Reset() {
	*x = Change{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Change) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Change) ProtoMessage() {}

func (x *Change) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Change.ProtoReflect.Descriptor instead.
func (*Change) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{2}
}

func (x *Change) GetAction() Action {
	if x != nil {
		return x.Action
	}
	return Action_NOOP
}

func (x *Change) GetValues() []*DynamicValue {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Change) GetBeforeSensitivePaths() []*Path {
	if x != nil {
		return x.BeforeSensitivePaths
	}
	return nil
}

func (x *Change) GetAfterSensitivePaths() []*Path {
	if x != nil {
		return x.AfterSensitivePaths
	}
	return nil
}

func (x *Change) GetImporting() *Importing {
	if x != nil {
		return x.Importing
	}
	return nil
}

func (x *Change) GetGeneratedConfig() string {
	if x != nil {
		return x.GeneratedConfig
	}
	return ""
}

type ResourceInstanceChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// addr is a string representation of the resource instance address that
	// this change will apply to.
	Addr string `protobuf:"bytes,13,opt,name=addr,proto3" json:"addr,omitempty"`
	// prev_run_addr is a string representation of the address at which
	// this resource instance was tracked during the previous apply operation.
	//
	// This is populated only if it would be different from addr due to
	// OpenTofu having reacted to refactoring annotations in the configuration.
	// If empty, the previous run address is the same as the current address.
	PrevRunAddr string `protobuf:"bytes,14,opt,name=prev_run_addr,json=prevRunAddr,proto3" json:"prev_run_addr,omitempty"`
	// deposed_key, if set, indicates that this change applies to a deposed
	// object for the indicated instance with the given deposed key. If not
	// set, the change applies to the instance's current object.
	DeposedKey string `protobuf:"bytes,7,opt,name=deposed_key,json=deposedKey,proto3" json:"deposed_key,omitempty"`
	// provider is the address of the provider configuration that this change
	// was planned with, and thus the configuration that must be used to
	// apply it.
	Provider string `protobuf:"bytes,8,opt,name=provider,proto3" json:"provider,omitempty"`
	// Description of the proposed change. May use "create", "read", "update",
	// "replace", "delete" and "no-op" actions.
	Change *Change `protobuf:"bytes,9,opt,name=change,proto3" json:"change,omitempty"`
	// raw blob value provided by the provider as additional context for the
	// change. Must be considered an opaque value for any consumer other than
	// the provider that generated it, and will be returned verbatim to the
	// provider during the subsequent apply operation.
	Private []byte `protobuf:"bytes,10,opt,name=private,proto3" json:"private,omitempty"`
	// An unordered set of paths that prompted the change action to be
	// "replace" rather than "update". Empty for any action other than
	// "replace".
	RequiredReplace []*Path `protobuf:"bytes,11,rep,name=required_replace,json=requiredReplace,proto3" json:"required_replace,omitempty"`
	// Optional extra user-oriented context for why change.Action was chosen.
	// This is for user feedback only and never used to drive behavior during
	// apply.
	ActionReason ResourceInstanceActionReason `protobuf:"varint,12,opt,name=action_reason,json=actionReason,proto3,enum=tfplan.ResourceInstanceActionReason" json:"action_reason,omitempty"`
}

func (x *ResourceInstanceChange) Reset() {
	*x = ResourceInstanceChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceInstanceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceInstanceChange) ProtoMessage() {}

func (x *ResourceInstanceChange) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceInstanceChange.ProtoReflect.Descriptor instead.
func (*ResourceInstanceChange) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{3}
}

func (x *ResourceInstanceChange) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

func (x *ResourceInstanceChange) GetPrevRunAddr() string {
	if x != nil {
		return x.PrevRunAddr
	}
	return ""
}

func (x *ResourceInstanceChange) GetDeposedKey() string {
	if x != nil {
		return x.DeposedKey
	}
	return ""
}

func (x *ResourceInstanceChange) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *ResourceInstanceChange) GetChange() *Change {
	if x != nil {
		return x.Change
	}
	return nil
}

func (x *ResourceInstanceChange) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ResourceInstanceChange) GetRequiredReplace() []*Path {
	if x != nil {
		return x.RequiredReplace
	}
	return nil
}

func (x *ResourceInstanceChange) GetActionReason() ResourceInstanceActionReason {
	if x != nil {
		return x.ActionReason
	}
	return ResourceInstanceActionReason_NONE
}

type OutputChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the output as defined in the root module.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the proposed change. May use "no-op", "create",
	// "update" and "delete" actions.
	Change *Change `protobuf:"bytes,2,opt,name=change,proto3" json:"change,omitempty"`
	// Sensitive, if true, indicates that one or more of the values given
	// in "change" is sensitive and should not be shown directly in any
	// rendered plan.
	Sensitive bool `protobuf:"varint,3,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
}

func (x *OutputChange) Reset() {
	*x = OutputChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputChange) ProtoMessage() {}

func (x *OutputChange) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputChange.ProtoReflect.Descriptor instead.
func (*OutputChange) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{4}
}

func (x *OutputChange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OutputChange) GetChange() *Change {
	if x != nil {
		return x.Change
	}
	return nil
}

func (x *OutputChange) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

type CheckResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind CheckResults_ObjectKind `protobuf:"varint,1,opt,name=kind,proto3,enum=tfplan.CheckResults_ObjectKind" json:"kind,omitempty"`
	// Address of the configuration object that declared the checks.
	ConfigAddr string `protobuf:"bytes,2,opt,name=config_addr,json=configAddr,proto3" json:"config_addr,omitempty"`
	// The aggregate status of the entire configuration object, based on
	// the statuses of its zero or more checkable objects.
	Status CheckResults_Status `protobuf:"varint,3,opt,name=status,proto3,enum=tfplan.CheckResults_Status" json:"status,omitempty"`
	// The results for individual objects that were declared by the
	// configuration object named in config_addr.
	Objects []*CheckResults_ObjectResult `protobuf:"bytes,4,rep,name=objects,proto3" json:"objects,omitempty"`
}

func (x *CheckResults) Reset() {
	*x = CheckResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResults) ProtoMessage() {}

func (x *CheckResults) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResults.ProtoReflect.Descriptor instead.
func (*CheckResults) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{5}
}

func (x *CheckResults) GetKind() CheckResults_ObjectKind {
	if x != nil {
		return x.Kind
	}
	return CheckResults_UNSPECIFIED
}

func (x *CheckResults) GetConfigAddr() string {
	if x != nil {
		return x.ConfigAddr
	}
	return ""
}

func (x *CheckResults) GetStatus() CheckResults_Status {
	if x != nil {
		return x.Status
	}
	return CheckResults_UNKNOWN
}

func (x *CheckResults) GetObjects() []*CheckResults_ObjectResult {
	if x != nil {
		return x.Objects
	}
	return nil
}

// DynamicValue represents a value whose type is not decided until runtime,
// often based on schema information obtained from a plugin.
//
// At present dynamic values are always encoded as msgpack, with extension
// id 0 used to represent the special "unknown" value indicating results
// that won't be known until after apply.
//
// In future other serialization formats may be used, possibly with a
// transitional period of including both as separate attributes of this type.
// Consumers must ignore attributes they don't support and fail if no supported
// attribute is present. The top-level format version will not be incremented
// for changes to the set of dynamic serialization formats.
type DynamicValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Msgpack []byte `protobuf:"bytes,1,opt,name=msgpack,proto3" json:"msgpack,omitempty"`
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{6}
}

func (x *DynamicValue) GetMsgpack() []byte {
	if x != nil {
		return x.Msgpack
	}
	return nil
}

// Path represents a set of steps to traverse into a data structure. It is
// used to refer to a sub-structure within a dynamic data structure presented
// separately.
type Path struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Steps []*Path_Step `protobuf:"bytes,1,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Path) Reset() {
	*x = Path{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Path) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path) ProtoMessage() {}

func (x *Path) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path.ProtoReflect.Descriptor instead.
func (*Path) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{7}
}

func (x *Path) GetSteps() []*Path_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Importing contains the embedded metadata about the import operation if this
// change describes it.
type Importing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original ID of the resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Importing) Reset() {
	*x = Importing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Importing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Importing) ProtoMessage() {}

func (x *Importing) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Importing.ProtoReflect.Descriptor instead.
func (*Importing) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{8}
}

func (x *Importing) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type PlanResourceAttr struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Attr     *Path  `protobuf:"bytes,2,opt,name=attr,proto3" json:"attr,omitempty"`
}

func (x *PlanResourceAttr) Reset() {
	*x = PlanResourceAttr{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlanResourceAttr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceAttr) ProtoMessage() {}

func (x *PlanResourceAttr) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceAttr.ProtoReflect.Descriptor instead.
func (*PlanResourceAttr) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PlanResourceAttr) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *PlanResourceAttr) GetAttr() *Path {
	if x != nil {
		return x.Attr
	}
	return nil
}

type CheckResults_ObjectResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ObjectAddr      string              `protobuf:"bytes,1,opt,name=object_addr,json=objectAddr,proto3" json:"object_addr,omitempty"`
	Status          CheckResults_Status `protobuf:"varint,2,opt,name=status,proto3,enum=tfplan.CheckResults_Status" json:"status,omitempty"`
	FailureMessages []string            `protobuf:"bytes,3,rep,name=failure_messages,json=failureMessages,proto3" json:"failure_messages,omitempty"`
}

func (x *CheckResults_ObjectResult) Reset() {
	*x = CheckResults_ObjectResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResults_ObjectResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResults_ObjectResult) ProtoMessage() {}

func (x *CheckResults_ObjectResult) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResults_ObjectResult.ProtoReflect.Descriptor instead.
func (*CheckResults_ObjectResult) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{5, 0}
}

func (x *CheckResults_ObjectResult) GetObjectAddr() string {
	if x != nil {
		return x.ObjectAddr
	}
	return ""
}

func (x *CheckResults_ObjectResult) GetStatus() CheckResults_Status {
	if x != nil {
		return x.Status
	}
	return CheckResults_UNKNOWN
}

func (x *CheckResults_ObjectResult) GetFailureMessages() []string {
	if x != nil {
		return x.FailureMessages
	}
	return nil
}

type Path_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Selector:
	//
	//	*Path_Step_AttributeName
	//	*Path_Step_ElementKey
	Selector isPath_Step_Selector `protobuf_oneof:"selector"`
}

func (x *Path_Step) Reset() {
	*x = Path_Step{}
	if protoimpl.UnsafeEnabled {
		mi := &file_planfile_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Path_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path_Step) ProtoMessage() {}

func (x *Path_Step) ProtoReflect() protoreflect.Message {
	mi := &file_planfile_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path_Step.ProtoReflect.Descriptor instead.
func (*Path_Step) Descriptor() ([]byte, []int) {
	return file_planfile_proto_rawDescGZIP(), []int{7, 0}
}

func (m *Path_Step) GetSelector() isPath_Step_Selector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (x *Path_Step) GetAttributeName() string {
	if x, ok := x.GetSelector().(*Path_Step_AttributeName); ok {
		return x.AttributeName
	}
	return ""
}

func (x *Path_Step) GetElementKey() *DynamicValue {
	if x, ok := x.GetSelector().(*Path_Step_ElementKey); ok {
		return x.ElementKey
	}
	return nil
}

type isPath_Step_Selector interface {
	isPath_Step_Selector()
}

type Path_Step_AttributeName struct {
	// Set "attribute_name" to represent looking up an attribute
	// in the current object value.
	AttributeName string `protobuf:"bytes,1,opt,name=attribute_name,json=attributeName,proto3,oneof"`
}

type Path_Step_ElementKey struct {
	// Set "element_key" to represent looking up an element in
	// an indexable collection type.
	ElementKey *DynamicValue `protobuf:"bytes,2,opt,name=element_key,json=elementKey,proto3,oneof"`
}

func (*Path_Step_AttributeName) isPath_Step_Selector() {}

func (*Path_Step_ElementKey) isPath_Step_Selector() {}

var File_planfile_proto protoreflect.FileDescriptor

var file_planfile_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x06, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x22, 0xdf, 0x06, 0x0a, 0x04, 0x50, 0x6c, 0x61,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x07, 0x75,
	0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x75, 0x69, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x09,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x45, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64,
	0x72, 0x69, 0x66, 0x74, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x44, 0x72, 0x69, 0x66, 0x74, 0x12, 0x3b, 0x0a, 0x0e, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x52, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x11, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41,
	0x64, 0x64, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x29, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x4b, 0x0a, 0x13,
	0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x1a, 0x52, 0x0a, 0x0e, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x61, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4d, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x12, 0x1a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x04, 0x61, 0x74, 0x74, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e,
	0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x61, 0x74, 0x74, 0x72, 0x22, 0x69, 0x0a, 0x07, 0x42, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0xc0, 0x02, 0x0a, 0x06, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x26, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61,
	0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x16, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e,
	0x50, 0x61, 0x74, 0x68, 0x52, 0x14, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x40, 0x0a, 0x15, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x52, 0x13, 0x61, 0x66, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x2f, 0x0a, 0x09,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a,
	0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd3, 0x02, 0x0a, 0x16, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x22, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x76, 0x5f,
	0x72, 0x75, 0x6e, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x70, 0x72, 0x65, 0x76, 0x52, 0x75, 0x6e, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61,
	0x6e, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x10, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x50, 0x61,
	0x74, 0x68, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x68,
	0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0xfc, 0x03, 0x0a, 0x0c, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x64, 0x64, 0x72, 0x12,
	0x33, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x3b, 0x0a, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x1a, 0x8f, 0x01, 0x0a, 0x0c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x22, 0x34, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a,
	0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x41,
	0x53, 0x53, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x22, 0x5c, 0x0a, 0x0a, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x56, 0x41, 0x52,
	0x49, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x04, 0x22, 0x28, 0x0a, 0x0c, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67, 0x70, 0x61,
	0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x70, 0x61, 0x63,
	0x6b, 0x22, 0xa5, 0x01, 0x0a, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x05, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x1a, 0x74, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x27, 0x0a, 0x0e, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48,
	0x00, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x42, 0x0a, 0x0a,
	0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x1b, 0x0a, 0x09, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x2a, 0x31, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0a,
	0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45,
	0x53, 0x54, 0x52, 0x4f, 0x59, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x46, 0x52, 0x45,
	0x53, 0x48, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x2a, 0x70, 0x0a, 0x06, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4f, 0x50, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45, 0x41,
	0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x54, 0x48, 0x45, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x48,
	0x45, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x07, 0x2a, 0xc8, 0x03, 0x0a, 0x1c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x42,
	0x59, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x52,
	0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x43,
	0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x25,
	0x0a, 0x21, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45,
	0x5f, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x10, 0x04, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f,
	0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x52, 0x45,
	0x50, 0x45, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x06, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x45, 0x41, 0x43,
	0x48, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x4d, 0x4f, 0x44,
	0x55, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45,
	0x5f, 0x42, 0x59, 0x5f, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x53, 0x10, 0x09, 0x12, 0x1f,
	0x0a, 0x1b, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x0a, 0x12,
	0x23, 0x0a, 0x1f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x42, 0x45, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f,
	0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x0b, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x42, 0x45, 0x43,
	0x41, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x4e, 0x45, 0x53, 0x54, 0x45,
	0x44, 0x10, 0x0d, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x45,
	0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x54, 0x41,
	0x52, 0x47, 0x45, 0x54, 0x10, 0x0c, 0x42, 0x40, 0x5a, 0x3e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x6f, 0x66, 0x75, 0x2f, 0x6f, 0x70,
	0x65, 0x6e, 0x74, 0x6f, 0x66, 0x75, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f,
	0x70, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70,
	0x6c, 0x61, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_planfile_proto_rawDescOnce sync.Once
	file_planfile_proto_rawDescData = file_planfile_proto_rawDesc
)

func file_planfile_proto_rawDescGZIP() []byte {
	file_planfile_proto_rawDescOnce.Do(func() {
		file_planfile_proto_rawDescData = protoimpl.X.CompressGZIP(file_planfile_proto_rawDescData)
	})
	return file_planfile_proto_rawDescData
}

var file_planfile_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_planfile_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_planfile_proto_goTypes = []interface{}{
	(Mode)(0),                         // 0: tfplan.Mode
	(Action)(0),                       // 1: tfplan.Action
	(ResourceInstanceActionReason)(0), // 2: tfplan.ResourceInstanceActionReason
	(CheckResults_Status)(0),          // 3: tfplan.CheckResults.Status
	(CheckResults_ObjectKind)(0),      // 4: tfplan.CheckResults.ObjectKind
	(*Plan)(nil),                      // 5: tfplan.Plan
	(*Backend)(nil),                   // 6: tfplan.Backend
	(*Change)(nil),                    // 7: tfplan.Change
	(*ResourceInstanceChange)(nil),    // 8: tfplan.ResourceInstanceChange
	(*OutputChange)(nil),              // 9: tfplan.OutputChange
	(*CheckResults)(nil),              // 10: tfplan.CheckResults
	(*DynamicValue)(nil),              // 11: tfplan.DynamicValue
	(*Path)(nil),                      // 12: tfplan.Path
	(*Importing)(nil),                 // 13: tfplan.Importing
	nil,                               // 14: tfplan.Plan.VariablesEntry
	(*PlanResourceAttr)(nil),          // 15: tfplan.Plan.resource_attr
	(*CheckResults_ObjectResult)(nil), // 16: tfplan.CheckResults.ObjectResult
	(*Path_Step)(nil),                 // 17: tfplan.Path.Step
}
var file_planfile_proto_depIdxs = []int32{
	0,  // 0: tfplan.Plan.ui_mode:type_name -> tfplan.Mode
	14, // 1: tfplan.Plan.variables:type_name -> tfplan.Plan.VariablesEntry
	8,  // 2: tfplan.Plan.resource_changes:type_name -> tfplan.ResourceInstanceChange
	8,  // 3: tfplan.Plan.resource_drift:type_name -> tfplan.ResourceInstanceChange
	9,  // 4: tfplan.Plan.output_changes:type_name -> tfplan.OutputChange
	10, // 5: tfplan.Plan.check_results:type_name -> tfplan.CheckResults
	6,  // 6: tfplan.Plan.backend:type_name -> tfplan.Backend
	15, // 7: tfplan.Plan.relevant_attributes:type_name -> tfplan.Plan.resource_attr
	11, // 8: tfplan.Backend.config:type_name -> tfplan.DynamicValue
	1,  // 9: tfplan.Change.action:type_name -> tfplan.Action
	11, // 10: tfplan.Change.values:type_name -> tfplan.DynamicValue
	12, // 11: tfplan.Change.before_sensitive_paths:type_name -> tfplan.Path
	12, // 12: tfplan.Change.after_sensitive_paths:type_name -> tfplan.Path
	13, // 13: tfplan.Change.importing:type_name -> tfplan.Importing
	7,  // 14: tfplan.ResourceInstanceChange.change:type_name -> tfplan.Change
	12, // 15: tfplan.ResourceInstanceChange.required_replace:type_name -> tfplan.Path
	2,  // 16: tfplan.ResourceInstanceChange.action_reason:type_name -> tfplan.ResourceInstanceActionReason
	7,  // 17: tfplan.OutputChange.change:type_name -> tfplan.Change
	4,  // 18: tfplan.CheckResults.kind:type_name -> tfplan.CheckResults.ObjectKind
	3,  // 19: tfplan.CheckResults.status:type_name -> tfplan.CheckResults.Status
	16, // 20: tfplan.CheckResults.objects:type_name -> tfplan.CheckResults.ObjectResult
	17, // 21: tfplan.Path.steps:type_name -> tfplan.Path.Step
	11, // 22: tfplan.Plan.VariablesEntry.value:type_name -> tfplan.DynamicValue
	12, // 23: tfplan.Plan.resource_attr.attr:type_name -> tfplan.Path
	3,  // 24: tfplan.CheckResults.ObjectResult.status:type_name -> tfplan.CheckResults.Status
	11, // 25: tfplan.Path.Step.element_key:type_name -> tfplan.DynamicValue
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_planfile_proto_init() }
func file_planfile_proto_init() {
	if File_planfile_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_planfile_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Plan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Backend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Change); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceInstanceChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Path); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Importing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlanResourceAttr); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResults_ObjectResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_planfile_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Path_Step); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_planfile_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Path_Step_AttributeName)(nil),
		(*Path_Step_ElementKey)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_planfile_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_planfile_proto_goTypes,
		DependencyIndexes: file_planfile_proto_depIdxs,
		EnumInfos:         file_planfile_proto_enumTypes,
		MessageInfos:      file_planfile_proto_msgTypes,
	}.Build()
	File_planfile_proto = out.File
	file_planfile_proto_rawDesc = nil
	file_planfile_proto_goTypes = nil
	file_planfile_proto_depIdxs = nil
}
