/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvutil.c,v 1.3 2004/01/17 04:09:26 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.3 $
 * $Log: rmvutil.c,v $
 * Revision 1.3  2004/01/17 04:09:26  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:23  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.5  2003/01/16 22:21:20  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.4  2002/04/30 19:40:37  wes
 * Updated copyright dates.
 *
 * Revision 1.3  2001/03/31 17:10:08  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.2  2000/04/17 00:05:24  wes
 * Lots of documentation updates, courtesy of jdb.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */


#include <rm/rm.h>
#include <rm/rmv.h>
#include "rmvprivt.h"

/*
 * ----------------------------------------------------
 * @Name rmvLOD1Reducer
 @pstart
 void rmvLOD1Reducer (RMnode *node)
 @pend

 @astart
 RMnode *node - a handle to an RMnode (modified).
 @aend

 @dstart
 
 rmvLOD1Reducer() is currently broken.

 @dend
 * ----------------------------------------------------
 */
void
rmvLOD1Reducer (RMnode *node)
{
    /*
     * construct LOD level-1 geometric models.
     *
     * 1. assumes input node has 1..n  primitives at level 0 LOD
     * 2. all non-zero LOD primitives in this node will be freed.
     * 3. each primitive at LOD 0 will have a new primitive at LOD 1.
     */
#if 0
    int i, j;
    int new_lod = 1, existing_lod = 0;
    int nprims;
    int status;
#endif

    fprintf(stderr, " rmvLOD1Reducer() is currently broken. \n");

#if 0
    lod = rmNodeGetNumLOD(node);   /* this says how many LOD's are there.. */
    if (lod > 0)
    {

        /* biff all non-zero LOD prims */
        for (j = 1; j < lod; j++)
	{
	    int nprims;
	
	    g = &(node->geometry_lod[j]);
	    nprims = rmGeometryGetNprims(g);
	    for (i = 0; i < nprims; i++)
	        rmPrimitiveDelete((RMprimitive *)rmGeometryGetPrimitive(g, i));
	}
    }
    
    g = &(node->geometry_lod[0]);
    nprims = rmGeometryGetNprims(g);
    for (i = 0; i < nprims; i++)
    {
        void *p_in, *p_out;
	
        p_in = rmGeometryGetPrimitive(g, i);
	status = rmLODReducer(node, p_in, &p_out);
	rmNodeAddPrimitive(node, p_out, new_lod);
    }
#endif
}


/*
 * ----------------------------------------------------
 * @Name rmvLOD1MeshReducer
 @pstart
 void rmvLOD1MeshReducer (float *xcoords,
		          float *ycoords,
			  float *zcoords,
			  float *data,
			  float *data2,
			  RMvisMap *vmap,
			  int axis_offset_flag,
			  int mesh_dims[2],
			  RMnode *node)
 @pend

 @astart
 float *xcoords, *ycoords, *zcoords - handles to the vertex arrays for
    the mesh (input).

 float *data - a handle to an array of floats specifying the mesh
    offset (input).

 float *data2 - a handle to an array of floats specifying the mesh
    RMvisMap indices (input).
			  
 RMvisMap *vmap - a handle to an RMvisMap object (input).
			  
 int axis_offset_flag - an RMenum specifying in which axis to
    offset.  Must be one of RMV_XAXIS_OFFSET, RMV_YAXIS_OFFSET, or
    RMV_ZAXIS_OFFSET (input).
			  
 int mesh_dims[2] - int specifying the mesh dimension (input).
			  
 RMnode *node - a handle to an RMnode (modified). 
 @aend

 @dstart

 rmvLOD1MeshReducer() is currently broken.

 @dend
 * ----------------------------------------------------
 */
void
rmvLOD1MeshReducer (float *xcoords,
		    float *ycoords,
		    float *zcoords,
		    float *data,
		    float *data2,
		    RMvisMap *vmap,
		    int axis_offset_enum,
		    int mesh_dims[2],
		    RMnode *node)
{
#if 0
    int          usize, vsize;
    int          outpoints;
    int          new_lod = 1;
    RMvertex3D  *v, *c;
    RMprimitive *p;
#endif

    fprintf(stderr, " rmvLOD1MeshReducer() is currently broken. \n");

#if 0
    {
        int    npts, id;
	double d;

	/* total number of input points */
	d  = (double)(mesh_dims[0] * mesh_dims[1]); 

	if (d <= RMV_LOD1_MAXPOINTS)
	{
	    usize = mesh_dims[0];
	    vsize = mesh_dims[1];
	}
	else
	{
	    d = d/(double)(RMV_LOD1_MAXPOINTS);
	    d = sqrt(d);

	    id = (int)d;

	    usize = mesh_dims[0] / id;
	    vsize = mesh_dims[1] / id;
	}
    }

    outpoints = usize * vsize;

    v = rmMallocVertex3DArray(outpoints);

    if ((data2 != NULL) && (vmap != NULL))
        c = rmMallocVertex3DArray(usize * vsize);
    else
        c = NULL;

    /* load up the vertex array */
    {
        int i, j;
	int oindex = 0, iindex = 0;

        for (j = 0; j < vsize; j++)
	{
	    for (i = 0; i < usize; i++)
	    {
		iindex = lod1_decimate_index(mesh_dims, usize, vsize, i, j);
		
	        v[oindex].x = xcoords[iindex];
	        v[oindex].y = ycoords[iindex];
	        v[oindex].z = zcoords[iindex];
		
		switch (axis_offset_enum)
		   {
		   case RMV_XAXIS_OFFSET:
		      v[oindex].x += data[iindex];
		      break;
		      
		   case RMV_YAXIS_OFFSET:
		      v[oindex].y += data[iindex];
		      break;
		      
		   case RMV_ZAXIS_OFFSET:
		      v[oindex].z += data[iindex];
		      break;
		      
		   default: /* bogus axis offset enum */
		      break;
		   }

		if (c)
		{
		    int index = rmVismapIndexFromData(vmap, data2[iindex]);

		    rmVismapGetColor3(vmap, index, (float *)(c + oindex));
		}
		oindex++;
	    }
	}
    }
    p = rmPrimitiveNew(RM_POINTS);
    rmPrimitiveSetVertex3D(p, outpoints, v, RM_COPY_DATA, NULL);

    if (c)
        rmPrimitiveSetColor3D(p, outpoints, c, RM_COPY_DATA, NULL);

    rmNodeSetPointSize(node, (float)3.0F);

    /* now, add the new primitive onto the node */
    rmGeometryAddLODPrimitive(node, p, new_lod);

    rmVertex3DDelete(v);
    if (c)
        rmColor3DDelete(c);
#endif
}


/*
 * ----------------------------------------------------
 * @Name rmvLOD2MeshReducer
 @pstart
 void rmvLOD2MeshReducer(RMvertex3D *bmin,
		         RMvertex3D *bmax,
			 RMnode *n)
 @pend

 @astart
 RMvertex3D *bmin - a handle to the bounding box minimum point
    (input).
		         
 RMvertex3D *bmax - a handle to the bounding box maximum point
    (input).
			 
 RMnode *n - a handle to an RMnode (modified).
 @aend

 @dstart

 rmvLOD2MesHReducer() is currently broken.

 @dend
 * ----------------------------------------------------
 */
void
rmvLOD2MeshReducer (RMvertex3D *bmin,
		    RMvertex3D *bmax,
		    RMnode *n)
{
#if 0
    int          new_lod = 2;
    int          index = 0;
    RMvertex3D   v[24];
    RMprimitive *p;
#endif

    fprintf(stderr," rmvLOD2MesHReducer() is currently broken. \n");

#if 0
    p = rmPrimitiveNew(RM_LINES_DISJOINT);
    private_AxisAlignedWireBox(bmin, bmax, v, &index, NULL, NULL);
    
    rmPrimitiveSetVertex3D(p, 24, v, RM_COPY_DATA, NULL);

    /* now, add the new primitive onto the node */
    rmGeometryAddLODPrimitive(n, p, new_lod);
#endif
}


/* PRIVATE */
int
lod1_decimate_index (int mesh_dims[2],
		     int usize,
		     int vsize,
		     int i,
		     int j)
{
    int iu, iv;

    /* check to see if we're close to the edge in U.  if so,
     set iu to be the edge.  otherwise, compute some value in the
     middle which evenly spaces i along mesh_dims[0]. */
    
    if (i == 0)
        iu = 0;
    else 
        if (i == (usize - 1))
	    iu = mesh_dims[0] - 1;
	else
            iu =  (int)((float)(mesh_dims[0] / (float)(usize - 1)) * (float)(i));

    if (j == 0)
        iv = 0;
    else 
        if (j == vsize-1)
	    iv = mesh_dims[1] - 1;
	else
	    iv = (int)((float)(mesh_dims[1] / (float)(vsize - 1)) * (float)(j));

    return((iv * mesh_dims[0]) + iu);
}


#define QUERY_SIGN(a,b) (((a) > (b)) ? 1 : ((a) < (b)) ? -1 : 0)

/* PRIVATE */
void
private_rmvInsertZeroCrossings (float *a,
			        int n,
			        float *oldx,
			        float *oldy,
			        float *oldz,
			        float *old_data2,
			        float **b,
			        float **newx,
			        float **newy,
			        float **newz,
			        int *m,
			        float **new_data2,
			        float zero_crossing_value)
{
    int    i, j, nzero_crossings;
    int    last_sign, this_sign;
    int    new_size;
    float *d, *x, *y, *z, *d2;

    nzero_crossings = 0;
    
    last_sign = QUERY_SIGN(a[0], zero_crossing_value);
    for (i = 1; i < n; i++)
    {
	this_sign = QUERY_SIGN(a[i], zero_crossing_value);

	if (last_sign != this_sign)
	{
	    if (!((last_sign == 0) || (this_sign == 0)))
		nzero_crossings++;
	}
	last_sign = this_sign;
    }

    new_size = n + nzero_crossings;
    d = *b = (float *)malloc(sizeof(float) * new_size);
    if ((new_data2) && (old_data2))
	d2 = *new_data2 = (float *)malloc(sizeof(float) * new_size);
    else
	d2 = NULL;
    
    if (newx)
	*newx = x = (float *)malloc(sizeof(float) * new_size);
    else
	x = NULL;
    
    if (newy)
	*newy = y = (float *)malloc(sizeof(float) * new_size);
    else
	y = NULL;
    
    if (newz)
	*newz = z = (float *)malloc(sizeof(float) * new_size);
    else
	z = NULL;

    *m = new_size;

    d[0] = a[0];
    if (x)
	x[0] = oldx[0];

    if (y)
	y[0] = oldy[0];

    if (z)
	z[0] = oldz[0];

    if (d2)
	d2[0] = old_data2[0];
    
    last_sign = QUERY_SIGN(a[0], zero_crossing_value);
    j = 1;
    for (i = 1; i < n; i++)
    {
	this_sign = QUERY_SIGN(a[i], zero_crossing_value);

	if (last_sign != this_sign)
	{
	    if (!((last_sign == 0) || (this_sign == 0)))
	    {
		float t;
		
		d[j] = zero_crossing_value;
		t = (a[i] - zero_crossing_value) / (a[i] - a[i - 1]);
		
		if (x)
		    x[j] = oldx[i] - (t * (oldx[i] - oldx[i - 1]));

		if (y)
		    y[j] = oldy[i] - (t * (oldy[i] - oldy[i - 1]));

		if (z)
		    z[j] = oldz[i] - (t * (oldz[i] - oldz[i - 1]));

		if (d2)
		    d2[j] = old_data2[i] - (t * (old_data2[i] - old_data2[i - 1]));
		j++;
		
		d[j] = a[i];
		if (x)
		    x[j] = oldx[i];

		if (y)
		    y[j] = oldy[i];

		if (z)
		    z[j] = oldz[i];

		if (d2)
		    d2[j] = old_data2[i];
	    }
	    else
	    {
		d[j] = a[i];

		if (x)
		    x[j] = oldx[i];

		if (y)
		    y[j] = oldy[i];

		if (z)
		    z[j] = oldz[i];

		if (d2)
		    d2[j] = old_data2[i];
	    }
	}
	else
	{
	    d[j] = a[i];

	    if (x)
		x[j] = oldx[i];

	    if (y)
		y[j] = oldy[i];

	    if (z)
		z[j] = oldz[i];

	    if (d2)
		d2[j] = old_data2[i];
	}
	j++;
	last_sign = this_sign;
    }
}


/* PRIVATE */
void
convert_from_map (unsigned char *rgba,
		  void *vmap,
		  int w,
		  int h,
		  int depth,
		  unsigned char *src)
{
    unsigned char *d;
    int            i, index;
    float          c[4];
    RMvisMap      *v;


    d = rgba;
    v = (RMvisMap *)vmap;

    for (i = 0; i < (w * h * depth); i++)
    {
	float ss;

	ss = (float)src[i];
	ss /= 255.0;
	index = rmVismapIndexFromData(v, ss);
	rmVismapGetColor4D(v, index, (RMcolor4D *)c);

	*d++ = (unsigned char)(c[0] * 255.0);
	*d++ = (unsigned char)(c[1] * 255.0);
	*d++ = (unsigned char)(c[2] * 255.0);
	*d++ = (unsigned char)(c[3] * 255.0);
    }
}


/* PRIVATE */
void
convert_from_a (unsigned char *rgba,
	        int w,
	        int h,
	        int depth,
	        unsigned char *src)
{
    unsigned char *d;
    int            i;

    d = rgba;

    for (i = 0; i < (w * h * depth); i++)
    {
	*d++ = src[i];
	*d++ = src[i];
	*d++ = src[i];
	*d++ = src[i];
    }
}
/* EOF */
