/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvbivar.c,v 1.3 2004/01/17 04:09:26 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.3 $
 * $Log: rmvbivar.c,v $
 * Revision 1.3  2004/01/17 04:09:26  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:23  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.5  2003/01/16 22:21:20  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.4  2002/04/30 19:40:00  wes
 * Updated copyright dates.
 *
 * Revision 1.3  2001/03/31 17:10:08  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.2  2000/04/20 16:17:45  wes
 * JDB modifications: code rearrangement, additional docs.
 *
 * Revision 1.1  2000/04/17 00:05:23  wes
 * Lots of documentation updates, courtesy of jdb.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */


#include <rm/rm.h>
#include <rm/rmv.h>

/* PRIVATE */
void
rmv_bivar (int npts,
	   float *inx,
	   float *iny,
	   float *indata,
	   int usize,
	   int vsize,
	   float *outx,
	   float *outy,
	   float *odata,
	   float search_radius,
	   float exponent,
	   float undef_value)

{
    int    i, j, l, k;
    int    direct_hit;
    int    index = 0;
    float  xnumer, xdenom;
    double xdist, wf, t, t2, sr2;

    sr2 = search_radius * search_radius;
    wf = exponent;
    
    for (k = 0; k < vsize; k++)  /* loop over grid J dimension */
    {
	for (j = 0; j < usize; j++)  /* loop over grid I dimension */
	{
	    xnumer = 0.0;
	    xdenom = 0.0;
	    direct_hit = 0;
	    l = 0;
	    for (i = 0; i < npts; i++)  /* loop on all input scatter points */
	    {
		t = ((inx[i] - outx[j]) * (inx[i] - outx[j])) + ((iny[i] - outy[k]) * (iny[i] - outy[k]));
		
		if (t < 1e-6)  /* if distance == 0 */
		{
		    direct_hit = 1;
		    odata[index] = indata[i];
		    break;
		}

		if (t < sr2)  /* if distance < search radius */
		{
		    l++;
		    xdist = sqrt(t);
		    t2 = 1.0 / (pow(xdist, wf));
		    xnumer = xnumer + (t2 * indata[i]);
		    xdenom = (xdenom + t2);
		}
	    }
	    if (direct_hit != 1)
	    {
		if (l == 0)
		    odata[index] = undef_value;
		else
		    odata[index] = xnumer / xdenom;
	    }
	    index++;
	}
    }
}
/* EOF */
