/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmwtext.c,v 1.3 2004/01/16 16:49:50 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.3 $
 * $Log: rmwtext.c,v $
 * Revision 1.3  2004/01/16 16:49:50  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:16  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.9  2003/01/16 22:21:17  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.8  2002/09/02 23:49:30  wes
 * Modifications for Win32 to support dynamic object pools.
 *
 * Revision 1.7  2002/04/30 19:37:09  wes
 * Updated copyright dates.
 *
 * Revision 1.6  2001/06/03 20:51:03  wes
 * Removed dead code.
 *
 * Revision 1.5  2001/03/31 17:12:39  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.4  2000/12/03 22:35:39  wes
 * Mods for thread safety.
 *
 * Revision 1.3  2000/08/23 23:33:35  wes
 * Removed unused code.
 *
 * Revision 1.2  2000/04/20 16:29:47  wes
 * Documentation additions/enhancements, some code rearragement.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#include <rm/rm.h>
#include "rmprivat.h"

#ifdef RM_WIN

/*
 * The following four arrays are used to construct an X font name
 * from user parameters.  The user can specify an enumerated font family
 * name, an enumerated size, and boolean values for italic and embolden.
 *
 * 5 fonts * 7 sizes * 4 styles = total of 140 potential font groups
 */
static char *font_families_win[] =
{ 
  {"times"},		/* RM_FONT_SERIF */
  {"helvetica"},	/* RM_FONT_SANS */
  {"courier"},		/* RM_FONT_MONO */
  {"symbol"},		/* RM_FONT_SYMBOL */
  {"zapfdingbats"}
#if 0
  {"wingdings"}		/* RM_FONT_DINGBATS */
  /* some win32 systems don't have "zapfdingbats", and "wingdings" is the
     equivalent font that is ubiquitous on Win32. we try to use zapfdingbats
     because it is equivalent to the x11 zapfdingbats font. */
#endif
};

static int font_sizes_win[] =
{
    8,		/* RM_XXS */
    10,		/* RM_XS */
    12,		/* RM_S */
    14,		/* RM_M */
    18,		/* RM_L */
    24,		/* RM_XL */
    34		/* RM_XXL */
};

/* these fonts get used if the user doesn't explicitly ask for one. */
#define NFALLBACK_FONTS 1

char fallback_fonts[NFALLBACK_FONTS][80] =
{
    {"system"}			/* 1 fallback font in windows */
};


/* PRIVATE
 *
 * private_rmPrepareBitmapFont prepares bitmap fonts for use by OpenGL
 */
RMenum
private_rmPrepareBitmapFont (RMtextProps *t,
			     RMpipe *pipe)
{
   RMfontRegistry *fr = private_rmFontRegistryEntry(t->fontEnum, t->sizeEnum, t->italicEnum, t->boldEnum, pipe->contextCache->pipeFontRegistry);

   if (fr == NULL)
       return(RM_WHACKED);

   if (fr->initialized == 0)	/* this font/size/style not yet initialized */
   {
       char   *typeface;
       char   *string;
       int     rmtfont;
       int     height;
       int     weight;		/* what's this supposed to be ? */
       int     italic;		/* what's this supposed to be? */
       HDC     hdc;
       HFONT   font;
       GLuint  base;

       if ((base = glGenLists(96)) == 0)
       {
	   rmError(" error generating display lists in rmPrepareBitmapFonts(). ");
	   return(RM_WHACKED);
       }

       hdc = pipe->hdc;	/* we need a better way to access the DC than this! */
       
       /* this needs work 5/14/99 */
       rmtfont = t->fontEnum;
       height = t->sizeEnum;
       weight = t->boldEnum;
       italic = t->italicEnum;
       /* end 5/19/99 */

       height = font_sizes_win[height];
       weight = (weight == RM_TRUE) ? 1 : 0;
       italic = (italic == RM_TRUE) ? 1 : 0;
       typeface = font_families_win[rmtfont];

       if (rmtfont == RM_FONT_SYMBOL)
	   font = CreateFont(height, 0, 0, 0, weight, italic, FALSE, FALSE, SYMBOL_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, DEFAULT_PITCH, typeface);
       else
	   font = CreateFont(height, 0, 0, 0, weight, italic, FALSE, FALSE, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, DEFAULT_PITCH, typeface);
       
       if (font == NULL)
	   rmError(" error creating a font in private_rmPrepareBitmapFonts()");

       SelectObject(hdc, font);
       wglUseFontBitmaps(hdc, 32, 96, base);

       fr->initialized = 1;
       fr->listbase = base;
       fr->refcount = 1;
       fr->fontinfo = (void *)font;
       fr->listoffset = 32;
   }
   else
       fr->refcount += 1;

#if 0
   /* 10/2000 this stuff removed from the scene graph */
   t->listbase = fr->listbase;
   t->listoffset = 32;
   t->fontinfo = fr->fontinfo;
#endif
   return(RM_CHILL);
}


/* PRIVATE 
 *
 * compute the width and height of a box containing a string rendered
 * in the specified style using a bitmap font. uses Win32 utilities.
 */
int
private_rmTextPrimComputeCW (RMtextPrim *p,
			     RMtextProps *tp,
			     RMfontRegistry *f,
			     RMpipe *pipe)
{
    char           *typeface;
    char           *string;
    HFONT           font;
    SIZE            sz;
    HDC             hdc;
    RMpipe         *cpipe;
    RMfontRegistry *fr;
    
    cpipe = pipe;
    hdc = cpipe->hdc;	/* hack! need a better way to access the DC than this! */
    
    fr = private_rmFontRegistryEntry(tp->fontEnum, tp->sizeEnum, tp->italicEnum, tp->boldEnum, cpipe->contextCache->pipeFontRegistry);
    font = (HFONT)(fr->fontinfo);
    SelectObject(hdc, font);
    string = p->string;
    if (string != NULL && string[0] != '\0')
    {
       GetTextExtentPoint(hdc, string, strlen(string), &sz);
       p->bw = sz.cx;
       p->bh = sz.cy;
       return(RM_CHILL);
    }
    else
       return(RM_WHACKED);
}
#endif /* RM_WIN */
/* EOF */
