/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmprivat.h,v 1.12 2004/01/16 16:57:39 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.12 $
 * $Log: rmprivat.h,v $
 * Revision 1.12  2004/01/16 16:57:39  wes
 * Added two private_rmPipe* declarations.
 *
 * Revision 1.11  2003/12/06 03:26:06  wes
 * Documentation tweaks to RMtime routines, updates to RMtime routines for
 * Windows.
 *
 * Revision 1.10  2003/12/01 02:13:05  wes
 * Additions to support constant frame-rate rendering on both Unix and Win32.
 *
 * Revision 1.9  2003/11/22 00:53:41  wes
 * Changes to support RMtextures being shared when assigned as scene parameters
 * to properly implement instancing.
 *
 * Revision 1.8  2003/11/05 15:29:44  wes
 * Updates for picking: now have 20 bits of node identifiers, and 8 of
 * primitive identifiers.
 *
 * Revision 1.7  2003/07/23 13:32:28  wes
 * Win32: problems with offscreen rendering appeared with new context
 * initialization code sequence (1.5.0). Minor repairs needed to fix the bug.
 *
 * Revision 1.6  2003/04/05 14:13:26  wes
 * Turn off all debugging, DEBUG_LEVEL = 0.
 *
 * Revision 1.5  2003/02/17 17:36:02  wes
 * Mods to fix Win32 compile problems.
 *
 * Revision 1.4  2003/02/14 00:19:12  wes
 * Add prototype for glCallList wrapper function.
 *
 * Revision 1.3  2003/02/02 17:50:57  wes
 * Added bounding boxes to RMprimitives, as a supplement to node-level bboxes.
 * The RMprimitive level bboxes are needed for the retained-mode CR work.
 *
 * Revision 1.2  2003/02/02 02:07:15  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.26  2003/01/27 05:04:42  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.25  2003/01/20 05:39:49  wes
 * Rewrote texture state handling code.
 *
 * Revision 1.24  2002/12/31 00:55:22  wes
 *
 * Various enhancements to support Chromium - achitecture-specific sections
 * of RMpipe were cleaned up, etc.
 *
 * Revision 1.23  2002/12/04 14:50:33  wes
 * Cleanup SGI compiles.
 *
 * Revision 1.22  2002/11/14 15:34:51  wes
 * Minor editing for beautification.
 *
 * Revision 1.21  2002/09/22 17:35:05  wes
 * Turned off debug messages used during 143 development.
 *
 * Revision 1.20  2002/09/17 14:21:05  wes
 * Added #define DEBUG_FINAL_MEMCHECK, which will cause rmComponentManagerPrintStatus
 * to be called inside rmFinish().
 *
 * Revision 1.19  2002/08/29 22:20:32  wes
 *
 * Massive upgrade to accommodate dynamic object reallocation within
 * the component manager, and within the context cache. Use the
 * debug #define DEBUG_LEVEL DEBUG_REALLOC_TRACE to get a printf
 * whenever a realloc occurs. With this upgrade, there are no
 * OpenRM limits on the size of the scene graph. There will be external
 * limits, such as the amount of RAM and the amount of space available
 * to your OpenGL implementation.
 *
 * Revision 1.18  2002/08/19 00:28:27  wes
 * Added declaration to private_rmAssert() so that it can be called
 * via a DLL in Win32 (from other OpenRM libs).
 *
 * Revision 1.17  2002/06/17 01:04:45  wes
 * Changed the number of bits available for node and primitive ID during
 * picking. New limits provide for 8192 nodes and 128 prims per node.
 *
 * Revision 1.16  2002/06/02 15:17:03  wes
 * Added RMstateCache code to help eliminate the number of state changes
 * made during the render traversal. The RMstateCache tracks
 * the actual OpenGL rendering state w/o the need for querying OpenGL
 * directly, and  is queried by draw code that then decides if any
 * real state changes are required given the configuration of data
 * within an RMprimitive.
 *
 * Revision 1.15  2002/04/30 19:33:26  wes
 * Updated copyright dates.
 *
 * Revision 1.14  2001/10/15 01:32:19  wes
 * Minor mods to support 4-byte alignment of framebuffer reads on Win32.
 * Problem showed up in demo "pdb."
 *
 * Revision 1.12  2001/07/15 17:14:24  wes
 * Added prototypes for private routines that cleanse the context cache.
 *
 * Revision 1.11  2001/06/03 20:52:02  wes
 * Added a few declarations for private routines.
 *
 * Revision 1.10  2001/05/26 14:37:49  wes
 * Added RMnode parameter to serialization code used in picking - this
 * will permit picking of scene graph subtrees that are disconnected
 * from rmRootNode().
 *
 * Revision 1.9  2001/03/31 18:46:33  wes
 * Turned off debugging for 1.4.0-alpha-2 release.
 *
 * Revision 1.8  2001/03/31 17:12:11  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.7  2000/12/03 22:35:38  wes
 * Mods for thread safety.
 *
 * Revision 1.6  2000/08/31 02:09:48  wes
 * No significant changes.
 *
 * Revision 1.5  2000/08/23 23:24:21  wes
 * DO_LISTS define moved from rmogl.c to rmprivat.h. All display
 * list code removed from rmBitmap (will be reinserted later).
 *
 * Revision 1.4  2000/05/14 23:40:52  wes
 * Single parm changes to internal routines to support new RMpipe
 * control over matrix stack initialization during rendering.
 *
 * Revision 1.3  2000/04/27 03:13:45  wes
 * Function prototype tweaks.
 *
 * Revision 1.2  2000/04/20 16:29:47  wes
 * Documentation additions/enhancements, some code rearragement.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */



#ifndef _rmprivat_h_
#define _rmprivat_h_

#if GL_EXT_texture3D
#define HAVE_3D_TEXTURES 1
#else
#define HAVE_3D_TEXTURES 0
#endif

#define DEBUG_GLERRORCHECK 0x1
#define DEBUG_TRACE        0x2
#define DEBUG_RSTATECACHECHECK 0x4
#define DEBUG_REALLOC_TRACE 0x8
#define DEBUG_FINAL_MEMCHECK 0x010
#define DEBUG_CR_BBOX      0x020

/*#define DEBUG_LEVEL DEBUG_TRACE */
/* #define DEBUG_LEVEL (DEBUG_TRACE | DEBUG_GLERRORCHECK) */
/*#define DEBUG_LEVEL DEBUG_CR_BBOX */
/*#define DEBUG_LEVEL DEBUG_GLERRORCHECK */
#define DEBUG_LEVEL 0


/* private GL stack manipulation [2] */
/*
 * To obtain lots of debugging information related to attribute
 * stack depth during rendering, use
 *   #define REAL_PUSHATTRIB 0
 * instead of #define REAL_PUSHATTRIB 1
 */
#define REAL_PUSHATTRIB 1
#if REAL_PUSHATTRIB
#define my_glPushAttrib(r,i)	glPushAttrib((i))
#define my_glPopAttrib()	glPopAttrib()
#else
int my_glPushAttrib (const RMnode *r, GLuint imask);
int my_glPopAttrib (void);
#endif

/*
 * when DO_LISTS is 1, display lists are enabled. when set to
 * zero, no OpenGL display lists will be used anywhere. (this define
 * was formerly in rmogl.c). some platforms are not happy with
 * combinations of display lists and vertex arrays.
 */
#define DO_LISTS 1 

/*
 * set DO_TIME to 1, and  per-frame rendering timer will be enabled.
 * it will spit out the render time in msec within rmFrame().
 * it may cause compilation to fail on some systems due
 * to the fact that some extra system includes are grabbed, all of
 * which do not exist across all platforms.
 */
#define DO_TIME 0

/* number of entries used to descibe the dashing pattern for line styles in postscript */
#define RM_MAX_PS_LINESTYLE_VALS 8

/* list of stuff that can be added to prims */
#define RM_PRIMITIVE_3DVERTICES			0
#define RM_PRIMITIVE_2DVERTICES			1
#define RM_PRIMITIVE_NORMALS			2
#define RM_PRIMITIVE_4COLORS			3 /* RGBA */
#define RM_PRIMITIVE_3COLORS			4 /* RGB */
#define RM_PRIMITIVE_RADII			5
#define RM_PRIMITIVE_2DTCOORDS			6
#define RM_PRIMITIVE_QMESHDIMS			7
#define RM_PRIMITIVE_OMESHDIMS			8 
#define RM_PRIMITIVE_CONE_RADII			9
#define RM_PRIMITIVE_CYLINDER_RADII		10
#define RM_PRIMITIVE_RENDERFUNC			11
#define RM_PRIMITIVE_INDEXED_TEXT_BITMAPS	12
#define RM_PRIMITIVE_MARKERS2D_SCALE		13
#define RM_PRIMITIVE_MARKERS2D_PRIM		14
#define RM_PRIMITIVE_SPRITES			15
#define RM_PRIMITIVE_BITMAPS			16
#define RM_PRIMITIVE_BITMAP_INDICES		17
#define RM_PRIMITIVE_TEXTPRIM			18
#define RM_PRIMITIVE_OMESH_MINMAX_GRID		19
#define RM_PRIMITIVE_OMESH_RECT_GRID		20
#define RM_PRIMITIVE_INDICES			21
#define RM_PRIMITIVE_4DVERTICES			22
#define RM_PRIMITIVE_3DTCOORDS			23

#define RM_PRIMITIVE_DONT_COPY_DATA		0 /* app manages memory */
#define RM_PRIMITIVE_COPY_DATA			1 /* RM manages memory */

#define C4COPY(a,b) 	(memcpy((void *)(a), (void *)(b), sizeof(RMcolor4D)))

/*
 * stuff for primitives. this structure provides configuration info
 * about each type of primitive. there's one of these configuration
 * things for each primitive
 */
#define RM_MAXBLOBS_PER_PRIMITIVE	6

/*
 * mapping from fundamental RM primitive data types to blob positions.
 * each primitive has an array of blobs. the following definitions map
 * from an RM primitive type into the array of blobs.
 */
#define BLOB_VERTEX_INDEX		0	
#define BLOB_COLOR_INDEX		1
#define BLOB_NORMAL_INDEX		2	
#define BLOB_TC_INDEX			3	
#define BLOB_QMESHDIMS_INDEX		4
#define BLOB_SCALE_INDEX		5
#define BLOB_OMESHDIMS_INDEX		6
#define BLOB_OMESH_RECTGRID_INDEX	7
#define BLOB_INDEX_INDEX		8

/*
 * We encode information into a passthrough token.  The types of information
 * encoded are:
 * 1. object/primitive/atomic specific information.  
 * 2. more general information, such as the current object index, and the
 *    current primitive index
 *
 * (others may be added in the future)
 *
 * Each passthrough token is treated as a signed 24bit integer quantity.
 * The breakdown of those 24 bits depends upon the particular type of
 * information being conveyed.
 *
 * (Currently) The one types of op's permitted are:
 * 1. Identifier  (object index, prim index, lod index)
 *
 * The uppermost 4 bits of the passthrough token are used to hold
 * the opcode.  Currently, these are:
 *
 * 0x00: Identifier
 * 0x01: 2d circle radius.
 * 0x02..0x05: 2d ellipse related stuff.
 * 0x06  indexed bitmap/text index
 * 0x07  change of render state.
 *
 * for the glPassThrough token, we can store in the glPassThrough
 * token a single number.  in this number, we can encode and extract
 * an object number (index), a primitive index, and the LOD used when
 * that primitive was rendered.  for these, we allocate:
 *
 * Updated 10/10/2003.
 * object index - 19 bits  (max 512K objects)
 * prim index -   7 bits  (max 128 primitives per object)
 *
 * the following macros are used to encode and extract this information. 
 */
#define RM_PASSTHRU_OPCODE_IDENTIFIER		0x0

/* opcode */
#define RMPASSTHRU_OPCODE_BITS     		4
#define RMPASSTHRU_OPCODE_SHIFT			26
#define RMPASSTHRU_ENCODE_OPCODE(a,b)		((a) = (a) | (((b) & 0x0f) << RMPASSTHRU_OPCODE_SHIFT))
#define RMPASSTHRU_GET_OPCODE(a)		(((a) >> RMPASSTHRU_OPCODE_SHIFT) & 0x0f)

/* object ID */
#define RMPASSTHRU_OBJECT_ID_BITS		19
#define RMPASSTHRU_OBJECT_ID_SHIFT		0
#define RMPASSTHRU_ENCODE_OBJECT_ID(a,b)	((a) = (a) | (((b) & 0x07ffff) << RMPASSTHRU_OBJECT_ID_SHIFT))
#define RMPASSTHRU_GET_OBJECT_ID(a)		(((a) >> RMPASSTHRU_OBJECT_ID_SHIFT) & 0x07ffff)

/* prim ID */
#define RMPASSTHRU_PRIM_ID_BITS			7
#define RMPASSTHRU_PRIM_ID_SHIFT		19
#define RMPASSTHRU_ENCODE_PRIM_ID(a,b)		((a) = (a) | (((b) & 0x07f) << RMPASSTHRU_PRIM_ID_SHIFT))
#define RMPASSTHRU_GET_PRIM_ID(a)		(((a) >> RMPASSTHRU_PRIM_ID_SHIFT) & 0x07f)

/* bitmap macro definitions [23] */
#define private_rmBitmapGetWidth(b)			((b)->w)
#define private_rmBitmapSetWidth(b,i)			((b)->w = (i))
#define private_rmBitmapGetHeight(b)			((b)->h)
#define private_rmBitmapSetHeight(b,i)			((b)->h = (i))
#define private_rmBitmapGetBytesPerScanline(b)		((b)->bytes_per_scanline)
#define private_rmBitmapSetBytesPerScanline(b,i)	((b)->bytes_per_scanline = (i))
#define private_rmBitmapGetPBSize(b)			((b)->pbsize)
#define private_rmBitmapSetPBSize(b,i)			((b)->pbsize = (i))
#define private_rmBitmapGetPixelData(b)			((b)->pixeldata)

/* image macro definitions [21] */
#define private_rmImageSetNDims(t,ndims)	((t)->ndims = ndims)
#define private_rmImageGetNDims(t)		((t)->ndims)
#define private_rmImageSetWidth(t,i)		((t)->w = i)
#define private_rmImageGetWidth(t)		((t)->w)
#define private_rmImageSetHeight(t,i)		((t)->h = i)
#define private_rmImageGetHeight(t)		((t)->h)
#define private_rmImageSetDepth(t,i)		((t)->d = i)
#define private_rmImageGetDepth(t)		((t)->d)
#define private_rmImageSetElements(t,i)		((t)->elements = i)
#define private_rmImageGetElements(t)		((t)->elements)
#define private_rmImageSetFormat(t,f)		((t)->image_format = f)
#define private_rmImageGetFormat(t)		((t)->image_format)
#define private_rmImageSetType(t,f)		((t)->image_type = f)
#define private_rmImageGetType(t)		((t)->image_type)
#define private_rmImageSetCopyFlag(t,i)		((t)->copy_flag = i)
#define private_rmImageGetCopyFlag(t)		((t)->copy_flag)
#define private_rmImageGetPixelData(t)		((t)->pixeldata)
#define private_rmImageGetBytesPerScanline(t)	((t)->bytes_per_scanline)
#define private_rmImageSetBytesPerScanline(t,i)	((t)->bytes_per_scanline = i)
#define private_rmImageGetCacheKey(t)           ((t)->cacheKey)
#define private_rmImageGetVismap(t)             ((t)->vismap)


#define RM_MAKE_CACHEKEY(a) ((a) & 0xFFFFFFFF)
#if 0
/* these #defines were used when the cachekey was a function of time */
#define RM_MAKE_CACHEKEY(sec,usec) (((sec) << 20) | ((usec) & 0x0fffff)) /* 32bit */
#define RM_MAKE_CACHEKEY(sec,usec) (((sec) << 32) | ((usec) & 0x0ffffffff)) /* 64 bit */
#endif

/* node macro definitions [12] */
#define   private_rmNodeSetRenderpassOpacity(n,i)	((n)->object_info.rpass_opacity = (i))
#define   private_rmNodeGetRenderpassOpacity(n)		((n)->object_info.rpass_opacity)
#define   private_rmNodeSetRenderpassDims(n,i)		((n)->object_info.rpass_vdims = (i))
#define   private_rmNodeGetRenderpassDims(n)		((n)->object_info.rpass_vdims)
#define   private_rmNodeGetNumChildren(n)		((n)->nchildren)
#define   private_rmNodeGetIthChild(a,j)		((a)->children[(j)])
#define   private_rmNodeSetTraversalMaskOpacity(n,i) ((n)->object_info.rpass_opacity = (i))
#define   private_rmNodeGetTraversalMaskOpacity(n)   ((n)->object_info.rpass_opacity)
#define   private_rmNodeSetTraversalMaskDims(n,i) ((n)->object_info.rpass_vdims = (i))
#define   private_rmNodeGetTraversalMaskDims(n)   ((n)->object_info.rpass_vdims)
#define   private_rmNodeSetTraversalMaskChannel(n,i) ((n)->object_info.channel = (i))
#define   private_rmNodeGetTraversalMaskChannel(n)   ((n)->object_info.channel)

/* RMprimitive macros [7] */
#define   private_rmPrimitiveSetType(p,t)		((p)->type = (t))
#define   private_rmPrimitiveGetType(p)			((p)->type)
#define   private_rmNodeGetName(n)			((n)->object_info.name)
#define   private_rmPrimitiveSetDisplayListEnable(p,n)	((p)->display_list_enable = (n))
#define   private_rmPrimitiveGetDisplayListEnable(p)	((p)->display_list_enable)
#define   private_rmPrimitiveSetModelFlag(p,t)		((p)->model_flag = (t))
#define   private_rmPrimitiveGetModelFlag(p)		((p)->model_flag)

/* texture macro definitions [4] */
#define    private_rmTextureGetDims(t)		((t)->dims)
#define    private_rmTextureGetNMipMaps(t)	((t)->nmipmaps)
#define    private_rmTextureSetNMipMaps(t,i)	((t)->nmipmaps = (i))
#define    private_rmTextureGetCacheKey(t)      ((t)->cacheKey)


typedef struct RMtextPrim /* PRIVATE? */
{
    char *string;	/* the string */
    int   bw, bh;	/* width/height of bitmap */
    int   ptag;		/* current font/style tag */
} RMtextPrim;

typedef struct RMSerialNodeList /* PRIVATE? */
{
    RMnode *node;	/* pointer to object */
    int     index;	/* serialized node index */
} RMSerialNodeList;

typedef struct RMLinestyleEnum /* PRIVATE? */
{
    int            enum_value;	/* enumeration value */
    int            ogl_factor;	/* stuff for OpenGL */
    unsigned short ogl_pattern;
} RMLinestyleEnum;

typedef struct RMLinewidthEnum /* PRIVATE */
{
    int   enum_value;
    float width;
} RMLinewidthEnum; 


/* rmcamera.c: view computation [1] */
void private_rmComputeViewMatrix (const RMcamera3D *, RMmatrix *, RMmatrix *);

/* rmcmpmgr.c: component manager init/manip routines [??] */
void           private_rmDeleteComponentManager(RMcompMgrHdr *);
RMcompMgrHdr * private_rmInitComponentManager(int objCount, int objSize);
RMimage      * private_rmImageNew(void);
RMenum         private_rmImageDelete(RMimage *);
RMnode       * private_rmNodeNew(void);
RMenum         private_rmNodeDelete(RMnode *);
RMprimitive  * private_rmPrimitiveNew(void);
RMenum         private_rmPrimitiveDelete(RMprimitive *);
RMtexture    * private_rmTextureNew(void);
RMenum         private_rmTextureDelete(RMtexture *);
void           private_rmPrimitiveSetCacheKey(RMprimitive *p);
void           private_rmTextureSetIDCacheKey(RMtexture *t);
void           private_rmTextureSetDataCacheKey(RMtexture *t);
RMtextProps *  private_rmTextPropsNew(void);
RMenum         private_rmTextPropsDelete(RMtextProps *r);

/* rmcr.c: CR-specific routines */
#ifdef RM_CR
void           private_rmPipeCloseContextCR (RMpipe *);
void           private_rmPipeInitCR(RMpipe *p);
#endif

/* rmdraw2.c: various rendering stuff [2] */
void private_rmStateGetTextJustify (const RMstate *s, RMenum *hjustify, RMenum *vjustify);
void private_initTrigTables (void);

/* rmframe.c: assorted private functions [12] */
void private_rmSetChannelRenderFunc (RMpipe *p);
int  private_rmTrueFilterfunc (RMnode *r);
int  private_rmFalseFilterfunc (RMnode *r);
void private_rmSubTreeFrame (RMpipe *renderPipe, RMnode *user_root, GLenum rendermode, void (*precam_func)(void), void (*perobj_func)(const RMnode *, int, int), void (*perprim_func)(RMnode *, int), int (*perchannel_func)(), void (*perstate_func)(), RMenum, RMenum, RMenum, RMenum);
void private_rmPostRender (int whichbuffer_enum, RMpipe *p);
void private_rmPostRenderDepthBuffer (GLenum whichbuffer_enum, RMpipe *p);
int  private_updateSceneParms (const RMnode *r, void (*precamFunc)(void), void (*perObjFunc)(const RMnode *, int, int), RMenum firstTime, GLenum renderMode, RMstate *rState, RMenum applyGL, int pushAttribEnable, RMpipe *renderPipe);
void private_fbClear(RMnode *r, RMstate *local_state, RMenum applyGL, RMenum fbClearEnable, RMpipe *renderPipe);
void private_computeStereoOffset (RMcamera3D *c,  RMenum whichChannel, RMcamera3D *r);
void private_postRenderBarrierFunc (RMpipe *p);
void private_postRenderImageFuncs (RMpipe *p, GLenum whichBuffer);
void private_postRenderSwapBuffersFunc (RMpipe *p);

/* rmglobal.c: text routines [2] */
int private_rmLinestyleToIndex (RMenum style_enum);
int private_rmLinewidthToIndex (RMenum style_enum);

/* rmimage.c: private image functions [15] */
int    private_rmImageGetNumElements (RMenum image_format_enum);
int    private_rmImageNumComponentBytes (RMenum type_enum);
GLenum private_rmImageGetOGLFormat (const RMimage *img);
GLenum private_rmImageGetOGLType (const RMimage *img);
RMenum private_rmImageSetGLScaleAndBias (const RMimage *src);
RMenum private_rmImageUnsetGLScaleAndBias (const RMimage *src);
RMenum private_glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixeldata, const RMimage *src);
RMenum private_glReadPixels (int x, int y, int width, int height, GLenum format, GLenum type, GLvoid *pixels);
RMenum private_rmSetLuminancePixelScale (void);
RMenum private_rmUnsetLuminancePixelScale (void);
RMenum private_rmImage2DMirrorVertical (RMimage *src);
RMenum private_rmImage2DMirrorHorizontal (RMimage *src);
RMenum private_rmImage2DResize (const RMimage *src, RMimage *dst, RMenum hardware_or_software, RMpipe *hwPipe);
RMenum private_rmImage3DResize (const RMimage *src, RMimage *dst, RMenum hardware_enum, RMpipe *hwPipe);
int    private_rmImage2DBuildMipmaps (const RMimage *img, RMimage ***maps_return, int filter_method, RMpipe *hwPipe);

/* rmmalloc.c: pointer checking [2] */
RM_EXPORT_API int  private_rmAssert (const void *a, const char *s);
#define RM_ASSERT(a,s)	private_rmAssert(a,s)

/* rmmatrix.c: coordinate conversions, deprecated private_rmPointMax [3] */
void   private_rmDCFromWC3 (RMvertex3D *a, RMvertex3D *ret, int n, RMstate *s);
void   private_rmDCFromWC2 (RMvertex3D *a, RMvertex3D *ret, int n, RMstate *s);
void   private_rmPointMax (float *input, int count, float *ret, int vnspace);

/* rmnode.c: node routines [7] */
void   private_initObjectTree (void);
void   private_rmNodeIncrementRefcount (RMnode *);
int    private_rmNodeGetRefcount (RMnode *);
int    private_rmNodeDecrementRefcount (RMnode *);
void   private_rmNodeAttribMask(RMnode *, GLuint, RMenum);
GLuint private_rmNodeGetAttribMask(const RMnode *);
GLuint private_rmNodeComputeAttribMask(const RMnode *);

/* rmogl.c: OpenGL stuff [13] */
void private_rmReadBytePixels (unsigned char *pixelbuf, int w, int h, int ncomponents, GLenum pixel_component, int bytesPerScanline);
void private_rmReadFloatPixels (float *pixelbuf, int w, int h, int ncomponents, GLenum pixel_component);
void private_rmOglSurfPropFunc (RMprimitive *p, RMnode *r, int has_norms, int has_color, RMstate *s);
void private_rmEndOglSurfPropFunc (void);
void private_rmOglLinesPropFunc (RMstate *s, RMprimitive *p, RMnode *r, int has_color, int has_tcoords);
void private_rmEndOglLinesPropFunc (void);
void private_rmOglImgPropFunc (RMprimitive *p, RMnode *r, RMstate *s);
void private_rmSetBackBuffer (RMpipe *p);
int  private_rmPrimitiveDisplayListBegin (RMpipe *pipe, RMprimitive *p);
int  private_rmPrimitiveDisplayListEnd (RMpipe *pipe, RMprimitive *p, int needFinalize);
int  private_rmPopattribWithErrorCheck (char *s);
void private_rmOGLTextureDelete(RMtexture *toDelete, RMpipe *p);
void private_glCallList(RMpipe *pipe, RMprimitive *prim, GLuint listIndx);

/* new 5/11/02, replace oglsurfprop end ogllinespropfunc */
void private_lightingStateManip(RMprimitive *p, RMstate *s, RMstateCache *rsc, RMenum forceNormals);
void private_colorMaterialStateManip(RMprimitive *p, RMstate *s, RMstateCache *rsc);
void private_rmColorMaterial(RMstate *s,RMstateCache *rsc,RMenum newVal);
void private_textureStateManip(RMprimitive *p, RMstate *s, RMstateCache *rsc);

/* rmpick.c: prims picking stuff [1] */
void private_rmComputePickMatrix (RMstate *s, RMmatrix *pickReturn);

/* rmpipe.c: pipe routines [9] */
void    private_rmPipeCopy (RMpipe *source_pipe, RMpipe *dest_pipe);
int     private_rmComparePipes (RMpipe *p1, RMpipe *p2);
RMenum  private_rmPipeIsOffscreenFormat (const RMpipe *p);
#define private_rmPipeSetPlatform(p, a) ((p)->targetPlatform = (a))
#define private_rmPipeGetPlatform(p)    ((p)->targetPlatform)
void    private_rmPipeFPSStart(RMpipe *p);
void    private_rmPipeFPSEnd(RMpipe *p);
void    private_rmPipeSetTimeSyncFunc(RMpipe *t,void (*newFunc)(RMpipe *));
void    private_rmPipeTimeSyncFunc(RMpipe *t);

/* rmprim.c: data blob & bbox routines [26] */
void                 private_rmGetBlobData (int tag, RMprimitive *p, int *stride, int *nverts, void **data, int *veclen);
void                 private_rmBlobSetFreefunc (RMprimitiveDataBlob *b, void (*freefunc)(void *));
void                 private_rmBlobSetData (RMprimitiveDataBlob *b, int num, int stride, void *stuff, RMenum copy_flag);
void                 private_rmBlobSetStride (RMprimitiveDataBlob *b, int stride);
void                 private_rmBlobSetNthings (RMprimitiveDataBlob *b, int num);
int                  private_rmBlobGetStride (RMprimitiveDataBlob *);
void                *private_rmBlobGetData (RMprimitiveDataBlob *b);	/* this will go away */
int                  private_rmBlobGetNthings (RMprimitiveDataBlob *b);
RMprimitiveDataBlob *private_rmBlobFromIndex (RMprimitive *p, int tag);
void                 private_rmBlobSetType (RMprimitiveDataBlob *b, int newtype);
int                  private_rmBlobGetType (RMprimitiveDataBlob *b);
void                 private_rmBlobSetVeclen (RMprimitiveDataBlob *b, int veclen);
int                  private_rmBlobGetVeclen (RMprimitiveDataBlob *b);
int                  private_rmBlobIndexFromPrimAtom (int tag);
RMenum               private_rmPrimitiveGetItem (RMprimitive *p, int tag, int *num,  void **stuff);
RMenum               private_rmPrimSetAssert (RMprimitive *t, int n, void *dataptr, RMenum copyEnum, void (*freefunc)(), const char *rname);
RMenum               rmPrimitiveSetItem (RMprimitive *p, int tag, int n, int stride, void *stuff, int copy_flag, void (*freefunc)(void *) );
RMenum               rmPrimitiveGetItem (RMprimitive *p, int tag, int *n, void **stuff);
/* RMprimitive bbox methods */
RMenum    private_rmPrimitiveComputeGenericBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveComputeSpheresBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveComputeCylindersBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveComputeConesBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveComputeOctmeshBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveComputeOctmeshBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveCompute2DCircleBoundingBox(RMprimitive *p);
RMenum    private_rmPrimitiveCompute2DEllipseBoundingBox(RMprimitive *p);



/* cache key macros for RMprimitives, RMtextures */
#define              private_rmPrimitiveGetCacheKey(p)   ((p)->cacheKey)
#define              private_rmTextureGetIDCacheKey(p)   ((p)->cacheKeyID)
#define              private_rmTextureGetDataCacheKey(p) ((p)->cacheKeyData)

/* rmqdrix.c: init for quadric prims, sphere routines [4] */
void private_rmInitQuadrics (RMcontextCache *c);
void private_rmCacheDeleteQuadrics (RMcontextCache *c);
void private_rmSphereTesselator (int subdivisions, RMvertex3D **sphere_verts, RMvertex3D **sphere_norms, int *face_count_return);
int  private_rmGetTrianglesPerSphere (void);

/* rmrstate.c: RM state routines [2] */
void          private_rmStateInit (const RMpipe *p, RMstate *s, RMenum rendermode, RMmatrix *initModel, RMmatrix *initView, RMmatrix *initProj, RMmatrix *initTexture);
RMstateCache *private_rmStateCacheNew (void);
void          private_rmStateCacheDelete(RMstateCache *);
void          private_rmStateCacheSync(const RMstate *s, RMstateCache *rsc);

/* rmscene.c: scene routines [2] */
RMtextProps *private_rmDefaultTextProps (RMpipe *p);
void         private_rmNodeSetSceneParms (RMnode *r, RMenum tag, void *stuff, int n);

/* rmserial.c: serialized scene graph for picking [7] */
int      private_rmBuildSerializedList (RMnode *r, int *totalNodesReturn, int *totalPrimsReturn);
int      private_rmIndexFromSerial (const RMnode *r);
RMnode  *private_rmNodeFromSerial (int index);
RMstate *private_rmStateFromSerial (int indx);
int      private_pushSerialState (RMstate *s);
int      private_rmBuildSerialState (RMpipe *p, RMnode *r, RMstate *last, int init);
int      private_rmDeleteSerialState (void);

/* rmtext.c: internal RM font registry functions [4] */
RMfontRegistry *private_rmFontRegistryNew(void);
int             private_rmFontRegistryIndex (int font_face, int font_size, int font_italic, int font_embolden);
RMfontRegistry *private_rmFontRegistryEntry (int font_face, int font_size, int font_italic, int font_embolden, RMfontRegistry *toQuery);
void   private_rmTextPropsCopy(const RMtextProps *s,RMtextProps *d);

/* rmtxture.c: texture routines [5] */
void private_rmSetPixelTransferMode (const RMvisMap *vmap);
void private_rmUnsetPixelTransferMode (void);
void private_rmTextureToOGL (RMtexture *t, int isnew);
void private_rmTextureSetRefCount(RMtexture *t,int newVal);
int  private_rmTextureGetRefCount(const RMtexture *t);


/* rmutil.c: GL imaging pipeline stuff, context init & cache keys [10] */
void       private_rmInitInternalImagingPipeline (RMpipe *hwPipe);
void       private_rmCacheFlush(RMcontextCache *toDelete);
RMenum     private_rmCacheInit(RMcontextCache **toCreate);
RMenum     private_rmCacheDelete(RMcontextCache *toDelete);
RMcacheKey private_rmGetNewCacheKey(void);
RMenum     private_rmInitCacheKeyMutex(void);
RMenum     private_rmCacheDeleteAllPrimitiveDisplayLists(RMcontextCache *c);
RMenum     private_rmCacheDeleteAllTextures(RMcontextCache *c);
RMenum     private_rmCacheDeleteAllImageDisplayLists(RMcontextCache *c);
int        private_rmCacheComputeNumberNewPages(int oldNItems,int numItemsPerPage,int newIndx);

/* rmversion.c: copyright notice [1] */
int private_rmHello (void);

/* rmx.c: X11 context stuff [1] */
RMenum private_rmxPipeCreateContext (RMpipe *pipe);
#ifdef RM_X
void    private_rmPipeCloseContextX11(RMpipe *toClose);
#endif

/* rmwtext.c, rmxtext.c: text stuff [3] */
RMenum private_rmPrepareBitmapFont (RMtextProps *t, RMpipe *p);
RMenum private_rmPrimitiveGetText (RMprimitive *t, int *nstringsReturn, RMtextPrim **primsReturn);
int    private_rmTextPrimComputeCW (RMtextPrim *, RMtextProps *, RMfontRegistry *, RMpipe *);

/* this is referenced in ifdef'ed out code in rmscene.c [318] */
void private_rmCompute2DProjectionInverse (const RMcamera2D *c, RMmatrix *m);

/* rmwin.c, win32-specific stuff [2] */
#ifdef RM_WIN
void   private_rmPipeCloseContextW32(RMpipe *toClose);
RMenum private_rmwCheckAndDisplayLastError(const char *callerMsg);
#endif


/* Win32 only: generate human-readable message from system error code */
#ifdef RM_WIN
private_rmW32Error(void);
#endif

/* scene parms  */
int private_setViewport (const RMnode *r, RMstate *s, int push_attrib_enable,  RMenum applyGL);
int process_scene_lights (const RMnode *r, int push_attrib_enable, RMstate *s,RMenum applyGL);
int private_setClipPlanes (const RMnode *r,int push_attrib_enable, RMstate *rState, RMenum applyGL);
int private_setFog (const RMnode *r, int push_attrib_enable, RMstate *rState,RMenum applyGL);
int private_manageTextureState(RMtexture *t, RMstate *rState, RMpipe *p, int push_attrib_enable, int applyGL);
int private_setSurfaceProps (const RMnode *r, int push_attrib_enable,RMstate *s,RMenum applyGL);
int private_setRenderProps (const RMnode *r, int push_attrib_enable, RMstate *s,  RMenum applyGL);
int private_setBackgroundDepthValue (const RMnode *r, RMstate *rState, int push_attrib_enable, RMenum applyGL);
int private_setBackgroundColor (const RMnode *r, RMstate *s, int push_attrib_enable, RMenum applyGL);
int private_setBackgroundTile (const RMnode *r, RMstate *s,int push_attrib_enable, RMenum applyGL);
int private_setBackgroundDepthImage (const RMnode *r,RMstate *s,int push_attrib_enable, RMenum applyGL);

int fake_gluScaleImage(GLenum format, GLsizei widthin, GLsizei heightin, GLenum typein, const void *datain, GLsizei widthout, GLsizei heightout, GLenum typeout, void *dataout);

/* from rmwin.c, win-32 stuff */
#ifdef RM_WIN
RM_EXPORT_API void private_rmwSetupDIB(HDC hDC, int width, int height, int depth);
RM_EXPORT_API void private_rmwSetupPalette(HDC hDC);
RM_EXPORT_API void private_rmwSetupPixelFormat(HDC hDC, int depth, int offscreenBool, RMenum stereoFormatBool);
#endif

#endif /* _rmprivat_h */
/* EOF */
