/*
 * This source code was obtained from 
 *     http://www.awl.com/cseng/titles/0-201-63392-2/
 * and is the source code for the programming examples of the book
 * entitled "Programming With POSIX(r) Threads" by Dave Butenhof 
 * (butenhof@zko.dec.com) (thanks Dave!) The original header (which 
 * contains no copyright) is included below. To honor the intention 
 * of the original author, there is claim of Copyright asserted in 
 * this file. We have added the log/CVS control info and this text,
 * but otherwise, the code is unmodified from it's original form.
 *
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 */
/*
 * $Revision: 1.1.1.1 $
 * $Name: OpenRM-1-5-2-RC3 $
 * $Log: barrier.h,v $
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.1  2001/03/31 17:10:46  wes
 * Initial entry.
 *
 * Revision 1.1  2000/12/02 17:22:55  wes
 * Initial entry.
 *
 */
 

/*
 * barrier.h
 *
 * This header file describes the "barrier" synchronization
 * construct. The type barrier_t describes the full state of the
 * barrier including the POSIX 1003.1c synchronization objects
 * necessary.
 *
 * A barrier causes threads to wait until a set of threads has
 * all "reached" the barrier. The number of threads required is
 * set when the barrier is initialized, and cannot be changed
 * except by reinitializing.
 */

#ifndef __barrier_h
#define __barrier_h

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Structure describing a barrier.
 */
typedef struct barrier_tag {
    pthread_mutex_t     mutex;          /* Control access to barrier */
    pthread_cond_t      cv;             /* wait for barrier */
    int                 valid;          /* set when valid */
    int                 threshold;      /* number of threads required */
    int                 counter;        /* current number of threads */
    int                 cycle;          /* alternate wait cycles (0 or 1) */
} barrier_t;

#define BARRIER_VALID   0xdbcafe

/*
 * Support static initialization of barriers
 */
#define BARRIER_INITIALIZER(cnt) \
    {PTHREAD_MUTEX_INITIALIZER, PTHREAD_COND_INITIALIZER, \
    BARRIER_VALID, cnt, cnt, 0}

/*
 * Define barrier functions
 */
extern int barrier_init (barrier_t *barrier, int count);
extern int barrier_destroy (barrier_t *barrier);
extern int barrier_wait (barrier_t *barrier);

#ifdef __cplusplus
}
#endif


#endif
