#!/bin/csh -f
#
# Copyright (C) 1997-2004, R3vis Corporation.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA, or visit http://www.gnu.org/copyleft/lgpl.html.
#
# Contributor(s):
#   Wes Bethel, R3vis Corporation, Marin County, California
#
# The OpenRM project is located at http://openrm.sourceforge.net/.
#
# $Id: makeDocs.csh,v 1.3 2004/01/17 04:04:18 wes Exp $
# Version: $Name: OpenRM-1-5-2-RC3 $
# $Revision: 1.3 $
# $Log: makeDocs.csh,v $
# Revision 1.3  2004/01/17 04:04:18  wes
# Updated copyright line for 2004.
#
# Revision 1.2  2003/07/27 15:37:15  wes
# Updated for new include structure in 1.5.0.
#
# Revision 1.1.1.1  2003/01/28 02:15:23  wes
# Manual rebuild of rm150 repository.
#
# Revision 1.4  2001/06/04 00:59:41  wes
# Added RMI to list of subdirs.
#
# Revision 1.3  2000/10/03 11:42:51  wes
# Contributions from jdb - script compaction.
#
# Revision 1.2  2000/04/20 16:16:14  wes
# JDB modifications.
#
#
# script to autogen the html documentation from the source files
# assume: we're in $OpenRM/doc when this script is run.
#
#

set path = (../doc ../../doc $path)

# clean up the old HTML documentation first
if (-e ./HTML) then
    echo "Cleaning older docs in ./doc/HTML";
    if (-e ./HTML/index.html) then
	\rm -f ./HTML/*.html;
    endif
else
    mkdir ./HTML
endif

# generate HTML pages for all files containing public functions and datatypes
foreach d (../rm ../rmaux ../rmv ../rmi ../include/rm )
    echo Making docs in $d
    pushd $d > /dev/null
    foreach f (*.c *.h)
	echo Documenting $f
	source2html.pl $f $d tempIndex.html $f.html > /dev/null
    end
    popd > /dev/null
    echo Documentation complete in $d; echo "";
end

# now, sort and trim HTML and we are done

sortlist.pl tempIndex.html index.html ./HTML

if (-r ./HTML/tempIndex.html) then
    \rm -f ./HTML/tempIndex.html > /dev/null
endif

# EOF

