/* Edit this file in -*- c -*- mode. */

/* Open Digita Services  --  Camera Device Protocol definitions.
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_send_h_)
#define _send_h_

/*--------------------------------------------------------------------------
  System include files */

#include <sys/types.h>

/*--------------------------------------------------------------------------
  Local include files */

#include "cameraP.h"

/* Start Editing Here: */

ODSResult begin_send(ODSCamera camera, unsigned long length, ods_command cmd);
ODSResult end_send(ODSCamera camera);

ODSResult send_ushort(ODSCamera camera, short s);
ODSResult send_uint(ODSCamera camera, UInteger u);
ODSResult send_sint(ODSCamera camera, SInteger s);
ODSResult send_fixed(ODSCamera camera, Fixed f);
ODSResult send_boolean(ODSCamera camera, Boolean b);
ODSResult send_bitflags(ODSCamera camera, BitFlags f);
ODSResult send_pname(ODSCamera camera, PName p);
ODSResult send_string(ODSCamera camera, const String * s);
ODSResult send_dosname(ODSCamera camera, const DOSName * d);
ODSResult send_bytes(ODSCamera camera, const void *addr, size_t len);
ODSResult send_ptvs(ODSCamera camera, PNameTypeValueStruct *);
ODSResult send_filename(ODSCamera, const FileNameStruct *filename);
ODSResult send_partialtag(ODSCamera camera, const PartialTag *partialtag);

#endif /* _send_h_ */
       /* Do not add anything below this line! */
