/* Edit this file in -*- c -*- mode. */

/* Open Digita Services	 --  Camera Device Protocol definitions.
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_cameraP_h_)
#define _cameraP_h_

/*--------------------------------------------------------------------------
  System include files */

#include "termios.h"

/*--------------------------------------------------------------------------
  Local include files */

#include "camera.h"
#include "cdpP.h"

/* Start Editing Here: */

typedef enum 
{
  ods_closed,				/* Any of the open calls are legal */
  ods_presend,				/* begin_send is legal */
  ods_send,				/* send_* are legal */
  ods_prereceive,			/* begin_rec is legal */
  ods_receive				/* rec_* are legal */
} ods_mode;

typedef enum 
{
  ods_get_product_info		= 0x0001,
  ods_get_image_specifications	= 0x0002,
  ods_get_camera_status		= 0x0003,
  ods_set_product_info		= 0x0005,
  ods_get_camera_capabilities	= 0x0010,
  ods_get_camera_state		= 0x0011,
  ods_set_camera_state		= 0x0012,
  ods_get_camera_defaults	= 0x0013,
  ods_set_camera_defaults	= 0x0014,
  ods_restore_camera_states	= 0x0015,
  ods_get_scene_analysis	= 0x0018,
  ods_get_power_mode		= 0x0019,
  ods_set_power_mode		= 0x001a,
  ods_get_s1_mode		= 0x001d,
  ods_set_s1_mode		= 0x001e,
  ods_start_capture		= 0x0030,
  ods_get_file_list		= 0x0040,
  ods_get_new_file_list		= 0x0041,
  ods_get_file_data		= 0x0042,
  ods_erase_file		= 0x0043,
  ods_get_storage_status	= 0x0044,
  ods_set_file_data		= 0x0047,
  ods_get_file_tag		= 0x0048,
  ods_set_user_file_tag		= 0x0049,
  ods_get_clock			= 0x0070,
  ods_set_clock			= 0x0071,
  ods_get_error			= 0x0078,
  ods_get_interface_timeout	= 0x0090,
  ods_set_interface_timeout	= 0x0091
} ods_command;

typedef struct _ODSCameraRec 
{
  ods_port_type		type;		/* Type of connection established */
  ods_mode		mode;		/* Protocol mode */
  int			fd;		/* Device file descriptor */
  
  ods_command		command;	/* Last command sent */
  short			result;		/* Command result */

  unsigned long		message_length;	/* Size of the message currently
					   being sent. */
  unsigned long		message_sent;	/* Number of bytes sent (by host
					   or camera) in current message. */

  void *		buffer;		/* Send/receive memory buffer */
  unsigned long		bufsize;	/* Buffer capacity */
  unsigned long		bufbytes;	/* Number of bytes stored in buffer:
					   0 <= bufbytes <= bufsize. */
  unsigned long		bufused;	/* Number of bytes used in buffer:
					   0 <= bufused <= bufbytes. */

  struct _camopts *	opts;
  unsigned long		verbosity;	/* How much output to spew */

  unsigned long		host_size;	/* Size of our receive buffer */
  unsigned long		device_size;	/* size of camera's receive buffer */

  unsigned long		data_speed;	/* serial baud rate to/from camera */
  unsigned long		timeout;	/* I/O timeout, in msec. */
  int			exit_on_error;	/* Should exit on I/O error? */
  struct termios	tty_original;	/* Original TTY settings of port */

  int			(*send_message)(struct _ODSCameraRec *);
  int			(*receive_message)(struct _ODSCameraRec *);

  ODSResult		error;		/* Last error that occurred. */
} ODSCameraRec;

void ensure_buffer_size(ODSCamera camera, unsigned int size);

#endif /* _cameraP_h_ */
/* Do not add anything below this line! */
