
/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 1995, 2004 IBM Corporation. All rights reserved.             */
/* Copyright (c) 2005-2021 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* https://www.oorexx.org/license.html                                        */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/******************************************************************************/
/* REXX Kernel                                                  okerrtxt.h    */
/*                                                                            */
/* Create table of mappings between Rexx errors and error messages            */
/*                                                                            */
/******************************************************************************/

#ifdef ERROR_TABLE

#define Table_end   0                  /* constant to mark end of table     */
#define Table_end_msg 0

ERROR_MESSAGE Message_table[] = {      /* table of major and minor errors   */


/* -------------------------------------------------------------------------- */
/* --            file is generated by build process                        -- */
/* --            ==================================================        -- */
/* --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!        -- */
/* --            ==================================================        -- */
/* -------------------------------------------------------------------------- */

    MESSAGE(Error_Program_unreadable, "Failure during initialization.")
    MESSAGE(Error_Program_unreadable_name, "Failure during initialization: File \"&1\" is unreadable.")
    MESSAGE(Error_Program_unreadable_user_defined, "&1.")
    MESSAGE(Error_Program_unreadable_notfound, "Failure during initialization: Program \"&1\" was not found.")
    MESSAGE(Error_Program_unreadable_output_error, "Error writing output file \"&1\".")
    MESSAGE(Error_Program_unreadable_version, "Program \"&1\" cannot be run by this version of the REXX interpreter.")
    MESSAGE(Error_Program_unreadable_invalid_encoding, "Encoded compiled program \"&1\" cannot be decoded.")
    MESSAGE(Error_Program_interrupted, "Program interrupted.")
    MESSAGE(Error_Program_interrupted_condition, "Program interrupted with &1 condition.")
    MESSAGE(Error_Program_interrupted_user_defined, "&1.")
    MESSAGE(Error_System_resources, "System resources exhausted.")
    MESSAGE(Error_System_resources_user_defined, "&1.")
    MESSAGE(Error_Unmatched_quote, "Unmatched \"/*\" or quote.")
    MESSAGE(Error_Unmatched_quote_comment, "Unmatched comment delimiter (\"/*\") on line &1.")
    MESSAGE(Error_Unmatched_quote_single, "Unmatched single quote (').")
    MESSAGE(Error_Unmatched_quote_double, "Unmatched double quote (\").")
    MESSAGE(Error_Unmatched_quote_user_defined, "&1.")
    MESSAGE(Error_When_expected, "WHEN or OTHERWISE expected.")
    MESSAGE(Error_When_expected_when, "SELECT on line &1 requires WHEN.")
    MESSAGE(Error_When_expected_whenotherwise, "SELECT on line &1 requires WHEN, OTHERWISE, or END.")
    MESSAGE(Error_When_expected_nootherwise, "All WHEN expressions of SELECT are false; OTHERWISE expected.")
    MESSAGE(Error_Unexpected_then, "Unexpected THEN or ELSE.")
    MESSAGE(Error_Unexpected_then_then, "THEN has no corresponding IF or WHEN clause.")
    MESSAGE(Error_Unexpected_then_else, "ELSE has no corresponding THEN clause.")
    MESSAGE(Error_Unexpected_when, "Unexpected WHEN or OTHERWISE.")
    MESSAGE(Error_Unexpected_when_when, "WHEN has no corresponding SELECT.")
    MESSAGE(Error_Unexpected_when_otherwise, "OTHERWISE has no corresponding SELECT.")
    MESSAGE(Error_Unexpected_end, "Unexpected or unmatched END.")
    MESSAGE(Error_Unexpected_end_nodo, "END has no corresponding DO, LOOP, or SELECT.")
    MESSAGE(Error_Unexpected_end_control, "Symbol following END (\"&1\") must match block specification name (\"&2\") on line &3 or be omitted.")
    MESSAGE(Error_Unexpected_end_nocontrol, "END corresponding to block on line &2 must not have a symbol following it because there is no LABEL or control variable; found \"&1\".")
    MESSAGE(Error_Unexpected_end_select, "Symbol following END (\"&1\") must match LABEL of SELECT specification (\"&2\") on line &3 or be omitted.")
    MESSAGE(Error_Unexpected_end_then, "END must not immediately follow THEN.")
    MESSAGE(Error_Unexpected_end_else, "END must not immediately follow ELSE.")
    MESSAGE(Error_Unexpected_end_select_nolabel, "END corresponding to SELECT on line &2 must not have a symbol following it because there is no LABEL; found \"&1\".")
    MESSAGE(Error_Control_stack, "Control stack full.")
    MESSAGE(Error_Control_stack_full, "Insufficient control stack space; cannot continue execution.")
    MESSAGE(Error_Control_stack_user_defined, "&1.")
    MESSAGE(Error_Invalid_character, "Invalid character in program.")
    MESSAGE(Error_Invalid_character_char, "Incorrect character in program \"&1\" ('&2'X).")
    MESSAGE(Error_Invalid_character_user_defined, "&1.")
    MESSAGE(Error_Incomplete_do, "Incomplete DO/LOOP/SELECT/IF.")
    MESSAGE(Error_Incomplete_do_do, "DO instruction on line &1 requires matching END.")
    MESSAGE(Error_Incomplete_do_select, "SELECT instruction on line &1 requires matching END.")
    MESSAGE(Error_Incomplete_do_then, "THEN on line &1 must be followed by an instruction.")
    MESSAGE(Error_Incomplete_do_else, "ELSE on line &1 must be followed by an instruction.")
    MESSAGE(Error_Incomplete_do_loop, "DO or LOOP instruction on line &1 requires matching END.")
    MESSAGE(Error_Incomplete_do_otherwise, "OTHERWISE on line &1 requires matching END.")
    MESSAGE(Error_Invalid_hex, "Invalid hexadecimal or binary string.")
    MESSAGE(Error_Invalid_hex_hexblank, "Incorrect location of whitespace character in position &1 in hexadecimal string.")
    MESSAGE(Error_Invalid_hex_binblank, "Incorrect location of whitespace character in position &1 in binary string.")
    MESSAGE(Error_Invalid_hex_invhex, "Only 0-9, a-f, A-F, and whitespace characters are valid in a hexadecimal string; found \"&1\".")
    MESSAGE(Error_Invalid_hex_invbin, "Only 0, 1, and whitespace characters are valid in a binary string; found \"&1\".")
    MESSAGE(Error_Invalid_hex_invhex_group, "Hexadecimal strings must be grouped in units that are multiples of two characters.")
    MESSAGE(Error_Invalid_hex_invbin_group, "Binary strings must be grouped in units that are multiples of four characters.")
    MESSAGE(Error_Label_not_found, "Label not found.")
    MESSAGE(Error_Label_not_found_name, "Label \"&1\" not found.")
    MESSAGE(Error_Unexpected_procedure, "Unexpected PROCEDURE.")
    MESSAGE(Error_Unexpected_procedure_call, "PROCEDURE is valid only when it is the first instruction executed after an internal CALL or function invocation.")
    MESSAGE(Error_Unexpected_procedure_interpret, "INTERPRET data must not contain PROCEDURE.")
    MESSAGE(Error_Then_expected, "THEN expected.")
    MESSAGE(Error_Then_expected_if, "IF instruction on line &1 requires matching THEN clause.")
    MESSAGE(Error_Then_expected_when, "WHEN instruction on line &1 requires matching THEN clause.")
    MESSAGE(Error_Symbol_or_string, "String or symbol expected.")
    MESSAGE(Error_Symbol_or_string_address, "String or symbol expected after ADDRESS keyword.")
    MESSAGE(Error_Symbol_or_string_call, "String or symbol expected after CALL keyword.")
    MESSAGE(Error_Symbol_or_string_name, "String or symbol expected after NAME keyword.")
    MESSAGE(Error_Symbol_or_string_signal, "String or symbol expected after SIGNAL keyword.")
    MESSAGE(Error_Symbol_or_string_trace, "String or symbol expected after TRACE keyword.")
    MESSAGE(Error_Symbol_or_string_parse, "String or symbol expected after PARSE keyword.")
    MESSAGE(Error_Symbol_or_string_user_defined, "&1.")
    MESSAGE(Error_Symbol_or_string_class, "String or symbol expected after ::CLASS keyword.")
    MESSAGE(Error_Symbol_or_string_method, "String or symbol expected after ::METHOD keyword.")
    MESSAGE(Error_Symbol_or_string_routine, "String or symbol expected after ::ROUTINE keyword.")
    MESSAGE(Error_Symbol_or_string_requires, "String or symbol expected after ::REQUIRES keyword.")
    MESSAGE(Error_Symbol_or_string_external, "String expected after EXTERNAL keyword.")
    MESSAGE(Error_Symbol_or_string_metaclass, "String or symbol expected after METACLASS keyword.")
    MESSAGE(Error_Symbol_or_string_subclass, "String or symbol expected after SUBCLASS keyword.")
    MESSAGE(Error_Symbol_or_string_inherit, "String or symbol expected after INHERIT keyword.")
    MESSAGE(Error_Symbol_or_string_tilde, "String or symbol expected after tilde (~).")
    MESSAGE(Error_Symbol_or_string_colon, "String or symbol expected after superclass colon (:).")
    MESSAGE(Error_Symbol_or_string_stream, "String or symbol expected after STREAM keyword.")
    MESSAGE(Error_Symbol_or_string_mixinclass, "String or symbol expected after MIXINCLASS keyword.")
    MESSAGE(Error_Symbol_or_string_attribute, "String or symbol expected as ::ATTRIBUTE directive name.")
    MESSAGE(Error_Symbol_or_string_constant, "String or symbol expected as ::CONSTANT directive name.")
    MESSAGE(Error_Symbol_or_string_constant_value, "String or symbol expected as ::CONSTANT value.")
    MESSAGE(Error_Symbol_or_string_digits_value, "String or symbol expected as DIGITS value.")
    MESSAGE(Error_Symbol_or_string_fuzz_value, "String or symbol expected as FUZZ value.")
    MESSAGE(Error_Symbol_or_string_trace_value, "String or symbol expected as TRACE value.")
    MESSAGE(Error_Symbol_or_string_resource, "String or symbol expected as ::RESOURCE directive name.")
    MESSAGE(Error_Symbol_or_string_resource_end, "String or symbol expected after ::RESOURCE END keyword.")
    MESSAGE(Error_Symbol_or_string_keyword, "String or symbol expected after &1 keyword.")
    MESSAGE(Error_Symbol_or_string_package_attribute_bad_value, "Symbol or string expected as ::ANNOTATE attribute value; found \"&1\".")
    MESSAGE(Error_Symbol_or_string_package_attribute_missing, "Symbol or string expected as ::ANNOTATE attribute value.")
    MESSAGE(Error_Symbol_or_string_directive_option, "Symbol or string expected after &1 &2 keyword.")
    MESSAGE(Error_Symbol_expected, "Symbol expected.")
    MESSAGE(Error_Symbol_expected_user_defined, "&1.")
    MESSAGE(Error_Symbol_expected_drop, "Symbol expected after DROP keyword.")
    MESSAGE(Error_Symbol_expected_expose, "Symbol expected after EXPOSE keyword.")
    MESSAGE(Error_Symbol_expected_parse, "Symbol expected after PARSE keyword.")
    MESSAGE(Error_Symbol_expected_var, "Symbol expected after PARSE VAR.")
    MESSAGE(Error_Symbol_expected_numeric, "NUMERIC must be followed by one of the keywords DIGITS, FORM, or FUZZ; found \"&1\".")
    MESSAGE(Error_Symbol_expected_varref, "Symbol expected after \"(\" of a variable reference.")
    MESSAGE(Error_Symbol_expected_leave, "Symbol expected after LEAVE keyword.")
    MESSAGE(Error_Symbol_expected_iterate, "Symbol expected after ITERATE keyword.")
    MESSAGE(Error_Symbol_expected_end, "Symbol expected after END keyword.")
    MESSAGE(Error_Symbol_expected_on, "Symbol expected after ON keyword.")
    MESSAGE(Error_Symbol_expected_off, "Symbol expected after OFF keyword.")
    MESSAGE(Error_Symbol_expected_use, "Symbol expected after USE ARG.")
    MESSAGE(Error_Symbol_expected_raise, "Symbol expected after RAISE keyword.")
    MESSAGE(Error_Symbol_expected_user, "Symbol expected after USER keyword.")
    MESSAGE(Error_Symbol_expected_directive, "Symbol expected after ::.")
    MESSAGE(Error_Symbol_expected_colon, "Symbol expected after superclass colon (:).")
    MESSAGE(Error_Symbol_expected_LABEL, "Symbol expected after LABEL keyword.")
    MESSAGE(Error_Symbol_expected_annotation_attribute, "Symbol expected as ::ANNOTATE attribute name; found \"&1\".")
    MESSAGE(Error_Symbol_expected_namespace, "Symbol expected after NAMESPACE keyword.")
    MESSAGE(Error_Symbol_expected_namespace_class, "Symbol expected as a class name of qualified class name.")
    MESSAGE(Error_Symbol_expected_qualified_call, "Symbol expected as a routine name of qualified CALL instruction.")
    MESSAGE(Error_Symbol_expected_qualified_symbol, "Symbol expected as a name of namespace-qualified symbol.")
    MESSAGE(Error_Symbol_expected_annotation_type, "Symbol expected for the ::ANNOTATE type.")
    MESSAGE(Error_Symbol_expected_form, "Symbol expected after the FORM keyword.")
    MESSAGE(Error_Symbol_expected_delegate, "Symbol expected after the DELEGATE keyword.")
    MESSAGE(Error_Symbol_expected_use_local, "Symbol expected after USE LOCAL.")
    MESSAGE(Error_Symbol_expected_indirect, "Symbol expected as an indirect variable name; found \"&1\".")
    MESSAGE(Error_Symbol_expected_after_keyword, "Symbol expected after &1 keyword.")
    MESSAGE(Error_Symbol_expected_after_prefix_reference, "Simple variable or stem symbol expected after > or < prefix operator; found &1.")
    MESSAGE(Error_Symbol_expected_after_use_arg_reference, "Simple variable or stem symbol expected after > or < USE ARG reference operator; found &1.")
    MESSAGE(Error_Symbol_expected_after_stem_keyword, "Stem symbol expected after STEM keyword.")
    MESSAGE(Error_Symbol_expected_address_with, "Symbol expected after WITH keyword.")
    MESSAGE(Error_Symbol_expected_counter, "Symbol expected after COUNTER keyword.")
    MESSAGE(Error_Invalid_data, "Invalid data on end of clause.")
    MESSAGE(Error_Invalid_data_user_defined, "&1.")
    MESSAGE(Error_Invalid_data_nop, "Data must not follow the NOP keyword; found \"&1\".")
    MESSAGE(Error_Invalid_data_select, "Data must not follow the SELECT keyword; found \"&1\".")
    MESSAGE(Error_Invalid_data_name, "Data must not follow the NAME keyword; found \"&1\".")
    MESSAGE(Error_Invalid_data_condition, "Data must not follow the condition name; found \"&1\".")
    MESSAGE(Error_Invalid_data_signal, "Data must not follow the SIGNAL label name; found \"&1\".")
    MESSAGE(Error_Invalid_data_trace, "Data must not follow the TRACE setting; found \"&1\".")
    MESSAGE(Error_Invalid_data_leave, "Data must not follow the LEAVE control variable name; found \"&1\".")
    MESSAGE(Error_Invalid_data_iterate, "Data must not follow the ITERATE control variable name; found \"&1\".")
    MESSAGE(Error_Invalid_data_end, "Data must not follow the END control variable name; found \"&1\".")
    MESSAGE(Error_Invalid_data_form, "Data must not follow the NUMERIC FORM specification; found \"&1\".")
    MESSAGE(Error_Invalid_data_guard_off, "Data must not follow the GUARD OFF specification; found \"&1\".")
    MESSAGE(Error_Invalid_data_constant_dir, "Data must not follow the ::CONSTANT value; found \"&1\".")
    MESSAGE(Error_Invalid_data_resource_dir, "Data must not follow the ::RESOURCE directive; found \"&1\".")
    MESSAGE(Error_Invalid_character_string, "Invalid character string.")
    MESSAGE(Error_Invalid_character_string_char, "Incorrect character string \"&1\" ('&2'X).")
    MESSAGE(Error_Invalid_character_string_user_defined, "&1.")
    MESSAGE(Error_Invalid_character_string_DBCS, "Incorrect double-byte character.")
    MESSAGE(Error_Invalid_data_string, "Invalid data string.")
    MESSAGE(Error_Invalid_data_string_char, "Incorrect data string \"&1\" ('&2'X).")
    MESSAGE(Error_Invalid_data_string_user_defined, "&1.")
    MESSAGE(Error_Invalid_trace, "Invalid TRACE request.")
    MESSAGE(Error_Invalid_trace_trace, "TRACE request letter must be one of \"ACEFILNOR\"; found  \"&1\".")
    MESSAGE(Error_Invalid_trace_debug, "Numeric TRACE requests are valid only from interactive debugging.")
    MESSAGE(Error_Invalid_subkeyword, "Invalid subkeyword found.")
    MESSAGE(Error_Invalid_subkeyword_callon, "CALL ON must be followed by one of the keywords ERROR, FAILURE, HALT, NOTREADY, USER, or ANY; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_calloff, "CALL OFF must be followed by one of the keywords ERROR, FAILURE, HALT, NOTREADY, USER, or ANY; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_signalon, "SIGNAL ON must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOTREADY, NOMETHOD, NOSTRING, NOVALUE, SYNTAX, USER, or ANY; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_signaloff, "SIGNAL OFF must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOTREADY, NOMETHOD, NOSTRING, NOVALUE, SYNTAX, USER, or ANY; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_form, "NUMERIC FORM must be followed by one of the keywords SCIENTIFIC or ENGINEERING; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_parse, "PARSE must be followed by one of the keywords ARG, LINEIN, PULL, SOURCE, VALUE, VAR, or VERSION; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_numeric, "NUMERIC must be followed by one of the keywords DIGITS, FORM, or FUZZ; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_procedure, "PROCEDURE must be followed by the keyword EXPOSE or nothing; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_string_user_defined, "&1.")
    MESSAGE(Error_Invalid_subkeyword_class, "Unknown keyword on ::CLASS directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_method, "Unknown keyword on ::METHOD directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_routine, "Unknown keyword on ::ROUTINE directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_requires, "Unknown keyword on ::REQUIRES directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_use, "USE must be followed by the keyword ARG or LOCAL; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_raise, "RAISE must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOMETHOD, NOSTRING, NOTREADY, NOVALUE, PROPAGATE, SYNTAX, or USER; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_raiseoption, "Unknown keyword on RAISE instruction; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_description, "Duplicate DESCRIPTION keyword found.")
    MESSAGE(Error_Invalid_subkeyword_additional, "Duplicate ADDITIONAL or ARRAY keyword found.")
    MESSAGE(Error_Invalid_subkeyword_result, "Duplicate RETURN or EXIT keyword found.")
    MESSAGE(Error_Invalid_subkeyword_guard_on, "GUARD ON or GUARD OFF must be followed by the keyword WHEN; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_guard, "GUARD must be followed by the keyword ON or OFF; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_callonname, "CALL ON condition must be followed by the keyword NAME; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_signalonname, "SIGNAL ON condition must be followed by the keyword NAME; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_forward_option, "Unknown keyword on FORWARD instruction; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_to, "Duplicate TO keyword found.")
    MESSAGE(Error_Invalid_subkeyword_arguments, "Duplicate ARGUMENTS or ARRAY keyword found.")
    MESSAGE(Error_Invalid_subkeyword_continue, "Duplicate RETURN or CONTINUE keyword found.")
    MESSAGE(Error_Invalid_subkeyword_forward_class, "Duplicate CLASS keyword found.")
    MESSAGE(Error_Invalid_subkeyword_message, "Duplicate MESSAGE keyword found.")
    MESSAGE(Error_Invalid_subkeyword_select, "SELECT must be followed by the keyword LABEL or CASE; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_options, "Unknown keyword on ::OPTIONS directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_attribute, "Unknown keyword on ::ATTRIBUTE directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_resource, "Unknown keyword on ::RESOURCE directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_following, "Unknown keyword following \"&1\"; found \"&2\".")
    MESSAGE(Error_Invalid_subkeyword_annotation, "Unknown keyword on ::ANNOTATE directive; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_use_strict, "USE STRICT must be followed by the keyword ARG; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_address_input, "Duplicate INPUT keyword found.")
    MESSAGE(Error_Invalid_subkeyword_address_output, "Duplicate OUTPUT keyword found.")
    MESSAGE(Error_Invalid_subkeyword_address_error, "Duplicate ERROR keyword found.")
    MESSAGE(Error_Invalid_subkeyword_address_with_io_option, "Acceptable ADDRESS WITH I/O types are STEM, STREAM, and USING; found \"&1\".")
    MESSAGE(Error_Invalid_subkeyword_address_with_option, "WITH must be followed by one of the keywords INPUT, OUTPUT, or ERROR; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number, "Invalid whole number.")
    MESSAGE(Error_Invalid_whole_number_repeat, "Value of repetition count expression in DO or LOOP instruction must be zero or a positive whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_for, "Value of FOR expression in DO or LOOP instruction must be zero or a positive whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_parse, "Positional pattern of PARSE template must be a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_digits, "DIGITS value must be a positive whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_fuzz, "FUZZ value must be zero or a positive whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_trace, "Number used in TRACE setting must be a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_power, "Operand to the right of the power operator (**) must be a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_intdiv, "Result of % operation did not result in a whole number.")
    MESSAGE(Error_Invalid_whole_number_rem, "Result of // operation did not result in a whole number.")
    MESSAGE(Error_Invalid_whole_number_user_defined, "&1.")
    MESSAGE(Error_Invalid_whole_number_method, "Result of a method call did not result in a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_compareto, "Result of a COMPARETO method call did not result in a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_compare, "Result of a COMPARE method call did not result in a whole number; found \"&1\".")
    MESSAGE(Error_Invalid_whole_number_stem_array_index, "Stem \"&1\" element 0 is not a whole number; found \"&2\".")
    MESSAGE(Error_Invalid_do, "Invalid DO or LOOP syntax.")
    MESSAGE(Error_Invalid_do_whileuntil, "Only one WHILE or UNTIL condition can be used on the same loop.")
    MESSAGE(Error_Invalid_do_forever, "Incorrect data following FOREVER keyword on the loop; found \"&1\".")
    MESSAGE(Error_Invalid_do_duplicate, "DO or LOOP keyword &1 can be specified only once.")
    MESSAGE(Error_Invalid_do_with_no_control, "No INDEX or ITEM control variable specified on a WITH loop.")
    MESSAGE(Error_Invalid_do_with_no_over, "OVER keyword expected for a WITH loop.")
    MESSAGE(Error_Invalid_do_simple_do_counter, "COUNTER keyword not allowed on a simple DO instruction.")
    MESSAGE(Error_Invalid_leave, "Invalid LEAVE or ITERATE.")
    MESSAGE(Error_Invalid_leave_leave, "LEAVE is valid only within a repetitive loop or labeled block instruction.")
    MESSAGE(Error_Invalid_leave_iterate, "ITERATE is valid only within a repetitive loop.")
    MESSAGE(Error_Invalid_leave_leavevar, "Symbol following LEAVE (\"&1\") must either match the label of a current loop or block instruction.")
    MESSAGE(Error_Invalid_leave_iteratevar, "Symbol following ITERATE (\"&1\") must either match the label of a current loop or be omitted.")
    MESSAGE(Error_Invalid_leave_iterate_name, "Symbol following ITERATE (\"&1\") does not match a repetitive block instruction.")
    MESSAGE(Error_Environment_name, "Environment name too long.")
    MESSAGE(Error_Environment_name_name, "Environment name exceeds &1 characters; found \"&2\".")
    MESSAGE(Error_Name_too_long, "Name or symbol too long.")
    MESSAGE(Error_Name_too_long_name, "Name or symbol exceeds 250 characters:  \"&1\".")
    MESSAGE(Error_Name_too_long_user_defined, "&1.")
    MESSAGE(Error_Invalid_variable, "Name starts with number or \".\".")
    MESSAGE(Error_Invalid_variable_assign, "A value cannot be assigned to a number; found \"&1\".")
    MESSAGE(Error_Invalid_variable_number, "Variable symbol must not start with a number; found \"&1\".")
    MESSAGE(Error_Invalid_variable_period, "Variable symbol must not start with a \".\"; found \"&1\".")
    MESSAGE(Error_Invalid_variable_user_defined, "&1.")
    MESSAGE(Error_Expression_result, "Invalid expression result.")
    MESSAGE(Error_Expression_result_digits, "Value of NUMERIC DIGITS (\"&1\") must exceed value of NUMERIC FUZZ (\"&2\").")
    MESSAGE(Error_Expression_result_maxdigits, "Value of NUMERIC DIGITS (\"&1\") must not exceed &2.")
    MESSAGE(Error_Expression_user_defined, "&1.")
    MESSAGE(Error_Expression_result_address, "Incorrect expression result following VALUE keyword of ADDRESS instruction.")
    MESSAGE(Error_Expression_result_signal, "Incorrect expression result following VALUE keyword of SIGNAL instruction.")
    MESSAGE(Error_Expression_result_trace, "Incorrect expression result following VALUE keyword of TRACE instruction.")
    MESSAGE(Error_Expression_result_raise, "Incorrect expression result following SYNTAX keyword of RAISE instruction.")
    MESSAGE(Error_Logical_value, "Logical value not 0 or 1.")
    MESSAGE(Error_Logical_value_if, "Value of expression following IF keyword must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_when, "Value of expression following WHEN keyword must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_while, "Value of expression following WHILE keyword must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_until, "Value of expression following UNTIL keyword must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_logical, "Value of expression to the left of the logical operator \"&1\" must be exactly \"0\" or \"1\"; found \"&2\".")
    MESSAGE(Error_Logical_value_logical_list, "Value of logical list expression element must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_user_defined, "&1.")
    MESSAGE(Error_Logical_value_method, "Logical value must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_guard, "Value of expression following GUARD keyword must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_authorization, "Authorization return value must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_property, "Property logical value must be exactly \"0\", \"1\", \"true\", or \"false\"; found \"&1\".")
    MESSAGE(Error_Logical_value_when_case, "SELECT CASE comparison result must be exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Logical_value_supplier, "Supplier AVAILABLE method did not return exactly \"0\" or \"1\"; found \"&1\".")
    MESSAGE(Error_Invalid_expression, "Invalid expression.")
    MESSAGE(Error_Invalid_expression_general, "Incorrect expression detected at \"&1\".")
    MESSAGE(Error_Invalid_expression_user_defined, "&1.")
    MESSAGE(Error_Invalid_expression_prefix, "Prefix operator \"&1\" is not followed by an expression term.")
    MESSAGE(Error_Invalid_expression_if, "Missing conditional expression following IF keyword.")
    MESSAGE(Error_Invalid_expression_when, "Missing conditional expression following WHEN keyword.")
    MESSAGE(Error_Invalid_expression_control, "Missing initial expression for DO or LOOP control variable.")
    MESSAGE(Error_Invalid_expression_by, "Missing expression following BY keyword.")
    MESSAGE(Error_Invalid_expression_to, "Missing expression following TO keyword.")
    MESSAGE(Error_Invalid_expression_for, "Missing expression following FOR keyword.")
    MESSAGE(Error_Invalid_expression_while, "Missing expression following WHILE keyword.")
    MESSAGE(Error_Invalid_expression_until, "Missing expression following UNTIL keyword.")
    MESSAGE(Error_Invalid_expression_over, "Missing expression following OVER keyword.")
    MESSAGE(Error_Invalid_expression_interpret, "Missing expression following INTERPRET keyword.")
    MESSAGE(Error_Invalid_expression_options, "Missing expression following OPTIONS keyword.")
    MESSAGE(Error_Invalid_expression_address, "Missing expression following VALUE keyword of an ADDRESS instruction.")
    MESSAGE(Error_Invalid_expression_signal, "Missing expression following VALUE keyword of a SIGNAL instruction.")
    MESSAGE(Error_Invalid_expression_trace, "Missing expression following VALUE keyword of a TRACE instruction.")
    MESSAGE(Error_Invalid_expression_form, "Missing expression following VALUE keyword of a NUMERIC FORM instruction.")
    MESSAGE(Error_Invalid_expression_assign, "Missing expression following assignment instruction.")
    MESSAGE(Error_Invalid_expression_operator, "Operator \"&1\" is not followed by an expression term.")
    MESSAGE(Error_Invalid_expression_guard, "Missing expression following GUARD keyword.")
    MESSAGE(Error_Invalid_expression_raise_description, "Missing expression following DESCRIPTION keyword of a RAISE instruction.")
    MESSAGE(Error_Invalid_expression_raise_additional, "Missing expression following ADDITIONAL keyword of a RAISE instruction.")
    MESSAGE(Error_Invalid_expression_raise_list, "Missing \"(\" on expression list of the ARRAY keyword.")
    MESSAGE(Error_Invalid_expression_forward_to, "Missing expression following TO keyword of a FORWARD instruction.")
    MESSAGE(Error_Invalid_expression_forward_arguments, "Missing expression following ARGUMENTS keyword of a FORWARD instruction.")
    MESSAGE(Error_Invalid_expression_forward_message, "Missing expression following MESSAGE keyword of a FORWARD instruction.")
    MESSAGE(Error_Invalid_expression_forward_class, "Missing expression following CLASS keyword of a FORWARD instruction.")
    MESSAGE(Error_Invalid_expression_logical_list, "Missing expression in logical expression list.")
    MESSAGE(Error_Invalid_expression_use_arg_default, "Invalid or missing expression following \"=\" token of a USE ARG instruction.")
    MESSAGE(Error_Invalid_expression_parse, "Missing expression following \"(\" of parse template.")
    MESSAGE(Error_Invalid_expression_call, "Missing expression for calculated CALL name.")
    MESSAGE(Error_Invalid_expression_select_case, "Missing expression following CASE keyword of a SELECT instruction.")
    MESSAGE(Error_Invalid_expression_case_when_list, "Missing expression in WHEN case expression list.")
    MESSAGE(Error_Invalid_expression_missing_general, "Missing expression following &1 keyword of a &2 instruction.")
    MESSAGE(Error_Invalid_expression_missing_constant, "Missing expression on ::CONSTANT directive.")
    MESSAGE(Error_Unmatched_parenthesis, "Unmatched \"(\" or \"[\" in expression.")
    MESSAGE(Error_Unmatched_parenthesis_user_defined, "&1.")
    MESSAGE(Error_Unmatched_parenthesis_paren, "Left parenthesis \"(\" in position &1 on line &2 requires a corresponding right parenthesis \")\".")
    MESSAGE(Error_Unmatched_parenthesis_square, "Square bracket \"[\" in position &1 on line &2 requires a corresponding right square bracket \"]\".")
    MESSAGE(Error_Unexpected_comma, "Unexpected \",\", \")\", or \"]\".")
    MESSAGE(Error_Unexpected_comma_comma, "Unexpected \",\".")
    MESSAGE(Error_Unexpected_comma_paren, "Unmatched \")\" in expression.")
    MESSAGE(Error_Unexpected_comma_user_defined, "&1.")
    MESSAGE(Error_Unexpected_comma_bracket, "Unexpected \"]\".")
    MESSAGE(Error_Invalid_template, "Invalid template or pattern.")
    MESSAGE(Error_Invalid_template_trigger, "Incorrect PARSE template detected at \"&1\".")
    MESSAGE(Error_Invalid_template_position, "Incorrect PARSE position detected at \"&1\".")
    MESSAGE(Error_Invalid_template_with, "PARSE VALUE instruction requires WITH keyword.")
    MESSAGE(Error_Invalid_template_user_defined, "&1.")
    MESSAGE(Error_Invalid_template_missing, "Missing PARSE relative position.")
    MESSAGE(Error_Evaluation_stack_overflow, "Evaluation stack overflow.")
    MESSAGE(Error_Incorrect_call, "Incorrect call to routine.")
    MESSAGE(Error_Incorrect_call_external, "External routine \"&1\" failed.")
    MESSAGE(Error_Incorrect_call_minarg, "Not enough arguments in invocation of &1; minimum expected is &2.")
    MESSAGE(Error_Incorrect_call_maxarg, "Too many arguments in invocation of &1; maximum expected is &2.")
    MESSAGE(Error_Incorrect_call_noarg, "Missing argument in invocation of &1; argument &2 is required.")
    MESSAGE(Error_Incorrect_call_number, "&1 argument &2 must be a number; found \"&3\".")
    MESSAGE(Error_Incorrect_call_whole, "&1 argument &2 must be a whole number; found \"&3\".")
    MESSAGE(Error_Incorrect_call_nonnegative, "&1 argument &2 must be zero or positive; found \"&3\".")
    MESSAGE(Error_Incorrect_call_positive, "&1 argument &2 must be positive; found \"&3\".")
    MESSAGE(Error_Incorrect_call_format_invalid, "&1 argument 2, \"&2\", is not in the format described by argument 3, \"&3\".")
    MESSAGE(Error_Incorrect_call_null, "&1 argument &2 must not be a null string.")
    MESSAGE(Error_Incorrect_call_option, "&1 argument &2 must be a single character or null; found \"&3\".")
    MESSAGE(Error_Incorrect_call_pad, "&1 argument &2 must be a single character; found \"&3\".")
    MESSAGE(Error_Incorrect_call_binary, "&1 argument &2 must be a binary string; found \"&3\".")
    MESSAGE(Error_Incorrect_call_hex, "&1 argument &2 must be a hexadecimal string; found \"&3\".")
    MESSAGE(Error_Incorrect_call_symbol, "&1 argument &2 must be a valid symbol; found \"&3\".")
    MESSAGE(Error_Incorrect_call_stream_name, "&1 argument 1 must be a valid stream name; found \"&2\".")
    MESSAGE(Error_Incorrect_call_pad_or_name, "&1 argument &2 must be a character class name or a single character; found \"&3\".")
    MESSAGE(Error_Incorrect_call_invalid_conversion, "&1 conversion to format \"&2\" is not allowed.")
    MESSAGE(Error_Incorrect_call_random_range, "RANDOM difference between argument 1 (\"&1\") and argument 2 (\"&2\") must not exceed 999,999,999.")
    MESSAGE(Error_Incorrect_call_random, "RANDOM argument 1 (\"&1\") must be less than or equal to argument 2 (\"&2\").")
    MESSAGE(Error_Incorrect_call_sourceline, "SOURCELINE argument 1 (\"&1\") must be less than or equal to the number of lines in the program (&2).")
    MESSAGE(Error_Incorrect_call_x2d, "X2D argument 1 cannot be expressed as a whole number; found \"&1\".")
    MESSAGE(Error_Incorrect_call_parm_wrong_sep, "&1 argument &2 must be a single non-alphanumeric character or the null string; found \"&3\".")
    MESSAGE(Error_Incorrect_call_format_incomp_sep, "&1 argument &2, \"&3\", is a format incompatible with the separator specified in argument &4.")
    MESSAGE(Error_Incorrect_call_user_defined, "&1.")
    MESSAGE(Error_Incorrect_call_result, "Result returned by &1 is longer than &2:  \"&3\".")
    MESSAGE(Error_Incorrect_call_toobig, "&1 argument &2 must not exceed the whole number limit.")
    MESSAGE(Error_Incorrect_call_range, "&1 argument &2 must be in the range 0-99; found \"&3\".")
    MESSAGE(Error_Incorrect_call_list, "&1 argument &2 must be one of &3; found \"&4\".")
    MESSAGE(Error_Incorrect_call_trace, "TRACE setting letter must be one of \"ACEFILNOR\"; found \"&1\".")
    MESSAGE(Error_Incorrect_call_array, "&1 argument &2 must be a single-dimensional array; found \"&3\".")
    MESSAGE(Error_Incorrect_call_nostring, "&1 argument &2 must have a string value; found \"&3\".")
    MESSAGE(Error_Incorrect_call_selector, "Unknown VALUE function variable environment selector; found \"&1\".")
    MESSAGE(Error_Incorrect_call_queue_no_char, "&1 cannot be used with QUEUE:.")
    MESSAGE(Error_Incorrect_call_read_from_writeonly, "Cannot read from a write-only property.")
    MESSAGE(Error_Incorrect_call_write_to_readonly, "Cannot write to a read-only property or typelib element.")
    MESSAGE(Error_Incorrect_call_signature, "Invalid native function signature specification.")
    MESSAGE(Error_Incorrect_call_nostem, "Argument &1 must have a stem object or stem name value; found \"&2\".")
    MESSAGE(Error_Incorrect_call_bad_option, "&1 argument &2 must be one of \"&3\"; found \"&4\".")
    MESSAGE(Error_Incorrect_call_relative, "Argument &1 (\"&2\") must be greater than argument &3 (\"&4\").")
    MESSAGE(Error_Incorrect_call_stem_size, "Stem argument does not have a valid count for element 0.")
    MESSAGE(Error_Incorrect_call_stem_range, "The operation is outside the size of the stem array (\"&1\").")
    MESSAGE(Error_Incorrect_call_stem_sparse_array, "Stem element at position \"&1\" is not set.")
    MESSAGE(Error_Incorrect_call_noarray_nostem, "Argument &1 must be an array object, a stem object, or a stem name value; found \"&2\".")
    MESSAGE(Error_Conversion, "Bad arithmetic conversion.")
    MESSAGE(Error_Conversion_operator, "Nonnumeric value (\"&1\") used in arithmetic operation.")
    MESSAGE(Error_Conversion_prefix, "Nonnumeric value (\"&1\") used with prefix operator.")
    MESSAGE(Error_Conversion_to, "Value of TO expression of DO or LOOP instruction must be numeric; found \"&1\".")
    MESSAGE(Error_Conversion_by, "Value of BY expression of DO or LOOP instruction must be numeric; found \"&1\".")
    MESSAGE(Error_Conversion_control, "Value of control variable expression of DO or LOOP instruction must be numeric; found \"&1\".")
    MESSAGE(Error_Conversion_exponent, "Exponent exceeds &1 digits; found \"&2\".")
    MESSAGE(Error_Conversion_user_defined, "&1.")
    MESSAGE(Error_Conversion_raise, "Value of RAISE instruction SYNTAX expression must be numeric; found \"&1\".")
    MESSAGE(Error_Overflow, "Arithmetic overflow/underflow.")
    MESSAGE(Error_Overflow_overflow, "Arithmetic overflow detected at:  \"&1&2&3\".")
    MESSAGE(Error_Overflow_underflow, "Arithmetic underflow detected at:  \"&1&2&3\".")
    MESSAGE(Error_Overflow_zero, "Arithmetic overflow; divisor must not be zero.")
    MESSAGE(Error_Overflow_user_defined, "&1.")
    MESSAGE(Error_Overflow_expoverflow, "Arithmetic overflow; exponent (\"&1\") exceeds &2 digits.")
    MESSAGE(Error_Overflow_expunderflow, "Arithmetic underflow; exponent (\"&1\") exceeds &2 digits.")
    MESSAGE(Error_Overflow_power, "Arithmetic underflow; zero raised to a negative power.")
    MESSAGE(Error_Routine_not_found, "Routine not found.")
    MESSAGE(Error_Routine_not_found_name, "Could not find routine \"&1\".")
    MESSAGE(Error_Routine_not_found_user_defined, "&1.")
    MESSAGE(Error_Routine_not_found_requires, "Could not find file \"&1\" for ::REQUIRES.")
    MESSAGE(Error_Routine_not_found_namespace, "Routine \"&1\" not found in namespace \"&2\".")
    MESSAGE(Error_Function_no_data, "Function or message did not return data.")
    MESSAGE(Error_Function_no_data_function, "No data returned from function \"&1\".")
    MESSAGE(Error_Function_no_data_user_defined, "&1.")
    MESSAGE(Error_No_data_on_return, "No data specified on function RETURN.")
    MESSAGE(Error_No_data_on_return_name, "Data expected on RETURN instruction because routine \"&1\" was called as a function.")
    MESSAGE(Error_Variable_reference, "Invalid variable reference.")
    MESSAGE(Error_Variable_reference_extra, "Extra token (\"&1\") found in variable reference list; \")\" expected.")
    MESSAGE(Error_Variable_reference_user_defined, "&1.")
    MESSAGE(Error_Variable_reference_missing, "Missing \")\" in variable reference.")
    MESSAGE(Error_Variable_reference_use, "Extra token (\"&1\") found in USE ARG variable reference; \",\" or end of instruction expected.")
    MESSAGE(Error_Unexpected_label, "Unexpected label.")
    MESSAGE(Error_Unexpected_label_interpret, "INTERPRET data must not contain labels; found \"&1\".")
    MESSAGE(Error_System_service, "Failure in system service.")
    MESSAGE(Error_System_service_service, "Failure in system service: &1.")
    MESSAGE(Error_System_service_user_defined, "&1.")
    MESSAGE(Error_Interpretation, "Interpretation error.")
    MESSAGE(Error_Interpretation_initialization, "Interpretation error: unexpected failure initializing the interpreter.")
    MESSAGE(Error_Interpretation_switch, "Interpretation error: unmatched &1 &2.")
    MESSAGE(Error_Interpretation_user_defined, "&1.")
    MESSAGE(Error_Invalid_argument, "Invalid argument.")
    MESSAGE(Error_Invalid_argument_user_defined, "&1.")
    MESSAGE(Error_Invalid_argument_noarg, "Missing argument; argument &1 is required.")
    MESSAGE(Error_Invalid_argument_number, "The &1 argument must be a number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_whole, "The &1 argument must be a whole number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_nonnegative, "The &1 argument must be zero or a positive whole number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_positive, "Argument &1 must be a positive whole number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_toobig, "Argument &1 must not exceed &2; found \"&3\".")
    MESSAGE(Error_Invalid_argument_range, "Argument &1 must be in the range &2 to &3; found \"&4\".")
    MESSAGE(Error_Invalid_argument_null, "Argument &1 must not be a null string.")
    MESSAGE(Error_Invalid_argument_string, "Argument &1 must have a string value.")
    MESSAGE(Error_Invalid_argument_pad, "Argument &1 is an invalid pad or character argument; found \"&2\".")
    MESSAGE(Error_Invalid_argument_length, "Argument &1 is an invalid length value; found \"&2\".")
    MESSAGE(Error_Invalid_argument_position, "Argument &1 is an invalid position value; found \"&2\".")
    MESSAGE(Error_Invalid_argument_noarray, "Argument &1 must be a single-dimensional array.")
    MESSAGE(Error_Invalid_argument_noclass, "Argument &1 must be an instance of the &2 class.")
    MESSAGE(Error_Invalid_argument_argType, "Argument &1 could not be converted to a &2 type.")
    MESSAGE(Error_Invalid_argument_list, "Argument &1 must be one of &2; found \"&3\".")
    MESSAGE(Error_Invalid_argument_general, "Argument &1 &2.")
    MESSAGE(Error_Invalid_argument_format, "Argument &1 is not in a valid format; found \"&2\".")
    MESSAGE(Error_Invalid_argument_pointer, "Argument &1 is not in valid pointer format; found \"&2\".")
    MESSAGE(Error_Invalid_argument_nostem, "Argument &1 must be a stem object or stem name; found \"&2\".")
    MESSAGE(Error_Invalid_argument_double, "Argument &1 must be a valid double value; found \"&2\".")
    MESSAGE(Error_Invalid_argument_maxarg, "Too many arguments in invocation; &1 expected.")
    MESSAGE(Error_Invalid_argument_array, "&1 argument &2 must be a single-dimensional array; found \"&3\".")
    MESSAGE(Error_Invalid_argument_array_size, "&1 argument &2 must be an array with exactly &3 items.")
    MESSAGE(Error_Invalid_argument_nonnegative_number, "The &1 argument must be zero or a positive number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_positive_number, "The &1 argument must be a positive number; found \"&2\".")
    MESSAGE(Error_Invalid_argument_logical, "The &1 argument must be exactly \"0\" or \"1\"; found \"&2\".")
    MESSAGE(Error_Invalid_argument_variable_reference, "The &1 argument must be a VariableReference instance; found \"&2\".")
    MESSAGE(Error_Invalid_argument_variable_reference_stem, "The &1 argument must be a VariableReference for a Stem variable; found \"&2\".")
    MESSAGE(Error_Invalid_argument_variable_reference_simple, "The &1 argument must be a VariableReference for a Simple variable; found \"&2\".")
    MESSAGE(Error_Invalid_argument_no_reference, "Argument &1 was omitted. A VariableReference argument is required.")
    MESSAGE(Error_Invalid_argument_date_template, "Date template &1 contains an invalid pattern; found \"&2\".")
    MESSAGE(Error_Invalid_argument_bad_date, "Unable to parse date \"&1\" with template \"&2\".")
    MESSAGE(Error_Variable_expected, "Variable or message term expected.")
    MESSAGE(Error_Variable_expected_USE, "The USE instruction requires a comma-separated list of variables or assignment message terms.")
    MESSAGE(Error_Variable_expected_PARSE, "The PARSE instruction was expecting a variable or a message term.")
    MESSAGE(Error_External_name_not_found, "External name not found.")
    MESSAGE(Error_External_name_not_found_user_defined, "&1.")
    MESSAGE(Error_External_name_not_found_class, "Unable to find external class \"&1\".")
    MESSAGE(Error_External_name_not_found_method, "Unable to find external method \"&1\".")
    MESSAGE(Error_External_name_not_found_routine, "Unable to find external routine \"&1\".")
    MESSAGE(Error_No_result_object, "No result object.")
    MESSAGE(Error_No_result_object_user_defined, "&1.")
    MESSAGE(Error_No_result_object_message, "Message \"&1\" did not return a result.")
    MESSAGE(Error_OLE_Error, "OLE error.")
    MESSAGE(Error_OLE_Error_user_defined, "&1.")
    MESSAGE(Error_Unknown_OLE_Error, "An unknown OLE error occurred (HRESULT=&1).")
    MESSAGE(Error_Variant2Rexx, "Cannot convert OLE VARIANT to REXX object: The conversion of the VARIANT type &1 into a REXX object failed.")
    MESSAGE(Error_Rexx2Variant, "Cannot convert REXX object to OLE VARIANT: The conversion of &1 into a VARIANT failed.")
    MESSAGE(Error_Argument_Count_Mismatch, "The number of elements provided to the method or property is different from the number of parameters accepted by it.")
    MESSAGE(Error_Invalid_Variant, "One of the parameters is not a valid VARIANT type.")
    MESSAGE(Error_OLE_Exception, "OLE exception: &1.")
    MESSAGE(Error_Unknown_OLE_Method, "The requested method does not exist, or you tried to set the value of a read-only property.")
    MESSAGE(Error_Coercion_Failed_Overflow, "One of the parameters could not be coerced to the desired type.")
    MESSAGE(Error_Coercion_Failed_Type_Mismatch, "One or more of the parameters could not be coerced to the desired type. The first parameter with incorrect type is argument &1.")
    MESSAGE(Error_Parameter_Omitted, "A required parameter was omitted.")
    MESSAGE(Error_No_OLE_instance, "Could not create OLE instance.")
    MESSAGE(Error_Client_Disconnected_From_Server, "The object invoked has disconnected from its clients.")
    MESSAGE(Error_Incorrect_method, "Incorrect call to method.")
    MESSAGE(Error_Incorrect_method_user_defined, "&1.")
    MESSAGE(Error_Incorrect_method_minarg, "Not enough arguments for method; &1 expected.")
    MESSAGE(Error_Incorrect_method_maxarg, "Too many arguments in invocation of method; &1 expected.")
    MESSAGE(Error_Incorrect_method_noarg, "Missing argument in method; argument &1 is required.")
    MESSAGE(Error_Incorrect_method_number, "Method argument &1 must be a number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_whole, "Method argument &1 must be a whole number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_nonnegative, "Method argument &1 must be zero or a positive whole number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_positive, "Method argument &1 must be a positive whole number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_toobig, "Method argument &1 must not exceed &2; found \"&3\".")
    MESSAGE(Error_Incorrect_method_range, "Method argument &1 must be in the range 0-99; found \"&2\".")
    MESSAGE(Error_Incorrect_method_null, "Method argument &1 must not be null.")
    MESSAGE(Error_Incorrect_method_hex, "Method argument &1 must be a hexadecimal string; found \"&2\".")
    MESSAGE(Error_Incorrect_method_symbol, "Method argument &1 must be a valid symbol; found \"&2\".")
    MESSAGE(Error_Incorrect_method_list, "Method argument &1 must be one of &2; found \"&3\".")
    MESSAGE(Error_Incorrect_method_option, "Method option must be one of \"&1\"; found \"&2\".")
    MESSAGE(Error_Incorrect_method_methodname, "Method &1 does not exist.")
    MESSAGE(Error_Incorrect_method_index, "Incorrect list index \"&1\".")
    MESSAGE(Error_Incorrect_method_array, "Incorrect array position \"&1\".")
    MESSAGE(Error_Incorrect_method_binary, "Argument missing on binary operator.")
    MESSAGE(Error_Incorrect_method_pad, "Incorrect pad or character argument specified; found \"&1\".")
    MESSAGE(Error_Incorrect_method_length, "Invalid length argument specified; found \"&1\".")
    MESSAGE(Error_Incorrect_method_position, "Invalid position argument specified; found \"&1\".")
    MESSAGE(Error_Incorrect_method_minsub, "Not enough subscripts for array; &1 expected.")
    MESSAGE(Error_Incorrect_method_maxsub, "Too many subscripts for array; &1 expected.")
    MESSAGE(Error_Incorrect_method_d2xd2c, "Length must be specified to convert a negative value.")
    MESSAGE(Error_Incorrect_method_d2x, "D2X value must be a valid whole number; found \"&1\".")
    MESSAGE(Error_Incorrect_method_d2c, "D2C value must be a valid whole number; found \"&1\".")
    MESSAGE(Error_Incorrect_method_hexblank, "Incorrect location of whitespace character in position &1 in hexadecimal string.")
    MESSAGE(Error_Incorrect_method_binblank, "Incorrect location of whitespace character in position &1 in binary string.")
    MESSAGE(Error_Incorrect_method_invhex, "Only 0-9, a-f, A-F, and whitespace characters are valid in a hexadecimal string; character found \"&1\".")
    MESSAGE(Error_Incorrect_method_invbin, "Only 0, 1, and whitespace characters are valid in a binary string; character found \"&1\".")
    MESSAGE(Error_Incorrect_method_x2dbig, "X2D result is not a valid whole number with NUMERIC DIGITS &1.")
    MESSAGE(Error_Incorrect_method_c2dbig, "C2D result is not a valid whole number with NUMERIC DIGITS &1.")
    MESSAGE(Error_Incorrect_method_supplier, "No more supplier items available.")
    MESSAGE(Error_Incorrect_method_nostring, "Method argument &1 must have a string value.")
    MESSAGE(Error_Incorrect_method_noarray, "Method argument &1 must have a single-dimensional array value.")
    MESSAGE(Error_Incorrect_method_string_no_whole_number, "&1 method target must be a whole number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_exponent_oversize, "Exponent of \"&1\" is too large for &2 spaces.")
    MESSAGE(Error_Incorrect_method_before_oversize, "Integer part of \"&1\" is too large for &2 spaces.")
    MESSAGE(Error_Incorrect_method_string_nonumber, "&1 method target must be a number; found \"&2\".")
    MESSAGE(Error_Incorrect_method_nomessage, "Method argument &1 must be a message object.")
    MESSAGE(Error_Incorrect_method_message_noarg, "Missing argument in message array; argument &1 is required.")
    MESSAGE(Error_Incorrect_method_message, "A message array must be a single-dimensional array with 2 elements.")
    MESSAGE(Error_Incorrect_method_section, "Method SECTION can be used only on single-dimensional arrays.")
    MESSAGE(Error_Incorrect_method_noclass, "Method argument &1 must be of the &2 class.")
    MESSAGE(Error_Incorrect_method_nomatch, "The value and index objects must be the same for PUT to an index-only collection.")
    MESSAGE(Error_Incorrect_method_time, "Incorrect alarm time; found \"&1\".")
    MESSAGE(Error_Incorrect_method_nostring_inarray, "Method argument &1 is an array and does not contain all string values.")
    MESSAGE(Error_Incorrect_method_argType, "Method argument &1 could not be converted to type &2.")
    MESSAGE(Error_Incorrect_method_array_dimension, "Method \"&1\" can be used only on a single-dimensional array.")
    MESSAGE(Error_Incorrect_method_array_nostring, "Element &1 of the array must be a string.")
    MESSAGE(Error_Incorrect_method_array_noclass, "Target object \"&1\" is not a subclass of the message override scope (&2).")
    MESSAGE(Error_Incorrect_method_stream_type, "Positioning of transient streams is not valid.")
    MESSAGE(Error_Incorrect_method_array_too_big, "An array cannot contain more than &1 elements.")
    MESSAGE(Error_Incorrect_method_no_method, "The &1 argument must be a string or array object.")
    MESSAGE(Error_Incorrect_method_invbase64, "Invalid Base64 encoded string.")
    MESSAGE(Error_Unsupported_method, "Call to unsupported or unimplemented method.")
    MESSAGE(Error_Application_error, "Application error:  &1.")
    MESSAGE(Error_Incorrect_method_abstract, "Method &1 is ABSTRACT and cannot be directly invoked.")
    MESSAGE(Error_Incorrect_method_queue_index, "Incorrect queue index \"&1\".")
    MESSAGE(Error_Unsupported_new_method, "NEW method is not supported for the &1 class.")
    MESSAGE(Error_Incorrect_method_signature, "Invalid native method signature specification.")
    MESSAGE(Error_Incorrect_method_nostem, "Method argument &1 must have a stem object value; found \"&2\".")
    MESSAGE(Error_Unsupported_copy_method, "COPY method is not supported for object &1.")
    MESSAGE(Error_Incorrect_method_multi_dimension, "Method argument &1 cannot have more than a single dimension.")
    MESSAGE(Error_Incorrect_method_message_name, "A message name argument must be a string or an array with 2 elements; found \"&1\".")
    MESSAGE(Error_Incorrect_method_nil_not_orderable, "ORDERABLE comparison method \"&1\" argument cannot be .nil.")
    MESSAGE(Error_Incorrect_method_no_method_type, "The &1 argument must be a string, array, or method object.")
    MESSAGE(Error_Incorrect_method_invalid_value_for, "Invalid &1 value; found \"&2\".")
    MESSAGE(Error_Incorrect_method_invhex_group, "Hexadecimal strings must be grouped in units that are multiples of two characters.")
    MESSAGE(Error_Incorrect_method_invbin_group, "Binary strings must be grouped in units that are multiples of four characters.")
    MESSAGE(Error_Incorrect_method_request_type, "Method argument &1 could not be converted to type &2; found \"&3\".")
    MESSAGE(Error_No_method, "Object method not found.")
    MESSAGE(Error_No_method_name, "Object \"&1\" does not understand message \"&2\".")
    MESSAGE(Error_No_method_private, "Object \"&1\" cannot accept private message \"&2\" from this context.")
    MESSAGE(Error_No_method_package, "Object \"&1\" cannot accept package scope message \"&2\" from a different package caller.")
    MESSAGE(Error_No_method_constant, "Constant \"&2\" of object \"&1\" has not been initialized.")
    MESSAGE(Error_No_method_unhandled, "An unhandled NOMETHOD condition has been raised.")
    MESSAGE(Error_No_method_user_defined, "&1.")
    MESSAGE(Error_Execution, "Execution error.")
    MESSAGE(Error_Execution_user_defined, "&1.")
    MESSAGE(Error_Execution_noinit, "Object \"&1\" was not correctly initialized.")
    MESSAGE(Error_Execution_nodouble, "Unable to convert object \"&1\" to a double-float value.")
    MESSAGE(Error_Execution_library, "Unable to load library \"&1\".")
    MESSAGE(Error_Execution_terminate, "Abnormal termination occurred.")
    MESSAGE(Error_Execution_deadlock, "Deadlock detected on a guarded method.")
    MESSAGE(Error_Execution_badobject, "Incorrect object reference detected.")
    MESSAGE(Error_Execution_wrongobject, "Object of type \"&1\" was required.")
    MESSAGE(Error_Execution_nometaclass, "Metaclass \"&1\" not found.")
    MESSAGE(Error_Execution_noclass, "Class \"&1\" not found.")
    MESSAGE(Error_Execution_cyclic, "Cyclic inheritance in program \"&1\".")
    MESSAGE(Error_Execution_noarray, "Unable to convert object \"&1\" to a single-dimensional array value.")
    MESSAGE(Error_Execution_nostring, "Unable to convert object \"&1\" to a string value.")
    MESSAGE(Error_Execution_message_reuse, "A message object that was sent a START message cannot be sent another START, SEND, or REPLY message.")
    MESSAGE(Error_Execution_message_error, "Message object \"&1\" received an error from message \"&2\".")
    MESSAGE(Error_Execution_raise_object, "Incorrect condition object received for RAISE OBJECT; found \"&1\".")
    MESSAGE(Error_Execution_propagate, "No active condition available for PROPAGATE.")
    MESSAGE(Error_Execution_nomethod, "Unable to convert object \"&1\" to a method.")
    MESSAGE(Error_Execution_file_not_writeable, "Unable to open file \"&1\" for writing; open result was \"&2\".")
    MESSAGE(Error_Execution_address_redirection_not_supported, "Address environment \"&1\" does not support input/output redirection.")
    MESSAGE(Error_Execution_using_rexxqueue_option, "REPLACE or APPEND cannot be specified with a RexxQueue object USING target.")
    MESSAGE(Error_Execution_address_redirection_failed, "Address command redirection failed (&1).")
    MESSAGE(Error_Execution_address_input_source, "Object \"&1\" is not a valid ADDRESS WITH INPUT source.")
    MESSAGE(Error_Execution_reply, "REPLY can be issued only once per method invocation.")
    MESSAGE(Error_Execution_reply_return, "RETURN cannot return a value after a REPLY.")
    MESSAGE(Error_Execution_reply_exit, "EXIT cannot return a value after a REPLY.")
    MESSAGE(Error_Execution_super, "Message search overrides can be used only from methods of the target object.")
    MESSAGE(Error_Execution_syntax_additional, "Additional information for SYNTAX errors must be a single-dimensional array of values.")
    MESSAGE(Error_Execution_error_condition, "Unknown error number specified on RAISE SYNTAX; found \"&1\".")
    MESSAGE(Error_Execution_mixinclass, "Class \"&1\" must be a MIXINCLASS for INHERIT.")
    MESSAGE(Error_Execution_baseclass, "Class \"&1\" is not a subclass of \"&2\" base class \"&3\".")
    MESSAGE(Error_Execution_recursive_inherit, "Class \"&1\" cannot inherit from itself, a superclass, or a subclass (\"&2\").")
    MESSAGE(Error_Execution_uninherit, "Class \"&1\" has not inherited class \"&2\".")
    MESSAGE(Error_Execution_forward_arguments, "FORWARD arguments must be a single-dimensional array of values.")
    MESSAGE(Error_Execution_forward, "FORWARD can only be issued in an object method invocation.")
    MESSAGE(Error_Execution_authorization, "Authorization failure:  &1.")
    MESSAGE(Error_Execution_no_concurrency, "Concurrency not supported.")
    MESSAGE(Error_Execution_circular_requires, "Circular ::REQUIRES references detected with &1.")
    MESSAGE(Error_Execution_error_syntax, "External command \"&1\" ended with return code &2.")
    MESSAGE(Error_Execution_failure_syntax, "External command \"&1\" failed with return code &2.")
    MESSAGE(Error_Execution_lostdigits_syntax, "Number &1 has more digits than the current precision.")
    MESSAGE(Error_Execution_nostring_syntax, "Object \"&1\" does not have a string representation.")
    MESSAGE(Error_Execution_notready_syntax, "Stream \"&1\" is not ready.")
    MESSAGE(Error_Execution_sparse_array, "Missing array element at position &1.")
    MESSAGE(Error_Execution_nostem, "Stem object default value cannot be another stem object.")
    MESSAGE(Error_Execution_library_method, "Unable to load method \"&1\" from library \"&2\".")
    MESSAGE(Error_Execution_library_routine, "Unable to load routine \"&1\" from library \"&2\".")
    MESSAGE(Error_Execution_native_routine, "Unable to load native routine \"&1\".")
    MESSAGE(Error_Execution_context_not_active, "Target RexxContext is no longer active.")
    MESSAGE(Error_Execution_library_version, "Library \"&1\" is not compatible with current interpreter version.")
    MESSAGE(Error_Execution_invalid_thread, "Execution thread does not match API thread context.")
    MESSAGE(Error_Execution_rexx_package_update, "User additions are not allowed to the REXX package.")
    MESSAGE(Error_Execution_rexx_defined_class, "User additions are not allowed to the REXX language classes.")
    MESSAGE(Error_Execution_unassigned_variable, "Reference to unassigned variable \"&1\".")
    MESSAGE(Error_Execution_no_namespace, "Namespace \"&1\" not found in package \"&2\".")
    MESSAGE(Error_Execution_no_namespace_class, "Class \"&1\" not found in namespace \"&2\".")
    MESSAGE(Error_Execution_abstract_class, "Class &1 is ABSTRACT and cannot be directly created.")
    MESSAGE(Error_Execution_abstract_metaclass, "Class &1 is a metaclass and cannot be made ABSTRACT.")
    MESSAGE(Error_Execution_private_access, "Method &1 may only be invoked from a method of the same object or one of its classes.")
    MESSAGE(Error_Execution_expose_method, "The EXPOSE instruction may only be used from method invocations.")
    MESSAGE(Error_Execution_use_local_method, "The USE LOCAL instruction may only be used from method invocations.")
    MESSAGE(Error_Execution_no_supplier, "Unable to convert object \"&1\" to a supplier object.")
    MESSAGE(Error_Execution_reference_variable_in_use, "Unable to reference variable \"&1\"; it must be an uninitialized local variable.")
    MESSAGE(Error_Execution_address_output_target, "Object \"&1\" is not a valid ADDRESS WITH OUTPUT or ERROR target.")
    MESSAGE(Error_Execution_using_stream_option, "REPLACE or APPEND cannot be specified with a Stream object USING target.")
    MESSAGE(Error_Execution_missing_stem_array_index, "Stem \"&1\" does not contain a size count in element 0.")
    MESSAGE(Error_Execution_file_not_readable, "Unable to open file \"&1\" for reading; open result was \"&2\".")
    MESSAGE(Error_Translation, "Translation error.")
    MESSAGE(Error_Translation_user_defined, "&1.")
    MESSAGE(Error_Translation_duplicate_class, "Duplicate ::CLASS directive instruction.")
    MESSAGE(Error_Translation_duplicate_method, "Duplicate ::METHOD directive instruction.")
    MESSAGE(Error_Translation_duplicate_routine, "Duplicate ::ROUTINE directive instruction.")
    MESSAGE(Error_Translation_duplicate_requires, "Duplicate ::REQUIRES directive instruction.")
    MESSAGE(Error_Translation_missing_class, "CLASS keyword on ::METHOD directive requires a matching ::CLASS directive.")
    MESSAGE(Error_Translation_constant_no_class, "A ::CONSTANT directive with an expression requires a matching ::CLASS directive.")
    MESSAGE(Error_Translation_expose, "EXPOSE must be the first instruction executed after a method invocation.")
    MESSAGE(Error_Translation_expose_interpret, "INTERPRET data must not contain EXPOSE.")
    MESSAGE(Error_Translation_guard, "GUARD must be the first instruction executed after EXPOSE or USE.")
    MESSAGE(Error_Translation_use_local, "USE LOCAL must be the first instruction executed after a method invocation.")
    MESSAGE(Error_Translation_guard_guard, "GUARD can only be issued in an object method invocation.")
    MESSAGE(Error_Translation_guard_interpret, "INTERPRET data must not contain GUARD.")
    MESSAGE(Error_Translation_guard_expose, "GUARD instruction did not include references to exposed variables.")
    MESSAGE(Error_Translation_directive_interpret, "INTERPRET data must not contain directive instructions.")
    MESSAGE(Error_Translation_use_local_interpret, "INTERPRET data must not contain USE LOCAL.")
    MESSAGE(Error_Translation_bad_directive, "Unrecognized directive instruction.")
    MESSAGE(Error_Translation_bad_external, "Incorrect external name specification \"&1\".")
    MESSAGE(Error_Translation_use_comma, "USE ARG requires a \",\" between variable names; found \"&1\".")
    MESSAGE(Error_Translation_reply, "REPLY can only be issued in an object method invocation.")
    MESSAGE(Error_Translation_invalid_line, "Incorrect program line in method source array.")
    MESSAGE(Error_Translation_requires, "::REQUIRES directives must appear before other directive instructions.")
    MESSAGE(Error_Translation_forward_interpret, "INTERPRET data must not contain FORWARD.")
    MESSAGE(Error_Translation_reply_interpret, "INTERPRET data must not contain REPLY.")
    MESSAGE(Error_Translation_invalid_attribute, "An ATTRIBUTE method name must be a valid variable name; found \"&1\".")
    MESSAGE(Error_Translation_class_external_bad_parameters, "Incorrect class external; too many parameters.")
    MESSAGE(Error_Translation_bad_metaclass, "\"&1\" is not a valid metaclass.")
    MESSAGE(Error_Translation_class_external_bad_class_name, "Incorrect class external; class name missing or invalid.")
    MESSAGE(Error_Translation_class_external_bad_class_server, "Incorrect class external; invalid class server \"&1\".")
    MESSAGE(Error_Translation_use_arg_ellipsis, "The \"...\" argument marker can only appear at the end of the argument list.")
    MESSAGE(Error_Translation_duplicate_attribute, "Duplicate ::ATTRIBUTE directive instruction.")
    MESSAGE(Error_Translation_duplicate_constant, "Duplicate ::CONSTANT directive instruction.")
    MESSAGE(Error_Translation_abstract_method, "Abstract methods cannot have a method body.")
    MESSAGE(Error_Translation_attribute_method, "Attribute methods cannot have a method body.")
    MESSAGE(Error_Translation_external_attribute, "External attributes cannot have a method body.")
    MESSAGE(Error_Translation_external_method, "External methods cannot have a method body.")
    MESSAGE(Error_Translation_body_error, "Attribute methods without a SET or GET designation cannot have a method body.")
    MESSAGE(Error_Translation_constant_body, "Constant methods cannot have a method body.")
    MESSAGE(Error_Translation_external_routine, "External routines cannot have a code body.")
    MESSAGE(Error_Translation_abstract_attribute, "Abstract attributes cannot have a method body.")
    MESSAGE(Error_Translation_directive_method_routine, "Method or routine code may not contain directive instructions.")
    MESSAGE(Error_Translation_duplicate_resource, "Duplicate ::RESOURCE directive instruction.")
    MESSAGE(Error_Translation_missing_resource_end, "Missing ::RESOURCE end marker \"&1\" for resource \"&2\".")
    MESSAGE(Error_Translation_reserved_namespace, "The REXX name is reserved for the language-provided namespace.")
    MESSAGE(Error_Translation_missing_annotation_target, "::ANNOTATE target &1 \"&2\" not found.")
    MESSAGE(Error_Translation_delegate_method, "Delegate methods cannot have a method body.")
    MESSAGE(Error_Translation_delegate_attribute, "Delegate attributes cannot have a method body.")
    MESSAGE(Error_Translation_use_local_compound, "USE LOCAL cannot process compound variables; found \"&1\".")
    MESSAGE(Error_Translation_bad_class, "\"&1\" is not a valid class.")
    MESSAGE(Error_Translation_use_arg_reference_no_default, "A USE ARG default value is not allowed for variable references.")
    MESSAGE(Error_at_line, "Error &1 running &2, line &3:.")
    MESSAGE(Message_Translations_error, "Error")
    MESSAGE(Message_Translations_running, "running")
    MESSAGE(Message_Translations_line, "line")
    MESSAGE(Message_Translations_debug_error, "+++ Interactive trace.  Error")
    MESSAGE(Message_Translations_debug_prompt, "+++ Interactive trace. \"Trace Off\" to end debug, ENTER to continue. +++")
    MESSAGE(Message_Translations_January, "January")
    MESSAGE(Message_Translations_February, "February")
    MESSAGE(Message_Translations_March, "March")
    MESSAGE(Message_Translations_April, "April")
    MESSAGE(Message_Translations_May, "May")
    MESSAGE(Message_Translations_June, "June")
    MESSAGE(Message_Translations_July, "July")
    MESSAGE(Message_Translations_August, "August")
    MESSAGE(Message_Translations_September, "September")
    MESSAGE(Message_Translations_October, "October")
    MESSAGE(Message_Translations_November, "November")
    MESSAGE(Message_Translations_December, "December")
    MESSAGE(Message_Translations_routine_invocation, "Routine \"&1\" in package \"&2\".")
    MESSAGE(Message_Translations_method_invocation, "Method \"&1\" with scope \"&2\" in package \"&3\".")
    MESSAGE(Message_Translations_compiled_method_invocation, "       *-* Compiled method \"&1\" with scope \"&2\".")
    MESSAGE(Message_Translations_compiled_routine_invocation, "       *-* Compiled routine \"&1\".")
    MESSAGE(Message_Translations_no_source_available, "Package \"&1\" (no source available).")
    MESSAGE(Message_Translations_internal_code, "Interpreter code (no source available).")
    MESSAGE(Message_Translations_sourceless_method_invocation, "Method &1 with scope \"&2\" in package \"&3\" (no source available).")
    MESSAGE(Message_Translations_sourceless_routine_invocation, "Routine &1 in package \"&2\" (no source available).")
    MESSAGE(Message_Translations_sourceless_program_invocation, "Program in \"&1\" (no source available).")
    MESSAGE(Error_RXSUBC_general, "The RXSUBCOM parameters are incorrect.")
    MESSAGE(Error_RXSUBC_register, "The RXSUBCOM REGISTER parameters are incorrect.")
    MESSAGE(Error_RXSUBC_drop, "The RXSUBCOM DROP parameters are incorrect.")
    MESSAGE(Error_RXSUBC_load, "The RXSUBCOM LOAD parameters are incorrect.")
    MESSAGE(Error_RXQUE_notinit, "The REXX rxapi queuing system is not available.")
    MESSAGE(Error_RXQUE_size, "The size of the data is incorrect.")
    MESSAGE(Error_RXQUE_nomem, "Storage for data queues is exhausted.")
    MESSAGE(Error_RXQUE_name, "The name %1 is not a valid queue name.")
    MESSAGE(Error_RXQUE_access, "The queue access mode is not correct.")
    MESSAGE(Error_RXQUE_exist, "The queue %1 does not exist.")
    MESSAGE(Error_RXSUBC_query, "The RXSUBCOM QUERY parameters are incorrect.")
    MESSAGE(Error_REXXC_cmd_parm_incorrect, "The rexxc command parameters are incorrect.")
    MESSAGE(Error_REXXC_outDifferent, "Output file name must be different from input file name.")
    MESSAGE(Error_REXXC_wrongNrArg, "SYNTAX: rexxc inputfile [outputfile] [-s] [-e]")
    MESSAGE(Error_REXXC_SynCheckInfo, "Without outputfile rexxc only performs a syntax check.")
    MESSAGE(Error_RXQUE_syntax, "The syntax of the command is incorrect.")
    MESSAGE(Error_RXQUE_memfail, "System error occurred while processing the command.")
    MESSAGE(Table_end, "")                 /* make sure table is ended          */
};
#endif

/* -------------------------------------------------------------------------- */
/* --            file is generated by build process                        -- */
/* --            ==================================================        -- */
/* --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!        -- */
/* --            ==================================================        -- */
/* -------------------------------------------------------------------------- */
