#pragma once

// Author: Torarin Hals Bakke (2013)

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#include <cassert>
#include <cstdio>
#include <string>

template <size_t N, typename... Ts>
std::string strprintf_impl(const char (&format)[N], Ts... ts) {
  const auto length_guess = static_cast<size_t>(1.5 * (N - 1 /* '\0' */) + 0.5);
  std::string result;
  result.resize(length_guess);
  auto formatted_length =
    snprintf(&result[0], length_guess + 1 /* '\0' */, &format[0], ts...);
  assert(formatted_length >= 0);
  result.resize(formatted_length);
  if ((unsigned) formatted_length > length_guess) {
    auto snprintf_ret =
      snprintf(&result[0], formatted_length + 1 /* '\0' */, &format[0], ts...);
    assert(snprintf_ret >= 0);
  }
  return result;
}

int strprintf_arg_checker(const char* format, ...) __attribute__((format(printf, 1, 2)));

#define strprintf(format, ts...) \
  ((void) sizeof(strprintf_arg_checker(format, ts)), strprintf_impl(format, ts))
