#!/usr/common/bin/perl
# 
# ASSUMES: y.tab.h and y.tab.c hold output from bison (with -y -d options)
#
# CREATES: RDIParser_y.h, RDIParser_y.cc with appropriate modifications.
#
# DELETES: y.tab.h and y.tab.c
# 
# 
# The mods for RDIParser_y.h:
#
#   (1) wrap with #ifndef #define .. #endif
#
#
# The mods for RDIParser_y.cc:
# 
#   (1) add comment about DEC C++ for OpenVMS needing a final #line directive,
#       followed by an appropriate #line directive

########################

open (YTABH, "<y.tab.h") or die "Could not open y.tab.h: $!";
open (H_OUTFILE,  ">RDIParser_y.h")  or die "Could not open RDIParser_y.h: $!";

print H_OUTFILE "// -*- Mode: C++; -*-\n";
print H_OUTFILE "\n";
print H_OUTFILE "//                              File      : RDIParser_y.h\n";
print H_OUTFILE "//                              Package   : omniNotify-Library\n";
print H_OUTFILE "//                              Created on: 1-Jan-1998\n"; 
print H_OUTFILE "//                              Authors   : gruber&panagos\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "//    Copyright (C) 1998-2003 AT&T Laboratories -- Research\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "//    This file is part of the omniNotify library\n"; 
print H_OUTFILE "//    and is distributed with the omniNotify release.\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "//    The omniNotify library is free software; you can redistribute it and/or\n"; 
print H_OUTFILE "//    modify it under the terms of the GNU Library General Public\n"; 
print H_OUTFILE "//    License as published by the Free Software Foundation; either\n"; 
print H_OUTFILE "//    version 2 of the License, or (at your option) any later version.\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "//    This library is distributed in the hope that it will be useful,\n"; 
print H_OUTFILE "//    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"; 
print H_OUTFILE "//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"; 
print H_OUTFILE "//    Library General Public License for more details.\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "//    You should have received a copy of the GNU Library General Public\n"; 
print H_OUTFILE "//    License along with this library; if not, write to the Free\n"; 
print H_OUTFILE "//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA\n"; 
print H_OUTFILE "//    02111-1307, USA\n"; 
print H_OUTFILE "//\n"; 
print H_OUTFILE "// -------------------------------------------------------------------\n";
print H_OUTFILE "// ** This file automatically generated by running buildgens.sh in    \n";
print H_OUTFILE "//    <top>/src/services/omniNotify/lib  Rebuild at your own risk!    \n";
print H_OUTFILE "// -------------------------------------------------------------------\n\n";
print H_OUTFILE "#ifndef _RDI_PARSER_Y_H_\n";
print H_OUTFILE "#define _RDI_PARSER_Y_H_\n\n";
while (<YTABH>) {  print H_OUTFILE $_; }
print H_OUTFILE "\n#endif\n\n";

close (YTABH);
close (H_OUTFILE);
unlink 'y.tab.h';

########################

open (YTABC, "<y.tab.c") or die "Could not open y.tab.c: $!";
open (CC_OUTFILE, ">RDIParser_y.cc") or die "Could not open RDIParser_y.cc: $!";

$outlines = 0;

print CC_OUTFILE "// -*- Mode: C++; -*-\n"; $outlines++;
print CC_OUTFILE "\n"; $outlines++;
print CC_OUTFILE "//                              File      : RDIParser_y.cc\n"; $outlines++;
print CC_OUTFILE "//                              Package   : omniNotify-Library\n"; $outlines++;
print CC_OUTFILE "//                              Created on: 1-jan-1998\n"; $outlines++;
print CC_OUTFILE "//                              Authors   : gruber&panagos\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "//    Copyright (C) 1998-2003 AT&T Laboratories -- Research\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "//    This file is part of the omniNotify library\n"; $outlines++;
print CC_OUTFILE "//    and is distributed with the omniNotify release.\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "//    The omniNotify library is free software; you can redistribute it and/or\n"; $outlines++;
print CC_OUTFILE "//    modify it under the terms of the GNU Library General Public\n"; $outlines++;
print CC_OUTFILE "//    License as published by the Free Software Foundation; either\n"; $outlines++;
print CC_OUTFILE "//    version 2 of the License, or (at your option) any later version.\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "//    This library is distributed in the hope that it will be useful,\n"; $outlines++;
print CC_OUTFILE "//    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"; $outlines++;
print CC_OUTFILE "//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"; $outlines++;
print CC_OUTFILE "//    Library General Public License for more details.\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "//    You should have received a copy of the GNU Library General Public\n"; $outlines++;
print CC_OUTFILE "//    License along with this library; if not, write to the Free\n"; $outlines++;
print CC_OUTFILE "//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA\n"; $outlines++;
print CC_OUTFILE "//    02111-1307, USA\n"; $outlines++;
print CC_OUTFILE "//\n"; $outlines++;
print CC_OUTFILE "// -------------------------------------------------------------------\n";  $outlines++;
print CC_OUTFILE "// ** This file automatically generated by running buildgens.sh in    \n";  $outlines++;
print CC_OUTFILE "//    <top>/src/services/omniNotify/lib  Rebuild at your own risk!    \n";  $outlines++;
print CC_OUTFILE "// -------------------------------------------------------------------\n";  $outlines++;
print CC_OUTFILE "\n"; $outlines++;

while (<YTABC>) {
  print CC_OUTFILE $_; $outlines++;
}

print CC_OUTFILE "#ifdef __VMS\n"; $outlines++;
print CC_OUTFILE "// Some versions of DEC C++ for OpenVMS set the module name used by the\n"; $outlines++;
print CC_OUTFILE "// librarian based on the last #line encountered.\n"; $outlines++;
$outlines++; # fencepost
print CC_OUTFILE "#line $outlines \"RDIParser_y.cc\"\n";
print CC_OUTFILE "#endif\n\n";

close (YTABC);
close (CC_OUTFILE);
unlink 'y.tab.c';
