// -*- Mode: C++; -*-

//                              File      : RDIParser_y.cc
//                              Package   : omniNotify-Library
//                              Created on: 1-jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2003 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
// -------------------------------------------------------------------
// ** This file automatically generated by running buildgens.sh in    
//    <top>/src/services/omniNotify/lib  Rebuild at your own risk!    
// -------------------------------------------------------------------


/*  A Bison parser, made from yacc.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TOK_DIGITS	257
#define	TOK_EXPONENT	258
#define	TOK_IDENT	259
#define	TOK_STRING	260
#define	TOK_EQ	261
#define	TOK_NE	262
#define	TOK_LE	263
#define	TOK_LT	264
#define	TOK_GE	265
#define	TOK_GT	266
#define	TOK_AND	267
#define	TOK_OR	268
#define	TOK_DEFAULT	269
#define	TOK_EXIST	270
#define	TOK_NOT	271
#define	TOK_IN	272
#define	TOK_SUBSTR	273
#define	TOK_DOT	274
#define	TOK_PLUS	275
#define	TOK_MINUS	276
#define	TOK_MUL	277
#define	TOK_DIV	278
#define	TOK_PCNT	279
#define	TOK_LPAR	280
#define	TOK_RPAR	281
#define	TOK_LB	282
#define	TOK_RB	283
#define	TOK_DOLLAR	284
#define	TOK_TRUE	285
#define	TOK_FALSE	286
#define	TOK_OTHER	287
#define	UMINUS	288
#define	UPLUS	289

#line 3 "yacc.y"

/* Description:
 *    Parser grammar for the Notification Service default constraint grammar
 */

/*
   The expressions derived by the constraint nonterminal
   are from the trader constraint language as given in Appendix B
   of the OMG Trading Object Service specification, modified
   as defined in OMG Notification Service, section 2.4.

   Note that unary plus and minus can only be applied to numbers.
   This is lame, but part of the spec.  Thus to negate an expr
   you must write, e.g.,  -1 * (expr) 

   Note that this grammar does not differentiate between
   . foo (a regular dot component part) and the special forms
   . _d, . _length, . _type_id, . _repos_id,   etc
   (the constructed constraint recognizes these cases)
*/

#define RDI_YACC_Y

#include <stdio.h>
#include <string.h>  
#include <stdlib.h>
#include "RDIStringDefs.h"
#include "RDIStaticEvalDefs.h"

#define YYPARSE_PARAM parm
#define YYLEX_PARAM parm

#define _ps ((RDI_PCState*)parm)

/* _ps:
     _ps->e       : error              (bool) 
     _ps->b       : error buf          (char[1024])
     _ps->r_tree  : result treee  (RDI_Constraint*)

   After parse, if _ps->r_tree is NULL, then _ps->e contains an error msg
*/

#define yylex(lvalp, psparm) \
 (((RDI_PCState*)psparm)->next_token((void*)lvalp))

#define yyerror(s)  do { _ps->e = 1; sprintf(_ps->b, "%s (parse failed)", s); } while (0)


#line 62 "yacc.y"
typedef union{
  /* the type of yylval */
  void* noval;     /* should be set to NULL */
  char* sb;
  RDI_Constraint* cexpr;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		106
#define	YYFLAG		-32768
#define	YYNTBASE	36

#define YYTRANSLATE(x) ((unsigned)(x) <= 289 ? yytranslate[x] : 55)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     3,     5,     9,    11,    15,    17,    21,    25,
    29,    33,    37,    41,    43,    47,    51,    53,    57,    59,
    63,    67,    69,    73,    77,    81,    83,    86,    88,    90,
    93,    96,    98,   100,   102,   105,   108,   110,   112,   116,
   118,   120,   122,   125,   129,   133,   138,   143,   148,   154,
   160,   166,   172,   178,   185,   192,   194,   196,   198,   200,
   203,   207,   210,   214,   216
};

static const short yyrhs[] = {    -1,
    37,     0,    38,     0,    38,    14,    39,     0,    39,     0,
    39,    13,    40,     0,    40,     0,    41,     7,    41,     0,
    41,     8,    41,     0,    41,     9,    41,     0,    41,    10,
    41,     0,    41,    11,    41,     0,    41,    12,    41,     0,
    41,     0,    42,    18,    47,     0,    42,    18,     5,     0,
    42,     0,    43,    19,    43,     0,    43,     0,    43,    21,
    44,     0,    43,    22,    44,     0,    44,     0,    44,    23,
    45,     0,    44,    24,    45,     0,    44,    25,    45,     0,
    45,     0,    17,    46,     0,    46,     0,    50,     0,    21,
    50,     0,    22,    50,     0,    54,     0,    53,     0,    47,
     0,    16,    48,     0,    15,    48,     0,    31,     0,    32,
     0,    26,    38,    27,     0,    48,     0,    49,     0,    30,
     0,    30,     5,     0,    49,    20,     5,     0,    49,    20,
     3,     0,    49,    28,     3,    29,     0,    49,    26,     5,
    27,     0,    49,    20,    26,    27,     0,    49,    20,    26,
    31,    27,     0,    49,    20,    26,    32,    27,     0,    49,
    20,    26,     6,    27,     0,    49,    20,    26,     5,    27,
     0,    49,    20,    26,     3,    27,     0,    49,    20,    26,
    21,     3,    27,     0,    49,    20,    26,    22,     3,    27,
     0,    51,     0,    52,     0,     3,     0,     4,     0,    20,
     3,     0,     3,    20,     3,     0,    20,     4,     0,     3,
    20,     4,     0,     6,     0,     5,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   110,   111,   114,   116,   120,   122,   126,   128,   132,   136,
   140,   144,   148,   152,   154,   159,   162,   164,   168,   170,
   174,   178,   180,   184,   188,   192,   194,   198,   200,   201,
   203,   207,   208,   209,   210,   214,   218,   222,   226,   229,
   234,   242,   246,   250,   254,   258,   262,   266,   270,   274,
   278,   282,   286,   290,   294,   299,   303,   309,   311,   312,
   314,   316,   318,   321,   327
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","TOK_DIGITS",
"TOK_EXPONENT","TOK_IDENT","TOK_STRING","TOK_EQ","TOK_NE","TOK_LE","TOK_LT",
"TOK_GE","TOK_GT","TOK_AND","TOK_OR","TOK_DEFAULT","TOK_EXIST","TOK_NOT","TOK_IN",
"TOK_SUBSTR","TOK_DOT","TOK_PLUS","TOK_MINUS","TOK_MUL","TOK_DIV","TOK_PCNT",
"TOK_LPAR","TOK_RPAR","TOK_LB","TOK_RB","TOK_DOLLAR","TOK_TRUE","TOK_FALSE",
"TOK_OTHER","UMINUS","UPLUS","global","constraint","bool_or","bool_and","bool_compare",
"expr_in","expr_substr","expr","term","factor_not","factor","comp_factor","compdone",
"component","number","lconst","dconst","string","enumident", NULL
};
#endif

static const short yyr1[] = {     0,
    36,    36,    37,    38,    38,    39,    39,    40,    40,    40,
    40,    40,    40,    40,    41,    41,    41,    42,    42,    43,
    43,    43,    44,    44,    44,    44,    45,    45,    46,    46,
    46,    46,    46,    46,    46,    46,    46,    46,    46,    47,
    48,    49,    49,    49,    49,    49,    49,    49,    49,    49,
    49,    49,    49,    49,    49,    50,    50,    51,    52,    52,
    52,    52,    52,    53,    54
};

static const short yyr2[] = {     0,
     0,     1,     1,     3,     1,     3,     1,     3,     3,     3,
     3,     3,     3,     1,     3,     3,     1,     3,     1,     3,
     3,     1,     3,     3,     3,     1,     2,     1,     1,     2,
     2,     1,     1,     1,     2,     2,     1,     1,     3,     1,
     1,     1,     2,     3,     3,     4,     4,     4,     5,     5,
     5,     5,     5,     6,     6,     1,     1,     1,     1,     2,
     3,     2,     3,     1,     1
};

static const short yydefact[] = {     1,
    58,    59,    65,    64,     0,     0,     0,     0,     0,     0,
     0,    42,    37,    38,     2,     3,     5,     7,    14,    17,
    19,    22,    26,    28,    34,    40,    41,    29,    56,    57,
    33,    32,     0,    36,    35,    27,    60,    62,    30,    31,
     0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    61,    63,    39,     4,     6,     8,     9,    10,    11,    12,
    13,    16,    15,    18,    20,    21,    23,    24,    25,    45,
    44,     0,     0,     0,     0,     0,     0,     0,     0,    48,
     0,     0,    47,    46,    53,    52,    51,     0,     0,    49,
    50,    54,    55,     0,     0,     0
};

static const short yydefgoto[] = {   104,
    15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
    25,    26,    27,    28,    29,    30,    31,    32
};

static const short yypact[] = {    -3,
   -14,-32768,-32768,-32768,    -4,    -4,    27,    12,     1,     1,
    -3,    33,-32768,-32768,-32768,    38,    41,-32768,    57,    44,
   -11,    53,-32768,-32768,-32768,-32768,    35,-32768,-32768,-32768,
-32768,-32768,    32,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    -7,-32768,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
     4,    -3,    -3,    -3,    -3,    -3,    -3,    34,    51,    85,
-32768,-32768,-32768,    41,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,    23,    53,    53,-32768,-32768,-32768,-32768,
-32768,    19,    62,    61,    64,    65,    66,    91,    92,-32768,
    69,    70,-32768,-32768,-32768,-32768,-32768,    71,    72,-32768,
-32768,-32768,-32768,   100,   101,-32768
};

static const short yypgoto[] = {-32768,
-32768,    93,    59,    63,    25,-32768,    54,    29,    24,    96,
    58,    79,-32768,    77,-32768,-32768,-32768,-32768
};


#define	YYLAST		109


static const short yytable[] = {     1,
     2,     3,     4,     1,     2,    33,    43,    52,    72,    53,
    54,     5,     6,     7,    37,    38,     8,     9,    10,    63,
     8,    85,    11,    86,    87,    12,    12,    13,    14,     1,
     2,     3,     4,    12,    61,    62,    80,    42,    81,    88,
    89,     5,     6,    53,    54,    90,     8,     9,    10,    91,
    92,    43,    11,    44,    58,    83,    12,    13,    14,    82,
    59,    51,    60,    45,    46,    47,    48,    49,    50,    66,
    67,    68,    69,    70,    71,    55,    56,    57,    77,    78,
    79,    75,    76,    34,    35,    39,    40,    84,    93,    94,
    95,    96,    97,    98,    99,   100,   101,   102,   103,   105,
   106,    64,    36,    41,     0,    74,    65,     0,    73
};

static const short yycheck[] = {     3,
     4,     5,     6,     3,     4,    20,    14,    19,     5,    21,
    22,    15,    16,    17,     3,     4,    20,    21,    22,    27,
    20,     3,    26,     5,     6,    30,    30,    31,    32,     3,
     4,     5,     6,    30,     3,     4,     3,     5,     5,    21,
    22,    15,    16,    21,    22,    27,    20,    21,    22,    31,
    32,    14,    26,    13,    20,     5,    30,    31,    32,    26,
    26,    18,    28,     7,     8,     9,    10,    11,    12,    45,
    46,    47,    48,    49,    50,    23,    24,    25,    55,    56,
    57,    53,    54,     5,     6,     9,    10,     3,    27,    29,
    27,    27,    27,     3,     3,    27,    27,    27,    27,     0,
     0,    43,     7,    11,    -1,    52,    44,    -1,    51
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/common/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/common/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 110 "yacc.y"
{ yyval.cexpr = NULL; _ps->r_tree = NULL; _ps->e = 0; ;
    break;}
case 2:
#line 112 "yacc.y"
{ yyval.cexpr = yyvsp[0].cexpr; _ps->r_tree = yyvsp[0].cexpr; _ps->e = 0; _ps->unregcexpr(yyvsp[0].cexpr); ;
    break;}
case 4:
#line 117 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewOr(_ps, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 6:
#line 123 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewAnd(_ps, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 8:
#line 129 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_eq, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 9:
#line 133 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_ne, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 10:
#line 137 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_le, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 11:
#line 141 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_lt, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 12:
#line 145 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_ge, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 13:
#line 149 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompare(_ps, RDI_CompareOp_gt, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 15:
#line 155 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewIn(_ps, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 16:
#line 160 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewRuntimeError(_ps, RDI_RTRet_NOT_SUPPORTED);
		  _ps->unregdelcexpr(yyvsp[-2].cexpr); _ps->unregdelstr(yyvsp[0].sb); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 18:
#line 165 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewSubStr(_ps, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 20:
#line 171 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewArith(_ps, RDI_ArithOp_add, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 21:
#line 175 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewArith(_ps, RDI_ArithOp_sub, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 23:
#line 181 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewArith(_ps, RDI_ArithOp_mul, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 24:
#line 185 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewArith(_ps, RDI_ArithOp_div, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 25:
#line 189 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewArith(_ps, RDI_ArithOp_rem, yyvsp[-2].cexpr, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 27:
#line 195 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewNot(_ps, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 30:
#line 202 "yacc.y"
{ yyval.cexpr = yyvsp[0].cexpr; ;
    break;}
case 31:
#line 204 "yacc.y"
{ yyval.cexpr = yyvsp[0].cexpr->negate(_ps);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 35:
#line 211 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewExist(_ps, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 36:
#line 215 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewDefault(_ps, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 37:
#line 219 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewBoolConst(_ps, 1);
		  if (_ps->e) { YYABORT; } 
                  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 38:
#line 223 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewBoolConst(_ps, 0);
		  if (_ps->e) { YYABORT; }
		  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 39:
#line 227 "yacc.y"
{ yyval.cexpr = yyvsp[-1].cexpr; ;
    break;}
case 40:
#line 230 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewCompEnd(_ps, yyvsp[0].cexpr);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 41:
#line 235 "yacc.y"
{ yyval.cexpr = yyvsp[0].cexpr->comp_done(_ps);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[0].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 42:
#line 243 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewComp(_ps, NULL);
		  if (_ps->e) { YYABORT; }
		  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 43:
#line 247 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewComp(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb);
		  if (_ps->e) { YYABORT; }
		  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 44:
#line 251 "yacc.y"
{ yyval.cexpr = yyvsp[-2].cexpr->add_dot_ident(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 45:
#line 255 "yacc.y"
{ yyval.cexpr = yyvsp[-2].cexpr->add_dot_num(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-2].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 46:
#line 259 "yacc.y"
{ yyval.cexpr = yyvsp[-3].cexpr->add_index(_ps, yyvsp[-1].sb); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-3].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 47:
#line 263 "yacc.y"
{ yyval.cexpr = yyvsp[-3].cexpr->add_assoc(_ps, yyvsp[-1].sb); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-3].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 48:
#line 267 "yacc.y"
{ yyval.cexpr = yyvsp[-3].cexpr->add_tag_default(_ps);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-3].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 49:
#line 271 "yacc.y"
{ yyval.cexpr = yyvsp[-4].cexpr->add_tag_bool(_ps, 1);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-4].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 50:
#line 275 "yacc.y"
{ yyval.cexpr = yyvsp[-4].cexpr->add_tag_bool(_ps, 0);
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-4].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 51:
#line 279 "yacc.y"
{ yyval.cexpr = yyvsp[-4].cexpr->add_tag_char(_ps, yyvsp[-1].sb); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-4].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 52:
#line 283 "yacc.y"
{ yyval.cexpr = yyvsp[-4].cexpr->add_tag_ident(_ps, yyvsp[-1].sb); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-4].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 53:
#line 287 "yacc.y"
{ yyval.cexpr = yyvsp[-4].cexpr->add_tag_num(_ps, yyvsp[-1].sb, 0); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-4].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 54:
#line 291 "yacc.y"
{ yyval.cexpr = yyvsp[-5].cexpr->add_tag_num(_ps, yyvsp[-1].sb, 0); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-5].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 55:
#line 295 "yacc.y"
{ yyval.cexpr = yyvsp[-5].cexpr->add_tag_num(_ps, yyvsp[-1].sb, 1); _ps->unregdelstr(yyvsp[-1].sb); 
		  if (_ps->e) { YYABORT; }
                  _ps->unregcexpr(yyvsp[-5].cexpr); _ps->regcexpr(yyval.cexpr); ;
    break;}
case 56:
#line 300 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewLConst(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb);
		  if (_ps->e) { YYABORT; }
                  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 57:
#line 304 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewDConst(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb);
		  if (_ps->e) { YYABORT; }
                  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 60:
#line 313 "yacc.y"
{ yyval.sb = RDI_BUILD_STRING(".", yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb); _ps->regstr(yyval.sb); ;
    break;}
case 61:
#line 315 "yacc.y"
{ yyval.sb = RDI_BUILD_STRING(yyvsp[-2].sb, ".", yyvsp[0].sb); _ps->unregdelstr(yyvsp[-2].sb); _ps->unregdelstr(yyvsp[0].sb); _ps->regstr(yyval.sb); ;
    break;}
case 62:
#line 317 "yacc.y"
{ yyval.sb = RDI_BUILD_STRING(".", yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb); _ps->regstr(yyval.sb); ;
    break;}
case 63:
#line 319 "yacc.y"
{ yyval.sb = RDI_BUILD_STRING(yyvsp[-2].sb, ".", yyvsp[0].sb); _ps->unregdelstr(yyvsp[-2].sb); _ps->unregdelstr(yyvsp[0].sb); _ps->regstr(yyval.sb); ;
    break;}
case 64:
#line 322 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewSConst(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb);
		  if (_ps->e) { YYABORT; }
                  _ps->regcexpr(yyval.cexpr); ;
    break;}
case 65:
#line 328 "yacc.y"
{ yyval.cexpr = RDI_Constraint::NewIdent(_ps, yyvsp[0].sb); _ps->unregdelstr(yyvsp[0].sb);
		  if (_ps->e) { YYABORT; }
                  _ps->regcexpr(yyval.cexpr); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/common/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += RDI_STRLEN(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 333 "yacc.y"


#ifdef __VMS
// Some versions of DEC C++ for OpenVMS set the module name used by the
// librarian based on the last #line encountered.
#line 1396 "RDIParser_y.cc"
#endif

