//
// $Id: MultiMapTest.m,v 1.11 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "MultiMapTest.h"
#import <ObjectiveLib/Map.h>
#import <ObjectiveLib/Algorithm.h>
#import <ObjectiveLib/Vector.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#endif
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation MultiMapTest

- (void) testBounds
{
    OLMultiMap* m;
    OLNumber* num;
    OLNumber* num2;
    OLAssociativeIterator* itor;
    OLPair* p;
    int i;
    unsigned count;

    m = [[OLMultiMap alloc] init];
    for (i = 0; i < 10; i++)
    {
        if (i != 4)
        {
            num = [[OLNumber alloc] initWithInt: i];
            [m assignKey: num value: REAP([num toText])];
            if (i == 2)
            {
                num2 = [[OLNumber alloc] initWithInt: (i * 10) + 1];
                [m assignKey: num value: REAP([num2 toText])];
                [num2 RELEASE];
                num2 = [[OLNumber alloc] initWithDouble: (i * 10) + 2];
                [m assignKey: num value: REAP([num2 toText])];
                [num2 RELEASE];
            }
            [num RELEASE];
        }
    }
    num = [[OLNumber alloc] initWithInt: 8];
    itor = REAP([m lowerBound: num]);
    if (![[[itor dereference] first] isEqual: num])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 8, but got %i", [[[itor dereference] first] intValue]];
    }
    if (![[[itor dereference] second] isEqual: REAP([num toText])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [REAP([num toText]) cString], [[[itor dereference] second] cString]];
    }
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 4];
    itor = REAP([m lowerBound: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    if (![[[itor dereference] first] isEqual: num])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %i", [[[itor dereference] first] intValue]];
    }
    if (![[[itor dereference] second] isEqual: REAP([num toText])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [REAP([num toText]) cString], [[[itor dereference] second] cString]];
    }
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 8];
    itor = REAP([m upperBound: num]);
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 9];
    if (![[[itor dereference] first] isEqual: num])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 9, but got %i", [[[itor dereference] first] intValue]];
    }
    if (![[[itor dereference] second] isEqual: REAP([num toText])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [REAP([num toText]) cString], [[[itor dereference] second] cString]];
    }
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    p = REAP([m equalRange: num]);
    [num RELEASE];
    count = [OLIterator distanceFrom: [p first] to: [p second]];
    if (count != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", count];
    }
    for ( ; ![[p first] isEqual: [p second]]; [[p first] advance])
    {
        if ([[[[p first] dereference] first] intValue] != 2)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected 2, but got %i",
                [[[[p first] dereference] first] intValue]];
        }
    }
    [m RELEASE];
}

- (void) testConvenienceAllocators
{
    OLMultiMap* m;
    OLMultiMap* m2;
    OLNumber* num;

    m = REAP([OLMultiMap multiMap]);
    if (![m IS_MEMBER_OF: [OLMultiMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMultiMap class])->name, ((Class)[m class])->name];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLMultiMap multiMapFrom: REAP([m begin]) to: REAP([m end])]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    num = [[OLNumber alloc] initWithInt: 4];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLMultiMap multiMapWithMap: m]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    m = REAP([OLMultiMap multiMapWithCompare:
        REAP([OLFunctor functorOfType: OLFunctorType_Greater])]);
    if (![m IS_MEMBER_OF: [OLMultiMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMultiMap class])->name, ((Class)[m class])->name];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    if (![[m keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLGreater class])->name, ((Class)[[m keyComp] class])->name];
    }
}

- (void) testCounting
{
    OLMultiMap* m;
    OLNumber* num;
    int i;
    int j;

    m = [[OLMultiMap alloc] init];
    for (i = 0; i < 100; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        if (i == 20)
        {
            for (j = 0; j < 20; j++)
                [m assignKey: num value: REAP([num toText])];
        }
        else
        {
            [m assignKey: num value: REAP([num toText])];
        }
        [num RELEASE];
    }
    num = [[OLNumber alloc] initWithInt: 20];
    i = [m count: num];
    [num RELEASE];
    if (i != 20)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 20, but got %i", i];
    }
    num = [[OLNumber alloc] initWithInt: 20000];
    i = [m count: num];
    [num RELEASE];
    if (i != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", i];
    }
    [m RELEASE];
}

- (void) testInsert
{
    OLMultiMap* m;
    OLAssociativeIterator* r;
    OLPair* p;
    OLVector* v;
    OLNumber* num;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    int keys[] = { 1, 3, 4, 4, 5, 5, 6, 6, 9, 9 };
    int i;

    m = [[OLMultiMap alloc] init];
    p = [[OLPair alloc] initWithFirst: @"my" second: @"dog"];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"my"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"my\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"dog"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"dog\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    p = [[OLPair alloc] initWithFirst: @"my" second: @"cat"];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"my"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"my\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"cat"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"cat\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    p = [[OLPair alloc] initWithFirst: @"your" second: @"cat"];
    r = REAP([m insertAt: r value: p]);
    [p RELEASE];
    if ([m size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"your"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"your\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"cat"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"cat\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    [m RELEASE];
    m = [[OLMultiMap alloc] init];
    v = [[OLVector alloc] init];
    for (i = 0; i < 10; i++)
    {
        num = [[OLNumber alloc] initWithInt: keys[i]];
        p = [[OLPair alloc] initWithFirst: num second: REAP([num toText])];
        [num RELEASE];
        [v pushBack: p];
        [p RELEASE];
    }
    [OLAlgorithm randomShuffleFrom: REAP([v begin]) to: REAP([v end])];
    [m insertFrom: REAP([v begin]) to: REAP([v end])];
    [v RELEASE];
    if ([m size] != 10)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10, but got %u", [m size]];
    }
    for (itor = REAP([m begin]), end = REAP([m end]), i = 0;
         ![itor isEqual: end]; [itor advance], i++)
    {
        num = [[OLNumber alloc] initWithInt: keys[i]];
        if (![[[itor dereference] first] isEqual: num])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                [num intValue], [[[itor dereference] first] intValue]];
        }
        if (![[[itor dereference] second] isEqual: REAP([num toText])])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [REAP([num toText]) cString], [[[itor dereference] second] cString]];
        }
        [num RELEASE];
    }
    num = [[OLNumber alloc] initWithInt: 700];
    [m assignKey: num value: REAP([num toText])];
    itor = REAP([m find: num]);
    if (![[[itor dereference] first] isEqual: num])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %i, but got %i",
            [num intValue], [[[itor dereference] first] intValue]];
    }
    if (![[[itor dereference] second] isEqual: REAP([num toText])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [REAP([num toText]) cString], [[[itor dereference] second] cString]];
    }
    [num RELEASE];
    [m RELEASE];
}

- (void) testInitializers
{
    OLMultiMap* m;
    CONSTSTR* keys[] = { @"five", @"five", @"four", @"four", @"one",
                         @"one", @"one", @"three", @"two", @"two" };
    int vals[] = { 5, 5, 4, 4, 1, 1, 1, 3, 2, 2 };
    OLNumber* num;
    OLPair* pairs[10];
    OLPair* p;
    OLAssociativeIterator* b;
    OLAssociativeIterator* e;
    int i;

    for (i = 0; i < 10; i++)
    {
        num = [[OLNumber alloc] initWithInt: vals[i]];
        pairs[i] = [[OLPair alloc] initWithFirst: keys[i] second: num];
        [num RELEASE];
    }
    p = REAP([OLArrayIterator pairWithPointer: pairs distance: 10]);
    [OLAlgorithm randomShuffleFrom: [p first] to: [p second]];
    m = [[OLMultiMap alloc] initFrom: [p first] to: [p second]];
    for (i = 0; i < 10; i++)
        [pairs[i] RELEASE];
    if ([m size] != 10)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10, but got %u", [m size]];
    }
    for (b = REAP([m begin]), e = REAP([m end]), i = 0; ![b isEqual: e]; [b advance], i++)
    {
        if (![[[b dereference] first] isEqual: keys[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [keys[i] cString], [[[b dereference] first] cString]];
        }
        if ([[[b dereference] second] intValue] != vals[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                vals[i], [[[b dereference] second] intValue]];
        }
    }
    [m RELEASE];
}

@end
