//
// $Id: AlgorithmTest.h,v 1.14 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */


#import "UnitTest.h"

@interface AlgorithmTest : UnitTest
{
}

- (void) testAdjacentFind;
- (void) testBinarySearch;
- (void) testCopy;
- (void) testCounting;
- (void) testEqual;
- (void) testEqualRange;
- (void) testFill;
- (void) testFind;
- (void) testFindEnd;
- (void) testFindFirst;
- (void) testForEach;
- (void) testIncludes;
- (void) testInPlaceMerge;
- (void) testLexicographicalCompare;
- (void) testLowerBound;
- (void) testMakeHeap;
- (void) testMerge;
- (void) testMinMax;
- (void) testMinMaxElement;
- (void) testMismatch;
- (void) testNextPermutation;
- (void) testNthElement;
- (void) testPartialSort;
- (void) testPartialSortCopy;
- (void) testPartition;
- (void) testPopHeap;
- (void) testPrevPermutation;
- (void) testPushHeap;
- (void) testRandomShuffle;
- (void) testRemove;
- (void) testRemoveCopy;
- (void) testReplace;
- (void) testReplaceCopy;
- (void) testReverse;
- (void) testReverseCopy;
- (void) testRotate;
- (void) testSearch;
- (void) testSearchCount;
- (void) testSetDifference;
- (void) testSetIntersection;
- (void) testSetSymmetricDifference;
- (void) testSetUnion;
- (void) testSort;
- (void) testSortHeap;
- (void) testStablePartition;
- (void) testStableSort;
- (void) testSwap;
- (void) testSwapRanges;
- (void) testTransform;
- (void) testUnique;
- (void) testUniqueCopy;
- (void) testUpperBound;

@end

