//
// $Id: SharedPointerTable.m,v 1.8 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "SharedPointerTable.h"
#import "Macros.h"
#import "RunTime.h"
#import "InStream.h"
#import "Exception.h"
#if defined(OL_NO_OPENSTEP)
#import "Text.h"
#else
#import <Foundation/NSException.h>
#import <Foundation/NSString.h>
#endif
#import <string.h>
#import <stdlib.h>

@implementation OLSharedPointerTable

- (id) init
{
    [super init];
    entryCapacity = 30;
    entryCount = 0;
    entries = objc_malloc(entryCapacity * sizeof(OLSharedPointerEntry));
    return self;
}

#if defined(OL_NO_OPENSTEP)
- (id) free
#else
- (void) dealloc
#endif
{
    unsigned i;

    for (i = 0; i < entryCount; i++)
    {
        if (entries[i].isObject)
            OBJ_RELEASE((id)entries[i].pointer);
    }
    objc_free(entries);
    SUPER_FREE;
}

- (uint32_t) addObject: (id)object
{
    uint32_t handle = entryCount;

    [self makeRoom];
    entries[entryCount].pointer = OBJ_RETAIN(object);
    entries[entryCount].isObject = YES;
    entryCount++;
    return handle;
}

- (uint32_t) addPointer: (void*)ptr
{
    uint32_t handle = entryCount;

    [self makeRoom];
    entries[entryCount].pointer = ptr;
    entries[entryCount].isObject = NO;
    entryCount++;
    return handle;
}

- (void*) lookUp: (uint32_t)handle
{
    if (handle >= entryCount)
    {
        RAISE_EXCEPTION(OLInputOutputException, @"Invalid handle in input stream");
    }
#if !defined(OL_NO_OPENSTEP)
    if (entries[handle].isObject)
        [OBJ_RETAIN((id)entries[handle].pointer) autorelease];
#endif
    return entries[handle].pointer;
}

- (void) makeRoom
{
    OLSharedPointerEntry* newEntries;

    if (entryCount == entryCapacity)
    {
        entryCapacity = entryCapacity * 2 + 1;
        newEntries = objc_malloc(entryCapacity * sizeof(OLSharedPointerEntry));
        memcpy(newEntries, entries, entryCount * sizeof(OLSharedPointerEntry));
        objc_free(entries);
        entries = newEntries;
    }
}

@end
