//
// $Id: Reaper.m,v 1.10 2007/03/28 03:16:51 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Reaper.h"
#import "RunTime.h"
#import "Macros.h"
#import "VectorJunior.h"
#import "Synchronization.h"
#import <stdio.h>
#include <stdlib.h>

typedef struct _OLReaperInfo
{
    struct _OLReadperInfo*  next;
    OLReaper*               reaper;
} OLReaperInfo;

static OLThreadDataKey __reaperKey;
static OLOnceControl __reaperOnce = OL_ONCE_INIT;

static void __initializeReaperKey()
{
    OLCreateThreadDataKey(&__reaperKey);
}

@implementation OLReaper

+ (OLReaper*) currentReaper
{
    OLReaperInfo* info = OLGetThreadData(__reaperKey);

    return (info == NULL) ? (OLReaper*)nil : info->reaper;
}

+ (id) initialize
{
    if (self == [OLReaper class])
        OLOnce(&__reaperOnce, __initializeReaperKey);
    return self;
}

- (id) init
{
    OLReaperInfo* cur = objc_malloc(sizeof(OLReaperInfo));

    [super init];
    undead = [[OLVectorJunior alloc] init];
    cur->next = OLGetThreadData(__reaperKey);
    cur->reaper = self;
    OLSetThreadData(__reaperKey, cur);
    return self;
}

- (id) free
{
    OLReaperInfo* cur;
    unsigned undeadSize = [undead size];
    unsigned i;

    cur = OLGetThreadData(__reaperKey);
    if (cur->reaper != self)
    {
        printf("*** There is an unreleased reaper in the chain! Release it. ***\n");
        abort();
    }
    OLSetThreadData(__reaperKey, cur->next);
    objc_free(cur);
    for (i = 0; i < undeadSize; i++)
        OBJ_RELEASE([undead at: i]);
    OBJ_RELEASE(undead);
    SUPER_FREE;
}

- (id) reap: (id)object
{
    [undead pushBack: object];
    return object;
}

- (unsigned) size
{
    return [undead size];
}

@end
