//
// $Id: Macros.h,v 1.31 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(MACROS_OL_GUARD)
#define MACROS_OL_GUARD

#include "Config.h"

#if defined(OL_NO_OPENSTEP)
#define OBJ_RETAIN(obj) [ obj copy ]
#define OBJ_RELEASE(obj) [ obj free ]
#define OBJ_AUTORELEASE(obj) obj
#define OBJ_COPY(obj) [ obj copy ]
#define OBJ_FREE_AUTO(obj) [ obj free ]
#define OBJ_RETAIN_AUTO(obj) obj
#define OBJ_PERFORM(obj, sel) [ obj perform: sel ]
#define OBJ_PERFORM_WITH(obj, sel, arg) [ obj perform: sel with: arg ]
#define IS_KIND_OF(obj, cls) [ obj isKindOf: [ cls class ] ]
#define RESPONDS_TO(obj, sel) [ obj respondsTo: sel ]
#define OL_DURING OL_TRY
#define OL_HANDLER OL_CATCH
#define OL_ENDHANDLER OL_END_CATCH
#define OL_VALUERETURN(v, t) OL_TRY_RETURN(v)
#define OL_BEGIN_AUTO_CTOR(cls) return [[ cls alloc ]
#define OL_END_AUTO_CTOR ]
#define RAISE_EXCEPTION(n, ...) [ OLException raiseTypeString: n messageString: __VA_ARGS__ ]
#define INVALID_ARGUMENT OLInvalidArgumentException
#define GENERIC_EXCEPTION OLGenericException
#define SUBCLASS_MUST_IMPLEMENT [ self subclassResponsibility: _cmd ]
#define SUPER_FREE return [ super free ]
#else
#define OBJ_RETAIN(obj) [ obj retain ]
#define OBJ_RELEASE(obj) [ obj release ]
#define OBJ_AUTORELEASE(obj) [ obj autorelease ]
#define OBJ_COPY(obj) [ obj copyWithZone: [ obj zone ] ]
#define OBJ_FREE_AUTO(obj)
#define OBJ_RETAIN_AUTO(obj) [ obj retain ]
#define OBJ_PERFORM(obj, sel) [ obj performSelector: sel ]
#define OBJ_PERFORM_WITH(obj, sel, arg) [ obj performSelector: sel withObject: arg ]
#define IS_KIND_OF(obj, cls) [ obj isKindOfClass: [ cls class ] ]
#define RESPONDS_TO(obj, sel) [ obj respondsToSelector: sel ]
#define OL_DURING NS_DURING
#define OL_HANDLER NS_HANDLER
#define OL_ENDHANDLER NS_ENDHANDLER
#define OL_VALUERETURN(v, t) NS_VALUERETURN(v, t)
#define OL_CATCH_RETURN(val) return val
#define OL_BEGIN_AUTO_CTOR(cls) return [[[ cls alloc ]
#define OL_END_AUTO_CTOR ] autorelease]
#define RAISE_EXCEPTION(n, ...) [ NSException raise: n format: __VA_ARGS__ ]
#define INVALID_ARGUMENT NSInvalidArgumentException
#define GENERIC_EXCEPTION NSGenericException
#define SUBCLASS_MUST_IMPLEMENT [ self doesNotRecognizeSelector: _cmd ]
#define SUPER_FREE [ super dealloc ]
#endif
#define OL_FAST_SWAP(one, two) (one) ^= (two); (two) ^= (one); (one) ^= (two)
#define OL_PREPARE_SLOW_SWAP void* __slowSwapTempValue
#define OL_SLOW_SWAP(one, two) __slowSwapTempValue = (one), (one) = (two), (two) = __slowSwapTempValue
#define BIG_STRING_TELL_BIT 0x8000
#define MAX_SINGLE_CHUNK_STR (UINT16_MAX & ~BIG_STRING_TELL_BIT)
#define OL_SUN_LEN(su) \
    (sizeof(*(su)) - sizeof((su)->sun_path) + strlen((su)->sun_path))
#if !defined(MIN)
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#endif
#if !defined(MAX)
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

/*
 * Object stream macros
 */
#define OL_STREAM_MAGIC          	0x16080B0B
#define OL_STREAM_VERSION        	0
#define WIRE_TYPE_HANDLE          	0xFF
#define WIRE_TYPE_CLASS           	0xFE
#define WIRE_TYPE_END_CLASS       	0xFD
#define WIRE_TYPE_STRING          	0xFC
#define WIRE_TYPE_INSTANCE        	0xFB
#define WIRE_TYPE_NIL             	0xFA
#define WIRE_TYPE_DATA            	0xF9
#define WIRE_TYPE_BOOL            	0xF8
#define WIRE_TYPE_DOUBLE          	0xF7
#define WIRE_TYPE_FLOAT           	0xF6
#define WIRE_TYPE_INT             	0xF5
#define WIRE_TYPE_INT16           	0xF4
#define WIRE_TYPE_INT32           	0xF3
#define WIRE_TYPE_INT64           	0xF2
#define WIRE_TYPE_CHAR            	0xF1
#define WIRE_TYPE_SHORT           	0xF0
#define WIRE_TYPE_LONG            	0xEF
#define WIRE_TYPE_LONG_LONG       	0xEE
#define WIRE_TYPE_SELECTOR        	0xED
#define WIRE_TYPE_CHARPTR         	0xEC
#define WIRE_TYPE_ARRAY           	0xEB
#define WIRE_TYPE_POINTER         	0xEA
#define WIRE_TYPE_NULL            	0xE9
#define WIRE_TYPE_STRUCTURE       	0xE8
#define WIRE_TYPE_OBJECT_DATA     	0xE7
#define WIRE_TYPE_BYTE_BLOCK      	0xE6
#define WIRE_TYPE_UTF8_DATA       	0xE5
#define WIRE_TYPE_CLASS_NAME      	0xE4

/*
 * Gzip constants
 */
#define GZ_ID1          31
#define GZ_ID2          139
#define GZ_OS_UNKNOWN   255
#define GZ_FTEXT        (1 << 0)
#define GZ_FHCRC        (1 << 1)
#define GZ_FEXTRA       (1 << 2)
#define GZ_FNAME        (1 << 3)
#define GZ_FCOMMENT     (1 << 4)

/*
 * For accessing the bzstream in bzlib streams
 */
#define BZSTREAM ((bz_stream*)bzstream)

#endif
