//
// $Id: LayeredInStream.m,v 1.10 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "LayeredInStream.h"
#import "Macros.h"
#import "ConnectedInStream.h"

#define FREE_MY_RESOURCES \
    OBJ_RELEASE(stream)

@implementation OLLayeredInStream

- (id) initWithInStream: (OLInStream*)underStream
{
    [super init];
    stream = OBJ_RETAIN(underStream);
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (void) dealloc
{
    FREE_MY_RESOURCES;
    SUPER_FREE;
}
#endif

- (void) close
{
    [stream close];
}

- (id) connectedInStream
{
    id cur = stream;

    while (!IS_KIND_OF(cur, OLConnectedInStream))
        cur = ((OLLayeredInStream*)cur)->stream;
    return cur;
}

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources
{
    FREE_MY_RESOURCES;
    [super freeStreamResources];
}
#endif

- (unsigned) readBytes: (uint8_t*)buffer count: (unsigned)max
{
    return [stream readBytes: buffer count: max];
}

@end
