//
// $Id: BufferingOutStream.m,v 1.9 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "BufferingOutStream.h"
#import "OutStreamPackage.h"
#import "Macros.h"
#import "RunTime.h"
#import <string.h>
#import <stdlib.h>

#define FREE_MY_RESOURCES \
    [self close]; \
    objc_free(buffer)

@interface OLBufferingOutStream (PrivateMethods)

- (void) flushImpl;

@end

@implementation OLBufferingOutStream

+ (id) streamWithOutStream: (OLOutStream*)underStream
{
    OL_BEGIN_AUTO_CTOR(OLBufferingOutStream)
        initWithOutStream: underStream
    OL_END_AUTO_CTOR;
}

- (id) initWithOutStream: (OLOutStream*)underStream
{
    return [self initWithOutStream: underStream bufferSize: 32 * 1024];
}

- (id) initWithOutStream: (OLOutStream*)underStream bufferSize: (unsigned)size
{
    [super initWithOutStream: underStream];
    buffer = objc_malloc(size);
    capacity = size;
    count = 0;
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (void) dealloc
{
	FREE_MY_RESOURCES;
	SUPER_FREE;
}
#endif

- (void) flush
{
    [self flushImpl];
    [stream flush];
}

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources
{
	FREE_MY_RESOURCES;
	[super freeStreamResources];
}
#endif

- (void) writeByte: (uint8_t)byte
{
    if (capacity == count)
        [self flushImpl];
    buffer[count++] = byte;
}

- (unsigned) writeBytes: (const uint8_t*)bytes count: (unsigned)num
{
    unsigned written;

    if (num > capacity)
    {
        [self flushImpl];
        written = [stream writeBytes: bytes count: num];
    }
    else
    {
        if (num > capacity - count)
            [self flushImpl];
        memcpy(buffer + count, bytes, num);
        count += num;
        written = num;
    }
    return written;
}

@end

@implementation OLBufferingOutStream (PrivateMethods)

- (void) flushImpl
{
    [stream completelyWriteBytes: buffer count: count];
    count = 0;
}

@end


