#include "oak.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define GROWBY 1.75

int oak_string_create(oak_string *s, char *in)
{
  int ret, len;
  len=strlen(in);
  ret=oak_string_create_with_size(s, len);
  if (ret) return(ret);
  strcpy(s->buff, in);
  s->len=len;
  return(ret);
}

/* create a null string, but starting with 'size' allocated in
 * memory
 */
int oak_string_create_with_size(oak_string *s, int size)
{
  s->buff=malloc(size+10);
  if (s->buff==NULL) return(-1);
  s->avail=size+10;
  s->len=0;
  strcpy(s->buff, "");
  return(0);
}

char *oak_string_to_str(oak_string *s)
{
  if ((s->len==0) || (!s->buff)) return("");
  return(s->buff);
}

void oak_string_strcat(oak_string *s, char *in)
{
  int inlen, need, next;

  /* do we need more space? */
  inlen=strlen(in);
  need=inlen+s->len+5;
  next=s->avail*GROWBY;
  if (need > s->avail) {
    if (next>need) {
      /* go with the GROWBY */
      s->buff=realloc(s->buff, next);
      s->avail=next;
    } else {
      /* GROWBY won't handle this string, give it as much as it needs */
      s->buff=realloc(s->buff, need);
      s->avail=need;
    }
  }
  strcat(s->buff, in);
  s->len+=inlen;
}

int oak_string_get_strlen(oak_string *s)
{
  return(s->len);
}

void oak_string_free(oak_string *s)
{
  if (s->buff) free(s->buff);
}
