/*
This source is published under the following 3-clause BSD license.

Copyright (c) 2012, Lukas Hosek and Alexander Wilkie
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * None of the names of the contributors may be used to endorse or promote 
      products derived from this software without specific prior written 
      permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/* ============================================================================

This file is part of a sample implementation of the analytical skylight model
presented in the SIGGRAPH 2012 paper


           "An Analytic Model for Full Spectral Sky-Dome Radiance"

                                    by 

                       Lukas Hosek and Alexander Wilkie
                Charles University in Prague, Czech Republic


                        Version: 1.0, May 11th, 2012


Please visit http://cgg.mff.cuni.cz/projects/SkylightModelling/ to check if
an updated version of this code has been published!

============================================================================ */


/*

This file contains the coefficient data for both the spectral and the colour
space version of the model.

*/

double dataset320[] = 
{
	// albedo 0, turbidity 1
	-1.341049e+001,
	-3.742293e+000,
	-5.229614e+000,
	5.307180e+000,
	-2.182658e-002,
	1.497676e-001,
	-8.561730e-006,
	1.733480e+000,
	8.826913e-001,
	-1.426825e+001,
	-3.550926e+000,
	5.719350e-002,
	3.165753e-001,
	-5.870693e-002,
	1.333896e-001,
	1.779338e-005,
	1.504276e+000,
	9.750357e-001,
	-2.239068e+000,
	-4.290407e+000,
	-7.494879e-001,
	2.864989e-001,
	-6.017855e-002,
	1.325901e-001,
	-1.661674e-004,
	1.732120e+000,
	6.513374e-001,
	-1.336194e+000,
	-2.467808e-001,
	3.961139e-001,
	-6.723820e-002,
	-1.817268e-001,
	1.017581e-002,
	6.096079e-004,
	1.986859e+000,
	1.415296e+000,
	-1.554271e+000,
	-1.811527e+000,
	7.309756e-001,
	1.766793e-003,
	5.779090e-001,
	6.186216e-001,
	-1.755338e-003,
	-2.701090e-002,
	2.699530e-001,
	-8.449639e-001,
	-5.665198e-001,
	5.525823e-001,
	-2.838870e-003,
	-4.555228e+000,
	2.824945e-001,
	4.002014e-003,
	1.114208e+000,
	6.637074e-001,
	// albedo 0, turbidity 2
	-1.298333e+001,
	-3.775577e+000,
	-5.173531e+000,
	5.316518e+000,
	-2.572615e-002,
	1.516601e-001,
	-8.297168e-006,
	1.669649e+000,
	9.000495e-001,
	-1.402639e+001,
	-3.787558e+000,
	7.611941e-002,
	2.521881e-001,
	-5.859973e-002,
	1.753711e-001,
	4.670097e-005,
	1.459275e+000,
	8.998629e-001,
	-2.190256e+000,
	-3.575495e+000,
	-4.930996e-001,
	4.826321e-002,
	-6.797145e-002,
	3.425922e-002,
	-3.512550e-004,
	1.978419e+000,
	8.866517e-001,
	-2.415991e+000,
	-1.453294e+000,
	2.170671e-001,
	1.341284e-001,
	-1.926330e-001,
	1.059103e-001,
	1.360739e-003,
	1.587725e+000,
	9.821154e-001,
	-5.254592e-001,
	-8.181026e-001,
	7.535702e-001,
	-3.323364e-002,
	4.503149e-001,
	5.778285e-001,
	-4.089673e-003,
	3.335089e-001,
	6.827164e-001,
	-1.280108e+000,
	-1.013716e+000,
	5.577676e-001,
	9.539205e-004,
	-4.934956e+000,
	2.642883e-001,
	1.005169e-002,
	9.265844e-001,
	4.999698e-001,
	// albedo 0, turbidity 3
	-1.292247e+001,
	-3.819777e+000,
	-4.478733e+000,
	4.582924e+000,
	-2.364370e-002,
	1.619828e-001,
	-3.053548e-006,
	1.646629e+000,
	5.103371e-001,
	-1.433099e+001,
	-3.766213e+000,
	4.930150e-001,
	-3.081235e-002,
	-6.522199e-002,
	1.564198e-001,
	3.455657e-004,
	1.428507e+000,
	4.312273e-001,
	-2.539220e+000,
	-3.459074e+000,
	-3.774393e-001,
	-3.628419e-001,
	-2.124451e-001,
	-1.358132e-002,
	-1.812805e-003,
	2.245152e+000,
	7.247429e-001,
	-2.393246e+000,
	-1.937898e+000,
	1.005834e-001,
	5.867890e-001,
	2.645044e-001,
	1.413695e-001,
	6.378716e-003,
	1.140715e+000,
	1.263014e+000,
	-1.185583e-001,
	-1.960943e-001,
	7.212723e-001,
	-1.763978e-001,
	-1.000190e+000,
	6.259726e-001,
	-1.783726e-002,
	7.790644e-001,
	3.244710e-001,
	-1.550325e+000,
	-1.333575e+000,
	5.618137e-001,
	2.563595e-002,
	-5.007716e+000,
	6.522985e-002,
	4.262830e-002,
	7.371930e-001,
	5.239972e-001,
	// albedo 0, turbidity 4
	-1.234358e+001,
	-3.851875e+000,
	-3.911206e+000,
	4.011324e+000,
	-2.734425e-002,
	1.272306e-001,
	-7.628210e-006,
	1.661843e+000,
	8.993903e-001,
	-1.349727e+001,
	-3.592681e+000,
	1.335192e+000,
	-9.426446e-001,
	-5.741127e-002,
	9.765267e-002,
	5.518099e-005,
	1.428554e+000,
	-4.278471e-001,
	-3.399618e+000,
	-3.818725e+000,
	-8.698171e-001,
	2.723930e-001,
	-3.644369e-001,
	1.238759e-001,
	-5.189179e-004,
	2.279175e+000,
	1.841076e+000,
	-1.925152e+000,
	-1.539333e+000,
	2.757771e-001,
	-6.435980e-002,
	6.466700e-001,
	3.084382e-002,
	3.114730e-003,
	1.259818e+000,
	5.121617e-001,
	-5.706832e-001,
	-6.696186e-001,
	6.798158e-001,
	6.920162e-001,
	-3.898854e+000,
	5.954021e-001,
	-1.196667e-002,
	5.714991e-001,
	6.528481e-001,
	-1.371907e+000,
	-1.142330e+000,
	5.207805e-001,
	-4.480298e-003,
	-5.008950e+000,
	1.251549e-001,
	3.531514e-002,
	8.776759e-001,
	4.999465e-001,
	// albedo 0, turbidity 5
	-1.459738e+001,
	-3.833562e+000,
	-4.148717e+000,
	4.203270e+000,
	-2.484405e-002,
	1.189704e-001,
	4.166397e-004,
	1.748850e+000,
	4.999721e-001,
	-1.223022e+001,
	-3.942049e+000,
	1.183072e+000,
	-9.018678e-001,
	-4.644071e-002,
	1.237476e-001,
	-2.359994e-003,
	1.471013e+000,
	5.298845e-001,
	-4.078262e+000,
	-3.261096e+000,
	-5.520001e-001,
	2.174261e-001,
	-3.582576e-001,
	2.000597e-002,
	9.890182e-003,
	2.199274e+000,
	2.756320e-001,
	-2.499065e+000,
	-2.408391e+000,
	3.391663e-002,
	-6.167543e-002,
	7.555424e-001,
	2.349252e-001,
	-2.443140e-002,
	1.328540e+000,
	1.348906e+000,
	5.456648e-002,
	-9.221401e-002,
	7.403428e-001,
	5.565324e-001,
	-5.134970e+000,
	3.021763e-001,
	3.638500e-002,
	5.560149e-001,
	1.818210e-001,
	-1.590269e+000,
	-1.344330e+000,
	4.805789e-001,
	5.038509e-001,
	-3.370644e+000,
	3.040357e-001,
	2.418483e-003,
	8.979818e-001,
	7.477974e-001,
	// albedo 0, turbidity 6
	-6.775680e+000,
	-3.436745e+000,
	-2.696730e+000,
	2.740681e+000,
	-4.032382e-002,
	1.036486e-001,
	8.133034e-005,
	1.767160e+000,
	5.401354e-001,
	-7.800595e+000,
	-2.867058e+000,
	1.478909e+000,
	-1.380160e+000,
	-1.658909e-001,
	1.962673e-001,
	-6.512798e-004,
	1.634359e+000,
	4.300704e-001,
	-4.392403e+000,
	-3.857979e+000,
	-1.022020e+000,
	1.449394e+000,
	2.769695e-001,
	-3.331834e-001,
	3.513950e-003,
	1.942113e+000,
	3.970742e-001,
	-2.469701e+000,
	-1.357319e+000,
	2.132600e-001,
	-1.918729e+000,
	-4.193060e+000,
	8.101579e-001,
	-9.605279e-003,
	1.844443e+000,
	1.582310e+000,
	-7.759612e-001,
	-1.298076e+000,
	7.162377e-001,
	2.906682e+000,
	-8.261148e-001,
	-2.892123e-001,
	1.491449e-002,
	6.529387e-002,
	-4.180287e-002,
	-9.962340e-001,
	-6.488730e-001,
	3.933344e-001,
	-4.752111e-003,
	-4.721793e+000,
	6.053196e-001,
	3.453563e-003,
	1.247655e+000,
	8.673379e-001,
	// albedo 0, turbidity 7
	-7.552689e+000,
	-3.219112e+000,
	-2.730242e+000,
	2.755929e+000,
	-3.925138e-002,
	8.394617e-002,
	1.514980e-004,
	1.844410e+000,
	5.389194e-001,
	-8.494732e+000,
	-3.138528e+000,
	1.424739e+000,
	-1.269326e+000,
	-1.561580e-001,
	1.767060e-001,
	-1.175921e-003,
	1.659123e+000,
	3.746132e-001,
	-4.672972e+000,
	-4.049529e+000,
	-1.027600e+000,
	1.072252e+000,
	7.908165e-002,
	-2.243835e-001,
	6.190595e-003,
	1.988822e+000,
	6.684758e-001,
	-2.256117e+000,
	-1.258356e+000,
	2.198377e-001,
	-1.296239e+000,
	-3.200970e+000,
	6.407291e-001,
	-1.527762e-002,
	1.735209e+000,
	1.170530e+000,
	-7.790059e-001,
	-1.269213e+000,
	6.315194e-001,
	2.368850e+000,
	-1.199163e+000,
	-1.504024e-001,
	1.733299e-002,
	2.544016e-001,
	2.756763e-001,
	-1.046916e+000,
	-6.991719e-001,
	3.620624e-001,
	7.364236e-002,
	-5.012491e+000,
	4.240417e-001,
	3.580425e-002,
	1.202329e+000,
	6.255804e-001,
	// albedo 0, turbidity 8
	-1.886851e+001,
	-4.491136e+000,
	-3.660440e+000,
	3.704226e+000,
	-3.158478e-002,
	1.229909e-001,
	9.233613e-004,
	1.745459e+000,
	5.011929e-001,
	-1.986322e+001,
	-3.528401e+000,
	1.401749e+000,
	-1.191377e+000,
	-7.474944e-002,
	-2.193835e-002,
	-5.138968e-003,
	1.710181e+000,
	5.473672e-001,
	5.355660e-001,
	-5.459304e+000,
	-8.809226e-001,
	5.959028e-001,
	-3.311339e-001,
	3.876731e-001,
	2.126070e-002,
	1.929868e+000,
	1.883429e-001,
	-3.136053e+000,
	-2.856938e-001,
	1.048390e-001,
	-7.708877e-001,
	2.106630e-001,
	-1.488471e-001,
	-5.172733e-002,
	1.769302e+000,
	1.526253e+000,
	1.496752e-001,
	-9.170428e-001,
	5.628226e-001,
	1.733601e+000,
	-4.784033e+000,
	3.570330e-001,
	7.396580e-002,
	3.954993e-001,
	1.397727e-003,
	-1.839740e+000,
	-1.279260e+000,
	3.173503e-001,
	1.096266e+000,
	-4.168649e+000,
	2.121881e-001,
	2.150917e-002,
	1.151497e+000,
	7.233585e-001,
	// albedo 0, turbidity 9
	-1.841090e+001,
	-4.803089e+000,
	-4.883823e+000,
	4.962235e+000,
	-2.693216e-002,
	1.089917e-001,
	-6.338015e-006,
	1.725865e+000,
	8.890717e-001,
	-1.947081e+001,
	-2.961260e+000,
	1.963002e+000,
	-1.942423e+000,
	-5.550118e-002,
	7.036456e-002,
	-5.990592e-004,
	1.807097e+000,
	-8.871814e-003,
	9.588307e-001,
	-6.379803e+000,
	-1.021090e+000,
	9.560589e-001,
	-2.175500e-001,
	8.613517e-002,
	1.362268e-002,
	1.953529e+000,
	7.422482e-001,
	-3.609766e+000,
	-1.823498e-003,
	2.516424e-002,
	-8.909855e-001,
	2.207805e-001,
	1.783064e-001,
	-4.293958e-002,
	1.607901e+000,
	1.131559e+000,
	6.087707e-001,
	-6.744295e-001,
	4.236310e-001,
	1.505925e+000,
	-4.197126e+000,
	2.046561e-001,
	6.445824e-002,
	7.793118e-001,
	3.262213e-001,
	-2.148492e+000,
	-1.597890e+000,
	3.166858e-001,
	2.414329e+000,
	-4.201339e+000,
	1.005902e-001,
	4.687865e-002,
	9.335376e-001,
	5.289661e-001,
	// albedo 0, turbidity 10
	-1.787767e+001,
	-4.873485e+000,
	-5.861224e+000,
	5.866336e+000,
	-1.564202e-002,
	6.967640e-002,
	7.574926e-004,
	1.768065e+000,
	5.856596e-001,
	-1.932995e+001,
	-4.092647e+000,
	2.679531e+000,
	-2.555671e+000,
	-4.181418e-002,
	1.023654e-001,
	-5.964172e-003,
	1.625691e+000,
	4.036808e-001,
	1.788482e+000,
	-5.652582e+000,
	-1.517519e+000,
	1.251535e+000,
	-2.225912e-001,
	-1.084716e-001,
	3.272584e-002,
	2.139078e+000,
	3.876645e-001,
	-3.363801e+000,
	-3.266475e-001,
	1.313912e-001,
	-6.889075e-001,
	4.356523e-001,
	3.120297e-001,
	-8.700131e-002,
	1.750122e+000,
	1.223546e+000,
	4.668756e-004,
	-9.612337e-001,
	3.082344e-001,
	1.298938e+000,
	-4.371395e+000,
	8.845524e-002,
	1.303481e-001,
	5.843720e-001,
	2.718863e-001,
	-1.759172e+000,
	-1.386072e+000,
	2.349661e-001,
	1.592185e+000,
	-3.063267e+000,
	1.529736e-001,
	3.429185e-002,
	1.030294e+000,
	6.917018e-001,
	// albedo 1, turbidity 1
	-1.341051e+001,
	-3.742047e+000,
	-5.229556e+000,
	5.307222e+000,
	-2.094796e-002,
	1.499787e-001,
	-7.023116e-006,
	1.732898e+000,
	8.826861e-001,
	-1.426829e+001,
	-3.550660e+000,
	5.731266e-002,
	3.166575e-001,
	-5.821080e-002,
	1.335860e-001,
	2.003178e-004,
	1.503788e+000,
	9.750310e-001,
	-2.239143e+000,
	-4.290084e+000,
	-7.493158e-001,
	2.865753e-001,
	-5.993923e-002,
	1.327393e-001,
	-5.399344e-004,
	1.731677e+000,
	6.513329e-001,
	-1.336350e+000,
	-2.463606e-001,
	3.963632e-001,
	-6.721398e-002,
	-1.816244e-001,
	1.021503e-002,
	8.081470e-004,
	1.986453e+000,
	1.415292e+000,
	-1.554584e+000,
	-1.810948e+000,
	7.313475e-001,
	1.703307e-003,
	5.779436e-001,
	6.184790e-001,
	-6.832621e-004,
	-2.739619e-002,
	2.699443e-001,
	-8.456234e-001,
	-5.656772e-001,
	5.531782e-001,
	-2.975361e-003,
	-4.555221e+000,
	2.821035e-001,
	4.007713e-004,
	1.113850e+000,
	6.636719e-001,
	// albedo 1, turbidity 2
	-1.263311e+001,
	-4.099112e+000,
	-5.130792e+000,
	5.526406e+000,
	-2.122841e-002,
	1.202556e-001,
	-8.060670e-006,
	1.209196e+000,
	8.997967e-001,
	-1.361400e+001,
	-3.538236e+000,
	1.570583e-001,
	3.445259e-001,
	-5.306874e-002,
	2.322893e-001,
	1.572516e-005,
	1.152750e+000,
	9.026902e-001,
	-1.477014e+000,
	-3.664310e+000,
	-1.442116e-001,
	-4.293554e-002,
	-3.768326e-002,
	-1.388530e-001,
	-1.687893e-004,
	1.592625e+000,
	8.804841e-001,
	-2.050884e+000,
	-1.470536e+000,
	3.327590e-001,
	1.976143e-001,
	-1.930369e-001,
	2.831960e-001,
	6.940849e-004,
	1.271203e+000,
	9.790242e-001,
	-3.704793e-001,
	-5.829841e-001,
	1.168589e+000,
	-1.387973e-001,
	5.998426e-001,
	3.825096e-001,
	-2.188637e-003,
	-2.273264e-001,
	7.393514e-001,
	-9.877542e-001,
	-7.646946e-001,
	8.859003e-001,
	5.263145e-002,
	-4.849410e+000,
	1.301905e-001,
	5.464872e-003,
	5.270984e-001,
	5.001226e-001,
	// albedo 1, turbidity 3
	-1.294452e+001,
	-3.858933e+000,
	-4.362969e+000,
	4.657159e+000,
	-2.281956e-002,
	1.371565e-001,
	3.552610e-006,
	1.354369e+000,
	5.222053e-001,
	-1.425646e+001,
	-3.745266e+000,
	6.901454e-001,
	-5.345642e-002,
	-5.238708e-002,
	1.157055e-001,
	-1.961110e-005,
	1.030408e+000,
	4.036292e-001,
	-2.236186e+000,
	-3.560196e+000,
	-1.053059e-001,
	-3.002269e-001,
	-1.702750e-001,
	3.290753e-002,
	-7.253274e-005,
	1.846963e+000,
	6.828000e-001,
	-1.991088e+000,
	-2.028027e+000,
	2.747056e-001,
	5.076456e-001,
	2.056096e-001,
	1.537040e-001,
	1.010611e-003,
	8.439763e-001,
	1.286657e+000,
	-2.733597e-001,
	-1.938590e-001,
	1.108079e+000,
	-1.668080e-001,
	-8.136300e-001,
	3.962292e-001,
	-4.757393e-003,
	1.536882e-001,
	4.595467e-001,
	-9.782447e-001,
	-8.452104e-001,
	9.149995e-001,
	2.750126e-002,
	-4.996263e+000,
	1.226836e-001,
	1.533731e-002,
	3.686265e-001,
	5.004484e-001,
	// albedo 1, turbidity 4
	-1.234416e+001,
	-3.818503e+000,
	-3.804408e+000,
	4.093838e+000,
	-2.505623e-002,
	1.149315e-001,
	-7.610563e-006,
	1.361584e+000,
	8.981571e-001,
	-1.349621e+001,
	-3.551853e+000,
	1.469377e+000,
	-8.971164e-001,
	-5.623731e-002,
	1.078524e-001,
	1.491378e-003,
	1.113040e+000,
	-4.279059e-001,
	-3.391950e+000,
	-3.791028e+000,
	-6.935352e-001,
	2.998175e-001,
	-3.155309e-001,
	1.196041e-001,
	-4.708048e-003,
	2.001973e+000,
	1.840166e+000,
	-1.915114e+000,
	-1.493080e+000,
	4.567342e-001,
	-7.334296e-002,
	6.767060e-001,
	-4.562689e-003,
	1.016838e-002,
	1.003272e+000,
	5.102018e-001,
	-5.674128e-001,
	-5.568719e-001,
	9.084369e-001,
	6.684870e-001,
	-3.892720e+000,
	5.312866e-001,
	-1.768715e-002,
	3.252051e-001,
	6.541029e-001,
	-1.343751e+000,
	-9.647458e-001,
	7.945561e-001,
	5.127485e-004,
	-5.009873e+000,
	6.165389e-002,
	2.642926e-002,
	6.213595e-001,
	5.327376e-001,
	// albedo 1, turbidity 5
	-1.450562e+001,
	-4.021778e+000,
	-4.181517e+000,
	4.509518e+000,
	-2.369519e-002,
	6.955582e-002,
	1.149882e-004,
	1.329583e+000,
	5.260857e-001,
	-1.297772e+001,
	-3.655039e+000,
	2.030636e+000,
	-1.537436e+000,
	-4.915490e-002,
	1.511047e-001,
	-9.053517e-004,
	1.156980e+000,
	4.831690e-001,
	-1.991837e+000,
	-3.919397e+000,
	-8.466357e-001,
	5.319508e-001,
	-3.165811e-001,
	1.056172e-001,
	4.836036e-003,
	1.843574e+000,
	3.084513e-001,
	-2.052725e+000,
	-1.606839e+000,
	5.876624e-001,
	-7.464148e-002,
	7.525473e-001,
	1.590947e-003,
	-1.261084e-002,
	8.587516e-001,
	1.404076e+000,
	-3.737447e-001,
	-4.061843e-001,
	8.985804e-001,
	5.700187e-001,
	-5.422882e+000,
	4.334301e-001,
	1.759754e-002,
	2.613056e-001,
	2.062463e-001,
	-1.002263e+000,
	-1.006484e+000,
	9.629219e-001,
	8.528366e-002,
	-4.220831e+000,
	7.848806e-002,
	1.254937e-002,
	2.140208e-001,
	6.187813e-001,
	// albedo 1, turbidity 6
	-7.175451e+000,
	-3.313094e+000,
	-2.396914e+000,
	2.657177e+000,
	-3.936959e-002,
	1.123476e-001,
	7.315860e-005,
	1.431209e+000,
	5.107145e-001,
	-8.058121e+000,
	-3.119458e+000,
	1.729776e+000,
	-1.435370e+000,
	-1.414745e-001,
	2.338787e-001,
	-5.865288e-004,
	1.247225e+000,
	5.037743e-001,
	-4.387785e+000,
	-3.851081e+000,
	-7.774273e-001,
	1.405520e+000,
	1.743075e-001,
	-4.108912e-001,
	3.058571e-003,
	1.519803e+000,
	2.636805e-001,
	-1.807473e+000,
	-1.498491e+000,
	3.237723e-001,
	-1.626737e+000,
	-3.741656e+000,
	8.444519e-001,
	-8.297013e-003,
	1.624861e+000,
	1.753817e+000,
	-6.242455e-001,
	-1.063850e+000,
	1.166897e+000,
	2.283807e+000,
	-1.150947e+000,
	-3.242997e-001,
	1.279340e-002,
	-5.448139e-001,
	-8.653106e-002,
	-8.143405e-001,
	-5.251732e-001,
	7.822692e-001,
	-3.764280e-003,
	-5.011112e+000,
	3.985065e-001,
	3.652394e-003,
	7.140115e-001,
	7.004910e-001,
	// albedo 1, turbidity 7
	-7.579673e+000,
	-3.495594e+000,
	-2.498830e+000,
	2.771470e+000,
	-3.451351e-002,
	8.186886e-002,
	1.272079e-004,
	1.390420e+000,
	5.545117e-001,
	-8.524117e+000,
	-3.121778e+000,
	1.680395e+000,
	-1.329455e+000,
	-1.395912e-001,
	1.911589e-001,
	-1.027988e-003,
	1.259267e+000,
	3.356989e-001,
	-4.579718e+000,
	-4.086739e+000,
	-8.030175e-001,
	1.103390e+000,
	1.429699e-001,
	-2.211841e-001,
	5.620349e-003,
	1.693702e+000,
	7.084432e-001,
	-1.946704e+000,
	-1.512415e+000,
	3.559506e-001,
	-1.318829e+000,
	-3.063409e+000,
	6.250046e-001,
	-1.490672e-002,
	1.414520e+000,
	1.317647e+000,
	-7.123367e-001,
	-1.133848e+000,
	1.064800e+000,
	2.217543e+000,
	-1.247373e+000,
	-2.105594e-001,
	2.261048e-002,
	-3.648618e-001,
	1.147223e-001,
	-7.979833e-001,
	-5.546030e-001,
	7.765850e-001,
	-4.676928e-003,
	-5.014372e+000,
	3.694816e-001,
	2.373221e-003,
	6.783145e-001,
	7.862971e-001,
	// albedo 1, turbidity 8
	-1.886599e+001,
	-4.523457e+000,
	-3.559445e+000,
	3.748747e+000,
	-2.082711e-002,
	1.120505e-001,
	4.908827e-005,
	1.430333e+000,
	4.999603e-001,
	-1.985552e+001,
	-3.530040e+000,
	1.578922e+000,
	-1.170838e+000,
	-6.347814e-002,
	2.032158e-003,
	-7.291357e-004,
	1.399338e+000,
	5.515394e-001,
	5.631541e-001,
	-5.483754e+000,
	-6.832337e-001,
	6.170499e-001,
	-2.824393e-001,
	3.546810e-001,
	6.248420e-003,
	1.638520e+000,
	2.300717e-001,
	-3.083195e+000,
	-3.071409e-001,
	2.822360e-001,
	-7.871125e-001,
	2.420642e-001,
	-1.716096e-001,
	-1.936307e-002,
	1.450902e+000,
	1.590291e+000,
	2.003824e-001,
	-8.374106e-001,
	8.800366e-001,
	1.702679e+000,
	-4.785357e+000,
	3.194078e-001,
	3.028099e-002,
	6.649245e-002,
	-4.459174e-003,
	-1.738851e+000,
	-1.144728e+000,
	6.950894e-001,
	1.073870e+000,
	-4.176611e+000,
	9.901497e-002,
	2.719362e-002,
	6.579628e-001,
	6.542088e-001,
	// albedo 1, turbidity 9
	-1.842858e+001,
	-4.464894e+000,
	-4.876181e+000,
	4.999894e+000,
	-1.680473e-002,
	9.284371e-002,
	8.631599e-005,
	1.551671e+000,
	8.637202e-001,
	-1.946220e+001,
	-2.928492e+000,
	1.932796e+000,
	-2.009963e+000,
	-2.067172e-002,
	2.760643e-001,
	-1.316034e-003,
	1.910005e+000,
	-2.057018e-002,
	1.012726e+000,
	-6.397245e+000,
	-8.570688e-001,
	9.466942e-001,
	-2.428074e-001,
	4.505376e-002,
	1.159119e-002,
	1.686356e+000,
	7.885028e-001,
	-3.502022e+000,
	-9.795202e-002,
	3.286657e-001,
	-8.318684e-001,
	1.254695e-001,
	9.600123e-002,
	-3.501772e-002,
	1.161309e+000,
	1.205342e+000,
	7.024550e-001,
	-6.903001e-001,
	7.519618e-001,
	1.501909e+000,
	-4.224528e+000,
	1.253867e-001,
	5.829515e-002,
	2.671626e-001,
	3.030079e-001,
	-2.056576e+000,
	-1.583471e+000,
	7.947031e-001,
	2.224097e+000,
	-4.127138e+000,
	1.885249e-001,
	1.729132e-005,
	3.336881e-001,
	5.332061e-001,
	// albedo 1, turbidity 10
	-1.825745e+001,
	-5.122861e+000,
	-5.876715e+000,
	5.970876e+000,
	-1.788919e-002,
	1.063934e-001,
	4.770037e-004,
	1.612403e+000,
	5.156506e-001,
	-1.981828e+001,
	-3.746331e+000,
	2.729783e+000,
	-2.477317e+000,
	-2.797536e-002,
	-5.281985e-002,
	-3.739083e-003,
	1.378246e+000,
	5.904024e-001,
	1.346751e+000,
	-6.486837e+000,
	-1.082622e+000,
	1.125524e+000,
	-2.228944e-001,
	3.975587e-001,
	2.035973e-002,
	1.884664e+000,
	1.086023e-003,
	-3.996320e+000,
	-4.646476e-001,
	3.008639e-002,
	-1.193861e+000,
	4.443960e-001,
	-2.593178e-001,
	-5.378377e-002,
	1.528777e+000,
	1.734923e+000,
	4.789259e-001,
	-8.952042e-001,
	8.595191e-001,
	2.353988e+000,
	-4.885398e+000,
	4.438339e-001,
	7.931163e-002,
	-8.144393e-002,
	1.663921e-002,
	-1.772626e+000,
	-1.783205e+000,
	7.322534e-001,
	1.529827e+000,
	-2.789303e+000,
	-1.817210e-001,
	2.737502e-002,
	2.620216e-001,
	6.227585e-001,
};

double datasetRad320[] = 
{
	// albedo 0, turbidity 1
	7.512813e-003,
	2.565179e-003,
	4.253480e-002,
	-1.185924e-001,
	5.817257e-001,
	4.371426e-001,
	// albedo 0, turbidity 2
	7.414562e-003,
	2.104390e-003,
	4.424958e-002,
	-1.216955e-001,
	5.827775e-001,
	4.360785e-001,
	// albedo 0, turbidity 3
	7.404947e-003,
	1.752151e-003,
	4.513723e-002,
	-1.244245e-001,
	5.840274e-001,
	4.355152e-001,
	// albedo 0, turbidity 4
	7.357950e-003,
	1.188061e-003,
	4.674957e-002,
	-1.293810e-001,
	5.870157e-001,
	4.313968e-001,
	// albedo 0, turbidity 5
	7.205901e-003,
	9.118062e-004,
	4.812589e-002,
	-1.334022e-001,
	5.844004e-001,
	4.363489e-001,
	// albedo 0, turbidity 6
	7.191812e-003,
	9.246117e-004,
	4.806915e-002,
	-1.350718e-001,
	5.853059e-001,
	4.315313e-001,
	// albedo 0, turbidity 7
	7.021308e-003,
	2.838239e-004,
	4.998992e-002,
	-1.401900e-001,
	5.846638e-001,
	4.304544e-001,
	// albedo 0, turbidity 8
	6.900165e-003,
	-1.418081e-004,
	5.088191e-002,
	-1.440144e-001,
	5.787350e-001,
	4.317369e-001,
	// albedo 0, turbidity 9
	6.663463e-003,
	-1.045860e-003,
	5.378644e-002,
	-1.526976e-001,
	5.708638e-001,
	4.315470e-001,
	// albedo 0, turbidity 10
	6.208056e-003,
	-1.526509e-003,
	5.248712e-002,
	-1.499028e-001,
	5.350711e-001,
	4.438774e-001,
	// albedo 1, turbidity 1
	8.947091e-003,
	2.068795e-004,
	6.462783e-002,
	-1.742158e-001,
	6.841679e-001,
	7.788551e-001,
	// albedo 1, turbidity 2
	8.995830e-003,
	-4.893647e-004,
	6.503652e-002,
	-1.727869e-001,
	6.769531e-001,
	7.804054e-001,
	// albedo 1, turbidity 3
	8.932087e-003,
	-6.660637e-004,
	6.613318e-002,
	-1.772526e-001,
	6.802856e-001,
	7.693223e-001,
	// albedo 1, turbidity 4
	8.702033e-003,
	-1.193023e-003,
	6.791705e-002,
	-1.825574e-001,
	6.811457e-001,
	7.558930e-001,
	// albedo 1, turbidity 5
	8.389107e-003,
	-1.075678e-003,
	6.757016e-002,
	-1.826106e-001,
	6.721755e-001,
	7.497970e-001,
	// albedo 1, turbidity 6
	8.436987e-003,
	-1.632254e-003,
	6.863361e-002,
	-1.858794e-001,
	6.721006e-001,
	7.351320e-001,
	// albedo 1, turbidity 7
	8.209635e-003,
	-1.906874e-003,
	6.921140e-002,
	-1.888528e-001,
	6.684109e-001,
	7.182233e-001,
	// albedo 1, turbidity 8
	7.837639e-003,
	-1.716124e-003,
	6.614409e-002,
	-1.800071e-001,
	6.355591e-001,
	7.174486e-001,
	// albedo 1, turbidity 9
	7.397518e-003,
	-2.176193e-003,
	6.530836e-002,
	-1.800409e-001,
	6.143563e-001,
	6.851424e-001,
	// albedo 1, turbidity 10
	6.845741e-003,
	-2.800399e-003,
	6.173213e-002,
	-1.673516e-001,
	5.537362e-001,
	6.672731e-001,
};

double dataset360[] = 
{
	// albedo 0, turbidity 1
	-2.974290e+000,
	-1.670904e+000,
	-5.183199e+000,
	5.377376e+000,
	-2.904124e-002,
	2.486720e-001,
	8.045624e-005,
	1.889212e+000,
	5.188203e-001,
	-2.638402e+000,
	-1.651876e+000,
	-1.229939e+000,
	1.776358e+000,
	-6.372414e-002,
	3.767834e-001,
	-6.475530e-004,
	1.373589e+000,
	4.349252e-001,
	-2.449142e+000,
	-1.541788e+000,
	4.629358e-001,
	-1.149742e+000,
	-7.317185e-002,
	-2.422158e-001,
	3.667113e-003,
	3.146429e+000,
	6.725657e-001,
	-8.559357e-001,
	-5.054959e-001,
	4.334205e-001,
	4.254155e-001,
	-2.920605e-001,
	9.303230e-001,
	-1.212609e-002,
	4.498482e-001,
	2.117838e-001,
	-1.098145e+000,
	-5.123514e-001,
	7.773196e-001,
	-1.325175e-001,
	4.648396e-001,
	1.386648e-001,
	2.427679e-002,
	1.199386e+000,
	7.988611e-001,
	-1.124849e+000,
	-5.693597e-001,
	7.315125e-001,
	2.986435e-002,
	-4.536788e+000,
	6.650081e-001,
	-9.004215e-007,
	1.006380e+000,
	4.999682e-001,
	// albedo 0, turbidity 2
	-2.709497e+000,
	-1.635812e+000,
	-4.594177e+000,
	4.809336e+000,
	-3.672907e-002,
	2.383111e-001,
	3.241989e-005,
	1.885505e+000,
	6.619619e-001,
	-2.590279e+000,
	-1.525236e+000,
	-6.846073e-001,
	1.216080e+000,
	-8.022814e-002,
	3.040074e-001,
	-4.984576e-004,
	1.521429e+000,
	1.746040e-001,
	-2.988403e+000,
	-1.938687e+000,
	4.954649e-002,
	-8.992325e-001,
	-7.157111e-002,
	-4.370068e-002,
	4.336645e-003,
	2.849496e+000,
	8.892788e-001,
	-2.932084e-001,
	-1.323910e-001,
	5.535910e-001,
	7.456284e-001,
	-2.713400e-001,
	6.989175e-001,
	-1.513162e-002,
	6.926848e-001,
	5.719944e-001,
	-1.379400e+000,
	-6.876864e-001,
	7.224534e-001,
	-6.172704e-001,
	1.217500e-001,
	3.074795e-001,
	2.905167e-002,
	1.123563e+000,
	6.837510e-001,
	-1.042446e+000,
	-5.201193e-001,
	7.107656e-001,
	4.182566e-001,
	-4.956238e+000,
	5.315425e-001,
	6.232999e-003,
	1.059015e+000,
	5.116427e-001,
	// albedo 0, turbidity 3
	-2.686687e+000,
	-1.615137e+000,
	-3.811956e+000,
	4.018597e+000,
	-3.953418e-002,
	2.171778e-001,
	-7.374887e-006,
	1.875745e+000,
	8.996180e-001,
	-3.049670e+000,
	-1.775802e+000,
	2.577719e-002,
	5.331200e-001,
	-9.424429e-002,
	3.852753e-001,
	-8.678326e-005,
	1.347053e+000,
	-1.078327e-001,
	-2.414334e+000,
	-1.637863e+000,
	-3.948523e-001,
	-4.867989e-001,
	-1.545516e-001,
	-2.045592e-001,
	2.308206e-003,
	3.257409e+000,
	1.029606e+000,
	-6.821703e-001,
	-3.665215e-001,
	7.496076e-001,
	5.391760e-001,
	-2.903450e-001,
	8.498544e-001,
	-1.388990e-002,
	2.126622e-001,
	6.857005e-001,
	-1.227285e+000,
	-5.958479e-001,
	5.828611e-001,
	-4.050489e-001,
	-2.935835e-001,
	1.410603e-001,
	4.352812e-002,
	1.406076e+000,
	4.955059e-001,
	-1.080553e+000,
	-5.308084e-001,
	6.980027e-001,
	2.193524e-001,
	-5.007206e+000,
	5.895807e-001,
	1.122391e-002,
	1.052433e+000,
	6.643198e-001,
	// albedo 0, turbidity 4
	-2.983088e+000,
	-1.746025e+000,
	-4.564198e+000,
	4.776145e+000,
	-3.208607e-002,
	2.008358e-001,
	-6.578048e-006,
	1.829880e+000,
	9.001069e-001,
	-2.858023e+000,
	-1.624623e+000,
	1.859497e+000,
	-1.348577e+000,
	-7.427284e-002,
	2.943068e-001,
	-1.961205e-004,
	1.502334e+000,
	-3.183648e-001,
	-2.858102e+000,
	-2.072804e+000,
	-1.205584e+000,
	5.674135e-001,
	-3.934144e-001,
	-3.736288e-002,
	4.780332e-003,
	2.831298e+000,
	1.553942e+000,
	-3.305766e-001,
	-8.277591e-003,
	8.561917e-001,
	-2.239172e-001,
	5.896697e-001,
	6.229823e-001,
	-2.242577e-002,
	7.216263e-001,
	4.295956e-001,
	-1.322728e+000,
	-7.101315e-001,
	5.645563e-001,
	9.897384e-001,
	-6.756374e+000,
	2.491515e-001,
	5.308124e-002,
	1.166258e+000,
	5.472501e-001,
	-1.117086e+000,
	-5.760006e-001,
	6.388217e-001,
	1.659290e-001,
	-4.687099e+000,
	4.544540e-001,
	2.672063e-002,
	1.067777e+000,
	6.419825e-001,
	// albedo 0, turbidity 5
	-2.943340e+000,
	-1.779161e+000,
	-3.715839e+000,
	3.949049e+000,
	-4.499824e-002,
	2.234466e-001,
	-8.091518e-006,
	1.825217e+000,
	9.000118e-001,
	-3.717358e+000,
	-1.850324e+000,
	2.277659e+000,
	-2.027790e+000,
	-1.240730e-001,
	3.029522e-001,
	-2.176255e-004,
	1.585933e+000,
	-2.794001e-001,
	-2.439542e+000,
	-2.277701e+000,
	-1.702329e+000,
	2.025885e+000,
	-1.142291e-001,
	-2.011641e-001,
	5.563891e-003,
	2.424957e+000,
	1.399542e+000,
	-1.562453e-001,
	5.099893e-001,
	1.026847e+000,
	-2.516874e+000,
	-2.212969e+000,
	9.252660e-001,
	-2.696795e-002,
	1.443711e+000,
	7.450372e-001,
	-1.579698e+000,
	-1.110703e+000,
	4.743061e-001,
	4.160187e+000,
	-4.597085e+000,
	-2.112156e-001,
	6.791770e-002,
	6.131169e-001,
	2.291635e-001,
	-9.959610e-001,
	-4.119588e-001,
	5.707529e-001,
	-3.505536e-003,
	-4.253949e+000,
	7.498003e-001,
	8.246945e-003,
	1.397857e+000,
	8.021253e-001,
	// albedo 0, turbidity 6
	-2.304734e+000,
	-1.483605e+000,
	-1.531059e+000,
	1.707306e+000,
	-1.150367e-001,
	2.153063e-001,
	-3.351533e-006,
	2.021261e+000,
	5.742842e-001,
	-3.130477e+000,
	-1.966839e+000,
	6.058600e-001,
	-9.209976e-001,
	-1.932901e-001,
	3.242645e-001,
	3.361262e-002,
	1.529938e+000,
	2.851152e-001,
	-1.110129e+000,
	-1.306323e+000,
	-3.235833e-001,
	2.998748e+000,
	-1.535927e-002,
	-4.001906e-001,
	-9.430492e-002,
	2.211086e+000,
	8.632200e-001,
	-1.174540e+000,
	7.550161e-002,
	-1.849588e-001,
	-6.281432e+000,
	-6.186665e+000,
	1.173048e+000,
	1.481656e-001,
	2.668578e+000,
	6.145923e-001,
	-1.104583e+000,
	-8.430389e-001,
	8.668416e-001,
	9.153752e+000,
	-7.289540e-001,
	-4.346537e-001,
	-9.065784e-002,
	2.866983e-001,
	6.920973e-001,
	-1.105893e+000,
	-4.500399e-001,
	4.286451e-001,
	1.207864e+000,
	-5.018291e+000,
	6.988292e-001,
	3.891745e-002,
	1.602324e+000,
	6.269169e-001,
	// albedo 0, turbidity 7
	-3.709341e+000,
	-2.038242e+000,
	-3.127214e+000,
	3.287030e+000,
	-4.565671e-002,
	2.427627e-001,
	-7.503980e-006,
	1.817881e+000,
	9.000389e-001,
	-3.393374e+000,
	-1.710497e+000,
	1.661275e+000,
	-1.388896e+000,
	-1.012293e-001,
	1.676172e-001,
	-5.719846e-004,
	1.694199e+000,
	-3.140071e-001,
	-2.812820e+000,
	-2.678401e+000,
	-1.170428e+000,
	1.560988e+000,
	-4.488218e-001,
	1.088693e-001,
	1.391966e-002,
	2.144426e+000,
	1.525731e+000,
	2.547360e-001,
	8.840167e-001,
	5.469168e-001,
	-2.615530e+000,
	-1.048663e+000,
	4.823171e-001,
	-5.958515e-002,
	1.842479e+000,
	5.322138e-001,
	-1.612173e+000,
	-1.055541e+000,
	4.733463e-001,
	5.083504e+000,
	-5.558403e+000,
	8.029584e-002,
	1.294180e-001,
	7.807964e-001,
	3.949822e-001,
	-1.098367e+000,
	-5.550631e-001,
	4.221569e-001,
	-1.661587e-003,
	-4.970027e+000,
	3.479325e-001,
	4.503648e-002,
	1.369224e+000,
	6.753984e-001,
	// albedo 0, turbidity 8
	-4.292777e+000,
	-2.231300e+000,
	-4.359252e+000,
	4.562131e+000,
	-3.759725e-002,
	2.170783e-001,
	-6.945269e-006,
	1.791630e+000,
	8.996451e-001,
	-4.016595e+000,
	-1.761175e+000,
	2.616213e+000,
	-2.658657e+000,
	-8.209207e-002,
	2.736152e-001,
	-6.864170e-004,
	1.820262e+000,
	-2.712707e-001,
	-2.942646e+000,
	-3.350329e+000,
	-1.645817e+000,
	2.957424e+000,
	-1.073783e-001,
	-1.920050e-001,
	1.665992e-002,
	1.723144e+000,
	1.394962e+000,
	9.793627e-001,
	1.743715e+000,
	5.396545e-001,
	-4.618273e+000,
	-2.186669e+000,
	1.012973e+000,
	-7.213786e-002,
	2.388103e+000,
	6.712519e-001,
	-2.085434e+000,
	-1.445755e+000,
	3.384806e-001,
	7.702938e+000,
	-3.897179e+000,
	-5.947697e-001,
	1.614194e-001,
	7.854754e-001,
	3.291034e-001,
	-9.660466e-001,
	-5.247410e-001,
	4.199048e-001,
	-3.304707e-003,
	-5.014144e+000,
	6.733599e-001,
	2.345161e-002,
	1.225739e+000,
	7.256834e-001,
	// albedo 0, turbidity 9
	-3.950771e+000,
	-2.192673e+000,
	-7.263653e+000,
	7.343312e+000,
	-1.840332e-002,
	1.893809e-001,
	-3.583629e-006,
	1.901172e+000,
	5.902387e-001,
	-6.384690e+000,
	-2.515788e+000,
	3.874778e+000,
	-3.776079e+000,
	-3.484710e-002,
	3.311078e-001,
	8.248395e-003,
	1.612712e+000,
	3.123684e-001,
	-6.207616e-001,
	-2.681061e+000,
	-2.005212e+000,
	2.445498e+000,
	-1.935675e-001,
	-1.988856e-001,
	-1.553754e-002,
	2.210740e+000,
	6.507040e-001,
	-1.241493e+000,
	5.908170e-001,
	3.899777e-001,
	-2.344038e+000,
	-1.820327e-001,
	7.889592e-001,
	-1.468064e-002,
	1.586758e+000,
	1.007885e+000,
	-4.395130e-001,
	-3.700611e-001,
	2.452754e-001,
	3.602006e+000,
	-4.692896e+000,
	-8.620746e-002,
	1.418548e-001,
	1.521301e+000,
	3.989756e-001,
	-1.794977e+000,
	-1.190586e+000,
	3.928989e-001,
	1.946953e+000,
	-1.874118e+000,
	-3.292602e-002,
	2.983309e-002,
	6.737092e-001,
	7.322706e-001,
	// albedo 0, turbidity 10
	-8.896186e+000,
	-3.278330e+000,
	-7.998349e+000,
	8.023312e+000,
	-1.357555e-002,
	1.947910e-001,
	-5.390226e-006,
	1.798414e+000,
	7.881395e-001,
	-8.040403e+000,
	-2.528514e+000,
	3.774303e+000,
	-3.590457e+000,
	-3.551313e-002,
	3.650761e-001,
	-4.401382e-004,
	1.701545e+000,
	-6.992899e-003,
	-4.150010e-001,
	-3.539507e+000,
	-1.527733e+000,
	1.415242e+000,
	-1.831476e-001,
	-3.009746e-001,
	1.211955e-002,
	2.365976e+000,
	9.928240e-001,
	-2.090923e+000,
	1.673638e-001,
	-2.183495e-001,
	-8.374584e-001,
	2.774184e-002,
	7.912769e-001,
	-6.650609e-002,
	1.154446e+000,
	7.863979e-001,
	5.115239e-001,
	2.415831e-001,
	4.022318e-001,
	2.292950e+000,
	-4.061496e+000,
	7.453182e-002,
	1.902451e-001,
	1.587339e+000,
	5.207620e-001,
	-2.334879e+000,
	-1.642495e+000,
	2.384458e-001,
	3.068363e+000,
	-1.699588e+000,
	-3.936924e-001,
	3.028660e-002,
	4.715374e-001,
	7.091893e-001,
	// albedo 1, turbidity 1
	-2.375941e+000,
	-1.508643e+000,
	-5.070151e+000,
	5.509378e+000,
	-2.915769e-002,
	2.122471e-001,
	8.584007e-005,
	1.517285e+000,
	5.163253e-001,
	-2.605398e+000,
	-1.589160e+000,
	-1.137560e+000,
	1.827729e+000,
	-4.939637e-002,
	3.243952e-001,
	-6.464612e-004,
	1.008816e+000,
	4.568463e-001,
	-2.176260e+000,
	-1.601522e+000,
	7.060324e-001,
	-1.060717e+000,
	-5.144614e-002,
	-1.938031e-001,
	3.449257e-003,
	2.641594e+000,
	5.976852e-001,
	-7.365744e-001,
	-3.720296e-001,
	7.315328e-001,
	3.156067e-001,
	-2.739385e-001,
	8.252942e-001,
	-1.055013e-002,
	7.327610e-002,
	3.218251e-001,
	-1.017537e+000,
	-4.631811e-001,
	1.093174e+000,
	-7.215941e-002,
	5.408457e-001,
	-1.848322e-002,
	1.942990e-002,
	6.882763e-001,
	7.268524e-001,
	-1.025215e+000,
	-3.712574e-001,
	9.661278e-001,
	7.791398e-003,
	-4.508617e+000,
	4.371074e-001,
	-1.241898e-006,
	1.152655e+000,
	5.008240e-001,
	// albedo 1, turbidity 2
	-2.621793e+000,
	-1.611544e+000,
	-4.494730e+000,
	4.902741e+000,
	-2.935751e-002,
	1.930048e-001,
	1.821579e-005,
	1.522018e+000,
	6.563013e-001,
	-2.473330e+000,
	-1.495083e+000,
	-5.536781e-001,
	1.305457e+000,
	-7.261347e-002,
	2.967738e-001,
	-2.858526e-004,
	1.132650e+000,
	1.737068e-001,
	-2.843519e+000,
	-1.913751e+000,
	2.006296e-001,
	-8.580922e-001,
	-5.273753e-002,
	-7.800250e-002,
	2.395781e-003,
	2.505017e+000,
	9.023934e-001,
	-1.805184e-001,
	-3.670063e-002,
	7.583717e-001,
	7.594739e-001,
	-2.092951e-001,
	6.278666e-001,
	-8.086828e-003,
	4.136002e-001,
	6.026937e-001,
	-1.274753e+000,
	-5.831501e-001,
	9.711756e-001,
	-6.209175e-001,
	1.488633e-001,
	2.117108e-001,
	1.531499e-002,
	9.306008e-001,
	7.201852e-001,
	-9.224434e-001,
	-3.344822e-001,
	9.964647e-001,
	3.991735e-001,
	-4.951439e+000,
	4.332347e-001,
	-1.082832e-005,
	9.570977e-001,
	5.221054e-001,
	// albedo 1, turbidity 3
	-2.648100e+000,
	-1.587720e+000,
	-3.738681e+000,
	4.084015e+000,
	-3.301163e-002,
	1.736140e-001,
	-5.598265e-006,
	1.628176e+000,
	8.967917e-001,
	-3.004556e+000,
	-1.702983e+000,
	1.060112e-001,
	5.816666e-001,
	-8.140777e-002,
	3.584557e-001,
	-7.793874e-005,
	1.090228e+000,
	-1.079451e-001,
	-2.337937e+000,
	-1.584523e+000,
	-2.912486e-001,
	-4.467895e-001,
	-9.195281e-002,
	-2.355753e-001,
	1.887118e-003,
	3.053238e+000,
	1.043382e+000,
	-5.985994e-001,
	-2.846782e-001,
	8.903642e-001,
	5.578845e-001,
	-2.510042e-001,
	8.033778e-001,
	-9.920460e-003,
	7.388584e-002,
	7.097127e-001,
	-1.155357e+000,
	-4.638306e-001,
	8.041892e-001,
	-4.051351e-001,
	-2.819435e-001,
	8.505708e-002,
	2.749222e-002,
	1.334820e+000,
	5.216620e-001,
	-1.010658e+000,
	-3.816787e-001,
	9.644918e-001,
	2.144477e-001,
	-5.005667e+000,
	5.475125e-001,
	3.758162e-005,
	1.033427e+000,
	6.866266e-001,
	// albedo 1, turbidity 4
	-2.686681e+000,
	-1.694114e+000,
	-4.346908e+000,
	4.745876e+000,
	-2.879846e-002,
	2.237339e-001,
	-6.438656e-006,
	1.456353e+000,
	9.000340e-001,
	-2.684912e+000,
	-1.616888e+000,
	2.447798e+000,
	-1.626883e+000,
	-7.346183e-002,
	2.641722e-001,
	-1.001518e-004,
	1.045501e+000,
	-2.314856e-001,
	-2.587652e+000,
	-1.999748e+000,
	-1.325810e+000,
	7.561102e-001,
	-4.182131e-001,
	-4.285017e-002,
	2.719759e-003,
	2.420598e+000,
	1.281981e+000,
	-2.679506e-001,
	5.139740e-002,
	1.276587e+000,
	-2.286956e-001,
	7.388924e-001,
	5.606395e-001,
	-1.472508e-002,
	5.105614e-001,
	7.670396e-001,
	-1.267160e+000,
	-7.441021e-001,
	9.154665e-001,
	8.190436e-001,
	-6.805266e+000,
	1.013064e-001,
	4.140297e-002,
	3.378301e-001,
	3.128860e-001,
	-9.570978e-001,
	-3.478847e-001,
	9.709923e-001,
	-3.444499e-003,
	-4.677921e+000,
	3.551546e-001,
	6.241534e-003,
	1.052060e+000,
	7.543152e-001,
	// albedo 1, turbidity 5
	-3.093830e+000,
	-1.859478e+000,
	-4.003711e+000,
	4.391665e+000,
	-3.051581e-002,
	2.180265e-001,
	-7.401285e-006,
	1.448366e+000,
	9.000549e-001,
	-3.121106e+000,
	-1.664385e+000,
	2.868256e+000,
	-2.280292e+000,
	-8.456847e-002,
	2.227469e-001,
	-1.681252e-004,
	1.176332e+000,
	-2.605895e-001,
	-2.166025e+000,
	-2.172663e+000,
	-1.705862e+000,
	1.960864e+000,
	-2.185020e-001,
	1.891067e-002,
	4.423413e-003,
	2.071931e+000,
	1.297661e+000,
	-5.263078e-001,
	2.296403e-001,
	1.342025e+000,
	-2.034590e+000,
	-1.024013e+000,
	4.873264e-001,
	-1.982506e-002,
	9.818474e-001,
	1.040041e+000,
	-1.138361e+000,
	-8.186096e-001,
	8.845700e-001,
	3.291911e+000,
	-5.915866e+000,
	1.125846e-001,
	4.477952e-002,
	9.195132e-002,
	-1.138939e-002,
	-1.013651e+000,
	-3.811416e-001,
	9.420266e-001,
	-3.599378e-003,
	-4.895655e+000,
	2.864445e-001,
	1.940262e-002,
	1.026648e+000,
	7.421204e-001,
	// albedo 1, turbidity 6
	-2.379373e+000,
	-1.540348e+000,
	-1.318467e+000,
	1.724703e+000,
	-1.017147e-001,
	1.811106e-001,
	-3.047951e-006,
	1.598808e+000,
	5.796580e-001,
	-3.200327e+000,
	-2.016985e+000,
	9.935187e-001,
	-9.970906e-001,
	-2.159523e-001,
	3.183812e-001,
	1.575987e-002,
	1.180131e+000,
	2.839510e-001,
	-1.107956e+000,
	-1.330969e+000,
	-1.627216e-001,
	2.985435e+000,
	-2.198633e-002,
	-4.401148e-001,
	-5.433064e-002,
	1.701087e+000,
	8.289746e-001,
	-9.423359e-001,
	4.619106e-002,
	3.116348e-002,
	-6.353122e+000,
	-6.192769e+000,
	1.175886e+000,
	1.020452e-001,
	2.180417e+000,
	7.076018e-001,
	-1.037343e+000,
	-5.711080e-001,
	1.282899e+000,
	8.808032e+000,
	-8.741903e-001,
	-6.097972e-001,
	-5.996612e-002,
	1.533313e-001,
	5.842877e-001,
	-1.002208e+000,
	-3.271512e-001,
	7.288675e-001,
	7.950560e-001,
	-5.029931e+000,
	4.493639e-001,
	2.389923e-002,
	1.568465e+000,
	5.653910e-001,
	// albedo 1, turbidity 7
	-3.584221e+000,
	-2.140498e+000,
	-5.324613e+000,
	5.753381e+000,
	-2.662581e-002,
	2.099272e-001,
	-6.879519e-006,
	1.362229e+000,
	9.000467e-001,
	-3.579609e+000,
	-1.804420e+000,
	3.448490e+000,
	-2.929179e+000,
	-6.009529e-002,
	2.821561e-001,
	-6.203809e-004,
	1.312035e+000,
	-3.013934e-001,
	-2.053811e+000,
	-2.420850e+000,
	-1.795999e+000,
	1.835004e+000,
	-3.451800e-001,
	-1.042135e-001,
	1.511574e-002,
	1.751304e+000,
	1.491704e+000,
	-2.602659e-001,
	5.963320e-001,
	1.059632e+000,
	-1.214076e+000,
	6.424455e-001,
	6.890202e-001,
	-6.544341e-002,
	1.457883e+000,
	5.321707e-001,
	-1.266632e+000,
	-8.504227e-001,
	8.680693e-001,
	1.899473e+000,
	-8.680238e+000,
	-1.798563e-001,
	1.477665e-001,
	2.430031e-001,
	4.229871e-001,
	-1.021321e+000,
	-5.129049e-001,
	9.006232e-001,
	1.534018e+000,
	-3.672948e+000,
	2.301115e-001,
	5.151145e-003,
	7.460819e-001,
	5.418252e-001,
	// albedo 1, turbidity 8
	-4.095186e+000,
	-2.274183e+000,
	-4.115160e+000,
	4.514741e+000,
	-3.131440e-002,
	1.475658e-001,
	-5.329133e-006,
	1.411833e+000,
	8.893477e-001,
	-3.691554e+000,
	-1.654418e+000,
	3.158573e+000,
	-2.961366e+000,
	-7.834161e-002,
	3.035141e-001,
	-4.241191e-004,
	1.485200e+000,
	-1.689443e-001,
	-2.697067e+000,
	-3.473351e+000,
	-1.707297e+000,
	3.138823e+000,
	-8.323430e-002,
	-1.605972e-001,
	1.025052e-002,
	1.132282e+000,
	1.093318e+000,
	7.049827e-001,
	1.769870e+000,
	8.659868e-001,
	-4.445404e+000,
	-2.256134e+000,
	7.768538e-001,
	-4.741793e-002,
	2.212406e+000,
	1.109562e+000,
	-1.771411e+000,
	-1.358270e+000,
	7.604506e-001,
	7.191590e+000,
	-4.358366e+000,
	-3.375251e-001,
	1.136852e-001,
	1.844576e-001,
	-1.208189e-003,
	-9.623648e-001,
	-5.518470e-001,
	9.623684e-001,
	-5.697517e-003,
	-5.015884e+000,
	2.811964e-001,
	2.100168e-002,
	4.434131e-001,
	7.212648e-001,
	// albedo 1, turbidity 9
	-5.131552e+000,
	-2.558716e+000,
	-8.066753e+000,
	8.403192e+000,
	-1.450692e-002,
	1.494495e-001,
	-2.898774e-006,
	1.427512e+000,
	5.020826e-001,
	-6.192910e+000,
	-2.261479e+000,
	5.059205e+000,
	-4.892079e+000,
	-2.703716e-002,
	3.381259e-001,
	2.231257e-002,
	1.490697e+000,
	5.441761e-001,
	-6.741018e-001,
	-3.356237e+000,
	-2.207329e+000,
	3.300094e+000,
	-1.801120e-001,
	-2.560242e-001,
	-6.216731e-002,
	1.180699e+000,
	2.241782e-001,
	-8.312435e-001,
	1.325391e+000,
	5.324159e-001,
	-2.912438e+000,
	-8.384977e-002,
	7.600872e-001,
	7.749519e-002,
	2.129188e+000,
	1.328287e+000,
	-7.455272e-001,
	-8.504579e-001,
	9.021474e-001,
	3.426594e+000,
	-4.607412e+000,
	-1.706127e-001,
	4.792024e-002,
	2.354077e-001,
	2.718195e-001,
	-1.448374e+000,
	-9.739004e-001,
	8.801628e-001,
	1.705262e+000,
	-2.420298e+000,
	-1.077392e-002,
	2.691713e-002,
	1.854876e-001,
	7.097466e-001,
	// albedo 1, turbidity 10
	-8.672396e+000,
	-3.339107e+000,
	-7.666257e+000,
	7.916291e+000,
	-1.396976e-002,
	1.676538e-001,
	-5.816416e-006,
	1.448247e+000,
	8.178892e-001,
	-7.852799e+000,
	-2.606120e+000,
	4.231840e+000,
	-3.774406e+000,
	-3.540722e-002,
	2.178494e-001,
	6.198617e-005,
	1.295236e+000,
	1.130678e-001,
	-1.374103e-001,
	-3.570476e+000,
	-1.588768e+000,
	1.538806e+000,
	-1.923629e-001,
	-1.793545e-002,
	3.373950e-003,
	2.008581e+000,
	6.041668e-001,
	-2.211224e+000,
	1.190704e-001,
	6.700025e-002,
	-8.972445e-001,
	2.133056e-001,
	4.471730e-001,
	-3.148150e-002,
	9.759721e-001,
	1.166537e+000,
	5.932825e-001,
	2.482606e-001,
	9.239617e-001,
	2.382787e+000,
	-4.611846e+000,
	1.608983e-001,
	1.385590e-001,
	7.641781e-001,
	3.076032e-001,
	-2.098394e+000,
	-1.561705e+000,
	7.602298e-001,
	1.783879e+000,
	-1.486238e+000,
	-4.025919e-001,
	2.965074e-002,
	-8.717180e-002,
	7.279518e-001,
};

double datasetRad360[] = 
{
	// albedo 0, turbidity 1
	2.018734e-002,
	2.878447e-002,
	2.400602e-003,
	2.195955e-002,
	1.081208e+000,
	6.713020e-001,
	// albedo 0, turbidity 2
	2.002136e-002,
	2.847494e-002,
	3.587591e-003,
	1.419700e-002,
	1.094719e+000,
	6.680584e-001,
	// albedo 0, turbidity 3
	2.011594e-002,
	2.839101e-002,
	3.428003e-003,
	9.071270e-003,
	1.101399e+000,
	6.741060e-001,
	// albedo 0, turbidity 4
	1.959942e-002,
	2.653676e-002,
	1.129384e-002,
	-1.580946e-002,
	1.127469e+000,
	6.780204e-001,
	// albedo 0, turbidity 5
	1.945450e-002,
	2.520872e-002,
	1.800661e-002,
	-4.294016e-002,
	1.162101e+000,
	6.730305e-001,
	// albedo 0, turbidity 6
	1.903655e-002,
	2.359634e-002,
	2.573237e-002,
	-6.716183e-002,
	1.191096e+000,
	6.637348e-001,
	// albedo 0, turbidity 7
	1.900294e-002,
	2.235101e-002,
	2.971978e-002,
	-8.191387e-002,
	1.197978e+000,
	6.798375e-001,
	// albedo 0, turbidity 8
	1.858572e-002,
	1.959071e-002,
	4.133418e-002,
	-1.226605e-001,
	1.235477e+000,
	6.843139e-001,
	// albedo 0, turbidity 9
	1.775300e-002,
	1.478736e-002,
	6.156524e-002,
	-1.871793e-001,
	1.285714e+000,
	6.918133e-001,
	// albedo 0, turbidity 10
	1.649168e-002,
	7.620909e-003,
	8.938806e-002,
	-2.710168e-001,
	1.325702e+000,
	7.116526e-001,
	// albedo 1, turbidity 1
	2.477596e-002,
	1.721452e-002,
	9.168552e-002,
	-2.257278e-001,
	1.577194e+000,
	1.309986e+000,
	// albedo 1, turbidity 2
	2.466371e-002,
	1.743042e-002,
	9.040406e-002,
	-2.274583e-001,
	1.578315e+000,
	1.306446e+000,
	// albedo 1, turbidity 3
	2.459685e-002,
	1.660564e-002,
	9.153715e-002,
	-2.315701e-001,
	1.571815e+000,
	1.309528e+000,
	// albedo 1, turbidity 4
	2.398256e-002,
	1.512880e-002,
	9.624211e-002,
	-2.499972e-001,
	1.588498e+000,
	1.289531e+000,
	// albedo 1, turbidity 5
	2.362570e-002,
	1.397231e-002,
	1.012384e-001,
	-2.701754e-001,
	1.597686e+000,
	1.277024e+000,
	// albedo 1, turbidity 6
	2.311217e-002,
	1.333246e-002,
	1.016992e-001,
	-2.741844e-001,
	1.590760e+000,
	1.271949e+000,
	// albedo 1, turbidity 7
	2.286898e-002,
	1.138458e-002,
	1.081702e-001,
	-2.975024e-001,
	1.604279e+000,
	1.243052e+000,
	// albedo 1, turbidity 8
	2.167905e-002,
	8.977041e-003,
	1.158610e-001,
	-3.247192e-001,
	1.602017e+000,
	1.222336e+000,
	// albedo 1, turbidity 9
	2.068610e-002,
	5.054490e-003,
	1.264696e-001,
	-3.615436e-001,
	1.593307e+000,
	1.183658e+000,
	// albedo 1, turbidity 10
	1.880968e-002,
	1.052745e-003,
	1.346693e-001,
	-3.906154e-001,
	1.528992e+000,
	1.155257e+000,
};

double dataset400[] = 
{
	// albedo 0, turbidity 1
	-1.869600e+000,
	-9.575785e-001,
	-6.993871e+000,
	7.306207e+000,
	-3.240320e-002,
	3.834949e-001,
	4.369976e-005,
	2.254773e+000,
	5.025988e-001,
	-1.746138e+000,
	-1.001117e+000,
	-1.758295e+000,
	2.492931e+000,
	-6.202861e-002,
	4.442043e-001,
	-3.779550e-004,
	1.411622e+000,
	4.890101e-001,
	-1.536453e+000,
	-5.330479e-001,
	1.126830e+000,
	-2.452367e+000,
	-6.694842e-002,
	-2.983825e-002,
	2.320196e-003,
	5.488905e+000,
	5.403856e-001,
	-1.069780e+000,
	-5.815078e-001,
	8.612956e-001,
	1.301347e+000,
	-4.089489e-001,
	1.269432e+000,
	-9.018004e-003,
	-2.283572e+000,
	3.760374e-001,
	-1.060384e+000,
	-2.207518e-001,
	6.362691e-001,
	-5.757237e-001,
	4.275177e-001,
	8.443714e-002,
	2.082596e-002,
	3.125040e+000,
	7.891611e-001,
	-1.077246e+000,
	-2.993040e-001,
	8.167430e-001,
	2.203982e-001,
	-3.984213e+000,
	1.123699e+000,
	1.313138e-002,
	1.750491e+000,
	4.999653e-001,
	// albedo 0, turbidity 2
	-1.752499e+000,
	-9.053927e-001,
	-1.080943e+001,
	1.110516e+001,
	-2.092090e-002,
	3.348109e-001,
	-8.432141e-006,
	2.326824e+000,
	9.000500e-001,
	-1.888565e+000,
	-1.067725e+000,
	1.491851e+000,
	-7.934014e-001,
	-4.853718e-002,
	5.346693e-001,
	9.170370e-005,
	1.397595e+000,
	-3.635730e-001,
	-1.471013e+000,
	-5.497976e-001,
	-4.310423e-001,
	-8.787275e-001,
	-9.206447e-002,
	-1.490862e-001,
	-4.078054e-005,
	5.442983e+000,
	1.757010e+000,
	-1.061905e+000,
	-5.429222e-001,
	1.412232e+000,
	8.460977e-001,
	-2.973654e-001,
	1.357299e+000,
	-5.347332e-003,
	-2.444304e+000,
	-3.363016e-002,
	-1.071200e+000,
	-2.263246e-001,
	3.639469e-001,
	-6.109244e-001,
	-2.484665e-001,
	-7.097027e-002,
	4.735641e-002,
	3.445733e+000,
	8.486491e-001,
	-1.081645e+000,
	-3.128264e-001,
	8.436471e-001,
	3.884148e-001,
	-5.004662e+000,
	1.137000e+000,
	1.500838e-002,
	1.585647e+000,
	5.832608e-001,
	// albedo 0, turbidity 3
	-1.774187e+000,
	-9.327599e-001,
	-9.130103e+000,
	9.413272e+000,
	-2.448089e-002,
	3.487996e-001,
	-3.033497e-006,
	2.291071e+000,
	6.408360e-001,
	-1.849342e+000,
	-1.038735e+000,
	2.863013e+000,
	-2.260302e+000,
	-5.040252e-002,
	4.583723e-001,
	1.008690e-002,
	1.502617e+000,
	7.223351e-002,
	-1.624679e+000,
	-7.257060e-001,
	-1.493033e+000,
	5.658415e-001,
	-2.079847e-001,
	-4.651180e-002,
	-3.701743e-002,
	4.858534e+000,
	1.342775e+000,
	-8.692395e-001,
	-3.025565e-001,
	1.630221e+000,
	-4.624355e-002,
	8.408669e-002,
	1.091981e+000,
	6.506253e-002,
	-1.403006e+000,
	2.076066e-001,
	-1.169258e+000,
	-3.711802e-001,
	3.440155e-001,
	-1.044556e-001,
	-3.304858e+000,
	1.185883e-001,
	1.489352e-002,
	2.642598e+000,
	8.151882e-001,
	-1.058391e+000,
	-2.657785e-001,
	6.984363e-001,
	9.737578e-002,
	-1.903943e+000,
	8.963329e-001,
	6.480860e-002,
	2.034024e+000,
	5.870424e-001,
	// albedo 0, turbidity 4
	-1.898858e+000,
	-1.031814e+000,
	-9.726056e+000,
	1.000989e+001,
	-2.125268e-002,
	3.569897e-001,
	-2.706653e-006,
	2.147646e+000,
	5.982401e-001,
	-2.136007e+000,
	-1.206456e+000,
	3.801172e+000,
	-3.254852e+000,
	-4.516490e-002,
	4.001123e-001,
	2.151890e-002,
	1.481457e+000,
	1.444904e-001,
	-1.355343e+000,
	-6.736369e-001,
	-2.052620e+000,
	1.298239e+000,
	-1.986869e-001,
	6.321488e-002,
	-6.792635e-002,
	4.482593e+000,
	1.322565e+000,
	-9.063816e-001,
	-1.873797e-001,
	1.559544e+000,
	-2.631298e-001,
	5.988684e-002,
	9.375378e-001,
	9.681349e-002,
	-6.480890e-001,
	2.362949e-001,
	-1.170470e+000,
	-3.968082e-001,
	2.266604e-001,
	-2.018118e-001,
	-3.768512e+000,
	9.706445e-002,
	6.046660e-002,
	2.723200e+000,
	7.968878e-001,
	-1.085813e+000,
	-3.519543e-001,
	7.537557e-001,
	3.003522e-001,
	-1.811803e+000,
	7.945754e-001,
	5.293207e-002,
	1.335214e+000,
	6.385980e-001,
	// albedo 0, turbidity 5
	-1.743240e+000,
	-9.391727e-001,
	-8.905876e+000,
	9.139326e+000,
	-2.333803e-002,
	3.093783e-001,
	-2.051734e-006,
	2.320564e+000,
	5.474845e-001,
	-2.624196e+000,
	-1.516703e+000,
	5.053093e+000,
	-4.599198e+000,
	-4.248730e-002,
	4.820250e-001,
	1.829762e-002,
	1.216991e+000,
	2.739806e-001,
	-1.040612e+000,
	-6.103044e-001,
	-3.190021e+000,
	3.216574e+000,
	-3.285978e-001,
	-1.982489e-001,
	-5.367025e-002,
	3.984414e+000,
	1.158312e+000,
	-9.537244e-001,
	-6.895800e-003,
	1.788307e+000,
	-2.659655e+000,
	6.473584e-001,
	1.333544e+000,
	5.529579e-002,
	8.049825e-001,
	4.930209e-001,
	-1.163791e+000,
	-5.095388e-001,
	1.215079e-001,
	3.427998e+000,
	-9.243257e+000,
	-5.059496e-001,
	1.412681e-001,
	1.829389e+000,
	5.544610e-001,
	-1.118058e+000,
	-3.706501e-001,
	6.885180e-001,
	-1.596776e-003,
	-3.279613e+000,
	1.068229e+000,
	3.010797e-002,
	1.479756e+000,
	7.483765e-001,
	// albedo 0, turbidity 6
	-1.811701e+000,
	-1.002650e+000,
	-9.194183e+000,
	9.469966e+000,
	-2.224886e-002,
	3.237441e-001,
	-2.632967e-006,
	2.168879e+000,
	5.952956e-001,
	-2.746180e+000,
	-1.592055e+000,
	4.225172e+000,
	-3.929912e+000,
	-3.866297e-002,
	3.982440e-001,
	3.812089e-002,
	1.390284e+000,
	1.922369e-001,
	-9.558770e-001,
	-6.401790e-001,
	-2.117905e+000,
	2.293799e+000,
	-2.226591e-001,
	6.151477e-002,
	-1.223358e-001,
	3.475975e+000,
	1.124575e+000,
	-9.065351e-001,
	1.443765e-001,
	7.871576e-001,
	-1.631026e+000,
	1.537369e-001,
	8.353048e-001,
	1.849704e-001,
	1.650615e+000,
	4.473559e-001,
	-1.180081e+000,
	-5.441674e-001,
	3.963103e-001,
	1.375519e+000,
	-4.882926e+000,
	-9.391794e-004,
	6.455569e-002,
	1.774670e+000,
	6.989373e-001,
	-1.128755e+000,
	-3.892532e-001,
	5.327884e-001,
	1.825253e+000,
	-2.335719e+000,
	5.863162e-001,
	5.535626e-002,
	1.452293e+000,
	6.920090e-001,
	// albedo 0, turbidity 7
	-2.042064e+000,
	-1.144943e+000,
	-5.152625e+000,
	5.384535e+000,
	-3.519943e-002,
	3.025845e-001,
	-2.994849e-006,
	2.113418e+000,
	6.000255e-001,
	-2.700541e+000,
	-1.485611e+000,
	2.159154e+000,
	-2.188608e+000,
	-5.879735e-002,
	3.921779e-001,
	5.020849e-002,
	1.869923e+000,
	2.118398e-001,
	-1.187417e+000,
	-1.102630e+000,
	-9.404690e-001,
	2.427532e+000,
	-2.948903e-001,
	-3.437257e-002,
	-1.636446e-001,
	1.894926e+000,
	1.001327e+000,
	-5.639857e-001,
	7.170770e-001,
	-1.146502e-001,
	-3.487513e+000,
	-7.711076e-001,
	1.046031e+000,
	2.606854e-001,
	3.873520e+000,
	5.637980e-001,
	-1.363103e+000,
	-8.396317e-001,
	5.750351e-001,
	4.317766e+000,
	-2.364722e+000,
	-4.135433e-001,
	2.669162e-002,
	5.768700e-001,
	6.649078e-001,
	-1.102449e+000,
	-3.685043e-001,
	4.622549e-001,
	-2.018634e-003,
	-3.947538e+000,
	8.449276e-001,
	8.837036e-002,
	1.601304e+000,
	7.026980e-001,
	// albedo 0, turbidity 8
	-2.314053e+000,
	-1.314766e+000,
	-7.125646e+000,
	7.357344e+000,
	-2.585710e-002,
	2.863908e-001,
	-2.425744e-006,
	2.039404e+000,
	5.594003e-001,
	-2.630411e+000,
	-1.404258e+000,
	3.675058e+000,
	-3.804226e+000,
	-4.249037e-002,
	3.486414e-001,
	5.675141e-002,
	1.944935e+000,
	2.880711e-001,
	-1.884599e+000,
	-1.657069e+000,
	-1.731916e+000,
	3.034605e+000,
	-1.746846e-001,
	-1.559184e-002,
	-1.600465e-001,
	1.915108e+000,
	9.460232e-001,
	6.351036e-002,
	1.061776e+000,
	1.195544e-002,
	-3.018584e+000,
	-5.618808e-001,
	1.008146e+000,
	2.013783e-001,
	3.212273e+000,
	6.523624e-001,
	-1.672505e+000,
	-9.752710e-001,
	5.282860e-001,
	3.776331e+000,
	-4.325128e+000,
	-4.384279e-001,
	1.352387e-001,
	8.847662e-001,
	5.717158e-001,
	-1.007695e+000,
	-3.840375e-001,
	3.463543e-001,
	2.848366e+000,
	-2.105699e+000,
	4.636429e-001,
	2.800131e-002,
	1.306056e+000,
	7.618236e-001,
	// albedo 0, turbidity 9
	-2.865406e+000,
	-1.637174e+000,
	-7.429613e+000,
	7.592861e+000,
	-2.196505e-002,
	2.800873e-001,
	-3.908530e-006,
	1.962505e+000,
	5.891464e-001,
	-3.196334e+000,
	-1.512711e+000,
	3.947880e+000,
	-4.029796e+000,
	-3.699620e-002,
	1.461452e-001,
	5.921432e-002,
	1.806132e+000,
	2.331816e-001,
	-2.335492e+000,
	-2.353032e+000,
	-1.764665e+000,
	2.841986e+000,
	-7.331326e-002,
	4.537047e-001,
	-1.668000e-001,
	2.156269e+000,
	9.812486e-001,
	3.278911e-001,
	1.315177e+000,
	-1.438189e-001,
	-2.859630e+000,
	-8.436262e-001,
	2.645711e-001,
	2.154409e-001,
	2.264493e+000,
	5.975203e-001,
	-1.738015e+000,
	-1.091057e+000,
	5.425696e-001,
	4.650166e+000,
	-3.975190e+000,
	2.066035e-001,
	1.017332e-001,
	9.321625e-001,
	6.517783e-001,
	-1.006457e+000,
	-4.243112e-001,
	1.934952e-001,
	2.795030e+000,
	-1.680697e+000,
	-9.428375e-002,
	7.158314e-002,
	1.082383e+000,
	7.234775e-001,
	// albedo 0, turbidity 10
	-4.195701e+000,
	-2.171135e+000,
	-5.278016e+000,
	5.393085e+000,
	-2.419182e-002,
	2.050075e-001,
	-3.797795e-006,
	1.853402e+000,
	6.912927e-001,
	-4.119053e+000,
	-1.648023e+000,
	2.332552e+000,
	-2.173813e+000,
	-6.442977e-002,
	2.188945e-001,
	3.548565e-002,
	1.792598e+000,
	4.162082e-002,
	-4.016823e+000,
	-3.599323e+000,
	-6.179057e-001,
	6.454998e-001,
	-9.913704e-002,
	2.770986e-001,
	-9.265471e-002,
	2.227501e+000,
	1.179216e+000,
	1.066227e+000,
	1.392783e+000,
	-9.653695e-001,
	-5.471637e-001,
	-8.500569e-001,
	4.678476e-001,
	8.760324e-002,
	1.564314e+000,
	4.885251e-001,
	-1.855594e+000,
	-1.029300e+000,
	8.521013e-001,
	3.975027e+000,
	-3.806819e+000,
	-2.044703e-002,
	1.757298e-001,
	7.790123e-001,
	6.918921e-001,
	-1.014961e+000,
	-6.014045e-001,
	1.926619e-002,
	2.357335e+000,
	-1.312911e+000,
	-8.783609e-002,
	7.739369e-002,
	7.356770e-001,
	7.042591e-001,
	// albedo 1, turbidity 1
	-1.467874e+000,
	-7.636581e-001,
	-7.251111e+000,
	7.726558e+000,
	-2.759341e-002,
	3.527534e-001,
	5.340629e-005,
	2.007747e+000,
	5.447487e-001,
	-1.863242e+000,
	-1.048209e+000,
	-1.580541e+000,
	2.558030e+000,
	-5.622126e-002,
	3.053960e-001,
	-4.657733e-004,
	9.956390e-001,
	3.409087e-001,
	-1.384101e+000,
	-5.553588e-001,
	1.191974e+000,
	-2.157512e+000,
	-3.567589e-002,
	1.020018e-001,
	2.940191e-003,
	4.555372e+000,
	8.736043e-001,
	-9.828878e-001,
	-4.220161e-001,
	1.184916e+000,
	9.230716e-001,
	-4.062756e-001,
	1.064980e+000,
	-1.060088e-002,
	-1.764815e+000,
	2.932808e-001,
	-1.057001e+000,
	-2.727017e-001,
	1.000018e+000,
	-3.108668e-001,
	6.848382e-001,
	-1.682596e-001,
	2.301218e-002,
	2.075821e+000,
	7.647327e-001,
	-1.058165e+000,
	-2.436130e-001,
	1.074414e+000,
	8.554434e-002,
	-3.846431e+000,
	7.595465e-001,
	9.729528e-006,
	1.915942e+000,
	4.999612e-001,
	// albedo 1, turbidity 2
	-1.610179e+000,
	-8.336019e-001,
	-1.443356e+001,
	1.492556e+001,
	-1.381931e-002,
	2.902743e-001,
	-7.665717e-006,
	1.981513e+000,
	9.000423e-001,
	-2.004083e+000,
	-1.148388e+000,
	3.747156e+000,
	-2.808560e+000,
	-3.298677e-002,
	4.224754e-001,
	4.166438e-004,
	8.792110e-001,
	-2.321793e-001,
	-1.178554e+000,
	-5.064839e-001,
	-1.117126e+000,
	2.815740e-001,
	-7.068438e-002,
	-3.031589e-002,
	-3.468069e-003,
	4.539093e+000,
	1.385612e+000,
	-1.091191e+000,
	-4.200919e-001,
	1.826508e+000,
	7.131992e-002,
	-1.883417e-001,
	1.061437e+000,
	1.311913e-002,
	-1.972550e+000,
	2.511246e-001,
	-9.987232e-001,
	-2.073656e-001,
	7.443384e-001,
	-7.245157e-002,
	-5.588818e-001,
	-1.364188e-001,
	2.023795e-002,
	2.829822e+000,
	7.230021e-001,
	-1.075477e+000,
	-2.556973e-001,
	1.051690e+000,
	3.075960e-002,
	-1.895492e+000,
	6.408333e-001,
	2.109454e-002,
	1.891240e+000,
	5.652527e-001,
	// albedo 1, turbidity 3
	-1.531711e+000,
	-8.266123e-001,
	-9.324763e+000,
	9.811491e+000,
	-1.988560e-002,
	3.404598e-001,
	-2.068369e-006,
	1.869307e+000,
	5.860842e-001,
	-2.113444e+000,
	-1.209106e+000,
	3.526508e+000,
	-2.628730e+000,
	-4.634065e-002,
	3.182739e-001,
	9.500212e-003,
	1.004871e+000,
	2.109968e-001,
	-1.196720e+000,
	-5.485073e-001,
	-1.667136e+000,
	9.920197e-001,
	-1.622954e-001,
	6.951315e-002,
	-3.482877e-002,
	4.214632e+000,
	1.108967e+000,
	-1.003096e+000,
	-3.200944e-001,
	2.042427e+000,
	-4.417822e-001,
	-1.404599e-001,
	9.288535e-001,
	6.077264e-002,
	-1.386737e+000,
	4.557129e-001,
	-1.061048e+000,
	-2.908451e-001,
	6.390633e-001,
	1.406786e-001,
	-1.834706e+000,
	-1.432145e-001,
	1.914080e-002,
	2.284516e+000,
	5.965839e-001,
	-1.054623e+000,
	-2.267971e-001,
	1.028491e+000,
	-3.197518e-003,
	-1.705329e+000,
	6.747358e-001,
	2.072713e-002,
	2.140509e+000,
	7.205824e-001,
	// albedo 1, turbidity 4
	-1.610001e+000,
	-8.622601e-001,
	-1.060181e+001,
	1.106133e+001,
	-1.648296e-002,
	2.590559e-001,
	-1.904522e-006,
	1.930415e+000,
	6.006964e-001,
	-2.308577e+000,
	-1.440194e+000,
	2.937335e+000,
	-2.093599e+000,
	-3.430217e-002,
	3.427774e-001,
	2.590705e-002,
	5.673750e-001,
	1.250422e-001,
	-9.441254e-001,
	-3.064812e-001,
	-8.895068e-001,
	2.815271e-001,
	-8.036228e-002,
	1.867017e-001,
	-7.809247e-002,
	4.774631e+000,
	1.391904e+000,
	-1.214397e+000,
	-5.423074e-001,
	1.361001e+000,
	1.782273e-001,
	-3.648675e-001,
	7.181838e-001,
	1.135547e-001,
	-1.935982e+000,
	1.820361e-001,
	-9.377631e-001,
	-1.533211e-001,
	8.439993e-001,
	-3.893771e-001,
	-2.564779e-001,
	-6.742272e-002,
	2.255856e-002,
	2.780601e+000,
	7.972008e-001,
	-1.101428e+000,
	-3.069552e-001,
	9.687591e-001,
	4.500576e-001,
	-4.912444e+000,
	5.398387e-001,
	3.638172e-002,
	1.582999e+000,
	6.425950e-001,
	// albedo 1, turbidity 5
	-1.687541e+000,
	-9.378170e-001,
	-8.475686e+000,
	8.929279e+000,
	-2.132746e-002,
	2.917650e-001,
	-2.177239e-006,
	1.863407e+000,
	5.908179e-001,
	-2.278432e+000,
	-1.387936e+000,
	5.425292e+000,
	-4.725025e+000,
	-3.892912e-002,
	4.084727e-001,
	1.842665e-002,
	8.461986e-001,
	1.673366e-001,
	-1.302702e+000,
	-7.200083e-001,
	-3.084331e+000,
	3.191487e+000,
	-3.222828e-001,
	-1.493849e-001,
	-5.641672e-002,
	3.624218e+000,
	1.256086e+000,
	-7.886965e-001,
	-3.966453e-002,
	2.110076e+000,
	-2.232935e+000,
	7.269719e-001,
	1.163410e+000,
	7.133744e-002,
	-1.660119e-001,
	4.329084e-001,
	-1.157760e+000,
	-4.084596e-001,
	5.689088e-001,
	2.379590e+000,
	-9.687743e+000,
	-5.598487e-001,
	9.191895e-002,
	1.923047e+000,
	5.802927e-001,
	-1.047250e+000,
	-2.873072e-001,
	1.046858e+000,
	6.890046e-001,
	-2.947892e+000,
	7.245997e-001,
	1.125227e-002,
	1.352625e+000,
	7.193979e-001,
	// albedo 1, turbidity 6
	-1.643764e+000,
	-9.086683e-001,
	-8.750078e+000,
	9.165653e+000,
	-2.025728e-002,
	2.737848e-001,
	-2.240987e-006,
	1.943471e+000,
	5.731722e-001,
	-2.473069e+000,
	-1.505194e+000,
	5.448737e+000,
	-4.863726e+000,
	-3.662439e-002,
	1.938729e-001,
	4.741355e-002,
	8.586572e-001,
	2.284408e-001,
	-1.232599e+000,
	-7.896777e-001,
	-3.056911e+000,
	3.546334e+000,
	-1.948820e-001,
	3.344216e-001,
	-1.376967e-001,
	3.029469e+000,
	1.120573e+000,
	-6.095289e-001,
	2.745468e-001,
	1.809782e+000,
	-2.593032e+000,
	-1.710009e-002,
	5.537278e-001,
	1.935506e-001,
	1.259882e+000,
	4.970103e-001,
	-1.324655e+000,
	-6.255071e-001,
	6.240868e-001,
	2.021182e+000,
	-5.876050e+000,
	-1.507819e-001,
	3.301250e-002,
	1.142019e+000,
	5.986671e-001,
	-9.888131e-001,
	-2.584852e-001,
	1.052160e+000,
	7.264224e-001,
	-2.563426e+000,
	5.494058e-001,
	1.821983e-002,
	1.277896e+000,
	7.557967e-001,
	// albedo 1, turbidity 7
	-2.100689e+000,
	-1.204431e+000,
	-7.573121e+000,
	8.039632e+000,
	-2.300526e-002,
	2.839214e-001,
	-2.346958e-006,
	1.678847e+000,
	5.536303e-001,
	-2.610610e+000,
	-1.587799e+000,
	5.460928e+000,
	-5.158708e+000,
	-4.505650e-002,
	3.876929e-001,
	3.852459e-002,
	1.172854e+000,
	3.104745e-001,
	-8.340903e-001,
	-7.487965e-001,
	-3.154774e+000,
	4.600448e+000,
	-1.818975e-001,
	-1.871764e-001,
	-1.222094e-001,
	2.067197e+000,
	8.802127e-001,
	-9.180308e-001,
	3.752197e-001,
	1.471125e+000,
	-4.691789e+000,
	-5.128294e-001,
	1.164707e+000,
	1.831224e-001,
	2.900937e+000,
	7.718397e-001,
	-1.126819e+000,
	-6.652330e-001,
	7.386065e-001,
	5.362044e+000,
	-6.196453e+000,
	-7.280092e-001,
	6.312604e-002,
	2.874666e-001,
	4.225580e-001,
	-1.091610e+000,
	-3.433417e-001,
	1.042206e+000,
	1.075776e-001,
	-4.443940e+000,
	7.469895e-001,
	3.166247e-002,
	1.019495e+000,
	7.523771e-001,
	// albedo 1, turbidity 8
	-2.234623e+000,
	-1.310221e+000,
	-8.525764e+000,
	8.932373e+000,
	-1.814945e-002,
	2.615153e-001,
	-2.992344e-006,
	1.672403e+000,
	5.897681e-001,
	-2.566352e+000,
	-1.472664e+000,
	5.894182e+000,
	-5.619094e+000,
	-3.204346e-002,
	2.993298e-001,
	4.281047e-002,
	1.303481e+000,
	2.453403e-001,
	-1.577477e+000,
	-1.491725e+000,
	-3.065840e+000,
	4.446634e+000,
	-1.689128e-001,
	9.559287e-002,
	-1.384724e-001,
	1.778589e+000,
	9.159045e-001,
	-2.747774e-001,
	8.787060e-001,
	1.071723e+000,
	-4.169230e+000,
	-3.029966e-001,
	6.326611e-001,
	2.145395e-001,
	2.611218e+000,
	7.082708e-001,
	-1.433045e+000,
	-8.939972e-001,
	8.538090e-001,
	4.481475e+000,
	-5.978961e+000,
	-1.608369e-001,
	5.335732e-002,
	3.510751e-001,
	5.421327e-001,
	-9.961738e-001,
	-3.023960e-001,
	9.152994e-001,
	2.936173e+000,
	-2.311060e+000,
	1.216642e-001,
	2.844950e-002,
	9.492671e-001,
	6.929460e-001,
	// albedo 1, turbidity 9
	-2.428587e+000,
	-1.538689e+000,
	-9.076712e+000,
	9.464050e+000,
	-1.503392e-002,
	2.373401e-001,
	-2.770103e-006,
	1.537508e+000,
	5.959289e-001,
	-3.240872e+000,
	-1.646067e+000,
	6.091797e+000,
	-5.738481e+000,
	-3.098072e-002,
	2.698026e-001,
	3.864212e-002,
	1.286514e+000,
	2.461153e-001,
	-1.970987e+000,
	-2.124015e+000,
	-2.894000e+000,
	3.858260e+000,
	-1.449222e-001,
	1.903898e-001,
	-1.194017e-001,
	1.882566e+000,
	8.764452e-001,
	3.562238e-002,
	1.092427e+000,
	6.291668e-001,
	-3.337396e+000,
	-2.817141e-001,
	4.799828e-001,
	1.674350e-001,
	1.943489e+000,
	7.728749e-001,
	-1.501790e+000,
	-9.408520e-001,
	1.000954e+000,
	4.599103e+000,
	-5.295662e+000,
	-1.111397e-001,
	1.040124e-001,
	3.185557e-001,
	4.959400e-001,
	-9.859417e-001,
	-3.827367e-001,
	8.040930e-001,
	2.980678e+000,
	-2.015582e+000,
	-8.947514e-003,
	1.696367e-002,
	6.489501e-001,
	7.555598e-001,
	// albedo 1, turbidity 10
	-3.758956e+000,
	-2.159015e+000,
	-7.207163e+000,
	7.516659e+000,
	-1.643521e-002,
	2.465725e-001,
	-4.045068e-006,
	1.471688e+000,
	6.687943e-001,
	-4.635664e+000,
	-1.766046e+000,
	4.282669e+000,
	-4.058908e+000,
	-2.908998e-002,
	1.202684e-001,
	3.167305e-002,
	1.450927e+000,
	8.171815e-002,
	-3.458011e+000,
	-3.657280e+000,
	-1.484743e+000,
	2.264533e+000,
	-1.033120e-001,
	4.282323e-001,
	-8.387881e-002,
	1.687334e+000,
	1.130604e+000,
	9.673527e-001,
	1.500425e+000,
	-3.604932e-001,
	-2.050346e+000,
	-3.778381e-001,
	2.416298e-001,
	8.439313e-002,
	1.458583e+000,
	5.816071e-001,
	-1.808078e+000,
	-1.089975e+000,
	1.291838e+000,
	5.144631e+000,
	-5.047822e+000,
	4.301183e-002,
	1.426941e-001,
	1.187472e-001,
	6.145551e-001,
	-8.399253e-001,
	-3.832885e-001,
	6.306417e-001,
	2.179775e+000,
	-1.492762e+000,
	-1.682763e-001,
	4.109851e-002,
	4.221724e-001,
	7.086504e-001,
};

double datasetRad400[] = 
{
	// albedo 0, turbidity 1
	4.668300e-002,
	9.868960e-002,
	-1.771333e-001,
	6.687440e-001,
	1.392029e+000,
	9.986235e-001,
	// albedo 0, turbidity 2
	4.582776e-002,
	1.018614e-001,
	-1.881307e-001,
	6.776592e-001,
	1.401047e+000,
	1.016435e+000,
	// albedo 0, turbidity 3
	4.568248e-002,
	1.010922e-001,
	-1.851341e-001,
	6.474660e-001,
	1.469330e+000,
	1.014158e+000,
	// albedo 0, turbidity 4
	4.434795e-002,
	9.838154e-002,
	-1.718009e-001,
	5.819163e-001,
	1.588451e+000,
	1.008220e+000,
	// albedo 0, turbidity 5
	4.359376e-002,
	9.611603e-002,
	-1.639761e-001,
	5.344035e-001,
	1.673271e+000,
	1.023811e+000,
	// albedo 0, turbidity 6
	4.305955e-002,
	9.393132e-002,
	-1.541275e-001,
	4.880885e-001,
	1.746925e+000,
	1.020812e+000,
	// albedo 0, turbidity 7
	4.192088e-002,
	9.112506e-002,
	-1.382965e-001,
	4.137111e-001,
	1.849490e+000,
	1.034616e+000,
	// albedo 0, turbidity 8
	4.042670e-002,
	8.299413e-002,
	-1.015609e-001,
	2.776178e-001,
	2.015643e+000,
	1.054391e+000,
	// albedo 0, turbidity 9
	3.852343e-002,
	6.641196e-002,
	-2.627537e-002,
	3.164681e-002,
	2.282128e+000,
	1.070368e+000,
	// albedo 0, turbidity 10
	3.571325e-002,
	3.974297e-002,
	8.424870e-002,
	-2.935775e-001,
	2.547312e+000,
	1.140705e+000,
	// albedo 1, turbidity 1
	5.679224e-002,
	7.929513e-002,
	-7.951369e-003,
	1.881214e-001,
	2.456521e+000,
	2.083260e+000,
	// albedo 1, turbidity 2
	5.653144e-002,
	7.757465e-002,
	-4.812390e-003,
	1.668414e-001,
	2.501044e+000,
	2.061822e+000,
	// albedo 1, turbidity 3
	5.556607e-002,
	7.722316e-002,
	-2.680467e-003,
	1.397415e-001,
	2.547245e+000,
	2.055499e+000,
	// albedo 1, turbidity 4
	5.423907e-002,
	7.569948e-002,
	2.746208e-003,
	9.388053e-002,
	2.613087e+000,
	2.047858e+000,
	// albedo 1, turbidity 5
	5.272135e-002,
	7.182013e-002,
	1.893595e-002,
	2.280844e-002,
	2.704394e+000,
	2.020504e+000,
	// albedo 1, turbidity 6
	5.184846e-002,
	6.852665e-002,
	2.963929e-002,
	-2.465402e-002,
	2.763538e+000,
	1.994612e+000,
	// albedo 1, turbidity 7
	5.035161e-002,
	6.473107e-002,
	4.822041e-002,
	-1.054530e-001,
	2.851784e+000,
	1.957751e+000,
	// albedo 1, turbidity 8
	4.785788e-002,
	5.525476e-002,
	8.163098e-002,
	-2.243489e-001,
	2.946524e+000,
	1.931700e+000,
	// albedo 1, turbidity 9
	4.492922e-002,
	4.174088e-002,
	1.344967e-001,
	-4.105780e-001,
	3.081372e+000,
	1.874144e+000,
	// albedo 1, turbidity 10
	4.055971e-002,
	2.134172e-002,
	2.023388e-001,
	-6.132472e-001,
	3.098515e+000,
	1.884364e+000,
};

double dataset440[] = 
{
	// albedo 0, turbidity 1
	-1.397312e+000,
	-5.327311e-001,
	-5.456059e+000,
	5.777674e+000,
	-5.111575e-002,
	4.730804e-001,
	7.375500e-003,
	3.032806e+000,
	5.181890e-001,
	-1.561639e+000,
	-7.024946e-001,
	-2.140322e+000,
	2.841761e+000,
	-8.846023e-002,
	5.529005e-001,
	6.219344e-003,
	2.004212e+000,
	3.701256e-001,
	-1.047473e+000,
	-1.152734e-001,
	2.275873e+000,
	-3.020347e+000,
	-1.739218e-001,
	2.250142e-001,
	-2.731776e-002,
	6.659723e+000,
	1.067495e+000,
	-1.298483e+000,
	-5.788209e-001,
	4.906412e-001,
	1.522576e+000,
	-5.650061e-001,
	1.544707e+000,
	4.638003e-002,
	-3.742019e+000,
	2.485397e-001,
	-9.485899e-001,
	-7.383610e-002,
	1.039247e+000,
	-4.744931e-001,
	-1.822357e-001,
	2.284415e-001,
	-4.796962e-002,
	4.363935e+000,
	8.217971e-001,
	-1.099082e+000,
	-2.001688e-001,
	7.365077e-001,
	1.068489e-001,
	-5.005434e+000,
	1.508145e+000,
	8.181497e-002,
	3.226865e+000,
	4.999418e-001,
	// albedo 0, turbidity 2
	-1.416143e+000,
	-5.515006e-001,
	-7.045898e+000,
	7.448161e+000,
	-4.504075e-002,
	5.055437e-001,
	-1.378949e-006,
	2.955475e+000,
	6.184716e-001,
	-1.698183e+000,
	-8.272914e-001,
	9.984388e-001,
	-2.511235e-001,
	-9.262675e-002,
	5.681534e-001,
	5.377123e-003,
	1.631048e+000,
	1.137691e-001,
	-9.234085e-001,
	-2.165404e-002,
	6.483039e-002,
	-8.535145e-001,
	-2.497457e-001,
	1.695057e-001,
	-3.410225e-002,
	6.726925e+000,
	1.331197e+000,
	-1.265077e+000,
	-5.034231e-001,
	1.196547e+000,
	3.666463e-001,
	-3.960044e-001,
	1.404008e+000,
	1.129300e-001,
	-2.644439e+000,
	1.103356e-001,
	-1.008210e+000,
	-1.455232e-001,
	7.347739e-001,
	2.462433e-002,
	-2.534587e+000,
	3.088590e-001,
	-6.687136e-002,
	3.786007e+000,
	9.578369e-001,
	-1.076840e+000,
	-1.851501e-001,
	7.341818e-001,
	-2.658571e-003,
	-5.001762e+000,
	1.275390e+000,
	1.277410e-001,
	3.223315e+000,
	5.147659e-001,
	// albedo 0, turbidity 3
	-1.449526e+000,
	-5.738159e-001,
	-8.976383e+000,
	9.275142e+000,
	-3.157845e-002,
	5.011970e-001,
	-1.218363e-006,
	3.001006e+000,
	5.662190e-001,
	-1.748840e+000,
	-9.338946e-001,
	5.557460e-002,
	9.451626e-001,
	-6.929558e-002,
	5.458365e-001,
	5.505399e-003,
	8.818793e-001,
	2.135274e-001,
	-8.369988e-001,
	1.127967e-001,
	8.846958e-001,
	-2.467908e+000,
	-8.394011e-002,
	1.684067e-001,
	-3.352743e-002,
	7.957386e+000,
	1.297777e+000,
	-1.284515e+000,
	-5.332365e-001,
	5.511261e-001,
	1.702784e+000,
	-6.616281e-001,
	1.349449e+000,
	1.269152e-001,
	-3.247373e+000,
	2.115827e-001,
	-9.889637e-001,
	-9.962819e-002,
	6.096776e-001,
	-8.472749e-001,
	7.672924e-001,
	7.425160e-002,
	2.113714e-002,
	4.990637e+000,
	8.274585e-001,
	-1.093910e+000,
	-2.211349e-001,
	6.959659e-001,
	3.423174e-001,
	-5.004213e+000,
	1.347201e+000,
	1.198192e-001,
	2.547517e+000,
	6.329489e-001,
	// albedo 0, turbidity 4
	-1.394462e+000,
	-5.287733e-001,
	-8.095187e+000,
	8.076613e+000,
	-1.275227e-002,
	1.916790e-001,
	4.741296e-002,
	3.145140e+000,
	5.071760e-001,
	-2.234192e+000,
	-1.437079e+000,
	-5.734544e-001,
	1.248687e+000,
	-4.136344e-002,
	7.671749e-001,
	-1.273584e-002,
	4.751894e-001,
	4.116995e-001,
	-4.063889e-001,
	4.920785e-001,
	3.865520e-001,
	2.254008e-001,
	-1.618861e-001,
	1.950875e-001,
	-8.622479e-002,
	3.836900e+000,
	1.108189e+000,
	-1.366924e+000,
	-4.557853e-001,
	-6.731417e-001,
	-3.011452e-001,
	2.413069e-001,
	1.404821e+000,
	1.920278e-001,
	6.394529e+000,
	4.219713e-001,
	-9.128947e-001,
	1.980978e-002,
	5.119874e-001,
	8.027541e-002,
	-3.680159e+000,
	6.597416e-001,
	3.853339e-002,
	3.969131e+000,
	8.351942e-001,
	-1.162856e+000,
	-3.606511e-001,
	7.055795e-001,
	-2.702137e-003,
	4.777294e-001,
	-7.722331e-001,
	3.446509e-001,
	1.186834e+000,
	5.118539e-001,
	// albedo 0, turbidity 5
	-1.563353e+000,
	-6.916347e-001,
	-4.154766e+001,
	4.181703e+001,
	-5.673370e-003,
	4.344900e-001,
	1.839829e-003,
	2.669278e+000,
	5.021266e-001,
	-1.948172e+000,
	-1.080669e+000,
	1.082552e+001,
	-1.034262e+001,
	-1.196421e-002,
	3.895739e-001,
	5.621831e-002,
	1.347130e+000,
	4.561106e-001,
	-9.155219e-001,
	-1.456265e-001,
	-2.177275e+000,
	2.079788e+000,
	-2.154465e-002,
	7.743816e-001,
	-2.181642e-001,
	4.897704e+000,
	1.035464e+000,
	-1.010898e+000,
	-4.425431e-002,
	3.067880e-001,
	-6.899235e-001,
	-1.891895e-001,
	3.015686e-001,
	4.236422e-001,
	1.901582e+000,
	3.916662e-001,
	-1.159005e+000,
	-4.048136e-001,
	5.385745e-001,
	3.423651e-001,
	1.474365e-001,
	3.516065e-001,
	2.564260e-003,
	1.815518e+000,
	7.634079e-001,
	-1.081675e+000,
	-2.556981e-001,
	6.544471e-001,
	4.093649e-001,
	-3.215201e+000,
	9.116400e-001,
	1.406660e-001,
	1.869407e+000,
	6.968119e-001,
	// albedo 0, turbidity 6
	-1.561484e+000,
	-7.153039e-001,
	-1.623772e+001,
	1.650713e+001,
	-1.394913e-002,
	4.467465e-001,
	9.613464e-004,
	2.564429e+000,
	5.363746e-001,
	-2.308050e+000,
	-1.314851e+000,
	-1.484346e+000,
	1.928705e+000,
	-2.164130e-002,
	2.817711e-001,
	7.177671e-002,
	1.146387e+000,
	3.025595e-001,
	-4.886429e-001,
	8.279799e-002,
	2.432876e+000,
	-2.276257e+000,
	-4.799742e-002,
	9.362010e-001,
	-2.753669e-001,
	4.784291e+000,
	1.180593e+000,
	-1.306115e+000,
	-1.759650e-001,
	-1.392008e+000,
	3.119302e-001,
	-2.268673e-001,
	8.336951e-002,
	5.250725e-001,
	2.534962e+000,
	2.800244e-001,
	-1.016608e+000,
	-3.429911e-001,
	5.659470e-001,
	9.044333e-001,
	7.387499e-002,
	4.267609e-001,
	-4.165623e-002,
	1.452779e+000,
	8.409560e-001,
	-1.127637e+000,
	-2.854231e-001,
	4.933964e-001,
	-3.379287e-003,
	-1.181893e+000,
	8.164171e-001,
	1.910509e-001,
	1.979338e+000,
	6.658885e-001,
	// albedo 0, turbidity 7
	-1.675310e+000,
	-8.020443e-001,
	-1.136130e+001,
	1.159861e+001,
	-1.871156e-002,
	4.151400e-001,
	-1.940992e-006,
	2.486322e+000,
	5.256426e-001,
	-2.071301e+000,
	-1.175325e+000,
	1.789426e+000,
	-1.455233e+000,
	-2.855906e-002,
	3.218745e-001,
	7.776969e-002,
	1.431615e+000,
	3.478887e-001,
	-1.093503e+000,
	-4.120496e-001,
	-8.598647e-002,
	4.564844e-001,
	-1.231980e-001,
	7.992132e-001,
	-2.910745e-001,
	3.881502e+000,
	1.064658e+000,
	-7.736128e-001,
	2.385498e-001,
	-7.867818e-001,
	-6.009723e-001,
	-1.808566e-001,
	-8.796429e-003,
	5.412620e-001,
	2.991552e+000,
	4.008143e-001,
	-1.259083e+000,
	-5.300975e-001,
	5.418031e-001,
	1.150966e+000,
	-7.553821e-001,
	5.991000e-001,
	-2.344718e-003,
	1.097939e+000,
	7.756612e-001,
	-1.094148e+000,
	-3.178958e-001,
	4.126954e-001,
	3.591106e-001,
	-1.415744e+000,
	3.908399e-001,
	1.806147e-001,
	1.584959e+000,
	6.862009e-001,
	// albedo 0, turbidity 8
	-1.815485e+000,
	-9.306778e-001,
	-1.249527e+001,
	1.271288e+001,
	-1.497209e-002,
	3.576353e-001,
	-2.464284e-006,
	2.326460e+000,
	5.655414e-001,
	-2.225570e+000,
	-1.213627e+000,
	6.082472e+000,
	-5.907562e+000,
	-2.446452e-002,
	2.113558e-001,
	7.708802e-002,
	1.647556e+000,
	2.416155e-001,
	-1.439532e+000,
	-8.666475e-001,
	-2.734807e+000,
	3.355265e+000,
	-1.311068e-001,
	1.048703e+000,
	-2.887025e-001,
	3.419973e+000,
	1.146322e+000,
	-5.599890e-001,
	4.437236e-001,
	1.582320e-001,
	-2.000110e+000,
	-2.859304e-001,
	-5.600631e-001,
	5.382793e-001,
	1.986387e+000,
	3.455121e-001,
	-1.319304e+000,
	-6.466246e-001,
	5.684685e-001,
	2.050330e+000,
	-2.796053e+000,
	1.001659e+000,
	-1.161356e-002,
	9.737235e-001,
	8.101246e-001,
	-1.097281e+000,
	-3.336023e-001,
	1.781708e-001,
	1.733079e+000,
	-1.378806e+000,
	-1.870394e-001,
	1.997578e-001,
	1.456148e+000,
	6.791796e-001,
	// albedo 0, turbidity 9
	-2.208666e+000,
	-1.219745e+000,
	-7.548669e+000,
	7.680830e+000,
	-2.012473e-002,
	3.627866e-001,
	-2.906182e-006,
	2.147138e+000,
	6.340095e-001,
	-1.967348e+000,
	-9.528057e-001,
	4.171590e+000,
	-4.002838e+000,
	-5.074552e-002,
	1.581866e-001,
	5.920106e-002,
	1.981564e+000,
	1.023257e-001,
	-3.150304e+000,
	-2.193706e+000,
	-2.016165e+000,
	2.374337e+000,
	-6.793058e-002,
	9.623811e-001,
	-2.195022e-001,
	2.736885e+000,
	1.252161e+000,
	4.737094e-001,
	1.067875e+000,
	-1.003861e-001,
	-1.566752e+000,
	-1.217264e+000,
	-4.270598e-001,
	3.968055e-001,
	1.234108e+000,
	3.105789e-001,
	-1.706975e+000,
	-9.607442e-001,
	7.140098e-001,
	3.981202e+000,
	-3.521433e+000,
	6.308820e-001,
	5.140937e-002,
	7.435120e-001,
	8.074305e-001,
	-1.012042e+000,
	-3.372525e-001,
	2.589450e-002,
	1.768224e+000,
	-1.059990e+000,
	-1.299077e-001,
	1.790337e-001,
	1.091012e+000,
	6.873854e-001,
	// albedo 0, turbidity 10
	-2.912541e+000,
	-1.677524e+000,
	-3.843452e+000,
	3.954207e+000,
	-3.414327e-002,
	2.945890e-001,
	-4.245832e-006,
	1.934337e+000,
	7.258748e-001,
	-1.567383e+000,
	-8.279686e-001,
	1.690940e+000,
	-1.413268e+000,
	-1.216792e-001,
	7.332798e-002,
	4.862765e-002,
	2.034766e+000,
	-5.041561e-002,
	-6.058613e+000,
	-3.509207e+000,
	-6.312870e-001,
	-4.558316e-002,
	6.168891e-002,
	8.153413e-001,
	-1.686845e-001,
	2.670227e+000,
	1.362906e+000,
	1.347177e+000,
	9.821888e-001,
	-9.242155e-001,
	5.851576e-001,
	-1.897421e+000,
	-2.729487e-002,
	2.866724e-001,
	7.306238e-001,
	2.792136e-001,
	-1.810783e+000,
	-1.027512e+000,
	1.216071e+000,
	5.270108e+000,
	-3.887149e+000,
	6.193256e-002,
	2.774610e-002,
	1.484756e-001,
	8.033249e-001,
	-9.801965e-001,
	-3.375841e-001,
	-3.004804e-001,
	1.385754e+000,
	-6.834540e-001,
	5.827734e-002,
	2.268309e-001,
	1.028696e+000,
	6.797371e-001,
	// albedo 1, turbidity 1
	-1.345260e+000,
	-5.085528e-001,
	-6.052009e+000,
	6.604590e+000,
	-4.300752e-002,
	4.745234e-001,
	6.591457e-003,
	2.595142e+000,
	5.013653e-001,
	-1.573525e+000,
	-7.133524e-001,
	-1.671346e+000,
	2.693205e+000,
	-7.828763e-002,
	2.915699e-001,
	1.795879e-002,
	1.469445e+000,
	4.927472e-001,
	-1.013665e+000,
	-1.731419e-001,
	2.043423e+000,
	-2.919634e+000,
	-1.020807e-001,
	5.467619e-001,
	-4.041481e-002,
	5.853992e+000,
	5.272064e-001,
	-1.173191e+000,
	-3.964683e-001,
	1.097258e+000,
	1.509973e+000,
	-5.675641e-001,
	9.815927e-001,
	6.962319e-002,
	-3.358210e+000,
	4.263117e-001,
	-1.003507e+000,
	-1.124908e-001,
	1.030642e+000,
	-5.357088e-001,
	6.114201e-001,
	1.628414e-001,
	-5.701497e-002,
	4.541126e+000,
	8.084996e-001,
	-1.071959e+000,
	-1.567262e-001,
	9.923029e-001,
	1.457160e-001,
	-4.742907e+000,
	7.280970e-001,
	6.770360e-002,
	3.919300e+000,
	4.999529e-001,
	// albedo 1, turbidity 2
	-1.399982e+000,
	-5.538549e-001,
	-6.983148e+000,
	7.513966e+000,
	-3.358417e-002,
	3.667027e-001,
	1.158837e-002,
	2.499680e+000,
	5.598537e-001,
	-1.602839e+000,
	-7.835806e-001,
	1.200264e+000,
	-1.454290e-001,
	-7.431927e-002,
	5.374263e-001,
	9.505505e-004,
	1.096167e+000,
	2.185838e-001,
	-9.587294e-001,
	-6.134134e-002,
	2.234030e-001,
	-8.115395e-001,
	-2.344054e-001,
	2.018782e-001,
	-4.192332e-002,
	6.331499e+000,
	1.353587e+000,
	-1.166832e+000,
	-4.057833e-001,
	1.461335e+000,
	3.165401e-001,
	-3.245858e-001,
	1.199323e+000,
	1.100274e-001,
	-2.727373e+000,
	5.329788e-002,
	-1.023178e+000,
	-1.351631e-001,
	9.944251e-001,
	2.103341e-002,
	-2.460318e+000,
	5.136074e-003,
	-5.267951e-002,
	4.097235e+000,
	9.388837e-001,
	-1.071426e+000,
	-1.726491e-001,
	1.048949e+000,
	-2.624840e-003,
	-4.993124e+000,
	6.621513e-001,
	7.801931e-002,
	3.227750e+000,
	5.363265e-001,
	// albedo 1, turbidity 3
	-1.362723e+000,
	-5.257224e-001,
	-1.325130e+001,
	1.374641e+001,
	-1.971887e-002,
	4.480379e-001,
	-9.588735e-007,
	2.679516e+000,
	5.628531e-001,
	-1.824466e+000,
	-9.877790e-001,
	4.631069e+000,
	-3.630521e+000,
	-4.340325e-002,
	3.913450e-001,
	3.415899e-002,
	4.746800e-001,
	2.022772e-001,
	-6.435267e-001,
	1.629762e-001,
	-1.452097e+000,
	8.028761e-001,
	-9.611017e-002,
	4.267105e-001,
	-1.023573e-001,
	6.652106e+000,
	1.406057e+000,
	-1.400277e+000,
	-5.150235e-001,
	1.752017e+000,
	-1.699743e-001,
	-3.411643e-001,
	8.465596e-001,
	2.127075e-001,
	-2.235971e+000,
	4.728189e-002,
	-9.044866e-001,
	-7.979493e-002,
	8.298122e-001,
	-5.604698e-002,
	-1.433761e+000,
	1.011757e-001,
	-7.175544e-002,
	4.243075e+000,
	9.588179e-001,
	-1.115618e+000,
	-2.148000e-001,
	1.109081e+000,
	2.661209e-001,
	-5.008111e+000,
	6.333048e-001,
	9.274718e-002,
	2.494529e+000,
	5.890657e-001,
	// albedo 1, turbidity 4
	-1.389611e+000,
	-5.579886e-001,
	-1.045229e+001,
	1.092342e+001,
	-2.282772e-002,
	4.054079e-001,
	2.781558e-003,
	2.578484e+000,
	5.372706e-001,
	-1.893851e+000,
	-1.116122e+000,
	2.111553e+000,
	-8.775468e-001,
	-5.640158e-002,
	5.399894e-001,
	1.929352e-002,
	-5.585557e-002,
	2.870402e-001,
	-7.015617e-001,
	1.884526e-001,
	-1.660273e-001,
	-8.785899e-001,
	-5.471987e-002,
	1.787856e-001,
	-9.958870e-002,
	7.207213e+000,
	1.277933e+000,
	-1.279075e+000,
	-4.794032e-001,
	9.037342e-001,
	6.225399e-001,
	-6.592270e-001,
	9.474313e-001,
	2.524811e-001,
	-2.485658e+000,
	2.050401e-001,
	-9.744212e-001,
	-9.899254e-002,
	9.474600e-001,
	-2.536639e-001,
	5.390432e-001,
	-8.465488e-002,
	-3.140532e-002,
	4.512343e+000,
	8.530654e-001,
	-1.093264e+000,
	-2.115594e-001,
	9.876876e-001,
	7.531309e-002,
	-5.003648e+000,
	6.719560e-001,
	1.111699e-001,
	2.412349e+000,
	6.482966e-001,
	// albedo 1, turbidity 5
	-1.410458e+000,
	-5.905263e-001,
	-4.146328e+001,
	4.190254e+001,
	-5.607421e-003,
	4.437719e-001,
	-1.948391e-006,
	2.496743e+000,
	5.031933e-001,
	-1.817258e+000,
	-9.848495e-001,
	1.089217e+001,
	-1.028029e+001,
	-1.221684e-002,
	3.317008e-001,
	5.060062e-002,
	1.198443e+000,
	4.449482e-001,
	-8.920534e-001,
	-8.835804e-002,
	-2.111594e+000,
	2.083599e+000,
	-1.507800e-002,
	6.993567e-001,
	-1.987686e-001,
	4.793539e+000,
	1.072586e+000,
	-1.048633e+000,
	-1.110825e-001,
	5.438710e-001,
	-6.707296e-001,
	-1.825365e-001,
	2.307221e-001,
	4.056218e-001,
	1.886912e+000,
	3.579576e-001,
	-1.094223e+000,
	-3.084727e-001,
	9.739595e-001,
	3.972140e-001,
	1.511647e-001,
	2.788218e-001,
	-6.279180e-002,
	1.866444e+000,
	7.995203e-001,
	-1.078162e+000,
	-2.176197e-001,
	1.088756e+000,
	4.329413e-001,
	-3.209490e+000,
	8.364785e-001,
	7.689785e-002,
	1.943182e+000,
	7.150615e-001,
	// albedo 1, turbidity 6
	-1.455846e+000,
	-6.322333e-001,
	-1.618289e+001,
	1.656258e+001,
	-1.280603e-002,
	4.130359e-001,
	-9.061644e-007,
	2.461391e+000,
	5.315915e-001,
	-2.222251e+000,
	-1.233356e+000,
	-1.454954e+000,
	1.957432e+000,
	-1.730555e-002,
	2.418496e-001,
	7.240262e-002,
	1.061939e+000,
	3.148474e-001,
	-4.536196e-001,
	1.457295e-001,
	2.483934e+000,
	-2.244550e+000,
	-4.593767e-002,
	8.967621e-001,
	-2.712877e-001,
	4.732142e+000,
	1.188839e+000,
	-1.277343e+000,
	-2.046024e-001,
	-1.229720e+000,
	3.977256e-001,
	-2.209195e-001,
	6.033235e-002,
	5.267707e-001,
	2.536445e+000,
	2.759606e-001,
	-1.029833e+000,
	-2.979843e-001,
	8.742883e-001,
	1.037710e+000,
	1.350257e-001,
	4.066094e-001,
	-1.376375e-001,
	1.500753e+000,
	8.676699e-001,
	-1.095935e+000,
	-2.211775e-001,
	9.320585e-001,
	8.955212e-002,
	-1.113388e+000,
	7.909911e-001,
	1.393848e-001,
	2.057146e+000,
	6.699739e-001,
	// albedo 1, turbidity 7
	-1.571831e+000,
	-7.466353e-001,
	-1.226063e+001,
	1.265995e+001,
	-1.514083e-002,
	3.639653e-001,
	-2.504287e-006,
	2.204454e+000,
	5.468861e-001,
	-2.235398e+000,
	-1.371434e+000,
	1.787996e+000,
	-1.073965e+000,
	-2.503530e-002,
	2.143584e-001,
	7.703453e-002,
	5.207181e-001,
	2.714312e-001,
	-6.944677e-001,
	-7.243136e-002,
	-6.193104e-001,
	9.567440e-001,
	-6.317194e-002,
	8.881508e-001,
	-2.783301e-001,
	4.224532e+000,
	1.192802e+000,
	-1.133391e+000,
	-9.811942e-002,
	2.312721e-001,
	-1.100585e+000,
	-3.655097e-001,
	2.268787e-003,
	5.074358e-001,
	1.512457e+000,
	3.165593e-001,
	-1.057051e+000,
	-3.424797e-001,
	9.536822e-001,
	1.034064e+000,
	6.413292e-001,
	1.165363e-001,
	-4.248128e-002,
	1.592803e+000,
	7.875911e-001,
	-1.096695e+000,
	-2.745143e-001,
	1.077920e+000,
	-8.435082e-004,
	-3.715956e+000,
	5.197900e-001,
	1.171467e-001,
	1.236912e+000,
	6.915287e-001,
	// albedo 1, turbidity 8
	-1.711623e+000,
	-9.023881e-001,
	-9.799257e+000,
	1.022040e+001,
	-1.708447e-002,
	3.309925e-001,
	-3.241111e-006,
	1.932295e+000,
	5.844205e-001,
	-2.351937e+000,
	-1.340391e+000,
	6.329976e+000,
	-6.054139e+000,
	-2.843868e-002,
	2.298301e-001,
	7.698142e-002,
	1.109800e+000,
	1.863187e-001,
	-1.141314e+000,
	-6.670322e-001,
	-3.262632e+000,
	4.551521e+000,
	-8.614941e-002,
	8.058038e-001,
	-2.791051e-001,
	3.084281e+000,
	1.236638e+000,
	-7.950557e-001,
	2.489854e-001,
	9.966347e-001,
	-3.391737e+000,
	-7.235716e-001,
	-2.155609e-001,
	5.126659e-001,
	1.452322e+000,
	2.882812e-001,
	-1.182289e+000,
	-5.192524e-001,
	9.672941e-001,
	3.091448e+000,
	-4.193043e+000,
	4.051469e-001,
	-5.708309e-002,
	9.386723e-001,
	8.208828e-001,
	-1.080579e+000,
	-2.918654e-001,
	9.499317e-001,
	2.856082e+000,
	-2.256007e+000,
	1.377750e-002,
	1.012914e-001,
	9.716489e-001,
	6.832750e-001,
	// albedo 1, turbidity 9
	-1.964781e+000,
	-1.162652e+000,
	-6.074737e+000,
	6.497797e+000,
	-2.595660e-002,
	3.222936e-001,
	-3.220871e-006,
	1.685891e+000,
	6.501551e-001,
	-2.352213e+000,
	-1.199539e+000,
	4.248376e+000,
	-3.876965e+000,
	-6.837923e-002,
	1.764412e-001,
	5.514810e-002,
	1.442736e+000,
	6.979575e-002,
	-2.560247e+000,
	-1.883591e+000,
	-1.916723e+000,
	2.598994e+000,
	-2.372381e-002,
	8.442578e-001,
	-2.063113e-001,
	2.359942e+000,
	1.287838e+000,
	7.281064e-002,
	7.835433e-001,
	1.380748e-001,
	-2.065580e+000,
	-1.696648e+000,
	-4.575316e-001,
	3.840004e-001,
	9.397056e-001,
	3.103904e-001,
	-1.444446e+000,
	-7.662151e-001,
	1.364103e+000,
	4.930232e+000,
	-4.455564e+000,
	6.735458e-001,
	-4.052978e-003,
	3.194173e-001,
	7.842959e-001,
	-1.039666e+000,
	-3.171617e-001,
	7.295920e-001,
	2.813846e+000,
	-1.561230e+000,
	-4.128303e-001,
	1.004149e-001,
	6.653613e-001,
	6.980277e-001,
	// albedo 1, turbidity 10
	-2.999915e+000,
	-1.721740e+000,
	-4.796494e+000,
	5.021888e+000,
	-2.163250e-002,
	3.309183e-001,
	-4.051804e-006,
	1.645464e+000,
	7.145890e-001,
	-1.673162e+000,
	-1.056666e+000,
	3.209766e+000,
	-2.559187e+000,
	-7.456364e-002,
	6.215063e-002,
	4.469425e-002,
	1.242757e+000,
	-1.580590e-002,
	-5.775475e+000,
	-3.239700e+000,
	-1.356432e+000,
	1.099950e+000,
	-9.497509e-002,
	7.121875e-001,
	-1.656838e-001,
	2.553396e+000,
	1.286227e+000,
	1.241869e+000,
	6.671222e-001,
	-4.156007e-001,
	-8.167921e-001,
	-1.037816e+000,
	5.950065e-002,
	3.114868e-001,
	6.414114e-001,
	3.677503e-001,
	-1.580126e+000,
	-7.852349e-001,
	1.749569e+000,
	5.987990e+000,
	-5.075133e+000,
	-4.693815e-002,
	-5.106759e-002,
	-9.755925e-001,
	7.440092e-001,
	-9.732917e-001,
	-1.939297e-001,
	2.709367e-001,
	1.352990e+000,
	-9.040352e-001,
	5.181217e-003,
	2.302437e-001,
	1.506500e+000,
	6.840186e-001,
};

double datasetRad440[] = 
{
	// albedo 0, turbidity 1
	7.613884e-002,
	1.581858e-001,
	-3.252313e-001,
	1.408388e+000,
	1.093508e+000,
	1.105128e+000,
	// albedo 0, turbidity 2
	7.451325e-002,
	1.653037e-001,
	-3.543027e-001,
	1.446460e+000,
	1.123936e+000,
	1.120306e+000,
	// albedo 0, turbidity 3
	7.325740e-002,
	1.688718e-001,
	-3.766044e-001,
	1.452725e+000,
	1.233697e+000,
	1.114182e+000,
	// albedo 0, turbidity 4
	7.006396e-002,
	1.789290e-001,
	-4.219204e-001,
	1.486303e+000,
	1.346055e+000,
	1.149056e+000,
	// albedo 0, turbidity 5
	6.762868e-002,
	1.817070e-001,
	-4.365127e-001,
	1.447243e+000,
	1.512287e+000,
	1.169631e+000,
	// albedo 0, turbidity 6
	6.626986e-002,
	1.809348e-001,
	-4.282658e-001,
	1.370862e+000,
	1.678637e+000,
	1.152996e+000,
	// albedo 0, turbidity 7
	6.401686e-002,
	1.780154e-001,
	-4.181312e-001,
	1.277002e+000,
	1.859575e+000,
	1.188609e+000,
	// albedo 0, turbidity 8
	6.135668e-002,
	1.657981e-001,
	-3.619501e-001,
	1.033618e+000,
	2.215815e+000,
	1.212149e+000,
	// albedo 0, turbidity 9
	5.748273e-002,
	1.355812e-001,
	-2.235179e-001,
	5.729304e-001,
	2.749632e+000,
	1.260376e+000,
	// albedo 0, turbidity 10
	5.281658e-002,
	8.825729e-002,
	-1.614986e-002,
	-6.617688e-002,
	3.338203e+000,
	1.388015e+000,
	// albedo 1, turbidity 1
	8.998056e-002,
	1.443958e-001,
	-1.578024e-001,
	9.105446e-001,
	2.422784e+000,
	2.318869e+000,
	// albedo 1, turbidity 2
	8.900756e-002,
	1.464687e-001,
	-1.698990e-001,
	9.161196e-001,
	2.474653e+000,
	2.320503e+000,
	// albedo 1, turbidity 3
	8.660660e-002,
	1.471943e-001,
	-1.748207e-001,
	8.777832e-001,
	2.613680e+000,
	2.294963e+000,
	// albedo 1, turbidity 4
	8.354844e-002,
	1.514437e-001,
	-1.998722e-001,
	8.658343e-001,
	2.736118e+000,
	2.318493e+000,
	// albedo 1, turbidity 5
	8.008078e-002,
	1.493295e-001,
	-1.908957e-001,
	7.640320e-001,
	2.948273e+000,
	2.290225e+000,
	// albedo 1, turbidity 6
	7.810981e-002,
	1.519283e-001,
	-2.057773e-001,
	7.437529e-001,
	3.011442e+000,
	2.311845e+000,
	// albedo 1, turbidity 7
	7.545684e-002,
	1.465048e-001,
	-1.818352e-001,
	6.105517e-001,
	3.203786e+000,
	2.300408e+000,
	// albedo 1, turbidity 8
	7.157199e-002,
	1.298467e-001,
	-1.131010e-001,
	3.426176e-001,
	3.527560e+000,
	2.258120e+000,
	// albedo 1, turbidity 9
	6.612079e-002,
	1.024330e-001,
	3.299415e-003,
	-6.376105e-002,
	3.909414e+000,
	2.240796e+000,
	// albedo 1, turbidity 10
	5.976123e-002,
	5.941061e-002,
	1.695098e-001,
	-5.778192e-001,
	4.222691e+000,
	2.269388e+000,
};

double dataset480[] = 
{
	// albedo 0, turbidity 1
	-1.397312e+000,
	-5.327311e-001,
	-5.456059e+000,
	5.777674e+000,
	-5.111575e-002,
	4.730804e-001,
	7.375500e-003,
	3.032806e+000,
	5.181890e-001,
	-1.561639e+000,
	-7.024946e-001,
	-2.140322e+000,
	2.841761e+000,
	-8.846023e-002,
	5.529005e-001,
	6.219344e-003,
	2.004212e+000,
	3.701256e-001,
	-1.047473e+000,
	-1.152734e-001,
	2.275873e+000,
	-3.020347e+000,
	-1.739218e-001,
	2.250142e-001,
	-2.731776e-002,
	6.659723e+000,
	1.067495e+000,
	-1.298483e+000,
	-5.788209e-001,
	4.906412e-001,
	1.522576e+000,
	-5.650061e-001,
	1.544707e+000,
	4.638003e-002,
	-3.742019e+000,
	2.485397e-001,
	-9.485899e-001,
	-7.383610e-002,
	1.039247e+000,
	-4.744931e-001,
	-1.822357e-001,
	2.284415e-001,
	-4.796962e-002,
	4.363935e+000,
	8.217971e-001,
	-1.099082e+000,
	-2.001688e-001,
	7.365077e-001,
	1.068489e-001,
	-5.005434e+000,
	1.508145e+000,
	8.181497e-002,
	3.226865e+000,
	4.999418e-001,
	// albedo 0, turbidity 2
	-1.416143e+000,
	-5.515006e-001,
	-7.045898e+000,
	7.448161e+000,
	-4.504075e-002,
	5.055437e-001,
	-1.378949e-006,
	2.955475e+000,
	6.184716e-001,
	-1.698183e+000,
	-8.272914e-001,
	9.984388e-001,
	-2.511235e-001,
	-9.262675e-002,
	5.681534e-001,
	5.377123e-003,
	1.631048e+000,
	1.137691e-001,
	-9.234085e-001,
	-2.165404e-002,
	6.483039e-002,
	-8.535145e-001,
	-2.497457e-001,
	1.695057e-001,
	-3.410225e-002,
	6.726925e+000,
	1.331197e+000,
	-1.265077e+000,
	-5.034231e-001,
	1.196547e+000,
	3.666463e-001,
	-3.960044e-001,
	1.404008e+000,
	1.129300e-001,
	-2.644439e+000,
	1.103356e-001,
	-1.008210e+000,
	-1.455232e-001,
	7.347739e-001,
	2.462433e-002,
	-2.534587e+000,
	3.088590e-001,
	-6.687136e-002,
	3.786007e+000,
	9.578369e-001,
	-1.076840e+000,
	-1.851501e-001,
	7.341818e-001,
	-2.658571e-003,
	-5.001762e+000,
	1.275390e+000,
	1.277410e-001,
	3.223315e+000,
	5.147659e-001,
	// albedo 0, turbidity 3
	-1.449526e+000,
	-5.738159e-001,
	-8.976383e+000,
	9.275142e+000,
	-3.157845e-002,
	5.011970e-001,
	-1.218363e-006,
	3.001006e+000,
	5.662190e-001,
	-1.748840e+000,
	-9.338946e-001,
	5.557460e-002,
	9.451626e-001,
	-6.929558e-002,
	5.458365e-001,
	5.505399e-003,
	8.818793e-001,
	2.135274e-001,
	-8.369988e-001,
	1.127967e-001,
	8.846958e-001,
	-2.467908e+000,
	-8.394011e-002,
	1.684067e-001,
	-3.352743e-002,
	7.957386e+000,
	1.297777e+000,
	-1.284515e+000,
	-5.332365e-001,
	5.511261e-001,
	1.702784e+000,
	-6.616281e-001,
	1.349449e+000,
	1.269152e-001,
	-3.247373e+000,
	2.115827e-001,
	-9.889637e-001,
	-9.962819e-002,
	6.096776e-001,
	-8.472749e-001,
	7.672924e-001,
	7.425160e-002,
	2.113714e-002,
	4.990637e+000,
	8.274585e-001,
	-1.093910e+000,
	-2.211349e-001,
	6.959659e-001,
	3.423174e-001,
	-5.004213e+000,
	1.347201e+000,
	1.198192e-001,
	2.547517e+000,
	6.329489e-001,
	// albedo 0, turbidity 4
	-1.394462e+000,
	-5.287733e-001,
	-8.095187e+000,
	8.076613e+000,
	-1.275227e-002,
	1.916790e-001,
	4.741296e-002,
	3.145140e+000,
	5.071760e-001,
	-2.234192e+000,
	-1.437079e+000,
	-5.734544e-001,
	1.248687e+000,
	-4.136344e-002,
	7.671749e-001,
	-1.273584e-002,
	4.751894e-001,
	4.116995e-001,
	-4.063889e-001,
	4.920785e-001,
	3.865520e-001,
	2.254008e-001,
	-1.618861e-001,
	1.950875e-001,
	-8.622479e-002,
	3.836900e+000,
	1.108189e+000,
	-1.366924e+000,
	-4.557853e-001,
	-6.731417e-001,
	-3.011452e-001,
	2.413069e-001,
	1.404821e+000,
	1.920278e-001,
	6.394529e+000,
	4.219713e-001,
	-9.128947e-001,
	1.980978e-002,
	5.119874e-001,
	8.027541e-002,
	-3.680159e+000,
	6.597416e-001,
	3.853339e-002,
	3.969131e+000,
	8.351942e-001,
	-1.162856e+000,
	-3.606511e-001,
	7.055795e-001,
	-2.702137e-003,
	4.777294e-001,
	-7.722331e-001,
	3.446509e-001,
	1.186834e+000,
	5.118539e-001,
	// albedo 0, turbidity 5
	-1.563353e+000,
	-6.916347e-001,
	-4.154766e+001,
	4.181703e+001,
	-5.673370e-003,
	4.344900e-001,
	1.839829e-003,
	2.669278e+000,
	5.021266e-001,
	-1.948172e+000,
	-1.080669e+000,
	1.082552e+001,
	-1.034262e+001,
	-1.196421e-002,
	3.895739e-001,
	5.621831e-002,
	1.347130e+000,
	4.561106e-001,
	-9.155219e-001,
	-1.456265e-001,
	-2.177275e+000,
	2.079788e+000,
	-2.154465e-002,
	7.743816e-001,
	-2.181642e-001,
	4.897704e+000,
	1.035464e+000,
	-1.010898e+000,
	-4.425431e-002,
	3.067880e-001,
	-6.899235e-001,
	-1.891895e-001,
	3.015686e-001,
	4.236422e-001,
	1.901582e+000,
	3.916662e-001,
	-1.159005e+000,
	-4.048136e-001,
	5.385745e-001,
	3.423651e-001,
	1.474365e-001,
	3.516065e-001,
	2.564260e-003,
	1.815518e+000,
	7.634079e-001,
	-1.081675e+000,
	-2.556981e-001,
	6.544471e-001,
	4.093649e-001,
	-3.215201e+000,
	9.116400e-001,
	1.406660e-001,
	1.869407e+000,
	6.968119e-001,
	// albedo 0, turbidity 6
	-1.561484e+000,
	-7.153039e-001,
	-1.623772e+001,
	1.650713e+001,
	-1.394913e-002,
	4.467465e-001,
	9.613464e-004,
	2.564429e+000,
	5.363746e-001,
	-2.308050e+000,
	-1.314851e+000,
	-1.484346e+000,
	1.928705e+000,
	-2.164130e-002,
	2.817711e-001,
	7.177671e-002,
	1.146387e+000,
	3.025595e-001,
	-4.886429e-001,
	8.279799e-002,
	2.432876e+000,
	-2.276257e+000,
	-4.799742e-002,
	9.362010e-001,
	-2.753669e-001,
	4.784291e+000,
	1.180593e+000,
	-1.306115e+000,
	-1.759650e-001,
	-1.392008e+000,
	3.119302e-001,
	-2.268673e-001,
	8.336951e-002,
	5.250725e-001,
	2.534962e+000,
	2.800244e-001,
	-1.016608e+000,
	-3.429911e-001,
	5.659470e-001,
	9.044333e-001,
	7.387499e-002,
	4.267609e-001,
	-4.165623e-002,
	1.452779e+000,
	8.409560e-001,
	-1.127637e+000,
	-2.854231e-001,
	4.933964e-001,
	-3.379287e-003,
	-1.181893e+000,
	8.164171e-001,
	1.910509e-001,
	1.979338e+000,
	6.658885e-001,
	// albedo 0, turbidity 7
	-1.675310e+000,
	-8.020443e-001,
	-1.136130e+001,
	1.159861e+001,
	-1.871156e-002,
	4.151400e-001,
	-1.940992e-006,
	2.486322e+000,
	5.256426e-001,
	-2.071301e+000,
	-1.175325e+000,
	1.789426e+000,
	-1.455233e+000,
	-2.855906e-002,
	3.218745e-001,
	7.776969e-002,
	1.431615e+000,
	3.478887e-001,
	-1.093503e+000,
	-4.120496e-001,
	-8.598647e-002,
	4.564844e-001,
	-1.231980e-001,
	7.992132e-001,
	-2.910745e-001,
	3.881502e+000,
	1.064658e+000,
	-7.736128e-001,
	2.385498e-001,
	-7.867818e-001,
	-6.009723e-001,
	-1.808566e-001,
	-8.796429e-003,
	5.412620e-001,
	2.991552e+000,
	4.008143e-001,
	-1.259083e+000,
	-5.300975e-001,
	5.418031e-001,
	1.150966e+000,
	-7.553821e-001,
	5.991000e-001,
	-2.344718e-003,
	1.097939e+000,
	7.756612e-001,
	-1.094148e+000,
	-3.178958e-001,
	4.126954e-001,
	3.591106e-001,
	-1.415744e+000,
	3.908399e-001,
	1.806147e-001,
	1.584959e+000,
	6.862009e-001,
	// albedo 0, turbidity 8
	-1.815485e+000,
	-9.306778e-001,
	-1.249527e+001,
	1.271288e+001,
	-1.497209e-002,
	3.576353e-001,
	-2.464284e-006,
	2.326460e+000,
	5.655414e-001,
	-2.225570e+000,
	-1.213627e+000,
	6.082472e+000,
	-5.907562e+000,
	-2.446452e-002,
	2.113558e-001,
	7.708802e-002,
	1.647556e+000,
	2.416155e-001,
	-1.439532e+000,
	-8.666475e-001,
	-2.734807e+000,
	3.355265e+000,
	-1.311068e-001,
	1.048703e+000,
	-2.887025e-001,
	3.419973e+000,
	1.146322e+000,
	-5.599890e-001,
	4.437236e-001,
	1.582320e-001,
	-2.000110e+000,
	-2.859304e-001,
	-5.600631e-001,
	5.382793e-001,
	1.986387e+000,
	3.455121e-001,
	-1.319304e+000,
	-6.466246e-001,
	5.684685e-001,
	2.050330e+000,
	-2.796053e+000,
	1.001659e+000,
	-1.161356e-002,
	9.737235e-001,
	8.101246e-001,
	-1.097281e+000,
	-3.336023e-001,
	1.781708e-001,
	1.733079e+000,
	-1.378806e+000,
	-1.870394e-001,
	1.997578e-001,
	1.456148e+000,
	6.791796e-001,
	// albedo 0, turbidity 9
	-2.208666e+000,
	-1.219745e+000,
	-7.548669e+000,
	7.680830e+000,
	-2.012473e-002,
	3.627866e-001,
	-2.906182e-006,
	2.147138e+000,
	6.340095e-001,
	-1.967348e+000,
	-9.528057e-001,
	4.171590e+000,
	-4.002838e+000,
	-5.074552e-002,
	1.581866e-001,
	5.920106e-002,
	1.981564e+000,
	1.023257e-001,
	-3.150304e+000,
	-2.193706e+000,
	-2.016165e+000,
	2.374337e+000,
	-6.793058e-002,
	9.623811e-001,
	-2.195022e-001,
	2.736885e+000,
	1.252161e+000,
	4.737094e-001,
	1.067875e+000,
	-1.003861e-001,
	-1.566752e+000,
	-1.217264e+000,
	-4.270598e-001,
	3.968055e-001,
	1.234108e+000,
	3.105789e-001,
	-1.706975e+000,
	-9.607442e-001,
	7.140098e-001,
	3.981202e+000,
	-3.521433e+000,
	6.308820e-001,
	5.140937e-002,
	7.435120e-001,
	8.074305e-001,
	-1.012042e+000,
	-3.372525e-001,
	2.589450e-002,
	1.768224e+000,
	-1.059990e+000,
	-1.299077e-001,
	1.790337e-001,
	1.091012e+000,
	6.873854e-001,
	// albedo 0, turbidity 10
	-2.912541e+000,
	-1.677524e+000,
	-3.843452e+000,
	3.954207e+000,
	-3.414327e-002,
	2.945890e-001,
	-4.245832e-006,
	1.934337e+000,
	7.258748e-001,
	-1.567383e+000,
	-8.279686e-001,
	1.690940e+000,
	-1.413268e+000,
	-1.216792e-001,
	7.332798e-002,
	4.862765e-002,
	2.034766e+000,
	-5.041561e-002,
	-6.058613e+000,
	-3.509207e+000,
	-6.312870e-001,
	-4.558316e-002,
	6.168891e-002,
	8.153413e-001,
	-1.686845e-001,
	2.670227e+000,
	1.362906e+000,
	1.347177e+000,
	9.821888e-001,
	-9.242155e-001,
	5.851576e-001,
	-1.897421e+000,
	-2.729487e-002,
	2.866724e-001,
	7.306238e-001,
	2.792136e-001,
	-1.810783e+000,
	-1.027512e+000,
	1.216071e+000,
	5.270108e+000,
	-3.887149e+000,
	6.193256e-002,
	2.774610e-002,
	1.484756e-001,
	8.033249e-001,
	-9.801965e-001,
	-3.375841e-001,
	-3.004804e-001,
	1.385754e+000,
	-6.834540e-001,
	5.827734e-002,
	2.268309e-001,
	1.028696e+000,
	6.797371e-001,
	// albedo 1, turbidity 1
	-1.345260e+000,
	-5.085528e-001,
	-6.052009e+000,
	6.604590e+000,
	-4.300752e-002,
	4.745234e-001,
	6.591457e-003,
	2.595142e+000,
	5.013653e-001,
	-1.573525e+000,
	-7.133524e-001,
	-1.671346e+000,
	2.693205e+000,
	-7.828763e-002,
	2.915699e-001,
	1.795879e-002,
	1.469445e+000,
	4.927472e-001,
	-1.013665e+000,
	-1.731419e-001,
	2.043423e+000,
	-2.919634e+000,
	-1.020807e-001,
	5.467619e-001,
	-4.041481e-002,
	5.853992e+000,
	5.272064e-001,
	-1.173191e+000,
	-3.964683e-001,
	1.097258e+000,
	1.509973e+000,
	-5.675641e-001,
	9.815927e-001,
	6.962319e-002,
	-3.358210e+000,
	4.263117e-001,
	-1.003507e+000,
	-1.124908e-001,
	1.030642e+000,
	-5.357088e-001,
	6.114201e-001,
	1.628414e-001,
	-5.701497e-002,
	4.541126e+000,
	8.084996e-001,
	-1.071959e+000,
	-1.567262e-001,
	9.923029e-001,
	1.457160e-001,
	-4.742907e+000,
	7.280970e-001,
	6.770360e-002,
	3.919300e+000,
	4.999529e-001,
	// albedo 1, turbidity 2
	-1.399982e+000,
	-5.538549e-001,
	-6.983148e+000,
	7.513966e+000,
	-3.358417e-002,
	3.667027e-001,
	1.158837e-002,
	2.499680e+000,
	5.598537e-001,
	-1.602839e+000,
	-7.835806e-001,
	1.200264e+000,
	-1.454290e-001,
	-7.431927e-002,
	5.374263e-001,
	9.505505e-004,
	1.096167e+000,
	2.185838e-001,
	-9.587294e-001,
	-6.134134e-002,
	2.234030e-001,
	-8.115395e-001,
	-2.344054e-001,
	2.018782e-001,
	-4.192332e-002,
	6.331499e+000,
	1.353587e+000,
	-1.166832e+000,
	-4.057833e-001,
	1.461335e+000,
	3.165401e-001,
	-3.245858e-001,
	1.199323e+000,
	1.100274e-001,
	-2.727373e+000,
	5.329788e-002,
	-1.023178e+000,
	-1.351631e-001,
	9.944251e-001,
	2.103341e-002,
	-2.460318e+000,
	5.136074e-003,
	-5.267951e-002,
	4.097235e+000,
	9.388837e-001,
	-1.071426e+000,
	-1.726491e-001,
	1.048949e+000,
	-2.624840e-003,
	-4.993124e+000,
	6.621513e-001,
	7.801931e-002,
	3.227750e+000,
	5.363265e-001,
	// albedo 1, turbidity 3
	-1.362723e+000,
	-5.257224e-001,
	-1.325130e+001,
	1.374641e+001,
	-1.971887e-002,
	4.480379e-001,
	-9.588735e-007,
	2.679516e+000,
	5.628531e-001,
	-1.824466e+000,
	-9.877790e-001,
	4.631069e+000,
	-3.630521e+000,
	-4.340325e-002,
	3.913450e-001,
	3.415899e-002,
	4.746800e-001,
	2.022772e-001,
	-6.435267e-001,
	1.629762e-001,
	-1.452097e+000,
	8.028761e-001,
	-9.611017e-002,
	4.267105e-001,
	-1.023573e-001,
	6.652106e+000,
	1.406057e+000,
	-1.400277e+000,
	-5.150235e-001,
	1.752017e+000,
	-1.699743e-001,
	-3.411643e-001,
	8.465596e-001,
	2.127075e-001,
	-2.235971e+000,
	4.728189e-002,
	-9.044866e-001,
	-7.979493e-002,
	8.298122e-001,
	-5.604698e-002,
	-1.433761e+000,
	1.011757e-001,
	-7.175544e-002,
	4.243075e+000,
	9.588179e-001,
	-1.115618e+000,
	-2.148000e-001,
	1.109081e+000,
	2.661209e-001,
	-5.008111e+000,
	6.333048e-001,
	9.274718e-002,
	2.494529e+000,
	5.890657e-001,
	// albedo 1, turbidity 4
	-1.389611e+000,
	-5.579886e-001,
	-1.045229e+001,
	1.092342e+001,
	-2.282772e-002,
	4.054079e-001,
	2.781558e-003,
	2.578484e+000,
	5.372706e-001,
	-1.893851e+000,
	-1.116122e+000,
	2.111553e+000,
	-8.775468e-001,
	-5.640158e-002,
	5.399894e-001,
	1.929352e-002,
	-5.585557e-002,
	2.870402e-001,
	-7.015617e-001,
	1.884526e-001,
	-1.660273e-001,
	-8.785899e-001,
	-5.471987e-002,
	1.787856e-001,
	-9.958870e-002,
	7.207213e+000,
	1.277933e+000,
	-1.279075e+000,
	-4.794032e-001,
	9.037342e-001,
	6.225399e-001,
	-6.592270e-001,
	9.474313e-001,
	2.524811e-001,
	-2.485658e+000,
	2.050401e-001,
	-9.744212e-001,
	-9.899254e-002,
	9.474600e-001,
	-2.536639e-001,
	5.390432e-001,
	-8.465488e-002,
	-3.140532e-002,
	4.512343e+000,
	8.530654e-001,
	-1.093264e+000,
	-2.115594e-001,
	9.876876e-001,
	7.531309e-002,
	-5.003648e+000,
	6.719560e-001,
	1.111699e-001,
	2.412349e+000,
	6.482966e-001,
	// albedo 1, turbidity 5
	-1.410458e+000,
	-5.905263e-001,
	-4.146328e+001,
	4.190254e+001,
	-5.607421e-003,
	4.437719e-001,
	-1.948391e-006,
	2.496743e+000,
	5.031933e-001,
	-1.817258e+000,
	-9.848495e-001,
	1.089217e+001,
	-1.028029e+001,
	-1.221684e-002,
	3.317008e-001,
	5.060062e-002,
	1.198443e+000,
	4.449482e-001,
	-8.920534e-001,
	-8.835804e-002,
	-2.111594e+000,
	2.083599e+000,
	-1.507800e-002,
	6.993567e-001,
	-1.987686e-001,
	4.793539e+000,
	1.072586e+000,
	-1.048633e+000,
	-1.110825e-001,
	5.438710e-001,
	-6.707296e-001,
	-1.825365e-001,
	2.307221e-001,
	4.056218e-001,
	1.886912e+000,
	3.579576e-001,
	-1.094223e+000,
	-3.084727e-001,
	9.739595e-001,
	3.972140e-001,
	1.511647e-001,
	2.788218e-001,
	-6.279180e-002,
	1.866444e+000,
	7.995203e-001,
	-1.078162e+000,
	-2.176197e-001,
	1.088756e+000,
	4.329413e-001,
	-3.209490e+000,
	8.364785e-001,
	7.689785e-002,
	1.943182e+000,
	7.150615e-001,
	// albedo 1, turbidity 6
	-1.455846e+000,
	-6.322333e-001,
	-1.618289e+001,
	1.656258e+001,
	-1.280603e-002,
	4.130359e-001,
	-9.061644e-007,
	2.461391e+000,
	5.315915e-001,
	-2.222251e+000,
	-1.233356e+000,
	-1.454954e+000,
	1.957432e+000,
	-1.730555e-002,
	2.418496e-001,
	7.240262e-002,
	1.061939e+000,
	3.148474e-001,
	-4.536196e-001,
	1.457295e-001,
	2.483934e+000,
	-2.244550e+000,
	-4.593767e-002,
	8.967621e-001,
	-2.712877e-001,
	4.732142e+000,
	1.188839e+000,
	-1.277343e+000,
	-2.046024e-001,
	-1.229720e+000,
	3.977256e-001,
	-2.209195e-001,
	6.033235e-002,
	5.267707e-001,
	2.536445e+000,
	2.759606e-001,
	-1.029833e+000,
	-2.979843e-001,
	8.742883e-001,
	1.037710e+000,
	1.350257e-001,
	4.066094e-001,
	-1.376375e-001,
	1.500753e+000,
	8.676699e-001,
	-1.095935e+000,
	-2.211775e-001,
	9.320585e-001,
	8.955212e-002,
	-1.113388e+000,
	7.909911e-001,
	1.393848e-001,
	2.057146e+000,
	6.699739e-001,
	// albedo 1, turbidity 7
	-1.571831e+000,
	-7.466353e-001,
	-1.226063e+001,
	1.265995e+001,
	-1.514083e-002,
	3.639653e-001,
	-2.504287e-006,
	2.204454e+000,
	5.468861e-001,
	-2.235398e+000,
	-1.371434e+000,
	1.787996e+000,
	-1.073965e+000,
	-2.503530e-002,
	2.143584e-001,
	7.703453e-002,
	5.207181e-001,
	2.714312e-001,
	-6.944677e-001,
	-7.243136e-002,
	-6.193104e-001,
	9.567440e-001,
	-6.317194e-002,
	8.881508e-001,
	-2.783301e-001,
	4.224532e+000,
	1.192802e+000,
	-1.133391e+000,
	-9.811942e-002,
	2.312721e-001,
	-1.100585e+000,
	-3.655097e-001,
	2.268787e-003,
	5.074358e-001,
	1.512457e+000,
	3.165593e-001,
	-1.057051e+000,
	-3.424797e-001,
	9.536822e-001,
	1.034064e+000,
	6.413292e-001,
	1.165363e-001,
	-4.248128e-002,
	1.592803e+000,
	7.875911e-001,
	-1.096695e+000,
	-2.745143e-001,
	1.077920e+000,
	-8.435082e-004,
	-3.715956e+000,
	5.197900e-001,
	1.171467e-001,
	1.236912e+000,
	6.915287e-001,
	// albedo 1, turbidity 8
	-1.711623e+000,
	-9.023881e-001,
	-9.799257e+000,
	1.022040e+001,
	-1.708447e-002,
	3.309925e-001,
	-3.241111e-006,
	1.932295e+000,
	5.844205e-001,
	-2.351937e+000,
	-1.340391e+000,
	6.329976e+000,
	-6.054139e+000,
	-2.843868e-002,
	2.298301e-001,
	7.698142e-002,
	1.109800e+000,
	1.863187e-001,
	-1.141314e+000,
	-6.670322e-001,
	-3.262632e+000,
	4.551521e+000,
	-8.614941e-002,
	8.058038e-001,
	-2.791051e-001,
	3.084281e+000,
	1.236638e+000,
	-7.950557e-001,
	2.489854e-001,
	9.966347e-001,
	-3.391737e+000,
	-7.235716e-001,
	-2.155609e-001,
	5.126659e-001,
	1.452322e+000,
	2.882812e-001,
	-1.182289e+000,
	-5.192524e-001,
	9.672941e-001,
	3.091448e+000,
	-4.193043e+000,
	4.051469e-001,
	-5.708309e-002,
	9.386723e-001,
	8.208828e-001,
	-1.080579e+000,
	-2.918654e-001,
	9.499317e-001,
	2.856082e+000,
	-2.256007e+000,
	1.377750e-002,
	1.012914e-001,
	9.716489e-001,
	6.832750e-001,
	// albedo 1, turbidity 9
	-1.964781e+000,
	-1.162652e+000,
	-6.074737e+000,
	6.497797e+000,
	-2.595660e-002,
	3.222936e-001,
	-3.220871e-006,
	1.685891e+000,
	6.501551e-001,
	-2.352213e+000,
	-1.199539e+000,
	4.248376e+000,
	-3.876965e+000,
	-6.837923e-002,
	1.764412e-001,
	5.514810e-002,
	1.442736e+000,
	6.979575e-002,
	-2.560247e+000,
	-1.883591e+000,
	-1.916723e+000,
	2.598994e+000,
	-2.372381e-002,
	8.442578e-001,
	-2.063113e-001,
	2.359942e+000,
	1.287838e+000,
	7.281064e-002,
	7.835433e-001,
	1.380748e-001,
	-2.065580e+000,
	-1.696648e+000,
	-4.575316e-001,
	3.840004e-001,
	9.397056e-001,
	3.103904e-001,
	-1.444446e+000,
	-7.662151e-001,
	1.364103e+000,
	4.930232e+000,
	-4.455564e+000,
	6.735458e-001,
	-4.052978e-003,
	3.194173e-001,
	7.842959e-001,
	-1.039666e+000,
	-3.171617e-001,
	7.295920e-001,
	2.813846e+000,
	-1.561230e+000,
	-4.128303e-001,
	1.004149e-001,
	6.653613e-001,
	6.980277e-001,
	// albedo 1, turbidity 10
	-2.999915e+000,
	-1.721740e+000,
	-4.796494e+000,
	5.021888e+000,
	-2.163250e-002,
	3.309183e-001,
	-4.051804e-006,
	1.645464e+000,
	7.145890e-001,
	-1.673162e+000,
	-1.056666e+000,
	3.209766e+000,
	-2.559187e+000,
	-7.456364e-002,
	6.215063e-002,
	4.469425e-002,
	1.242757e+000,
	-1.580590e-002,
	-5.775475e+000,
	-3.239700e+000,
	-1.356432e+000,
	1.099950e+000,
	-9.497509e-002,
	7.121875e-001,
	-1.656838e-001,
	2.553396e+000,
	1.286227e+000,
	1.241869e+000,
	6.671222e-001,
	-4.156007e-001,
	-8.167921e-001,
	-1.037816e+000,
	5.950065e-002,
	3.114868e-001,
	6.414114e-001,
	3.677503e-001,
	-1.580126e+000,
	-7.852349e-001,
	1.749569e+000,
	5.987990e+000,
	-5.075133e+000,
	-4.693815e-002,
	-5.106759e-002,
	-9.755925e-001,
	7.440092e-001,
	-9.732917e-001,
	-1.939297e-001,
	2.709367e-001,
	1.352990e+000,
	-9.040352e-001,
	5.181217e-003,
	2.302437e-001,
	1.506500e+000,
	6.840186e-001,
};

double datasetRad480[] = 
{
	// albedo 0, turbidity 1
	1.106836e-001,
	1.617557e-001,
	-2.223712e-001,
	1.629241e+000,
	8.626553e-001,
	1.011117e+000,
	// albedo 0, turbidity 2
	1.068095e-001,
	1.807606e-001,
	-3.107154e-001,
	1.794334e+000,
	8.357312e-001,
	1.058704e+000,
	// albedo 0, turbidity 3
	1.023979e-001,
	1.935925e-001,
	-3.821700e-001,
	1.903843e+000,
	9.506144e-001,
	1.055374e+000,
	// albedo 0, turbidity 4
	9.750983e-002,
	2.221893e-001,
	-5.210713e-001,
	2.109239e+000,
	1.050698e+000,
	1.115763e+000,
	// albedo 0, turbidity 5
	9.111285e-002,
	2.453301e-001,
	-6.358660e-001,
	2.264126e+000,
	1.142400e+000,
	1.203246e+000,
	// albedo 0, turbidity 6
	8.801765e-002,
	2.536783e-001,
	-6.724997e-001,
	2.260727e+000,
	1.303234e+000,
	1.215945e+000,
	// albedo 0, turbidity 7
	8.383362e-002,
	2.570991e-001,
	-6.868821e-001,
	2.164623e+000,
	1.598177e+000,
	1.240969e+000,
	// albedo 0, turbidity 8
	7.810199e-002,
	2.499359e-001,
	-6.529595e-001,
	1.904702e+000,
	2.066657e+000,
	1.302165e+000,
	// albedo 0, turbidity 9
	7.178799e-002,
	2.126681e-001,
	-4.768538e-001,
	1.271237e+000,
	2.836735e+000,
	1.395516e+000,
	// albedo 0, turbidity 10
	6.560434e-002,
	1.422030e-001,
	-1.620349e-001,
	2.862457e-001,
	3.797996e+000,
	1.559196e+000,
	// albedo 1, turbidity 1
	1.239585e-001,
	1.691730e-001,
	-1.347675e-001,
	1.316695e+000,
	2.106735e+000,
	2.217214e+000,
	// albedo 1, turbidity 2
	1.214136e-001,
	1.827941e-001,
	-2.037588e-001,
	1.440769e+000,
	2.108289e+000,
	2.269001e+000,
	// albedo 1, turbidity 3
	1.162070e-001,
	2.002146e-001,
	-2.955303e-001,
	1.591777e+000,
	2.141568e+000,
	2.342411e+000,
	// albedo 1, turbidity 4
	1.107892e-001,
	2.106751e-001,
	-3.612057e-001,
	1.626070e+000,
	2.411162e+000,
	2.325309e+000,
	// albedo 1, turbidity 5
	1.050623e-001,
	2.192739e-001,
	-4.115423e-001,
	1.626936e+000,
	2.636868e+000,
	2.361264e+000,
	// albedo 1, turbidity 6
	1.025933e-001,
	2.228143e-001,
	-4.341956e-001,
	1.588611e+000,
	2.810589e+000,
	2.370193e+000,
	// albedo 1, turbidity 7
	9.714317e-002,
	2.251753e-001,
	-4.411182e-001,
	1.471839e+000,
	3.071992e+000,
	2.407635e+000,
	// albedo 1, turbidity 8
	9.030970e-002,
	2.107053e-001,
	-3.728364e-001,
	1.119804e+000,
	3.583579e+000,
	2.403320e+000,
	// albedo 1, turbidity 9
	8.372172e-002,
	1.708661e-001,
	-2.025603e-001,
	5.031154e-001,
	4.251905e+000,
	2.428124e+000,
	// albedo 1, turbidity 10
	7.503295e-002,
	1.014131e-001,
	8.782860e-002,
	-4.050759e-001,
	4.993351e+000,
	2.471109e+000,
};

double dataset520[] = 
{
	// albedo 0, turbidity 1
	-1.171338e+000,
	-2.379456e-001,
	-6.515446e+000,
	7.133235e+000,
	-5.382867e-002,
	6.889982e-001,
	4.250983e-002,
	4.471437e+000,
	5.087463e-001,
	-1.193029e+000,
	-2.445141e-001,
	-4.311723e-001,
	1.019354e+000,
	-1.281643e-001,
	7.837279e-001,
	2.609613e-002,
	5.965800e+000,
	4.381607e-001,
	-1.165299e+000,
	-2.503239e-001,
	3.829843e+000,
	-2.234083e+000,
	-4.693988e-001,
	1.045109e+000,
	-6.241707e-002,
	2.623310e-001,
	7.500398e-001,
	-1.077288e+000,
	-2.659342e-001,
	-7.565678e-002,
	1.145086e+000,
	-2.316655e-002,
	1.564941e+000,
	9.375322e-002,
	-7.476929e-001,
	6.076913e-001,
	-1.075530e+000,
	-1.232648e-001,
	1.877081e+000,
	-1.186427e-001,
	-2.748628e+000,
	1.249377e+000,
	-1.085780e-001,
	3.838331e+000,
	8.601227e-001,
	-1.067002e+000,
	-1.572453e-001,
	1.350156e+000,
	3.140948e-003,
	-3.277283e+000,
	1.488404e+000,
	1.127058e-001,
	2.655730e+000,
	4.999138e-001,
	// albedo 0, turbidity 2
	-1.175145e+000,
	-2.454528e-001,
	-8.173280e+000,
	8.622722e+000,
	-3.895019e-002,
	6.739096e-001,
	6.622835e-002,
	4.450872e+000,
	5.061382e-001,
	-1.226543e+000,
	-2.979950e-001,
	3.102814e+000,
	-2.662701e+000,
	-1.012309e-001,
	5.142095e-001,
	4.939276e-002,
	5.007851e+000,
	4.179865e-001,
	-1.075743e+000,
	-1.267529e-001,
	1.017884e-001,
	4.839556e-001,
	-4.025119e-001,
	1.120466e+000,
	-5.059103e-002,
	3.601070e+000,
	1.104232e+000,
	-1.104008e+000,
	-2.079352e-001,
	1.094572e+000,
	1.147058e+000,
	-1.516726e-001,
	1.526097e+000,
	1.922554e-001,
	4.060614e-001,
	2.975787e-001,
	-1.080135e+000,
	-1.942481e-001,
	1.409056e+000,
	-3.800384e+000,
	-7.125701e+000,
	9.731220e-001,
	-7.312793e-002,
	2.377810e+000,
	9.223131e-001,
	-1.066280e+000,
	-1.421591e-001,
	1.272936e+000,
	7.891881e+000,
	-3.626975e+000,
	1.294678e+000,
	1.331475e-001,
	2.986127e+000,
	5.316962e-001,
	// albedo 0, turbidity 3
	-1.210057e+000,
	-2.827640e-001,
	-5.179186e+000,
	5.514430e+000,
	-5.638504e-002,
	6.656727e-001,
	5.417868e-002,
	4.216550e+000,
	5.495231e-001,
	-1.311087e+000,
	-3.921139e-001,
	1.436554e+000,
	-7.051260e-001,
	-1.462714e-001,
	2.604620e-001,
	5.771570e-002,
	3.493766e+000,
	5.041164e-001,
	-9.705912e-001,
	-4.316197e-002,
	5.357225e-001,
	-1.399982e+000,
	-3.407923e-001,
	1.585242e+000,
	-6.423039e-002,
	5.338193e+000,
	9.835385e-001,
	-1.177697e+000,
	-1.893604e-001,
	-5.207247e-002,
	4.572666e+000,
	-5.523178e-001,
	2.677765e-001,
	3.872768e-001,
	1.978123e+000,
	4.095974e-001,
	-1.029420e+000,
	-2.105096e-001,
	1.657176e+000,
	-1.028655e+001,
	-7.725428e+000,
	1.707122e+000,
	-7.681108e-002,
	1.074660e+000,
	8.312794e-001,
	-1.082084e+000,
	-1.321893e-001,
	8.487219e-001,
	1.858290e+001,
	-3.172656e+000,
	6.915801e-001,
	1.905927e-001,
	3.901473e+000,
	6.144141e-001,
	// albedo 0, turbidity 4
	-1.259854e+000,
	-3.329630e-001,
	-2.270176e+000,
	2.357599e+000,
	-9.019414e-002,
	5.779792e-001,
	7.706039e-002,
	3.971905e+000,
	4.999172e-001,
	-1.413220e+000,
	-5.430979e-001,
	-1.715627e-001,
	1.151561e+000,
	-2.318489e-001,
	2.791441e-001,
	1.306646e-002,
	1.794583e+000,
	6.167457e-001,
	-9.926840e-001,
	2.303697e-002,
	7.306051e-001,
	-2.124879e+000,
	-2.221853e-001,
	1.635982e+000,
	-8.684297e-002,
	7.621636e+000,
	9.443863e-001,
	-1.113409e+000,
	-2.409045e-001,
	-1.979662e-001,
	5.089736e+000,
	-2.071840e+000,
	-6.954891e-001,
	5.966469e-001,
	-1.346819e+000,
	3.752080e-001,
	-1.055595e+000,
	-1.703680e-001,
	1.089771e+000,
	-1.041463e+001,
	-4.687545e+000,
	2.149733e+000,
	-1.118987e-001,
	3.558810e+000,
	8.741214e-001,
	-1.070779e+000,
	-1.445161e-001,
	6.385947e-001,
	1.695445e+001,
	-3.724275e+000,
	-3.465499e-002,
	3.645376e-001,
	3.232410e+000,
	6.285788e-001,
	// albedo 0, turbidity 5
	-1.297812e+000,
	-3.805039e-001,
	-1.474455e+000,
	1.558382e+000,
	-1.292485e-001,
	5.206238e-001,
	7.166147e-002,
	3.651150e+000,
	4.998781e-001,
	-1.680599e+000,
	-8.036751e-001,
	8.267015e-001,
	-2.109200e-001,
	-4.326451e-001,
	3.843930e-001,
	5.207142e-002,
	6.938520e-001,
	4.752346e-001,
	-8.467684e-001,
	1.620743e-001,
	-5.520307e-001,
	8.293798e-001,
	8.728132e-001,
	9.075147e-001,
	-1.734859e-001,
	7.815672e+000,
	1.126843e+000,
	-1.182658e+000,
	-3.290773e-001,
	1.442907e-001,
	-1.705529e+000,
	-1.186174e+001,
	-1.903040e-001,
	7.826049e-001,
	-1.497409e+000,
	2.238945e-001,
	-1.032316e+000,
	-1.590425e-001,
	9.289968e-001,
	1.217091e+001,
	1.274690e+000,
	1.400296e+000,
	-3.047612e-001,
	2.805729e+000,
	9.198989e-001,
	-1.073060e+000,
	-1.623303e-001,
	3.798836e-001,
	2.223272e+000,
	-4.660805e+000,
	-1.172357e-001,
	5.306455e-001,
	3.105520e+000,
	6.420864e-001,
	// albedo 0, turbidity 6
	-1.374072e+000,
	-4.453408e-001,
	-1.081601e+000,
	1.104314e+000,
	-1.730612e-001,
	5.074812e-001,
	5.784588e-002,
	3.488150e+000,
	5.037112e-001,
	-1.704606e+000,
	-8.629255e-001,
	-3.905040e-001,
	2.152742e+000,
	-6.716606e-001,
	5.638527e-001,
	-5.967161e-003,
	4.886292e-001,
	4.385432e-001,
	-9.651511e-001,
	1.186522e-001,
	3.421397e-001,
	-4.626814e+000,
	9.716770e-001,
	7.579588e-001,
	-1.064476e-002,
	8.154392e+000,
	1.103676e+000,
	-1.067172e+000,
	-3.214506e-001,
	-3.934660e-001,
	9.254630e+000,
	-3.599603e+000,
	-1.624031e-001,
	5.478446e-001,
	-2.781628e+000,
	2.905848e-001,
	-1.063218e+000,
	-1.412572e-001,
	8.153795e-001,
	-1.467486e+001,
	-2.020170e+000,
	1.094685e+000,
	7.786265e-002,
	3.719129e+000,
	8.826899e-001,
	-1.070058e+000,
	-1.684172e-001,
	2.225147e-001,
	2.345795e+001,
	-4.342429e+000,
	-4.661816e-002,
	3.545794e-001,
	3.051769e+000,
	6.567686e-001,
	// albedo 0, turbidity 7
	-1.397244e+000,
	-4.874379e-001,
	-2.217129e+000,
	2.415780e+000,
	-1.039290e-001,
	5.444596e-001,
	2.296795e-002,
	3.242776e+000,
	5.575920e-001,
	-1.943117e+000,
	-1.042293e+000,
	1.936194e+000,
	-7.807718e-001,
	-4.753317e-001,
	6.351817e-001,
	3.357824e-002,
	3.221570e-001,
	2.277390e-001,
	-1.007469e+000,
	4.283560e-002,
	-1.830583e+000,
	-1.613949e-001,
	5.103059e-001,
	1.830881e-001,
	-6.111472e-002,
	7.698471e+000,
	1.322151e+000,
	-9.885823e-001,
	-2.796329e-001,
	9.017585e-001,
	9.500529e-001,
	-8.751757e+000,
	5.198673e-001,
	6.111910e-001,
	-3.165369e+000,
	1.193651e-001,
	-1.105054e+000,
	-1.835801e-001,
	2.099263e-001,
	3.626436e+000,
	4.241807e-001,
	2.861915e-002,
	-3.245808e-002,
	3.560209e+000,
	9.581069e-001,
	-1.061783e+000,
	-1.955111e-001,
	3.405765e-001,
	1.682185e+001,
	-4.868111e+000,
	3.591669e-001,
	3.518670e-001,
	2.163473e+000,
	6.425305e-001,
	// albedo 0, turbidity 8
	-1.452178e+000,
	-5.662818e-001,
	-1.492883e+000,
	1.742373e+000,
	-1.894966e-001,
	6.129524e-001,
	2.370115e-006,
	3.042560e+000,
	7.988979e-001,
	-2.146318e+000,
	-1.176122e+000,
	1.480664e+000,
	1.846814e-001,
	-9.003192e-001,
	2.819986e-001,
	-6.858291e-003,
	5.447940e-001,
	-2.109028e-001,
	-1.465359e+000,
	-3.055025e-001,
	-1.747423e+000,
	-2.538335e+000,
	6.082904e-001,
	6.523133e-001,
	1.426957e-001,
	6.921276e+000,
	1.637843e+000,
	-7.135462e-001,
	-2.351046e-001,
	1.111445e+000,
	2.259275e+000,
	-7.853810e+000,
	-3.006083e-001,
	3.100486e-001,
	-4.047366e+000,
	-3.732308e-002,
	-1.188030e+000,
	-2.177467e-001,
	8.022451e-002,
	8.746107e+000,
	-6.824017e-001,
	5.968181e-001,
	7.024883e-002,
	3.164998e+000,
	9.909158e-001,
	-1.038065e+000,
	-1.989059e-001,
	1.630845e-001,
	1.261969e+001,
	-4.006594e+000,
	-3.213161e-001,
	3.948313e-001,
	2.040063e+000,
	6.364874e-001,
	// albedo 0, turbidity 9
	-1.789980e+000,
	-8.450140e-001,
	-2.591234e+000,
	2.769295e+000,
	-8.338896e-002,
	5.620741e-001,
	-8.271253e-006,
	2.531602e+000,
	9.001159e-001,
	-1.468080e+000,
	-7.426812e-001,
	2.369441e+000,
	-1.635443e+000,
	-3.560365e-001,
	2.130482e-001,
	-2.124886e-003,
	1.863478e+000,
	-3.426455e-001,
	-3.911974e+000,
	-1.873182e+000,
	-2.428294e+000,
	1.019786e+000,
	2.178584e-001,
	9.599962e-001,
	3.763471e-002,
	4.121844e+000,
	1.708236e+000,
	5.986629e-001,
	4.160930e-001,
	1.499968e+000,
	-4.234635e+000,
	-7.153272e+000,
	-8.777277e-001,
	4.276508e-001,
	-2.268730e+000,
	-9.278595e-002,
	-1.581111e+000,
	-5.414559e-001,
	3.449756e-002,
	2.095624e+001,
	-1.717086e+000,
	6.913385e-001,
	-1.227380e-001,
	1.401315e+000,
	9.723511e-001,
	-9.931334e-001,
	-2.191364e-001,
	1.647201e-001,
	2.954460e+000,
	-2.889774e+000,
	-4.261816e-001,
	4.166838e-001,
	1.370273e+000,
	6.561021e-001,
	// albedo 0, turbidity 10
	-2.368520e+000,
	-1.245557e+000,
	-3.473878e+000,
	3.511922e+000,
	-4.076311e-002,
	4.228576e-001,
	-8.136079e-006,
	2.268992e+000,
	9.001266e-001,
	-1.498984e+000,
	-9.483364e-001,
	2.970418e+000,
	-2.003511e+000,
	-3.005171e-001,
	3.242320e-001,
	6.724107e-003,
	1.693927e+000,
	-2.648941e-001,
	-6.258071e+000,
	-2.616781e+000,
	-3.186408e+000,
	-3.570416e-002,
	5.972101e-001,
	5.638927e-001,
	-8.227073e-002,
	3.805214e+000,
	1.486701e+000,
	7.183470e-001,
	-1.332710e-001,
	1.495243e+000,
	3.859652e+000,
	-5.605361e+000,
	3.808435e-001,
	4.998100e-001,
	-1.207866e+000,
	1.082917e-001,
	-1.422091e+000,
	-5.984032e-001,
	2.297508e-001,
	1.726780e+000,
	-6.684454e-001,
	-1.024912e+000,
	-1.967199e-001,
	-3.214571e-001,
	8.922300e-001,
	-1.018798e+000,
	-2.003211e-001,
	5.344788e-002,
	1.474717e+001,
	-4.025558e+000,
	9.010150e-001,
	3.605184e-001,
	1.504726e+000,
	6.720300e-001,
	// albedo 1, turbidity 1
	-1.150179e+000,
	-2.233430e-001,
	-6.725138e+000,
	7.601675e+000,
	-6.176639e-002,
	7.963802e-001,
	2.476816e-002,
	4.311811e+000,
	5.070506e-001,
	-1.184017e+000,
	-2.330060e-001,
	1.903877e-001,
	4.425206e-001,
	-1.173330e-001,
	2.459899e-001,
	6.799957e-002,
	5.710763e+000,
	4.639162e-001,
	-1.129855e+000,
	-2.313999e-001,
	3.299978e+000,
	-1.861830e+000,
	-3.626476e-001,
	1.858194e+000,
	-9.845844e-002,
	6.523143e-001,
	6.278178e-001,
	-1.090030e+000,
	-2.445577e-001,
	4.546659e-001,
	9.848860e-001,
	-4.044981e-001,
	3.532740e-001,
	1.409977e-001,
	-7.724273e-001,
	2.901711e-001,
	-1.048192e+000,
	-1.048720e-001,
	2.079951e+000,
	-7.519850e-002,
	-1.451911e+000,
	1.354243e+000,
	-1.508252e-001,
	4.159135e+000,
	8.685415e-001,
	-1.081709e+000,
	-1.496534e-001,
	1.433416e+000,
	-8.415186e-005,
	-3.147387e+000,
	6.964893e-002,
	1.345400e-001,
	3.372381e+000,
	5.369835e-001,
	// albedo 1, turbidity 2
	-1.163329e+000,
	-2.341078e-001,
	-8.084459e+000,
	8.765664e+000,
	-4.227908e-002,
	6.476384e-001,
	5.575993e-002,
	4.291594e+000,
	5.023286e-001,
	-1.234281e+000,
	-3.038288e-001,
	3.304120e+000,
	-2.565467e+000,
	-1.080261e-001,
	5.183037e-001,
	2.633070e-002,
	4.459108e+000,
	4.526356e-001,
	-1.015235e+000,
	-1.003890e-001,
	2.834337e-001,
	4.230399e-001,
	-4.060874e-001,
	1.119918e+000,
	-2.357803e-002,
	3.215664e+000,
	1.089777e+000,
	-1.171497e+000,
	-2.465867e-001,
	1.219344e+000,
	1.184120e+000,
	-6.451707e-002,
	1.087554e+000,
	1.687897e-001,
	4.111776e-001,
	2.471485e-001,
	-1.010262e+000,
	-1.337460e-001,
	1.953577e+000,
	-3.761183e+000,
	-7.089300e+000,
	5.963565e-001,
	-8.297304e-002,
	2.741114e+000,
	9.771003e-001,
	-1.102719e+000,
	-1.647974e-001,
	1.510508e+000,
	7.573412e+000,
	-3.431528e+000,
	3.953995e-001,
	6.793657e-002,
	2.744717e+000,
	5.018037e-001,
	// albedo 1, turbidity 3
	-1.186728e+000,
	-2.648685e-001,
	-7.540497e+000,
	8.152868e+000,
	-4.363040e-002,
	6.836829e-001,
	3.221451e-002,
	4.013046e+000,
	6.004295e-001,
	-1.302626e+000,
	-3.904258e-001,
	3.431819e+000,
	-2.975541e+000,
	-7.666020e-002,
	2.464561e-002,
	1.054528e-001,
	3.161765e+000,
	3.544185e-001,
	-9.615438e-001,
	-4.842098e-002,
	-4.756207e-001,
	9.408081e-001,
	-3.108222e-001,
	1.708814e+000,
	-1.241215e-001,
	4.416567e+000,
	1.207369e+000,
	-1.178731e+000,
	-1.824314e-001,
	8.266664e-001,
	1.001614e+000,
	3.024332e-001,
	3.291998e-002,
	4.178949e-001,
	2.532397e+000,
	2.014902e-001,
	-1.018913e+000,
	-2.016682e-001,
	2.132865e+000,
	-3.323938e+000,
	-8.751654e+000,
	1.240780e+000,
	-1.801214e-001,
	6.145479e-001,
	9.457932e-001,
	-1.101603e+000,
	-1.521834e-001,
	1.348807e+000,
	5.640453e+000,
	-2.695953e+000,
	-7.496627e-002,
	1.719606e-001,
	3.175091e+000,
	5.968939e-001,
	// albedo 1, turbidity 4
	-1.229694e+000,
	-3.167126e-001,
	-3.548352e+000,
	3.846155e+000,
	-5.028022e-002,
	5.061677e-001,
	7.498335e-002,
	3.626295e+000,
	4.999424e-001,
	-1.436439e+000,
	-5.562909e-001,
	8.010070e-001,
	3.290243e-001,
	-1.385772e-001,
	4.556269e-002,
	2.571935e-002,
	1.623385e+000,
	5.222220e-001,
	-8.876360e-001,
	5.717281e-002,
	4.713905e-001,
	-1.668970e+000,
	-3.199243e-001,
	2.050582e+000,
	-7.783980e-002,
	6.117601e+000,
	1.070445e+000,
	-1.235363e+000,
	-2.778190e-001,
	1.577638e-001,
	3.982457e+000,
	-2.266885e-002,
	-1.411004e+000,
	5.570462e-001,
	1.740426e-001,
	2.747952e-001,
	-9.785264e-001,
	-1.458813e-001,
	1.996989e+000,
	-7.517409e+000,
	-6.602487e+000,
	2.387711e+000,
	-1.996484e-001,
	2.112759e+000,
	9.289256e-001,
	-1.117781e+000,
	-1.699302e-001,
	1.214480e+000,
	1.141083e+001,
	-3.253445e+000,
	-8.156284e-001,
	2.248021e-001,
	2.860500e+000,
	6.151694e-001,
	// albedo 1, turbidity 5
	-1.290523e+000,
	-3.813116e-001,
	-6.728796e-001,
	1.007366e+000,
	-2.068030e-001,
	4.422499e-001,
	6.016254e-002,
	3.218056e+000,
	5.068822e-001,
	-1.614452e+000,
	-7.953309e-001,
	5.977485e-001,
	1.056365e+000,
	-8.402403e-001,
	3.713919e-001,
	3.164720e-002,
	-2.526630e-001,
	4.072481e-001,
	-8.377211e-001,
	2.276878e-001,
	-3.232539e-001,
	-2.390300e+000,
	2.127070e+000,
	7.169058e-001,
	-4.032313e-002,
	9.072383e+000,
	1.188019e+000,
	-1.226600e+000,
	-4.426177e-001,
	6.370202e-001,
	3.846913e+000,
	-1.128719e+001,
	3.667721e-002,
	5.000027e-001,
	-4.192432e+000,
	2.376054e-001,
	-9.852235e-001,
	-5.890324e-002,
	1.529937e+000,
	4.301220e+000,
	-1.839775e+000,
	8.993504e-001,
	-1.040866e-001,
	4.636528e+000,
	8.466710e-001,
	-1.118112e+000,
	-2.040213e-001,
	1.203227e+000,
	7.252102e+000,
	-4.515955e+000,
	-2.398231e-001,
	2.375855e-001,
	1.923160e+000,
	6.645269e-001,
	// albedo 1, turbidity 6
	-1.330626e+000,
	-4.272516e-001,
	-1.317682e+000,
	1.650847e+000,
	-1.192771e-001,
	4.904191e-001,
	4.074827e-002,
	3.015846e+000,
	5.271835e-001,
	-1.711989e+000,
	-8.644776e-001,
	4.057135e-001,
	9.037139e-001,
	-3.100084e-001,
	6.317697e-002,
	1.065625e-001,
	9.226240e-002,
	3.022474e-001,
	-8.465894e-001,
	1.652715e-001,
	-2.532361e-001,
	-2.422693e+000,
	3.144841e-001,
	1.839347e+000,
	-2.818162e-001,
	7.856667e+000,
	1.387977e+000,
	-1.192114e+000,
	-3.830569e-001,
	5.124751e-001,
	7.280034e+000,
	-2.610477e+000,
	-1.832768e+000,
	9.101904e-001,
	-3.349116e+000,
	-7.313079e-002,
	-1.011026e+000,
	-1.061217e-001,
	1.357854e+000,
	-1.496195e+001,
	-2.180975e+000,
	2.484329e+000,
	-3.239225e-001,
	3.899425e+000,
	1.179264e+000,
	-1.106228e+000,
	-1.927917e-001,
	1.179701e+000,
	2.379834e+001,
	-4.870211e+000,
	-1.290713e+000,
	2.854422e-001,
	2.078973e+000,
	5.128625e-001,
	// albedo 1, turbidity 7
	-1.342815e+000,
	-4.571984e-001,
	-1.803521e+000,
	2.229578e+000,
	-1.196587e-001,
	5.694038e-001,
	1.194687e-002,
	2.950110e+000,
	5.961719e-001,
	-1.937297e+000,
	-1.078823e+000,
	2.178495e+000,
	-1.251900e+000,
	-3.577875e-001,
	2.553915e-001,
	8.081142e-002,
	-4.723152e-001,
	1.174551e-001,
	-9.292675e-001,
	1.125551e-001,
	-1.708569e+000,
	1.832840e+000,
	5.150525e-001,
	9.287322e-001,
	-1.746780e-001,
	7.793815e+000,
	1.498832e+000,
	-1.058850e+000,
	-3.495292e-001,
	1.135259e+000,
	-4.069374e+000,
	-9.727412e+000,
	-7.670653e-001,
	7.550431e-001,
	-4.105064e+000,
	-5.149354e-002,
	-1.079472e+000,
	-1.399984e-001,
	1.058148e+000,
	1.392667e+001,
	-6.245343e-001,
	1.192083e+000,
	-2.578858e-001,
	4.030723e+000,
	1.025069e+000,
	-1.093159e+000,
	-2.150433e-001,
	1.210946e+000,
	3.349246e+000,
	-4.030345e+000,
	-5.362971e-001,
	2.886842e-001,
	1.192375e+000,
	6.363049e-001,
	// albedo 1, turbidity 8
	-1.408172e+000,
	-5.491538e-001,
	-1.360219e+000,
	1.738150e+000,
	-1.505117e-001,
	6.030014e-001,
	-6.866289e-006,
	2.656101e+000,
	9.001849e-001,
	-2.171702e+000,
	-1.231851e+000,
	1.860400e+000,
	3.613146e-002,
	-7.300078e-001,
	1.974371e-001,
	-5.351202e-003,
	-1.443434e-001,
	-3.779605e-001,
	-1.284657e+000,
	-1.935945e-001,
	-1.494185e+000,
	-2.070689e+000,
	2.974020e-001,
	8.048383e-001,
	1.097715e-001,
	6.907960e+000,
	1.819367e+000,
	-8.288598e-001,
	-3.374917e-001,
	1.029011e+000,
	1.347088e+000,
	-7.655126e+000,
	-8.232335e-001,
	3.722934e-001,
	-4.847675e+000,
	-1.864913e-001,
	-1.146031e+000,
	-1.480097e-001,
	1.051391e+000,
	8.396865e+000,
	-1.407010e+000,
	1.240651e+000,
	-3.942068e-002,
	3.291458e+000,
	1.060212e+000,
	-1.069599e+000,
	-2.047532e-001,
	9.437765e-001,
	1.189879e+001,
	-4.026750e+000,
	-9.372092e-001,
	2.463501e-001,
	1.782902e+000,
	6.235027e-001,
	// albedo 1, turbidity 9
	-1.793508e+000,
	-8.986075e-001,
	-2.346395e+000,
	2.775625e+000,
	-7.052213e-002,
	5.349215e-001,
	-7.457456e-006,
	1.901248e+000,
	9.001358e-001,
	-1.629402e+000,
	-8.273410e-001,
	2.270930e+000,
	-1.125114e+000,
	-3.562854e-001,
	1.948044e-001,
	1.703882e-003,
	1.426305e+000,
	-3.737234e-001,
	-3.443431e+000,
	-1.686429e+000,
	-1.515036e+000,
	-6.941862e-001,
	4.976814e-001,
	1.144483e+000,
	-4.277285e-002,
	3.662107e+000,
	1.819972e+000,
	3.138150e-001,
	2.426714e-001,
	7.717995e-001,
	2.759520e+000,
	-7.216077e+000,
	-1.389093e+000,
	5.332838e-001,
	-2.316313e+000,
	-2.636593e-001,
	-1.449802e+000,
	-4.017798e-001,
	1.133688e+000,
	2.114337e+000,
	6.227965e-002,
	1.378688e+000,
	-1.759313e-001,
	9.446579e-001,
	1.165017e+000,
	-1.049420e+000,
	-2.614006e-001,
	9.473363e-001,
	1.531288e+001,
	-4.714989e+000,
	-8.992715e-001,
	2.423509e-001,
	9.148027e-001,
	5.650972e-001,
	// albedo 1, turbidity 10
	-2.382332e+000,
	-1.290760e+000,
	-3.316114e+000,
	3.587059e+000,
	-3.748522e-002,
	4.468493e-001,
	-7.212198e-006,
	1.789208e+000,
	9.001267e-001,
	-1.333339e+000,
	-9.355999e-001,
	3.281313e+000,
	-2.263103e+000,
	-2.499164e-001,
	1.591742e-001,
	8.117981e-003,
	1.345396e+000,
	-2.689053e-001,
	-6.612658e+000,
	-2.809230e+000,
	-2.744061e+000,
	1.005261e+000,
	4.216309e-001,
	1.055067e+000,
	-9.021558e-002,
	2.940833e+000,
	1.495270e+000,
	1.251113e+000,
	5.915517e-002,
	1.142846e+000,
	-2.807371e-001,
	-5.335452e+000,
	-6.967012e-001,
	5.129558e-001,
	-5.264483e-001,
	1.137786e-001,
	-1.517768e+000,
	-5.807447e-001,
	1.179477e+000,
	1.252252e+001,
	-2.305973e+000,
	2.184822e-001,
	-3.092917e-001,
	-1.524373e+000,
	8.724218e-001,
	-1.037889e+000,
	-2.065780e-001,
	6.479897e-001,
	4.786848e-002,
	-2.348244e+000,
	-3.053490e-002,
	4.059549e-001,
	1.313102e+000,
	6.713422e-001,
};

double datasetRad520[] = 
{
	// albedo 0, turbidity 1
	1.181575e-001,
	1.246023e-001,
	-1.496294e-002,
	1.265571e+000,
	5.482287e-001,
	7.505452e-001,
	// albedo 0, turbidity 2
	1.160347e-001,
	1.329016e-001,
	-8.180703e-002,
	1.418742e+000,
	5.748010e-001,
	7.627669e-001,
	// albedo 0, turbidity 3
	1.101719e-001,
	1.655258e-001,
	-2.430655e-001,
	1.733940e+000,
	5.362119e-001,
	8.264630e-001,
	// albedo 0, turbidity 4
	1.022463e-001,
	1.983788e-001,
	-4.272497e-001,
	2.067266e+000,
	6.024013e-001,
	8.848645e-001,
	// albedo 0, turbidity 5
	9.401543e-002,
	2.296749e-001,
	-5.842591e-001,
	2.315439e+000,
	6.927636e-001,
	9.577504e-001,
	// albedo 0, turbidity 6
	8.955011e-002,
	2.492320e-001,
	-6.780498e-001,
	2.434256e+000,
	7.757295e-001,
	1.006068e+000,
	// albedo 0, turbidity 7
	8.389384e-002,
	2.633396e-001,
	-7.506875e-001,
	2.457562e+000,
	1.011233e+000,
	1.057894e+000,
	// albedo 0, turbidity 8
	7.664395e-002,
	2.660639e-001,
	-7.551246e-001,
	2.244514e+000,
	1.510373e+000,
	1.106036e+000,
	// albedo 0, turbidity 9
	6.960593e-002,
	2.348760e-001,
	-6.096824e-001,
	1.645028e+000,
	2.296756e+000,
	1.213901e+000,
	// albedo 0, turbidity 10
	6.281555e-002,
	1.600404e-001,
	-2.694273e-001,
	5.733989e-001,
	3.363154e+000,
	1.382931e+000,
	// albedo 1, turbidity 1
	1.293373e-001,
	1.448979e-001,
	-1.489032e-002,
	1.190124e+000,
	1.374518e+000,
	1.715324e+000,
	// albedo 1, turbidity 2
	1.257474e-001,
	1.593917e-001,
	-9.494839e-002,
	1.358060e+000,
	1.387390e+000,
	1.759057e+000,
	// albedo 1, turbidity 3
	1.205675e-001,
	1.785796e-001,
	-2.085014e-001,
	1.577640e+000,
	1.442267e+000,
	1.810434e+000,
	// albedo 1, turbidity 4
	1.120654e-001,
	2.046914e-001,
	-3.577105e-001,
	1.820708e+000,
	1.593538e+000,
	1.871408e+000,
	// albedo 1, turbidity 5
	1.051588e-001,
	2.239942e-001,
	-4.688978e-001,
	1.950392e+000,
	1.793172e+000,
	1.930285e+000,
	// albedo 1, turbidity 6
	1.008210e-001,
	2.326341e-001,
	-5.167178e-001,
	1.966038e+000,
	1.965523e+000,
	1.957849e+000,
	// albedo 1, turbidity 7
	9.476285e-002,
	2.429074e-001,
	-5.647231e-001,
	1.916956e+000,
	2.246725e+000,
	2.009022e+000,
	// albedo 1, turbidity 8
	8.751265e-002,
	2.310627e-001,
	-5.147987e-001,
	1.576738e+000,
	2.834201e+000,
	2.015610e+000,
	// albedo 1, turbidity 9
	8.015871e-002,
	1.955507e-001,
	-3.514813e-001,
	9.234911e-001,
	3.616998e+000,
	2.073327e+000,
	// albedo 1, turbidity 10
	7.117381e-002,
	1.228804e-001,
	-3.803469e-002,
	-7.371653e-002,
	4.495822e+000,
	2.179633e+000,
};

double dataset560[] = 
{
	// albedo 0, turbidity 1
	-1.121223e+000,
	-1.710187e-001,
	-1.383038e+001,
	1.475343e+001,
	-3.137953e-002,
	1.035662e+000,
	4.060064e-002,
	5.222551e+000,
	5.001051e-001,
	-1.172565e+000,
	-1.880874e-001,
	7.283594e+000,
	-5.774643e+000,
	-9.051333e-002,
	9.108126e-001,
	-1.565410e-002,
	6.194404e+000,
	4.688599e-001,
	-1.124108e+000,
	-3.082835e-001,
	-2.179926e-001,
	1.330167e+000,
	-4.502254e-001,
	1.470140e+000,
	4.202392e-004,
	-4.724308e+000,
	1.134678e+000,
	-1.079809e+000,
	-9.226814e-002,
	1.465364e+000,
	1.348856e+000,
	4.357794e-001,
	1.771543e+000,
	8.121383e-003,
	6.057395e+000,
	2.462141e-001,
	-1.086667e+000,
	-2.709889e-001,
	2.249152e+000,
	-3.177505e+000,
	-7.138130e+000,
	1.112553e+000,
	-9.718434e-003,
	-2.392239e+000,
	9.352768e-001,
	-1.071154e+000,
	-1.272150e-001,
	1.644374e+000,
	4.326598e+000,
	-2.244682e+000,
	1.611051e+000,
	7.835546e-003,
	3.213282e+000,
	6.580432e-001,
	// albedo 0, turbidity 2
	-1.133883e+000,
	-1.835049e-001,
	-1.232301e+001,
	1.307796e+001,
	-3.760123e-002,
	1.051162e+000,
	3.392954e-002,
	5.319376e+000,
	6.501601e-001,
	-1.116119e+000,
	-1.457114e-001,
	5.436576e+000,
	-5.114276e+000,
	-7.178414e-002,
	2.658168e-001,
	1.603756e-001,
	7.619379e+000,
	3.112698e-001,
	-1.215552e+000,
	-3.391607e-001,
	4.502377e-001,
	1.281602e+000,
	-4.095778e-001,
	2.374058e+000,
	-1.988430e-001,
	-3.809377e+000,
	1.254846e+000,
	-9.657094e-001,
	3.858547e-002,
	3.324554e-001,
	1.541740e+000,
	6.029572e-001,
	2.346414e-001,
	3.902458e-001,
	7.263050e+000,
	1.353991e-001,
	-1.152042e+000,
	-3.155103e-001,
	2.163244e+000,
	-5.230832e+000,
	-7.443608e+000,
	2.247834e+000,
	-1.632216e-001,
	-1.725315e+000,
	1.034709e+000,
	-1.051862e+000,
	-1.310458e-001,
	1.554942e+000,
	1.063510e+001,
	-3.558989e+000,
	6.764257e-001,
	1.428912e-001,
	2.541641e+000,
	5.000389e-001,
	// albedo 0, turbidity 3
	-1.156925e+000,
	-2.104634e-001,
	-1.793090e+001,
	1.817524e+001,
	-1.225514e-002,
	6.518753e-001,
	1.085708e-001,
	4.947239e+000,
	5.635117e-001,
	-1.183783e+000,
	-2.187288e-001,
	5.860654e+000,
	-5.643960e+000,
	-4.453459e-002,
	6.724995e-001,
	1.698133e-002,
	6.742131e+000,
	6.353553e-001,
	-1.143101e+000,
	-2.644541e-001,
	9.354577e-001,
	9.256854e-001,
	-1.074845e-001,
	1.663131e+000,
	4.998918e-002,
	-2.049721e+000,
	8.150826e-001,
	-1.021102e+000,
	2.478746e-002,
	-1.367363e+000,
	-9.011684e-002,
	-5.001730e-001,
	4.316685e-002,
	3.952231e-001,
	8.084754e+000,
	5.380131e-001,
	-1.101145e+000,
	-2.731481e-001,
	2.483816e+000,
	3.581780e-001,
	4.249615e-001,
	2.284087e+000,
	-5.836688e-002,
	-1.651434e+000,
	7.685430e-001,
	-1.073863e+000,
	-1.705854e-001,
	1.169673e+000,
	-2.183705e-003,
	-5.007439e+000,
	2.318154e-001,
	2.738714e-001,
	2.187327e+000,
	6.676882e-001,
	// albedo 0, turbidity 4
	-1.207581e+000,
	-2.653224e-001,
	-9.004497e+000,
	8.985720e+000,
	-9.024461e-003,
	4.273132e-001,
	1.378091e-001,
	4.307648e+000,
	5.309421e-001,
	-1.278614e+000,
	-3.516334e-001,
	2.489304e+000,
	-1.840089e+000,
	-6.293646e-002,
	8.426903e-001,
	-7.266949e-002,
	4.434869e+000,
	7.077739e-001,
	-1.150333e+000,
	-2.033123e-001,
	8.150312e-001,
	-7.926382e-001,
	-3.230951e-001,
	1.291679e+000,
	1.822329e-001,
	1.619133e+000,
	7.522432e-001,
	-1.002248e+000,
	-3.092969e-002,
	-1.092273e+000,
	2.820671e+000,
	4.504455e-001,
	-5.121048e-001,
	4.229688e-001,
	4.037073e+000,
	5.843543e-001,
	-1.087962e+000,
	-2.434172e-001,
	1.817322e+000,
	-6.031774e+000,
	-4.873903e+000,
	2.094606e+000,
	1.184743e-001,
	2.293346e-001,
	7.283940e-001,
	-1.072272e+000,
	-1.614715e-001,
	8.337136e-001,
	1.086866e+001,
	-3.373042e+000,
	2.260332e-002,
	2.622468e-001,
	2.470766e+000,
	7.078601e-001,
	// albedo 0, turbidity 5
	-1.263850e+000,
	-3.278851e-001,
	-5.336400e+000,
	5.102832e+000,
	2.070020e-003,
	3.605369e-001,
	1.633426e-001,
	3.790121e+000,
	4.999503e-001,
	-1.507623e+000,
	-6.465694e-001,
	-2.983753e+000,
	4.212027e+000,
	-5.868795e-002,
	3.852488e-001,
	-7.222995e-002,
	1.042808e+000,
	6.632120e-001,
	-1.041397e+000,
	6.326589e-002,
	3.860471e+000,
	-5.579882e+000,
	-1.730201e-001,
	2.303753e+000,
	6.102393e-002,
	7.287763e+000,
	8.916057e-001,
	-1.049861e+000,
	-2.836044e-001,
	-2.302537e+000,
	6.724969e+000,
	4.373598e-001,
	-2.422514e+000,
	6.952438e-001,
	-2.633600e+000,
	4.070954e-001,
	-1.054117e+000,
	-1.206625e-001,
	1.764625e+000,
	-9.467716e+000,
	-3.436987e+000,
	3.394707e+000,
	-8.149683e-002,
	3.485918e+000,
	8.515716e-001,
	-1.072517e+000,
	-1.574135e-001,
	2.214599e-001,
	1.331766e+001,
	-3.915381e+000,
	-1.229973e+000,
	6.267275e-001,
	2.923262e+000,
	6.516824e-001,
	// albedo 0, turbidity 6
	-1.293503e+000,
	-3.676147e-001,
	-1.323095e+001,
	1.301713e+001,
	-3.471894e-004,
	3.957986e-001,
	1.317480e-001,
	3.616827e+000,
	4.998510e-001,
	-1.757697e+000,
	-8.202513e-001,
	2.560133e+000,
	-1.337734e+000,
	-3.413795e-002,
	5.633043e-001,
	-4.355758e-002,
	7.324869e-001,
	5.728008e-001,
	-8.814599e-001,
	9.828960e-002,
	-2.701428e-001,
	-1.298657e+000,
	-6.721423e-002,
	1.581675e+000,
	4.095024e-002,
	6.548913e+000,
	9.726866e-001,
	-1.125663e+000,
	-2.625873e-001,
	-2.797592e-001,
	2.848739e+000,
	-3.363778e-002,
	-1.672768e+000,
	7.349952e-001,
	-1.708628e+000,
	3.557813e-001,
	-1.044841e+000,
	-1.712889e-001,
	7.091708e-001,
	-4.275119e+000,
	-7.565130e-001,
	2.483873e+000,
	-7.781321e-002,
	2.667776e+000,
	8.709126e-001,
	-1.067360e+000,
	-1.543712e-001,
	3.884866e-001,
	6.915851e+000,
	-4.250734e+000,
	-6.525729e-001,
	6.368377e-001,
	2.671865e+000,
	6.566986e-001,
	// albedo 0, turbidity 7
	-1.360356e+000,
	-4.336026e-001,
	-1.442967e+001,
	1.428579e+001,
	-3.990325e-003,
	4.600126e-001,
	1.023159e-001,
	3.367805e+000,
	4.999150e-001,
	-2.054147e+000,
	-1.064745e+000,
	-7.857491e-001,
	2.214734e+000,
	-3.764113e-002,
	8.504761e-001,
	-4.222958e-002,
	1.091377e-001,
	4.732161e-001,
	-8.953952e-001,
	1.048085e-001,
	1.481293e+000,
	-4.223012e+000,
	-4.164160e-002,
	5.999023e-001,
	6.310005e-002,
	7.156883e+000,
	1.066682e+000,
	-1.030251e+000,
	-2.777709e-001,
	-8.361086e-001,
	5.611154e+000,
	1.861240e-001,
	-5.823197e-001,
	6.716210e-001,
	-3.269717e+000,
	2.922029e-001,
	-1.095631e+000,
	-1.966849e-001,
	6.300566e-001,
	-7.129591e+000,
	-7.351951e-001,
	1.400340e+000,
	-6.997516e-003,
	2.879018e+000,
	8.879337e-001,
	-1.052935e+000,
	-1.551958e-001,
	2.334578e-001,
	1.040948e+001,
	-4.426381e+000,
	-3.477323e-001,
	6.257070e-001,
	2.451148e+000,
	6.570737e-001,
	// albedo 0, turbidity 8
	-1.382656e+000,
	-4.830539e-001,
	-1.107403e+001,
	1.127854e+001,
	-2.723641e-002,
	8.478005e-001,
	2.907652e-003,
	3.290364e+000,
	7.398950e-001,
	-2.230895e+000,
	-1.163446e+000,
	-1.001991e+001,
	1.125340e+001,
	-3.233871e-002,
	3.041577e-001,
	3.870458e-003,
	3.463879e-001,
	-8.829082e-002,
	-1.489234e+000,
	-3.402035e-001,
	2.948409e+000,
	-8.098077e+000,
	9.078299e-002,
	-3.179835e-001,
	4.730321e-001,
	6.765707e+000,
	1.440217e+000,
	-6.206234e-001,
	-1.701007e-001,
	-7.346357e-002,
	9.350033e+000,
	1.548964e-001,
	1.313206e+000,
	-1.479143e-001,
	-5.119165e+000,
	1.854277e-001,
	-1.226372e+000,
	-2.128299e-001,
	-1.643093e-001,
	-9.382334e+000,
	-4.857784e-001,
	-1.374948e-001,
	5.877245e-001,
	3.862307e+000,
	8.700125e-001,
	-1.030598e+000,
	-1.931668e-001,
	3.691403e-001,
	1.066393e+001,
	-4.244968e+000,
	-5.872571e-002,
	4.193140e-001,
	1.461878e+000,
	6.699478e-001,
	// albedo 0, turbidity 9
	-1.606656e+000,
	-7.140209e-001,
	-1.149565e+001,
	1.168427e+001,
	-2.245577e-002,
	7.718953e-001,
	-8.349882e-006,
	2.654449e+000,
	9.001224e-001,
	-2.100494e+000,
	-1.013602e+000,
	-1.638934e+001,
	1.729185e+001,
	-1.580924e-002,
	5.038208e-002,
	-1.628735e-002,
	1.762584e+000,
	-3.121794e-001,
	-3.228292e+000,
	-1.459508e+000,
	7.424519e+000,
	-1.194272e+001,
	4.931054e-002,
	6.493074e-001,
	3.590561e-001,
	4.068321e+000,
	1.613039e+000,
	1.278814e-001,
	4.010913e-002,
	-2.185675e+000,
	1.164548e+001,
	2.706306e-002,
	1.632886e-001,
	-1.090111e-002,
	-3.342580e+000,
	1.916992e-002,
	-1.400278e+000,
	-2.825658e-001,
	4.168149e-001,
	-1.195909e+001,
	-1.122968e-002,
	1.863328e-001,
	4.263033e-001,
	2.270053e+000,
	9.748449e-001,
	-1.017511e+000,
	-2.884028e-001,
	3.544996e-001,
	1.535118e+001,
	-5.009184e+000,
	1.511064e-001,
	2.916578e-001,
	7.889658e-001,
	6.294910e-001,
	// albedo 0, turbidity 10
	-2.031136e+000,
	-1.076357e+000,
	-8.660773e+000,
	8.800317e+000,
	-2.370842e-002,
	5.736027e-001,
	-8.441313e-006,
	2.248669e+000,
	9.001280e-001,
	-1.270967e+000,
	-7.828844e-001,
	-1.198232e+001,
	1.262753e+001,
	-1.509989e-002,
	1.663438e-001,
	2.440939e-004,
	2.068640e+000,
	-2.521574e-001,
	-6.600872e+000,
	-2.689874e+000,
	6.453928e+000,
	-9.592747e+000,
	-3.551170e-002,
	1.325662e+000,
	-1.894375e-002,
	3.506163e+000,
	1.469724e+000,
	7.961323e-001,
	-1.989144e-001,
	-2.685238e+000,
	1.034230e+001,
	2.076702e-001,
	-7.692350e-001,
	6.184894e-001,
	-1.969413e+000,
	3.842922e-002,
	-1.459073e+000,
	-4.964034e-001,
	1.060127e+000,
	-1.277712e+001,
	-9.634553e-001,
	5.610879e-001,
	-2.034286e-001,
	3.525910e-001,
	1.003048e+000,
	-1.021565e+000,
	-2.553022e-001,
	6.367571e-002,
	2.028825e+001,
	-4.623219e+000,
	-2.400428e-002,
	4.251423e-001,
	9.640897e-001,
	6.080298e-001,
	// albedo 1, turbidity 1
	-1.121224e+000,
	-1.710171e-001,
	-1.383038e+001,
	1.475343e+001,
	-3.137812e-002,
	1.035662e+000,
	4.060006e-002,
	5.222551e+000,
	5.001051e-001,
	-1.172565e+000,
	-1.880857e-001,
	7.283595e+000,
	-5.774643e+000,
	-9.051285e-002,
	9.108124e-001,
	-1.565627e-002,
	6.194404e+000,
	4.688599e-001,
	-1.124109e+000,
	-3.082816e-001,
	-2.179926e-001,
	1.330167e+000,
	-4.502252e-001,
	1.470140e+000,
	4.158616e-004,
	-4.724308e+000,
	1.134678e+000,
	-1.079810e+000,
	-9.226583e-002,
	1.465364e+000,
	1.348856e+000,
	4.357794e-001,
	1.771543e+000,
	8.115381e-003,
	6.057395e+000,
	2.462140e-001,
	-1.086668e+000,
	-2.709863e-001,
	2.249153e+000,
	-3.177505e+000,
	-7.138130e+000,
	1.112553e+000,
	-9.724210e-003,
	-2.392239e+000,
	9.352768e-001,
	-1.071158e+000,
	-1.272123e-001,
	1.644374e+000,
	4.326598e+000,
	-2.244682e+000,
	1.611051e+000,
	7.831866e-003,
	3.213282e+000,
	6.580432e-001,
	// albedo 1, turbidity 2
	-1.125449e+000,
	-1.733403e-001,
	-1.228038e+001,
	1.311695e+001,
	-3.541409e-002,
	1.005494e+000,
	4.147852e-002,
	5.316886e+000,
	6.051699e-001,
	-1.101273e+000,
	-1.422106e-001,
	5.484715e+000,
	-5.089835e+000,
	-6.655928e-002,
	2.076815e-001,
	1.633101e-001,
	7.624535e+000,
	3.044941e-001,
	-1.213425e+000,
	-3.085010e-001,
	5.550585e-001,
	1.302798e+000,
	-3.946488e-001,
	2.285152e+000,
	-1.925101e-001,
	-3.790065e+000,
	1.263207e+000,
	-9.610579e-001,
	9.458093e-003,
	5.293256e-001,
	1.553214e+000,
	6.053752e-001,
	1.172267e-001,
	3.674690e-001,
	7.305350e+000,
	1.509544e-001,
	-1.119731e+000,
	-2.765693e-001,
	2.433951e+000,
	-5.229810e+000,
	-7.449777e+000,
	2.123304e+000,
	-2.242917e-001,
	-1.669115e+000,
	1.041008e+000,
	-1.094324e+000,
	-1.418743e-001,
	1.836224e+000,
	1.063054e+001,
	-3.561209e+000,
	5.916534e-001,
	9.296571e-002,
	2.600060e+000,
	4.999316e-001,
	// albedo 1, turbidity 3
	-1.155818e+000,
	-2.162981e-001,
	-2.560068e+001,
	2.636088e+001,
	-1.382944e-002,
	8.101983e-001,
	4.709210e-002,
	4.301909e+000,
	6.416958e-001,
	-1.171460e+000,
	-1.866443e-001,
	8.497645e+000,
	-8.396229e+000,
	-3.345417e-002,
	2.960022e-001,
	7.985279e-002,
	7.420544e+000,
	5.552152e-001,
	-1.114385e+000,
	-2.963805e-001,
	5.955009e-002,
	2.320529e+000,
	-7.649266e-002,
	2.277940e+000,
	-5.942479e-002,
	-4.040964e+000,
	9.588558e-001,
	-1.070647e+000,
	4.194546e-002,
	-5.701942e-001,
	-1.001278e+000,
	-3.389615e-001,
	-8.559533e-001,
	5.070784e-001,
	9.805560e+000,
	3.529747e-001,
	-1.057912e+000,
	-2.733753e-001,
	3.080618e+000,
	7.477366e-001,
	3.484876e-001,
	2.214994e+000,
	-2.597625e-001,
	-2.842961e+000,
	9.178917e-001,
	-1.105636e+000,
	-1.815423e-001,
	1.651373e+000,
	-2.553941e-003,
	-5.008441e+000,
	-6.378055e-001,
	2.370503e-001,
	1.890656e+000,
	6.018255e-001,
	// albedo 1, turbidity 4
	-1.194221e+000,
	-2.570801e-001,
	-8.919095e+000,
	9.380192e+000,
	-2.650470e-002,
	6.233645e-001,
	6.663964e-002,
	4.027438e+000,
	6.125383e-001,
	-1.308216e+000,
	-3.781794e-001,
	2.369107e+000,
	-1.977066e+000,
	-4.079773e-002,
	1.443960e-001,
	8.206719e-002,
	3.465933e+000,
	5.442867e-001,
	-1.048459e+000,
	-1.617720e-001,
	1.015136e+000,
	-2.989579e-001,
	-2.764989e-001,
	2.427990e+000,
	-1.147612e-001,
	1.522921e+000,
	1.041410e+000,
	-1.105796e+000,
	-4.826962e-002,
	-8.419705e-001,
	3.285981e+000,
	7.975109e-001,
	-1.954456e+000,
	7.424696e-001,
	4.604902e+000,
	2.602059e-001,
	-1.033856e+000,
	-2.507382e-001,
	2.882633e+000,
	-8.250912e+000,
	-6.878129e+000,
	2.948966e+000,
	-2.850302e-001,
	-8.253849e-001,
	9.844934e-001,
	-1.125219e+000,
	-1.879003e-001,
	1.474838e+000,
	1.453266e+001,
	-3.271910e+000,
	-1.231579e+000,
	2.397524e-001,
	1.654932e+000,
	5.625696e-001,
	// albedo 1, turbidity 5
	-1.246640e+000,
	-3.202274e-001,
	-6.355032e+000,
	6.364143e+000,
	9.028376e-004,
	3.146975e-001,
	1.550718e-001,
	3.413749e+000,
	4.999065e-001,
	-1.477471e+000,
	-5.819223e-001,
	1.329471e+000,
	-2.694229e-001,
	-4.575905e-002,
	5.087866e-001,
	-6.857139e-002,
	1.810092e+000,
	6.318693e-001,
	-1.046136e+000,
	-6.763679e-002,
	6.725076e-001,
	-1.036786e+000,
	-3.192799e-001,
	1.724205e+000,
	6.468388e-002,
	3.953855e+000,
	9.417528e-001,
	-1.033910e+000,
	-1.295544e-001,
	-4.551294e-001,
	2.659205e+000,
	8.887235e-001,
	-1.733153e+000,
	6.540117e-001,
	8.046523e-001,
	3.597443e-001,
	-1.094530e+000,
	-2.282012e-001,
	2.298267e+000,
	-5.184881e+000,
	-6.122309e+000,
	2.590799e+000,
	-1.618707e-001,
	1.116033e+000,
	8.867666e-001,
	-1.095556e+000,
	-1.807112e-001,
	1.406193e+000,
	8.120385e+000,
	-3.058239e+000,
	-1.121150e+000,
	2.933606e-001,
	1.488339e+000,
	6.374827e-001,
	// albedo 1, turbidity 6
	-1.270123e+000,
	-3.552595e-001,
	-8.975893e+000,
	9.110080e+000,
	-3.388207e-003,
	3.559109e-001,
	1.201097e-001,
	3.109904e+000,
	4.998957e-001,
	-1.663376e+000,
	-7.846840e-001,
	6.951405e-001,
	3.139107e-001,
	-2.448004e-002,
	3.572505e-001,
	1.453572e-002,
	6.307761e-001,
	5.142914e-001,
	-9.518772e-001,
	7.764573e-002,
	1.247094e+000,
	-2.224855e+000,
	-1.195310e-001,
	1.709581e+000,
	-8.836329e-002,
	5.688916e+000,
	1.113629e+000,
	-1.087154e+000,
	-2.665646e-001,
	-8.624251e-001,
	4.536060e+000,
	4.180650e-001,
	-1.629798e+000,
	8.479560e-001,
	-1.293696e+000,
	1.869693e-001,
	-1.064826e+000,
	-1.599892e-001,
	2.285337e+000,
	-8.584887e+000,
	-3.074560e+000,
	2.139459e+000,
	-2.592372e-001,
	1.937577e+000,
	9.957954e-001,
	-1.099622e+000,
	-1.849797e-001,
	1.193609e+000,
	1.416481e+001,
	-5.009527e+000,
	-8.592493e-001,
	3.485606e-001,
	1.884203e+000,
	6.097274e-001,
	// albedo 1, turbidity 7
	-1.344841e+000,
	-4.339942e-001,
	-9.193112e+000,
	9.385864e+000,
	-9.742818e-003,
	4.812040e-001,
	7.690647e-002,
	2.843801e+000,
	5.228047e-001,
	-1.975928e+000,
	-1.042040e+000,
	9.695714e-001,
	3.718000e-001,
	-3.334078e-002,
	1.333620e-001,
	8.180282e-002,
	-1.652429e-001,
	3.267010e-001,
	-8.651864e-001,
	1.288722e-001,
	6.811456e-001,
	-3.282787e+000,
	-9.074685e-002,
	1.894059e+000,
	-1.849744e-001,
	6.610614e+000,
	1.322978e+000,
	-1.103780e+000,
	-3.279618e-001,
	-4.193802e-001,
	7.331165e+000,
	6.529659e-001,
	-2.227297e+000,
	9.625482e-001,
	-3.348971e+000,
	-7.261722e-003,
	-1.055963e+000,
	-1.527328e-001,
	1.786114e+000,
	-1.367578e+001,
	-3.450729e+000,
	2.641691e+000,
	-3.229222e-001,
	2.800131e+000,
	1.129409e+000,
	-1.111541e+000,
	-2.123518e-001,
	1.286159e+000,
	2.297563e+001,
	-4.591526e+000,
	-1.374672e+000,
	3.462811e-001,
	1.071127e+000,
	5.498514e-001,
	// albedo 1, turbidity 8
	-1.387544e+000,
	-4.964558e-001,
	-9.744778e+000,
	1.014533e+001,
	-2.463089e-002,
	7.188705e-001,
	3.919951e-003,
	2.760792e+000,
	7.369418e-001,
	-2.206536e+000,
	-1.191342e+000,
	-2.244384e+000,
	3.629413e+000,
	-3.601610e-002,
	7.725349e-002,
	5.357588e-002,
	-2.692147e-001,
	-1.142476e-001,
	-1.358286e+000,
	-2.268740e-001,
	9.805731e-001,
	-5.163195e+000,
	-8.589000e-003,
	7.697565e-001,
	2.198750e-001,
	7.029301e+000,
	1.567170e+000,
	-7.167767e-001,
	-2.969978e-001,
	2.300987e-001,
	7.956088e+000,
	6.339728e-001,
	-6.195374e-001,
	2.502844e-001,
	-6.307569e+000,
	-2.208822e-002,
	-1.210525e+000,
	-1.245541e-001,
	9.742409e-001,
	-9.705683e+000,
	-1.658899e+000,
	1.365829e+000,
	2.003500e-001,
	4.400174e+000,
	1.042345e+000,
	-1.061524e+000,
	-2.323500e-001,
	1.284880e+000,
	1.294836e+001,
	-5.011732e+000,
	-9.141086e-001,
	2.723804e-001,
	6.225528e-001,
	6.030977e-001,
	// albedo 1, turbidity 9
	-1.548946e+000,
	-6.802676e-001,
	-1.274231e+001,
	1.312954e+001,
	-1.834225e-002,
	7.051580e-001,
	-8.330446e-006,
	2.320435e+000,
	9.001244e-001,
	-1.867128e+000,
	-9.670210e-001,
	-6.847422e+000,
	7.952765e+000,
	-1.985986e-002,
	1.690548e-002,
	-1.176902e-002,
	8.988469e-001,
	-3.242269e-001,
	-3.470633e+000,
	-1.555121e+000,
	2.684966e+000,
	-5.964736e+000,
	-5.524158e-003,
	1.187089e+000,
	2.552534e-001,
	4.394076e+000,
	1.656399e+000,
	4.095837e-001,
	1.440005e-001,
	-5.602190e-001,
	7.110869e+000,
	2.313366e-001,
	-1.373206e+000,
	1.973962e-001,
	-4.112998e+000,
	-5.877027e-002,
	-1.540633e+000,
	-3.264234e-001,
	1.072405e+000,
	-7.205546e+000,
	-5.125251e-001,
	2.009905e+000,
	1.531985e-001,
	2.113439e+000,
	1.042547e+000,
	-1.013330e+000,
	-2.663837e-001,
	1.168934e+000,
	9.315778e+000,
	-4.320502e+000,
	-1.303393e+000,
	2.825872e-001,
	2.365015e-001,
	5.993344e-001,
	// albedo 1, turbidity 10
	-2.055426e+000,
	-1.093229e+000,
	-3.487182e+000,
	3.753855e+000,
	-4.639837e-002,
	5.797714e-001,
	-8.056992e-006,
	1.916262e+000,
	9.001298e-001,
	-1.643864e+000,
	-9.676934e-001,
	-1.147133e+001,
	1.253880e+001,
	2.347351e-002,
	-1.602964e-002,
	4.481579e-003,
	1.373645e+000,
	-2.884929e-001,
	-6.156336e+000,
	-2.568735e+000,
	6.499533e+000,
	-9.136753e+000,
	-1.751599e-001,
	1.876960e+000,
	-7.959051e-002,
	3.074951e+000,
	1.579874e+000,
	7.378485e-001,
	-2.614544e-001,
	-2.861777e+000,
	9.518947e+000,
	5.033808e-001,
	-1.844722e+000,
	6.855962e-001,
	-1.497263e+000,
	-9.081643e-002,
	-1.341940e+000,
	-3.847183e-001,
	2.045437e+000,
	-1.179073e+001,
	-1.532773e+000,
	1.639939e+000,
	-2.668175e-001,
	-8.401827e-001,
	1.083722e+000,
	-1.086126e+000,
	-2.811402e-001,
	7.554239e-001,
	1.862181e+001,
	-4.343385e+000,
	-8.611011e-001,
	3.146558e-001,
	7.022438e-001,
	5.872694e-001,
};

double datasetRad560[] = 
{
	// albedo 0, turbidity 1
	1.229100e-001,
	9.521889e-002,
	1.405396e-001,
	8.787112e-001,
	3.988783e-001,
	5.495204e-001,
	// albedo 0, turbidity 2
	1.199581e-001,
	1.081049e-001,
	6.220570e-002,
	1.081857e+000,
	3.919610e-001,
	5.733490e-001,
	// albedo 0, turbidity 3
	1.138362e-001,
	1.298987e-001,
	-7.284771e-002,
	1.405046e+000,
	3.664093e-001,
	6.266856e-001,
	// albedo 0, turbidity 4
	1.049109e-001,
	1.679341e-001,
	-2.972688e-001,
	1.869885e+000,
	3.458361e-001,
	7.128497e-001,
	// albedo 0, turbidity 5
	9.598094e-002,
	2.070366e-001,
	-5.051216e-001,
	2.239049e+000,
	3.816016e-001,
	7.939503e-001,
	// albedo 0, turbidity 6
	8.963794e-002,
	2.286618e-001,
	-6.166284e-001,
	2.410878e+000,
	4.394852e-001,
	8.454492e-001,
	// albedo 0, turbidity 7
	8.340284e-002,
	2.476914e-001,
	-7.170190e-001,
	2.486806e+000,
	6.858305e-001,
	8.717659e-001,
	// albedo 0, turbidity 8
	7.444609e-002,
	2.646252e-001,
	-7.920395e-001,
	2.426535e+000,
	1.075172e+000,
	9.650954e-001,
	// albedo 0, turbidity 9
	6.629833e-002,
	2.459655e-001,
	-6.980154e-001,
	1.912425e+000,
	1.829164e+000,
	1.077596e+000,
	// albedo 0, turbidity 10
	5.889089e-002,
	1.723101e-001,
	-3.613857e-001,
	8.275448e-001,
	2.946694e+000,
	1.231617e+000,
	// albedo 1, turbidity 1
	1.314133e-001,
	1.122331e-001,
	1.449363e-001,
	8.093475e-001,
	1.079774e+000,
	1.233568e+000,
	// albedo 1, turbidity 2
	1.279124e-001,
	1.290274e-001,
	4.690773e-002,
	1.061743e+000,
	1.017150e+000,
	1.317400e+000,
	// albedo 1, turbidity 3
	1.220803e-001,
	1.528616e-001,
	-9.605511e-002,
	1.391437e+000,
	1.000174e+000,
	1.408238e+000,
	// albedo 1, turbidity 4
	1.121360e-001,
	1.811889e-001,
	-2.743886e-001,
	1.744983e+000,
	1.106066e+000,
	1.489542e+000,
	// albedo 1, turbidity 5
	1.043672e-001,
	2.082413e-001,
	-4.376278e-001,
	2.008634e+000,
	1.246195e+000,
	1.572920e+000,
	// albedo 1, turbidity 6
	9.950913e-002,
	2.198237e-001,
	-5.028179e-001,
	2.058564e+000,
	1.441221e+000,
	1.587471e+000,
	// albedo 1, turbidity 7
	9.246215e-002,
	2.370164e-001,
	-5.865610e-001,
	2.082736e+000,
	1.718826e+000,
	1.643687e+000,
	// albedo 1, turbidity 8
	8.343644e-002,
	2.411559e-001,
	-6.125797e-001,
	1.909744e+000,
	2.180259e+000,
	1.747309e+000,
	// albedo 1, turbidity 9
	7.492090e-002,
	2.122543e-001,
	-4.784322e-001,
	1.297338e+000,
	2.978259e+000,
	1.846305e+000,
	// albedo 1, turbidity 10
	6.653290e-002,
	1.376844e-001,
	-1.431215e-001,
	2.099180e-001,
	4.028552e+000,
	1.938106e+000,
};

double dataset600[] = 
{
	// albedo 0, turbidity 1
	-1.120756e+000,
	-1.756050e-001,
	-3.557732e+000,
	5.117996e+000,
	-1.042966e-001,
	1.269364e+000,
	1.318863e-002,
	3.718263e+000,
	5.393663e-001,
	-1.170564e+000,
	-1.845108e-001,
	1.081952e+000,
	1.330153e+000,
	-2.486698e-001,
	7.864551e-001,
	3.710973e-003,
	4.567181e+000,
	4.998408e-001,
	-1.036563e+000,
	-2.605284e-001,
	3.803752e+000,
	-3.585400e+000,
	-9.070196e-001,
	2.380958e+000,
	-1.320680e-002,
	-4.210738e+000,
	1.085121e+000,
	-1.193752e+000,
	-1.236757e-001,
	-2.036484e-001,
	4.137855e+000,
	1.566414e+000,
	8.510547e-001,
	1.653213e-002,
	5.488784e+000,
	2.335910e-001,
	-9.950781e-001,
	-2.103974e-001,
	2.992004e+000,
	-4.050491e+000,
	-6.354208e+000,
	2.250652e+000,
	-1.548511e-002,
	-1.876535e+000,
	9.733518e-001,
	-1.106820e+000,
	-1.804412e-001,
	1.960315e+000,
	3.667064e+000,
	-2.460232e+000,
	9.553453e-001,
	1.238019e-002,
	1.307691e+000,
	5.564710e-001,
	// albedo 0, turbidity 2
	-1.112834e+000,
	-1.534956e-001,
	-4.968015e+000,
	6.079068e+000,
	-8.917942e-002,
	1.167545e+000,
	5.945633e-002,
	5.295468e+000,
	6.272123e-001,
	-1.160910e+000,
	-1.640745e-001,
	7.416807e-001,
	-2.894668e-001,
	-8.983936e-002,
	3.778575e-002,
	2.133300e-001,
	6.390765e+000,
	3.592393e-001,
	-1.054872e+000,
	-2.642844e-001,
	4.375802e+000,
	-1.434824e+000,
	-7.521504e-001,
	3.669027e+000,
	-2.992879e-001,
	-5.159653e+000,
	1.284643e+000,
	-1.147542e+000,
	1.011446e-002,
	-2.308529e+000,
	1.587994e+000,
	1.226957e+000,
	-1.328837e+000,
	5.996235e-001,
	1.004278e+001,
	5.212352e-002,
	-1.023945e+000,
	-2.867193e-001,
	3.733660e+000,
	-2.572157e+000,
	-7.749675e+000,
	3.927326e+000,
	-3.230666e-001,
	-4.260418e+000,
	1.091761e+000,
	-1.100815e+000,
	-1.590204e-001,
	1.413330e+000,
	6.546557e+000,
	-2.407235e+000,
	-2.678587e-001,
	2.367155e-001,
	2.242596e+000,
	5.273419e-001,
	// albedo 0, turbidity 3
	-1.137271e+000,
	-1.838447e-001,
	-2.268731e+000,
	3.013967e+000,
	-1.471213e-001,
	9.047947e-001,
	8.086373e-002,
	4.834215e+000,
	6.545047e-001,
	-1.136415e+000,
	-1.536696e-001,
	-1.821062e+000,
	1.756804e+000,
	-9.313635e-002,
	2.208938e-001,
	2.021774e-001,
	7.289664e+000,
	4.997813e-001,
	-1.173214e+000,
	-3.202233e-001,
	4.868221e+000,
	-2.485467e+000,
	-7.693969e-001,
	3.027854e+000,
	-1.745243e-001,
	-4.896365e+000,
	1.014186e+000,
	-1.021346e+000,
	7.262425e-002,
	-2.940205e+000,
	3.357462e+000,
	1.150486e+000,
	-1.710207e+000,
	7.381637e-001,
	9.857427e+000,
	3.036725e-001,
	-1.082107e+000,
	-2.721172e-001,
	3.071962e+000,
	-7.058088e+000,
	-5.103538e+000,
	3.852302e+000,
	-2.281911e-001,
	-2.565665e+000,
	9.669584e-001,
	-1.076296e+000,
	-1.655466e-001,
	1.323765e+000,
	1.496892e+001,
	-3.773928e+000,
	-5.211752e-001,
	2.583009e-001,
	1.797906e+000,
	5.888323e-001,
	// albedo 0, turbidity 4
	-1.180432e+000,
	-2.327942e-001,
	-7.152650e-001,
	1.078120e+000,
	-2.935788e-001,
	6.977295e-001,
	1.118530e-001,
	4.270574e+000,
	6.241267e-001,
	-1.260549e+000,
	-2.865438e-001,
	-2.736770e+000,
	2.720969e+000,
	1.291231e-001,
	4.072562e-001,
	4.510932e-002,
	5.412464e+000,
	6.781695e-001,
	-1.119712e+000,
	-2.521160e-001,
	4.860527e+000,
	-1.950603e+000,
	-1.598805e+000,
	2.556718e+000,
	2.462723e-002,
	-2.059404e+000,
	8.000995e-001,
	-1.056386e+000,
	2.018258e-002,
	-3.728955e+000,
	1.022270e+000,
	1.722210e+000,
	-2.691554e+000,
	8.329883e-001,
	6.982450e+000,
	4.746778e-001,
	-1.044811e+000,
	-2.531291e-001,
	3.102204e+000,
	-3.662632e+000,
	-5.609358e+000,
	4.574385e+000,
	-2.173600e-001,
	-1.646110e+000,
	8.593305e-001,
	-1.090027e+000,
	-1.699462e-001,
	7.118896e-001,
	1.287572e+001,
	-2.747429e+000,
	-1.706223e+000,
	4.483382e-001,
	2.029605e+000,
	6.366599e-001,
	// albedo 0, turbidity 5
	-1.232266e+000,
	-2.905676e-001,
	-4.158347e-001,
	5.285264e-001,
	-3.064312e-001,
	5.569478e-001,
	1.195289e-001,
	3.788091e+000,
	5.970680e-001,
	-1.451205e+000,
	-5.169964e-001,
	-2.018331e-001,
	1.499655e+000,
	-1.575963e+000,
	2.761459e-001,
	5.184923e-002,
	2.301119e+000,
	6.177771e-001,
	-1.059832e+000,
	-7.658003e-002,
	6.456894e-001,
	-4.398594e+000,
	5.369604e+000,
	2.121235e+000,
	3.210869e-002,
	3.542794e+000,
	9.114953e-001,
	-1.040966e+000,
	-1.269405e-001,
	-3.751056e-001,
	1.229395e+001,
	-1.977090e+001,
	-2.458488e+000,
	7.711932e-001,
	8.079227e-001,
	3.865305e-001,
	-1.061923e+000,
	-1.981907e-001,
	1.089854e+000,
	-3.414507e+000,
	8.032592e+000,
	3.459965e+000,
	-1.253984e-001,
	1.188198e+000,
	8.639277e-001,
	-1.070607e+000,
	-1.627049e-001,
	7.012071e-001,
	2.138780e+000,
	-5.006595e+000,
	-1.096698e+000,
	6.658771e-001,
	1.999430e+000,
	6.557122e-001,
	// albedo 0, turbidity 6
	-1.280090e+000,
	-3.357179e-001,
	-9.337154e-002,
	-5.075553e-003,
	-3.096112e+000,
	4.001499e-001,
	1.489818e-001,
	3.515349e+000,
	5.571477e-001,
	-1.648190e+000,
	-7.024227e-001,
	-2.925797e-002,
	1.658094e+000,
	4.229924e+000,
	3.502683e-001,
	3.180108e-002,
	1.430955e+000,
	5.739552e-001,
	-9.589189e-001,
	2.559557e-002,
	2.192186e-001,
	-5.276316e+000,
	-4.153922e+000,
	1.855574e+000,
	3.052317e-002,
	4.323694e+000,
	9.839497e-001,
	-1.076589e+000,
	-1.936109e-001,
	-4.162615e-001,
	1.202609e+001,
	-9.327314e+000,
	-2.326508e+000,
	7.983253e-001,
	2.100845e-001,
	3.135170e-001,
	-1.049437e+000,
	-1.694738e-001,
	1.062110e+000,
	5.575299e+000,
	4.846701e-001,
	3.089474e+000,
	-1.584214e-001,
	1.369457e+000,
	8.995377e-001,
	-1.069986e+000,
	-1.830827e-001,
	5.006422e-001,
	-3.063835e-003,
	-2.768514e+000,
	-1.258027e+000,
	6.679955e-001,
	1.840288e+000,
	6.498676e-001,
	// albedo 0, turbidity 7
	-1.328971e+000,
	-3.853230e-001,
	-2.343098e-001,
	-6.505414e-003,
	-4.859294e+000,
	3.752993e-001,
	1.670718e-001,
	3.474961e+000,
	4.998573e-001,
	-2.023062e+000,
	-1.023840e+000,
	4.308501e-001,
	1.473146e+000,
	6.112105e+000,
	5.767265e-001,
	-3.107377e-002,
	7.748759e-002,
	5.016978e-001,
	-8.575747e-001,
	1.580212e-001,
	-7.365004e-001,
	-4.007773e+000,
	-4.051657e+000,
	8.889282e-001,
	1.978413e-001,
	6.282132e+000,
	1.063928e+000,
	-1.073428e+000,
	-3.228761e-001,
	4.793085e-001,
	5.455778e+000,
	-7.830559e+000,
	-9.794478e-001,
	5.370543e-001,
	-3.022750e+000,
	2.818600e-001,
	-1.057120e+000,
	-1.266841e-001,
	4.555368e-001,
	1.201278e+001,
	-9.293773e-001,
	1.439595e+000,
	3.262182e-002,
	2.890364e+000,
	8.821540e-001,
	-1.060079e+000,
	-1.816680e-001,
	3.541107e-001,
	-2.642196e-003,
	-2.588317e+000,
	-5.640010e-001,
	6.643994e-001,
	1.673077e+000,
	6.658333e-001,
	// albedo 0, turbidity 8
	-1.395409e+000,
	-4.658947e-001,
	-4.370597e-001,
	1.342039e+000,
	-1.108674e+000,
	6.439316e-001,
	1.355229e-002,
	3.241153e+000,
	6.696079e-001,
	-2.418167e+000,
	-1.266061e+000,
	3.287382e-001,
	-1.486721e+000,
	-6.770180e-001,
	2.439008e-001,
	1.703788e-001,
	1.664559e-002,
	-6.330217e-003,
	-1.221212e+000,
	-1.072571e-001,
	-1.655914e+000,
	2.659047e+000,
	6.830770e+000,
	4.984792e-001,
	2.538158e-001,
	6.500660e+000,
	1.486576e+000,
	-7.182331e-001,
	-2.519055e-001,
	1.641261e+000,
	-5.500375e+000,
	-1.253143e+001,
	-1.542672e-001,
	1.741161e-001,
	-4.907497e+000,
	7.968864e-002,
	-1.207117e+000,
	-1.635739e-001,
	-3.256308e-001,
	1.409033e+001,
	1.107883e+000,
	7.217342e-001,
	3.158860e-001,
	3.537550e+000,
	9.389751e-001,
	-1.015927e+000,
	-1.890895e-001,
	4.180376e-001,
	9.528535e+000,
	-4.073979e+000,
	-8.713087e-001,
	4.899379e-001,
	1.277831e+000,
	6.519818e-001,
	// albedo 0, turbidity 9
	-1.551242e+000,
	-6.400568e-001,
	-3.673011e-001,
	1.623228e+000,
	-1.482572e+000,
	5.625944e-001,
	-1.130924e-005,
	2.792007e+000,
	9.000924e-001,
	-1.971409e+000,
	-9.004995e-001,
	-2.337582e-001,
	-1.511905e+000,
	6.645432e-002,
	6.149087e-001,
	-3.184094e-002,
	2.026210e+000,
	-2.799058e-001,
	-3.464015e+000,
	-1.604654e+000,
	-1.514516e+000,
	2.768075e+000,
	4.084166e+000,
	-4.287171e-001,
	7.112107e-001,
	2.896460e+000,
	1.502031e+000,
	4.069978e-001,
	2.775394e-001,
	1.525761e+000,
	-5.264056e+000,
	-7.108445e+000,
	1.134996e+000,
	-4.122625e-001,
	-2.558151e+000,
	2.009854e-001,
	-1.504217e+000,
	-3.618442e-001,
	-2.305374e-001,
	1.434481e+001,
	-1.713254e+000,
	-5.670708e-001,
	5.206848e-001,
	1.704009e+000,
	8.447497e-001,
	-9.753124e-001,
	-2.080868e-001,
	2.450141e-001,
	-3.535206e-003,
	-2.121317e+000,
	-1.425634e-001,
	4.670084e-001,
	1.027875e+000,
	6.735543e-001,
	// albedo 0, turbidity 10
	-2.027207e+000,
	-1.003600e+000,
	-3.813114e-001,
	9.357907e-001,
	-1.031886e+000,
	5.523389e-001,
	-8.883940e-006,
	2.339379e+000,
	9.001659e-001,
	-1.506235e+000,
	-7.795241e-001,
	-4.313309e-001,
	9.124054e-001,
	-7.484352e-001,
	-8.417756e-002,
	-1.426561e-002,
	2.571178e+000,
	-2.504298e-001,
	-6.482777e+000,
	-2.700075e+000,
	-1.556622e+000,
	-2.978497e+000,
	4.623255e+000,
	1.953868e+000,
	3.113178e-001,
	2.311303e+000,
	1.451021e+000,
	9.357272e-001,
	-1.066566e-001,
	1.476763e+000,
	6.889797e+000,
	-1.038036e+001,
	-2.094856e+000,
	1.330069e-001,
	-1.446404e+000,
	1.121890e-001,
	-1.398229e+000,
	-3.167573e-001,
	-1.276866e-001,
	1.239440e+000,
	1.816678e+000,
	1.586775e+000,
	8.043533e-002,
	3.219192e-001,
	9.200620e-001,
	-1.070734e+000,
	-3.636167e-001,
	2.426490e-001,
	8.282765e+000,
	-3.588710e+000,
	-9.105402e-001,
	3.760276e-001,
	5.756358e-001,
	6.508161e-001,
	// albedo 1, turbidity 1
	-1.120757e+000,
	-1.756034e-001,
	-3.557732e+000,
	5.117996e+000,
	-1.042960e-001,
	1.269364e+000,
	1.318834e-002,
	3.718263e+000,
	5.393663e-001,
	-1.170565e+000,
	-1.845093e-001,
	1.081952e+000,
	1.330153e+000,
	-2.486697e-001,
	7.864550e-001,
	3.709405e-003,
	4.567181e+000,
	4.998408e-001,
	-1.036564e+000,
	-2.605265e-001,
	3.803752e+000,
	-3.585400e+000,
	-9.070196e-001,
	2.380958e+000,
	-1.320996e-002,
	-4.210738e+000,
	1.085121e+000,
	-1.193753e+000,
	-1.236733e-001,
	-2.036483e-001,
	4.137855e+000,
	1.566414e+000,
	8.510543e-001,
	1.652749e-002,
	5.488784e+000,
	2.335910e-001,
	-9.950796e-001,
	-2.103948e-001,
	2.992004e+000,
	-4.050491e+000,
	-6.354208e+000,
	2.250652e+000,
	-1.548996e-002,
	-1.876535e+000,
	9.733518e-001,
	-1.106823e+000,
	-1.804388e-001,
	1.960315e+000,
	3.667064e+000,
	-2.460232e+000,
	9.553451e-001,
	1.237721e-002,
	1.307692e+000,
	5.564710e-001,
	// albedo 1, turbidity 2
	-1.113356e+000,
	-1.560185e-001,
	-7.788803e+000,
	8.963658e+000,
	-5.322872e-002,
	1.116670e+000,
	7.024842e-002,
	4.886694e+000,
	5.931909e-001,
	-1.134232e+000,
	-1.667475e-001,
	4.176259e+000,
	-3.242194e+000,
	-7.889230e-002,
	8.254326e-002,
	1.400333e-001,
	5.395289e+000,
	4.862375e-001,
	-1.105040e+000,
	-2.389195e-001,
	9.866260e-001,
	1.271557e+000,
	-6.066849e-001,
	3.599900e+000,
	-1.681445e-001,
	-2.812867e+000,
	1.053791e+000,
	-1.078302e+000,
	-2.258635e-002,
	7.407482e-001,
	1.805864e-001,
	9.070580e-001,
	-1.720820e+000,
	4.256187e-001,
	6.982502e+000,
	3.350778e-001,
	-1.070883e+000,
	-2.752054e-001,
	2.937203e+000,
	-2.246366e+000,
	-9.847865e+000,
	3.104714e+000,
	-2.573859e-001,
	-2.816401e+000,
	8.478900e-001,
	-1.090880e+000,
	-1.453755e-001,
	2.046382e+000,
	5.595795e+000,
	-2.809181e+000,
	-9.239576e-001,
	1.783176e-001,
	2.051350e+000,
	5.815062e-001,
	// albedo 1, turbidity 3
	-1.136641e+000,
	-1.825277e-001,
	-3.464338e+000,
	4.413974e+000,
	-1.123917e-001,
	1.009115e+000,
	5.542918e-002,
	4.702599e+000,
	6.799974e-001,
	-1.146478e+000,
	-1.593833e-001,
	-9.055790e-001,
	8.991902e-001,
	-4.711416e-002,
	-3.813573e-001,
	2.290428e-001,
	6.961903e+000,
	4.206011e-001,
	-1.136317e+000,
	-3.103198e-001,
	4.219694e+000,
	-2.031887e+000,
	-7.184952e-001,
	3.795646e+000,
	-1.650547e-001,
	-5.402471e+000,
	1.118561e+000,
	-1.044973e+000,
	7.826651e-002,
	-2.043684e+000,
	3.410720e+000,
	1.974969e+000,
	-2.736513e+000,
	6.828176e-001,
	1.049084e+001,
	1.894241e-001,
	-1.076125e+000,
	-2.930526e-001,
	3.722784e+000,
	-7.364061e+000,
	-7.399428e+000,
	4.034307e+000,
	-3.489831e-001,
	-3.438955e+000,
	1.077145e+000,
	-1.100551e+000,
	-1.533449e-001,
	1.767589e+000,
	1.479022e+001,
	-2.910058e+000,
	-1.732923e+000,
	2.193598e-001,
	1.880974e+000,
	4.999331e-001,
	// albedo 1, turbidity 4
	-1.175282e+000,
	-2.274651e-001,
	-8.788053e-001,
	1.446934e+000,
	-2.568124e-001,
	7.201567e-001,
	1.054963e-001,
	4.149007e+000,
	6.084060e-001,
	-1.224868e+000,
	-2.528005e-001,
	-2.861303e+000,
	3.033667e+000,
	1.405049e-001,
	2.481768e-001,
	6.435189e-002,
	5.409907e+000,
	6.372238e-001,
	-1.144647e+000,
	-3.063749e-001,
	4.347579e+000,
	-2.473291e+000,
	-1.180139e+000,
	2.550631e+000,
	3.833967e-002,
	-3.231444e+000,
	8.737219e-001,
	-1.028428e+000,
	8.888974e-002,
	-2.431225e+000,
	2.811511e+000,
	2.400771e+000,
	-2.380403e+000,
	7.114868e-001,
	8.190106e+000,
	4.166861e-001,
	-1.076730e+000,
	-3.129260e-001,
	3.582560e+000,
	-5.902417e+000,
	-6.959342e+000,
	3.528030e+000,
	-2.613596e-001,
	-2.993803e+000,
	8.934226e-001,
	-1.107957e+000,
	-1.728652e-001,
	1.679540e+000,
	1.238391e+001,
	-2.945620e+000,
	-1.568811e+000,
	2.418421e-001,
	1.360652e+000,
	6.182405e-001,
	// albedo 1, turbidity 5
	-1.215034e+000,
	-2.755459e-001,
	-1.477751e-001,
	4.448730e-001,
	-4.027817e-001,
	4.787013e-001,
	1.200617e-001,
	3.613995e+000,
	5.999756e-001,
	-1.443500e+000,
	-5.194350e-001,
	1.588243e-001,
	1.429114e+000,
	-2.310655e+000,
	3.033213e-001,
	2.308566e-002,
	1.894189e+000,
	6.066576e-001,
	-1.051421e+000,
	-9.990731e-002,
	5.187710e-001,
	-3.890856e+000,
	7.794599e+000,
	1.810628e+000,
	6.532073e-002,
	2.564480e+000,
	9.334916e-001,
	-1.034548e+000,
	-6.777012e-002,
	-2.587520e-002,
	1.062675e+001,
	-2.266196e+001,
	-2.002081e+000,
	7.508804e-001,
	2.022771e+000,
	3.517577e-001,
	-1.090576e+000,
	-2.542157e-001,
	2.213560e+000,
	-3.563890e+000,
	9.180955e+000,
	2.780121e+000,
	-2.656654e-001,
	-5.012514e-002,
	8.968751e-001,
	-1.104356e+000,
	-1.955634e-001,
	1.782217e+000,
	1.085584e+000,
	-5.011522e+000,
	-1.075140e+000,
	3.828238e-001,
	6.133363e-001,
	6.448312e-001,
	// albedo 1, turbidity 6
	-1.261147e+000,
	-3.271435e-001,
	1.136430e-001,
	-3.464762e-003,
	-3.025565e+000,
	3.660675e-001,
	1.337332e-001,
	3.190374e+000,
	5.655627e-001,
	-1.611753e+000,
	-6.914768e-001,
	2.911405e-001,
	1.806475e+000,
	2.823240e+000,
	3.320241e-001,
	2.606391e-002,
	9.946717e-001,
	5.581393e-001,
	-9.491151e-001,
	9.848038e-003,
	2.711804e-001,
	-5.319331e+000,
	1.135835e-001,
	1.669815e+000,
	3.604115e-002,
	3.506230e+000,
	1.008650e+000,
	-1.109597e+000,
	-1.650703e-001,
	-3.529912e-001,
	1.209251e+001,
	-1.435008e+001,
	-2.085063e+000,
	7.955493e-001,
	1.240407e+000,
	2.856509e-001,
	-1.035803e+000,
	-1.963707e-001,
	2.407913e+000,
	-1.564693e+000,
	4.483717e+000,
	2.795295e+000,
	-2.799711e-001,
	6.851892e-002,
	9.312311e-001,
	-1.132687e+000,
	-2.383551e-001,
	1.590132e+000,
	1.025733e+000,
	-4.837236e+000,
	-1.334195e+000,
	4.022060e-001,
	4.281273e-001,
	6.334802e-001,
	// albedo 1, turbidity 7
	-1.310240e+000,
	-3.819813e-001,
	2.469845e-002,
	-7.043983e-003,
	-5.009925e+000,
	3.560980e-001,
	1.582176e-001,
	2.966421e+000,
	4.998910e-001,
	-1.993638e+000,
	-1.029241e+000,
	7.780588e-001,
	1.080741e+000,
	7.179598e+000,
	2.478857e-001,
	1.935012e-002,
	-3.434240e-001,
	4.813586e-001,
	-8.209344e-001,
	1.728853e-001,
	-7.045676e-001,
	-3.384688e+000,
	-4.855111e+000,
	1.661563e+000,
	4.252574e-002,
	5.701648e+000,
	1.110774e+000,
	-1.130678e+000,
	-3.273624e-001,
	5.555549e-001,
	5.800793e+000,
	-8.817085e+000,
	-2.344445e+000,
	7.532869e-001,
	-2.418368e+000,
	2.201826e-001,
	-1.032417e+000,
	-1.335568e-001,
	1.707051e+000,
	8.168228e+000,
	-5.151972e-003,
	2.785504e+000,
	-2.123703e-001,
	1.770173e+000,
	9.064082e-001,
	-1.125604e+000,
	-2.328530e-001,
	1.537245e+000,
	4.347312e+000,
	-4.368526e+000,
	-1.527321e+000,
	3.574251e-001,
	5.982159e-001,
	6.705880e-001,
	// albedo 1, turbidity 8
	-1.381743e+000,
	-4.607543e-001,
	-2.754732e-001,
	9.134243e-001,
	-7.581174e-001,
	6.220814e-001,
	2.353878e-002,
	2.891536e+000,
	6.426078e-001,
	-2.362341e+000,
	-1.306326e+000,
	6.909936e-001,
	-7.196658e-001,
	-4.501812e-001,
	-5.219928e-002,
	2.111683e-001,
	-9.499603e-001,
	3.301774e-002,
	-1.218829e+000,
	-6.834768e-002,
	-1.241760e+000,
	1.122890e+000,
	5.750762e+000,
	1.231058e+000,
	6.884716e-003,
	6.801032e+000,
	1.512485e+000,
	-6.781560e-001,
	-2.446588e-001,
	1.302166e+000,
	-2.334650e+000,
	-1.218960e+001,
	-1.257952e+000,
	5.387955e-001,
	-5.559859e+000,
	-1.209718e-002,
	-1.270037e+000,
	-1.870204e-001,
	9.650201e-001,
	9.976613e+000,
	1.444014e+000,
	1.523442e+000,
	-2.753646e-002,
	3.415790e+000,
	1.017645e+000,
	-1.046712e+000,
	-2.173979e-001,
	1.473981e+000,
	4.368847e+000,
	-4.642506e+000,
	-1.049951e+000,
	3.511771e-001,
	2.379457e-001,
	6.307946e-001,
	// albedo 1, turbidity 9
	-1.532302e+000,
	-6.390752e-001,
	-1.369123e-001,
	1.480171e+000,
	-1.313391e+000,
	5.210118e-001,
	-1.053608e-005,
	2.352090e+000,
	9.000581e-001,
	-2.042866e+000,
	-1.015386e+000,
	1.750126e-001,
	-9.921800e-001,
	-9.449241e-002,
	4.791921e-001,
	-2.744712e-002,
	9.337925e-001,
	-2.902902e-001,
	-3.413474e+000,
	-1.485380e+000,
	-1.301300e+000,
	1.266203e+000,
	3.869657e+000,
	-1.405606e-002,
	6.109944e-001,
	3.883967e+000,
	1.540321e+000,
	5.838664e-001,
	2.370098e-001,
	1.420200e+000,
	-1.803001e+000,
	-6.672775e+000,
	2.866921e-001,
	-2.599250e-001,
	-4.162164e+000,
	1.296901e-001,
	-1.654226e+000,
	-3.296843e-001,
	6.245723e-001,
	7.899655e+000,
	-1.079857e+000,
	3.145485e-001,
	4.085894e-001,
	2.258895e+000,
	9.071309e-001,
	-9.748612e-001,
	-2.545963e-001,
	1.374064e+000,
	-2.816107e-003,
	-2.589259e+000,
	-5.960628e-001,
	2.656787e-001,
	-1.458520e-001,
	6.529731e-001,
	// albedo 1, turbidity 10
	-1.944006e+000,
	-9.776516e-001,
	-2.425412e-001,
	8.187180e-001,
	-6.620102e-001,
	5.676187e-001,
	-7.857556e-006,
	1.944153e+000,
	9.001463e-001,
	-1.294455e+000,
	-7.294996e-001,
	-1.718682e-002,
	1.261264e+000,
	-1.170104e+000,
	-2.029198e-001,
	-1.306023e-002,
	1.821821e+000,
	-2.533820e-001,
	-6.849943e+000,
	-2.937611e+000,
	-1.107710e+000,
	-3.923478e+000,
	5.018293e+000,
	2.040419e+000,
	2.845113e-001,
	2.080902e+000,
	1.460328e+000,
	1.445166e+000,
	1.641979e-001,
	9.591325e-001,
	8.676572e+000,
	-1.098801e+001,
	-2.274573e+000,
	1.340040e-001,
	-1.166380e+000,
	1.014270e-001,
	-1.596800e+000,
	-4.130457e-001,
	9.250919e-001,
	-1.406592e+000,
	2.474727e+000,
	1.748285e+000,
	9.929937e-002,
	-6.705073e-001,
	9.210646e-001,
	-1.035617e+000,
	-3.537996e-001,
	1.073337e+000,
	6.090616e+000,
	-3.710420e+000,
	-9.390485e-001,
	2.233788e-001,
	-3.213961e-004,
	6.545784e-001,
};

double datasetRad600[] = 
{
	// albedo 0, turbidity 1
	1.299197e-001,
	8.321511e-002,
	2.387451e-001,
	5.880940e-001,
	3.729916e-001,
	4.103205e-001,
	// albedo 0, turbidity 2
	1.270323e-001,
	9.637820e-002,
	1.615812e-001,
	8.452533e-001,
	3.032088e-001,
	4.665419e-001,
	// albedo 0, turbidity 3
	1.219961e-001,
	1.092933e-001,
	5.901632e-002,
	1.159891e+000,
	2.934228e-001,
	5.092212e-001,
	// albedo 0, turbidity 4
	1.119541e-001,
	1.351827e-001,
	-1.275865e-001,
	1.613767e+000,
	3.106034e-001,
	5.716776e-001,
	// albedo 0, turbidity 5
	1.014757e-001,
	1.830462e-001,
	-3.923527e-001,
	2.142187e+000,
	2.311117e-001,
	6.935246e-001,
	// albedo 0, turbidity 6
	9.547231e-002,
	2.061450e-001,
	-5.263613e-001,
	2.366722e+000,
	2.846338e-001,
	7.366447e-001,
	// albedo 0, turbidity 7
	8.667068e-002,
	2.433017e-001,
	-7.117469e-001,
	2.634726e+000,
	3.869484e-001,
	8.214510e-001,
	// albedo 0, turbidity 8
	7.662515e-002,
	2.696023e-001,
	-8.324986e-001,
	2.658131e+000,
	7.772588e-001,
	8.929431e-001,
	// albedo 0, turbidity 9
	6.629504e-002,
	2.629460e-001,
	-7.999192e-001,
	2.265017e+000,
	1.480991e+000,
	1.022526e+000,
	// albedo 0, turbidity 10
	5.848320e-002,
	1.969638e-001,
	-4.880301e-001,
	1.188948e+000,
	2.656831e+000,
	1.166634e+000,
	// albedo 1, turbidity 1
	1.356710e-001,
	1.027510e-001,
	2.164597e-001,
	5.973954e-001,
	8.682036e-001,
	9.805911e-001,
	// albedo 1, turbidity 2
	1.334939e-001,
	1.170363e-001,
	1.345563e-001,
	8.550149e-001,
	8.116863e-001,
	1.066240e+000,
	// albedo 1, turbidity 3
	1.276963e-001,
	1.324982e-001,
	2.283428e-002,
	1.185916e+000,
	8.070938e-001,
	1.153223e+000,
	// albedo 1, turbidity 4
	1.189040e-001,
	1.594238e-001,
	-1.704000e-001,
	1.638298e+000,
	8.601982e-001,
	1.260336e+000,
	// albedo 1, turbidity 5
	1.084167e-001,
	1.944743e-001,
	-3.780871e-001,
	2.038365e+000,
	9.194507e-001,
	1.384964e+000,
	// albedo 1, turbidity 6
	1.031451e-001,
	2.143658e-001,
	-4.911574e-001,
	2.201644e+000,
	1.040176e+000,
	1.437725e+000,
	// albedo 1, turbidity 7
	9.432700e-002,
	2.394741e-001,
	-6.269994e-001,
	2.357064e+000,
	1.243691e+000,
	1.534951e+000,
	// albedo 1, turbidity 8
	8.488675e-002,
	2.521587e-001,
	-6.920513e-001,
	2.241994e+000,
	1.759223e+000,
	1.611551e+000,
	// albedo 1, turbidity 9
	7.537831e-002,
	2.332452e-001,
	-5.979287e-001,
	1.683393e+000,
	2.607738e+000,
	1.716448e+000,
	// albedo 1, turbidity 10
	6.598016e-002,
	1.617505e-001,
	-2.684133e-001,
	5.631708e-001,
	3.767336e+000,
	1.829865e+000,
};

double dataset640[] = 
{
	// albedo 0, turbidity 1
	-1.113346e+000,
	-1.715076e-001,
	-2.657094e+000,
	4.632520e+000,
	-1.092310e-001,
	1.421516e+000,
	3.230348e-003,
	2.697889e+000,
	6.262031e-001,
	-1.193355e+000,
	-2.074379e-001,
	1.431777e+000,
	8.245570e-001,
	-1.936967e-001,
	9.392137e-001,
	1.972523e-002,
	3.001209e+000,
	4.415825e-001,
	-9.337792e-001,
	-2.037239e-001,
	3.943675e+000,
	-2.487730e+000,
	-9.876315e-001,
	2.772411e+000,
	-4.919462e-002,
	-4.176827e+000,
	1.026227e+000,
	-1.297623e+000,
	-1.296758e-001,
	-3.144502e-001,
	2.454199e+000,
	2.433614e+000,
	5.298928e-001,
	7.814939e-002,
	6.564581e+000,
	5.587597e-001,
	-9.325270e-001,
	-1.997966e-001,
	3.363315e+000,
	-1.887198e+000,
	-8.905212e+000,
	2.808597e+000,
	-9.537165e-002,
	-3.059702e+000,
	5.403718e-001,
	-1.125650e+000,
	-1.904795e-001,
	2.099998e+000,
	1.251930e+000,
	-1.899312e+000,
	5.255919e-001,
	9.848260e-002,
	9.627433e-001,
	6.251236e-001,
	// albedo 0, turbidity 2
	-1.104956e+000,
	-1.372068e-001,
	-2.996624e+000,
	4.260021e+000,
	-1.263137e-001,
	1.327775e+000,
	7.595887e-002,
	5.301229e+000,
	6.478109e-001,
	-1.158426e+000,
	-1.921879e-001,
	3.371987e-001,
	8.543727e-001,
	-1.195421e-001,
	2.178871e-001,
	1.573997e-001,
	3.059646e+000,
	5.355391e-001,
	-1.012076e+000,
	-1.456275e-001,
	3.857821e+000,
	-1.137640e+000,
	-7.400821e-001,
	4.132381e+000,
	-2.101470e-001,
	-1.704290e-001,
	1.094519e+000,
	-1.200085e+000,
	-9.008631e-002,
	-1.764929e+000,
	4.584027e-001,
	8.033799e-001,
	-1.730728e+000,
	5.892683e-001,
	6.438112e+000,
	2.141131e-001,
	-9.836248e-001,
	-1.983419e-001,
	3.519957e+000,
	-9.777763e-001,
	-5.727911e+000,
	4.397457e+000,
	-2.864495e-001,
	-2.511187e+000,
	9.881415e-001,
	-1.111842e+000,
	-1.992363e-001,
	1.746814e+000,
	5.036170e+000,
	-2.993753e+000,
	-5.348114e-001,
	2.332738e-001,
	8.970344e-001,
	5.806194e-001,
	// albedo 0, turbidity 3
	-1.120087e+000,
	-1.577355e-001,
	-1.165606e+000,
	1.782016e+000,
	-1.771264e-001,
	8.928578e-001,
	1.613110e-001,
	4.975693e+000,
	6.258796e-001,
	-1.182069e+000,
	-2.047357e-001,
	-4.041517e-001,
	1.732659e+000,
	-4.322749e-001,
	6.549554e-001,
	5.392767e-002,
	4.838218e+000,
	6.441461e-001,
	-1.071518e+000,
	-2.057500e-001,
	2.808685e+000,
	-1.990080e+000,
	-8.491815e-001,
	2.193915e+000,
	2.411077e-001,
	-3.251587e+000,
	7.470978e-001,
	-1.113379e+000,
	-6.708322e-003,
	-2.181109e+000,
	2.107674e+000,
	2.216970e+000,
	-6.233552e-001,
	3.558080e-001,
	9.251876e+000,
	6.319555e-001,
	-1.026698e+000,
	-2.260748e-001,
	3.031659e+000,
	-1.615765e+000,
	-1.323341e+000,
	2.835147e+000,
	1.186568e-001,
	-3.366247e+000,
	6.850407e-001,
	-1.088223e+000,
	-1.817555e-001,
	1.435855e+000,
	1.845164e+000,
	-3.488539e+000,
	2.554837e-001,
	2.144895e-001,
	1.558895e+000,
	7.315398e-001,
	// albedo 0, turbidity 4
	-1.164089e+000,
	-2.003003e-001,
	-2.998423e-001,
	2.713689e-001,
	-1.828861e-001,
	5.800779e-001,
	1.968402e-001,
	4.650130e+000,
	6.156174e-001,
	-1.209796e+000,
	-2.733887e-001,
	-9.360003e-001,
	2.769100e+000,
	-1.870929e+000,
	7.049322e-001,
	-8.477045e-002,
	4.120960e+000,
	7.444509e-001,
	-1.232839e+000,
	-2.622151e-001,
	2.857050e+000,
	-2.866256e+000,
	3.128232e+000,
	1.897877e+000,
	4.581244e-001,
	-2.112943e+000,
	6.384882e-001,
	-9.291113e-001,
	4.110508e-002,
	-2.235781e+000,
	2.969741e+000,
	-9.758544e+000,
	-1.941571e+000,
	3.426656e-001,
	6.907158e+000,
	6.945892e-001,
	-1.103614e+000,
	-2.279953e-001,
	2.314490e+000,
	-6.307971e-001,
	3.369674e+000,
	3.787928e+000,
	2.456513e-001,
	-1.776073e+000,
	6.864316e-001,
	-1.072160e+000,
	-1.984678e-001,
	1.092192e+000,
	8.472734e-001,
	-3.126637e+000,
	-1.076607e+000,
	3.908469e-001,
	1.205671e+000,
	7.035925e-001,
	// albedo 0, turbidity 5
	-1.222416e+000,
	-2.654298e-001,
	-1.149975e-001,
	-6.277756e-003,
	-1.369463e+000,
	4.402179e-001,
	1.881320e-001,
	3.896722e+000,
	6.037946e-001,
	-1.407746e+000,
	-4.603243e-001,
	-3.071475e-001,
	2.937390e+000,
	-9.164938e-001,
	6.696693e-001,
	-6.608327e-002,
	2.444782e+000,
	6.905594e-001,
	-1.120454e+000,
	-1.466269e-001,
	7.829076e-001,
	-7.009271e+000,
	5.364470e+000,
	1.294280e+000,
	4.109552e-001,
	1.525889e+000,
	7.709564e-001,
	-9.792886e-001,
	-4.325464e-002,
	-4.059461e-001,
	1.522559e+001,
	-1.867598e+001,
	-1.169367e+000,
	3.589556e-001,
	2.368951e+000,
	5.526839e-001,
	-1.091118e+000,
	-2.286983e-001,
	9.896666e-001,
	-6.655971e+000,
	8.168041e+000,
	1.923773e+000,
	3.116805e-001,
	1.852611e-001,
	7.524175e-001,
	-1.053081e+000,
	-1.598496e-001,
	9.684194e-001,
	3.620674e+000,
	-5.015769e+000,
	8.125082e-002,
	4.669502e-001,
	1.415221e+000,
	7.044272e-001,
	// albedo 0, turbidity 6
	-1.267172e+000,
	-3.101221e-001,
	-8.556526e-002,
	-3.602153e-003,
	-4.988229e+000,
	4.099753e-001,
	1.555248e-001,
	3.585489e+000,
	6.128833e-001,
	-1.613116e+000,
	-6.560485e-001,
	9.250270e-002,
	2.119268e+000,
	8.031058e+000,
	4.019483e-001,
	4.526662e-002,
	1.362051e+000,
	5.999628e-001,
	-1.012405e+000,
	-2.251592e-002,
	2.836289e-001,
	-7.904006e+000,
	-9.544755e+000,
	1.754891e+000,
	1.283266e-001,
	3.042478e+000,
	9.234755e-001,
	-1.022835e+000,
	-1.361070e-001,
	-4.207218e-001,
	1.947050e+001,
	-5.511234e+000,
	-2.417169e+000,
	7.837822e-001,
	8.288902e-001,
	3.509734e-001,
	-1.068370e+000,
	-1.806143e-001,
	1.059217e+000,
	7.087518e-001,
	-1.671865e+000,
	3.098645e+000,
	-9.859822e-002,
	9.336021e-001,
	8.929147e-001,
	-1.065467e+000,
	-1.928982e-001,
	6.159162e-001,
	-4.157538e-003,
	-9.397621e-001,
	-1.193139e+000,
	6.979501e-001,
	1.118894e+000,
	6.467115e-001,
	// albedo 0, turbidity 7
	-1.345697e+000,
	-3.906019e-001,
	-1.921159e-001,
	-7.410201e-003,
	-4.683006e+000,
	4.591917e-001,
	1.919817e-001,
	3.158844e+000,
	5.319014e-001,
	-2.096314e+000,
	-1.056514e+000,
	7.665515e-001,
	1.602483e+000,
	6.290779e+000,
	4.693208e-001,
	-6.258855e-002,
	-3.745685e-001,
	5.853677e-001,
	-7.573573e-001,
	2.265213e-001,
	-1.283398e+000,
	-4.696984e+000,
	-4.261986e+000,
	1.197826e+000,
	3.444468e-001,
	6.004387e+000,
	9.413954e-001,
	-1.140929e+000,
	-3.489820e-001,
	1.095429e+000,
	7.531589e+000,
	-8.153320e+000,
	-1.722207e+000,
	4.427477e-001,
	-3.072440e+000,
	3.874398e-001,
	-1.009003e+000,
	-9.087616e-002,
	4.181128e-002,
	1.154023e+001,
	-5.092155e-001,
	2.166116e+000,
	1.620893e-001,
	2.824826e+000,
	8.289491e-001,
	-1.080842e+000,
	-2.166745e-001,
	6.939662e-001,
	-2.316636e-003,
	-2.616711e+000,
	-1.012238e+000,
	6.132021e-001,
	7.579828e-001,
	6.813755e-001,
	// albedo 0, turbidity 8
	-1.394668e+000,
	-4.508268e-001,
	-2.615024e-001,
	-7.412740e-003,
	-4.811648e+000,
	4.235635e-001,
	1.627041e-001,
	3.134174e+000,
	5.225016e-001,
	-2.715734e+000,
	-1.409574e+000,
	6.485110e-001,
	6.307101e-001,
	8.120123e+000,
	3.677567e-001,
	6.430919e-002,
	-3.729191e-001,
	3.463130e-001,
	-8.973624e-001,
	2.859206e-002,
	-1.610007e+000,
	-1.483136e+000,
	-5.613288e+000,
	7.093329e-001,
	2.936945e-001,
	5.541210e+000,
	1.143952e+000,
	-8.450858e-001,
	-1.969825e-001,
	1.399585e+000,
	1.418708e-001,
	-4.532026e+000,
	-7.432040e-001,
	3.410858e-001,
	-3.386293e+000,
	2.885614e-001,
	-1.180533e+000,
	-2.469972e-001,
	-2.694505e-002,
	1.635998e+001,
	-2.378676e+000,
	9.477733e-001,
	1.105776e-001,
	1.954485e+000,
	8.559872e-001,
	-1.022908e+000,
	-1.650807e-001,
	3.812483e-001,
	-2.139201e-003,
	-2.300711e+000,
	-5.917998e-001,
	6.793527e-001,
	1.248273e+000,
	6.747565e-001,
	// albedo 0, turbidity 9
	-1.557922e+000,
	-6.294681e-001,
	-2.355549e-001,
	-8.743568e-003,
	-5.017111e+000,
	4.034446e-001,
	1.005643e-001,
	2.735289e+000,
	5.667004e-001,
	-3.061673e+000,
	-1.398157e+000,
	1.597008e-001,
	1.066059e+000,
	8.207018e+000,
	4.785780e-001,
	4.629487e-002,
	1.324020e+000,
	2.540204e-001,
	-2.371583e+000,
	-1.100187e+000,
	-1.279309e+000,
	-3.340819e+000,
	-6.556706e+000,
	2.636750e-001,
	4.298705e-001,
	2.649782e+000,
	1.060950e+000,
	-5.315727e-002,
	2.306821e-001,
	1.091037e+000,
	5.297610e+000,
	-2.412315e+000,
	-7.083157e-002,
	7.256586e-002,
	-1.330891e+000,
	4.168205e-001,
	-1.375983e+000,
	-4.677570e-001,
	2.271650e-001,
	8.771601e+000,
	-2.511780e+000,
	1.487082e-001,
	8.542210e-002,
	5.509707e-003,
	7.821447e-001,
	-1.006483e+000,
	-1.435513e-001,
	5.802646e-002,
	-3.181899e-003,
	-2.010861e+000,
	-1.746922e-001,
	7.487809e-001,
	1.623209e+000,
	6.848148e-001,
	// albedo 0, turbidity 10
	-1.919035e+000,
	-9.396362e-001,
	-3.059418e-001,
	1.542398e+000,
	-1.488273e+000,
	5.133825e-001,
	-7.992185e-006,
	2.276361e+000,
	8.334381e-001,
	-2.470138e+000,
	-1.108577e+000,
	-5.521438e-001,
	-9.047033e-001,
	6.905739e-001,
	3.774300e-001,
	-2.801883e-002,
	2.413470e+000,
	-8.986266e-002,
	-5.532450e+000,
	-2.346497e+000,
	-1.734654e+000,
	1.461689e+000,
	1.765938e+000,
	4.969811e-001,
	6.205943e-001,
	2.112232e+000,
	1.159488e+000,
	4.159150e-001,
	-2.306809e-001,
	1.540502e+000,
	-1.006923e+000,
	-5.275092e+000,
	-2.776202e-002,
	-1.632884e-001,
	-1.467491e+000,
	4.177919e-001,
	-1.248112e+000,
	-3.080519e-001,
	-1.229235e-001,
	8.972757e+000,
	-1.532948e+000,
	-8.283794e-002,
	1.561573e-001,
	1.856113e-001,
	7.696948e-001,
	-1.054499e+000,
	-2.660558e-001,
	1.307025e-001,
	-2.167883e-003,
	-1.531056e+000,
	1.525856e-001,
	5.356892e-001,
	7.181428e-001,
	6.837654e-001,
	// albedo 1, turbidity 1
	-1.113347e+000,
	-1.715068e-001,
	-2.657094e+000,
	4.632520e+000,
	-1.092308e-001,
	1.421516e+000,
	3.229759e-003,
	2.697889e+000,
	6.262031e-001,
	-1.193355e+000,
	-2.074367e-001,
	1.431777e+000,
	8.245569e-001,
	-1.936966e-001,
	9.392136e-001,
	1.972263e-002,
	3.001209e+000,
	4.415825e-001,
	-9.337795e-001,
	-2.037221e-001,
	3.943675e+000,
	-2.487730e+000,
	-9.876315e-001,
	2.772410e+000,
	-4.919872e-002,
	-4.176827e+000,
	1.026227e+000,
	-1.297624e+000,
	-1.296733e-001,
	-3.144502e-001,
	2.454199e+000,
	2.433614e+000,
	5.298925e-001,
	7.814503e-002,
	6.564581e+000,
	5.587597e-001,
	-9.325285e-001,
	-1.997939e-001,
	3.363316e+000,
	-1.887198e+000,
	-8.905212e+000,
	2.808596e+000,
	-9.537523e-002,
	-3.059702e+000,
	5.403717e-001,
	-1.125653e+000,
	-1.904767e-001,
	2.099998e+000,
	1.251930e+000,
	-1.899312e+000,
	5.255917e-001,
	9.848033e-002,
	9.627434e-001,
	6.251233e-001,
	// albedo 1, turbidity 2
	-1.115892e+000,
	-1.571450e-001,
	-5.361081e+000,
	6.833528e+000,
	-6.891479e-002,
	1.309709e+000,
	6.046362e-002,
	3.972373e+000,
	6.651606e-001,
	-1.147479e+000,
	-1.855896e-001,
	2.239259e+000,
	-5.937930e-001,
	-1.005125e-001,
	2.773971e-001,
	1.337105e-001,
	3.136906e+000,
	5.194230e-001,
	-1.030450e+000,
	-1.533626e-001,
	2.268967e+000,
	-4.886576e-001,
	-6.336865e-001,
	3.911080e+000,
	-1.602643e-001,
	1.513730e-001,
	1.130153e+000,
	-1.159297e+000,
	-5.818314e-002,
	-1.488690e-001,
	1.358829e+000,
	1.208889e+000,
	-1.827456e+000,
	4.867277e-001,
	6.185880e+000,
	1.951064e-001,
	-1.023581e+000,
	-2.517540e-001,
	3.635148e+000,
	-2.375150e+000,
	-9.409992e+000,
	3.209554e+000,
	-3.006489e-001,
	-3.235953e+000,
	9.969505e-001,
	-1.102864e+000,
	-1.644399e-001,
	2.160645e+000,
	5.685422e+000,
	-2.867248e+000,
	-1.020916e+000,
	2.064591e-001,
	1.192668e+000,
	5.029621e-001,
	// albedo 1, turbidity 3
	-1.120417e+000,
	-1.543428e-001,
	-2.173869e+000,
	2.965267e+000,
	-1.062190e-001,
	8.112859e-001,
	1.448682e-001,
	4.993622e+000,
	6.373394e-001,
	-1.168618e+000,
	-1.948508e-001,
	-6.247560e-001,
	2.203402e+000,
	-2.724794e-001,
	8.364691e-001,
	5.608377e-002,
	4.262497e+000,
	6.310098e-001,
	-1.080229e+000,
	-2.282841e-001,
	2.194035e+000,
	-1.203336e+000,
	-3.861545e-001,
	2.234045e+000,
	1.553866e-001,
	-3.266039e+000,
	8.246847e-001,
	-1.101698e+000,
	2.182410e-002,
	-1.179116e+000,
	8.533844e-001,
	8.777171e-001,
	-1.222988e+000,
	5.021882e-001,
	9.364642e+000,
	4.790363e-001,
	-1.047144e+000,
	-2.539571e-001,
	3.684827e+000,
	9.827861e-002,
	-2.297266e-001,
	3.038327e+000,
	-2.609445e-001,
	-3.685112e+000,
	8.596057e-001,
	-1.103227e+000,
	-1.861499e-001,
	2.098952e+000,
	1.030900e-001,
	-4.268311e+000,
	-1.120060e+000,
	2.879792e-001,
	7.160893e-001,
	6.213207e-001,
	// albedo 1, turbidity 4
	-1.155288e+000,
	-2.006105e-001,
	-5.822630e-002,
	3.970794e-001,
	-2.828885e-001,
	5.093569e-001,
	1.631119e-001,
	4.152479e+000,
	6.357376e-001,
	-1.241627e+000,
	-2.673712e-001,
	-6.444494e-001,
	2.257014e+000,
	-1.630843e+000,
	5.967071e-001,
	9.888683e-003,
	4.308732e+000,
	6.751366e-001,
	-1.136812e+000,
	-2.811418e-001,
	2.220215e+000,
	-1.535870e+000,
	2.354743e+000,
	2.041362e+000,
	2.387976e-001,
	-3.453756e+000,
	7.672245e-001,
	-1.028322e+000,
	9.134962e-002,
	-1.151053e+000,
	6.511620e-001,
	-5.683098e+000,
	-2.001006e+000,
	6.430642e-001,
	8.523367e+000,
	5.422240e-001,
	-1.076830e+000,
	-3.101207e-001,
	3.052794e+000,
	3.177593e-001,
	3.054756e+000,
	3.386727e+000,
	-2.312489e-001,
	-3.908802e+000,
	7.978614e-001,
	-1.107083e+000,
	-1.880372e-001,
	2.001810e+000,
	-3.352202e-003,
	-1.526356e+000,
	-1.480550e+000,
	3.486524e-001,
	7.220325e-001,
	6.581821e-001,
	// albedo 1, turbidity 5
	-1.214879e+000,
	-2.719222e-001,
	2.247747e-001,
	1.509740e-002,
	-5.438281e-001,
	3.728351e-001,
	1.749880e-001,
	3.132220e+000,
	6.001432e-001,
	-1.424202e+000,
	-4.768943e-001,
	-6.396040e-001,
	2.060101e+000,
	-1.113780e+000,
	6.993089e-001,
	-2.098291e-002,
	2.504826e+000,
	6.757213e-001,
	-1.048548e+000,
	-1.173837e-001,
	1.885902e+000,
	-3.700301e+000,
	4.667326e+000,
	1.344798e+000,
	2.140261e-001,
	1.525414e-001,
	8.450168e-001,
	-1.056271e+000,
	-5.272364e-002,
	-1.391708e+000,
	9.711492e+000,
	-1.742761e+001,
	-1.677628e+000,
	6.906304e-001,
	4.107662e+000,
	4.268005e-001,
	-1.072328e+000,
	-2.450563e-001,
	3.125155e+000,
	-2.470389e+000,
	6.794968e+000,
	2.678049e+000,
	-2.092059e-001,
	-1.651858e+000,
	8.708740e-001,
	-1.107628e+000,
	-2.089585e-001,
	1.799168e+000,
	4.621596e-001,
	-5.008181e+000,
	-1.121127e+000,
	3.917217e-001,
	2.703209e-001,
	6.449597e-001,
	// albedo 1, turbidity 6
	-1.249741e+000,
	-3.073987e-001,
	1.398829e-001,
	-2.878563e-003,
	-5.008845e+000,
	4.535605e-001,
	1.447766e-001,
	3.091173e+000,
	6.138128e-001,
	-1.577209e+000,
	-6.213162e-001,
	2.895282e-001,
	1.670732e+000,
	8.708786e+000,
	2.480283e-001,
	7.326386e-002,
	1.395638e+000,
	5.814691e-001,
	-1.015394e+000,
	-9.306378e-002,
	4.870291e-001,
	-6.558243e+000,
	-1.073347e+001,
	1.842159e+000,
	2.135043e-002,
	1.655269e+000,
	9.750505e-001,
	-1.030222e+000,
	-3.712071e-002,
	-4.565649e-001,
	1.827249e+001,
	-4.505703e+000,
	-2.635230e+000,
	9.447498e-001,
	2.450865e+000,
	2.757082e-001,
	-1.086063e+000,
	-2.709359e-001,
	2.527868e+000,
	-1.786375e+000,
	-2.329338e+000,
	3.367729e+000,
	-4.201670e-001,
	-9.372873e-001,
	9.570917e-001,
	-1.113156e+000,
	-2.162986e-001,
	1.815038e+000,
	1.036606e-001,
	-1.106537e+000,
	-1.657558e+000,
	4.923976e-001,
	-1.768985e-002,
	6.218745e-001,
	// albedo 1, turbidity 7
	-1.345662e+000,
	-4.038158e-001,
	1.601105e-001,
	-6.892546e-003,
	-5.010308e+000,
	3.903794e-001,
	1.543535e-001,
	2.538245e+000,
	5.555141e-001,
	-1.998866e+000,
	-9.786972e-001,
	5.763250e-001,
	1.007104e+000,
	8.983795e+000,
	3.752110e-001,
	7.375525e-002,
	1.792659e-001,
	4.969463e-001,
	-7.854213e-001,
	1.186171e-001,
	-1.925047e-001,
	-3.567464e+000,
	-8.901606e+000,
	1.181923e+000,
	4.049067e-002,
	3.603602e+000,
	1.081550e+000,
	-1.113558e+000,
	-1.964692e-001,
	-6.175963e-002,
	7.345047e+000,
	-5.293662e+000,
	-1.720046e+000,
	8.863695e-001,
	-1.699694e-001,
	2.184709e-001,
	-1.077319e+000,
	-2.429937e-001,
	2.226652e+000,
	8.082352e+000,
	-5.647382e-001,
	2.187018e+000,
	-3.571678e-001,
	-2.370890e-001,
	9.528157e-001,
	-1.101702e+000,
	-2.020333e-001,
	1.637670e+000,
	5.276716e-001,
	-4.006007e+000,
	-1.066501e+000,
	4.548015e-001,
	4.055769e-001,
	6.485706e-001,
	// albedo 1, turbidity 8
	-1.411469e+000,
	-4.870956e-001,
	1.017578e-001,
	-8.806763e-003,
	-5.014847e+000,
	4.306981e-001,
	1.278033e-001,
	2.361142e+000,
	5.472925e-001,
	-2.735007e+000,
	-1.453253e+000,
	5.783189e-001,
	5.673243e-001,
	9.968637e+000,
	2.236397e-001,
	1.860109e-001,
	-3.781953e-001,
	2.505082e-001,
	-7.371503e-001,
	1.290592e-001,
	-5.349577e-001,
	-1.885854e+000,
	-8.623054e+000,
	1.078614e+000,
	-5.694996e-002,
	4.526279e+000,
	1.347569e+000,
	-9.678370e-001,
	-2.562830e-001,
	2.961987e-001,
	2.461144e+000,
	-4.753928e+000,
	-1.657373e+000,
	8.388825e-001,
	-2.440974e+000,
	1.816225e-002,
	-1.148918e+000,
	-2.271366e-001,
	1.817890e+000,
	1.097345e+001,
	-1.126160e+000,
	1.993895e+000,
	-2.870862e-001,
	7.269217e-001,
	1.032783e+000,
	-1.090291e+000,
	-2.315314e-001,
	1.491197e+000,
	9.632479e+000,
	-4.323932e+000,
	-1.326631e+000,
	3.604933e-001,
	1.905995e-001,
	6.312241e-001,
	// albedo 1, turbidity 9
	-1.552618e+000,
	-6.336918e-001,
	4.605315e-002,
	-8.452985e-003,
	-4.979015e+000,
	3.484674e-001,
	8.791637e-002,
	2.297399e+000,
	5.705230e-001,
	-2.770597e+000,
	-1.302036e+000,
	3.421676e-001,
	1.220769e+000,
	7.584372e+000,
	4.050789e-001,
	4.478808e-002,
	9.435710e-001,
	2.393878e-001,
	-2.631791e+000,
	-1.247576e+000,
	-8.423940e-001,
	-3.955998e+000,
	-5.341100e+000,
	6.385142e-001,
	3.872948e-001,
	2.279807e+000,
	1.101259e+000,
	1.875824e-001,
	3.564184e-001,
	7.973268e-001,
	7.159160e+000,
	-3.857340e+000,
	-9.227702e-001,
	8.283793e-002,
	-1.444145e+000,
	3.654244e-001,
	-1.489693e+000,
	-4.947623e-001,
	1.253918e+000,
	3.949282e+000,
	-1.320903e+000,
	1.088652e+000,
	1.489763e-001,
	-3.855853e-001,
	8.130960e-001,
	-1.042349e+000,
	-2.134514e-001,
	1.289359e+000,
	-3.129206e-003,
	-2.385397e+000,
	-7.642278e-001,
	3.772293e-001,
	3.683001e-001,
	6.811674e-001,
	// albedo 1, turbidity 10
	-1.924886e+000,
	-9.354584e-001,
	-1.879067e-001,
	1.267892e+000,
	-1.174622e+000,
	5.570232e-001,
	-1.060836e-005,
	2.002481e+000,
	9.001398e-001,
	-1.556107e+000,
	-8.200410e-001,
	-1.065249e-001,
	-3.241942e-001,
	1.552504e-001,
	7.662815e-002,
	-2.568474e-002,
	1.738474e+000,
	-2.100942e-001,
	-7.169297e+000,
	-2.972878e+000,
	-1.324108e+000,
	7.276378e-003,
	2.638975e+000,
	1.186150e+000,
	5.695709e-001,
	2.027718e+000,
	1.328077e+000,
	1.889259e+000,
	2.600110e-001,
	1.309033e+000,
	1.187864e+000,
	-6.905754e+000,
	-1.163025e+000,
	-1.642758e-001,
	-1.774036e+000,
	2.566466e-001,
	-1.816439e+000,
	-3.601966e-001,
	6.367922e-001,
	6.798160e+000,
	-6.431562e-001,
	9.014269e-001,
	2.490693e-001,
	-6.685128e-003,
	8.542883e-001,
	-9.684886e-001,
	-3.866519e-001,
	1.268224e+000,
	-4.187273e-003,
	-1.833316e+000,
	-4.626197e-001,
	2.263859e-001,
	-5.583963e-001,
	6.650112e-001,
};

double datasetRad640[] = 
{
	// albedo 0, turbidity 1
	1.197895e-001,
	7.750667e-002,
	2.407021e-001,
	3.903099e-001,
	2.932408e-001,
	3.006399e-001,
	// albedo 0, turbidity 2
	1.209424e-001,
	8.265434e-002,
	2.083945e-001,
	5.853826e-001,
	2.663490e-001,
	3.373078e-001,
	// albedo 0, turbidity 3
	1.161191e-001,
	9.288397e-002,
	1.219496e-001,
	9.247264e-001,
	2.049420e-001,
	4.043150e-001,
	// albedo 0, turbidity 4
	1.073493e-001,
	1.169092e-001,
	-6.161409e-002,
	1.431414e+000,
	1.494847e-001,
	4.931987e-001,
	// albedo 0, turbidity 5
	9.794193e-002,
	1.457214e-001,
	-2.558067e-001,
	1.850120e+000,
	1.802584e-001,
	5.523752e-001,
	// albedo 0, turbidity 6
	9.153358e-002,
	1.740591e-001,
	-4.147944e-001,
	2.143293e+000,
	1.718393e-001,
	6.142311e-001,
	// albedo 0, turbidity 7
	8.281154e-002,
	2.131901e-001,
	-6.172447e-001,
	2.462224e+000,
	2.434283e-001,
	6.958915e-001,
	// albedo 0, turbidity 8
	7.214826e-002,
	2.499471e-001,
	-8.009912e-001,
	2.650458e+000,
	4.904950e-001,
	8.061404e-001,
	// albedo 0, turbidity 9
	6.109653e-002,
	2.500028e-001,
	-7.962813e-001,
	2.317194e+000,
	1.174011e+000,
	9.080407e-001,
	// albedo 0, turbidity 10
	5.281779e-002,
	1.966643e-001,
	-5.387787e-001,
	1.359134e+000,
	2.260367e+000,
	1.063031e+000,
	// albedo 1, turbidity 1
	1.241851e-001,
	9.705702e-002,
	2.016387e-001,
	4.445551e-001,
	6.215866e-001,
	7.528173e-001,
	// albedo 1, turbidity 2
	1.248417e-001,
	1.001877e-001,
	1.809281e-001,
	6.156329e-001,
	6.384930e-001,
	8.001681e-001,
	// albedo 1, turbidity 3
	1.215185e-001,
	1.116381e-001,
	9.409322e-002,
	9.385153e-001,
	6.300761e-001,
	8.884105e-001,
	// albedo 1, turbidity 4
	1.132146e-001,
	1.313387e-001,
	-7.312012e-002,
	1.408822e+000,
	6.509308e-001,
	1.009256e+000,
	// albedo 1, turbidity 5
	1.032816e-001,
	1.663390e-001,
	-2.911491e-001,
	1.869933e+000,
	6.563583e-001,
	1.150412e+000,
	// albedo 1, turbidity 6
	9.701537e-002,
	1.883206e-001,
	-4.243771e-001,
	2.104057e+000,
	7.155674e-001,
	1.228579e+000,
	// albedo 1, turbidity 7
	8.841369e-002,
	2.160578e-001,
	-5.725878e-001,
	2.290829e+000,
	9.251758e-001,
	1.303580e+000,
	// albedo 1, turbidity 8
	7.850642e-002,
	2.390426e-001,
	-6.946719e-001,
	2.320692e+000,
	1.325887e+000,
	1.424719e+000,
	// albedo 1, turbidity 9
	6.825538e-002,
	2.253718e-001,
	-6.265067e-001,
	1.821317e+000,
	2.158738e+000,
	1.529418e+000,
	// albedo 1, turbidity 10
	5.985528e-002,
	1.644544e-001,
	-3.362673e-001,
	7.751736e-001,
	3.306230e+000,
	1.654105e+000,
};

double dataset680[] = 
{
	// albedo 0, turbidity 1
	-1.112655e+000,
	-1.844098e-001,
	-3.170582e+000,
	5.334685e+000,
	-6.690891e-002,
	1.561122e+000,
	-2.792088e-006,
	1.400688e+000,
	6.639418e-001,
	-1.138469e+000,
	-1.797086e-001,
	1.271179e+000,
	1.158372e+000,
	-1.687824e-001,
	1.414051e+000,
	4.258569e-003,
	2.135675e+000,
	5.322718e-001,
	-1.026337e+000,
	-1.861539e-001,
	2.119648e+000,
	-6.753200e-001,
	-1.972700e-001,
	2.384659e+000,
	-1.304972e-002,
	-1.804518e+000,
	1.207802e+000,
	-1.198321e+000,
	-1.585305e-001,
	1.339219e+000,
	5.796904e-001,
	-5.143433e-002,
	1.107455e+000,
	2.551349e-002,
	3.346946e+000,
	-3.387602e-002,
	-9.935091e-001,
	-1.747698e-001,
	2.816779e+000,
	-3.496148e-001,
	1.832218e+000,
	2.324658e+000,
	-3.408305e-002,
	-1.618451e+000,
	1.189512e+000,
	-1.092682e+000,
	-1.840784e-001,
	2.455887e+000,
	1.441429e-001,
	-4.002347e+000,
	1.186375e+000,
	3.634755e-002,
	3.070963e-001,
	5.512501e-001,
	// albedo 0, turbidity 2
	-1.104975e+000,
	-1.425541e-001,
	-1.889148e+000,
	3.408593e+000,
	-1.252648e-001,
	1.396095e+000,
	8.358812e-002,
	3.814297e+000,
	6.848154e-001,
	-1.131570e+000,
	-1.500053e-001,
	-1.048539e+000,
	3.133642e+000,
	-2.651219e-001,
	1.193999e+000,
	7.013543e-002,
	4.592749e+000,
	6.857750e-001,
	-1.030016e+000,
	-1.667752e-001,
	6.179600e+000,
	-5.163198e+000,
	-4.084328e-001,
	2.617798e+000,
	1.966627e-003,
	-2.417731e+000,
	8.402310e-001,
	-1.167563e+000,
	-3.644294e-002,
	-4.501893e+000,
	4.471663e+000,
	-5.377956e-001,
	4.971351e-002,
	4.621337e-001,
	1.014187e+001,
	4.411276e-001,
	-1.018402e+000,
	-2.068288e-001,
	4.710566e+000,
	-1.425858e+000,
	1.287815e-001,
	3.605281e+000,
	-2.164599e-001,
	-4.336932e+000,
	9.051639e-001,
	-1.078985e+000,
	-1.995548e-001,
	1.678948e+000,
	3.074167e-001,
	-1.642830e+000,
	-1.235470e-001,
	2.735898e-001,
	6.360197e-001,
	5.870665e-001,
	// albedo 0, turbidity 3
	-1.132881e+000,
	-1.676238e-001,
	-1.179974e+000,
	1.902080e+000,
	-7.980402e-002,
	8.946611e-001,
	1.939671e-001,
	3.793414e+000,
	6.357246e-001,
	-1.138356e+000,
	-1.681053e-001,
	1.548320e+000,
	-6.001024e-001,
	-4.138892e-001,
	2.586807e-001,
	2.126762e-001,
	4.742849e+000,
	5.910253e-001,
	-1.093982e+000,
	-1.847904e-001,
	1.234133e+000,
	-4.707125e-001,
	1.076579e+000,
	3.355751e+000,
	5.394600e-002,
	-2.314910e+000,
	8.900752e-001,
	-1.117812e+000,
	-6.182272e-002,
	-4.681118e-001,
	5.075227e+000,
	-1.561122e+001,
	-2.343845e+000,
	5.618788e-001,
	7.005713e+000,
	4.622191e-001,
	-1.013135e+000,
	-1.529086e-001,
	1.960772e+000,
	-3.022528e+000,
	8.938126e+000,
	4.411437e+000,
	3.156643e-002,
	-1.449180e+000,
	8.181914e-001,
	-1.087086e+000,
	-2.231900e-001,
	1.871061e+000,
	1.830836e+000,
	-4.397140e+000,
	-5.441402e-001,
	2.728682e-001,
	-5.607736e-002,
	6.741811e-001,
	// albedo 0, turbidity 4
	-1.176035e+000,
	-2.099056e-001,
	-8.221907e-001,
	1.520994e+000,
	-2.507738e-001,
	9.100863e-001,
	1.507234e-001,
	3.661138e+000,
	6.726424e-001,
	-1.140180e+000,
	-1.918480e-001,
	2.844393e-001,
	-3.842927e-001,
	-5.520764e-001,
	-1.868484e-001,
	2.247948e-001,
	5.381202e+000,
	6.059726e-001,
	-1.282085e+000,
	-3.059464e-001,
	1.619956e+000,
	-1.362117e+000,
	2.324649e+000,
	3.350678e+000,
	2.102082e-001,
	-4.028753e+000,
	8.172091e-001,
	-9.092985e-001,
	4.843416e-002,
	-1.076741e+000,
	8.143038e+000,
	-1.618418e+001,
	-3.681285e+000,
	5.217800e-001,
	7.307672e+000,
	5.312006e-001,
	-1.110248e+000,
	-2.047143e-001,
	1.565253e+000,
	-4.575474e+000,
	8.737741e+000,
	5.023419e+000,
	2.469230e-001,
	-1.716906e+000,
	7.856742e-001,
	-1.054900e+000,
	-2.018466e-001,
	1.352034e+000,
	2.656066e+000,
	-4.403444e+000,
	-1.479998e+000,
	3.939305e-001,
	6.455032e-001,
	6.775162e-001,
	// albedo 0, turbidity 5
	-1.237521e+000,
	-2.734963e-001,
	-4.554763e-001,
	3.417711e-001,
	2.054204e-001,
	3.954470e-001,
	2.366979e-001,
	3.239693e+000,
	6.083737e-001,
	-1.354583e+000,
	-4.251172e-001,
	-3.241668e-001,
	2.077967e+000,
	-1.910410e+000,
	8.755633e-001,
	-8.365829e-002,
	2.443727e+000,
	7.260119e-001,
	-1.152500e+000,
	-1.277879e-001,
	1.089367e+000,
	-4.497520e+000,
	5.636501e+000,
	1.249272e+000,
	5.829396e-001,
	9.198423e-001,
	7.039872e-001,
	-9.782313e-001,
	-8.253891e-002,
	-5.673470e-001,
	1.098032e+001,
	-1.689550e+001,
	-1.619205e+000,
	2.125660e-001,
	2.080566e+000,
	6.315535e-001,
	-1.064286e+000,
	-1.710957e-001,
	9.336921e-001,
	-5.525059e+000,
	8.053084e+000,
	2.664602e+000,
	4.815015e-001,
	4.884965e-001,
	7.093015e-001,
	-1.067798e+000,
	-1.817268e-001,
	1.095720e+000,
	3.551145e+000,
	-5.009504e+000,
	-4.802047e-001,
	4.854159e-001,
	8.021585e-001,
	7.133339e-001,
	// albedo 0, turbidity 6
	-1.251896e+000,
	-2.936510e-001,
	-3.090944e-002,
	-5.488869e-003,
	-6.577788e-001,
	4.577691e-001,
	1.780002e-001,
	3.335561e+000,
	6.394482e-001,
	-1.615603e+000,
	-6.405318e-001,
	-4.651954e-001,
	2.332689e+000,
	-1.893131e-001,
	3.391170e-001,
	3.495888e-002,
	1.058634e+000,
	6.310524e-001,
	-9.703572e-001,
	1.437971e-002,
	6.532383e-001,
	-6.450045e+000,
	4.026380e+000,
	2.198628e+000,
	2.684967e-001,
	2.873804e+000,
	8.626816e-001,
	-1.053437e+000,
	-1.577255e-001,
	-2.354526e-001,
	1.753047e+001,
	-1.802766e+001,
	-3.193379e+000,
	6.264380e-001,
	3.733714e-001,
	4.466776e-001,
	-1.051388e+000,
	-1.690749e-001,
	6.925698e-001,
	-7.450365e+000,
	7.747780e+000,
	3.681960e+000,
	1.688173e-001,
	9.054528e-001,
	8.229209e-001,
	-1.060369e+000,
	-1.751603e-001,
	8.678290e-001,
	5.136962e+000,
	-5.014566e+000,
	-1.283438e+000,
	6.547844e-001,
	9.420523e-001,
	6.738511e-001,
	// albedo 0, turbidity 7
	-1.358251e+000,
	-3.909003e-001,
	-7.590093e-002,
	-8.010253e-003,
	-2.417641e-001,
	5.031789e-001,
	1.882499e-001,
	2.807060e+000,
	5.884485e-001,
	-2.043506e+000,
	-9.923881e-001,
	-4.530797e-001,
	1.750575e+000,
	-4.362236e-001,
	2.997323e-001,
	2.328504e-002,
	1.626543e-001,
	5.806819e-001,
	-7.280672e-001,
	2.228069e-001,
	2.169765e-001,
	-3.681736e+000,
	4.308793e+000,
	1.308622e+000,
	3.451835e-001,
	4.037459e+000,
	9.113772e-001,
	-1.155299e+000,
	-3.079453e-001,
	-1.640569e-001,
	7.663297e+000,
	-1.327817e+001,
	-1.431157e+000,
	4.096359e-001,
	-9.185502e-001,
	4.578034e-001,
	-1.006427e+000,
	-1.250087e-001,
	7.477012e-001,
	2.612704e+000,
	2.531799e+000,
	1.565371e+000,
	3.452604e-001,
	9.129266e-001,
	7.684386e-001,
	-1.068759e+000,
	-1.729191e-001,
	5.265652e-001,
	7.074812e+000,
	-4.259958e+000,
	-4.833255e-001,
	6.043380e-001,
	1.489203e+000,
	7.089074e-001,
	// albedo 0, turbidity 8
	-1.398983e+000,
	-4.500153e-001,
	-5.189309e-001,
	1.546325e-001,
	4.187327e-001,
	2.811516e-001,
	2.379667e-001,
	2.801040e+000,
	5.198375e-001,
	-2.970455e+000,
	-1.529948e+000,
	1.094532e-001,
	7.382263e-001,
	-1.024683e+000,
	2.074091e-001,
	1.397605e-001,
	-6.743828e-001,
	3.496944e-001,
	-3.942086e-001,
	3.424842e-001,
	-1.253259e+000,
	-9.268654e-001,
	5.636065e+000,
	8.224289e-001,
	2.452235e-001,
	5.864258e+000,
	1.202820e+000,
	-1.181174e+000,
	-4.197175e-001,
	1.429102e+000,
	-7.894317e-003,
	-1.239152e+001,
	-5.753431e-001,
	3.552180e-001,
	-4.495555e+000,
	2.141883e-001,
	-1.060281e+000,
	-1.080598e-001,
	-3.276480e-001,
	1.369250e+001,
	1.504389e+000,
	6.401191e-001,
	2.437501e-001,
	3.212918e+000,
	9.172133e-001,
	-1.037564e+000,
	-2.018083e-001,
	6.250668e-001,
	-2.525843e-003,
	-3.269998e+000,
	-2.649814e-001,
	6.600589e-001,
	3.337508e-001,
	6.516131e-001,
	// albedo 0, turbidity 9
	-1.610481e+000,
	-6.353902e-001,
	-5.968977e-001,
	1.414037e+000,
	-7.941453e-001,
	7.888684e-001,
	2.209045e-002,
	2.615106e+000,
	6.870260e-001,
	-3.073343e+000,
	-1.365905e+000,
	-2.651943e-001,
	-1.685310e+000,
	4.755874e-001,
	-1.110669e-001,
	2.561961e-001,
	1.222045e+000,
	3.362780e-002,
	-2.207768e+000,
	-1.009608e+000,
	-1.329601e+000,
	3.393091e+000,
	3.419104e+000,
	-4.733375e-002,
	5.989185e-001,
	2.814641e+000,
	1.245189e+000,
	-1.981173e-002,
	2.018414e-001,
	1.457765e+000,
	-6.316169e+000,
	-6.640569e+000,
	7.150646e-001,
	-2.993748e-001,
	-2.703376e+000,
	3.218596e-001,
	-1.435873e+000,
	-3.390505e-001,
	-3.859047e-001,
	1.457464e+001,
	-1.121591e+000,
	-6.089868e-002,
	5.319220e-001,
	1.852395e+000,
	8.379521e-001,
	-9.812568e-001,
	-2.273751e-001,
	5.108069e-001,
	-3.735693e-003,
	-2.547988e+000,
	-4.492561e-001,
	5.069199e-001,
	2.977910e-001,
	6.639273e-001,
	// albedo 0, turbidity 10
	-2.056405e+000,
	-9.703512e-001,
	-3.731953e-001,
	2.052022e+000,
	-1.445283e+000,
	6.103743e-001,
	-9.389644e-006,
	2.198652e+000,
	8.567335e-001,
	-2.105651e+000,
	-8.924283e-001,
	-6.868702e-001,
	-1.665838e+000,
	4.795702e-001,
	5.228080e-001,
	-4.272483e-002,
	2.661317e+000,
	-1.154062e-001,
	-6.179767e+000,
	-2.651580e+000,
	-1.527652e+000,
	2.692054e+000,
	2.293427e+000,
	-1.005611e-001,
	9.545323e-001,
	1.367438e+000,
	1.169193e+000,
	1.240848e+000,
	1.126706e-001,
	1.620422e+000,
	-3.384604e+000,
	-5.545532e+000,
	4.928203e-001,
	-5.999585e-001,
	-1.407078e+000,
	4.193816e-001,
	-1.539149e+000,
	-2.081890e-001,
	-4.552234e-001,
	1.056410e+001,
	-1.048637e+000,
	-2.780921e-001,
	5.682296e-001,
	6.785092e-001,
	7.729892e-001,
	-1.036841e+000,
	-4.359099e-001,
	4.767834e-001,
	-3.794262e-003,
	-1.980492e+000,
	9.954067e-002,
	3.037557e-001,
	2.156592e-002,
	6.845201e-001,
	// albedo 1, turbidity 1
	-1.110980e+000,
	-1.799491e-001,
	-3.168600e+000,
	5.336662e+000,
	-6.318131e-002,
	1.559251e+000,
	3.204341e-003,
	1.401140e+000,
	6.638144e-001,
	-1.132332e+000,
	-1.786787e-001,
	1.272954e+000,
	1.160211e+000,
	-1.685885e-001,
	1.409550e+000,
	7.140682e-003,
	2.136473e+000,
	5.320908e-001,
	-1.015776e+000,
	-1.825058e-001,
	2.122848e+000,
	-6.725506e-001,
	-1.976294e-001,
	2.376807e+000,
	-1.859856e-002,
	-1.803033e+000,
	1.207528e+000,
	-1.189845e+000,
	-1.509036e-001,
	1.345709e+000,
	5.832609e-001,
	-5.130839e-002,
	1.097035e+000,
	2.686911e-002,
	3.349361e+000,
	-3.431297e-002,
	-1.000281e+000,
	-1.696328e-001,
	2.829408e+000,
	-3.466041e-001,
	1.832532e+000,
	2.314637e+000,
	-2.721994e-002,
	-1.614939e+000,
	1.188720e+000,
	-1.120411e+000,
	-1.974172e-001,
	2.474172e+000,
	1.453506e-001,
	-4.002206e+000,
	1.180333e+000,
	2.229171e-002,
	3.112615e-001,
	5.505539e-001,
	// albedo 1, turbidity 2
	-1.112667e+000,
	-1.574855e-001,
	-2.284814e+000,
	4.255050e+000,
	-1.386097e-001,
	1.459506e+000,
	4.508931e-002,
	2.944474e+000,
	7.339984e-001,
	-1.113577e+000,
	-1.331062e-001,
	-1.828757e+000,
	3.910596e+000,
	-2.095519e-001,
	1.159335e+000,
	9.311608e-002,
	4.517295e+000,
	6.365313e-001,
	-1.061651e+000,
	-2.007134e-001,
	5.907472e+000,
	-4.808769e+000,
	-2.120206e-001,
	2.727568e+000,
	-4.222666e-002,
	-2.599674e+000,
	9.265659e-001,
	-1.136633e+000,
	-4.281875e-003,
	-3.407541e+000,
	4.132332e+000,
	-3.866153e-001,
	-5.082717e-001,
	4.828348e-001,
	9.797167e+000,
	3.325034e-001,
	-1.027909e+000,
	-2.334388e-001,
	4.972147e+000,
	-1.499736e+000,
	9.598438e-002,
	2.744895e+000,
	-3.558702e-001,
	-4.288054e+000,
	1.000138e+000,
	-1.102843e+000,
	-1.875642e-001,
	2.087760e+000,
	3.692600e-001,
	-6.520835e-001,
	-9.598766e-001,
	2.984231e-001,
	4.045786e-001,
	5.091931e-001,
	// albedo 1, turbidity 3
	-1.117485e+000,
	-1.492968e-001,
	-2.639425e+000,
	3.672106e+000,
	-1.058342e-001,
	1.098101e+000,
	1.544782e-001,
	4.496691e+000,
	6.582312e-001,
	-1.123872e+000,
	-1.467158e-001,
	3.049045e+000,
	-2.607634e+000,
	-2.505495e-001,
	-8.310458e-002,
	3.333822e-001,
	4.631418e+000,
	5.120491e-001,
	-1.118262e+000,
	-2.462050e-001,
	-8.333919e-002,
	2.438788e+000,
	6.143236e-001,
	3.745903e+000,
	-2.043295e-001,
	-3.451983e+000,
	1.056003e+000,
	-1.095394e+000,
	2.009680e-002,
	8.468659e-001,
	1.230624e-002,
	-8.638525e+000,
	-2.989487e+000,
	8.735734e-001,
	8.533740e+000,
	2.548062e-001,
	-1.035035e+000,
	-2.296018e-001,
	2.722309e+000,
	1.849369e-001,
	3.440975e+000,
	4.372083e+000,
	-4.747494e-001,
	-2.984092e+000,
	1.009737e+000,
	-1.113497e+000,
	-1.931400e-001,
	2.288509e+000,
	4.973129e-002,
	-1.353292e-001,
	-1.587772e+000,
	4.073801e-001,
	-8.180513e-003,
	5.682569e-001,
	// albedo 1, turbidity 4
	-1.172242e+000,
	-2.084847e-001,
	-1.212027e+000,
	1.991627e+000,
	-1.403495e-001,
	7.684996e-001,
	1.582914e-001,
	3.407597e+000,
	6.659386e-001,
	-1.167834e+000,
	-2.117291e-001,
	1.196578e+000,
	-1.438719e+000,
	-3.137939e-001,
	-4.537552e-002,
	2.260096e-001,
	4.659389e+000,
	5.776369e-001,
	-1.222298e+000,
	-2.893306e-001,
	9.080116e-001,
	1.413518e+000,
	1.709237e+000,
	2.915962e+000,
	8.464584e-002,
	-3.867076e+000,
	9.110543e-001,
	-9.554071e-001,
	6.610246e-002,
	-3.323811e-001,
	2.702543e+000,
	-1.345592e+001,
	-3.119309e+000,
	7.740473e-001,
	7.452516e+000,
	3.929172e-001,
	-1.119763e+000,
	-2.579942e-001,
	2.830634e+000,
	-1.333418e+000,
	6.825773e+000,
	4.230596e+000,
	-2.654108e-001,
	-2.669457e+000,
	9.126183e-001,
	-1.084261e+000,
	-2.086570e-001,
	2.248616e+000,
	6.993871e-001,
	-2.391760e+000,
	-1.738827e+000,
	3.674794e-001,
	-5.324741e-001,
	6.183292e-001,
	// albedo 1, turbidity 5
	-1.226325e+000,
	-2.688667e-001,
	-1.462040e-001,
	4.749868e-001,
	-8.718681e-002,
	4.956704e-001,
	1.752427e-001,
	2.933911e+000,
	6.470198e-001,
	-1.359737e+000,
	-3.985716e-001,
	-1.570034e-001,
	1.277905e+000,
	-1.314322e+000,
	4.320873e-001,
	8.532731e-002,
	2.774395e+000,
	6.318556e-001,
	-1.088212e+000,
	-1.688766e-001,
	1.399098e+000,
	-3.254950e+000,
	4.733557e+000,
	2.079183e+000,
	1.907990e-001,
	-9.540048e-001,
	8.714774e-001,
	-1.034524e+000,
	-1.050729e-002,
	-8.054376e-001,
	1.166351e+001,
	-1.879498e+001,
	-3.021428e+000,
	7.755251e-001,
	4.516574e+000,
	4.092690e-001,
	-1.076150e+000,
	-2.551781e-001,
	2.797790e+000,
	-5.437950e+000,
	9.156159e+000,
	3.988462e+000,
	-2.324172e-001,
	-2.124766e+000,
	8.863276e-001,
	-1.103432e+000,
	-2.058047e-001,
	2.117130e+000,
	2.401558e+000,
	-5.015370e+000,
	-1.829480e+000,
	4.046378e-001,
	-2.078794e-001,
	6.449045e-001,
	// albedo 1, turbidity 6
	-1.263516e+000,
	-3.133966e-001,
	3.174560e-001,
	-4.989246e-003,
	-2.317630e+000,
	3.963746e-001,
	1.677262e-001,
	2.563898e+000,
	6.335899e-001,
	-1.577927e+000,
	-5.893907e-001,
	-2.991531e-001,
	1.783728e+000,
	3.693827e+000,
	5.704918e-001,
	6.768069e-002,
	2.215180e+000,
	6.196162e-001,
	-9.191335e-001,
	-4.529201e-002,
	1.577262e+000,
	-6.455191e+000,
	-4.020064e+000,
	1.309911e+000,
	1.373281e-001,
	-7.178508e-001,
	9.243738e-001,
	-1.144508e+000,
	-9.289247e-002,
	-1.606387e+000,
	2.061805e+001,
	-1.051527e+001,
	-2.077164e+000,
	8.328239e-001,
	4.729795e+000,
	3.298487e-001,
	-1.018834e+000,
	-2.186851e-001,
	3.321767e+000,
	-7.887012e+000,
	3.374834e+000,
	3.005232e+000,
	-2.515037e-001,
	-2.656610e+000,
	9.316017e-001,
	-1.125230e+000,
	-2.422532e-001,
	1.850916e+000,
	6.213105e+000,
	-5.017914e+000,
	-1.644457e+000,
	3.811828e-001,
	-1.772362e-001,
	6.297360e-001,
	// albedo 1, turbidity 7
	-1.365631e+000,
	-4.017085e-001,
	1.942501e-001,
	-7.073927e-003,
	-1.461125e-001,
	4.898017e-001,
	1.623346e-001,
	2.330174e+000,
	5.983242e-001,
	-1.957177e+000,
	-9.640834e-001,
	-2.217521e-001,
	1.316645e+000,
	-1.907085e-001,
	1.134191e-002,
	9.704476e-002,
	3.828565e-002,
	5.538419e-001,
	-7.832629e-001,
	1.949904e-001,
	6.232354e-001,
	-2.947737e+000,
	3.702377e+000,
	2.212239e+000,
	9.128296e-002,
	3.131504e+000,
	9.923939e-001,
	-1.121562e+000,
	-2.704893e-001,
	-5.161748e-001,
	8.115427e+000,
	-1.443497e+001,
	-3.292676e+000,
	8.232212e-001,
	-1.548451e-002,
	3.199244e-001,
	-1.059207e+000,
	-1.613941e-001,
	2.375866e+000,
	-9.517705e-002,
	4.514722e+000,
	3.755824e+000,
	-1.696953e-001,
	-2.539157e-001,
	8.992553e-001,
	-1.108877e+000,
	-2.404852e-001,
	1.830175e+000,
	2.808956e+000,
	-4.932362e+000,
	-2.042775e+000,
	4.168739e-001,
	-2.534590e-001,
	6.533212e-001,
	// albedo 1, turbidity 8
	-1.405398e+000,
	-4.540068e-001,
	-4.766512e-001,
	1.871207e-001,
	5.535070e-001,
	-4.467365e-002,
	2.846366e-001,
	2.443422e+000,
	5.035706e-001,
	-2.843953e+000,
	-1.562366e+000,
	8.527921e-001,
	5.991182e-001,
	-9.984088e-001,
	7.599314e-001,
	-2.025184e-002,
	-1.515050e+000,
	4.397429e-001,
	-5.156586e-001,
	3.789775e-001,
	-1.194407e+000,
	-7.591558e-001,
	4.515532e+000,
	4.795814e-001,
	3.163186e-001,
	5.993132e+000,
	1.096327e+000,
	-1.070353e+000,
	-4.037269e-001,
	1.108932e+000,
	1.269159e+000,
	-1.099135e+001,
	-1.049849e+000,
	4.644725e-001,
	-4.387074e+000,
	2.704008e-001,
	-1.136211e+000,
	-1.473182e-001,
	1.235769e+000,
	5.725364e+000,
	1.712036e+000,
	1.630777e+000,
	3.656685e-002,
	2.082798e+000,
	9.036801e-001,
	-1.083101e+000,
	-2.468910e-001,
	1.894919e+000,
	6.574012e+000,
	-4.949098e+000,
	-1.132033e+000,
	3.336584e-001,
	-7.321133e-001,
	6.606587e-001,
	// albedo 1, turbidity 9
	-1.609910e+000,
	-6.550380e-001,
	-5.773346e-001,
	1.426156e+000,
	-5.000686e-001,
	8.257866e-001,
	1.839148e-002,
	2.106656e+000,
	6.957214e-001,
	-3.047283e+000,
	-1.421592e+000,
	-4.003615e-001,
	-6.531692e-001,
	5.643821e-001,
	-2.693762e-001,
	2.295553e-001,
	5.533910e-001,
	2.751822e-002,
	-2.160824e+000,
	-9.212504e-001,
	-8.438420e-001,
	1.466021e+000,
	1.124686e+000,
	-6.848173e-002,
	6.224893e-001,
	3.137662e+000,
	1.224147e+000,
	1.444817e-002,
	1.418426e-001,
	7.055176e-001,
	-1.787432e+000,
	-1.625625e+000,
	7.638401e-001,
	-3.309940e-001,
	-3.414755e+000,
	3.580691e-001,
	-1.480512e+000,
	-3.141638e-001,
	1.193403e+000,
	6.152773e+000,
	-3.314867e+000,
	1.345353e-001,
	5.359935e-001,
	1.409582e+000,
	8.072343e-001,
	-1.016066e+000,
	-2.346375e-001,
	1.457587e+000,
	-2.761458e-003,
	-2.546952e+000,
	-6.058542e-001,
	3.134230e-001,
	-2.232281e-001,
	6.760089e-001,
	// albedo 1, turbidity 10
	-2.019395e+000,
	-9.550942e-001,
	-1.187885e-001,
	1.995372e+000,
	-1.604228e+000,
	4.995785e-001,
	-9.647137e-006,
	1.929333e+000,
	8.659254e-001,
	-2.071307e+000,
	-9.485438e-001,
	-3.817151e-001,
	-1.657017e+000,
	9.488626e-001,
	5.816145e-001,
	-3.856514e-002,
	1.677756e+000,
	-1.262572e-001,
	-6.388445e+000,
	-2.738739e+000,
	-9.872469e-001,
	2.450058e+000,
	1.075999e+000,
	2.305434e-002,
	8.598771e-001,
	1.853582e+000,
	1.180017e+000,
	1.742851e+000,
	2.950102e-001,
	1.015937e+000,
	-2.511194e+000,
	-3.829361e+000,
	-1.126698e-001,
	-4.564605e-001,
	-2.097128e+000,
	4.012648e-001,
	-1.845177e+000,
	-3.242819e-001,
	7.060963e-001,
	7.747868e+000,
	-1.721532e+000,
	6.057347e-001,
	4.266212e-001,
	3.153697e-001,
	7.958222e-001,
	-9.599955e-001,
	-3.732025e-001,
	1.381129e+000,
	-3.983023e-003,
	-1.941446e+000,
	-5.943490e-001,
	2.269207e-001,
	-7.249738e-001,
	6.710888e-001,
};

double datasetRad680[] = 
{
	// albedo 0, turbidity 1
	1.069136e-001,
	7.429652e-002,
	2.056544e-001,
	2.763020e-001,
	2.214969e-001,
	2.265690e-001,
	// albedo 0, turbidity 2
	1.104352e-001,
	7.802008e-002,
	1.987620e-001,
	4.426471e-001,
	1.961324e-001,
	2.622675e-001,
	// albedo 0, turbidity 3
	1.098059e-001,
	7.983873e-002,
	1.632683e-001,
	7.073005e-001,
	1.731280e-001,
	3.099027e-001,
	// albedo 0, turbidity 4
	1.031706e-001,
	8.474020e-002,
	5.727517e-002,
	1.115427e+000,
	1.666019e-001,
	3.729170e-001,
	// albedo 0, turbidity 5
	9.321128e-002,
	1.157084e-001,
	-1.460692e-001,
	1.597840e+000,
	1.062877e-001,
	4.640498e-001,
	// albedo 0, turbidity 6
	8.816825e-002,
	1.391452e-001,
	-2.899934e-001,
	1.874267e+000,
	1.135532e-001,
	5.090668e-001,
	// albedo 0, turbidity 7
	7.855885e-002,
	1.795611e-001,
	-5.035302e-001,
	2.242952e+000,
	1.336585e-001,
	5.946044e-001,
	// albedo 0, turbidity 8
	6.763602e-002,
	2.205196e-001,
	-7.151851e-001,
	2.508741e+000,
	3.330016e-001,
	6.895142e-001,
	// albedo 0, turbidity 9
	5.687157e-002,
	2.382926e-001,
	-7.951639e-001,
	2.380214e+000,
	8.486318e-001,
	8.192685e-001,
	// albedo 0, turbidity 10
	4.804473e-002,
	1.966076e-001,
	-5.859989e-001,
	1.534534e+000,
	1.866946e+000,
	9.528688e-001,
	// albedo 1, turbidity 1
	1.109470e-001,
	8.190043e-002,
	2.023152e-001,
	2.721896e-001,
	5.193682e-001,
	5.401298e-001,
	// albedo 1, turbidity 2
	1.147364e-001,
	8.626295e-002,
	1.944652e-001,
	4.314563e-001,
	5.265573e-001,
	5.928457e-001,
	// albedo 1, turbidity 3
	1.138018e-001,
	9.568157e-002,
	1.324943e-001,
	7.414987e-001,
	4.882138e-001,
	6.992066e-001,
	// albedo 1, turbidity 4
	1.069268e-001,
	1.061070e-001,
	8.235325e-003,
	1.173655e+000,
	5.092401e-001,
	8.123288e-001,
	// albedo 1, turbidity 5
	9.671533e-002,
	1.365510e-001,
	-1.887680e-001,
	1.636105e+000,
	4.931799e-001,
	9.534092e-001,
	// albedo 1, turbidity 6
	9.120079e-002,
	1.542261e-001,
	-3.079008e-001,
	1.860609e+000,
	5.696775e-001,
	1.003946e+000,
	// albedo 1, turbidity 7
	8.298575e-002,
	1.891728e-001,
	-5.047613e-001,
	2.191998e+000,
	6.314728e-001,
	1.138476e+000,
	// albedo 1, turbidity 8
	7.299294e-002,
	2.200614e-001,
	-6.649578e-001,
	2.320101e+000,
	9.665028e-001,
	1.260207e+000,
	// albedo 1, turbidity 9
	6.270944e-002,
	2.186724e-001,
	-6.537155e-001,
	1.958369e+000,
	1.721545e+000,
	1.362280e+000,
	// albedo 1, turbidity 10
	5.423905e-002,
	1.687944e-001,
	-4.102190e-001,
	1.017356e+000,
	2.817177e+000,
	1.498748e+000,
};

double dataset720[] = 
{
	// albedo 0, turbidity 1
	-1.110553e+000,
	-1.675726e-001,
	-2.349324e-001,
	2.433790e+000,
	-1.342878e-001,
	1.755516e+000,
	-1.879493e-006,
	1.509217e+000,
	7.216495e-001,
	-1.149960e+000,
	-2.418229e-001,
	2.341927e+000,
	1.486508e-001,
	-4.333388e-001,
	9.028740e-001,
	9.450710e-003,
	-3.134790e-001,
	5.923234e-001,
	-9.702430e-001,
	-5.384657e-002,
	3.025898e+000,
	-6.450284e-001,
	9.728166e-001,
	3.532967e+000,
	-2.429753e-002,
	1.343614e+000,
	1.067807e+000,
	-1.278773e+000,
	-2.072018e-001,
	-2.458359e-001,
	3.749133e-001,
	-9.580484e+000,
	3.066020e-001,
	4.056471e-002,
	4.343208e+000,
	1.865704e-001,
	-9.511618e-001,
	-1.674143e-001,
	4.195842e+000,
	-1.205785e-001,
	2.160133e+000,
	3.048813e+000,
	-4.826924e-002,
	-3.779096e+000,
	1.024834e+000,
	-1.095577e+000,
	-1.855865e-001,
	1.973593e+000,
	7.894097e-002,
	9.578182e-001,
	8.565674e-001,
	4.663966e-002,
	7.375811e-001,
	5.577192e-001,
	// albedo 0, turbidity 2
	-1.099352e+000,
	-1.338612e-001,
	-8.419373e-001,
	2.710346e+000,
	-2.241044e-001,
	1.645463e+000,
	7.621625e-002,
	3.548772e+000,
	7.268231e-001,
	-1.140694e+000,
	-1.723890e-001,
	1.413194e+000,
	3.429051e-001,
	-4.431396e-001,
	9.757402e-001,
	1.248306e-001,
	1.780103e+000,
	6.637254e-001,
	-9.861499e-001,
	-8.032931e-002,
	2.396682e+000,
	7.281382e-001,
	1.472495e-001,
	3.316479e+000,
	-1.028439e-001,
	3.729469e+000,
	9.059004e-001,
	-1.233397e+000,
	-9.896833e-002,
	-1.679568e+000,
	1.542653e+000,
	-9.977726e+000,
	-6.579124e-001,
	6.386315e-001,
	6.157752e+000,
	3.985939e-001,
	-9.438092e-001,
	-1.629239e-001,
	4.213446e+000,
	-3.419684e-001,
	2.110121e+000,
	3.552183e+000,
	-2.817116e-001,
	-3.323718e+000,
	8.785077e-001,
	-1.120794e+000,
	-2.121477e-001,
	1.326767e+000,
	2.317528e-001,
	5.648291e-001,
	4.155089e-001,
	3.048162e-001,
	3.186797e-001,
	6.285665e-001,
	// albedo 0, turbidity 3
	-1.117191e+000,
	-1.510453e-001,
	-3.511136e-001,
	1.706946e+000,
	-3.820460e-001,
	1.228101e+000,
	1.641555e-001,
	3.663544e+000,
	6.846104e-001,
	-1.130950e+000,
	-1.622534e-001,
	1.197076e+000,
	-1.342532e+000,
	6.608991e-002,
	-1.955817e-001,
	3.515286e-001,
	3.237403e+000,
	5.732364e-001,
	-1.103903e+000,
	-1.810472e-001,
	1.254237e+000,
	3.367565e+000,
	-1.746589e+000,
	4.464939e+000,
	-2.831757e-001,
	-2.424241e-001,
	9.961252e-001,
	-1.107818e+000,
	-2.407723e-002,
	-7.518594e-001,
	7.115830e+000,
	-1.603375e+001,
	-4.077248e+000,
	1.210904e+000,
	6.281392e+000,
	2.496837e-001,
	-1.012153e+000,
	-1.911658e-001,
	2.357463e+000,
	-2.392720e+000,
	7.080581e+000,
	6.002768e+000,
	-5.120158e-001,
	-2.039879e+000,
	1.008071e+000,
	-1.083766e+000,
	-1.889743e-001,
	1.669813e+000,
	1.205140e+000,
	-2.973102e+000,
	-1.420288e+000,
	5.838643e-001,
	1.338574e-001,
	5.902153e-001,
	// albedo 0, turbidity 4
	-1.176390e+000,
	-2.045914e-001,
	-1.035177e+000,
	1.521425e+000,
	-9.698257e-002,
	7.561111e-001,
	2.338582e-001,
	3.264500e+000,
	6.520267e-001,
	-1.132876e+000,
	-1.921539e-001,
	9.661015e-001,
	-2.470184e-001,
	-5.825797e-001,
	5.044517e-001,
	1.418233e-001,
	4.416172e+000,
	6.580570e-001,
	-1.296062e+000,
	-2.855719e-001,
	1.143329e+000,
	-1.640682e+000,
	1.921828e+000,
	1.625086e+000,
	5.248871e-001,
	-3.757434e+000,
	7.293814e-001,
	-9.026255e-001,
	2.670242e-002,
	-8.632572e-001,
	7.076787e+000,
	-1.407525e+001,
	-1.251814e+000,
	1.806495e-001,
	6.575978e+000,
	6.367149e-001,
	-1.103623e+000,
	-1.818983e-001,
	1.490037e+000,
	-3.276017e+000,
	6.936153e+000,
	2.689183e+000,
	5.705211e-001,
	-1.354153e+000,
	7.095230e-001,
	-1.049370e+000,
	-1.854814e-001,
	1.385509e+000,
	1.714977e+000,
	-3.205204e+000,
	-1.161420e-001,
	3.453320e-001,
	4.355508e-001,
	7.115006e-001,
	// albedo 0, turbidity 5
	-1.225291e+000,
	-2.574996e-001,
	-4.766919e-001,
	4.951357e-001,
	5.242961e-002,
	4.702062e-001,
	2.428653e-001,
	3.095075e+000,
	6.424221e-001,
	-1.318856e+000,
	-3.713082e-001,
	-4.987985e-001,
	2.026237e+000,
	-1.457426e+000,
	7.809557e-001,
	1.419197e-003,
	2.776845e+000,
	7.058454e-001,
	-1.168038e+000,
	-1.572586e-001,
	1.786834e+000,
	-4.594005e+000,
	4.780600e+000,
	1.639416e+000,
	5.324063e-001,
	-1.000719e+000,
	7.325083e-001,
	-9.862998e-001,
	-7.482649e-002,
	-1.332445e+000,
	1.329260e+001,
	-1.803019e+001,
	-2.669936e+000,
	3.591475e-001,
	3.852972e+000,
	5.714399e-001,
	-1.049025e+000,
	-1.404280e-001,
	1.342894e+000,
	-5.633938e+000,
	8.396123e+000,
	3.809869e+000,
	4.313231e-001,
	-5.373938e-001,
	7.693298e-001,
	-1.069033e+000,
	-2.091865e-001,
	1.088280e+000,
	3.125506e+000,
	-4.664580e+000,
	-1.191484e+000,
	5.195344e-001,
	3.961673e-001,
	6.817393e-001,
	// albedo 0, turbidity 6
	-1.267895e+000,
	-3.004228e-001,
	-5.149611e-001,
	4.302967e-001,
	1.504018e-001,
	3.700643e-001,
	2.354209e-001,
	2.887788e+000,
	6.298388e-001,
	-1.551925e+000,
	-5.917820e-001,
	-5.915642e-001,
	2.016019e+000,
	-1.252286e+000,
	8.651065e-001,
	7.721402e-003,
	1.148828e+000,
	6.589887e-001,
	-9.782795e-001,
	3.652455e-002,
	1.331304e+000,
	-4.804135e+000,
	5.130801e+000,
	1.052586e+000,
	4.439877e-001,
	2.100157e+000,
	8.308236e-001,
	-1.077598e+000,
	-2.015253e-001,
	-1.037818e+000,
	1.307045e+001,
	-1.715211e+001,
	-1.607252e+000,
	4.472382e-001,
	6.802371e-001,
	4.848934e-001,
	-1.025969e+000,
	-1.170376e-001,
	1.139546e+000,
	-3.374680e+000,
	6.330035e+000,
	2.199093e+000,
	3.928627e-001,
	8.428666e-001,
	7.960910e-001,
	-1.062382e+000,
	-1.881842e-001,
	8.863153e-001,
	4.266858e+000,
	-5.011692e+000,
	-4.086830e-001,
	5.889147e-001,
	5.341939e-001,
	6.866073e-001,
	// albedo 0, turbidity 7
	-1.352417e+000,
	-3.836953e-001,
	-5.951560e-001,
	4.053297e-001,
	2.468304e-001,
	2.565711e-001,
	2.321365e-001,
	2.512376e+000,
	6.089904e-001,
	-1.976438e+000,
	-9.152777e-001,
	-4.417666e-001,
	1.790189e+000,
	-1.085567e+000,
	4.562228e-001,
	2.133332e-002,
	4.989856e-001,
	6.257100e-001,
	-7.197412e-001,
	2.165210e-001,
	6.233215e-001,
	-3.960686e+000,
	4.694083e+000,
	2.062797e+000,
	3.121864e-001,
	2.942681e+000,
	8.846033e-001,
	-1.189984e+000,
	-3.151612e-001,
	-5.020073e-001,
	1.015136e+001,
	-1.483684e+001,
	-3.476730e+000,
	6.049863e-001,
	-1.941153e-001,
	4.281015e-001,
	-9.781383e-001,
	-8.764833e-002,
	8.290915e-001,
	1.086960e-001,
	4.467570e+000,
	3.905633e+000,
	1.975895e-001,
	6.964295e-001,
	8.333166e-001,
	-1.081242e+000,
	-2.051949e-001,
	6.056482e-001,
	5.219268e+000,
	-4.410608e+000,
	-1.963212e+000,
	7.277904e-001,
	8.509624e-001,
	6.689251e-001,
	// albedo 0, turbidity 8
	-1.443212e+000,
	-4.725757e-001,
	-9.477961e-001,
	2.671049e-001,
	6.163577e-001,
	-3.965036e-001,
	4.071134e-001,
	2.464218e+000,
	4.997820e-001,
	-3.021428e+000,
	-1.558459e+000,
	1.389763e-001,
	1.122031e+000,
	-1.014816e+000,
	1.265687e+000,
	-1.649604e-001,
	-6.627923e-001,
	5.494665e-001,
	-1.593477e-001,
	5.076305e-001,
	-7.283933e-001,
	-1.265076e+000,
	3.904153e+000,
	-8.196757e-002,
	6.585734e-001,
	4.998464e+000,
	9.330667e-001,
	-1.378374e+000,
	-5.064534e-001,
	7.231197e-001,
	1.385088e+000,
	-9.500118e+000,
	-4.806746e-001,
	1.067642e-001,
	-3.297209e+000,
	4.441955e-001,
	-9.436176e-001,
	-6.189764e-002,
	1.144482e-001,
	9.137694e+000,
	2.948867e-001,
	1.224655e+000,
	3.675148e-001,
	2.124090e+000,
	8.014519e-001,
	-1.078915e+000,
	-2.051854e-001,
	4.754209e-001,
	5.826389e-003,
	-2.498632e+000,
	-8.265078e-001,
	7.644670e-001,
	6.066256e-001,
	6.811963e-001,
	// albedo 0, turbidity 9
	-1.621711e+000,
	-6.425839e-001,
	-7.307813e-001,
	1.109519e+000,
	-4.107299e-001,
	7.789953e-001,
	7.764812e-002,
	2.335627e+000,
	6.230915e-001,
	-4.003597e+000,
	-1.736865e+000,
	-6.062450e-001,
	-7.370264e-001,
	7.002778e-001,
	-4.140325e-001,
	3.926087e-001,
	8.316399e-001,
	1.516341e-001,
	-7.696712e-001,
	-3.872306e-001,
	-1.159436e+000,
	1.660752e+000,
	2.031840e+000,
	-7.697685e-001,
	5.481684e-001,
	2.788249e+000,
	1.112977e+000,
	-8.506589e-001,
	-5.430791e-002,
	1.088719e+000,
	-2.513532e+000,
	-4.144477e+000,
	2.760914e+000,
	-3.011272e-001,
	-2.383556e+000,
	4.496070e-001,
	-1.150061e+000,
	-3.009215e-001,
	-9.176868e-002,
	8.996074e+000,
	-1.753862e+000,
	-2.428423e+000,
	5.764492e-001,
	1.218492e+000,
	7.552230e-001,
	-1.020853e+000,
	-1.499849e-001,
	3.437744e-001,
	-2.339597e-003,
	-2.646520e+000,
	1.378457e+000,
	6.708410e-001,
	9.149680e-001,
	6.961806e-001,
	// albedo 0, turbidity 10
	-1.982394e+000,
	-9.369621e-001,
	-3.767595e-001,
	2.514582e+000,
	-1.501415e+000,
	6.258952e-001,
	-5.260430e-006,
	2.100142e+000,
	7.824077e-001,
	-3.432415e+000,
	-1.264283e+000,
	-9.042363e-001,
	-2.930432e+000,
	8.249096e-001,
	7.244840e-001,
	3.055253e-002,
	2.527405e+000,
	-2.107031e-003,
	-4.333533e+000,
	-2.156157e+000,
	-8.341654e-001,
	5.048387e+000,
	1.803580e+000,
	-9.318434e-001,
	1.085401e+000,
	8.728330e-001,
	1.050061e+000,
	4.889224e-001,
	5.956721e-002,
	8.445388e-001,
	-7.479177e+000,
	-4.049292e+000,
	1.199966e+000,
	-7.060560e-001,
	-9.742353e-001,
	4.893674e-001,
	-1.347508e+000,
	-1.874523e-001,
	-5.063342e-002,
	1.299813e+001,
	-1.707387e+000,
	-4.076088e-001,
	6.119042e-001,
	3.717790e-001,
	7.662157e-001,
	-1.047037e+000,
	-3.743109e-001,
	3.452375e-001,
	-3.615559e-003,
	-2.169432e+000,
	-7.166880e-002,
	3.747046e-001,
	2.746126e-001,
	6.773818e-001,
	// albedo 1, turbidity 1
	-1.105396e+000,
	-1.663441e-001,
	-2.359634e-001,
	2.476496e+000,
	-1.329052e-001,
	1.715759e+000,
	2.103991e-003,
	1.421966e+000,
	6.270733e-001,
	-1.132480e+000,
	-2.330883e-001,
	2.273938e+000,
	2.422717e-001,
	-4.159883e-001,
	9.350714e-001,
	1.432347e-002,
	-4.176684e-001,
	4.664640e-001,
	-1.036155e+000,
	-9.432450e-002,
	3.117262e+000,
	-6.369808e-001,
	1.060389e+000,
	3.386481e+000,
	-4.605081e-002,
	1.248000e+000,
	9.701974e-001,
	-1.162485e+000,
	-1.382303e-001,
	1.544122e-001,
	3.716511e-001,
	-9.520209e+000,
	-2.739605e-001,
	8.489054e-002,
	4.371570e+000,
	7.694391e-002,
	-1.031787e+000,
	-2.165067e-001,
	4.446666e+000,
	-1.470711e-001,
	2.143436e+000,
	1.922123e+000,
	-9.589030e-002,
	-3.594664e+000,
	8.629249e-001,
	-1.081125e+000,
	-1.623953e-001,
	2.048137e+000,
	8.639386e-002,
	1.225845e+000,
	1.239255e-001,
	8.366038e-002,
	8.322625e-001,
	5.604708e-001,
	// albedo 1, turbidity 2
	-1.112606e+000,
	-1.514491e-001,
	-1.608942e+000,
	3.592344e+000,
	-1.616115e-001,
	1.593861e+000,
	5.488306e-002,
	2.854783e+000,
	7.519999e-001,
	-1.098630e+000,
	-1.410161e-001,
	2.155487e+000,
	-4.381610e-001,
	-3.635146e-001,
	1.313843e+000,
	1.201277e-001,
	2.469958e+000,
	6.481071e-001,
	-1.077575e+000,
	-1.275645e-001,
	1.418205e+000,
	2.057232e+000,
	-7.778503e-002,
	2.433840e+000,
	-7.094034e-002,
	3.347259e+000,
	9.344752e-001,
	-1.099714e+000,
	-4.474282e-002,
	-1.247041e-001,
	-1.578342e-001,
	-7.968895e+000,
	1.730912e-001,
	5.303765e-001,
	5.523179e+000,
	3.840340e-001,
	-1.061945e+000,
	-2.200148e-001,
	4.333103e+000,
	1.818948e-002,
	1.907751e+000,
	1.560633e+000,
	-3.182192e-001,
	-3.010282e+000,
	8.844351e-001,
	-1.087782e+000,
	-1.709041e-001,
	1.834683e+000,
	7.351214e-002,
	1.282669e+000,
	2.075884e-001,
	2.698971e-001,
	3.373859e-001,
	5.808336e-001,
	// albedo 1, turbidity 3
	-1.121417e+000,
	-1.551220e-001,
	-1.527123e+000,
	2.788105e+000,
	-1.477847e-001,
	1.152139e+000,
	1.742181e-001,
	3.473417e+000,
	6.737050e-001,
	-1.118910e+000,
	-1.496848e-001,
	2.736873e+000,
	-1.829596e+000,
	-3.411991e-001,
	1.177538e-001,
	2.960683e-001,
	3.273898e+000,
	5.743833e-001,
	-1.121145e+000,
	-1.980292e-001,
	-5.407002e-001,
	2.886807e+000,
	4.877852e-001,
	3.692424e+000,
	-1.104033e-001,
	-2.358878e-001,
	9.976295e-001,
	-1.078889e+000,
	-1.541161e-003,
	1.370650e+000,
	1.644450e+000,
	-1.425572e+001,
	-3.075430e+000,
	9.346385e-001,
	5.871863e+000,
	2.618026e-001,
	-1.053346e+000,
	-2.262166e-001,
	2.532003e+000,
	-8.720058e-001,
	7.667901e+000,
	4.357082e+000,
	-5.367969e-001,
	-2.073329e+000,
	1.023965e+000,
	-1.100093e+000,
	-1.810893e-001,
	2.566430e+000,
	4.757700e-001,
	-2.069684e+000,
	-1.585209e+000,
	4.693140e-001,
	-6.719615e-001,
	5.569453e-001,
	// albedo 1, turbidity 4
	-1.181528e+000,
	-2.151896e-001,
	-1.076470e+000,
	2.037517e+000,
	-1.683559e-001,
	8.780110e-001,
	1.782773e-001,
	2.768650e+000,
	6.743293e-001,
	-1.142132e+000,
	-1.825403e-001,
	1.320992e+000,
	-1.895472e+000,
	-2.160241e-001,
	-2.079637e-001,
	3.424953e-001,
	4.333355e+000,
	5.663420e-001,
	-1.225408e+000,
	-2.906477e-001,
	8.323962e-001,
	2.176300e+000,
	1.943859e+000,
	3.003671e+000,
	1.130255e-001,
	-4.449977e+000,
	8.867390e-001,
	-9.815988e-001,
	5.577004e-002,
	-4.240348e-001,
	1.488466e+000,
	-1.279361e+001,
	-3.110899e+000,
	7.360104e-001,
	7.937751e+000,
	4.474817e-001,
	-1.103439e+000,
	-2.481553e-001,
	3.045691e+000,
	-6.993993e-001,
	6.081464e+000,
	3.986228e+000,
	-1.616828e-001,
	-3.373973e+000,
	8.572294e-001,
	-1.081695e+000,
	-1.943361e-001,
	2.303236e+000,
	3.906537e-001,
	-1.498982e+000,
	-1.372140e+000,
	3.379214e-001,
	-4.953601e-001,
	6.521383e-001,
	// albedo 1, turbidity 5
	-1.235776e+000,
	-2.745978e-001,
	2.205316e-002,
	4.505193e-001,
	-1.569202e-001,
	5.065039e-001,
	2.016320e-001,
	2.449382e+000,
	6.535188e-001,
	-1.268478e+000,
	-3.078367e-001,
	-2.041769e-001,
	1.189583e+000,
	-1.311782e+000,
	4.724677e-001,
	1.025764e-001,
	3.300615e+000,
	6.689797e-001,
	-1.190389e+000,
	-2.597641e-001,
	1.377486e+000,
	-2.289003e+000,
	4.214767e+000,
	1.900318e+000,
	3.126604e-001,
	-2.537399e+000,
	7.980811e-001,
	-9.632300e-001,
	7.067379e-002,
	-6.690546e-001,
	9.507059e+000,
	-1.721426e+001,
	-2.850631e+000,
	6.931159e-001,
	5.722238e+000,
	4.856193e-001,
	-1.119689e+000,
	-3.019499e-001,
	2.657474e+000,
	-5.208105e+000,
	1.015200e+001,
	3.863887e+000,
	-1.603721e-001,
	-3.132328e+000,
	8.543154e-001,
	-1.078742e+000,
	-1.840880e-001,
	2.341448e+000,
	2.576821e+000,
	-5.011296e+000,
	-1.671996e+000,
	3.955131e-001,
	-4.700684e-001,
	6.516593e-001,
	// albedo 1, turbidity 6
	-1.263449e+000,
	-3.016185e-001,
	-1.680842e-001,
	4.791728e-001,
	-8.989862e-002,
	5.069014e-001,
	1.892810e-001,
	2.535339e+000,
	6.506411e-001,
	-1.544305e+000,
	-5.656222e-001,
	-2.084263e-001,
	1.312304e+000,
	-8.580598e-001,
	4.039133e-001,
	1.008588e-001,
	1.268784e+000,
	6.333075e-001,
	-9.436041e-001,
	-1.620107e-002,
	1.253874e+000,
	-3.499120e+000,
	4.452594e+000,
	1.870490e+000,
	1.524710e-001,
	8.031346e-001,
	8.930942e-001,
	-1.106718e+000,
	-1.102586e-001,
	-8.803979e-001,
	1.326904e+001,
	-1.878253e+001,
	-2.994671e+000,
	9.501205e-001,
	2.284893e+000,
	3.662824e-001,
	-1.048783e+000,
	-2.156089e-001,
	2.786728e+000,
	-4.862603e+000,
	8.438175e+000,
	3.683031e+000,
	-3.092444e-001,
	-1.293934e+000,
	9.110045e-001,
	-1.108140e+000,
	-2.156079e-001,
	2.181504e+000,
	2.124553e+000,
	-5.007442e+000,
	-1.711417e+000,
	4.904871e-001,
	-8.710312e-001,
	6.376965e-001,
	// albedo 1, turbidity 7
	-1.345282e+000,
	-3.856197e-001,
	-1.975094e-001,
	3.016919e-001,
	2.765844e-001,
	2.092275e-001,
	2.251325e-001,
	2.058589e+000,
	6.014266e-001,
	-1.907309e+000,
	-8.881952e-001,
	-4.827860e-001,
	1.495665e+000,
	-9.243173e-001,
	3.864061e-001,
	7.491538e-002,
	2.719526e-001,
	6.046039e-001,
	-7.540737e-001,
	1.800167e-001,
	1.174575e+000,
	-3.052295e+000,
	4.669060e+000,
	1.793876e+000,
	1.664066e-001,
	2.376187e+000,
	9.261122e-001,
	-1.165479e+000,
	-2.500464e-001,
	-9.603937e-001,
	8.919733e+000,
	-1.561899e+001,
	-2.850650e+000,
	8.368531e-001,
	3.404393e-001,
	3.694265e-001,
	-1.032259e+000,
	-1.593662e-001,
	2.621639e+000,
	-5.369281e-001,
	6.011517e+000,
	3.234312e+000,
	-1.842335e-001,
	-3.749684e-001,
	8.913063e-001,
	-1.119906e+000,
	-2.533313e-001,
	2.017975e+000,
	4.776492e-001,
	-5.005474e+000,
	-1.503414e+000,
	4.694448e-001,
	-1.039200e+000,
	6.438630e-001,
	// albedo 1, turbidity 8
	-1.457842e+000,
	-4.806585e-001,
	-6.807833e-001,
	2.682520e-001,
	5.586195e-001,
	-2.806536e-001,
	3.694491e-001,
	2.169304e+000,
	4.997873e-001,
	-2.906600e+000,
	-1.558470e+000,
	4.048869e-001,
	1.012321e+000,
	-8.709928e-001,
	9.025637e-001,
	-9.171486e-002,
	-1.279805e+000,
	5.327924e-001,
	-2.500868e-001,
	5.175467e-001,
	-4.366020e-001,
	-1.156645e+000,
	3.657335e+000,
	4.092973e-001,
	4.611188e-001,
	4.971048e+000,
	9.789196e-001,
	-1.282240e+000,
	-4.792753e-001,
	3.824491e-001,
	2.061672e+000,
	-9.474747e+000,
	-1.080446e+000,
	3.852100e-001,
	-3.234591e+000,
	3.696703e-001,
	-1.046065e+000,
	-1.097023e-001,
	1.672284e+000,
	4.799701e+000,
	1.286403e+000,
	1.712569e+000,
	1.099301e-001,
	1.214451e+000,
	8.572886e-001,
	-1.104124e+000,
	-2.576744e-001,
	1.919030e+000,
	-1.296687e-003,
	-3.500874e+000,
	-1.048831e+000,
	3.929400e-001,
	-9.229794e-001,
	6.687909e-001,
	// albedo 1, turbidity 9
	-1.658918e+000,
	-6.637256e-001,
	-1.162850e+000,
	1.829549e+000,
	-2.525065e-001,
	8.624803e-001,
	5.214746e-002,
	1.977784e+000,
	6.455044e-001,
	-3.553256e+000,
	-1.639022e+000,
	-8.821743e-001,
	-2.660037e-001,
	5.168738e-001,
	-8.582770e-001,
	4.110780e-001,
	1.034123e-001,
	1.039852e-001,
	-1.299367e+000,
	-4.890457e-001,
	-5.595307e-001,
	1.129115e+000,
	5.445041e-001,
	5.361314e-001,
	4.579589e-001,
	3.385708e+000,
	1.184267e+000,
	-4.366852e-001,
	-2.303554e-002,
	5.417530e-001,
	-9.106900e-001,
	-4.398484e-001,
	3.178252e-001,
	-2.132156e-001,
	-3.682761e+000,
	3.754470e-001,
	-1.334075e+000,
	-2.466639e-001,
	1.293237e+000,
	4.685982e+000,
	-4.032879e+000,
	4.666293e-001,
	5.337822e-001,
	1.603290e+000,
	8.067400e-001,
	-1.052460e+000,
	-2.501759e-001,
	1.601487e+000,
	1.713504e+000,
	-2.810006e+000,
	-8.042597e-001,
	3.216101e-001,
	-5.944876e-001,
	6.740783e-001,
	// albedo 1, turbidity 10
	-1.974746e+000,
	-9.111910e-001,
	-2.159155e-001,
	2.437415e+000,
	-1.592257e+000,
	6.133797e-001,
	-6.243023e-006,
	1.960399e+000,
	7.806415e-001,
	-2.677119e+000,
	-1.100702e+000,
	-6.847246e-001,
	-2.820855e+000,
	1.577837e+000,
	6.243833e-001,
	2.218481e-002,
	1.568717e+000,
	2.327673e-002,
	-5.323827e+000,
	-2.461050e+000,
	-3.941307e-001,
	4.908417e+000,
	-1.657232e-001,
	-9.501763e-001,
	1.063520e+000,
	1.455622e+000,
	9.781890e-001,
	1.325000e+000,
	3.538115e-001,
	1.783573e-001,
	-6.903650e+000,
	-8.079921e-001,
	1.215973e+000,
	-6.852540e-001,
	-1.735835e+000,
	5.744662e-001,
	-1.741196e+000,
	-3.448017e-001,
	1.242377e+000,
	1.098613e+001,
	-3.386782e+000,
	-3.128683e-001,
	5.792848e-001,
	1.364330e-002,
	7.112763e-001,
	-9.762671e-001,
	-3.368355e-001,
	1.374728e+000,
	-3.312353e-003,
	-2.576919e+000,
	-1.778015e-001,
	2.024288e-001,
	-6.128666e-001,
	6.917938e-001,
};

double datasetRad720[] = 
{
	// albedo 0, turbidity 1
	9.147390e-002,
	7.018942e-002,
	1.622668e-001,
	2.036338e-001,
	1.635090e-001,
	1.713774e-001,
	// albedo 0, turbidity 2
	9.909969e-002,
	7.154626e-002,
	1.772161e-001,
	3.305464e-001,
	1.553279e-001,
	1.987828e-001,
	// albedo 0, turbidity 3
	1.013563e-001,
	6.482712e-002,
	1.919424e-001,
	5.177933e-001,
	1.653095e-001,
	2.316577e-001,
	// albedo 0, turbidity 4
	9.553482e-002,
	7.250944e-002,
	9.582747e-002,
	9.293376e-001,
	1.096383e-001,
	3.115109e-001,
	// albedo 0, turbidity 5
	8.787796e-002,
	9.182246e-002,
	-6.114610e-002,
	1.352986e+000,
	6.824176e-002,
	3.863098e-001,
	// albedo 0, turbidity 6
	8.211688e-002,
	1.136177e-001,
	-2.007215e-001,
	1.645362e+000,
	4.150372e-002,
	4.378610e-001,
	// albedo 0, turbidity 7
	7.400462e-002,
	1.477923e-001,
	-3.967754e-001,
	2.001798e+000,
	6.469253e-002,
	5.049746e-001,
	// albedo 0, turbidity 8
	6.300931e-002,
	1.904274e-001,
	-6.189626e-001,
	2.322083e+000,
	2.089235e-001,
	5.945747e-001,
	// albedo 0, turbidity 9
	5.200819e-002,
	2.169587e-001,
	-7.460159e-001,
	2.320149e+000,
	6.242710e-001,
	7.185568e-001,
	// albedo 0, turbidity 10
	4.329013e-002,
	1.900081e-001,
	-6.070381e-001,
	1.647416e+000,
	1.517600e+000,
	8.465953e-001,
	// albedo 1, turbidity 1
	9.457245e-002,
	7.644762e-002,
	1.578740e-001,
	2.074747e-001,
	3.827800e-001,
	4.125345e-001,
	// albedo 1, turbidity 2
	1.013784e-001,
	8.198680e-002,
	1.620652e-001,
	3.461549e-001,
	3.867509e-001,
	4.653134e-001,
	// albedo 1, turbidity 3
	1.040624e-001,
	7.855947e-002,
	1.633979e-001,
	5.501949e-001,
	4.194008e-001,
	5.300353e-001,
	// albedo 1, turbidity 4
	9.866276e-002,
	8.661824e-002,
	6.828152e-002,
	9.529887e-001,
	4.147963e-001,
	6.531589e-001,
	// albedo 1, turbidity 5
	9.141347e-002,
	1.084182e-001,
	-9.664085e-002,
	1.383297e+000,
	4.048587e-001,
	7.736555e-001,
	// albedo 1, turbidity 6
	8.553065e-002,
	1.271555e-001,
	-2.233165e-001,
	1.643686e+000,
	4.299472e-001,
	8.400556e-001,
	// albedo 1, turbidity 7
	7.765393e-002,
	1.591606e-001,
	-4.067067e-001,
	1.968938e+000,
	4.995870e-001,
	9.464057e-001,
	// albedo 1, turbidity 8
	6.756910e-002,
	1.954915e-001,
	-6.050275e-001,
	2.224385e+000,
	7.084781e-001,
	1.098066e+000,
	// albedo 1, turbidity 9
	5.751694e-002,
	2.034682e-001,
	-6.417645e-001,
	1.994080e+000,
	1.364626e+000,
	1.202615e+000,
	// albedo 1, turbidity 10
	4.881952e-002,
	1.632172e-001,
	-4.409641e-001,
	1.162848e+000,
	2.405383e+000,
	1.327313e+000,
};



double* datasets[] =
{
	dataset320,
	dataset360,
	dataset400,
	dataset440,
	dataset480,
	dataset520,
	dataset560,
	dataset600,
	dataset640,
	dataset680,
    dataset720
};

double* datasetsRad[] =
{
	datasetRad320,
	datasetRad360,
	datasetRad400,
	datasetRad440,
	datasetRad480,
	datasetRad520,
	datasetRad560,
	datasetRad600,
	datasetRad640,
	datasetRad680,
    datasetRad720
};


double datasetXYZ1[] = 
{
	// albedo 0, turbidity 1
	-1.101486e+000,
	-1.625977e-001,
	-1.638708e+000,
	2.691125e+000,
	-1.570727e-001,
	9.434333e-001,
	5.944289e-002,
	4.597857e+000,
	5.192436e-001,
	-1.146219e+000,
	-1.731352e-001,
	-2.017772e+000,
	3.407866e+000,
	-1.226220e-001,
	6.479211e-001,
	2.885115e-002,
	5.453907e+000,
	3.603228e-001,
	-1.053996e+000,
	-1.654194e-001,
	4.328823e+000,
	-3.101506e+000,
	-7.300690e-001,
	2.099738e+000,
	-8.055807e-002,
	1.000556e+000,
	1.125343e+000,
	-1.149056e+000,
	-2.619810e-001,
	9.589140e-002,
	2.150554e+000,
	9.517496e-001,
	7.542357e-001,
	9.669580e-002,
	-1.252807e-001,
	6.431416e-002,
	-1.020209e+000,
	-1.368326e-001,
	1.895474e+000,
	-2.187264e+000,
	-6.141343e+000,
	1.825375e+000,
	-8.482316e-002,
	2.658493e+000,
	9.470160e-001,
	-1.076820e+000,
	-1.440642e-001,
	1.432733e+000,
	3.413745e+000,
	-2.344518e+000,
	1.213725e+000,
	6.208270e-002,
	3.030371e+000,
	4.998994e-001,
	// albedo 0, turbidity 2
	-1.117775e+000,
	-1.779226e-001,
	-5.134562e+000,
	6.252734e+000,
	-8.102730e-002,
	1.049450e+000,
	4.085968e-002,
	4.424605e+000,
	6.475802e-001,
	-1.140066e+000,
	-1.751408e-001,
	2.533825e+000,
	-2.137066e+000,
	-1.325967e-001,
	2.837325e-001,
	1.524333e-001,
	5.763824e+000,
	4.045794e-001,
	-1.080149e+000,
	-2.581561e-001,
	1.743889e+000,
	1.338846e+000,
	-6.270160e-001,
	2.415543e+000,
	-1.451883e-001,
	-2.887826e+000,
	1.095943e+000,
	-1.088968e+000,
	-3.315172e-002,
	-5.423126e-001,
	-1.285017e+000,
	-2.836525e-001,
	1.106355e-002,
	3.408528e-001,
	7.823781e+000,
	3.120904e-001,
	-1.061339e+000,
	-2.798560e-001,
	2.462703e+000,
	-7.622134e-001,
	-9.415643e+000,
	2.173416e+000,
	-1.482007e-001,
	-2.137092e+000,
	8.709323e-001,
	-1.069052e+000,
	-1.377888e-001,
	1.204842e+000,
	7.566803e+000,
	-2.862954e+000,
	5.810028e-001,
	1.703831e-001,
	3.183023e+000,
	4.999642e-001,
	// albedo 0, turbidity 3
	-1.132202e+000,
	-1.944061e-001,
	-3.088318e+000,
	3.790264e+000,
	-1.082306e-001,
	8.484089e-001,
	7.280150e-002,
	4.559532e+000,
	6.448053e-001,
	-1.146339e+000,
	-1.873527e-001,
	2.717645e-001,
	-2.760341e-001,
	-1.711107e-001,
	1.650634e-001,
	1.865217e-001,
	6.227743e+000,
	4.657157e-001,
	-1.113398e+000,
	-2.525943e-001,
	2.464015e+000,
	-1.010793e+000,
	-4.516208e-001,
	2.181247e+000,
	-7.235616e-002,
	-1.881470e+000,
	1.014248e+000,
	-1.046335e+000,
	-5.917753e-004,
	-1.524205e+000,
	2.852940e+000,
	-2.478880e-001,
	-3.286072e-001,
	4.540589e-001,
	7.871340e+000,
	3.592995e-001,
	-1.072484e+000,
	-2.566241e-001,
	2.273554e+000,
	-6.831235e+000,
	-5.012665e+000,
	2.159977e+000,
	-5.481960e-002,
	-1.052033e+000,
	8.894254e-001,
	-1.067337e+000,
	-1.595660e-001,
	1.088576e+000,
	1.354817e+001,
	-3.811848e+000,
	3.518446e-001,
	1.510721e-001,
	2.573394e+000,
	6.071131e-001,
	// albedo 0, turbidity 4
	-1.185647e+000,
	-2.528115e-001,
	-2.437674e+000,
	2.796612e+000,
	-9.607830e-002,
	7.181786e-001,
	8.286644e-002,
	4.029493e+000,
	6.385637e-001,
	-1.214985e+000,
	-2.837320e-001,
	-8.427044e-001,
	1.109678e+000,
	-1.623519e-001,
	2.800385e-001,
	7.769566e-002,
	4.862665e+000,
	5.863215e-001,
	-1.126346e+000,
	-2.190142e-001,
	2.404206e+000,
	-2.029997e+000,
	-4.848325e-001,
	1.914520e+000,
	9.543178e-002,
	4.312553e-001,
	8.722100e-001,
	-1.028901e+000,
	-3.047034e-002,
	-1.765204e+000,
	3.312119e+000,
	5.016337e-001,
	-1.300037e+000,
	5.202519e-001,
	5.196915e+000,
	4.632371e-001,
	-1.064053e+000,
	-2.335792e-001,
	1.899585e+000,
	-6.412736e+000,
	-4.247619e+000,
	2.799190e+000,
	1.558133e-002,
	2.116759e-001,
	8.234323e-001,
	-1.074179e+000,
	-1.736113e-001,
	7.909836e-001,
	1.156281e+001,
	-3.300053e+000,
	-5.142526e-001,
	2.666226e-001,
	2.352668e+000,
	6.596287e-001,
	// albedo 0, turbidity 5
	-1.228849e+000,
	-3.037428e-001,
	-3.471341e-001,
	4.350544e-001,
	-3.647964e-001,
	4.740405e-001,
	1.095041e-001,
	3.715388e+000,
	5.953906e-001,
	-1.421982e+000,
	-5.415118e-001,
	-3.421059e-001,
	1.905995e+000,
	-1.654769e+000,
	4.861404e-001,
	1.314065e-002,
	1.846742e+000,
	6.325141e-001,
	-1.061932e+000,
	-4.597166e-002,
	5.943122e-001,
	-4.096098e+000,
	5.060566e+000,
	1.243269e+000,
	7.660147e-002,
	4.778453e+000,
	8.933671e-001,
	-1.018600e+000,
	-1.588265e-001,
	-4.221715e-001,
	9.524085e+000,
	-1.745260e+001,
	-8.306124e-001,
	5.802910e-001,
	4.240811e-001,
	4.185031e-001,
	-1.078570e+000,
	-1.951610e-001,
	1.028815e+000,
	1.154640e+000,
	4.418362e+000,
	1.663718e+000,
	-2.890672e-002,
	2.142532e+000,
	8.181486e-001,
	-1.054656e+000,
	-1.499753e-001,
	5.109586e-001,
	1.239675e+000,
	-4.846160e+000,
	4.503893e-002,
	5.210647e-001,
	2.768949e+000,
	6.726095e-001,
	// albedo 0, turbidity 6
	-1.256198e+000,
	-3.347739e-001,
	-1.209987e+000,
	8.285029e-001,
	1.180869e-001,
	1.753936e-001,
	2.088779e-001,
	3.590526e+000,
	4.999286e-001,
	-1.604654e+000,
	-7.062520e-001,
	-4.240035e-001,
	1.467255e+000,
	-4.714837e-001,
	8.506681e-001,
	-1.248613e-001,
	1.220216e+000,
	6.542021e-001,
	-9.581498e-001,
	2.839298e-002,
	5.118732e-001,
	-1.117046e+000,
	4.644809e-001,
	8.577887e-001,
	2.391953e-001,
	5.085931e+000,
	8.500554e-001,
	-1.071832e+000,
	-2.011442e-001,
	-5.882682e-001,
	1.436666e+000,
	-2.262832e+000,
	-7.777687e-001,
	5.609258e-001,
	8.731629e-002,
	4.618670e-001,
	-1.057077e+000,
	-1.912628e-001,
	8.410181e-001,
	-2.331775e+000,
	3.637049e-001,
	1.638660e+000,
	1.467789e-002,
	1.976998e+000,
	8.168068e-001,
	-1.057954e+000,
	-1.468896e-001,
	3.321536e-001,
	5.437255e+000,
	-4.671045e+000,
	-1.358064e-001,
	5.785188e-001,
	3.014237e+000,
	6.672890e-001,
	// albedo 0, turbidity 7
	-1.343903e+000,
	-4.205350e-001,
	-9.993870e-001,
	7.287143e-001,
	4.537888e-002,
	3.291653e-001,
	1.521443e-001,
	3.265017e+000,
	5.012229e-001,
	-1.895822e+000,
	-9.783864e-001,
	1.424146e+000,
	4.344237e-002,
	-8.684624e-001,
	8.203909e-001,
	-2.548241e-002,
	1.499495e-001,
	4.605675e-001,
	-9.140175e-001,
	1.289977e-001,
	-1.664735e+000,
	-1.162182e+000,
	1.228762e+000,
	-3.508682e-002,
	1.841621e-001,
	6.921907e+000,
	1.095041e+000,
	-1.045760e+000,
	-3.250604e-001,
	1.079474e+000,
	5.770621e-002,
	-1.120456e+001,
	3.498680e-001,
	4.705944e-001,
	-3.353592e+000,
	2.717154e-001,
	-1.064820e+000,
	-1.287183e-001,
	6.377933e-002,
	1.857799e+001,
	-3.852349e-001,
	3.275219e-001,
	5.074330e-002,
	3.863174e+000,
	8.538603e-001,
	-1.051704e+000,
	-1.720625e-001,
	3.343374e-001,
	1.230333e-002,
	-3.119730e+000,
	9.286937e-003,
	5.504549e-001,
	2.165011e+000,
	6.772012e-001,
	// albedo 0, turbidity 8
	-1.400958e+000,
	-4.962991e-001,
	-1.472534e+000,
	1.637928e+000,
	-1.500740e-001,
	6.363313e-001,
	3.398782e-002,
	3.062964e+000,
	6.181961e-001,
	-2.281140e+000,
	-1.212929e+000,
	2.066309e+000,
	-9.078293e-001,
	-7.786086e-001,
	2.674922e-001,
	9.910386e-002,
	3.526180e-001,
	1.031765e-001,
	-1.247570e+000,
	-1.860524e-001,
	-2.480103e+000,
	-1.214462e+000,
	4.921450e-001,
	5.073764e-001,
	2.070932e-001,
	5.946086e+000,
	1.371012e+000,
	-7.111959e-001,
	-1.678064e-001,
	1.754787e+000,
	1.078337e+000,
	-8.236462e+000,
	-3.652583e-001,
	2.819599e-001,
	-3.560758e+000,
	1.289778e-001,
	-1.216962e+000,
	-2.426196e-001,
	-2.761225e-001,
	1.188950e+001,
	-6.400520e-001,
	7.522732e-001,
	1.634544e-001,
	3.030162e+000,
	9.178231e-001,
	-1.019668e+000,
	-1.934685e-001,
	4.011653e-001,
	1.038563e+001,
	-3.673953e+000,
	-5.730092e-001,
	3.768768e-001,
	1.519136e+000,
	6.627072e-001,
	// albedo 0, turbidity 9
	-1.543709e+000,
	-6.636039e-001,
	-1.809906e+000,
	2.170911e+000,
	-1.937131e-001,
	7.968612e-001,
	-8.460147e-006,
	2.686099e+000,
	9.000913e-001,
	-2.001654e+000,
	-9.594942e-001,
	2.079997e+000,
	-1.353312e+000,
	-5.482266e-001,
	-1.459976e-003,
	-2.624163e-002,
	1.834867e+000,
	-2.747675e-001,
	-3.241391e+000,
	-1.537084e+000,
	-2.481444e+000,
	-7.635039e-001,
	-7.605263e-001,
	5.191508e-001,
	5.847757e-001,
	3.257599e+000,
	1.487922e+000,
	2.689125e-001,
	2.598647e-001,
	1.725140e+000,
	-2.635218e-001,
	-3.626237e+000,
	8.275047e-002,
	-2.856604e-001,
	-2.307654e+000,
	2.134944e-001,
	-1.463897e+000,
	-4.116973e-001,
	-1.916056e-001,
	1.574040e+001,
	-3.593091e+000,
	-1.773656e-001,
	3.519763e-001,
	1.614908e+000,
	8.302769e-001,
	-9.864921e-001,
	-2.005394e-001,
	2.091380e-001,
	4.013374e-002,
	-2.015258e+000,
	1.418678e-001,
	4.259543e-001,
	1.368687e+000,
	6.820722e-001,
	// albedo 0, turbidity 10
	-2.262384e+000,
	-1.148119e+000,
	-3.593889e+000,
	3.776156e+000,
	-6.404236e-002,
	6.193772e-001,
	-7.094359e-006,
	2.237025e+000,
	8.931620e-001,
	-1.276920e+000,
	-8.302892e-001,
	3.189973e+000,
	-2.359861e+000,
	-2.929750e-001,
	1.562370e-001,
	-7.604893e-003,
	1.609136e+000,
	-2.270658e-001,
	-6.611222e+000,
	-2.656391e+000,
	-3.600171e+000,
	1.023390e+000,
	6.030035e-001,
	9.329641e-001,
	1.651021e-001,
	3.756497e+000,
	1.403624e+000,
	1.026923e+000,
	2.946641e-002,
	1.795470e+000,
	2.540858e-001,
	-5.953577e+000,
	-4.162474e-001,
	3.559647e-001,
	-1.540672e+000,
	1.581254e-001,
	-1.547540e+000,
	-6.243264e-001,
	1.732470e-001,
	1.096480e+001,
	-1.286094e+000,
	-2.143584e-001,
	-1.972282e-001,
	-1.319792e-001,
	8.731654e-001,
	-9.875272e-001,
	-1.822978e-001,
	4.548775e-002,
	5.387053e+000,
	-3.062190e+000,
	2.906349e-001,
	4.781276e-001,
	1.300372e+000,
	6.730039e-001,
	// albedo 1, turbidity 1
	-1.104052e+000,
	-1.634691e-001,
	-1.387391e+000,
	2.942748e+000,
	-2.259220e-001,
	1.010486e+000,
	2.204942e-002,
	4.310299e+000,
	5.138674e-001,
	-1.116156e+000,
	-1.683774e-001,
	-1.858271e+000,
	3.430711e+000,
	-2.377475e-001,
	8.108399e-001,
	1.060377e-002,
	5.208319e+000,
	3.989719e-001,
	-1.078962e+000,
	-1.538849e-001,
	4.367510e+000,
	-3.165369e+000,
	-6.711199e-001,
	2.062774e+000,
	-3.202848e-002,
	8.503602e-001,
	9.692679e-001,
	-1.111541e+000,
	-2.728946e-001,
	2.255183e-001,
	2.174348e+000,
	1.031057e+000,
	3.183663e-001,
	3.920242e-002,
	-1.516022e-001,
	-2.159894e-002,
	-1.039419e+000,
	-1.206100e-001,
	2.290060e+000,
	-2.243307e+000,
	-6.142358e+000,
	1.056594e+000,
	-3.303547e-002,
	2.713636e+000,
	9.106202e-001,
	-1.076578e+000,
	-1.432110e-001,
	1.639488e+000,
	3.282302e+000,
	-2.493190e+000,
	5.608864e-001,
	2.261511e-002,
	3.056882e+000,
	5.003018e-001,
	// albedo 1, turbidity 2
	-1.114018e+000,
	-1.764798e-001,
	-7.677623e+000,
	8.808307e+000,
	-4.847876e-002,
	9.534913e-001,
	5.618491e-002,
	4.212917e+000,
	6.023125e-001,
	-1.126231e+000,
	-1.672111e-001,
	4.388054e+000,
	-3.703504e+000,
	-8.553161e-002,
	2.885906e-001,
	1.306424e-001,
	5.639266e+000,
	4.398425e-001,
	-1.099800e+000,
	-2.630132e-001,
	4.787770e-001,
	2.105288e+000,
	-5.251653e-001,
	2.427252e+000,
	-1.246785e-001,
	-2.933590e+000,
	1.063575e+000,
	-1.057713e+000,
	-3.084726e-002,
	6.768199e-001,
	-1.044275e+000,
	4.866777e-001,
	-4.646566e-001,
	3.030455e-001,
	7.489353e+000,
	3.358166e-001,
	-1.076440e+000,
	-2.718000e-001,
	2.524154e+000,
	-4.838771e-001,
	-9.977367e+000,
	1.820647e+000,
	-1.723508e-001,
	-2.072269e+000,
	8.536330e-001,
	-1.070888e+000,
	-1.374705e-001,
	1.629302e+000,
	3.428098e+000,
	-2.601212e+000,
	-2.974475e-001,
	1.394611e-001,
	2.984174e+000,
	5.419294e-001,
	// albedo 1, turbidity 3
	-1.130412e+000,
	-1.933669e-001,
	-4.857386e+000,
	5.769973e+000,
	-7.535259e-002,
	8.797336e-001,
	5.043900e-002,
	4.337387e+000,
	6.753643e-001,
	-1.161688e+000,
	-1.960287e-001,
	1.106545e+000,
	-8.577884e-001,
	-9.360930e-002,
	-7.801522e-002,
	1.647885e-001,
	5.848615e+000,
	4.471543e-001,
	-1.067258e+000,
	-2.455886e-001,
	2.084800e+000,
	-5.197051e-001,
	-5.325673e-001,
	2.777012e+000,
	-8.039336e-002,
	-2.543091e+000,
	1.079026e+000,
	-1.097567e+000,
	-5.464719e-003,
	-8.165063e-001,
	2.596105e+000,
	9.459394e-001,
	-1.468011e+000,
	4.630859e-001,
	8.461670e+000,
	2.460684e-001,
	-1.035713e+000,
	-2.587340e-001,
	2.864353e+000,
	-6.828294e+000,
	-6.971908e+000,
	2.583928e+000,
	-1.921443e-001,
	-1.937886e+000,
	1.017362e+000,
	-1.096681e+000,
	-1.527298e-001,
	1.482432e+000,
	1.313477e+001,
	-3.016722e+000,
	-8.479338e-001,
	1.294546e-001,
	2.716000e+000,
	4.999595e-001,
	// albedo 1, turbidity 4
	-1.169876e+000,
	-2.412093e-001,
	-3.946023e+000,
	4.525235e+000,
	-6.225248e-002,
	6.686438e-001,
	7.725227e-002,
	3.834185e+000,
	6.336494e-001,
	-1.225511e+000,
	-2.825782e-001,
	-1.528308e-001,
	4.349972e-001,
	-9.851306e-002,
	2.563982e-001,
	7.882497e-002,
	4.716580e+000,
	5.901271e-001,
	-1.096536e+000,
	-2.581517e-001,
	2.344027e+000,
	-1.068223e+000,
	-4.165502e-001,
	2.094143e+000,
	4.314056e-003,
	-1.406154e+000,
	9.368852e-001,
	-1.056016e+000,
	2.810766e-002,
	-1.383733e+000,
	2.916831e+000,
	7.615073e-001,
	-1.587747e+000,
	5.845122e-001,
	7.180950e+000,
	3.747069e-001,
	-1.054600e+000,
	-2.844119e-001,
	2.873617e+000,
	-6.879472e+000,
	-6.837078e+000,
	2.552183e+000,
	-1.730378e-001,
	-1.664886e+000,
	9.019748e-001,
	-1.100561e+000,
	-1.705639e-001,
	1.407614e+000,
	1.211381e+001,
	-3.074279e+000,
	-9.390883e-001,
	1.811676e-001,
	2.093695e+000,
	5.995081e-001,
	// albedo 1, turbidity 5
	-1.208279e+000,
	-2.897170e-001,
	-1.476546e-001,
	5.890126e-001,
	-4.981961e-001,
	4.583529e-001,
	8.688694e-002,
	3.436587e+000,
	6.179337e-001,
	-1.431865e+000,
	-5.637869e-001,
	1.387813e-001,
	1.280784e+000,
	-1.554694e+000,
	3.086383e-001,
	5.996838e-002,
	1.263023e+000,
	5.584827e-001,
	-1.008065e+000,
	-1.511029e-002,
	3.503926e-001,
	-3.436937e+000,
	5.368936e+000,
	1.418578e+000,
	-1.024279e-002,
	4.433483e+000,
	1.012857e+000,
	-1.063774e+000,
	-1.747988e-001,
	1.386619e-001,
	9.452941e+000,
	-1.800934e+001,
	-1.193473e+000,
	6.588347e-001,
	4.905837e-001,
	2.953989e-001,
	-1.067953e+000,
	-1.932052e-001,
	1.877574e+000,
	4.291478e-001,
	3.924028e+000,
	1.870800e+000,
	-2.168527e-001,
	1.746841e+000,
	8.941231e-001,
	-1.091804e+000,
	-1.887841e-001,
	1.459507e+000,
	-2.411611e-003,
	-5.007685e+000,
	-5.384484e-001,
	3.273158e-001,
	1.389896e+000,
	6.481899e-001,
	// albedo 1, turbidity 6
	-1.244637e+000,
	-3.352956e-001,
	-7.729831e-001,
	9.902457e-001,
	-6.408322e-002,
	4.089615e-001,
	1.079801e-001,
	3.069518e+000,
	5.700739e-001,
	-1.582813e+000,
	-7.186917e-001,
	-2.051782e+000,
	2.745735e+000,
	-5.882307e-002,
	2.724410e-001,
	4.057660e-002,
	8.511673e-001,
	5.731486e-001,
	-9.671558e-001,
	1.950082e-002,
	1.810232e+000,
	-1.217155e+000,
	-1.071386e-001,
	1.908662e+000,
	-8.193543e-002,
	4.082294e+000,
	1.012666e+000,
	-1.060235e+000,
	-1.751755e-001,
	-8.530449e-001,
	1.475536e+000,
	-6.133057e-001,
	-1.967505e+000,
	8.653180e-001,
	9.681735e-001,
	2.746134e-001,
	-1.070553e+000,
	-2.087976e-001,
	2.149017e+000,
	-3.787703e+000,
	-1.475900e+000,
	2.401470e+000,
	-2.897798e-001,
	1.002619e+000,
	9.514204e-001,
	-1.097750e+000,
	-1.941377e-001,
	1.296961e+000,
	7.603643e+000,
	-5.010009e+000,
	-9.621720e-001,
	3.499847e-001,
	1.552155e+000,
	6.142077e-001,
	// albedo 1, turbidity 7
	-1.317243e+000,
	-4.124129e-001,
	-2.112784e-001,
	2.358159e-001,
	7.933267e-002,
	2.953331e-001,
	1.393908e-001,
	2.797095e+000,
	5.001629e-001,
	-1.936943e+000,
	-1.047386e+000,
	7.900712e-001,
	7.391704e-001,
	-1.761740e+000,
	4.555495e-001,
	7.089075e-003,
	-4.904502e-001,
	4.687010e-001,
	-7.950385e-001,
	2.145152e-001,
	-7.466747e-001,
	-1.478622e+000,
	5.440532e+000,
	1.045622e+000,
	2.731993e-002,
	6.502641e+000,
	1.131266e+000,
	-1.144490e+000,
	-3.809627e-001,
	6.924196e-001,
	2.313561e+000,
	-1.492566e+001,
	-1.261390e+000,
	6.493101e-001,
	-3.111817e+000,
	2.197202e-001,
	-1.033182e+000,
	-1.134661e-001,
	1.362390e+000,
	7.974857e+000,
	2.098611e+000,
	1.676310e+000,
	-1.459275e-001,
	3.060691e+000,
	9.001197e-001,
	-1.099954e+000,
	-2.081654e-001,
	1.288675e+000,
	3.154435e+000,
	-4.977442e+000,
	-7.563663e-001,
	3.316278e-001,
	1.310469e+000,
	6.638634e-001,
	// albedo 1, turbidity 8
	-1.398360e+000,
	-5.091482e-001,
	-6.128087e-001,
	1.064324e+000,
	-2.655754e-001,
	5.784825e-001,
	2.447271e-002,
	2.556213e+000,
	6.406131e-001,
	-2.292408e+000,
	-1.287064e+000,
	1.698575e+000,
	-4.555523e-001,
	-1.098610e+000,
	4.172403e-002,
	1.458605e-001,
	-4.711102e-001,
	4.042647e-002,
	-1.098655e+000,
	-5.631273e-002,
	-1.686446e+000,
	-1.324818e+000,
	6.189470e-001,
	1.015319e+000,
	4.519728e-002,
	6.306605e+000,
	1.495579e+000,
	-8.179258e-001,
	-2.762936e-001,
	1.360129e+000,
	1.082906e+000,
	-8.142899e+000,
	-1.145783e+000,
	4.835959e-001,
	-4.634913e+000,
	-9.753444e-003,
	-1.182319e+000,
	-1.786040e-001,
	9.066952e-001,
	1.133717e+001,
	-1.070025e+000,
	1.405348e+000,
	-7.513401e-002,
	3.297654e+000,
	1.003184e+000,
	-1.060857e+000,
	-2.086912e-001,
	1.253454e+000,
	8.836029e+000,
	-4.146867e+000,
	-8.924448e-001,
	2.793886e-001,
	9.711994e-001,
	6.371753e-001,
	// albedo 1, turbidity 9
	-1.521357e+000,
	-6.741763e-001,
	-1.153037e+000,
	1.777504e+000,
	-2.339845e-001,
	7.149374e-001,
	-8.169860e-006,
	2.158744e+000,
	9.000908e-001,
	-2.063901e+000,
	-1.050348e+000,
	1.888832e+000,
	-7.193047e-001,
	-6.376830e-001,
	-8.892313e-002,
	-2.207132e-002,
	9.541427e-001,
	-2.903996e-001,
	-3.079068e+000,
	-1.419114e+000,
	-1.810205e+000,
	-1.419799e+000,
	-6.498295e-001,
	9.599459e-001,
	4.898180e-001,
	3.881219e+000,
	1.541392e+000,
	3.182043e-001,
	1.995494e-001,
	1.434280e+000,
	1.894230e-001,
	-4.081692e+000,
	-9.559909e-001,
	-1.349792e-001,
	-3.617047e+000,
	1.281326e-001,
	-1.521852e+000,
	-3.451241e-001,
	7.272857e-001,
	1.443762e+001,
	-3.427250e+000,
	9.841537e-001,
	2.142994e-001,
	2.000402e+000,
	8.885077e-001,
	-1.000647e+000,
	-2.295867e-001,
	1.144994e+000,
	-2.393324e-003,
	-2.630422e+000,
	-6.861019e-001,
	2.825890e-001,
	5.805290e-001,
	6.620424e-001,
	// albedo 1, turbidity 10
	-1.923394e+000,
	-1.036111e+000,
	-2.560678e+000,
	2.987334e+000,
	-7.660880e-002,
	6.060592e-001,
	-7.414202e-006,
	1.792845e+000,
	9.001463e-001,
	-1.938155e+000,
	-1.049658e+000,
	2.934957e+000,
	-2.112628e+000,
	-3.195476e-001,
	-2.020638e-002,
	-9.686121e-003,
	1.455635e+000,
	-2.181714e-001,
	-5.889712e+000,
	-2.639521e+000,
	-2.752599e+000,
	8.110383e-001,
	5.758426e-001,
	1.080493e+000,
	2.073045e-001,
	2.349084e+000,
	1.355521e+000,
	1.037526e+000,
	1.432077e-001,
	1.320726e+000,
	2.881663e-001,
	-5.803075e+000,
	-8.863853e-001,
	2.717468e-001,
	-5.351612e-001,
	2.186762e-001,
	-1.507983e+000,
	-5.787687e-001,
	1.138616e+000,
	1.024246e+001,
	-1.554095e+000,
	5.415668e-001,
	-1.499505e-001,
	-1.523118e+000,
	8.418226e-001,
	-1.031267e+000,
	-2.072990e-001,
	7.887604e-001,
	4.217895e+000,
	-2.995052e+000,
	-4.380607e-001,
	3.324471e-001,
	1.063346e+000,
	6.807500e-001,
};

double datasetXYZRad1[] = 
{
	// albedo 0, turbidity 1
	9.005710e-003,
	8.182992e-003,
	6.957843e-003,
	6.306849e-002,
	3.425256e-002,
	4.218684e-002,
	// albedo 0, turbidity 2
	8.928056e-003,
	8.633753e-003,
	4.500547e-003,
	7.073306e-002,
	3.305915e-002,
	4.362185e-002,
	// albedo 0, turbidity 3
	8.848416e-003,
	9.009571e-003,
	2.113216e-003,
	7.825675e-002,
	3.201372e-002,
	4.500035e-002,
	// albedo 0, turbidity 4
	8.679785e-003,
	9.554857e-003,
	-1.631724e-003,
	8.887206e-002,
	3.173559e-002,
	4.661125e-002,
	// albedo 0, turbidity 5
	8.490013e-003,
	1.008158e-002,
	-5.387675e-003,
	9.934433e-002,
	3.160711e-002,
	4.814191e-002,
	// albedo 0, turbidity 6
	8.176708e-003,
	1.116184e-002,
	-1.232061e-002,
	1.152735e-001,
	3.149746e-002,
	5.090645e-002,
	// albedo 0, turbidity 7
	7.825887e-003,
	1.217907e-002,
	-1.904565e-002,
	1.307615e-001,
	3.150599e-002,
	5.372829e-002,
	// albedo 0, turbidity 8
	7.509914e-003,
	1.349140e-002,
	-2.655743e-002,
	1.453788e-001,
	3.160182e-002,
	5.709059e-002,
	// albedo 0, turbidity 9
	7.185144e-003,
	1.470882e-002,
	-3.373863e-002,
	1.591499e-001,
	3.221303e-002,
	6.023953e-002,
	// albedo 0, turbidity 10
	6.992372e-003,
	1.542746e-002,
	-3.779775e-002,
	1.657643e-001,
	3.455624e-002,
	6.176418e-002,
	// albedo 1, turbidity 1
	9.606797e-003,
	9.089278e-003,
	8.202458e-003,
	5.641609e-002,
	8.358347e-002,
	9.499950e-002,
	// albedo 1, turbidity 2
	9.539700e-003,
	9.514892e-003,
	5.777662e-003,
	6.403082e-002,
	8.257854e-002,
	9.744811e-002,
	// albedo 1, turbidity 3
	9.456190e-003,
	9.927642e-003,
	3.328348e-003,
	7.160160e-002,
	8.173734e-002,
	9.982680e-002,
	// albedo 1, turbidity 4
	9.276166e-003,
	1.052422e-002,
	-5.679250e-004,
	8.230185e-002,
	8.188579e-002,
	1.026310e-001,
	// albedo 1, turbidity 5
	9.076613e-003,
	1.109440e-002,
	-4.469722e-003,
	9.292079e-002,
	8.205840e-002,
	1.054416e-001,
	// albedo 1, turbidity 6
	8.801736e-003,
	1.192704e-002,
	-1.043735e-002,
	1.063672e-001,
	8.512298e-002,
	1.085586e-001,
	// albedo 1, turbidity 7
	8.474727e-003,
	1.277127e-002,
	-1.644412e-002,
	1.197926e-001,
	8.806212e-002,
	1.118848e-001,
	// albedo 1, turbidity 8
	8.155408e-003,
	1.379662e-002,
	-2.265334e-002,
	1.312810e-001,
	9.129692e-002,
	1.156650e-001,
	// albedo 1, turbidity 9
	7.820697e-003,
	1.475906e-002,
	-2.864690e-002,
	1.420061e-001,
	9.520393e-002,
	1.192700e-001,
	// albedo 1, turbidity 10
	7.644931e-003,
	1.534608e-002,
	-3.196959e-002,
	1.464542e-001,
	9.985241e-002,
	1.208171e-001,
};

double datasetXYZ2[] = 
{
	// albedo 0, turbidity 1
	-1.122914e+000,
	-1.807235e-001,
	-1.619165e+000,
	2.731045e+000,
	-1.975906e-001,
	9.087980e-001,
	4.034744e-002,
	4.576616e+000,
	5.161273e-001,
	-1.154388e+000,
	-1.988315e-001,
	-2.030717e+000,
	3.373363e+000,
	-2.460481e-001,
	6.460481e-001,
	3.157532e-002,
	5.421385e+000,
	3.782806e-001,
	-1.079334e+000,
	-1.658789e-001,
	4.322620e+000,
	-3.142670e+000,
	-7.643807e-001,
	2.131864e+000,
	-9.013664e-002,
	9.705869e-001,
	1.078954e+000,
	-1.134921e+000,
	-2.543435e-001,
	9.573512e-002,
	2.124979e+000,
	9.555775e-001,
	8.037731e-001,
	1.184837e-001,
	-1.496420e-001,
	-8.840597e-003,
	-1.049115e+000,
	-1.444870e-001,
	1.981646e+000,
	-2.194727e+000,
	-6.137320e+000,
	1.876768e+000,
	-1.074934e-001,
	2.649021e+000,
	8.652867e-001,
	-1.072213e+000,
	-1.379147e-001,
	1.507428e+000,
	3.410012e+000,
	-2.362891e+000,
	1.245730e+000,
	7.913373e-002,
	3.022137e+000,
	4.999200e-001,
	// albedo 0, turbidity 2
	-1.131878e+000,
	-1.911417e-001,
	-5.546343e+000,
	6.486312e+000,
	-7.540655e-002,
	9.642554e-001,
	3.999667e-002,
	4.609125e+000,
	6.292406e-001,
	-1.126486e+000,
	-1.582147e-001,
	2.323428e+000,
	-2.107498e+000,
	-1.516963e-001,
	2.866962e-001,
	1.540643e-001,
	7.073975e+000,
	3.562770e-001,
	-1.159513e+000,
	-3.101117e-001,
	1.722605e+000,
	8.457975e-001,
	-5.367977e-001,
	2.084499e+000,
	-1.638125e-001,
	-3.350490e+000,
	1.149230e+000,
	-1.026013e+000,
	-1.328421e-004,
	-2.569728e-001,
	6.293616e-002,
	-7.518545e-001,
	4.849009e-001,
	3.378441e-001,
	7.293808e+000,
	2.684199e-001,
	-1.107049e+000,
	-2.912417e-001,
	2.313578e+000,
	-2.877340e+000,
	-8.789791e+000,
	1.964722e+000,
	-1.326046e-001,
	-1.641421e+000,
	9.088870e-001,
	-1.062899e+000,
	-1.366999e-001,
	1.374840e+000,
	9.253357e+000,
	-3.285853e+000,
	7.598081e-001,
	1.518365e-001,
	2.825418e+000,
	4.999470e-001,
	// albedo 0, turbidity 3
	-1.149828e+000,
	-2.119093e-001,
	-3.083260e+000,
	3.704001e+000,
	-1.121437e-001,
	8.021617e-001,
	5.920592e-002,
	4.604865e+000,
	6.398452e-001,
	-1.173890e+000,
	-2.156342e-001,
	2.565790e-001,
	-1.267097e-001,
	-2.072132e-001,
	1.829126e-001,
	1.283318e-001,
	6.095559e+000,
	4.937362e-001,
	-1.116949e+000,
	-2.482856e-001,
	2.218113e+000,
	-8.794890e-001,
	-5.644284e-001,
	2.082300e+000,
	-5.169108e-002,
	-7.659116e-001,
	9.558886e-001,
	-1.054217e+000,
	8.365248e-004,
	-1.216753e+000,
	2.368297e+000,
	-7.221626e-001,
	-2.645171e-001,
	4.218527e-001,
	6.847504e+000,
	4.451660e-001,
	-1.078108e+000,
	-2.751379e-001,
	2.237058e+000,
	-6.031771e+000,
	-6.013303e+000,
	2.276389e+000,
	-3.578611e-002,
	-1.090788e+000,
	8.050813e-001,
	-1.074500e+000,
	-1.518904e-001,
	1.142963e+000,
	1.249282e+001,
	-3.264809e+000,
	3.225364e-001,
	1.546626e-001,
	2.625043e+000,
	6.604471e-001,
	// albedo 0, turbidity 4
	-1.204183e+000,
	-2.690555e-001,
	-2.118885e+000,
	2.333211e+000,
	-9.144809e-002,
	6.235965e-001,
	9.022505e-002,
	4.107881e+000,
	5.935340e-001,
	-1.249364e+000,
	-3.302901e-001,
	-1.015855e+000,
	1.626302e+000,
	-2.098635e-001,
	3.586044e-001,
	3.433743e-002,
	4.259679e+000,
	6.186639e-001,
	-1.130739e+000,
	-1.893714e-001,
	2.212068e+000,
	-2.632060e+000,
	-5.355575e-001,
	1.855859e+000,
	5.156915e-002,
	2.331263e+000,
	8.620975e-001,
	-1.029212e+000,
	-5.804296e-002,
	-1.456592e+000,
	4.450693e+000,
	4.508010e-001,
	-1.190723e+000,
	5.486355e-001,
	3.324973e+000,
	4.658997e-001,
	-1.071594e+000,
	-2.295521e-001,
	1.797098e+000,
	-8.426178e+000,
	-4.838257e+000,
	2.749226e+000,
	-7.145818e-003,
	9.376112e-001,
	8.234331e-001,
	-1.076084e+000,
	-1.644066e-001,
	8.169316e-001,
	1.447937e+001,
	-3.328583e+000,
	-4.635255e-001,
	2.876957e-001,
	2.371624e+000,
	6.607566e-001,
	// albedo 0, turbidity 5
	-1.249210e+000,
	-3.222757e-001,
	-3.993402e-001,
	4.023211e-001,
	-2.849433e-001,
	4.535075e-001,
	1.115902e-001,
	3.744528e+000,
	5.563504e-001,
	-1.477704e+000,
	-6.045061e-001,
	-3.822014e-001,
	1.661732e+000,
	-1.238864e+000,
	4.237514e-001,
	8.886169e-003,
	1.420669e+000,
	6.186606e-001,
	-1.035944e+000,
	6.890505e-003,
	6.684449e-001,
	-2.790536e+000,
	3.601830e+000,
	1.380572e+000,
	-5.081267e-003,
	6.133132e+000,
	9.371410e-001,
	-1.055090e+000,
	-2.222588e-001,
	-5.205025e-001,
	5.816522e+000,
	-1.516023e+001,
	-1.026305e+000,
	6.623858e-001,
	-9.657356e-001,
	3.741606e-001,
	-1.059766e+000,
	-1.598774e-001,
	1.157297e+000,
	5.532982e+000,
	2.638082e+000,
	2.027566e+000,
	-1.199808e-001,
	2.770544e+000,
	8.444287e-001,
	-1.066947e+000,
	-1.591492e-001,
	4.375334e-001,
	4.423892e-001,
	-4.533511e+000,
	-3.404865e-001,
	5.901014e-001,
	2.719634e+000,
	6.625956e-001,
	// albedo 0, turbidity 6
	-1.284441e+000,
	-3.609807e-001,
	-9.984029e-001,
	7.536405e-001,
	2.158548e-002,
	3.401340e-001,
	1.517400e-001,
	3.584038e+000,
	4.998561e-001,
	-1.642638e+000,
	-7.512595e-001,
	-5.758545e-001,
	1.892728e+000,
	-6.026600e-001,
	6.764253e-001,
	-6.644974e-002,
	9.368823e-001,
	5.881781e-001,
	-9.687452e-001,
	5.694871e-002,
	4.808739e-001,
	-2.494357e+000,
	7.817431e-001,
	9.839932e-001,
	1.281253e-001,
	6.408919e+000,
	9.352341e-001,
	-1.067115e+000,
	-2.459833e-001,
	-4.332687e-001,
	4.019233e+000,
	-2.284292e+000,
	-7.820544e-001,
	5.997262e-001,
	-1.481944e+000,
	4.002165e-001,
	-1.062319e+000,
	-1.694356e-001,
	8.089156e-001,
	-5.809914e+000,
	-3.376530e-001,
	1.664714e+000,
	1.171593e-002,
	2.709085e+000,
	8.406936e-001,
	-1.059995e+000,
	-1.476748e-001,
	3.041194e-001,
	9.109686e+000,
	-4.692319e+000,
	-2.445953e-001,
	5.867979e-001,
	3.010372e+000,
	6.649859e-001,
	// albedo 0, turbidity 7
	-1.356626e+000,
	-4.344649e-001,
	-1.447889e+000,
	1.316070e+000,
	-3.231971e-002,
	4.115335e-001,
	1.070600e-001,
	3.299847e+000,
	5.078718e-001,
	-1.908978e+000,
	-9.880442e-001,
	1.734223e+000,
	-3.331857e-001,
	-6.564627e-001,
	7.778246e-001,
	-2.493316e-003,
	2.301123e-001,
	4.057979e-001,
	-9.822537e-001,
	7.415023e-002,
	-1.823900e+000,
	-5.375540e-001,
	7.367396e-001,
	3.368504e-002,
	1.007106e-001,
	7.096159e+000,
	1.148616e+000,
	-9.972614e-001,
	-2.851500e-001,
	1.076035e+000,
	-1.429468e+000,
	-1.018551e+001,
	3.978549e-001,
	5.298517e-001,
	-3.271319e+000,
	2.447665e-001,
	-1.091570e+000,
	-1.638435e-001,
	1.867819e-001,
	1.968715e+001,
	-9.281292e-001,
	2.334219e-001,
	-8.687501e-003,
	3.377805e+000,
	8.598541e-001,
	-1.048522e+000,
	-1.614766e-001,
	2.718072e-001,
	7.482388e-003,
	-3.077932e+000,
	8.851555e-002,
	5.774509e-001,
	2.395370e+000,
	6.787352e-001,
	// albedo 0, turbidity 8
	-1.402258e+000,
	-5.000147e-001,
	-1.953453e+000,
	2.236805e+000,
	-1.565432e-001,
	7.284951e-001,
	7.637932e-003,
	3.157646e+000,
	6.973669e-001,
	-2.139018e+000,
	-1.131695e+000,
	2.538143e+000,
	-1.588990e+000,
	-5.632198e-001,
	2.000549e-001,
	5.533031e-002,
	4.863742e-001,
	-3.692560e-002,
	-1.508179e+000,
	-3.385328e-001,
	-2.890536e+000,
	4.392917e-001,
	-2.160104e-001,
	4.321423e-001,
	2.859367e-001,
	6.164596e+000,
	1.460664e+000,
	-5.946662e-001,
	-1.226202e-001,
	1.975459e+000,
	-4.214771e+000,
	-6.102017e+000,
	1.242637e-001,
	1.413993e-001,
	-3.812389e+000,
	1.352672e-001,
	-1.243217e+000,
	-2.621981e-001,
	-2.366563e-001,
	2.337274e+001,
	-3.000507e+000,
	7.773696e-002,
	1.592284e-001,
	2.841483e+000,
	8.722272e-001,
	-1.016039e+000,
	-1.664222e-001,
	2.477921e-001,
	3.645234e-002,
	-2.538394e+000,
	-5.133680e-002,
	5.200253e-001,
	1.965000e+000,
	6.779353e-001,
	// albedo 0, turbidity 9
	-1.603220e+000,
	-7.076823e-001,
	-2.233113e+000,
	2.499871e+000,
	-1.306915e-001,
	7.341952e-001,
	-8.135566e-006,
	2.650817e+000,
	9.001136e-001,
	-1.848857e+000,
	-8.949301e-001,
	2.568410e+000,
	-1.739167e+000,
	-4.613569e-001,
	2.355479e-002,
	-1.885319e-002,
	1.873327e+000,
	-2.914893e-001,
	-3.533969e+000,
	-1.665575e+000,
	-2.860794e+000,
	-2.842810e-001,
	-2.235740e-001,
	6.939897e-001,
	4.165640e-001,
	3.409915e+000,
	1.543612e+000,
	4.143747e-001,
	3.149978e-001,
	1.888906e+000,
	-1.013183e+000,
	-4.994871e+000,
	-2.117057e-001,
	-5.263550e-002,
	-2.147159e+000,
	1.293928e-001,
	-1.522103e+000,
	-4.654974e-001,
	-1.701403e-001,
	1.692673e+001,
	-2.752530e+000,
	7.045914e-002,
	1.899328e-001,
	1.276994e+000,
	8.783455e-001,
	-9.829618e-001,
	-2.093400e-001,
	2.225879e-001,
	-1.929224e-004,
	-2.153428e+000,
	-2.570729e-002,
	4.314043e-001,
	1.287312e+000,
	6.728048e-001,
	// albedo 0, turbidity 10
	-2.204582e+000,
	-1.133269e+000,
	-3.567686e+000,
	3.691437e+000,
	-5.609072e-002,
	5.815449e-001,
	-7.619855e-006,
	2.272998e+000,
	9.001409e-001,
	-1.295809e+000,
	-8.555245e-001,
	3.224414e+000,
	-2.416681e+000,
	-2.909513e-001,
	1.419765e-001,
	-4.780137e-003,
	1.653556e+000,
	-2.383716e-001,
	-6.623633e+000,
	-2.685647e+000,
	-3.573099e+000,
	1.039728e+000,
	6.517956e-001,
	9.342824e-001,
	9.620348e-002,
	3.719962e+000,
	1.413863e+000,
	1.011824e+000,
	-4.712038e-003,
	1.840273e+000,
	2.670188e-001,
	-5.934827e+000,
	-4.000691e-001,
	4.055636e-001,
	-1.576287e+000,
	1.625110e-001,
	-1.528649e+000,
	-6.319570e-001,
	1.759796e-001,
	1.096345e+001,
	-1.281789e+000,
	-2.029316e-001,
	-2.287413e-001,
	-1.879906e-001,
	8.681681e-001,
	-1.004153e+000,
	-1.969335e-001,
	3.961794e-002,
	5.389883e+000,
	-3.037866e+000,
	2.821557e-001,
	4.772254e-001,
	1.246164e+000,
	6.737333e-001,
	// albedo 1, turbidity 1
	-1.119344e+000,
	-1.778838e-001,
	-1.508412e+000,
	2.870124e+000,
	-2.239333e-001,
	8.733617e-001,
	2.986154e-002,
	4.430712e+000,
	5.135851e-001,
	-1.135624e+000,
	-1.892481e-001,
	-1.925788e+000,
	3.394714e+000,
	-2.507147e-001,
	6.564287e-001,
	1.890654e-002,
	5.264438e+000,
	3.955314e-001,
	-1.089894e+000,
	-1.644770e-001,
	4.378723e+000,
	-3.163341e+000,
	-7.647141e-001,
	2.071685e+000,
	-5.411723e-002,
	8.601366e-001,
	1.014955e+000,
	-1.115740e+000,
	-2.553530e-001,
	2.736970e-001,
	2.183258e+000,
	9.796187e-001,
	4.044719e-001,
	6.919363e-002,
	-1.499169e-001,
	-5.072956e-002,
	-1.044489e+000,
	-1.247379e-001,
	2.360130e+000,
	-2.225798e+000,
	-6.163017e+000,
	1.085341e+000,
	-6.292495e-002,
	2.724664e+000,
	8.346156e-001,
	-1.083384e+000,
	-1.428958e-001,
	1.674826e+000,
	3.290022e+000,
	-2.508268e+000,
	5.171812e-001,
	4.707754e-002,
	3.056420e+000,
	5.205018e-001,
	// albedo 1, turbidity 2
	-1.126203e+000,
	-1.874434e-001,
	-8.225386e+000,
	9.269649e+000,
	-4.877404e-002,
	9.126623e-001,
	4.343544e-002,
	4.398148e+000,
	6.048192e-001,
	-1.127515e+000,
	-1.550387e-001,
	4.222531e+000,
	-3.896625e+000,
	-9.271714e-002,
	2.272982e-001,
	1.474878e-001,
	7.073835e+000,
	3.534149e-001,
	-1.140955e+000,
	-3.141082e-001,
	7.494281e-001,
	1.928069e+000,
	-5.030279e-001,
	2.213426e+000,
	-1.778000e-001,
	-4.450330e+000,
	1.208623e+000,
	-1.036406e+000,
	6.146237e-003,
	4.836567e-001,
	-4.637645e-001,
	3.971223e-001,
	-8.322950e-002,
	3.525289e-001,
	8.416154e+000,
	1.781471e-001,
	-1.091202e+000,
	-2.793346e-001,
	2.677430e+000,
	-1.228281e+000,
	-9.791189e+000,
	1.628287e+000,
	-2.033050e-001,
	-2.250860e+000,
	9.727505e-001,
	-1.077631e+000,
	-1.444596e-001,
	1.677057e+000,
	3.028066e+000,
	-2.741089e+000,
	-2.423031e-001,
	1.570363e-001,
	2.711075e+000,
	5.193949e-001,
	// albedo 1, turbidity 3
	-1.145360e+000,
	-2.105117e-001,
	-5.077634e+000,
	5.952346e+000,
	-7.390363e-002,
	8.359362e-001,
	3.894082e-002,
	4.272124e+000,
	6.689348e-001,
	-1.169021e+000,
	-1.984243e-001,
	1.727631e+000,
	-1.660273e+000,
	-1.204151e-001,
	-3.657555e-002,
	1.396934e-001,
	6.459890e+000,
	4.429674e-001,
	-1.095745e+000,
	-2.703153e-001,
	1.524693e+000,
	4.786023e-001,
	-5.195445e-001,
	2.454992e+000,
	-9.359784e-002,
	-2.494334e+000,
	1.062193e+000,
	-1.080084e+000,
	1.859535e-002,
	-5.240918e-001,
	1.058138e+000,
	3.243268e-001,
	-1.013826e+000,
	4.696901e-001,
	8.386396e+000,
	2.995756e-001,
	-1.055753e+000,
	-2.828392e-001,
	2.890561e+000,
	-3.996377e+000,
	-8.871250e+000,
	2.270188e+000,
	-2.078015e-001,
	-2.350737e+000,
	9.407089e-001,
	-1.098941e+000,
	-1.572908e-001,
	1.543062e+000,
	8.155922e+000,
	-2.961933e+000,
	-6.409603e-001,
	1.797896e-001,
	2.512159e+000,
	5.535961e-001,
	// albedo 1, turbidity 4
	-1.184914e+000,
	-2.566244e-001,
	-3.846003e+000,
	4.420609e+000,
	-6.973320e-002,
	6.818036e-001,
	5.691508e-002,
	3.866452e+000,
	6.359155e-001,
	-1.261831e+000,
	-3.275588e-001,
	7.852943e-002,
	2.205681e-001,
	-9.853502e-002,
	4.286207e-002,
	9.083512e-002,
	4.172143e+000,
	5.440606e-001,
	-1.078705e+000,
	-2.152762e-001,
	1.912472e+000,
	-1.012286e+000,
	-4.044678e-001,
	2.400412e+000,
	-8.055112e-002,
	4.643356e-001,
	1.007864e+000,
	-1.086128e+000,
	-1.844862e-002,
	-1.041382e+000,
	3.081237e+000,
	6.333381e-001,
	-1.901209e+000,
	6.588684e-001,
	5.373024e+000,
	3.074915e-001,
	-1.041302e+000,
	-2.639676e-001,
	2.783729e+000,
	-7.142120e+000,
	-7.159345e+000,
	2.843385e+000,
	-2.319381e-001,
	-9.181803e-001,
	9.458627e-001,
	-1.115824e+000,
	-1.814189e-001,
	1.440363e+000,
	1.228528e+001,
	-3.111162e+000,
	-1.091867e+000,
	2.170530e-001,
	1.853334e+000,
	5.820210e-001,
	// albedo 1, turbidity 5
	-1.232446e+000,
	-3.127409e-001,
	-1.622789e-001,
	4.915046e-001,
	-4.065352e-001,
	4.224392e-001,
	9.198375e-002,
	3.391924e+000,
	5.731891e-001,
	-1.443917e+000,
	-5.875923e-001,
	1.658220e-001,
	1.351501e+000,
	-1.644611e+000,
	3.257529e-001,
	3.153559e-002,
	1.195318e+000,
	5.653871e-001,
	-1.043103e+000,
	-1.694476e-002,
	2.932353e-001,
	-2.984651e+000,
	4.702246e+000,
	1.309969e+000,
	-1.346309e-002,
	5.174512e+000,
	1.009478e+000,
	-1.048629e+000,
	-1.972413e-001,
	1.662522e-001,
	7.139297e+000,
	-1.583388e+001,
	-9.428178e-001,
	6.162218e-001,
	-4.325526e-001,
	3.161814e-001,
	-1.077482e+000,
	-1.788140e-001,
	1.914283e+000,
	2.374649e+000,
	2.030094e+000,
	1.702760e+000,
	-1.769197e-001,
	2.149751e+000,
	8.693740e-001,
	-1.094960e+000,
	-1.913894e-001,
	1.426293e+000,
	-2.499581e-003,
	-5.010191e+000,
	-5.223956e-001,
	3.183908e-001,
	1.428610e+000,
	6.591116e-001,
	// albedo 1, turbidity 6
	-1.264029e+000,
	-3.549419e-001,
	-1.406577e+000,
	1.507000e+000,
	-8.434063e-003,
	3.365377e-001,
	1.289022e-001,
	3.066945e+000,
	5.080897e-001,
	-1.610970e+000,
	-7.451223e-001,
	-7.941481e-001,
	1.856694e+000,
	-1.795623e-001,
	3.454217e-001,
	-2.784437e-003,
	7.329015e-001,
	5.715167e-001,
	-9.666391e-001,
	3.876303e-002,
	8.648352e-001,
	-1.587177e+000,
	5.145482e-002,
	1.711765e+000,
	-5.636895e-002,
	5.223236e+000,
	1.024660e+000,
	-1.080803e+000,
	-2.247415e-001,
	-2.913792e-001,
	3.381244e+000,
	-6.921786e-001,
	-1.689096e+000,
	7.923716e-001,
	-5.143487e-001,
	2.724712e-001,
	-1.059741e+000,
	-1.809840e-001,
	1.942598e+000,
	-7.101628e+000,
	-2.477121e+000,
	2.198085e+000,
	-2.267978e-001,
	1.738299e+000,
	9.444295e-001,
	-1.103098e+000,
	-1.914456e-001,
	1.299857e+000,
	1.221396e+001,
	-4.937333e+000,
	-8.898276e-001,
	3.150947e-001,
	1.699920e+000,
	6.222964e-001,
	// albedo 1, turbidity 7
	-1.331835e+000,
	-4.251342e-001,
	-6.041415e-001,
	7.867983e-001,
	-1.040816e-001,
	4.133208e-001,
	8.617309e-002,
	2.875871e+000,
	5.195064e-001,
	-1.926241e+000,
	-1.044496e+000,
	1.348627e+000,
	5.796068e-002,
	-9.951364e-001,
	3.106924e-001,
	7.828124e-002,
	-5.033876e-001,
	3.443558e-001,
	-8.746306e-001,
	1.684892e-001,
	-1.131114e+000,
	-1.142233e+000,
	2.657255e+000,
	1.083562e+000,
	-1.051614e-001,
	7.051685e+000,
	1.280761e+000,
	-1.092601e+000,
	-3.652440e-001,
	8.395056e-001,
	1.876542e+000,
	-1.293821e+001,
	-1.197457e+000,
	7.676588e-001,
	-3.675501e+000,
	8.835534e-002,
	-1.058669e+000,
	-1.227902e-001,
	1.351437e+000,
	1.010666e+001,
	1.334936e+000,
	1.644623e+000,
	-2.421837e-001,
	3.267276e+000,
	9.679541e-001,
	-1.100225e+000,
	-2.126091e-001,
	1.294536e+000,
	4.106722e+000,
	-4.882368e+000,
	-8.109179e-001,
	3.455974e-001,
	1.171128e+000,
	6.467468e-001,
	// albedo 1, turbidity 8
	-1.392910e+000,
	-5.069860e-001,
	-1.142949e+000,
	1.640913e+000,
	-1.966830e-001,
	6.482210e-001,
	6.953198e-003,
	2.652369e+000,
	6.996688e-001,
	-2.172107e+000,
	-1.209059e+000,
	2.139161e+000,
	-1.059948e+000,
	-5.782265e-001,
	4.811473e-002,
	8.485675e-002,
	-3.292543e-001,
	-6.032595e-002,
	-1.335264e+000,
	-2.069000e-001,
	-1.982960e+000,
	8.070808e-001,
	-4.710386e-001,
	9.418094e-001,
	1.195574e-001,
	6.509415e+000,
	1.546262e+000,
	-6.990349e-001,
	-2.244664e-001,
	1.513781e+000,
	-6.074608e+000,
	-6.749382e+000,
	-9.377171e-001,
	4.125712e-001,
	-4.914209e+000,
	5.574207e-003,
	-1.214571e+000,
	-1.960482e-001,
	9.045432e-001,
	2.394870e+001,
	-2.765233e+000,
	1.132797e+000,
	-8.917130e-002,
	3.246801e+000,
	9.419349e-001,
	-1.059957e+000,
	-1.995737e-001,
	1.176967e+000,
	1.405613e-003,
	-3.383990e+000,
	-7.123966e-001,
	3.495155e-001,
	1.196716e+000,
	6.635052e-001,
	// albedo 1, turbidity 9
	-1.584877e+000,
	-7.262168e-001,
	-1.740843e+000,
	2.262110e+000,
	-1.295187e-001,
	6.690681e-001,
	-7.904979e-006,
	2.078188e+000,
	9.001230e-001,
	-1.904657e+000,
	-9.791879e-001,
	2.526185e+000,
	-1.393353e+000,
	-4.377071e-001,
	-7.490654e-003,
	-1.508279e-002,
	1.086965e+000,
	-3.083812e-001,
	-3.371479e+000,
	-1.560656e+000,
	-2.231093e+000,
	-2.427120e-001,
	-2.338193e-001,
	9.563028e-001,
	3.304433e-001,
	3.739686e+000,
	1.599714e+000,
	4.387745e-001,
	2.628599e-001,
	1.524571e+000,
	-1.970968e+000,
	-5.345634e+000,
	-9.987550e-001,
	9.361642e-002,
	-3.014998e+000,
	4.664222e-002,
	-1.546981e+000,
	-4.036780e-001,
	8.325325e-001,
	1.715800e+001,
	-2.851827e+000,
	1.017658e+000,
	5.047605e-002,
	1.280570e+000,
	9.205303e-001,
	-1.007805e+000,
	-2.280094e-001,
	1.094464e+000,
	-2.536201e-003,
	-2.625881e+000,
	-7.694080e-001,
	3.014068e-001,
	6.863553e-001,
	6.618797e-001,
	// albedo 1, turbidity 10
	-2.053568e+000,
	-1.118817e+000,
	-2.476651e+000,
	2.850408e+000,
	-6.473262e-002,
	5.621066e-001,
	-7.416765e-006,
	1.745013e+000,
	9.001462e-001,
	-1.709489e+000,
	-9.819671e-001,
	2.761507e+000,
	-1.714474e+000,
	-3.528594e-001,
	-4.119396e-002,
	-4.730579e-003,
	1.499789e+000,
	-2.391912e-001,
	-6.391469e+000,
	-2.761260e+000,
	-2.577416e+000,
	3.597562e-002,
	5.989102e-001,
	1.364694e+000,
	9.601535e-002,
	2.454903e+000,
	1.416630e+000,
	1.216754e+000,
	9.574717e-002,
	1.225522e+000,
	1.738200e+000,
	-5.694060e+000,
	-1.293189e+000,
	3.689231e-001,
	-6.089362e-001,
	1.579300e-001,
	-1.525011e+000,
	-5.441954e-001,
	1.133633e+000,
	1.006755e+001,
	-2.040823e+000,
	8.661522e-001,
	-2.113994e-001,
	-1.412329e+000,
	8.753097e-001,
	-1.042371e+000,
	-2.363937e-001,
	7.521052e-001,
	2.049669e-002,
	-1.941391e+000,
	-4.961140e-001,
	3.981498e-001,
	9.201797e-001,
	6.656735e-001,
};

double datasetXYZRad2[] = 
{
	// albedo 0, turbidity 1
	9.427554e-003,
	8.058571e-003,
	7.941874e-003,
	7.152767e-002,
	3.420213e-002,
	4.486364e-002,
	// albedo 0, turbidity 2
	9.343795e-003,
	8.500973e-003,
	5.220239e-003,
	7.911633e-002,
	3.371270e-002,
	4.595605e-002,
	// albedo 0, turbidity 3
	9.223919e-003,
	8.979357e-003,
	2.266151e-003,
	8.695394e-002,
	3.307117e-002,
	4.712533e-002,
	// albedo 0, turbidity 4
	9.022225e-003,
	9.826422e-003,
	-2.734701e-003,
	9.906042e-002,
	3.211211e-002,
	4.915850e-002,
	// albedo 0, turbidity 5
	8.790138e-003,
	1.065429e-002,
	-7.647537e-003,
	1.108126e-001,
	3.142813e-002,
	5.104678e-002,
	// albedo 0, turbidity 6
	8.449344e-003,
	1.204669e-002,
	-1.569449e-002,
	1.276238e-001,
	3.143630e-002,
	5.399848e-002,
	// albedo 0, turbidity 7
	8.102946e-003,
	1.323220e-002,
	-2.319017e-002,
	1.435403e-001,
	3.189872e-002,
	5.687037e-002,
	// albedo 0, turbidity 8
	7.772349e-003,
	1.470008e-002,
	-3.103115e-002,
	1.578796e-001,
	3.281949e-002,
	6.018986e-002,
	// albedo 0, turbidity 9
	7.429019e-003,
	1.602571e-002,
	-3.840462e-002,
	1.712024e-001,
	3.422270e-002,
	6.336843e-002,
	// albedo 0, turbidity 10
	7.217988e-003,
	1.684335e-002,
	-4.272209e-002,
	1.780005e-001,
	3.647559e-002,
	6.525172e-002,
	// albedo 1, turbidity 1
	1.007930e-002,
	9.469359e-003,
	7.751882e-003,
	6.735888e-002,
	8.607559e-002,
	1.024772e-001,
	// albedo 1, turbidity 2
	9.994748e-003,
	1.000808e-002,
	4.606871e-003,
	7.572962e-002,
	8.492733e-002,
	1.050286e-001,
	// albedo 1, turbidity 3
	9.867055e-003,
	1.050709e-002,
	1.632528e-003,
	8.364781e-002,
	8.428999e-002,
	1.073660e-001,
	// albedo 1, turbidity 4
	9.657944e-003,
	1.132287e-002,
	-3.178687e-003,
	9.510100e-002,
	8.436936e-002,
	1.103412e-001,
	// albedo 1, turbidity 5
	9.423656e-003,
	1.209974e-002,
	-7.969914e-003,
	1.064676e-001,
	8.451926e-002,
	1.133836e-001,
	// albedo 1, turbidity 6
	9.102522e-003,
	1.313191e-002,
	-1.453139e-002,
	1.197732e-001,
	8.837563e-002,
	1.164319e-001,
	// albedo 1, turbidity 7
	8.758492e-003,
	1.408607e-002,
	-2.093813e-002,
	1.327661e-001,
	9.241165e-002,
	1.195703e-001,
	// albedo 1, turbidity 8
	8.449389e-003,
	1.515206e-002,
	-2.716582e-002,
	1.432571e-001,
	9.701279e-002,
	1.230409e-001,
	// albedo 1, turbidity 9
	8.119285e-003,
	1.608683e-002,
	-3.295498e-002,
	1.527686e-001,
	1.021520e-001,
	1.266069e-001,
	// albedo 1, turbidity 10
	7.942180e-003,
	1.664579e-002,
	-3.594293e-002,
	1.559130e-001,
	1.083492e-001,
	1.276285e-001,
};

double datasetXYZ3[] = 
{
	// albedo 0, turbidity 1
	-1.311888e+000,
	-4.420623e-001,
	-8.214623e+000,
	8.648177e+000,
	-3.635749e-002,
	5.335267e-001,
	1.131124e-002,
	3.149016e+000,
	4.999443e-001,
	-1.425950e+000,
	-5.484125e-001,
	-1.397730e+000,
	2.129249e+000,
	-8.008800e-002,
	5.424854e-001,
	9.998297e-003,
	2.644282e+000,
	5.135004e-001,
	-1.104356e+000,
	-1.940769e-001,
	2.507502e+000,
	-3.111118e+000,
	-1.123243e-001,
	4.371704e-001,
	-1.567242e-002,
	5.499670e+000,
	4.026340e-001,
	-1.192319e+000,
	-4.462048e-001,
	5.371843e-001,
	1.752080e+000,
	-5.827109e-001,
	1.447609e+000,
	4.110161e-002,
	-3.291197e+000,
	8.331939e-001,
	-1.005527e+000,
	-1.072900e-001,
	1.013645e+000,
	-6.226680e-001,
	7.023087e-001,
	5.090545e-001,
	-6.104120e-002,
	4.522197e+000,
	6.585009e-001,
	-1.074276e+000,
	-1.717007e-001,
	8.668669e-001,
	1.635690e-001,
	-5.004160e+000,
	1.450587e+000,
	1.000051e-001,
	3.366395e+000,
	4.999445e-001,
	// albedo 0, turbidity 2
	-1.331333e+000,
	-4.626283e-001,
	-6.305924e+000,
	6.766781e+000,
	-5.051313e-002,
	5.556381e-001,
	4.156655e-003,
	3.095492e+000,
	5.777151e-001,
	-1.575536e+000,
	-7.238005e-001,
	2.173605e-002,
	9.741010e-001,
	-1.103266e-001,
	5.139781e-001,
	1.587703e-002,
	1.459081e+000,
	2.112299e-001,
	-8.709656e-001,
	6.710823e-002,
	1.020573e+000,
	-2.360032e+000,
	-1.540314e-001,
	4.154631e-001,
	-1.385436e-002,
	7.471963e+000,
	1.182792e+000,
	-1.285011e+000,
	-5.166853e-001,
	8.665324e-001,
	1.692490e+000,
	-7.961840e-001,
	1.256981e+000,
	1.009228e-001,
	-3.544266e+000,
	2.688645e-001,
	-9.893626e-001,
	-9.370750e-002,
	7.783371e-001,
	-8.390834e-001,
	1.050487e-001,
	6.421791e-001,
	-6.671917e-002,
	4.897068e+000,
	8.901579e-001,
	-1.076705e+000,
	-1.802849e-001,
	8.245262e-001,
	3.292666e-001,
	-5.004096e+000,
	1.146985e+000,
	1.568911e-001,
	3.093827e+000,
	5.240784e-001,
	// albedo 0, turbidity 3
	-1.350265e+000,
	-4.789632e-001,
	-4.518654e+000,
	4.892352e+000,
	-6.730528e-002,
	5.459274e-001,
	6.104279e-003,
	3.152799e+000,
	5.387910e-001,
	-1.655122e+000,
	-8.206123e-001,
	6.170559e-001,
	2.808772e-001,
	-1.358176e-001,
	5.332729e-001,
	2.780488e-002,
	1.104735e+000,
	2.869065e-001,
	-7.543663e-001,
	1.668019e-001,
	2.587982e-001,
	-1.385098e+000,
	-2.965985e-001,
	1.255789e-001,
	-5.621719e-002,
	7.402862e+000,
	1.248826e+000,
	-1.305139e+000,
	-4.469096e-001,
	4.910604e-001,
	1.908400e+000,
	-4.318161e-001,
	1.569090e+000,
	1.923636e-001,
	-1.167472e+000,
	2.045414e-001,
	-9.935607e-001,
	-1.439402e-001,
	8.263513e-001,
	-2.915009e+000,
	-5.527549e+000,
	8.037532e-002,
	-7.526778e-003,
	3.769175e+000,
	8.937858e-001,
	-1.083111e+000,
	-1.916481e-001,
	7.362846e-001,
	4.367754e+000,
	-4.060770e+000,
	1.350372e+000,
	1.200770e-001,
	2.889067e+000,
	5.899180e-001,
	// albedo 0, turbidity 4
	-1.373374e+000,
	-5.100680e-001,
	-3.039093e+000,
	3.413389e+000,
	-9.466214e-002,
	4.973266e-001,
	8.466897e-003,
	3.014455e+000,
	5.101163e-001,
	-1.840141e+000,
	-9.808119e-001,
	6.416855e-001,
	1.635225e-001,
	-1.891191e-001,
	4.956113e-001,
	1.624685e-002,
	9.842522e-001,
	4.001240e-001,
	-6.544802e-001,
	1.776027e-001,
	-1.115127e-001,
	-1.815564e-001,
	-5.015203e-001,
	3.345275e-001,
	-6.851344e-002,
	6.281235e+000,
	1.105559e+000,
	-1.301369e+000,
	-3.174570e-001,
	6.940684e-002,
	-6.766562e-001,
	-2.472675e-001,
	9.532933e-001,
	2.652804e-001,
	1.382351e+000,
	3.872409e-001,
	-1.000531e+000,
	-2.370102e-001,
	8.777148e-001,
	2.465815e+000,
	-1.032874e+001,
	3.288488e-001,
	2.599159e-002,
	2.171819e+000,
	7.430662e-001,
	-1.106629e+000,
	-2.267646e-001,
	6.647827e-001,
	8.473269e-001,
	-1.995761e+000,
	9.933816e-001,
	1.593503e-001,
	2.349060e+000,
	6.768979e-001,
	// albedo 0, turbidity 5
	-1.451695e+000,
	-5.853568e-001,
	-2.498264e+000,
	2.828335e+000,
	-1.021180e-001,
	4.463749e-001,
	1.084684e-002,
	2.835571e+000,
	5.003887e-001,
	-1.883066e+000,
	-1.028171e+000,
	1.581882e+000,
	-1.304488e+000,
	-2.563745e-001,
	5.796013e-001,
	4.006731e-002,
	1.172546e+000,
	4.705877e-001,
	-8.036150e-001,
	1.421039e-002,
	-1.224287e+000,
	3.345430e+000,
	-7.822678e-002,
	-8.034004e-002,
	-1.981820e-001,
	5.281135e+000,
	1.054045e+000,
	-1.107203e+000,
	-1.301295e-001,
	4.868606e-001,
	-4.658867e+000,
	-8.327308e+000,
	1.360841e+000,
	4.849250e-001,
	2.170094e+000,
	3.667511e-001,
	-1.113339e+000,
	-3.526006e-001,
	5.749117e-001,
	9.771155e+000,
	-1.239915e+000,
	-3.274243e-001,
	-1.014052e-001,
	1.580264e+000,
	7.824541e-001,
	-1.071144e+000,
	-2.129768e-001,
	6.020160e-001,
	1.069035e-003,
	-3.513311e+000,
	1.059215e+000,
	1.897841e-001,
	2.314860e+000,
	6.921064e-001,
	// albedo 0, turbidity 6
	-1.475550e+000,
	-6.235784e-001,
	-2.739219e+000,
	3.102316e+000,
	-9.871396e-002,
	4.894712e-001,
	1.512045e-003,
	2.716438e+000,
	5.202016e-001,
	-2.100286e+000,
	-1.174158e+000,
	1.810953e+000,
	-1.623774e+000,
	-2.261133e-001,
	5.442875e-001,
	4.655874e-002,
	1.098479e+000,
	3.540358e-001,
	-5.874487e-001,
	1.046816e-001,
	-1.318062e+000,
	3.853206e+000,
	-1.574024e-001,
	-7.611052e-002,
	-2.255800e-001,
	5.023688e+000,
	1.139217e+000,
	-1.255342e+000,
	-1.702924e-001,
	1.930147e-001,
	-6.472261e+000,
	-7.280723e+000,
	1.320492e+000,
	5.794775e-001,
	2.703602e+000,
	3.045391e-001,
	-1.036406e+000,
	-3.366023e-001,
	6.357367e-001,
	1.135332e+001,
	-8.266441e-001,
	-5.135191e-001,
	-1.539050e-001,
	1.191031e+000,
	8.387967e-001,
	-1.102701e+000,
	-2.398535e-001,
	4.559688e-001,
	-2.013559e-003,
	-3.550343e+000,
	1.051510e+000,
	2.182405e-001,
	2.311132e+000,
	6.821927e-001,
	// albedo 0, turbidity 7
	-1.547031e+000,
	-6.877917e-001,
	-3.473587e+000,
	3.780188e+000,
	-7.225087e-002,
	4.498234e-001,
	-9.858722e-007,
	2.658526e+000,
	5.167507e-001,
	-2.064595e+000,
	-1.170986e+000,
	2.388138e+000,
	-2.247533e+000,
	-1.622052e-001,
	5.117292e-001,
	5.911014e-002,
	1.131937e+000,
	3.718462e-001,
	-9.685079e-001,
	-2.158542e-001,
	-1.719697e+000,
	3.990801e+000,
	-7.427683e-002,
	2.332378e-001,
	-2.661236e-001,
	4.625093e+000,
	1.104653e+000,
	-8.970945e-001,
	8.323946e-002,
	3.367617e-001,
	-6.209571e+000,
	-6.061473e+000,
	6.627023e-001,
	6.095066e-001,
	2.260073e+000,
	3.429540e-001,
	-1.198498e+000,
	-4.510515e-001,
	4.388823e-001,
	1.113762e+001,
	-1.660976e+000,
	-9.334453e-002,
	-1.097612e-001,
	1.301591e+000,
	8.116829e-001,
	-1.082711e+000,
	-2.783680e-001,
	4.468370e-001,
	6.363411e-001,
	-2.892323e+000,
	5.460732e-001,
	2.027693e-001,
	1.745605e+000,
	6.915067e-001,
	// albedo 0, turbidity 8
	-1.698899e+000,
	-8.367919e-001,
	-4.302314e+000,
	4.563539e+000,
	-4.785560e-002,
	4.111800e-001,
	-1.874868e-006,
	2.392578e+000,
	5.671278e-001,
	-2.186667e+000,
	-1.203216e+000,
	3.101762e+000,
	-3.003775e+000,
	-1.159056e-001,
	3.095751e-001,
	6.628745e-002,
	1.421465e+000,
	2.244936e-001,
	-1.432555e+000,
	-7.167314e-001,
	-2.167274e+000,
	4.075338e+000,
	6.408773e-002,
	8.131324e-001,
	-2.893191e-001,
	3.927968e+000,
	1.227801e+000,
	-5.759409e-001,
	3.350147e-001,
	5.792035e-001,
	-6.077718e+000,
	-5.495646e+000,
	-3.000352e-001,
	6.441570e-001,
	1.466788e+000,
	2.406916e-001,
	-1.311503e+000,
	-5.925982e-001,
	3.307142e-001,
	1.089626e+001,
	-1.249587e+000,
	5.174552e-001,
	-1.492856e-001,
	9.061259e-001,
	8.814459e-001,
	-1.089719e+000,
	-3.246084e-001,
	3.677823e-001,
	1.541657e+000,
	-3.032948e+000,
	4.760454e-002,
	2.299367e-001,
	1.476567e+000,
	6.684034e-001,
	// albedo 0, turbidity 9
	-2.103618e+000,
	-1.132994e+000,
	-4.590875e+000,
	4.750566e+000,
	-3.515167e-002,
	3.942989e-001,
	-2.898367e-006,
	2.183169e+000,
	6.470920e-001,
	-1.636508e+000,
	-8.262485e-001,
	3.365690e+000,
	-3.097147e+000,
	-1.333573e-001,
	2.142492e-001,
	4.660433e-002,
	1.930268e+000,
	6.372777e-002,
	-3.513446e+000,
	-2.169842e+000,
	-2.453532e+000,
	3.012257e+000,
	2.293273e-001,
	8.800788e-001,
	-2.045822e-001,
	2.988254e+000,
	1.334491e+000,
	6.299066e-001,
	9.712599e-001,
	9.122987e-001,
	-4.113695e+000,
	-5.133434e+000,
	-2.746053e-001,
	4.512841e-001,
	7.482225e-001,
	2.176656e-001,
	-1.729124e+000,
	-8.961104e-001,
	1.416097e-001,
	1.156449e+001,
	-1.713114e+000,
	9.200428e-002,
	-4.258075e-002,
	5.910965e-001,
	8.549823e-001,
	-1.002796e+000,
	-3.188077e-001,
	3.083129e-001,
	6.623051e-001,
	-2.560582e+000,
	2.459886e-001,
	2.127178e-001,
	1.224087e+000,
	6.830473e-001,
	// albedo 0, turbidity 10
	-2.774006e+000,
	-1.579782e+000,
	-3.983600e+000,
	4.085097e+000,
	-3.032315e-002,
	3.048476e-001,
	-4.148488e-006,
	1.965812e+000,
	7.195398e-001,
	-1.133820e+000,
	-7.717168e-001,
	2.805407e+000,
	-2.464148e+000,
	-1.506218e-001,
	1.790959e-001,
	4.858177e-002,
	1.824955e+000,
	-3.404481e-002,
	-6.492776e+000,
	-3.311990e+000,
	-2.236767e+000,
	1.846738e+000,
	3.120065e-001,
	6.711671e-001,
	-1.968289e-001,
	3.151885e+000,
	1.340389e+000,
	1.261591e+000,
	6.328827e-001,
	6.625715e-001,
	-2.573150e+000,
	-4.327788e+000,
	2.392943e-001,
	4.142411e-001,
	1.626791e-001,
	2.558303e-001,
	-1.635953e+000,
	-8.632853e-001,
	3.638306e-001,
	1.178910e+001,
	-2.213853e+000,
	-5.985963e-001,
	-1.411031e-001,
	-4.697450e-002,
	8.275285e-001,
	-1.036112e+000,
	-3.064725e-001,
	6.676653e-002,
	-2.658343e-003,
	-2.226863e+000,
	6.336803e-001,
	3.174833e-001,
	1.300817e+000,
	6.757297e-001,
	// albedo 1, turbidity 1
	-1.278934e+000,
	-4.266107e-001,
	-1.235449e+001,
	1.301378e+001,
	-2.286229e-002,
	5.011387e-001,
	1.252610e-002,
	2.717347e+000,
	4.999421e-001,
	-1.453838e+000,
	-5.905132e-001,
	3.010002e+000,
	-2.045614e+000,
	-5.107792e-002,
	3.025847e-001,
	2.930079e-002,
	1.721588e+000,
	4.997147e-001,
	-1.020968e+000,
	-1.655083e-001,
	2.393053e-001,
	-7.842962e-001,
	-1.093614e-001,
	7.482797e-001,
	-4.499164e-002,
	5.672841e+000,
	5.092278e-001,
	-1.157174e+000,
	-3.644371e-001,
	1.765101e+000,
	8.851871e-001,
	-4.206434e-001,
	8.388970e-001,
	7.564143e-002,
	-3.961135e+000,
	4.268443e-001,
	-1.002681e+000,
	-7.845491e-002,
	8.361537e-001,
	-4.692559e-001,
	-5.310315e-001,
	4.461649e-001,
	-6.564163e-002,
	6.116065e+000,
	7.999559e-001,
	-1.078227e+000,
	-1.728760e-001,
	1.200918e+000,
	1.804492e-001,
	-5.003140e+000,
	5.363958e-001,
	7.966617e-002,
	3.047472e+000,
	4.999439e-001,
	// albedo 1, turbidity 2
	-1.315307e+000,
	-4.637043e-001,
	-8.460782e+000,
	9.039007e+000,
	-2.854979e-002,
	4.312812e-001,
	1.962972e-002,
	2.633290e+000,
	5.353702e-001,
	-1.479455e+000,
	-6.406754e-001,
	1.726747e+000,
	-5.285200e-001,
	-7.870318e-002,
	5.230240e-001,
	-4.621225e-003,
	1.380045e+000,
	3.265295e-001,
	-9.582427e-001,
	-6.316786e-002,
	4.850994e-001,
	-1.439690e+000,
	-1.342330e-001,
	2.835928e-001,
	8.701807e-003,
	6.390283e+000,
	1.026493e+000,
	-1.165746e+000,
	-3.814278e-001,
	1.422304e+000,
	1.154808e+000,
	-6.366475e-001,
	1.159796e+000,
	7.795290e-002,
	-3.713275e+000,
	3.796947e-001,
	-1.014936e+000,
	-8.039227e-002,
	8.741110e-001,
	-5.380748e-001,
	-2.829132e-001,
	3.008224e-001,
	-5.677102e-002,
	6.161057e+000,
	8.319051e-001,
	-1.071826e+000,
	-1.735548e-001,
	1.149064e+000,
	1.867569e-001,
	-5.002087e+000,
	3.926498e-001,
	1.190023e-001,
	2.923191e+000,
	5.123194e-001,
	// albedo 1, turbidity 3
	-1.325328e+000,
	-4.754775e-001,
	-6.030560e+000,
	6.613063e+000,
	-4.269386e-002,
	4.715374e-001,
	7.358240e-003,
	2.657615e+000,
	5.593666e-001,
	-1.624180e+000,
	-8.094649e-001,
	1.735206e+000,
	-6.343355e-001,
	-9.197103e-002,
	3.486869e-001,
	4.423550e-002,
	7.200739e-001,
	2.047150e-001,
	-7.256930e-001,
	1.644973e-001,
	-1.514868e-001,
	-8.475176e-001,
	-2.033383e-001,
	5.118070e-001,
	-1.001742e-001,
	6.856190e+000,
	1.437906e+000,
	-1.326390e+000,
	-4.608617e-001,
	1.225254e+000,
	1.574815e+000,
	-4.162977e-001,
	9.049236e-001,
	2.449473e-001,
	-1.919735e+000,
	-3.623446e-002,
	-9.472798e-001,
	-8.325384e-002,
	1.014683e+000,
	-2.622519e+000,
	-3.422335e+000,
	1.797932e-001,
	-9.031335e-002,
	4.504420e+000,
	1.093961e+000,
	-1.097737e+000,
	-1.963290e-001,
	1.161926e+000,
	3.934307e+000,
	-5.006855e+000,
	5.610052e-001,
	9.326543e-002,
	2.582889e+000,
	4.999522e-001,
	// albedo 1, turbidity 4
	-1.355405e+000,
	-5.136983e-001,
	-3.702103e+000,
	4.227707e+000,
	-5.697320e-002,
	3.973961e-001,
	1.259334e-002,
	2.530478e+000,
	5.263474e-001,
	-1.746851e+000,
	-9.649533e-001,
	8.702134e-001,
	3.591285e-001,
	-1.363910e-001,
	5.205780e-001,
	2.734811e-002,
	2.767819e-001,
	3.181624e-001,
	-6.762497e-001,
	2.385826e-001,
	7.976268e-002,
	-1.129624e+000,
	-2.516586e-001,
	2.778869e-001,
	-1.092787e-001,
	6.853386e+000,
	1.277624e+000,
	-1.307943e+000,
	-4.480330e-001,
	5.995796e-001,
	1.612401e+000,
	-6.924595e-001,
	8.015640e-001,
	3.344989e-001,
	-9.589034e-001,
	1.453526e-001,
	-9.700917e-001,
	-1.197321e-001,
	1.241096e+000,
	-2.502490e+000,
	-3.753413e+000,
	1.769959e-001,
	-8.447797e-002,
	3.447177e+000,
	9.516305e-001,
	-1.091235e+000,
	-1.919335e-001,
	9.970199e-001,
	3.549449e+000,
	-4.306689e+000,
	4.962728e-001,
	1.238430e-001,
	2.758578e+000,
	6.013159e-001,
	// albedo 1, turbidity 5
	-1.392447e+000,
	-5.579332e-001,
	-2.567321e+000,
	3.088258e+000,
	-8.579040e-002,
	4.621026e-001,
	4.565959e-003,
	2.445922e+000,
	5.565956e-001,
	-1.956557e+000,
	-1.134455e+000,
	1.416415e+000,
	-4.109731e-001,
	-1.999037e-001,
	3.035066e-001,
	5.289490e-002,
	2.444984e-001,
	2.199443e-001,
	-5.536306e-001,
	2.669274e-001,
	-6.183169e-001,
	1.745223e-001,
	-1.311617e-001,
	5.290580e-001,
	-1.792890e-001,
	6.114569e+000,
	1.378717e+000,
	-1.376163e+000,
	-4.446270e-001,
	5.943493e-001,
	1.222020e+000,
	-2.809079e+000,
	4.104369e-001,
	4.456987e-001,
	-2.749475e-001,
	6.876941e-002,
	-9.221449e-001,
	-1.189414e-001,
	1.193682e+000,
	-3.876951e+000,
	-3.618624e+000,
	2.508265e-001,
	-7.996779e-002,
	3.060098e+000,
	1.001817e+000,
	-1.124365e+000,
	-2.449169e-001,
	1.067130e+000,
	7.941036e+000,
	-4.040194e+000,
	3.627627e-001,
	9.585876e-002,
	1.793268e+000,
	5.802275e-001,
	// albedo 1, turbidity 6
	-1.416356e+000,
	-5.884181e-001,
	-2.434923e+000,
	2.989620e+000,
	-9.143356e-002,
	4.306519e-001,
	-6.626430e-007,
	2.370120e+000,
	5.543846e-001,
	-2.036822e+000,
	-1.235608e+000,
	2.235972e+000,
	-1.594146e+000,
	-2.250287e-001,
	4.041790e-001,
	6.020190e-002,
	1.324026e-001,
	2.311588e-001,
	-6.100902e-001,
	2.187419e-001,
	-1.458361e+000,
	3.029719e+000,
	8.679713e-002,
	2.147092e-001,
	-2.294104e-001,
	5.602675e+000,
	1.338276e+000,
	-1.245646e+000,
	-3.217976e-001,
	8.337516e-001,
	-4.097808e+000,
	-7.336715e+000,
	7.497411e-001,
	5.383807e-001,
	7.421823e-001,
	1.409221e-001,
	-1.020851e+000,
	-2.276978e-001,
	1.089822e+000,
	7.262143e+000,
	-1.712580e+000,
	-2.187467e-001,
	-1.665151e-001,
	1.999861e+000,
	9.036180e-001,
	-1.082805e+000,
	-2.009170e-001,
	9.834561e-001,
	1.962586e+000,
	-3.968345e+000,
	5.620788e-001,
	1.501137e-001,
	2.293511e+000,
	6.539755e-001,
	// albedo 1, turbidity 7
	-1.455097e+000,
	-6.377708e-001,
	-3.056790e+000,
	3.531290e+000,
	-6.726070e-002,
	4.008309e-001,
	-7.720256e-007,
	2.336308e+000,
	5.628152e-001,
	-2.233654e+000,
	-1.384154e+000,
	2.850003e+000,
	-2.395164e+000,
	-1.519300e-001,
	3.482269e-001,
	6.872621e-002,
	1.501730e-001,
	2.173574e-001,
	-5.769213e-001,
	1.376470e-001,
	-1.834490e+000,
	4.179173e+000,
	8.998180e-002,
	5.029472e-001,
	-2.794634e-001,
	4.935213e+000,
	1.315894e+000,
	-1.254086e+000,
	-2.557369e-001,
	8.003818e-001,
	-6.221100e+000,
	-7.022007e+000,
	2.179719e-001,
	6.137258e-001,
	9.926229e-001,
	1.832485e-001,
	-9.955460e-001,
	-2.588225e-001,
	1.038675e+000,
	1.121541e+001,
	-1.790333e+000,
	2.385889e-002,
	-1.909201e-001,
	1.672978e+000,
	8.630985e-001,
	-1.110471e+000,
	-2.589342e-001,
	1.046373e+000,
	1.105839e+000,
	-3.835543e+000,
	3.726309e-001,
	1.505174e-001,
	1.451357e+000,
	6.730513e-001,
	// albedo 1, turbidity 8
	-1.635744e+000,
	-8.131883e-001,
	-4.173952e+000,
	4.643640e+000,
	-4.347971e-002,
	3.723717e-001,
	-2.050838e-006,
	2.010619e+000,
	5.933561e-001,
	-2.214302e+000,
	-1.311257e+000,
	3.795249e+000,
	-3.352616e+000,
	-1.225978e-001,
	3.357912e-001,
	5.780200e-002,
	7.000075e-001,
	1.532865e-001,
	-1.240030e+000,
	-5.251359e-001,
	-2.462401e+000,
	4.199373e+000,
	2.198326e-001,
	5.820900e-001,
	-2.528969e-001,
	3.969682e+000,
	1.323585e+000,
	-7.335051e-001,
	1.348211e-001,
	1.117508e+000,
	-5.736812e+000,
	-5.947695e+000,
	5.484914e-003,
	5.667800e-001,
	4.203315e-001,
	1.901034e-001,
	-1.218142e+000,
	-4.652876e-001,
	8.454010e-001,
	1.094323e+001,
	-1.555471e+000,
	-6.514268e-004,
	-1.486863e-001,
	1.215668e+000,
	8.730318e-001,
	-1.060175e+000,
	-2.649293e-001,
	1.050104e+000,
	3.755117e-001,
	-3.691971e+000,
	3.635470e-001,
	1.517157e-001,
	1.040222e+000,
	6.741737e-001,
	// albedo 1, turbidity 9
	-1.965171e+000,
	-1.110977e+000,
	-3.975371e+000,
	4.402380e+000,
	-3.781046e-002,
	3.442826e-001,
	-3.206313e-006,
	1.722681e+000,
	7.137791e-001,
	-2.076631e+000,
	-1.135266e+000,
	3.495989e+000,
	-2.951976e+000,
	-1.431175e-001,
	2.313894e-001,
	4.838592e-002,
	1.154473e+000,
	-5.960279e-002,
	-2.741027e+000,
	-1.710606e+000,
	-2.098317e+000,
	2.856980e+000,
	3.092012e-001,
	7.699211e-001,
	-2.114227e-001,
	3.077816e+000,
	1.467774e+000,
	8.957317e-002,
	5.539637e-001,
	8.640813e-001,
	-3.998637e+000,
	-5.613935e+000,
	-2.914646e-001,
	4.722521e-001,
	-1.125185e-001,
	1.188316e-001,
	-1.420326e+000,
	-6.360910e-001,
	9.080250e-001,
	1.138477e+001,
	-1.566010e+000,
	9.528291e-002,
	-1.176358e-001,
	5.778964e-001,
	8.949048e-001,
	-1.046287e+000,
	-3.098941e-001,
	9.483681e-001,
	5.415214e-001,
	-3.375804e+000,
	1.960618e-001,
	1.620471e-001,
	7.370266e-001,
	6.676636e-001,
	// albedo 1, turbidity 10
	-2.805422e+000,
	-1.616587e+000,
	-4.192218e+000,
	4.466438e+000,
	-2.546462e-002,
	3.308681e-001,
	-4.461434e-006,
	1.619262e+000,
	7.556575e-001,
	-1.725173e+000,
	-1.156569e+000,
	3.580993e+000,
	-2.892076e+000,
	-1.189607e-001,
	1.286486e-001,
	4.079482e-002,
	1.063847e+000,
	-6.582657e-002,
	-5.636612e+000,
	-2.816844e+000,
	-2.322376e+000,
	2.161365e+000,
	2.108298e-001,
	6.220582e-001,
	-1.804825e-001,
	3.007238e+000,
	1.307987e+000,
	9.476952e-001,
	1.996303e-001,
	6.847905e-001,
	-2.704996e+000,
	-3.436784e+000,
	2.883236e-001,
	4.180512e-001,
	1.200158e-001,
	3.259385e-001,
	-1.433266e+000,
	-6.003231e-001,
	1.164057e+000,
	1.018945e+001,
	-2.896672e+000,
	-6.514654e-001,
	-1.962561e-001,
	-1.267212e+000,
	7.789219e-001,
	-1.009612e+000,
	-1.798906e-001,
	4.963464e-001,
	-2.286995e-003,
	-2.469826e+000,
	6.499727e-001,
	3.226465e-001,
	1.912468e+000,
	6.786669e-001,
};

double datasetXYZRad3[] = 
{
	// albedo 0, turbidity 1
	6.748228e-003,
	1.245822e-002,
	-2.299497e-002,
	1.149254e-001,
	7.674022e-002,
	8.293835e-002,
	// albedo 0, turbidity 2
	6.664536e-003,
	1.290106e-002,
	-2.480392e-002,
	1.180803e-001,
	7.712743e-002,
	8.403643e-002,
	// albedo 0, turbidity 3
	6.559916e-003,
	1.325689e-002,
	-2.649347e-002,
	1.207550e-001,
	7.786707e-002,
	8.478919e-002,
	// albedo 0, turbidity 4
	6.499438e-003,
	1.353255e-002,
	-2.801609e-002,
	1.225208e-001,
	8.205891e-002,
	8.470021e-002,
	// albedo 0, turbidity 5
	6.397692e-003,
	1.376565e-002,
	-2.953498e-002,
	1.240835e-001,
	8.626065e-002,
	8.439770e-002,
	// albedo 0, turbidity 6
	6.247701e-003,
	1.446960e-002,
	-3.269905e-002,
	1.281632e-001,
	8.995242e-002,
	8.634051e-002,
	// albedo 0, turbidity 7
	6.090256e-003,
	1.497959e-002,
	-3.532743e-002,
	1.310822e-001,
	9.449566e-002,
	8.775524e-002,
	// albedo 0, turbidity 8
	5.965851e-003,
	1.535956e-002,
	-3.712273e-002,
	1.319752e-001,
	1.002717e-001,
	8.924543e-002,
	// albedo 0, turbidity 9
	5.817304e-003,
	1.562969e-002,
	-3.870089e-002,
	1.324030e-001,
	1.059721e-001,
	9.073928e-002,
	// albedo 0, turbidity 10
	5.747920e-003,
	1.576308e-002,
	-3.904300e-002,
	1.306544e-001,
	1.121448e-001,
	9.062238e-002,
	// albedo 1, turbidity 1
	7.815700e-003,
	1.183664e-002,
	-1.186281e-002,
	8.121980e-002,
	1.759349e-001,
	1.758821e-001,
	// albedo 1, turbidity 2
	7.761406e-003,
	1.209518e-002,
	-1.309164e-002,
	8.320275e-002,
	1.771012e-001,
	1.766797e-001,
	// albedo 1, turbidity 3
	7.686516e-003,
	1.228515e-002,
	-1.424823e-002,
	8.478350e-002,
	1.785574e-001,
	1.773424e-001,
	// albedo 1, turbidity 4
	7.573618e-003,
	1.252190e-002,
	-1.545068e-002,
	8.569616e-002,
	1.826553e-001,
	1.776316e-001,
	// albedo 1, turbidity 5
	7.431437e-003,
	1.271230e-002,
	-1.662223e-002,
	8.623589e-002,
	1.869661e-001,
	1.777765e-001,
	// albedo 1, turbidity 6
	7.296445e-003,
	1.303427e-002,
	-1.829775e-002,
	8.679538e-002,
	1.934616e-001,
	1.781220e-001,
	// albedo 1, turbidity 7
	7.131506e-003,
	1.322757e-002,
	-1.966949e-002,
	8.662494e-002,
	2.003751e-001,
	1.782167e-001,
	// albedo 1, turbidity 8
	6.985675e-003,
	1.329179e-002,
	-2.001190e-002,
	8.388650e-002,
	2.091531e-001,
	1.777761e-001,
	// albedo 1, turbidity 9
	6.809328e-003,
	1.332258e-002,
	-2.050411e-002,
	8.151631e-002,
	2.168861e-001,
	1.779214e-001,
	// albedo 1, turbidity 10
	6.742967e-003,
	1.344217e-002,
	-2.111739e-002,
	8.050785e-002,
	2.209232e-001,
	1.786115e-001,
};

double* datasetsXYZ[] =
{
	datasetXYZ1,
	datasetXYZ2,
	datasetXYZ3
};

double* datasetsXYZRad[] =
{
	datasetXYZRad1,
	datasetXYZRad2,
	datasetXYZRad3
};