/** @file novel_pinyin_imengine.h
 * definition of Pinyin IMEngine related classes.
 */

/* 
 * Novel Pinyin Input Method
 * 
 * Copyright (c) 2005 James Su <suzhe@tsinghua.org.cn>
 * Copyright (c) 2008 Peng Wu <alexepico@gmail.com>
 */

#if !defined (__NOVEL_PINYIN_IMENGINE_CONFIG_KEYS_H)
#define __NOVEL_PINYIN_IMENGINE_CONFIG_KEYS_H

#define NOVEL_CONFIG_IMENGINE_PINYIN_TONE                             "/IMEngine/Pinyin/Novel/Tone"
#define NOVEL_CONFIG_IMENGINE_PINYIN_INCOMPLETE                       "/IMEngine/Pinyin/Novel/Incomplete"
#define NOVEL_CONFIG_IMENGINE_PINYIN_DYNAMIC_ADJUST                   "/IMEngine/Pinyin/Novel/DynamicAdjust"
#define NOVEL_CONFIG_IMENGINE_PINYIN_DYNAMIC_SENSITIVITY              "/IMEngine/Pinyin/Novel/DynamicSensitivity"
#define NOVEL_CONFIG_IMENGINE_PINYIN_FULL_WIDTH_PUNCT_KEY             "/IMEngine/Pinyin/Novel/FullWidthPunctKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_FULL_WIDTH_LETTER_KEY            "/IMEngine/Pinyin/Novel/FullWidthLetterKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_MODE_SWITCH_KEY                  "/IMEngine/Pinyin/Novel/ModeSwitchKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_CHINESE_SWITCH_KEY               "/IMEngine/Pinyin/Novel/ChineseSwitchKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_PAGE_UP_KEY                      "/IMEngine/Pinyin/Novel/PageUpKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_PAGE_DOWN_KEY                    "/IMEngine/Pinyin/Novel/PageDownKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_DISABLE_PHRASE_KEY               "/IMEngine/Pinyin/Novel/DisablePhraseKey"
#define NOVEL_CONFIG_IMENGINE_PINYIN_MATCH_LONGER_PHRASE              "/IMEngine/Pinyin/Novel/MatchLongerPhrase"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AUTO_FILL_PREEDIT                "/IMEngine/Pinyin/Novel/AutoFillPreedit"
#define NOVEL_CONFIG_IMENGINE_PINYIN_ALWAYS_SHOW_LOOKUP               "/IMEngine/Pinyin/Novel/AlwaysShowLookup"
#define NOVEL_CONFIG_IMENGINE_PINYIN_SHOW_ALL_KEYS                    "/IMEngine/Pinyin/Novel/ShowAllKeys"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY                        "/IMEngine/Pinyin/Novel/Ambiguity"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ANY                    "/IMEngine/Pinyin/Novel/Ambiguity/Any"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ZhiZi                  "/IMEngine/Pinyin/Novel/Ambiguity/ZhiZi"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ChiCi                  "/IMEngine/Pinyin/Novel/Ambiguity/ChiCi"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ShiSi                  "/IMEngine/Pinyin/Novel/Ambiguity/ShiSi"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_NeLe                   "/IMEngine/Pinyin/Novel/Ambiguity/NeLe"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_LeRi                   "/IMEngine/Pinyin/Novel/Ambiguity/LeRi"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_FoHe                   "/IMEngine/Pinyin/Novel/Ambiguity/FoHe"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_AnAng                  "/IMEngine/Pinyin/Novel/Ambiguity/AnAng"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_EnEng                  "/IMEngine/Pinyin/Novel/Ambiguity/EnEng"
#define NOVEL_CONFIG_IMENGINE_PINYIN_AMBIGUITY_InIng                  "/IMEngine/Pinyin/Novel/Ambiguity/InIng"
#define NOVEL_CONFIG_IMENGINE_PINYIN_SAVE_PERIOD                      "/IMEngine/Pinyin/Novel/SavePeriod"
#define NOVEL_CONFIG_IMENGINE_PINYIN_SHUANG_PIN                       "/IMEngine/Pinyin/Novel/ShuangPin"
#define NOVEL_CONFIG_IMENGINE_PINYIN_SHUANG_PIN_SCHEME                "/IMEngine/Pinyin/Novel/ShuangPinScheme"
#endif
/*
vi:expandtab:ts=4:nowrap:ai
*/

