//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// デバッガのメモリアクセスヘルパー(?)
//

#pragma once

#include "debugger_defs.h"
#include "bus.h"

class IODevice;

class DebuggerMemoryStream
{
 public:
	// コンストラクタ (全部入り)
	DebuggerMemoryStream(const DebuggerMD *md_, busaddr laddr_);

	// 現在のアドレスを表示用に整形して str に代入する。
	// アドレス変換でバスエラーが起きたら false を返す。
	bool FormatAddr(std::string& str);

	// アドレスをリセットする。
	void ResetAddr(uint32 newaddr);

	// アドレスを n 進める(戻す)。
	void Offset(int n);

	// 以下 Peek*()/Read*() はいずれも読み込んだデータを返す。
	// (uint64)-1 ならアクセスの結果バスエラー。
	// (uint64)-2 ならアドレス変換でバスエラー。

	// laddr から指定バイト数を右詰めで読み込むが、アドレスは進めない。
	// 命令ワード読み込み用なので bytes は 1, 2, 4 を想定。
	uint64 Peek(int bytes);

	// laddr から指定バイト数を右詰めで読み込んで、アドレスを進める。
	// 命令ワード読み込み用なので bytes は 1, 2, 4 を想定。
	uint64 Read(int bytes);

	// laddr から1バイト読み込んで、アドレスを進める。
	uint64 Read1();

 public:
	busaddr laddr {};		// (論理)アドレス
	uint32 paddr {};		// 物理アドレス

 private:
	// アクセスするバス
	IODevice *bus {};

	int lcol;					// 論理アドレス幅の16進桁数
	int pcol;					// 物理アドレス幅の16進桁数

	bool translate {};			// アドレス変換が必要なら true
	bool pageover {};			// 256バイト境界をまたいだら true
	const DebuggerMD *md {};	// アドレス変換に必要
};
