//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// X68030 のメイン空間 ($000000-$FFFFFF) 担当
//

#pragma once

#include "mainbus.h"

class X68kIODevice : public MainbusBaseDevice
{
	using inherited = MainbusBaseDevice;
 public:
	X68kIODevice();
	~X68kIODevice() override;

	bool InitMainbus() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// ブートページを切り替える。(X68kMainbus から呼ばれる)
	void SwitchBootPage(bool isrom) override;

	// エリアセット。
	uint8 GetAreaset() const { return arealimit; }
	void SetAreaset(uint8 arealimit_);
	// 拡張エリアセット。
	uint8 GetExtarea(uint offset) const;
	void SetExtarea(uint offset, uint8 data);

 private:
	void SetUdevice(uint32 startaddr, uint32 endaddr, bool accessible);
	void AddDevice(IODevice *dev, uint devaddr, uint devlen);

	inline IODevice *Decoder(bool super, uint32 addr) const;
	inline void CheckCI(busaddr addr);

	DECLARE_MONITOR_CALLBACK(MonitorUpdate);
	DECLARE_MONITOR_CALLBACK(MonitorUpdateAreaset);

	std::unique_ptr<IODevice> pADPCM {};
	std::unique_ptr<IODevice> pAreaSet {};
	std::unique_ptr<IODevice> pBusErr {};
	std::unique_ptr<IODevice> pCGROM {};
	std::unique_ptr<IODevice> pCRTC {};
	std::unique_ptr<IODevice> pDMAC {};
	std::unique_ptr<IODevice> pExtArea {};
	std::unique_ptr<IODevice> pFDC {};
	std::unique_ptr<IODevice> pGVRAM {};
	std::unique_ptr<IODevice> pPEDEC {};
	std::unique_ptr<IODevice> pIPLROM0 {};
	std::unique_ptr<IODevice> pIPLROM1 {};
	std::unique_ptr<IODevice> pIPLROM2 {};
	std::unique_ptr<IODevice> pMainRAM {};
	std::unique_ptr<IODevice> pMFP {};
	std::unique_ptr<IODevice> pNereid {};
	std::unique_ptr<IODevice> pOPM {};
	std::unique_ptr<IODevice> pPlaneVRAM {};
	std::unique_ptr<IODevice> pPluto {};
	std::unique_ptr<IODevice> pPPI {};
	std::unique_ptr<IODevice> pPrinter {};
	std::unique_ptr<IODevice> pRTC {};
	std::unique_ptr<IODevice> pSCC {};
	std::unique_ptr<IODevice> pSRAM {};
	std::unique_ptr<IODevice> pSPC {};
	std::unique_ptr<IODevice> pSprite {};
	std::unique_ptr<IODevice> pSysport {};
	std::unique_ptr<IODevice> pVideoCtlr {};
	std::unique_ptr<IODevice> pWindrv {};

	std::array<IODevice*, 2048> udevice {};	// ユーザ空間用
	std::array<IODevice*, 2048> sdevice {};	// スーパーバイザ空間用

	uint8 arealimit {};					// エリアセット (設定値)
	std::array<uint8, 5> extarea {};	// 拡張エリアセット (設定値)

	bool cut_fc2 {};					// FC2 ピンカットなら true

	Monitor *map_monitor {};
	Monitor *area_monitor {};
};

static inline X68kIODevice *GetX68kIODevice() {
	return Object::GetObject<X68kIODevice>(OBJ_X68KIO);
}
