//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構
//

#pragma once

#include "header.h"
#include <functional>
#include <mutex>

class UIMessage
{
 public:
	// メッセージ ID
	enum ID {
		NONE = 0,

		// アプリケーションを終了する
		APPEXIT,

		// MPU がホールト状態になった
		HALT,

		// SCSI (各 ID) のメディア状態が変わった (Load/Unload)
		SCSI_MEDIA_CHANGE,

		// SCSI メディアの挿入に失敗した
		SCSI_MEDIA_FAILED,

		// FDD (各 ID) のメディア状態が変わった (Load/Unload)
		FDD_MEDIA_CHANGE,

		// FDD メディアの挿入に失敗した
		FDD_MEDIA_FAILED,

		// キー入力状態が変わった
		KEYBOARD,

		// LCD 状態が変わった
		LCD,

		// 画面を更新した
		RENDER,

		// パレットが変更になった
		PALETTE,

		// LED 状態が変わった
		LED,

		// 新しいホストドライバの起動に失敗した。
		HOSTNET_FAILED,
		HOSTCOM_FAILED,

		ID_MAX,
	};

 public:
	UIMessage();
	~UIMessage();

	// コールバックを指定して UIMessage サービスを開始。
	void StartUIMessage(const std::function<void(uint, int)>& func_);

	// UIMessage サービスを停止。
	void StopUIMessage();

	// UIMessage をポスト (コールバックを実行)。
	void Post(uint id) {
		Post(id, 0);
	}
	void Post(uint id, int arg);

 private:
	std::function<void(uint, int)> func {};
	std::mutex mtx {};
};
