//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// X680x0 SRAM.DAT エディタ
//

#pragma once

#include "header.h"
#include "mystring.h"
#include <cstdio>
#include <cstring>
#include <vector>

struct sraminfo_t {
	// このパラメータのオフセット (占有バイト数は持っていない)
	uint32 offset;
	// キー名
	const char *name;

	// 値の読み出しコールバック。
	// このパラメータの値を表示用にして返す。
	// 詳細未定。
	std::string (*reader)(const sraminfo_t&);

	// 値の書き込みコールバック。
	// このパラメータを値 input に更新する。
	// エラーなら -1、更新の必要がなければ 0、更新すれば更新件数(通常1)を返す。
	int (*writer)(const sraminfo_t&, const std::string& input);

	// ヘルプメッセージを返す。
	const std::string (*help)(const sraminfo_t&);
};

extern int debug;
extern uint8 *sram;
extern std::vector<sraminfo_t> sraminfo;
