#!/bin/sh
#
# nono
# Copyright (C) 2024 nono project
# Licensed under nono-license.txt
#

mv_if()
{
	local newfile=$1
	local targetfile=$2

	if ! cmp -s "$newfile" "$targetfile"; then
		echo $targetfile
		mv $newfile $targetfile
	fi
}

php gentable.php

cat ops_00.cpp.new \
    ops_cb.cpp.new \
    ops_dd.cpp.new \
    ops_dd_cb.cpp.new \
    ops_ed.cpp.new > ops.cpp.new
php ../util/merge_ops/merge_ops.php ops.cpp.new hd64180ops.cpp > ops.new
mv_if ops.new hd64180ops.cpp
php ../util/merge_ops/merge_ops.php ops.cpp.new hd64180disasm.cpp > dis.new
mv_if dis.new hd64180disasm.cpp

mv_if ops.h.new hd64180ops.h
mv_if switch_00.inc.new hd64180switch_00.inc
mv_if switch_cb.inc.new hd64180switch_cb.inc
mv_if switch_dd.inc.new hd64180switch_dd.inc
mv_if switch_dd_cb.inc.new hd64180switch_dd_cb.inc
mv_if switch_ed.inc.new hd64180switch_ed.inc
