<!--
 nono
 Copyright (C) 2024 nono project
 Licensed under nono-license.txt
-->
<?php require_once "common.php"; ?>
<html>
<head>
<?php
	get_version();
	print_head_common();
?>
<title>nono: runx</title>
</head>
<body>
<h3>nono: runx</h3>
<div style="text-align: right"><?php print "nono {$nono_ver} ({$nono_date})";
?></div>
<?php linkto("index", "[Back]"); ?>
<hr>

runx は NetBSD/x68k を含む NetBSD/m68k で
Human68k の実行ファイルを直接実行するアプリケーションです。
一般命令を CPU で直接実行し、DOS コール・IOCS コールなど
一部の命令だけをトラップしてソフトウェアエミュレーションしています。

<h4>ビルド方法</h4>
runx は nono のソースツリーに付属しています。
NetBSD/m68k 用のアプリケーションなので
NetBSD/m68k で以下のようにビルドします。
<blockquote><pre>
m68k% cd &lt;path/to&gt;/nono-x.x.x
m68k% cd util/runx
m68k% make
</pre></blockquote>
あるいは手元の PC に NetBSD の build.sh による m68k
のクロスビルド環境が整っていれば
それを用いて一瞬でクロスビルドすることも可能です。
<blockquote><pre>
amd64% cd &lt;path/to&gt;/nono-x.x.x
amd64% cd util/runx
amd64% make -j5 CXX="&lt;TOOLSDIR&gt;/bin/m68k--netbsdelf-g++ --sysroot=&lt;DESTDIR&gt;"
</blockquote>

<h4>使い方</h4>
<blockquote>
<tt>runx [-t][-d] <i>executable</i> [<i>arguments</i>...]</tt>
</blockquote>

<dl>
<dt><tt>-t</tt>
<dd>トレースオプションです。
DOS コール、IOCS コールおよびトラップされた命令を表示します。
<dt><tt>-d</tt>
<dd>デバッグレベルを上げます。複数回(現状2回まで)指定できます。
</dl>


<h4>サポート状況</h4>
拡張子 .X (と .R) の形式の実行ファイルをサポートしています。
<p>
Human68k 実行ファイルのうち、
ハードウェアの I/O を直接叩いているようなものは動作しません。
現状、標準入出力など簡単な DOS コール、IOCS コールのみサポートしています。


<h4>使用例</h4>

nono で NetBSD/luna68k を起動して、
<blockquote><pre>
runx XEiJ/misc/instructiontest.x all
</pre></blockquote>
を実行すると nono の 68030 CPU の整数命令が正しく
実装されているかを確認することが出来ます。
またこれを使えば、他のエミュレータであっても NetBSD/m68k が動作すれば
そのエミュレータの 68030 CPU
エミュレーションの完成度がチェック出来るかも知れません。

<hr>
nono project
</body>
</html>
