//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ログモニター
//

#pragma once

#include "wxsubwindow.h"
#include "wxscrollbar.h"
#include "wxmonitor.h"

class Logger;
class WXLogMonitor;

// モニター部分
class LogMonitor : public Object
{
	using inherited = Object;
 public:
	LogMonitor();
	~LogMonitor() override;

	void Init(WXLogMonitor *parent_);

	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	// バックログに追加
	void Append(const char *);

	// 1行追加された時の下請け処理
	void IncLines();

 private:
	WXLogMonitor *parent {};

	Logger *logger {};

	// ログ全体の行数(上限)
	const int backlog = 10000;

	// ログバッファ
	TextScreen logbuf {};

	// 今から書き込む行の logbuf でのY座標
	int cursor {};

	// UTF-8 -> CP932 変換
	wxCSConv conv { "CP932" };
};

// ログウィンドウ
class WXLogMonitor : public WXSubWindow
{
	using inherited = WXSubWindow;
	friend class LogMonitor;

 public:
	explicit WXLogMonitor(wxWindow *);
	~WXLogMonitor() override;

	void FontChanged() override;
	bool Layout() override;

 private:
	void Fit() override;

	// 最大/最小サイズ設定
	wxSize DoSizeHints();

	// マウスホイールイベント
	void OnMouseWheel(wxMouseEvent&);

	// スクロールイベント
	void OnScroll(wxScrollEvent&);

	// スクロールバー再設定
	void SetScroll();

	// スクロール処理
	void DoScroll(int pos);

	WXMonitorPanel *screen {};

	// スクロールバー
	WXScrollBar *vscroll {};

	int col {};
	int row {};

	// 表示開始位置
	// パネル最下行に表示する行を、最新行からのオフセットで表す。
	// 0 ならパネル最下行は最新行、1 なら一つ手前の行…となる。
	int vpos {};

	// 現在のログ行数
	int lines {};

	// モニター
	std::unique_ptr<Monitor> monitor /*{}*/;
	LogMonitor log {};

	// 前回のウィンドウマージン (クライアント領域の外側)
	wxSize oldmargin {};

	// 謎のリサイズ対策
	bool layout_pass2 {};
};
